/*
 * kbiffurl.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 * Copyright (C) 1999 Bjorn Hansson <Bjorn.Hansson@signal.uu.se>
 *
 * $Id: kbiffurl.h,v 1.2 2001/03/24 18:50:21 gran Exp $
 *
 */
#ifndef KBIFFURL_H
#define KBIFFURL_H

#include <kurl.h>

/**
 * This is a simple extension to the KURL class.
 */
class KBiffURL : public KURL
{
public:
	/**
	 * Default constructor
	 */
	KBiffURL();

	/**
	 * Construct a KBiffURL object from _url
	 */
	KBiffURL(const QString& _url);

	/**
	 * Returns the parameter value found in the search part of the URL
	 */
	QString searchPar( const QString & _parName ) const;

	/**
	 * Sets a parameter value in the search part of the URL
	 */
	void setSearchPar( const QString & _parName, const QString & _newParVal );

	QString pass() const;

private:
	/**
	 * Returns the position of a parameter within the search part
	 */
	int findPos( const QString & _searchPart, const QString & _parName ) const;
};
#endif // KBIFFURL_H
