/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYDBLP_H
#define KBIBTEXWEBQUERYDBLP_H

#include <webquery.h>

namespace KBibTeX
{

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryWizardDBLP: public WebQueryWizard
    {
        Q_OBJECT
    public:
        WebQueryWizardDBLP( const QString& caption, QWidget* parent, const char* name = 0 );
        ~WebQueryWizardDBLP();

    protected slots:
        void startSearch();

    };

    class WebQueryDBLP : public WebQuery
    {
    public:
        WebQueryDBLP( QWidget* parent, const char* name = 0 );
        ~WebQueryDBLP();

        BibTeX::File* query( );

        int uniqueId();
        QString title();

    private:
        WebQueryWizardDBLP *m_wizard;

    };

}

#endif
