//
// C++ Interface: replacestringdlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef REPLACESTRINGDLG_H
#define REPLACESTRINGDLG_H

#include <kdialogbase.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <qgroupbox.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h> 
#include <qradiobutton.h>


/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class ReplaceStringDlg : public KDialogBase
{
Q_OBJECT
public:
    ReplaceStringDlg(bool selected, QWidget *parent = 0, const char *name = 0);
	QString fieldName() { return (m_field->currentText()).simplifyWhiteSpace().lower(); }
	QString oldString() { return (m_oldString->text()) ; }
	QString newString() { return (m_newString->text()) ; }
	bool isAllReferences() { if (m_allEntrySelect->isChecked() ) return true; else return false; }
	bool isAllField() { if (m_allFieldSelect->isChecked() ) return true; else return false; }
	
    ~ReplaceStringDlg();
private slots:
	void slotField(const QString &);	
	
private:
	KComboBox *m_field;
	KLineEdit *m_oldString;
	KLineEdit *m_newString;
	
	QVGroupBox *m_fieldOptionGroup;
	QButtonGroup *m_fieldButtonGroup;
	QRadioButton *m_allFieldSelect;
	QRadioButton *m_fieldSelect;
	
	QVGroupBox *m_entryOptionGroup;
	QButtonGroup *m_entryButtonGroup;
	QRadioButton *m_allEntrySelect;
	QRadioButton *m_selectedEntrySelect;
		
};


#endif
