//
// C++ Implementation: queryresultdlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "queryresultdlg.h"

#include <klocale.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qlabel.h>

queryResultDlg::queryResultDlg(unsigned int num, QWidget *parent, const char *name):KDialogBase( parent, name , true, "Search result", KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false ){
	QWidget* mainWidget = new QWidget(this, "Query result");
	setMainWidget(mainWidget);
	QVBoxLayout* l = new QVBoxLayout(mainWidget, 0, KDialog::spacingHint());
	QLabel *lb1 = new QLabel(QString(i18n("Found %1 references")).arg(num), mainWidget);
	l->addWidget(lb1);
	
	QHBox* box1 = new QHBox(mainWidget);
	box1->setMargin(4);
	box1->setSpacing(4);
	
	QLabel *lb2 = new QLabel (QString(i18n("Retrieve reference from ")), box1);
	min= new QSpinBox (1, num, 1, box1);
	min->setValue(1);
	
	QLabel *lb3 = new QLabel (QString(i18n(" to ")), box1);
	max = new QSpinBox (1, num, 1, box1);
	if (num >= 20)
		max->setValue(20);
	else
		max->setValue(num);
	l->addWidget(box1);
	
	connect(min, SIGNAL( valueChanged(int)), this, SLOT(slotMinValueChanged(int)) );
	connect(max, SIGNAL( valueChanged(int)), this, SLOT(slotMaxValueChanged(int)) );
}


queryResultDlg::~queryResultDlg()
{
}


void queryResultDlg::slotMinValueChanged(int n){
	if (max->value() < n)
		max->setValue(n);
	max-> setMinValue(n);
}	
	

void queryResultDlg::slotMaxValueChanged(int n){
	if (min->value() > n)
		min->setValue(n);
	min-> setMaxValue(n);	
}


#include "queryresultdlg.moc"
