//
// C++ Interface: kbibstringmacrodlg
//
// Description:
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KBIBSTRINGMACRODLG_H
#define KBIBSTRINGMACRODLG_H

class KLineEdit;
class QListView;
class QListViewItem;

#include <kdialogbase.h>
#include <qobject.h>
#include <qmap.h>
#include "bibentrytable.h"

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class KbibStringMacroDlg : public KDialogBase
{
    Q_OBJECT
public:
	KbibStringMacroDlg(BibentryTable *list, QMap<QString, QString> globalMap, QWidget* parent=0, const char* name=0, bool modal=false);

    ~KbibStringMacroDlg();
	QMap<QString, QString> getStringMacroList(); 

public slots:
    void slotAdd();
    void slotDelete();
    void slotClicked(QListViewItem* item);
    void slotGlobal();

private:
    void addNewString(QString ID, QString text);

	QMap<QString, QString> globalMap; 
	KListView* m_listView;
    KLineEdit* m_editID;
    KLineEdit* m_editValue;
};


class GlobalStringMacroDlg : public KDialogBase
{
	Q_OBJECT
	public:
		GlobalStringMacroDlg(QMap<QString, QString>& map_, QWidget* parent=0, const char* name=0, bool modal=false);

		~GlobalStringMacroDlg();
		QMap<QString, QString> getMacros();
	private:
		KListView* m_listView;
};

#endif
