/***************************************************************************
                          kbibinsertfiledlg  -  description
                             -------------------
    begin                : Tue Apr 13 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KBIBINSERTFILEDLG_H
#define KBIBINSERTFILEDLG_H

#include <kdialogbase.h>

#include <kurlrequester.h>
#include <kpushbutton.h>

#include <qlabel.h>
#include <kcombobox.h> 
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h> 
#include <qradiobutton.h>

/**
@author Thach Nguyen
*/
class KbibInsertFileDlg : public KDialogBase
{
Q_OBJECT
public:
    KbibInsertFileDlg(QWidget *parent = 0, const char *name = 0);

    ~KbibInsertFileDlg();
    
    QString getFileName();
    int getFileType();
    bool getNotInsertExisting();
	bool importIntoNewDoc() { return (m_importNewFile->isChecked() ) ; }
    
private:
	KURLRequester *m_requester;
	KComboBox  *fileType;
	QCheckBox *noImportExisting;
	
	QVGroupBox *m_optionBox;
	QButtonGroup *m_buttonGroup;
	QRadioButton *m_importNewFile;
	QRadioButton *m_importIntoExisting;

public slots:
    void slotURLChanged(const QString& );
};

#endif
