/***************************************************************************
                          kbibconfigdlg  -  description
                             -------------------
    begin                : Tue Apr 13 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KBIBCONFIGDLG_H
#define KBIBCONFIGDLG_H

#include <kfontdialog.h>
#include <kdialogbase.h>
#include <klistbox.h>
#include <kbuttonbox.h>

#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qvbuttongroup.h>
#include "kbib.h"
#include "searcher.h"

/**
@author Thach Nguyen
*/


class searcher;

class KBibConfigDlg : public KDialogBase
{
        Q_OBJECT

public:
        KBibConfigDlg( QWidget *parent=0, char *name=0, bool modal=true );
        ~KBibConfigDlg( void );

        //void setState( const DefStruct &state );
        configState state( void );
        void setState(const configState &st);

protected slots:
        virtual void slotOk( void );
        virtual void slotApply( void );
        virtual void slotCancel( void );
        virtual void slotDefault( void );
		
        void slotFieldLeft(void);
        void slotFieldRight(void);
        void slotFieldUp(void);
        void slotFieldDown(void);
		void slotNewSourceClicked();
		void slotModifySourceClicked();
		void slotRemoveSourceClicked();
		void slotMoveSourceUpClicked();
		void slotMoveSourceDownClicked();
		void slotPresetSourceClicked();
		void slotSourceListSelectionChanged();
		void slotStringMacroClicked(QListViewItem* item_);
		void slotAddStringMacro();
		void slotDeleteStringMacro();
		void slotImportStringMacro();

private:
        void setupGeneralPage(void);
        void setupFontPage( void );
        void setupToolPage( void );
        void setuptDisplayPage( void );
		void setupDataSourcePage(void);
		void setupStringMacroPage(void);

private:
	void readDataSourceConfig(void);
	void addNewStringMacro(QString ID, QString text);
	
		QLineEdit *keyConnectingEdit;
		QCheckBox *askReqField;
		QCheckBox *autocompletion;
        QRadioButton *newFile;
        QRadioButton *openFile;
        QRadioButton *askUser;
        QVButtonGroup *buttonGroup;

        QRadioButton *cite2Kile;
		QRadioButton *cite2Lyx;
        QRadioButton *cite2Clipboard;
//        QRadioButton *cite2LyxnClipboard;
        QVButtonGroup *citeActionGroup;
		QComboBox * fieldDelimiter;

		QRadioButton *compareRequired;
		QRadioButton *compareOptional;
		QRadioButton *compareAll;
		QVButtonGroup *entryCompare;
		
//		KLineEdit *crossRefUser;
//		KLineEdit *crossRefPassword;
		
		QRadioButton *firstAuthorSelect;
		QRadioButton *twoAuthorSelect;
		QRadioButton *allAuthorSelect;
		QVButtonGroup *authorsDisplay;
		
//		QComboBox *encoding;
		
        QComboBox * textViewer;
        QComboBox * browser;
        KFontChooser *mFontChooser;
		
        KListBox *availableFields;
        KListBox *selectedFields;

		
		KListView* m_sourceListView;
		KPushButton* m_modifySourceBtn;
		KPushButton* m_removeSourceBtn;
		KPushButton* m_moveSourceUpBtn;
		KPushButton* m_moveSourceDownBtn;
		KPushButton* m_presetSourceBtn;
		
		KListView* m_stringMacroListView;
		KLineEdit* m_stringMacroEditID;
		KLineEdit* m_stringMacroEditValue;
		
        configState    mState;
	
	bool displayStateChange;

signals:
        void valueChanged( const configState &state );
};


class SourceListViewItem : public KListViewItem {
	public:
		SourceListViewItem(KListView* parent, QListViewItem* after,searcher *s);
		~SourceListViewItem();
		void setConfigGroup(const QString& s) { m_configGroup = s; }
		const QString& configGroup() const { return m_configGroup; }
		void setNewSource(bool b) { m_newSource = b; }
		bool isNewSource() const { return m_newSource; }
		void setSearcher(searcher *s);
		const Type searcherType() const { return m_searcher->type(); }
		searcher* getSearcher() const { return m_searcher; }

	private:
		QString m_configGroup;
		bool m_newSource : 1;
		searcher* m_searcher;
};


#endif
