/***************************************************************************
                          bibentry.h  -  description
                             -------------------
    begin                : Sat May 24 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BIBENTRY_H
#define BIBENTRY_H


#include "bibentrydeftable.h"
#include <qstring.h>
#include <qmap.h>

/**
  *@author Thach Nguyen
  */

class BibEntry
{
public:

    ///
    BibEntry();
    ///
    BibEntry(const QString entrytype, const QString key);
    /// Copy constructor
    BibEntry(BibEntry&);
    ///
    ~BibEntry();

    QString getEntryType() const;
    QString getKey() const;
    QString getFieldName(int) const;

    QString getField(int) const;
    QString getField(const QString) const ;

    QString getReqField(int) const;
    QString getOptField(int) const;
    QString getExtField(int) const;

    int getNoFields() const
    {
        return (!def) ? 1:  def->numRequired() + def->numOptional() + nextra;
    }

    int getNoReqFields() const
    {
        return (!def) ? 1: def->numRequired();
    }

    int getNoOptFields() const
    {
        return (!def) ? 0: def->numOptional();
    }

    int getNoExtraFields() const
    {
        return nextra;
    }

    void setEntryType(QString);

    void setKey(QString k) { key = k; }

    void setField(int, QString);

    void setField(QString fieldName, QString);

    void setFields(BibEntry &);

	void clearExtraField(void ) { extra_field.clear(); nextra = 0; extra_field_string_macro.clear();  }

    BibEntry& operator=(BibEntry &);

    int createKey(QString connectingString=QString::fromLatin1(""));
    int getIndex();
    void setIndex(int);

    void allowExtraField() { allow_extra = true; }

    bool stringMacroIndicator(int fieldIdx) { return asStringMacro[fieldIdx]; }
    bool stringMacroIndicator(QString fieldName);
    void setStringMacroIndicator(int idx, bool s) { asStringMacro[idx] = s; }
    void setStringMacroIndicator(QString fieldName, bool s);
	
	bool replaceString(bool allField, QString field, QString oldString, QString newString);
protected:
    QString key;
    QString *req_field;
    QString *opt_field;
    BibEntryDef *def;
    int nextra;
	QMap<QString, QString> extra_field;
	QMap<QString, bool>extra_field_string_macro;
//	slist_pair_bool extra_field_string_macro;
//    bool special;
//	bool preamble;
//    bool stringMacro;
    bool *asStringMacro;
    bool allow_extra;
    //    friend class BibentryTable;
private: // Private attributes
    int index;
};


int compareBibEntry(BibEntry *e1, BibEntry *e2, int fields=0, bool compare_key = false, bool compare_lockkey = false);
void processAuthor(QString st, QString &surname, QString &givenname);
QString reformatAuthors(QString st, int numAuthorsDisplayed=0);
QString entryToString(BibEntry *entry, int fieldDelimiter = 0);

#endif
