//
// C++ Interface: fieldtextedit
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIFIELDTEXTEDIT_H
#define GUIFIELDTEXTEDIT_H

#include <ktextedit.h>
#include <kcompletion.h>
#include <kcompletionbox.h>

namespace GUI {

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class FieldTextEdit : public KTextEdit, public KCompletionBase
{
Q_OBJECT
public:
    FieldTextEdit(QWidget *parent = 0, const char *name = 0);

    ~FieldTextEdit();

	virtual void  setCompletedText (const QString &text);	
	virtual void setCompletedItems( const QStringList& items );
	
	protected slots:
		void makeCompletion( const QString& text ) ;
		void completionSelect(const QString& text);
		void setTextWorkaround( const QString& );
		void userCancelled( const QString& );
	
	protected:
		virtual void keyPressEvent ( QKeyEvent * e );
		
private:
	KCompletionBox * getCompletionBox( bool create = true );
	KCompletionBox *completionBox;	
	
};

}

#endif
