import node
import parsemaxima
import nodesubclasses

import logging
l = logging.getLogger(__name__)

class DrawObject:
    drawobjects = {}
    nextIndex = 0
    
    def __init__(self):
        self.drawobjecttype = ""
        self.node = ""
        self.text = ""
        self.textOnly = False
        self.rowNo = None
        self.pixmap = None

    @staticmethod
    def addDrawObject(do):
        do.index = DrawObject.nextIndex
        l.debug("add object of index %s" % do.index)
        DrawObject.drawobjects[DrawObject.nextIndex] = do
        DrawObject.nextIndex += 1
        l.debug("next index %s" % DrawObject.nextIndex)

class Equation(DrawObject):
    def __init__(self,text, dontAddToDrawObjects=False):
        DrawObject.__init__(self)
        l.debug("add equation of text " + text)
        self.drawobjecttype = "equation"
        self.text = text
        try:
            self.node = parsemaxima.parseString(text)
            self.node.setChildParent()
            self.node.postParse()
            self.h = self.node.h
            self.w = self.node.w
            self.operatorcentreline = self.node.operatorcentreline
        except:
            l.exception("parsing %s" % text)
            self.textOnly = True
        if not dontAddToDrawObjects:
            DrawObject.addDrawObject(self)

class Text(DrawObject):
    def __init__(self,text):
        DrawObject.__init__(self)
        self.drawobjecttype = "text"
        self.text = text
        self.textOnly = True
        DrawObject.addDrawObject(self)

class Graph(DrawObject):
    def __init__(self,pixmap, pixthumb):
        DrawObject.__init__(self)
        self.drawobjecttype = "graph"
        self.pixmap = pixmap
        self.pixthumb = pixthumb
        self.node = node.Node()
        self.node.operator = 'pix'
        self.node.term1 = pixmap
        self.node.term2 = pixthumb
        self.node.h = pixthumb.height()
        self.node.w = pixthumb.width()
        self.node.operatorcentreline = self.node.h/2.0
        self.h = self.node.h
        self.w = self.node.w
        self.operatorcentreline = self.node.operatorcentreline
        self.addDrawObject(self)


plots = {}
# (equationDrawObject, allVars, options)
currentPlotIndex = 0
