/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Laurent Montel : montel@kde.org                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <qstring.h>
#include <kglobal.h>
#include <klocale.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include <kiconloader.h>
#include <kaboutdata.h>
#include "katutils.h"

// Utility functions
void addSeparators( QString& s )
{
    QString thousandsSeparator = KGlobal::locale()->thousandsSeparator();
    int i = s.length()-1;
    for( int j=1; i>0; i--, j++ )
        if ( j%3 == 0 )
            s.insert( i, thousandsSeparator );
}

#ifdef __GNUC__
#warning "Remove katConvertSeconds when we will use kde >= 3.4 it's a duplicate code from klocale => not easy to keep sync"
#endif

QString katConvertSeconds( unsigned int seconds )
{
    unsigned int days  = seconds / 86400;
    unsigned int hours = (seconds - (days * 86400)) / 3600;
    unsigned int mins  = (seconds - (days * 86400) - (hours * 3600)) / 60;
    seconds = (seconds - (days * 86400) - (hours * 3600) - (mins * 60));

    const QTime time(hours, mins, seconds);
    const QString timeStr( KGlobal::locale()->formatTime(time, true /*with seconds*/, true /*duration*/) );
    if ( days > 0 )
        return i18n( "1 day %1", "%n days %1", days ).arg( timeStr );
    else
        return timeStr;
}

QPixmap loadMenuIconEnabled( const QString &imagename )
{
    return KGlobal::iconLoader()->loadIcon( imagename, KIcon::Small, 16, KIcon::DefaultState );
}

QPixmap loadToolbarIconEnabled( const QString &imagename )
{
    return KGlobal::iconLoader()->loadIcon( imagename, KIcon::Toolbar, 22, KIcon::DefaultState );
}

QPixmap loadToolbarIconDisabled( const QString &imagename )
{
    return KGlobal::iconLoader()->loadIcon( imagename, KIcon::Toolbar, 22, KIcon::DisabledState );
}

QPixmap loadLargeIconEnabled( const QString &imagename )
{
    return KGlobal::iconLoader()->loadIcon( imagename, KIcon::Toolbar, 32, KIcon::DefaultState );
}

QIconSet createToolbarIconSet( const QString &imagename )
{
    QIconSet isIconSet;

    isIconSet.setPixmap( loadToolbarIconEnabled( imagename ),
        QIconSet::Automatic, QIconSet::Normal );
    isIconSet.setPixmap( loadToolbarIconDisabled( imagename ),
        QIconSet::Automatic, QIconSet::Disabled );
    return isIconSet;
}

static const char description[] = I18N_NOOP( "KAT - Desktop Search Environment" );
static const char version[] = "0.6.3";

KAboutData katAboutData()
{
    KAboutData about(
                      "kat",
                      I18N_NOOP( "Kat" ),
                      version, description,
                      KAboutData::License_GPL_V2,
                      I18N_NOOP( "(C) 2005 Roberto Cappuccio and the KAT team" ),
                      I18N_NOOP( "A desktop search environment for KDE" ),
                      "http://kat.sourceforge.net",
                      "kat.development@lists.sourceforge.net"
                     );
    about.addAuthor( "Roberto Cappuccio", I18N_NOOP("Lead developer"), "roberto.cappuccio@gmail.com" );
    about.addAuthor( "Laurent Montel", I18N_NOOP("Developer"), "montel@kde.org" );
    about.addAuthor( "Praveen Kandikuppa", I18N_NOOP("Developer"), "praveen9@gmail.com" );
    about.addAuthor( "Fred Schaettgen", I18N_NOOP("Developer"), "kde.sch@ttgen.net" );
    about.addCredit( "Cavnar, W. B. and J. M. Trenkle", I18N_NOOP("N-Gram-Based Text Categorization\n"
                     "Third Annual Symposium on Document Analysis and Information Retrieval\n"
                     "Las Vegas, 11-13 April 1994\n"
                     "(Kat's language identification feature is based on this paper)") );
    about.setTranslator( I18N_NOOP( "_: NAME OF TRANSLATORS\\nYour names" ) ,
                         I18N_NOOP( "_: EMAIL OF TRANSLATORS\\nYour emails" ) );
    return about;
}
