/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include "dlgnewcatalog.h"

#include <katengine.h>
#include <katfulltextjob.h>
#include <katpreviewjob.h>

#include <qvariant.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <kactionselector.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kio/global.h>
#include <kio/jobclasses.h>
#include <kio/previewjob.h>
#include <kio/metainfojob.h>
#include <kurlrequester.h>
#include <klocale.h>
#include <klineedit.h>

DlgNewCatalog::DlgNewCatalog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : KDialogBase( parent, name, modal, i18n( "New Catalog" ),
        KDialogBase::Ok|KDialogBase::Cancel|KDialogBase::Help, KDialogBase::Ok, true )
{
    setSizeGripEnabled( false );
    QWidget *page = new QWidget( this );
    setMainWidget(page);
    QVBoxLayout *DlgNewCatalogLayout = new QVBoxLayout( page, 11, 6, "DlgNewCatalogLayout" );

    tabWidget = new QTabWidget( page, "tabWidget" );

    QWidget *Widget8 = new QWidget( tabWidget, "Widget8" );
    QGridLayout *gridlayout = new QGridLayout( Widget8, 10, 2, KDialog::marginHint(),
        KDialog::spacingHint() );

    tlCatalogName = new QLabel( Widget8, "tlCatalogName" );
    tlCatalogName->setText( i18n( "Catalog name:" ) );
    gridlayout->addWidget( tlCatalogName, 0, 0 );

    leCatalogName = new QLineEdit( Widget8, "leCatalogName" );
    gridlayout->addWidget( leCatalogName, 0, 1 );

    tlBaseFolder = new QLabel( Widget8, "tlBaseFolder" );
    gridlayout->addWidget( tlBaseFolder, 1, 0 );
    tlBaseFolder->setText( i18n( "Base folder:" ) );

    leBaseFolder = new KURLRequester( Widget8, "leBaseFolder" );
    gridlayout->addWidget( leBaseFolder, 1, 1 );
    leBaseFolder->setMode( KFile::Directory );

    tlDescription = new QLabel( Widget8, "tlDescription" );
    gridlayout->addWidget( tlDescription, 2, 0 );
    tlDescription->setText( i18n( "Description:" ) );

    teDescription = new QTextEdit( Widget8, "teDescription" );
    gridlayout->addMultiCellWidget( teDescription, 2,4,1, 1 );
    teDescription->setTabChangesFocus(true);

    tlAuthor = new QLabel( Widget8, "tlAuthor" );
    gridlayout->addWidget( tlAuthor, 5, 0 );
    tlAuthor->setText( i18n( "Author:" ) );

    leAuthor = new QLineEdit( Widget8, "leAuthor" );
    gridlayout->addWidget( leAuthor, 5, 1 );

    tlNotes = new QLabel( Widget8, "tlNotes" );
    gridlayout->addWidget( tlNotes, 6, 0 );
    tlNotes->setText( i18n( "Notes:" ) );

    teNotes = new QTextEdit( Widget8, "teNotes" );
    gridlayout->addMultiCellWidget( teNotes, 6,8,1, 1 );
    teNotes->setTabChangesFocus( true );
    tabWidget->insertTab( Widget8, i18n( "Catalog" ) );

    tlAutoUpdate = new QLabel( Widget8, "tlAutoUpdate" );
    gridlayout->addWidget( tlAutoUpdate, 9, 0 );
    tlAutoUpdate->setText( i18n( "Auto update" ) );

    cbAutoUpdate = new QCheckBox( Widget8, "cbAutoUpdate" );
    gridlayout->addWidget( cbAutoUpdate, 9, 1 );

    QWidget *qwMimeTypes = new QWidget( tabWidget, "qwMimeTypes" );
    QVBoxLayout *layout = new QVBoxLayout( qwMimeTypes, KDialog::marginHint(),
        KDialog::spacingHint(), "layout" );
    asMimeTypes = new KActionSelector( qwMimeTypes, "asMimeTypes" );
    asMimeTypes->setAvailableLabel( i18n( "&Available:" ) );
    asMimeTypes->setSelectedLabel( i18n( "&Selected:" ) );
    layout->addWidget( asMimeTypes );

    QListBox* lbSelectedMimeTypes = asMimeTypes->selectedListBox();

    QStringList availableMimeTypes = KIO::MetaInfoJob::supportedMimeTypes();
    for ( QStringList::Iterator it = availableMimeTypes.begin();
            it != availableMimeTypes.end(); ++it )
        lbSelectedMimeTypes->insertItem( *it );
    availableMimeTypes = KatPreviewJob::supportedMimeTypes();
    for ( QStringList::Iterator it = availableMimeTypes.begin();
            it != availableMimeTypes.end(); ++it )
        if ( !lbSelectedMimeTypes->findItem( *it ) )
            lbSelectedMimeTypes->insertItem( *it );
    availableMimeTypes = KatFullTextJob::supportedMimeTypes();
    for ( QStringList::Iterator it = availableMimeTypes.begin();
            it != availableMimeTypes.end(); ++it )
        if ( !lbSelectedMimeTypes->findItem( *it ) )
            lbSelectedMimeTypes->insertItem( *it );
    lbSelectedMimeTypes->sort();

    tabWidget->insertTab( qwMimeTypes, i18n( "Mime Types" ) );

    QWidget *Widget9 = new QWidget( tabWidget, "Widget9" );
    layout = new QVBoxLayout( Widget9, KDialog::marginHint(),
        KDialog::spacingHint(), "layout" );
    asDescriptionPlugins = new KActionSelector( Widget9, "asDescriptionPlugins" );
    asDescriptionPlugins->setAvailableLabel( i18n( "&Available:" ) );
    asDescriptionPlugins->setSelectedLabel( i18n( "&Selected:" ) );
    layout->addWidget( asDescriptionPlugins );

    QListBox* lbSelectedDescriptionPlugins = asDescriptionPlugins->selectedListBox();

    QStringList availableMetaInfoPlugins = KIO::MetaInfoJob::availablePlugins();
    for ( QStringList::Iterator it = availableMetaInfoPlugins.begin();
            it != availableMetaInfoPlugins.end(); ++it )
        lbSelectedDescriptionPlugins->insertItem( (*it).right( (*it).length() - 6 ) );
    lbSelectedDescriptionPlugins->sort();

    tabWidget->insertTab( Widget9, i18n( "Metadata" ) );

    TabPage = new QWidget( tabWidget, "TabPage" );
    layout = new QVBoxLayout( TabPage, KDialog::marginHint(),
        KDialog::spacingHint(), "layout" );

    asFullTextPlugins = new KActionSelector( TabPage, "asFullTextPlugins" );
    asFullTextPlugins->setAvailableLabel( i18n( "&Available:" ) );
    asFullTextPlugins->setSelectedLabel( i18n( "&Selected:" ) );
    layout->addWidget( asFullTextPlugins );

    QListBox* lbSelectedFullTextPlugins = asFullTextPlugins->selectedListBox();

    QStringList availableFullTextPlugins = KatFullTextJob::availablePlugins();
    for ( QStringList::Iterator it = availableFullTextPlugins.begin();
            it != availableFullTextPlugins.end(); ++it )
        lbSelectedFullTextPlugins->insertItem( (*it).lower().left( (*it).length() - 6 ) ); //display name
    lbSelectedFullTextPlugins->sort();

    QHBoxLayout *box = new QHBoxLayout;
    cbUseExclusionList = new QCheckBox( TabPage, "cbUseExclusionList" );
    cbUseExclusionList->setText( i18n( "Use exclusion list" ) );
    box->addWidget( cbUseExclusionList );

    bManageExclusionList = new QPushButton( TabPage, "bManageExclusionList" );
    bManageExclusionList->setText( i18n( "Manage Exclusion List" ) );
    tabWidget->insertTab( TabPage, i18n( "Fulltext" ) );
    box->addWidget( bManageExclusionList );

    layout->addLayout( box );

    QWidget *TabPage_2 = new QWidget( tabWidget, "TabPage_2" );
    layout = new QVBoxLayout( TabPage_2, KDialog::marginHint(), KDialog::spacingHint(), "layout_2" );

    asThumbnailPlugins = new KActionSelector( TabPage_2, "asThumbnailPlugins" );
    asThumbnailPlugins->setAvailableLabel( i18n( "&Available:" ) );
    asThumbnailPlugins->setSelectedLabel( i18n( "&Selected:" ) );
    layout->addWidget( asThumbnailPlugins );

    QListBox* lbSelectedThumbnailPlugins = asThumbnailPlugins->selectedListBox();

    QStringList availableThumbnailPlugins = KatPreviewJob::availablePlugins();
    for ( QStringList::Iterator it = availableThumbnailPlugins.begin();
            it != availableThumbnailPlugins.end(); ++it )
        lbSelectedThumbnailPlugins->insertItem( (*it).left( (*it).length() - 9 )  );
    lbSelectedThumbnailPlugins->sort();

    box = new QHBoxLayout;

    tlThumbnailSize = new QLabel( TabPage_2, "tlThumbnailSize" );
    box->addWidget( tlThumbnailSize );

    slThumbnailSize = new QSlider( TabPage_2, "slThumbnailSize" );
    slThumbnailSize->setMinValue( 48 );
    slThumbnailSize->setMaxValue( 160 );
    slThumbnailSize->setLineStep( 1 );
    slThumbnailSize->setPageStep( 8 );
    slThumbnailSize->setOrientation( QSlider::Horizontal );
    slThumbnailSize->setTickmarks( QSlider::Below );
    slThumbnailSize->setTickInterval( 8 );
    tlThumbnailSize->setText( i18n( "Thumbnail size:" ) );
    QToolTip::add( slThumbnailSize, i18n( "Thumbnail size" ) );
    box->addWidget( slThumbnailSize );

    tlSize = new QLabel( TabPage_2, "tlSize" );
    tlSize->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    tlSize->setText( "48x48" );
    tlSize->setMinimumWidth( 60 );
    box->addWidget( tlSize );

    layout->addLayout( box );
    tabWidget->insertTab( TabPage_2, i18n( "Thumbnails" ) );
    DlgNewCatalogLayout->addWidget( tabWidget );

    resize( QSize( 560, 520 ).expandedTo( minimumSizeHint() ) );
    clearWState( WState_Polished );
    connect( bManageExclusionList, SIGNAL( clicked() ),
             this, SLOT( slotManageExclusionList() ) );
    connect( cbUseExclusionList, SIGNAL( stateChanged(int) ),
             this, SLOT( slotUseExclusionList(int) ) );
    connect( slThumbnailSize, SIGNAL( valueChanged(int) ),
             this, SLOT( slotThumbnailSizeValueChanged(int) ) );
    connect( leCatalogName, SIGNAL( textChanged(const QString&) ),
             this, SLOT( slotChangedCatalogname() ) );
    connect( leBaseFolder->lineEdit(), SIGNAL( textChanged(const QString&) ),
             this, SLOT( slotChangedBaseFolder() ) );

    leCatalogName->setFocus();
    enableButton( KDialogBase::Help, false);
}

DlgNewCatalog::~DlgNewCatalog()
{
}

void DlgNewCatalog::slotChangedCatalogname()
{
    if ( !leBaseFolder->lineEdit()->text().isEmpty() && !leCatalogName->text().isEmpty() )
        enableButtonOK( true );
    else
        enableButtonOK( false );
}

void DlgNewCatalog::slotOk()
{
    struct stat my_stat;
    QString basefolder = leBaseFolder->lineEdit()->text();

    // Check if the file exists
    // TODO: Use Qt3 functions (maybe allowing urls beginning with "file:/" )
    int result = stat( basefolder, &my_stat );
    if ( result == -1 )
    {
        KMessageBox::error( this, i18n( "The specified folder does not exist or is not accessible" ) );
        leBaseFolder->lineEdit()->selectAll();
        leBaseFolder->lineEdit()->setFocus();
        return;
    }

    this->done( QDialog::Accepted );
}

KatCatalog *DlgNewCatalog::newCatalog()
{
    KatCatalog *cat = new KatCatalog();

    cat->setName( leCatalogName->text() );
    cat->setDescription( teDescription->text() );
    cat->setNotes( teNotes->text() );
    cat->setPath( leBaseFolder->lineEdit()->text() );
    cat->setAuthor( leAuthor->text() );
    cat->setThumbnailSize( slThumbnailSize->value() );
    cat->setCreationDate( time( 0 ) );
    cat->setLastUpdateDate( time( 0 ) );

    if ( cbAutoUpdate->isChecked() )
        cat->setAutoUpdate( 2 );
    else
        cat->setAutoUpdate( 1 );
    return cat;
}

void DlgNewCatalog::slotUseExclusionList( int )
{
}

void DlgNewCatalog::slotThumbnailSizeValueChanged( int size )
{
    int i;
    int sizes[ 21 ];
    for ( i=0; i < 21; i++ )
        sizes[ i ] = i*8;

    for ( i=0; i<20; i++ )
    {
        if ( size > sizes[ i ] && size < sizes[ i + 1 ] )
        {
            size = sizes[ i ];
            break;
        }
    }
    QString s = QString::number( size );
    s = s + "x" + s;
    tlSize->setText( s );
    slThumbnailSize->setValue( size );
}

void DlgNewCatalog::slotChangedBaseFolder()
{
    if ( !leBaseFolder->lineEdit()->text().isEmpty() && !leCatalogName->text().isEmpty() )
        enableButtonOK( true );
    else
        enableButtonOK( false );
}

void DlgNewCatalog::slotManageExclusionList()
{
}

#include "dlgnewcatalog.moc"
