/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <qcstring.h>
#include <qsocket.h>
#include <qdatetime.h>
#include <qbitarray.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kurl.h>
#include <ksock.h>

#include "katslave.h"

#include <katengine.h>
#include <kat_export.h>

using namespace KIO;

static void addAtom(UDSEntry& entry, unsigned int uds, const QString& s)
{
	UDSAtom a;
	a.m_uds = uds;
	a.m_str = s;
	entry.append(a);
}


static void addAtom(UDSEntry& entry, unsigned int uds, long l)
{
	UDSAtom a;
	a.m_uds = uds;
	a.m_long = l;
	entry.append(a);
}

kio_katslaveProtocol::kio_katslaveProtocol( const QCString& pool_socket, const QCString& app_socket )
    : SlaveBase( "kio_katslave", pool_socket, app_socket )
{
    kdDebug() << "kio_katslaveProtocol::kio_katslaveProtocol()" << endl;
    m_ke = new KatEngine();
}

kio_katslaveProtocol::~kio_katslaveProtocol()
{
    kdDebug() << "kio_katslaveProtocol::~kio_katslaveProtocol()" << endl;
    delete m_ke;
}

QValueList<int> kio_katslaveProtocol::parseSearch( const QString& _url, QString & word )
{
    word = "";
    QString url = _url;
    while ( url.at( 0 ) == '/' )
        url.remove( 0, 1 );
    word = url;
    QValueList<int> results;
    //define method to specify or not search by filename etc.
    results = m_ke->doSearch( word, true, true, true );
    kdDebug() << " word search is before : " << word << endl;
    kdDebug() << " results number : " << results.count() << endl;
    return results;
}


void kio_katslaveProtocol::stat( const KURL & url )
{
    kdDebug()<<" void kio_katslaveProtocol::stat( const KURL & url )******************************* :"<<url<<endl;
    QString path = url.path();
    kdDebug()<<" void kio_katslaveProtocol::stat( const KURL & url ) : path !!! : "<<path<<endl;
    UDSEntry entry;
    addAtom(entry, KIO::UDS_NAME, url.decode_string(url.url()));
    addAtom(entry, KIO::UDS_FILE_TYPE, S_IFDIR);
    statEntry(entry);
    finished();
}


void kio_katslaveProtocol::listDir( const KURL & url )
{
    if ( url.path().length() <= 1 )
    {
        return;
    }

    kdDebug()<<" kio_katslaveProtocol::listDir :"<<url<<endl;
    QString wordSearch;
    QValueList<int> resultsValue = parseSearch( url.path(), wordSearch );
    kdDebug() << " wordSeach is : " << wordSearch << endl;

    kdDebug() << "url.prettyURL(): " << url.prettyURL() << endl;

    totalSize( resultsValue.count() );

    UDSEntry entry;
    QValueList<int>::Iterator it = resultsValue.begin();
    for( ; it != resultsValue.end(); ++it )
    {
        int fileid = *it;
        KatInformation info = m_ke->readFileInformation( fileid );
        UDSEntry entry;
        addAtom(entry, KIO::UDS_NAME, url.decode_string(info.fullName));
        addAtom(entry, KIO::UDS_FILE_TYPE,S_IFREG );

        listEntry( entry, false );
    }

    listEntry( entry, true ); // ready

    finished();
}


void kio_katslaveProtocol::get( const KURL& url )
{
    kdDebug() << "kio_katslave::get(const KURL& url) url.query(): " << url.query() << endl;

    QString wordSearch;
    QValueList<int> resultsValue = parseSearch( url.path(), wordSearch );
    kdDebug() << " wordSeach is : " << wordSearch << endl;

    kdDebug() << "url.prettyURL(): " << url.prettyURL() << endl;

    //data(QCString(d));
    data(QByteArray()); // empty array means we're done sending the data
    finished();
}

void kio_katslaveProtocol::mimetype( const KURL&url )
{
    kdDebug()<<" void kio_katslaveProtocol::mimetype( const KURL&url )******* :"<<url<<endl;
    mimeType( "inode/directory" );
    finished();
}

extern "C"
{
    KAT_EXPORT int kdemain( int argc, char** argv )
    {
        KInstance instance( "kio_katslave" );

        kdDebug() << "*** Starting kio_katslave " << endl;

        if (argc != 4) {
            kdDebug() << "Usage: kio_katslave  protocol domain-socket1 domain-socket2" << endl;
            exit( -1 );
        }

        kio_katslaveProtocol slave( argv[ 2 ], argv[ 3 ] );
        slave.dispatchLoop();

        kdDebug() << "*** kio_katslave Done" << endl;
        return 0;
    }
}
