/***************************************************************************
                          processus.cpp  -  description
                             -------------------
    begin                : Sat Jun 5 1999
    copyright            : a little improvement of kprocess.cpp (C) Christian Czezatke by Eric Coquelle
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "processus.h"
#include <kprocess.h>
#define _MAY_INCLUDE_KPROCESSCONTROLLER_
#include "kprocctrl.h"

#include <qapplication.h>

#include <config.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>

#include <kdebug.h>

const unsigned int CProcessus::maxnumberofarguments=800;

/////////////////////////////
// public member functions //
/////////////////////////////

CProcessus::CProcessus() : KProcess()//(QObject * parent) : KProcess( parent)
{
  connect(&my_splitprocess, SIGNAL(processExited (KProcess*)), this, SLOT(endSplitProcess(KProcess*)));
  connect(&my_splitprocess, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(stdoutSplitProcess(KProcess*, char*, int)));
  connect(&my_splitprocess, SIGNAL(receivedStderr (KProcess*, char*, int)), this, SLOT(stderrSplitProcess(KProcess*, char*, int)));
  my_splitprocess.clearArguments();
  maxargumentslist=0;
  positionargumentslist=0;
  argumentslist.clear();
  parameters.clear();
  splitprocess=false;
}

CProcessus::CProcessus(QObject * parent, const char* name) : KProcess( parent, name)
{
  connect(&my_splitprocess, SIGNAL(processExited (KProcess*)), this, SLOT(endSplitProcess(KProcess*)));
  connect(&my_splitprocess, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(stdoutSplitProcess(KProcess*, char*, int)));
  connect(&my_splitprocess, SIGNAL(receivedStderr (KProcess*, char*, int)), this, SLOT(stderrSplitProcess(KProcess*, char*, int)));
  my_splitprocess.clearArguments();
  maxargumentslist=0;
  positionargumentslist=0;
  argumentslist.clear();
  parameters.clear();
  splitprocess=false;
}

bool CProcessus::start(FILE** flot, Communication comm, RunMode runmode)
{
   if(runmode!=DontCare)
   	return start(runmode,comm);
   	
   uint i;
   uint n = arguments.count();
   char **arglist;
 
   if (runs || (0 == n)) {//if (isRunning()) {
     return FALSE;  // cannot start a process that is already running
     // or if no executable has been assigned
   }

   status = 0;
 
   arglist = (char **)malloc( (n+1)*sizeof(char *));
   CHECK_PTR(arglist);
   for (i=0; i < n; i++)
     arglist[i] = arguments[i].data();
   arglist[n]= 0;//NULL;
 
   if (!setupCommunication(comm))
     debug("Could not setup Communication!");
 
   runs = TRUE;

   QApplication::flushX();
   pid_ = fork();
 
   if (0 == pid_) {
     // The child process

     if(!commSetupDoneC())
	 		debug("Could not finish comm setup in child!");

     setpgid(0,0);
      // restore default SIGPIPE handler (restore)
      struct sigaction act;
      sigemptyset(&(act.sa_mask));
      sigaddset(&(act.sa_mask), SIGPIPE);
      act.sa_handler = SIG_DFL;
      act.sa_flags = 0;
      sigaction(SIGPIPE, &act, 0L);

     execvp(arglist[0], arglist);
     exit(-1);
 
   } else if (-1 == pid_) {
     // forking failed
 
     runs = FALSE;
     free(arglist);
     return FALSE;

   } else {
     // the parent continues here

    if (communication & Stdin)
    close(in[0]);
    if (communication & Stdout)
      close(out[1]);
    if (communication & Stderr)
      close(err[1]);		

     if (comm == Stdin)
	     *flot = fdopen(in[1], "w");
     else if (comm == Stdout)
	     *flot = fdopen(out[0], "r");
     else if (comm == Stderr)
	     *flot = fdopen(err[0], "r");

   }
   free(arglist);
   return TRUE;
}

void CProcessus::stdoutSplitProcess(KProcess* p, char* b, int l)
{
  emit(receivedStdout (p, b, l));
}

void CProcessus::stderrSplitProcess(KProcess* p, char* b, int l)
{
  emit(receivedStderr (p, b, l));
}

void CProcessus::endSplitProcess(KProcess *)
{
  if(positionargumentslist>maxargumentslist)
  {
    my_splitprocess.clearArguments();
    maxargumentslist=0;
    positionargumentslist=0;
    argumentslist.clear();
    parameters.clear();
    splitprocess=false;
    positionargumentslist=0;
    emit(processExited(this));
  }
  else
  {
    positionargumentslist+=maxnumberofarguments;
    prepareSubProcess();
    my_splitprocess.start(m_runmode, m_communication);
  }
}

void CProcessus::clearArguments ()
{
  my_splitprocess.clearArguments();
  splitprocess=false;
  maxargumentslist=0;
  positionargumentslist=0;
  argumentslist.clear();
  parameters.clear();
  KProcess::clearArguments ();
}

KProcess& CProcessus::operator<<(const QString &arg)
{
  parameters.append(arg);
  return KProcess::operator<<(arg);
}

KProcess& CProcessus::operator<<(const QCString &arg)
{
  parameters.append(arg);
  return KProcess::operator<<(arg);
}

KProcess& CProcessus::operator<<(const char *arg)
{
  parameters.append(arg);
  return KProcess::operator<<(arg);
}

KProcess& CProcessus::operator<<(const QStringList &args) 
{
    if(maxargumentslist+args.count()>maxnumberofarguments)
    {
      for(unsigned int i=0;i<args.count();i++ )
      {
        argumentslist.append(*args.at(i));
      }
      positionlistfilesinparameters=parameters.count(); //Some uncompressors are quite sensitive where the various arguments are...
      splitprocess=true;
      maxargumentslist+=args.count();
      return my_splitprocess;
    }
    else 
    {
      splitprocess=false;
      return KProcess::operator<<(args);
    }
}

bool CProcessus::kill (int signo)
{
  if(splitprocess)
  {
    my_splitprocess.clearArguments();
    maxargumentslist=0;
    argumentslist.clear();
    parameters.clear();
    splitprocess=false;
    positionargumentslist=0;
    emit(processExited(this));
    return my_splitprocess.kill(signo);
  }
  else
    return KProcess::kill(signo);
}

void CProcessus::prepareSubProcess()
{
  unsigned int i, max;
  
  my_splitprocess.clearArguments();
  /*for(QStringList::Iterator it=parameters.begin();it != parameters.end(); ++it ) {
    my_splitprocess<<*it;
}*/
  for(i=0;i<positionlistfilesinparameters;i++) {
    my_splitprocess << *parameters.at(i);
    kdDebug()<<QString("Adding parameter %1, pos %2").arg(*parameters.at(i)).arg(i)<<endl;
  }
  
  kdDebug()<<QString("Arguments")<<endl;
  max=positionargumentslist+maxnumberofarguments;
  if(max>=maxargumentslist)
    max=maxargumentslist;
  for(i=positionargumentslist;i<max;i++)
    my_splitprocess << *argumentslist.at(i);
  
  for(i=positionlistfilesinparameters;i<parameters.count();i++) {
    my_splitprocess << *parameters.at(i);
    kdDebug()<<QString("Adding parameter %1, pos %2").arg(*parameters.at(i)).arg(i)<<endl;
  }
}

bool CProcessus::start(RunMode runmode, Communication comm)
{
  if(splitprocess)
  {
    positionargumentslist=0;
    prepareSubProcess();
    m_runmode=runmode;
    m_communication=comm;
    kdDebug()<<QString("Running subprocess")<<endl;
    return my_splitprocess.start(runmode, comm);
  }
  else
    return KProcess::start(runmode, comm);
}

#include "processus.moc"
