/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) 2000 by Eric Coquelle <coquelle@caramail.com>
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cnavigateur.h"

CArchiveBrowser::CArchiveBrowser(QWidget *parent, const char *name) : QDialog(parent,name,false){
  initDialog();

  //Additionnal init
  lPath->setFrameStyle( QFrame::Panel | QFrame::Sunken );

  setCaption(i18n("Archive Browser"));
}

CArchiveBrowser::~CArchiveBrowser(){
}

/** Set the current path for the browser */
void CArchiveBrowser::setPath(QString path)
{
  QStringList listefichiers;
  QDir d;

  lPath->setText(path);
  d.setPath(path);

  QListBox_1->clear();
  listefichiers=d.entryList("*gz");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*bz2");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*tar");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*.Z");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*zip");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*rar");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*lha");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*lzh");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*arj");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*7z");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*deb");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*sit");
  QListBox_1->insertStringList(listefichiers);
  listefichiers=d.entryList("*hqx");
  QListBox_1->insertStringList(listefichiers);
}

QString CArchiveBrowser::getChemin()
{
  return lPath->text()+"/";
}

/** The user closed the window */
void CArchiveBrowser::closeEvent( QCloseEvent* ){
	emit(windowwillbeclosed());
}

#include "cnavigateur.moc"
