/***************************************************************************
                          caddfiles.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CADDFILES_H
#define CADDFILES_H

#include <qwidget.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qdialog.h>

#include <klocale.h>
#include <kfiledialog.h>

#include "cchoixfichier.h"


/**
  *@author Eric Coquelle
  */

class CAddFiles : public QDialog  {
   Q_OBJECT
public: 
	CAddFiles(QWidget *parent=0, const char *name=0);
	~CAddFiles();
  /** return the name of the archive to be created */
  QString getNewArchiveName();
  /** return the name of the archive to which
		* the files will be added */
  QString getOtherArchiveName();
  /** Return 0 if we'll add files to current archive,
		* 1 if we'll add to another,
		* 2 if we'll create a new archive
		* 3 if we'll directly open this archive*/
  int getAddFilesChoice();
  /** The dropped file is an archive, so modify
		* the dialog box. */
  void setCheckBoxArchive();
  /** If karchiveur doesn't contain any archive,
		* disable the first radio button */
  void canAddToCurrentArchive(bool canAdd);
  /*Set the default dusplayed archive name*/
  void setDefaultArchiveName(QString);

public:
  enum {INVALID=-1, ADD_TO_CURRENT_ARCHIVE, ADD_TO_ANOTHER_ARCHIVE, CREATE_NEW_ARCHIVE_AND_ADD, OPEN_THIS_ARCHIVE};

protected: 
	void initDialog();

private:
	QButtonGroup *bgChooseActionAddFiles;
	QRadioButton *rbAddCurrent;
	QRadioButton *rbAddOther;
	QLineEdit *leCreate;
	QPushButton *bBrowseAdd;
	QRadioButton *rbCreate;
	QPushButton *bBrowseCreate;
	QLineEdit *leAddOther;
	QRadioButton *rbOpenArchive;
	QPushButton *bOk;
	QPushButton *bCancel;

protected slots: // Protected slots
  /** The user will enter a new archive name */
  void slotBrowseCreateArchive();
  /** reject the choices */
  void slotCancel();
  /** Validate the choice */
  void slotOk();
  /** The user will browse and choose the archive
  to which the files will be added */
  void slotBrowseAddToOtherArchive();
  /*Check for the lineedit to ckeck the right radiobox*/
  void slotUpdateCreate(const QString&);
  void slotUpdateAddOther(const QString&);
  void slotSetFocus(int);
};

#endif
