/*
    Copyright (C) 2005 by Ryan Schultz <schultz.ryan@gmail.com>
	GNU GPL v2 
*/

/* Translation data from kanjidic/edict */

#ifndef _KANJI_H_
#define _KANJI_H_

typedef struct {
  const char    * pKanji;
  const char	* pEnglish;
  const char	* pKun;
  const char	* pKunRomaji;
  const char	* pOn;
  const char	* pOnRomaji;
} kanjitransInfo;

static kanjitransInfo kanjitable_jlpt4[] =
{
{"半","half, middle, odd number, semi-, part-","なか.ば, は","naka.ba, ha","ハン","han"},
{"南","south","みなみ, なみ, は, みな, みまみ","minami, nami, ha, mina, mimami","ナン, ナ","nan, na"},
{"友","friend","とも, う, ど, ゆ","tomo, u, do, yu","ユウ","yuu"},
{"口","mouth","くち","kuchi","コウ, ク","kou, ku"},
{"古","old","ふる.い, ふる, ふる.す, ふゆ","furu.i, furu, furu.su, fuyu","コ","ko"},
{"右","right","みぎ, あき, すけ","migi, aki, suke","ウ, ユウ","u, yuu"},
{"名","name, noted, distinguished, reputation","な, な, と","na, na, to","メイ, ミョウ","mei, myou"},
{"四","four","よ, よ.つ, よっ.つ, よん, あ, つ, よつ","yo, yo.tsu, yoo.tsu, yon, a, tsu, yotsu","シ","shi"},
{"国","country","くに, くな, こ","kuni, kuna, ko","コク","koku"},
{"土","soil, earth, ground, Turkey","つち, つ, つく, は, ひじ","tsuchi, tsu, tsuku, ha, hiji","ド, ト","do, to"},
{"外","outside","そと, ほか, はず.す, はず.れる, と, うい, け, ふか","soto, hoka, hazu.su, hazu.reru, to, ui, ke, fuka","ガイ, ゲ","gai, ge"},
{"多","many, frequent, much","おお.い, まさ.に, まさ.る","oo.i, masa.ni, masa.ru","タ","ta"},
{"大","large, big","おお, おお.きい, おお.いに, うふ, お, おう, た, たかし, とも, はじめ, ひろ, ひろし, まさ, まさる, もと, わ","oo, oo.kii, oo.ini, ufu, o, ou, ta, takashi, tomo, hajime, hiro, hiroshi, masa, masaru, moto, wa","ダイ, タイ","dai, tai"},
{"天","heavens, sky, imperial","あまつ, あめ, あま, あき, あも, た, たかし, て, なま","amatsu, ame, ama, aki, amo, ta, takashi, te, nama","テン","ten"},
{"女","woman, female","おんな, め, おな, た, つき, な","onna, me, ona, ta, tsuki, na","ジョ, ニョ, ニョウ","jo, nyo, nyou"},
{"子","child, sign of the rat, 11PM-1AM, first sign of Chinese zodiac","こ, こ, ね, い, き, ぎ, く, け, ねっ","ko, ko, ne, i, ki, gi, ku, ke, nee","シ, ス, ツ","shi, su, tsu"},
{"学","study, learning, science","まな.ぶ, たか, のり","mana.bu, taka, nori","ガク","gaku"},
{"安","relax, cheap, low, quiet, rested, contented, peaceful","やす.い, やす.まる, やす, やす.らか, あ, あす, あず, あっ, や","yasu.i, yasu.maru, yasu, yasu.raka, a, asu, azu, aa, ya","アン","an"},
{"小","little, small","ちい.さい, こ, お, さ, いさら, こう, さざ, しゃお, ちいさ","chii.sai, ko, o, sa, isara, kou, saza, shao, chiisa","ショウ","shou"},
{"少","few, little","すく.ない, すこ.し","suku.nai, suko.shi","ショウ","shou"},
{"山","mountain","やま, さ, やの, やん","yama, sa, yano, yan","サン, セン","san, sen"},
{"川","stream, river","かわ, か, こ, さわ, さんぼんがわ","kawa, ka, ko, sawa, sanbongawa","セン","sen"},
{"左","left","ひだり, そ","hidari, so","サ, シャ","sa, sha"},
{"年","year","とし, ね","toshi, ne","ネン","nen"},
{"店","store, shop","みせ, たな","mise, tana","テン","ten"},
{"後","behind, back, later","のち, うし.ろ, うしろ, あと, おく.れる, こし, し, しい, しり","nochi, ushi.ro, ushiro, ato, oku.reru, koshi, shi, shii, shiri","ゴ, コウ","go, kou"},
{"手","hand","て, て, て, た","te, te, te, ta","シュ, ズ","shu, zu"},
{"新","new","あたら.しい, あら.た, あら, にい, あせ, あたらし, し, に, にっ, につ, よし","atara.shii, ara.ta, ara, nii, ase, atarashi, shi, ni, nii, nitsu, yoshi","シン","shin"},
{"日","day, sun, Japan","ひ, び, か, あ, あき, いる, く, くさ, こう, す, たち, に, にっ, につ, へ","hi, bi, ka, a, aki, iru, ku, kusa, kou, su, tachi, ni, nii, nitsu, he","ニチ, ジツ","nichi, jitsu"},
{"時","time, hour","とき, どき, と, とぎ","toki, doki, to, togi","ジ","ji"},
{"書","write","か.く, が.き, がき, かき","ka.ku, ga.ki, gaki, kaki","ショ","sho"},
{"月","month, moon","つき, おと, がっ, す, ずき, もり","tsuki, oto, gaa, su, zuki, mori","ゲツ, ガツ","getsu, gatsu"},
{"木","tree, wood","き, こ, ぐ, も, もと","ki, ko, gu, mo, moto","ボク, モク","boku, moku"},
{"本","book, present, main, true, real, counter for long things","もと, まと","moto, mato","ホン","hon"},
{"来","come, due, next, cause, become","く.る, きた.る, きた.す, き.たす, き.たる, き, こ, くり, くる, ごろ, さ","ku.ru, kita.ru, kita.su, ki.tasu, ki.taru, ki, ko, kuri, kuru, goro, sa","ライ, タイ","rai, tai"},
{"東","east","ひがし, あい, あがり, あずま, あづま, こ, さき, しの, とお, はる, ひが, もと","higashi, ai, agari, azuma, azuma, ko, saki, shino, too, haru, higa, moto","トウ","tou"},
{"校","exam, school, printing, proof, correction","めん","men","コウ, キョウ","kou, kyou"},
{"母","mama, mother","はは, も","haha, mo","ボ","bo"},
{"毎","every","ごと, ごと.に, つね","goto, goto.ni, tsune","マイ","mai"},
{"気","spirit, mind","いき","iki","キ, ケ","ki, ke"},
{"水","water","みず, みず, うず, ずみ, つ, ど, み, みさ, みつ, みな, みん","mizu, mizu, uzu, zumi, tsu, do, mi, misa, mitsu, mina, min","スイ","sui"},
{"火","fire","ひ, び, ほ","hi, bi, ho","カ","ka"},
{"父","father","ちち","chichi","フ","fu"},
{"生","life, genuine, birth","い.きる, い.かす, い.ける, う.まれる, う.まれ, うまれ, う.む, お.う, は.える, は.やす, き, なま, なま, な.る, な.す, む.す, う, あさ, いき, いく, いけ, うぶ, うまい, え, おい, ぎゅう, くるみ, ごせ, さ, じょう, すぎ, そ, そう, ちる, なば, にう, にゅう, ふ, み, もう, よい, りゅう","i.kiru, i.kasu, i.keru, u.mareru, u.mare, umare, u.mu, o.u, ha.eru, ha.yasu, ki, nama, nama, na.ru, na.su, mu.su, u, asa, iki, iku, ike, ubu, umai, e, oi, gyuu, kurumi, gose, sa, jou, sugi, so, sou, chiru, naba, niu, nyuu, fu, mi, mou, yoi, ryuu","セイ, ショウ","sei, shou"},
{"男","male","おとこ, お, み","otoko, o, mi","ダン, ナン","dan, nan"},
{"白","white","しろ, しら, しろ.い, あき, か, はっ","shiro, shira, shiro.i, aki, ka, haa","ハク, ビャク","haku, byaku"},
{"百","hundred","もも, お, ど, どう, なり, ひゃっ, ひゅく, も, もんど, ゆ","momo, o, do, dou, nari, hyaa, hyuku, mo, mondo, yu","ヒャク, ビャク","hyaku, byaku"},
{"目","eye, class, look, insight, experience, care, favor","め, め, ま, さかん, さがん, さっか, さつか","me, me, ma, sakan, sagan, sakka, satsuka","モク, ボク","moku, boku"},
{"社","company, firm, office, association, shrine","やしろ, こそ","yashiro, koso","シャ","sha"},
{"空","empty, sky, void, vacant, vacuum","そら, あ.く, あ.き, あ.ける, から, す.く, す.かす, むな.しい, うつ, き, く","sora, a.ku, a.ki, a.keru, kara, su.ku, su.kasu, muna.shii, utsu, ki, ku","クウ","kuu"},
{"立","stand up","た.つ, た.つ, た.ち, た.てる, た.てる, た.て, たて, た.て, だ.て, だ.てる, たち, たっ, たつ, だて, つい","ta.tsu, ta.tsu, ta.chi, ta.teru, ta.teru, ta.te, tate, ta.te, da.te, da.teru, tachi, taa, tatsu, date, tsui","リツ, リュウ, リットル","ritsu, ryuu, rittoru"},
{"耳","ear","みみ, がみ","mimi, gami","ジ","ji"},
{"聞","hear, ask, listen","き.く, き.こえる","ki.ku, ki.koeru","ブン, モン","bun, mon"},
{"花","flower","はな, わ","hana, wa","カ, ケ","ka, ke"},
{"行","going, journey","い.く, ゆ.く, ゆ.き, ゆき, い.き, いき, おこな.う, おこ.なう, いく, なみ, なめ, みち, ゆき, ゆく","i.ku, yu.ku, yu.ki, yuki, i.ki, iki, okona.u, oko.nau, iku, nami, name, michi, yuki, yuku","コウ, ギョウ, アン","kou, gyou, an"},
{"西","west, Spain","にし, いり, ひし, むら","nishi, iri, hishi, mura","セイ, サイ, ス","sei, sai, su"},
{"見","see, hopes, chances, idea, opinion, look at, visible","み.る, み.える, み.せる","mi.ru, mi.eru, mi.seru","ケン","ken"},
{"言","say","い.う, こと, とき","i.u, koto, toki","ゲン, ゴン","gen, gon"},
{"話","tale, talk","はな.す, はなし","hana.su, hanashi","ワ","wa"},
{"語","word, speech, language","かた.る, かた.らう","kata.ru, kata.rau","ゴ","go"},
{"読","read","よ.む, よ.み, よみ","yo.mu, yo.mi, yomi","ドク, トク, トウ","doku, toku, tou"},
{"買","buy","か.う","ka.u","バイ","bai"},
{"足","leg, foot, be sufficient, counter for pairs of footwear","あし, た.りる, た.る, た.す, あ, あす, おす, たらし","ashi, ta.riru, ta.ru, ta.su, a, asu, osu, tarashi","ソク","soku"},
{"車","car","くるま, くら, くろま","kuruma, kura, kuroma","シャ","sha"},
{"週","week","","","シュウ","shuu"},
{"道","road-way, street, district, journey, course, moral, teachings","みち, さ, じ, ど, みつ","michi, sa, ji, do, mitsu","ドウ, トウ","dou, tou"},
{"金","gold","かね, かな, がね, かん, きむ, こ, この, ん","kane, kana, gane, kan, kimu, ko, kono, n","キン, コン, ゴン","kin, kon, gon"},
{"長","long, leader","なが.い, おさ, お, おしゃ, たかし, たけ, な, は, ひさ","naga.i, osa, o, osha, takashi, take, na, ha, hisa","チョウ","chou"},
{"間","interval, space","あいだ, ま, あい","aida, ma, ai","カン, ケン","kan, ken"},
{"雨","rain","あめ, あま, さめ","ame, ama, same","ウ","u"},
{"電","electricity","","","デン","den"},
{"食","eat, food","く.う, く.らう, た.べる, は.む, ぐい","ku.u, ku.rau, ta.beru, ha.mu, gui","ショク, ジキ","shoku, jiki"},
{"飲","drink, smoke, take","の.む, の.み","no.mu, no.mi","イン, オン","in, on"},
{"駅","station","","","エキ","eki"},
{"高","tall, high, expensive","たか.い, たか, だか, たか.まる, たか.める, か, こ, じょい, た, はか","taka.i, taka, daka, taka.maru, taka.meru, ka, ko, joi, ta, haka","コウ","kou"},
{"魚","fish","うお, さかな, ざかな, い","uo, sakana, zakana, i","ギョ","gyo"}
};

static kanjitransInfo kanjitable_jlpt3[] = 
{
{"青","blue, green","あお, あお, あお.い, お","ao, ao, ao.i, o","セイ, ショウ","sei, shou"},
{"赤","red","あか, あか, あか.い, あか.らむ, あか.らめる, あ, あこ, あま","aka, aka, aka.i, aka.ramu, aka.rameru, a, ako, ama","セキ, シャク","seki, shaku"},
{"明","bright, light","あ.かり, あか.るい, あか.るむ, あか.らむ, あき.らか, あ.ける, あ.け, あ.く, あ.くる, あ.かす, あきら, あけ, あす, きら, け, さや, さやか, とし, はる, み, め","a.kari, aka.rui, aka.rumu, aka.ramu, aki.raka, a.keru, a.ke, a.ku, a.kuru, a.kasu, akira, ake, asu, kira, ke, saya, sayaka, toshi, haru, mi, me","メイ, ミョウ, ミン","mei, myou, min"},
{"秋","autumn","あき, とき, あい","aki, toki, ai","シュウ","shuu"},
{"開","open, unfold, unseal","ひら.く, ひら.き, びら.き, ひら.ける, あ.く, あ.ける, はる, か","hira.ku, hira.ki, bira.ki, hira.keru, a.ku, a.keru, haru, ka","カイ","kai"},
{"悪","bad, vice, rascal, false, evil, wrong","わる.い, わる, あ.し, にく.い, にく.い, ああ, いずくに, いずくんぞ, にく.む","waru.i, waru, a.shi, niku.i, niku.i, aa, izukuni, izukunzo, niku.mu","アク, オ","aku, o"},
{"朝","morning, dynasty, regime, epoch, period, (North) Korea","あさ, あ, あそ, ささ, ちか, とも","asa, a, aso, sasa, chika, tomo","チョウ","chou"},
{"字","character, letter, word, section of village","あざ, あざな, な","aza, azana, na","ジ","ji"},
{"味","flavor, taste","あじ, あじ.わう","aji, aji.wau","ミ","mi"},
{"集","gather, meet, congregate, swarm, flock","あつ.まる, あつ.める, つど.う, あつまり, ず","atsu.maru, atsu.meru, tsudo.u, atsumari, zu","シュウ","shuu"},
{"兄","elder brother, big brother","あに, え, せ, よし","ani, e, se, yoshi","ケイ, キョウ","kei, kyou"},
{"姉","elder sister","あね, はは","ane, haha","シ","shi"},
{"歩","walk, counter for steps","ある.く, あゆ.む, あ, ゆき, ゆみ","aru.ku, ayu.mu, a, yuki, yumi","ホ, ブ, フ","ho, bu, fu"},
{"有","possess, have, exist, happen, occur, approx","あ.る, あ, あら, あり, ある, くに, なお, ゆ","a.ru, a, ara, ari, aru, kuni, nao, yu","ユウ, ウ","yuu, u"},
{"医","doctor, medicine","い.やす, い.する, くすし","i.yasu, i.suru, kusushi","イ","i"},
{"意","idea, mind, heart, taste, thought, desire, care, liking","もと, よし","moto, yoshi","イ","i"},
{"以","by means of, because, in view of, compared with","もっ.て, もち","moo.te, mochi","イ","i"},
{"家","house, home","いえ, や, うち, あり, え, く, つか, べ","ie, ya, uchi, ari, e, ku, tsuka, be","カ, ケ","ka, ke"},
{"急","hurry, emergency, sudden, steep","いそ.ぐ, いそ.ぎ","iso.gu, iso.gi","キュウ","kyuu"},
{"犬","dog","いぬ, いぬ","inu, inu","ケン","ken"},
{"妹","younger sister","いもうと, す, せ, も","imouto, su, se, mo","マイ","mai"},
{"色","color","いろ, しか, しこ","iro, shika, shiko","ショク, シキ","shoku, shiki"},
{"音","sound, noise","おと, ね, お, と","oto, ne, o, to","オン, イン, ノン","on, in, non"},
{"員","employee, member, number, the one in charge","いな, かず","ina, kazu","イン","in"},
{"院","Inst., institution, temple, mansion, school","","","イン","in"},
{"動","move, motion, change, confusion, shift, shake","うご.く, うご.かす, るぎ","ugo.ku, ugo.kasu, rugi","ドウ","dou"},
{"牛","cow","うし, うじ, ご","ushi, uji, go","ギュウ","gyuu"},
{"歌","song, sing","うた, うた.う","uta, uta.u","カ","ka"},
{"写","copy, be photographed, describe","うつ.す, うつ.る, うつ, うつ.し","utsu.su, utsu.ru, utsu, utsu.shi","シャ, ジャ","sha, ja"},
{"映","reflect, reflection, projection","うつ.る, うつ.す, は.える, ば.え, あきら, え, てる","utsu.ru, utsu.su, ha.eru, ba.e, akira, e, teru","エイ","ei"},
{"海","sea, ocean","うみ, あ, あま, うな, うん, え, か, た, ひろ, ひろし, ぶ, まち, まま, み, め, わたる","umi, a, ama, una, un, e, ka, ta, hiro, hiroshi, bu, machi, mama, mi, me, wataru","カイ","kai"},
{"売","sell","う.る, う.れる, うり, うる, め","u.ru, u.reru, uri, uru, me","バイ","bai"},
{"運","carry, luck, destiny, fate, lot, transport, progress, advance","はこ.ぶ","hako.bu","ウン","un"},
{"重","heavy, heap up, pile up, nest of boxes, -fold","え, おも.い, おも.り, おも.なう, かさ.ねる, かさ.なる, おも, さね, しげ, しげる","e, omo.i, omo.ri, omo.nau, kasa.neru, kasa.naru, omo, sane, shige, shigeru","ジュウ, チョウ","juu, chou"},
{"英","England, English","はなぶさ, あ, あい, え, すぐる, はな, ひ, ひで, よし, ら","hanabusa, a, ai, e, suguru, hana, hi, hide, yoshi, ra","エイ","ei"},
{"終","end, finish","お.わる, お.わる, おわ.る, お.える, つい, つい.に, ばて","o.waru, o.waru, owa.ru, o.eru, tsui, tsui.ni, bate","シュウ","shuu"},
{"起","rouse, wake up, get up","お.きる, お.こる, お.こす, おこ.す, た.つ","o.kiru, o.koru, o.kosu, oko.su, ta.tsu","キ","ki"},
{"屋","roof, house, shop, dealer, seller","や, た","ya, ta","オク","oku"},
{"送","escort, send","おく.る","oku.ru","ソウ","sou"},
{"教","teach, faith, doctrine","おし.える, おそ.わる, のり, ひさ","oshi.eru, oso.waru, nori, hisa","キョウ","kyou"},
{"弟","younger brother, faithful service to elders","おとうと, て","otouto, te","テイ, ダイ, デ","tei, dai, de"},
{"同","same, agree, equal","おな.じ","ona.ji","ドウ","dou"},
{"主","lord, chief, master, main thing, principal","ぬし, おも, あるじ, かず, ず, もん","nushi, omo, aruji, kazu, zu, mon","シュ, ス, シュウ","shu, su, shuu"},
{"思","think","おも.う, おもえら.く, おぼ.す","omo.u, omoera.ku, obo.su","シ","shi"},
{"親","parent, intimacy, relative, familiarity, dealer (cards)","おや, おや, した.しい, した.しむ, ぎ, ちか, のり","oya, oya, shita.shii, shita.shimu, gi, chika, nori","シン","shin"},
{"夏","summer","なつ","natsu","カ, ガ, ゲ","ka, ga, ge"},
{"画","brush-stroke, picture","えが.く, かく.する, かぎ.る, はかりごと, はか.る","ega.ku, kaku.suru, kagi.ru, hakarigoto, haka.ru","ガ, カク, エ, カイ","ga, kaku, e, kai"},
{"界","world","","","カイ","kai"},
{"帰","homecoming, arrive at, lead to, result in","かえ.る, かえ.す, おく.る, とつ.ぐ","kae.ru, kae.su, oku.ru, totsu.gu","キ","ki"},
{"代","substitute, change, convert, replace, period, age, generation, charge, rate, fee","か.わる, かわ.る, かわ.り, がわ.り, か.える, よ, しろ, す","ka.waru, kawa.ru, kawa.ri, gawa.ri, ka.eru, yo, shiro, su","ダイ, タイ","dai, tai"},
{"楽","music, comfort, ease","たの.しい, たの.しむ, この.む, さ, た, やす, ら","tano.shii, tano.shimu, kono.mu, sa, ta, yasu, ra","ガク, ラク, ゴウ","gaku, raku, gou"},
{"風","wind, air, style, manner","かぜ, かざ, かぜ, い, え","kaze, kaza, kaze, i, e","フウ, フ","fuu, fu"},
{"貸","lend","か.す, か.し, かし","ka.su, ka.shi, kashi","タイ","tai"},
{"方","direction, person, alternative","かた, かた, がた, から, な, なた, ふさ, まさ, みち, も, わ","kata, kata, gata, kara, na, nata, fusa, masa, michi, mo, wa","ホウ","hou"},
{"紙","paper","かみ","kami","シ","shi"},
{"通","traffic, pass through, avenue, commute, counter for letters","とお.る, とお.り, とお.り, どお.り, とお.す, とお.し, どお.し, かよ.う, とん, どうし, どおり, みち","too.ru, too.ri, too.ri, doo.ri, too.su, too.shi, doo.shi, kayo.u, ton, doushi, doori, michi","ツウ, ツ","tsuu, tsu"},
{"体","body, substance, object, reality, counter for images","からだ, かたち, なり","karada, katachi, nari","タイ, テイ","tai, tei"},
{"借","borrow, rent","か.りる","ka.riru","シャク","shaku"},
{"漢","Sino-, China","はん","han","カン","kan"},
{"館","building, mansion, large building, palace","やかた, たて, たち","yakata, tate, tachi","カン","kan"},
{"元","beginning, former time, origin","もと, ちか, はじめ, はる, ゆき, よし","moto, chika, hajime, haru, yuki, yoshi","ゲン, ガン","gen, gan"},
{"考","consider, think over","かんが.える, かんが.え, たか","kanga.eru, kanga.e, taka","コウ","kou"},
{"着","don, arrive, wear, counter for suits of clothing","き.る, ぎ, き.せる, き.せ, つ.く, つ.ける","ki.ru, gi, ki.seru, ki.se, tsu.ku, tsu.keru","チャク, ジャク","chaku, jaku"},
{"究","research, study","きわ.める, きゅ","kiwa.meru, kyu","キュウ, ク","kyuu, ku"},
{"去","gone, past, quit, leave, elapse, eliminate, divorce","さ.る, さ.る, い","sa.ru, sa.ru, i","キョ, コ","kyo, ko"},
{"京","capital, 10**16","みやこ, たか","miyako, taka","キョウ, ケイ, キン","kyou, kei, kin"},
{"強","strong","つよ.い, つよ.まる, つよ.める, し.いる, こわ.い, すね","tsuyo.i, tsuyo.maru, tsuyo.meru, shi.iru, kowa.i, sune","キョウ, ゴウ","kyou, gou"},
{"業","business, vocation, arts, performance","わざ, なり, のぶ","waza, nari, nobu","ギョウ, ゴウ","gyou, gou"},
{"〆切","(n) closing, cut-off, end, deadline, Closed, No Entrance","","","しめきり","shimekiri"},
{"切","cut, cutoff, be sharp","き.る, き.る, き.り, き.り, ぎ.り, き.れる, き.れる, き.れ, き.れ, ぎ.れ, きつ, きり, ぎり","ki.ru, ki.ru, ki.ri, ki.ri, gi.ri, ki.reru, ki.reru, ki.re, ki.re, gi.re, kitsu, kiri, giri","セツ, サイ","setsu, sai"},
{"近","near, early, akin, tantamount","ちか.い, おう, おお, この","chika.i, ou, oo, kono","キン, コン","kin, kon"},
{"銀","silver","しろがね, うん, かな, かね","shirogane, un, kana, kane","ギン","gin"},
{"工","craft, construction","もく, たくみ","moku, takumi","コウ, ク, グ","kou, ku, gu"},
{"黒","black","くろ, くろ.ずむ, くろ.い","kuro, kuro.zumu, kuro.i","コク","koku"},
{"計","plot, plan, scheme, measure","はか.る, はか.らう, え, かず, け","haka.ru, haka.rau, e, kazu, ke","ケイ","kei"},
{"研","polish, study of, sharpen","と.ぐ, のり","to.gu, nori","ケン","ken"},
{"建","build","た.てる, た.て, だ.て, た.つ, たけ, たつ, たて","ta.teru, ta.te, da.te, ta.tsu, take, tatsu, tate","ケン, コン","ken, kon"},
{"験","verification, effect, testing","あかし, しるし, ため.す, ためし","akashi, shirushi, tame.su, tameshi","ケン, ゲン","ken, gen"},
{"広","wide, broad, spacious","ひろ.い, ひろ.まる, ひろ.める, ひろ.がる, ひろ.げる","hiro.i, hiro.maru, hiro.meru, hiro.garu, hiro.geru","コウ","kou"},
{"心","heart, mind, spirit","こころ, ごころ, りっしんべん","kokoro, gokoro, risshinben","シン","shin"},
{"試","test, try, attempt, experiment, ordeal","こころ.みる, ため.す","kokoro.miru, tame.su","シ","shi"},
{"答","solution, answer","こた.える, こた.え, どう","kota.eru, kota.e, dou","トウ","tou"},
{"事","matter, thing, fact, business, reason, possibly","こと, つか.う, つか.える, ろ","koto, tsuka.u, tsuka.eru, ro","ジ, ズ","ji, zu"},
{"転","revolve, turn around, change","ころ.がる, ころ.げる, ころ.がす, ころ.ぶ, まろ.ぶ, うたた, うつ.る","koro.garu, koro.geru, koro.gasu, koro.bu, maro.bu, utata, utsu.ru","テン","ten"},
{"作","make, production, prepare, build","つく.る, つく.り, づく.り, くり, さか, さっ, づくり, とも, なお, はぎ, まさか","tsuku.ru, tsuku.ri, zuku.ri, kuri, saka, saa, zukuri, tomo, nao, hagi, masaka","サク, サ","saku, sa"},
{"茶","tea","ちや","chiya","チャ, サ","cha, sa"},
{"早","early, fast","はや.い, はや, はや, はや.まる, はや.める, さ, さか, さわ, そ, わ","haya.i, haya, haya, haya.maru, haya.meru, sa, saka, sawa, so, wa","ソウ, サッ","sou, saa"},
{"止","stop, halt","と.まる, ど.まり, と.める, と.める, ど.め, とど.める, とど.め, とど.まる, や.める, や.む, や.む, よ.す, さ.す, さ.し, どめ","to.maru, do.mari, to.meru, to.meru, do.me, todo.meru, todo.me, todo.maru, ya.meru, ya.mu, ya.mu, yo.su, sa.su, sa.shi, dome","シ","shi"},
{"自","oneself","みずか.ら, おの.ずから, おの.ずと, より","mizuka.ra, ono.zukara, ono.zuto, yori","ジ, シ","ji, shi"},
{"仕","attend, doing, official, serve","つか.える","tsuka.eru","シ, ジ","shi, ji"},
{"死","death, die","し.ぬ, し.に","shi.nu, shi.ni","シ","shi"},
{"始","commence, begin","はじ.める, はじ.める, はじ.まる, もと","haji.meru, haji.meru, haji.maru, moto","シ","shi"},
{"使","use","つか.う, つか.い, つか.い, づか.い","tsuka.u, tsuka.i, tsuka.i, zuka.i","シ","shi"},
{"私","private, I, me","わたくし, わたし","watakushi, watashi","シ","shi"},
{"地","ground, earth","どま","doma","チ, ジ","chi, ji"},
{"持","hold, have","も.つ, も.ち, も.てる, もち, もつ","mo.tsu, mo.chi, mo.teru, mochi, motsu","ジ","ji"},
{"質","substance, quality, matter, temperament","たち, ただ.す, もと, わりふ","tachi, tada.su, moto, warifu","シツ, シチ, チ","shitsu, shichi, chi"},
{"室","room, apartment, chamber, greenhouse, cellar","むろ","muro","シツ","shitsu"},
{"品","goods, refinement, dignity, article, counter for meal courses","しな","shina","ヒン, ホン","hin, hon"},
{"者","someone, person","もの","mono","シャ","sha"},
{"習","learn","なら.う, なら.い","nara.u, nara.i","シュウ, ジュ","shuu, ju"},
{"住","dwell, reside, live, inhabit","す.む, す.まう, ず.まい, し, じゅ, すみ","su.mu, su.mau, zu.mai, shi, ju, sumi","ジュウ, ヂュウ, チュウ","juu, jiュu, chuu"},
{"春","springtime, spring (season)","はる, あずま, かす, すの, ひ, わら","haru, azuma, kasu, suno, hi, wara","シュン","shun"},
{"正","correct, justice, righteous, 10**40","ただ.しい, ただ.す, まさ, まさ.に, おお, くに, ま, まさし, ただし","tada.shii, tada.su, masa, masa.ni, oo, kuni, ma, masashi, tadashi","セイ, ショウ","sei, shou"},
{"場","location, place","ば","ba","ジョウ, チョウ","jou, chou"},
{"知","know, wisdom","し.る, し.らせる, さと, さとる, しり, しれ, とも, のり","shi.ru, shi.raseru, sato, satoru, shiri, shire, tomo, nori","チ","chi"},
{"真","true, reality, Buddhist sect","ま, ま, まこと, さな, さね, ただ, ただし, なお, のり, まあ, まこ, まさ, まっ, まど, まな, まゆ, みち, も","ma, ma, makoto, sana, sane, tada, tadashi, nao, nori, maa, mako, masa, maa, mado, mana, mayu, michi, mo","シン","shin"},
{"図","map, drawing, plan, unexpected, accidentally","え, はか.る, づ","e, haka.ru, zu","ズ, ト","zu, to"},
{"世","generation, world, society, public","よ, さんじゅう, とし, ゆ, ゆき","yo, sanjuu, toshi, yu, yuki","セイ, セ, ソウ","sei, se, sou"},
{"夕","evening","ゆう, ゆ","yuu, yu","セキ","seki"},
{"走","run","はし.る, はしり","hashi.ru, hashiri","ソウ","sou"},
{"族","tribe, family","つぎ","tsugi","ゾク","zoku"},
{"注","pour, irrigate, shed (tears), flow into, concentrate on, notes, comment, annotate","そそ.ぐ, さ.す, つ.ぐ","soso.gu, sa.su, tsu.gu","チュウ","chuu"},
{"田","rice field, rice paddy","た, いなか, おか, たん, で, とう, や","ta, inaka, oka, tan, de, tou, ya","デン","den"},
{"台","pedestal, a stand, counter for machines and vehicles","うてな, われ, つかさ","utena, ware, tsukasa","ダイ, タイ","dai, tai"},
{"待","wait, depend on","ま.つ, ま.ち, まち, まつ","ma.tsu, ma.chi, machi, matsu","タイ","tai"},
{"題","topic, subject","","","ダイ","dai"},
{"度","degrees, occurrence, time, counter for occurrences","たび, た.い, のり","tabi, ta.i, nori","ド, ト, タク","do, to, taku"},
{"旅","trip, travel","たび","tabi","リョ","ryo"},
{"力","power, strong, strain, bear up, exert","ちから, じから, つとむ","chikara, jikara, tsutomu","リョク, リキ, リイ","ryoku, riki, rii"},
{"昼","daytime, noon","ひる","hiru","チュウ","chuu"},
{"町","village, town, block, street","まち","machi","チョウ","chou"},
{"鳥","bird, chicken","とり, か, と, とっ","tori, ka, to, too","チョウ","chou"},
{"問","question, ask, problem","と.う, と.い, とん, はる","to.u, to.i, ton, haru","モン","mon"},
{"冬","winter","ふゆ","fuyu","トウ","tou"},
{"堂","public chamber, hall","","","ドウ","dou"},
{"特","special","","","トク","toku"},
{"肉","meat","","","ニク","niku"},
{"野","plains, field, rustic, civilian life","の, の, ずけ, つけ, ぬ","no, no, zuke, tsuke, nu","ヤ, ショ","ya, sho"},
{"発","discharge, departure, publish, emit, start from, disclose","た.つ, あば.く, おこ.る, つか.わす, はな.つ, ば, わ","ta.tsu, aba.ku, oko.ru, tsuka.wasu, hana.tsu, ba, wa","ハツ, ホツ","hatsu, hotsu"},
{"飯","meal, boiled rice","めし, い, いい, いり, え","meshi, i, ii, iri, e","ハン","han"},
{"病","ill, sick","や.む, や.み, やまい","ya.mu, ya.mi, yamai","ビョウ, ヘイ","byou, hei"},
{"不","negative, non-, bad, ugly, clumsy","","","フ, ブ","fu, bu"},
{"服","clothing, admit, obey, discharge","はっ, はつ, はら","haa, hatsu, hara","フク","fuku"},
{"物","thing, object, matter","もの, もの","mono, mono","ブツ, モツ","butsu, motsu"},
{"文","sentence, literature, style, art, decoration, figures, plan","ふみ, あや, かざり, ふ, も, ぶんにょう","fumi, aya, kazari, fu, mo, bunnyou","ブン, モン","bun, mon"},
{"別","separate, branch off, diverge, fork, another, extra, specially","わか.れる, わ.ける, べっ","waka.reru, wa.keru, bee","ベツ","betsu"},
{"勉","exertion","つと.める, ひこ, やつ","tsuto.meru, hiko, yatsu","ベン","ben"},
{"用","utilize, business, service, use, employ","もち.いる, たから","mochi.iru, takara","ヨウ","you"},
{"夜","night, evening","よ, よる","yo, yoru","ヤ","ya"},
{"曜","weekday","てる","teru","ヨウ","you"},
{"洋","ocean, western style","なだ, ひろ, ひろし, よ, よし","nada, hiro, hiroshi, yo, yoshi","ヨウ","you"},
{"理","logic, arrangement, reason, justice, truth","ことわり, あや, おさむ, さと, さとる, ただ, ただし, とおる, に, のり, ひ, まこと, まさ, まさし, まろ, みち, よし","kotowari, aya, osamu, sato, satoru, tada, tadashi, tooru, ni, nori, hi, makoto, masa, masashi, maro, michi, yoshi","リ","ri"},
{"料","fee, materials","","","リョウ","ryou"},
{"暗","darkness, disappear, shade, informal, grow dark, be blinded","くら.い","kura.i","アン","an"},
{"引","pull, tug, jerk, admit, install, quote, refer to","ひ.く, ひ.き, ひ.き, び.き, ひ.ける, いな, ひき, ひけ, びき","hi.ku, hi.ki, hi.ki, bi.ki, hi.keru, ina, hiki, hike, biki","イン","in"},
{"遠","distant, far","とお.い, お, おに, ど, どお","too.i, o, oni, do, doo","エン, オン","en, on"},
{"回","-times, round, game, revolve, counter for occurrences","まわ.る, まわ.る, まわ.り, まわ.す, まわ.す, まわ.し, まわ.し, もとお.る, か.える","mawa.ru, mawa.ru, mawa.ri, mawa.su, mawa.su, mawa.shi, mawa.shi, motoo.ru, ka.eru","カイ, エ","kai, e"},
{"寒","cold","さむ.い, さ, さん","samu.i, sa, san","カン","kan"},
{"顔","face, expression","かお","kao","ガン","gan"},
{"区","ward, district","","","ク, オウ, コウ","ku, ou, kou"},
{"軽","lightly, trifling, unimportant","かる.い, かろ.やか, かろ.んじる","karu.i, karo.yaka, karo.njiru","ケイ","kei"},
{"県","prefecture","か.ける, あがた, がた","ka.keru, agata, gata","ケン","ken"},
{"光","ray, light","ひか.る, ひかり, あき, あきら, こお, てる, ひこ, み, みつ","hika.ru, hikari, aki, akira, koo, teru, hiko, mi, mitsu","コウ","kou"},
{"好","fond, pleasing, like something","この.む, す.く, よ.い, い.い, こ, たか, とし, よし","kono.mu, su.ku, yo.i, i.i, ko, taka, toshi, yoshi","コウ","kou"},
{"合","fit, suit, join, 0.1","あ.う, あ.う, あ.い, あい, あ.い, あい, あ.わす, あ.わせる, あ.わせる, あう, あん, い, か, こう, ごお, に, ね, や, り, わい","a.u, a.u, a.i, ai, a.i, ai, a.wasu, a.waseru, a.waseru, au, an, i, ka, kou, goo, ni, ne, ya, ri, wai","ゴウ, ガッ, カッ","gou, gaa, kaa"},
{"菜","vegetable, side dish, greens","な, よう","na, you","サイ","sai"},
{"産","products, bear, give birth, yield, childbirth, native, property","う.む, う.まれる, うぶ, む.す, もと","u.mu, u.mareru, ubu, mu.su, moto","サン","san"},
{"市","market, city, town","いち, い, ち","ichi, i, chi","シ","shi"},
{"弱","weak, frail","よわ.い, よわ.る, よわ.まる, よわ.める","yowa.i, yowa.ru, yowa.maru, yowa.meru","ジャク","jaku"},
{"首","neck","くび, おびと, こべ, す","kubi, obito, kobe, su","シュ","shu"},
{"暑","sultry, hot, summer heat","あつ.い","atsu.i","ショ","sho"},
{"所","place","ところ, ところ, どころ, とこ, せ","tokoro, tokoro, dokoro, toko, se","ショ","sho"},
{"乗","ride, power, multiplication, record, counter for vehicles, board, mount, join","の.る, の.り, の.せる, のり","no.ru, no.ri, no.seru, nori","ジョウ, ショウ","jou, shou"},
{"森","forest, woods","もり, もと","mori, moto","シン","shin"},
{"進","advance, proceed, progress, promote","すす.む, すす.める, のぶ","susu.mu, susu.meru, nobu","シン","shin"},
{"声","voice","こえ, こわ","koe, kowa","セイ, ショウ","sei, shou"},
{"説","rumor, opinion, theory","と.く, さとし, とき","to.ku, satoshi, toki","セツ, ゼイ","setsu, zei"},
{"洗","wash, inquire into, probe","あら.う, あらい, らい","ara.u, arai, rai","セン","sen"},
{"村","town, village","むら, え, むた, ら","mura, e, muta, ra","ソン","son"},
{"太","plump, thick, big around","ふと.い, ふと.る, おお, たか, ひろ","futo.i, futo.ru, oo, taka, hiro","タイ, タ","tai, ta"},
{"短","short, brevity, fault, defect, weak point","みじか.い","mijika.i","タン","tan"},
{"池","pond, cistern, pool, reservoir","いけ","ike","チ","chi"},
{"低","lower, short, humble","ひく.い, ひく.める, ひく.まる","hiku.i, hiku.meru, hiku.maru","テイ","tei"},
{"都","metropolis, capital","みやこ, くに, ず, ち, づめ, みや","miyako, kuni, zu, chi, zume, miya","ト, ツ","to, tsu"},
{"便","convenience","たよ.り","tayo.ri","ベン, ビン","ben, bin"},
{"民","people, nation, subjects","たみ, ひと, み","tami, hito, mi","ミン","min"},
{"門","gates","かど, と, じょう, も","kado, to, jou, mo","モン","mon"},
{"薬","medicine, chemical, enamel, gunpowder, benefit","くすり, み","kusuri, mi","ヤク","yaku"},
{"林","grove, forest","はやし, し","hayashi, shi","リン","rin"}
};

static kanjitransInfo kanjitable_jlpt2[] = 
{
{"相","inter-, mutual, together, each other, minister of state, councillor, aspect, phase, physiognomy","あい, あ, い, おう, さ, さが, すけ","ai, a, i, ou, sa, saga, suke","ソウ, ショウ","sou, shou"},
{"愛","love, affection, favourite","いと.しい, あ, あし, え, かな, まな, めぐ, めぐみ, よし","ito.shii, a, ashi, e, kana, mana, megu, megumi, yoshi","アイ","ai"},
{"商","make a deal, selling, dealing in, merchant","あきな.う, あき","akina.u, aki","ショウ","shou"},
{"浅","shallow, superficial, frivolous, wretched, shameful","あさ.い, あざ, さ","asa.i, aza, sa","セン","sen"},
{"預","deposit, custody, leave with, entrust to","あず.ける, あず.かる","azu.keru, azu.karu","ヨ","yo"},
{"汗","sweat, perspire","あせ","ase","カン","kan"},
{"遊","play","あそ.ぶ, あそ.ばす, あす, う","aso.bu, aso.basu, asu, u","ユウ, ユ","yuu, yu"},
{"値","price, cost, value","ね, あたい, じ","ne, atai, ji","チ","chi"},
{"与","bestow, participate in, give, award, impart, provide, cause, gift, godsend","あた.える, あずか.る, くみ.する, ともに, とも, ゆ","ata.eru, azuka.ru, kumi.suru, tomoni, tomo, yu","ヨ","yo"},
{"温","warm","あたた.か, あたた.かい, あたた.まる, あたた.める, ぬく, あつ, あつし, なお, はる, ゆ, ゆたか","atata.ka, atata.kai, atata.maru, atata.meru, nuku, atsu, atsushi, nao, haru, yu, yutaka","オン","on"},
{"暖","warmth","あたた.か, あたた.かい, あたた.まる, あたた.める","atata.ka, atata.kai, atata.maru, atata.meru","ダン, ノン","dan, non"},
{"頭","head, counter for large animals","あたま, かしら, がしら, かぶり, かみ, がみ, ちゃん, つむり, づ","atama, kashira, gashira, kaburi, kami, gami, chan, tsumuri, zu","トウ, ズ, ト","tou, zu, to"},
{"辺","environs, boundary, border, vicinity","あた.り, ほと.り, べ, なべ","ata.ri, hoto.ri, be, nabe","ヘン","hen"},
{"当","hit, right, appropriate, himself","あ.たる, あ.たり, あ.てる, あ.て, まさ.に, まさ.にべし, たい","a.taru, a.tari, a.teru, a.te, masa.ni, masa.nibeshi, tai","トウ","tou"},
{"圧","pressure, push, overwhelm, oppress, dominate","お.す, へ.す, おさ.える, お.さえる","o.su, he.su, osa.eru, o.saeru","アツ, エン, オウ","atsu, en, ou"},
{"暑","sultry, hot, summer heat","あつ.い","atsu.i","ショ","sho"},
{"熱","heat, temperature, fever, mania, passion","あつ.い, あた","atsu.i, ata","ネツ","netsu"},
{"厚","thick, heavy, rich, kind, cordial, brazen, shameless","あつ.い, あか, あ, あっ","atsu.i, aka, a, aa","コウ","kou"},
{"跡","tracks, mark, print, impression","あと","ato","セキ","seki"},
{"暴","outburst, rave, fret, force, violence, cruelty, outrage","あば.く, あば.れる","aba.ku, aba.reru","ボウ, バク","bou, baku"},
{"浴","bathe, be favored with, bask in","あ.びる, あ.びせる, えき, さこ","a.biru, a.biseru, eki, sako","ヨク","yoku"},
{"危","dangerous, fear, uneasy","あぶ.ない, あや.うい, あや.ぶむ","abu.nai, aya.ui, aya.bumu","キ","ki"},
{"油","oil, fat","あぶら","abura","ユ, ユウ","yu, yuu"},
{"脂","fat, grease, tallow, lard, rosin, gum, tar","あぶら","abura","シ","shi"},
{"甘","sweet, coax, pamper, be content, sugary","あま.い, あま.える, あま.やかす, うま.い, かも","ama.i, ama.eru, ama.yakasu, uma.i, kamo","カン","kan"},
{"余","too much, myself, surplus, other, remainder","あま.る, あま.り, あま.す, あまる","ama.ru, ama.ri, ama.su, amaru","ヨ","yo"},
{"編","compilation, knit, plait, braid, twist, editing, completed poem, part of a book","あ.む, あ.み","a.mu, a.mi","ヘン","hen"},
{"過","overdo, exceed, go beyond, error","す.ぎる, す.ぎる, す.ぎ, す.ごす, あやま.つ, あやま.ち","su.giru, su.giru, su.gi, su.gosu, ayama.tsu, ayama.chi","カ","ka"},
{"誤","mistake, err, do wrong, mislead","あやま.る, あやま.る","ayama.ru, ayama.ru","ゴ","go"},
{"荒","laid waste, rough, rude, wild","あら.い, あら, あ.れる, あ.らす, あ.らし, すさ.む, ら","ara.i, ara, a.reru, a.rasu, a.rashi, susa.mu, ra","コウ","kou"},
{"洗","wash, inquire into, probe","あら.う, あらい, らい","ara.u, arai, rai","セン","sen"},
{"争","contend, dispute, argue","あらそ.う, いか.でか","araso.u, ika.deka","ソウ","sou"},
{"改","reformation, change, modify, mend, renew, examine, inspect, search","あらた.める, あらた.まる","arata.meru, arata.maru","カイ","kai"},
{"表","surface, table, chart, diagram","おもて, おもて, あらわ.す, あらわ.れる, あら.わす","omote, omote, arawa.su, arawa.reru, ara.wasu","ヒョウ","hyou"},
{"現","present, existing, actual","あらわ.れる, あらわ.す, あきら, きら","arawa.reru, arawa.su, akira, kira","ゲン","gen"},
{"著","renowned, publish, write, remarkable, phenomenal, put on, don, wear, arrival, finish (race), counter for suits of clothing, literary work","あらわ.す, いちじる.しい","arawa.su, ichijiru.shii","チョ, チャク","cho, chaku"},
{"在","exist, outskirts, suburbs, located in","あ.る, あり","a.ru, ari","ザイ","zai"},
{"暗","darkness, disappear, shade, informal, grow dark, be blinded","くら.い","kura.i","アン","an"},
{"委","committee, entrust to, leave to, devote, discard","ゆだ.ねる, まかせ","yuda.neru, makase","イ","i"},
{"衣","garment, clothes, dressing","ころも, きぬ, ぎ","koromo, kinu, gi","イ, エ","i, e"},
{"囲","surround, besiege, store, paling, enclosure, encircle, preserve, keep","かこ.む, かこ.う, かこ.い","kako.mu, kako.u, kako.i","イ","i"},
{"位","rank, grade, throne, crown, about, some","くらい, ぐらい, ぞき","kurai, gurai, zoki","イ","i"},
{"胃","stomach, paunch, crop, craw","","","イ","i"},
{"易","easy, ready to, simple, fortune-telling, divination","やさ.しい, やす.い","yasa.shii, yasu.i","エキ, イ","eki, i"},
{"移","shift, move, change, drift, catch (cold, fire), pass into","うつ.る, うつ.す","utsu.ru, utsu.su","イ","i"},
{"依","reliant, depend on, consequently, therefore, due to","よ.る, よ, より","yo.ru, yo, yori","イ, エ","i, e"},
{"偉","admirable, greatness, remarkable, conceited, famous, excellent","えら.い, ひで","era.i, hide","イ","i"},
{"違","difference, differ","ちが.う, ちが.い, ちが.える, ちが.える, たが.う, たが.える","chiga.u, chiga.i, chiga.eru, chiga.eru, taga.u, taga.eru","イ","i"},
{"怒","angry, be offended","いか.る, おこ.る","ika.ru, oko.ru","ド, ヌ","do, nu"},
{"息","breath, respiration, son, interest (on money)","いき","iki","ソク","soku"},
{"域","range, region, limits, stage, level","","","イキ","iki"},
{"勢","forces, energy, military strength","いきお.い, はずみ, せ","ikio.i, hazumi, se","セイ, ゼイ","sei, zei"},
{"幾","how many, how much, how far, how long","いく, いく.つ, いく.ら, い, く","iku, iku.tsu, iku.ra, i, ku","キ","ki"},
{"育","bring up, grow up, raise, rear","そだ.つ, そだ.ち, そだ.てる, はぐく.む, やす","soda.tsu, soda.chi, soda.teru, haguku.mu, yasu","イク","iku"},
{"戦","war, battle, match","いくさ, たたか.う, おのの.く, そよぐ, わなな.く, せ","ikusa, tataka.u, onono.ku, soyogu, wanana.ku, se","セン","sen"},
{"池","pond, cistern, pool, reservoir","いけ","ike","チ","chi"},
{"勇","courage, cheer up, be in high spirits, bravery, heroism","いさ.む, お, はや","isa.mu, o, haya","ユウ","yuu"},
{"石","stone","いし, いさ, いす, いわ, し, せっく, と","ishi, isa, isu, iwa, shi, sekku, to","セキ, シャク, コク","seki, shaku, koku"},
{"泉","spring, fountain","いずみ, いず, ずい, ずみ, ぜい, ぜん, の","izumi, izu, zui, zumi, zei, zen, no","セン","sen"},
{"忙","busy, occupied, restless","いそが.しい, せわ.しい, おそ.れる, うれえるさま","isoga.shii, sewa.shii, oso.reru, ureerusama","ボウ, モウ","bou, mou"},
{"板","plank, board, plate, stage","いた","ita","ハン, バン","han, ban"},
{"痛","pain, hurt, damage, bruise","いた.い, いた.む, いた.ましい, いた.める","ita.i, ita.mu, ita.mashii, ita.meru","ツウ","tsuu"},
{"抱","embrace, hug, hold in arms","だ.く, いだ.く, かか.える, たば","da.ku, ida.ku, kaka.eru, taba","ホウ","hou"},
{"頂","place on the head, receive, top of head, top, summit, peak","いただ.く, いただき","itada.ku, itadaki","チョウ","chou"},
{"市","market, city, town","いち, い, ち","ichi, i, chi","シ","shi"},
{"糸","thread","いと","ito","シ","shi"},
{"営","occupation, camp, perform, build, conduct (business)","いとな.む, いとな.み","itona.mu, itona.mi","エイ","ei"},
{"否","negate, no, noes, refuse, decline, deny","いな, いや","ina, iya","ヒ","hi"},
{"命","fate, command, decree, destiny, life, appoint","いのち","inochi","メイ, ミョウ","mei, myou"},
{"祈","pray, wish","いの.る, のり, れい","ino.ru, nori, rei","キ","ki"},
{"要","need, main point, essence, pivot, key to","い.る, かなめ, とし","i.ru, kaname, toshi","ヨウ","you"},
{"居","reside, to be, exist, live with","い.る, い, お.る, おき, ぐ, すえ","i.ru, i, o.ru, oki, gu, sue","キョ, コ","kyo, ko"},
{"岩","boulder, rock, cliff","いわ","iwa","ガン","gan"},
{"祝","celebrate, congratulate","いわ.う, のり, ほぎ, ゆわい","iwa.u, nori, hogi, yuwai","シュク, シュウ","shuku, shuu"},
{"引","pull, tug, jerk, admit, install, quote, refer to","ひ.く, ひ.き, ひ.き, び.き, ひ.ける, いな, ひき, ひけ, びき","hi.ku, hi.ki, hi.ki, bi.ki, hi.keru, ina, hiki, hike, biki","イン","in"},
{"印","stamp, seal, mark, imprint, symbol, emblem, trademark, evidence, souvenir, India","しるし, じるし, しる.す","shirushi, jirushi, shiru.su","イン","in"},
{"因","cause, factor, be associated with, depend on, be limited to","よ.る, ちな.む, て","yo.ru, china.mu, te","イン","in"},
{"羽","feathers, counter for birds, rabbits","は, わ, はね, しゅう, ば","ha, wa, hane, shuu, ba","ウ","u"},
{"宇","eaves, roof, house, heaven","いえ, たか, ひろ, ひろし","ie, taka, hiro, hiroshi","ウ","u"},
{"初","first time, beginning","はじ.め, はじ.めて, はつ, はつ, うい, そ.める, ぞ.め, し, はっ","haji.me, haji.mete, hatsu, hatsu, ui, so.meru, zo.me, shi, haa","ショ","sho"},
{"植","plant","う.える, う.わる, うえ, え, げ","u.eru, u.waru, ue, e, ge","ショク","shoku"},
{"伺","pay respects, visit, ask, inquire, question, implore","うかが.う","ukaga.u","シ","shi"},
{"浮","floating, float, rise to surface","う.く, う.かれる, う.かぶ, む, う.かべる, うき","u.ku, u.kareru, u.kabu, mu, u.kaberu, uki","フ","fu"},
{"受","accept, undergo, answer (phone), take, get, catch, receive","う.ける, う.け, う.かる, じょ","u.keru, u.ke, u.karu, jo","ジュ","ju"},
{"承","acquiesce, hear, listen to, be informed, receive","うけたまわ.る, う.ける, つぐ","uketamawa.ru, u.keru, tsugu","ショウ","shou"},
{"失","lose, error, fault, disadvantage, loss","うしな.う, う.せる","ushina.u, u.seru","シツ","shitsu"},
{"薄","dilute, thin, weak (tea)","うす.い, うす, うす, うす.める, うす.まる, うす.らぐ, うす.ら, うす.れる, すすき","usu.i, usu, usu, usu.meru, usu.maru, usu.ragu, usu.ra, usu.reru, susuki","ハク","haku"},
{"疑","doubt, distrust, be suspicious, question","うたが.う","utaga.u","ギ","gi"},
{"内","inside, within, between, among, house, home","うち, いと, ただ, ち, のち","uchi, ito, tada, chi, nochi","ナイ, ダイ","nai, dai"},
{"打","strike, hit, knock, pound, dozen","う.つ, う.ち, ぶ.つ, うち","u.tsu, u.chi, bu.tsu, uchi","ダ, ダアス","da, daasu"},
{"美","beauty, beautiful","うつく.しい, はる, よし, よしみ, り","utsuku.shii, haru, yoshi, yoshimi, ri","ビ, ミ","bi, mi"},
{"器","utensil, vessel, receptacle, implement, instrument, ability, container, tool, set","うつわ","utsuwa","キ","ki"},
{"腕","arm, ability, talent","うで","ude","ワン","wan"},
{"産","products, bear, give birth, yield, childbirth, native, property","う.む, う.まれる, うぶ, む.す, もと","u.mu, u.mareru, ubu, mu.su, moto","サン","san"},
{"馬","horse","うま, うま, ま, た, ばん, め, も","uma, uma, ma, ta, ban, me, mo","バ","ba"},
{"埋","bury, be filled up, embedded","う.める, う.まる, う.もれる, うず.める, うず.まる, い.ける","u.meru, u.maru, u.moreru, uzu.meru, uzu.maru, i.keru","マイ","mai"},
{"敬","awe, respect, honor, revere","うやま.う, け, たか, たかし, たけ, とし, のり, ひろ, ゆき, よし","uyama.u, ke, taka, takashi, take, toshi, nori, hiro, yuki, yoshi","ケイ, キョウ","kei, kyou"},
{"裏","back, amidst, in, reverse, inside, palm, sole, rear, lining, wrong side","うら","ura","リ","ri"},
{"占","fortune-telling, divining, forecasting, occupy, hold, have, get, take","し.める, うらな.う, うら, しむ, じめ","shi.meru, urana.u, ura, shimu, jime","セン","sen"},
{"得","gain, get, find, earn, acquire, can, may, able to, profit, advantage, benefit","え.る, う.る, あつ, てろ","e.ru, u.ru, atsu, tero","トク","toku"},
{"絵","picture, drawing, painting, sketch","","","カイ, エ","kai, e"},
{"回","-times, round, game, revolve, counter for occurrences","まわ.る, まわ.る, まわ.り, まわ.す, まわ.す, まわ.し, まわ.し, もとお.る, か.える","mawa.ru, mawa.ru, mawa.ri, mawa.su, mawa.su, mawa.shi, mawa.shi, motoo.ru, ka.eru","カイ, エ","kai, e"},
{"泳","swim","およ.ぐ","oyo.gu","エイ","ei"},
{"栄","flourish, prosperity, honor, glory, splendor","さか.える, は.え, ば.え, は.える, え, さかえ, しげ, てる, なが, ひで, よし","saka.eru, ha.e, ba.e, ha.eru, e, sakae, shige, teru, naga, hide, yoshi","エイ, ヨウ","ei, you"},
{"永","eternity, long, lengthy","なが.い, え, と, のり, ひさ, ひさし","naga.i, e, to, nori, hisa, hisashi","エイ","ei"},
{"鋭","pointed, sharpness, edge, weapon, sharp, violent","するど.い, とし","surudo.i, toshi","エイ","ei"},
{"役","duty, war, campaign, drafted labor, office, service, role","ちゃく","chaku","ヤク, エキ","yaku, eki"},
{"液","fluid, liquid, juice, sap, secretion","","","エキ","eki"},
{"枝","bough, branch, twig, limb","えだ, え, ぐさ","eda, e, gusa","シ","shi"},
{"越","surpass, cross over, move to, exceed, Vietnam","こ.す, こ.す, ご.し, こ.える, ご.え, えち, えっ, お, こえ, こし, ごえ, ごし, ごや","ko.su, ko.su, go.shi, ko.eru, go.e, echi, ee, o, koe, koshi, goe, goshi, goya","エツ, オツ","etsu, otsu"},
{"笑","laugh","わら.う, え.む, えみ","wara.u, e.mu, emi","ショウ","shou"},
{"選","elect, select, choose, prefer","えら.ぶ","era.bu","セン","sen"},
{"園","park, garden, yard, farm","その, おん, ぞの","sono, on, zono","エン","en"},
{"遠","distant, far","とお.い, お, おに, ど, どお","too.i, o, oni, do, doo","エン, オン","en, on"},
{"塩","salt","しお","shio","エン","en"},
{"演","performance, act, play, render, stage","","","エン","en"},
{"延","prolong, stretching","の.びる, の.べる, の.べ, の.ばす, たか, のぶ, のべ","no.biru, no.beru, no.be, no.basu, taka, nobu, nobe","エン","en"},
{"煙","smoke","けむ.る, けむり, けむ.い, たば","kemu.ru, kemuri, kemu.i, taba","エン","en"},
{"緒","thong, beginning, inception, end, cord, strap","お, いとぐち, ほ","o, itoguchi, ho","ショ, チョ","sho, cho"},
{"汚","dirty, pollute, disgrace, rape, defile","けが.す, けが.れる, けが.らわしい, よご.す, よご.れる, きたな.い","kega.su, kega.reru, kega.rawashii, yogo.su, yogo.reru, kitana.i","オ","o"},
{"和","harmony, Japanese style, peace, soften, Japan","やわ.らぐ, やわ.らげる, なご.む, なご.やか, あい, いず, かず, かつ, かつり, かづ, たけ, ち, とも, な, にぎ, まさ, やす, よし, より, わだこ, わっ","yawa.ragu, yawa.rageru, nago.mu, nago.yaka, ai, izu, kazu, katsu, katsuri, kazu, take, chi, tomo, na, nigi, masa, yasu, yoshi, yori, wadako, waa","ワ, オ, カ","wa, o, ka"},
{"老","old man, old age, grow old","お.いる, ふ.ける, えび, おい, び","o.iru, fu.keru, ebi, oi, bi","ロウ","rou"},
{"負","defeat, negative, -, minus, bear, owe, assume a responsibility","ま.ける, ま.かす, お.う","ma.keru, ma.kasu, o.u","フ","fu"},
{"追","chase, drive away, follow, pursue, meanwhile","お.う, おい","o.u, oi","ツイ","tsui"},
{"王","king, rule, magnate","おお, おおきみ, わ","oo, ookimi, wa","オウ, ノウ","ou, nou"},
{"黄","yellow","き, こ, うい, れい","ki, ko, ui, rei","コウ, オウ","kou, ou"},
{"央","center, middle","あきら, え, お, さと, ちか, てる, なか, ひさ, ひろ, や","akira, e, o, sato, chika, teru, naka, hisa, hiro, ya","オウ","ou"},
{"横","sideways, side, horizontal, width, woof","よこ","yoko","オウ","ou"},
{"欧","Europe","うた.う, は.く, おお, ひろ","uta.u, ha.ku, oo, hiro","オウ","ou"},
{"押","push, stop, check, subdue, attach, seize, weight, shove, press, seal, do in spite of","お.す, お.し, お.っ, お.さえる, おさ.える, おし, おす, おや","o.su, o.shi, o.., o.saeru, osa.eru, oshi, osu, oya","オウ","ou"},
{"奥","heart, interior","おく.まる, くま, お, おお, おん, つ, のく","oku.maru, kuma, o, oo, on, tsu, noku","オウ, オク","ou, oku"},
{"犯","crime, sin, offense","おか.す","oka.su","ハン, ボン","han, bon"},
{"拝","worship, adore, pray to","おが.む, おろが.む","oga.mu, oroga.mu","ハイ","hai"},
{"補","supplement, supply, make good, offset, compensate, assistant, learner","おぎな.う","ogina.u","ホ","ho"},
{"置","placement, put, set, deposit, leave behind, keep, employ, pawn","お.く, お.き, おき, おけ, き","o.ku, o.ki, oki, oke, ki","チ","chi"},
{"億","hundred million, 10**8","お","o","オク","oku"},
{"遅","slow, late, back, later","おく.れる, おく.らす, おそ.い, じ","oku.reru, oku.rasu, oso.i, ji","チ","chi"},
{"贈","presents, send, give to, award to, confer on, presenting something","おく.る","oku.ru","ゾウ, ソウ","zou, sou"},
{"幼","infancy, childhood","おさな.い, うぶ, わか","osana.i, ubu, waka","ヨウ","you"},
{"治","reign, be at peace, calm down, subdue, quell, govt, cure, heal, rule, conserve","おさ.める, おさ.まる, なお.る, なお.す, し, ぢ, はり, はる, みち","osa.meru, osa.maru, nao.ru, nao.su, shi, ji, hari, haru, michi","ジ, チ","ji, chi"},
{"収","income, obtain, reap, pay, supply, store","おさ.める, おさ.まる, のぶ","osa.meru, osa.maru, nobu","シュウ","shuu"},
{"恐","fear, dread, awe","おそ.れる, おそ.る, おそ.ろしい, こわ.い, こわ.がる","oso.reru, oso.ru, oso.roshii, kowa.i, kowa.garu","キョウ","kyou"},
{"落","fall, drop, come down","お.ちる, お.ち, お.とす, おち","o.chiru, o.chi, o.tosu, ochi","ラク","raku"},
{"夫","husband, man","おっと, そ.れ, お, と, ゆう, よ","otto, so.re, o, to, yuu, yo","フ, フウ, ブ","fu, fuu, bu"},
{"訪","call on, visit, look up, offer sympathy","おとず.れる, たず.ねる, と.う, わ","otozu.reru, tazu.neru, to.u, wa","ホウ","hou"},
{"踊","jump, dance, leap, skip","おど.る","odo.ru","ヨウ","you"},
{"各","each, every, either","おのおの, かか, かが","onoono, kaka, kaga","カク","kaku"},
{"帯","sash, belt, obi, zone, region","お.びる, おび, たて","o.biru, obi, tate","タイ","tai"},
{"覚","memorize, learn, remember, awake, sober up","おぼ.える, さ.ます, さ.める, さと.る","obo.eru, sa.masu, sa.meru, sato.ru","カク","kaku"},
{"面","mask, face, features, surface","おも, おもて, つら, お, ずら, ほおつき, も","omo, omote, tsura, o, zura, hootsuki, mo","メン, ベン","men, ben"},
{"折","fold, break, fracture, bend, yield, submit","お.る, おり, お.り, お.り, お.れる, せき","o.ru, ori, o.ri, o.ri, o.reru, seki","セツ","setsu"},
{"降","descend, precipitate, fall, surrender","お.りる, お.ろす, ふ.る, ふ.り, くだ.る, くだ.す, ふり, ふる","o.riru, o.rosu, fu.ru, fu.ri, kuda.ru, kuda.su, furi, furu","コウ, ゴ","kou, go"},
{"御","honorable, manipulate, govern","おん, お, み, う","on, o, mi, u","ギョ, ゴ","gyo, go"},
{"香","incense, smell, perfume","か, かお.り, かお.る, こ, こお, ひゃん, よし","ka, kao.ri, kao.ru, ko, koo, hyan, yoshi","コウ, キョウ","kou, kyou"},
{"科","department, course, section","しな","shina","カ","ka"},
{"化","change, take the form of, influence, enchant, delude, -ization","ば.ける, ば.かす, ふ.ける, け.する","ba.keru, ba.kasu, fu.keru, ke.suru","カ, ケ","ka, ke"},
{"荷","baggage, shoulder-pole load, bear (a burden), shoulder (a gun), load, cargo, freight","に, はす, り","ni, hasu, ri","カ","ka"},
{"加","add, addition, increase, join, include, Canada","くわ.える, くわ.わる","kuwa.eru, kuwa.waru","カ","ka"},
{"果","fruit, reward, carry out, achieve, complete, end, finish, succeed","は.たす, はた.す, は.たす, は.てる, は.てる, は.て, み","ha.tasu, hata.su, ha.tasu, ha.teru, ha.teru, ha.te, mi","カ","ka"},
{"貨","freight, goods, property","","","カ","ka"},
{"課","chapter, lesson, section, department, division, counter for chapters (of a book)","","","カ","ka"},
{"可","can, passable, mustn't, should not, do not","べ.き, べ.し, よし","be.ki, be.shi, yoshi","カ, コク","ka, koku"},
{"河","river","かわ, かっ, こ, こう","kawa, kaa, ko, kou","カ","ka"},
{"菓","candy, cakes, fruit","","","カ","ka"},
{"靴","shoes","くつ","kutsu","カ","ka"},
{"貝","shellfish","かい","kai","バイ","bai"},
{"階","storey, stair, counter for storeys of a building","きざはし, しな, と, はし","kizahashi, shina, to, hashi","カイ","kai"},
{"械","contraption, fetter, machine, instrument","かせ","kase","カイ","kai"},
{"快","cheerful, pleasant, agreeable, comfortable","こころよ.い, よし","kokoroyo.i, yoshi","カイ","kai"},
{"解","unravel, notes, key, explanation, understanding, untie, undo, solve, answer, cancel, absolve, explain, minute","と.く, と.かす, と.ける, ほど.く, ほど.ける, わか.る, さと.る, さとる, とけ","to.ku, to.kasu, to.keru, hodo.ku, hodo.keru, waka.ru, sato.ru, satoru, toke","カイ, ゲ","kai, ge"},
{"灰","ashes, puckery juice, cremate","はい","hai","カイ","kai"},
{"介","jammed in, shellfish, mediate, concern oneself with","すけ, ゆき","suke, yuki","カイ","kai"},
{"皆","all, everything","みな, みんな, むな","mina, minna, muna","カイ","kai"},
{"害","harm, injury","","","ガイ","gai"},
{"交","mingle, mixing, association, coming & going","まじ.わる, まじ.える, ま.じる, まじ.る, ま.ざる, ま.ぜる, か.う, か.わす, かわ.す, こもごも, かた","maji.waru, maji.eru, ma.jiru, maji.ru, ma.zaru, ma.zeru, ka.u, ka.wasu, kawa.su, komogomo, kata","コウ","kou"},
{"返","return, answer, fade, repay","かえ.す, かえ.す, かえ.る, かえ.る","kae.su, kae.su, kae.ru, kae.ru","ヘン","hen"},
{"省","focus, government ministry, conserve","かえり.みる, はぶ.く, さとし, み","kaeri.miru, habu.ku, satoshi, mi","セイ, ショウ","sei, shou"},
{"変","unusual, change, strange","か.わる, か.わり, か.える","ka.waru, ka.wari, ka.eru","ヘン","hen"},
{"替","exchange, spare, substitute, per-","か.える, か.え, か.わる, かえ","ka.eru, ka.e, ka.waru, kae","タイ","tai"},
{"換","interchange, period, charge, change?","か.える, か.える, か.わる","ka.eru, ka.eru, ka.waru","カン","kan"},
{"係","person in charge, connection, duty, concern oneself","かか.る, かかり, がかり, かか.わる","kaka.ru, kakari, gakari, kaka.waru","ケイ","kei"},
{"掛","hang, suspend, depend, arrive at, tax, pour","か.ける, か.ける, か.け, か.け, が.け, か.かる, か.かる, が.かる, か.かり, が.かり, かかり, がかり, かけ","ka.keru, ka.keru, ka.ke, ka.ke, ga.ke, ka.karu, ka.karu, ga.karu, ka.kari, ga.kari, kakari, gakari, kake","カイ, ケイ","kai, kei"},
{"限","limit, restrict, to best of ability","かぎ.る, かぎ.り, かぎ.り","kagi.ru, kagi.ri, kagi.ri","ゲン","gen"},
{"欠","lack, gap, fail","か.ける, か.く, あくび","ka.keru, ka.ku, akubi","ケツ, ケン","ketsu, ken"},
{"角","angle, corner, square, horn, antlers","かど, つの, い, す, すみ, ずみ, ふさ","kado, tsuno, i, su, sumi, zumi, fusa","カク","kaku"},
{"客","guest, visitor, customer, client","","","キャク, カク","kyaku, kaku"},
{"格","status, rank, capacity, character, case (law, grammar)","いたる, のり","itaru, nori","カク, コウ, キャク, ゴウ","kaku, kou, kyaku, gou"},
{"確","assurance, firm, tight, hard, solid, confirm, clear, evident","たし.か, たし.かめる","tashi.ka, tashi.kameru","カク, コウ","kaku, kou"},
{"革","leather, become serious, skin, hide, pelt","かわ","kawa","カク","kaku"},
{"額","forehead, tablet, plaque, framed picture, sum, amount, volume","ひたい, ぬか","hitai, nuka","ガク","gaku"},
{"賢","intelligent, wise, wisdom, cleverness","かしこ.い, かた, さか, さと, さとし, たか, たて, のり, まこと, まさ, まさる","kashiko.i, kata, saka, sato, satoshi, taka, tate, nori, makoto, masa, masaru","ケン","ken"},
{"数","number, strength, fate, law, figures","かず, かぞ.える, しばしば, せ.める, わずらわ.しい, じゅ","kazu, kazo.eru, shibashiba, se.meru, wazurawa.shii, ju","スウ, ス, サク, ソク, シュ","suu, su, saku, soku, shu"},
{"形","shape, form, style","かた, がた, かたち, なり, ち","kata, gata, katachi, nari, chi","ケイ, ギョウ","kei, gyou"},
{"型","mould, type, model","かた, がた","kata, gata","ケイ","kei"},
{"片","one-sided, leaf, sheet","かた, かた","kata, kata","ヘン","hen"},
{"肩","shoulder","かた","kata","ケン","ken"},
{"固","harden, set, clot, curdle","かた.める, かた.まる, かた.まり, かた.い","kata.meru, kata.maru, kata.mari, kata.i","コ","ko"},
{"難","difficult, impossible, trouble, accident, defect","かた.い, がた.い, むずか.しい, むづか.しい, むつか.しい, にく.い, な, なに","kata.i, gata.i, muzuka.shii, muzuka.shii, mutsuka.shii, niku.i, na, nani","ナン","nan"},
{"硬","stiff, hard","かた.い","kata.i","コウ","kou"},
{"堅","strict, hard, solid, tough, tight, reliable","かた.い, がた.い, きん","kata.i, gata.i, kin","ケン","ken"},
{"傾","lean, incline, tilt, trend, wane, sink, ruin, bias","かたむ.く, かたむ.ける, かたぶ.く, かた.げる, かし.げる","katamu.ku, katamu.keru, katabu.ku, kata.geru, kashi.geru","ケイ","kei"},
{"勝","victory, win, prevail, excel","か.つ, が.ち, まさ.る, すぐ.れる, かつ, かち, と, よし","ka.tsu, ga.chi, masa.ru, sugu.reru, katsu, kachi, to, yoshi","ショウ","shou"},
{"活","lively, resuscitation, being helped, living","い.きる, い.かす, い.ける","i.kiru, i.kasu, i.keru","カツ","katsu"},
{"割","proportion, comparatively, divide, cut, separate, split","わ.る, わり, わ.り, わ.れる, さ.く","wa.ru, wari, wa.ri, wa.reru, sa.ku","カツ","katsu"},
{"担","shouldering, carry, raise, bear","かつ.ぐ, にな.う","katsu.gu, nina.u","タン","tan"},
{"門","gates","かど, と, じょう, も","kado, to, jou, mo","モン","mon"},
{"悲","jail cell, grieve, sad, deplore, regret","かな.しい, かな.しむ","kana.shii, kana.shimu","ヒ","hi"},
{"必","invariably, certain, inevitable","かなら.ず","kanara.zu","ヒツ","hitsu"},
{"彼","he, that, the","かれ, かの, か.の, その","kare, kano, ka.no, sono","ヒ","hi"},
{"構","posture, build, pretend","かま.える, かま.う, とち","kama.eru, kama.u, tochi","コウ","kou"},
{"神","gods, mind, soul","かみ, かん, こう, か, かぐ, かな, かも, くま, こ, こは, だま, み","kami, kan, kou, ka, kagu, kana, kamo, kuma, ko, koha, dama, mi","シン, ジン","shin, jin"},
{"髪","hair of the head","かみ, がた, ひげ","kami, gata, hige","ハツ","hatsu"},
{"辛","spicy, bitter, hot, acrid","から.い, つら.い, づら.い, かのと","kara.i, tsura.i, zura.i, kanoto","シン","shin"},
{"枯","wither, die, dry up, be seasoned","か.れる, か.らす","ka.reru, ka.rasu","コ","ko"},
{"絡","entwine, coil around, get caught in","から.む, から.まる","kara.mu, kara.maru","ラク","raku"},
{"軽","lightly, trifling, unimportant","かる.い, かろ.やか, かろ.んじる","karu.i, karo.yaka, karo.njiru","ケイ","kei"},
{"皮","pelt, skin, hide, leather","かわ, けがわ","kawa, kegawa","ヒ","hi"},
{"側","side, lean, oppose, regret","かわ, がわ, そば","kawa, gawa, soba","ソク","soku"},
{"乾","drought, dry, dessicate, drink up, heaven, emperor","かわ.く, かわ.かす, ほ.す, ひ.る, いぬい","kawa.ku, kawa.kasu, ho.su, hi.ru, inui","カン, ケン","kan, ken"},
{"寒","cold","さむ.い, さ, さん","samu.i, sa, san","カン","kan"},
{"感","emotion, feeling, sensation","","","カン","kan"},
{"完","perfect, completion, end","","","カン","kan"},
{"官","bureaucrat, the government","","","カン","kan"},
{"管","pipe, tube, wind instrument, drunken talk","くだ, すが","kuda, suga","カン","kan"},
{"関","connection, barrier, gateway, involve, concerning","せき, ぜき, かか.わる, からくり, かんぬき","seki, zeki, kaka.waru, karakuri, kannuki","カン","kan"},
{"観","outlook, look, appearance, condition, view","み.る, しめ.す","mi.ru, shime.su","カン","kan"},
{"刊","publish, carve, engrave","","","カン","kan"},
{"慣","accustomed, get used to, become experienced","な.れる, な.らす","na.reru, na.rasu","カン","kan"},
{"干","dry, parch","ほ.す, ほ.し, ぼ.し, ひ.る, ほし","ho.su, ho.shi, bo.shi, hi.ru, hoshi","カン","kan"},
{"巻","scroll, volume, book, part, roll up, wind up, tie, coil, counter for texts (or book scrolls)","ま.く, まき, ま.き","ma.ku, maki, ma.ki","カン, ケン","kan, ken"},
{"簡","simplicity, brevity","","","カン","kan"},
{"缶","tin can, container","かま, ふ, べ, ほとぎ","kama, fu, be, hotogi","カン","kan"},
{"患","afflicted, disease, suffer from, be ill","わずら.う, くろ","wazura.u, kuro","カン","kan"},
{"丸","round, full, month, perfection, -ship, pills, make round, roll up, curl up, seduce, explain away","まる, まる.める, まる.い, ま, わ, わに","maru, maru.meru, maru.i, ma, wa, wani","ガン","gan"},
{"岸","beach","きし, けし","kishi, keshi","ガン","gan"},
{"願","petition, request, vow, wish, hope","ねが.う, ねがい, ら","nega.u, negai, ra","ガン","gan"},
{"含","include, bear in mind, understand, cherish","ふく.む, ふく.める","fuku.mu, fuku.meru","ガン","gan"},
{"記","scribe, account, narrative","しる.す, のり","shiru.su, nori","キ","ki"},
{"期","period, time, date, term","","","キ, ゴ","ki, go"},
{"希","hope, beg, request, pray, beseech, Greece, dilute (acid), rare, few, phenomenal","まれ, のぞ, のぞみ","mare, nozo, nozomi","キ, ケ","ki, ke"},
{"季","seasons","すえ, とし","sue, toshi","キ","ki"},
{"喜","rejoice, take pleasure in","よろこ.ぶ, よろこ.ばす, あき, きゅ, のぶ, ゆき, よし","yoroko.bu, yoroko.basu, aki, kyu, nobu, yuki, yoshi","キ","ki"},
{"機","mechanism, opportunity, occasion, machine, airplane","はた","hata","キ","ki"},
{"規","standard, measure","すのり, ただし, のり, み","sunori, tadashi, nori, mi","キ","ki"},
{"寄","draw near, stop in, bring near, gather, collect, send, forward","よ.る, よ.り, よ.せる, よせ, より, よろ","yo.ru, yo.ri, yo.seru, yose, yori, yoro","キ","ki"},
{"机","desk, table","つくえ","tsukue","キ","ki"},
{"議","deliberation, consultation, debate, consideration","かた, のり","kata, nori","ギ","gi"},
{"技","skill, art, craft, ability, feat, performance, vocation, arts","わざ","waza","ギ","gi"},
{"消","extinguish, blow out, turn off, neutralize, cancel","き.える, け.す","ki.eru, ke.su","ショウ","shou"},
{"利","profit, advantage, benefit","き.く, かが, と, とし, のり, み, りい","ki.ku, kaga, to, toshi, nori, mi, rii","リ","ri"},
{"効","merit, efficacy, efficiency, benefit","き.く, ききめ, なら.う","ki.ku, kikime, nara.u","コウ","kou"},
{"兆","portent, 10**12, trillion, sign, omen, symptoms","きざ.す, きざ.し","kiza.su, kiza.shi","チョウ","chou"},
{"刻","engrave, cut fine, chop, hash, mince, time, carving","きざ.む, きざ.み","kiza.mu, kiza.mi","コク","koku"},
{"築","fabricate, build, construct","きず.く, つい, つき, つく, づき","kizu.ku, tsui, tsuki, tsuku, zuki","チク","chiku"},
{"競","emulate, compete with, bid, sell at auction, bout, contest, race","きそ.う, せ.る, かい, わたなべ","kiso.u, se.ru, kai, watanabe","キョウ, ケイ","kyou, kei"},
{"喫","consume, eat, drink, smoke, receive (a blow)","","","キツ","kitsu"},
{"詰","packed, close, pressed, reprove, rebuke, blame","つ.める, つ.め, づ.め, つ.まる, つ.む, ずめ, づめ","tsu.meru, tsu.me, zu.me, tsu.maru, tsu.mu, zume, zume","キツ, キチ","kitsu, kichi"},
{"決","decide, fix, agree upon, appoint","き.める, ぎ.め, き.まる, さ.く","ki.meru, gi.me, ki.maru, sa.ku","ケツ","ketsu"},
{"君","old boy, name-suffix","きみ, ぎみ, み","kimi, gimi, mi","クン","kun"},
{"客","guest, visitor, customer, client","","","キャク, カク","kyaku, kaku"},
{"逆","inverted, reverse, opposite, wicked","さか, さか.さ, さか.らう","saka, saka.sa, saka.rau","ギャク, ゲキ","gyaku, geki"},
{"級","class, rank, grade","しな","shina","キュウ","kyuu"},
{"球","ball, sphere","たま, く","tama, ku","キュウ","kyuu"},
{"求","request, want, wish for, require, demand","もと.める","moto.meru","キュウ, グ","kyuu, gu"},
{"泣","cry, weep, moan","な.く","na.ku","キュウ","kyuu"},
{"救","salvation, save, help, rescue, reclaim","すく.う","suku.u","キュウ","kyuu"},
{"給","salary, wage, gift, allow, grant, bestow on","たま.う, たも.う, たま.え, きい","tama.u, tamo.u, tama.e, kii","キュウ","kyuu"},
{"久","long time, old story","ひさ.しい, きゅ, わ","hisa.shii, kyu, wa","キュウ, ク","kyuu, ku"},
{"旧","old times, old things, old friend, former, ex-","ふる.い, もと","furu.i, moto","キュウ","kyuu"},
{"吸","suck, imbibe, inhale, sip","す.う","su.u","キュウ","kyuu"},
{"許","permit, approve","ゆる.す, もと","yuru.su, moto","キョ","kyo"},
{"魚","fish","うお, さかな, ざかな, い","uo, sakana, zakana, i","ギョ","gyo"},
{"清","pure, purify, cleanse, exorcise, Manchu dynasty","きよ.い, きよ.まる, きよ.める, あき, さや, し, すが, すみ, せ, ちん","kiyo.i, kiyo.maru, kiyo.meru, aki, saya, shi, suga, sumi, se, chin","セイ, ショウ, シン","sei, shou, shin"},
{"橋","bridge","はし, ばせ","hashi, base","キョウ","kyou"},
{"共","together, both, neither, all, and, alike, with","とも, とも.に, ども","tomo, tomo.ni, domo","キョウ","kyou"},
{"協","co-, cooperation","","","キョウ","kyou"},
{"経","sutra, longitude, pass thru, expire, warp","へ.る, た.つ, たていと, はか.る, のり, つね, のぶ","he.ru, ta.tsu, tateito, haka.ru, nori, tsune, nobu","ケイ, キョウ","kei, kyou"},
{"境","boundary, border, region","さかい, さか, じき","sakai, saka, jiki","キョウ, ケイ","kyou, kei"},
{"供","submit, offer, present, serve (meal), accompany","そな.える, とも, ども","sona.eru, tomo, domo","キョウ, ク, クウ, グ","kyou, ku, kuu, gu"},
{"胸","bosom, breast, chest, heart, feelings","むね, むな","mune, muna","キョウ","kyou"},
{"叫","shout, exclaim, yell","さけ.ぶ","sake.bu","キョウ","kyou"},
{"況","condition, situation","まし.て, いわ.んや, おもむき","mashi.te, iwa.nya, omomuki","キョウ","kyou"},
{"狭","cramped, narrow, contract, tight","せま.い, せば.める, せば.まる, さ, はざ","sema.i, seba.meru, seba.maru, sa, haza","キョウ, コウ","kyou, kou"},
{"挟","pinch, between","はさ.む, はさ.まる, わきばさ.む, さしはさ.む","hasa.mu, hasa.maru, wakibasa.mu, sashihasa.mu","キョウ, ショウ","kyou, shou"},
{"曲","bend, music, melody, composition, pleasure, injustice, fault, curve, crooked, perverse, lean","ま.がる, ま.げる, まがた","ma.garu, ma.geru, magata","キョク","kyoku"},
{"局","bureau, board, office, affair, conclusion, court lady, lady-in-waiting, her apartment","つぼね","tsubone","キョク","kyoku"},
{"極","poles, settlement, conclusion, end, highest rank, electric poles, very, extremely, most, highly, 10**48","きわ.める, きわ.まる, きわ.まり, きわ.み, き.める, ぎ.め, き.まる","kiwa.meru, kiwa.maru, kiwa.mari, kiwa.mi, ki.meru, gi.me, ki.maru","キョク, ゴク","kyoku, goku"},
{"玉","jewel, ball","たま, たま, だま, おう, だん","tama, tama, dama, ou, dan","ギョク","gyoku"},
{"際","occasion, side, edge, verge, dangerous, adventurous, indecent, time, when","きわ, ぎわ, わ","kiwa, giwa, wa","サイ","sai"},
{"均","level, average","なら.す, ひとし","nara.su, hitoshi","キン","kin"},
{"禁","prohibition, ban, forbid","","","キン","kin"},
{"勤","diligence, become employed, serve","つと.める, づと.め, つと.まる, いそ.しむ","tsuto.meru, zuto.me, tsuto.maru, iso.shimu","キン, ゴン","kin, gon"},
{"区","ward, district","","","ク, オウ, コウ","ku, ou, kou"},
{"苦","suffering, trial, worry, hardship, feel bitter, scowl","くる.しい, ぐる.しい, くる.しむ, くる.しめる, にが.い, にが.る","kuru.shii, guru.shii, kuru.shimu, kuru.shimeru, niga.i, niga.ru","ク","ku"},
{"庫","warehouse, storehouse","くら","kura","コ, ク","ko, ku"},
{"紅","crimson, deep red","べに, くれない, あか.い, くれ, もみ","beni, kurenai, aka.i, kure, momi","コウ, ク","kou, ku"},
{"具","tool, utensil, means, possess, ingredients, counter for armor, suits, sets of furniture","そな.える, つぶさ.に, とも","sona.eru, tsubusa.ni, tomo","グ","gu"},
{"偶","accidentally, even number, couple, man & wife, same kind","たま","tama","グウ","guu"},
{"隅","corner, nook","すみ","sumi","グウ","guu"},
{"草","grass, weeds, herbs, pasture, write, draft","くさ, くさ, ぐさ, そ, や","kusa, kusa, gusa, so, ya","ソウ","sou"},
{"薬","medicine, chemical, enamel, gunpowder, benefit","くすり, み","kusuri, mi","ヤク","yaku"},
{"掘","dig, delve, excavate","ほ.る, ぼり","ho.ru, bori","クツ","kutsu"},
{"配","distribute, spouse, exile, rationing","くば.る","kuba.ru","ハイ","hai"},
{"首","neck","くび, おびと, こべ, す","kubi, obito, kobe, su","シュ","shu"},
{"組","association, braid, plait, construct, assemble, unite, cooperate, grapple","く.む, くみ, ぐみ","ku.mu, kumi, gumi","ソ","so"},
{"曇","cloudy weather, cloud up","くも.る, ど, ずみ","kumo.ru, do, zumi","ドン","don"},
{"蔵","storehouse, hide, own, have, possess","くら, おさ.める, かく.れる, くらし, くらん, くろう, さし, ざ, ろう","kura, osa.meru, kaku.reru, kurashi, kuran, kurou, sashi, za, rou","ゾウ, ソウ","zou, sou"},
{"暮","livelihood, make a living, spend time","く.れる, く.らす, ぐらし, ぐれ, ぽ","ku.reru, ku.rasu, gurashi, gure, po","ボ","bo"},
{"比","compare, race, ratio, Philipines","くら.べる, い, ぴっ","kura.beru, i, pii","ヒ","hi"},
{"訓","instruction, Japanese character reading, explanation, read","おし.える, よ.む, くん.ずる, く, くに, くの, さとし, のり, ふみ","oshi.eru, yo.mu, kun.zuru, ku, kuni, kuno, satoshi, nori, fumi","クン, キン","kun, kin"},
{"軍","army, force, troops, war, battle","","","グン","gun"},
{"群","flock, group, crowd, herd, swarm, cluster","む.れる, む.れ, むら, むら.がる, ぐり, ぐ, こお, こおり, ごうり","mu.reru, mu.re, mura, mura.garu, guri, gu, koo, koori, gouri","グン","gun"},
{"毛","fur, hair, feather, down","け, めん, も","ke, men, mo","モウ","mou"},
{"景","scenery, view","かげ","kage","ケイ","kei"},
{"警","admonish, commandment","いまし.める","imashi.meru","ケイ","kei"},
{"芸","technique, art, craft, performance, acting, trick, stunt","う.える, のり, わざ, き, げ, なり","u.eru, nori, waza, ki, ge, nari","ゲイ, ウン","gei, un"},
{"迎","welcome, meet, greet","むか.える, むかえ","muka.eru, mukae","ゲイ","gei"},
{"劇","drama, play","","","ゲキ","geki"},
{"血","blood","ち","chi","ケツ","ketsu"},
{"結","tie, bind, contract, join, organize, do up hair, fasten","むす.ぶ, ゆ.う, ゆ.わえる, ゆい, ゆう","musu.bu, yu.u, yu.waeru, yui, yuu","ケツ, ケチ","ketsu, kechi"},
{"険","precipitous, inaccessible place, impregnable position, steep place, sharp eyes","けわ.しい","kewa.shii","ケン","ken"},
{"県","prefecture","か.ける, あがた, がた","ka.keru, agata, gata","ケン","ken"},
{"件","affair, case, matter, item","くだん","kudan","ケン","ken"},
{"券","ticket","","","ケン","ken"},
{"検","examination, investigate","しら.べる","shira.beru","ケン","ken"},
{"権","authority, power, rights","おもり, かり, はか.る","omori, kari, haka.ru","ケン, ゴン","ken, gon"},
{"軒","flats, counter for houses, eaves","のき","noki","ケン","ken"},
{"原","meadow, original, primitive, field, plain, prairie, tundra, wilderness","はら, た, ばる, ら, わた, わら","hara, ta, baru, ra, wata, wara","ゲン","gen"},
{"減","dwindle, decrease, reduce, decline, curtail, get hungry","へ.る, へ.らす","he.ru, he.rasu","ゲン","gen"},
{"粉","flour, powder, dust","こ, こな","ko, kona","フン, デシメートル","fun, deshimeーtoru"},
{"戸","door","と, え, へ, とびらのと","to, e, he, tobiranoto","コ","ko"},
{"湖","lake","みずうみ, うみ, み","mizuumi, umi, mi","コ","ko"},
{"個","individual, counter for articles and military units","","","コ, カ","ko, ka"},
{"呼","call, call out to, invite","よ.ぶ, よぶ","yo.bu, yobu","コ","ko"},
{"雇","employ, hire","やと.う","yato.u","コ","ko"},
{"互","mutually, reciprocally, together","たが.い, かたみ.に","taga.i, katami.ni","ゴ","go"},
{"恋","romance, in love, yearn for, miss, darling","こ.う, こい, こい.しい","ko.u, koi, koi.shii","レン","ren"},
{"濃","concentrated, thick, dark, undiluted","こ.い, の","ko.i, no","ノウ","nou"},
{"光","ray, light","ひか.る, ひかり, あき, あきら, こお, てる, ひこ, み, みつ","hika.ru, hikari, aki, akira, koo, teru, hiko, mi, mitsu","コウ","kou"},
{"向","yonder, facing, beyond, confront, defy, tend toward, approach","む.く, む.い, む.き, む.ける, む.け, む.かう, む.かい, む.こう, む.こう, むこ, むか.い, こお, た, な, むか, むかい, むこう","mu.ku, mu.i, mu.ki, mu.keru, mu.ke, mu.kau, mu.kai, mu.kou, mu.kou, muko, muka.i, koo, ta, na, muka, mukai, mukou","コウ","kou"},
{"幸","happiness, blessing, fortune","さいわ.い, さち, しあわ.せ, こ, さき, さし, さっ, とも, ひろ, みゆき, ゆ, ゆき, よし","saiwa.i, sachi, shiawa.se, ko, saki, sashi, saa, tomo, hiro, miyuki, yu, yuki, yoshi","コウ","kou"},
{"港","harbor","みなと","minato","コウ","kou"},
{"好","fond, pleasing, like something","この.む, す.く, よ.い, い.い, こ, たか, とし, よし","kono.mu, su.ku, yo.i, i.i, ko, taka, toshi, yoshi","コウ","kou"},
{"航","navigate, sail, cruise, fly","わたる","wataru","コウ","kou"},
{"候","climate, season, weather","そうろう","sourou","コウ","kou"},
{"耕","till, plow, cultivate","たがや.す, こお","tagaya.su, koo","コウ","kou"},
{"鉱","mineral, ore","あらがね","aragane","コウ","kou"},
{"講","lecture, club, association","","","コウ","kou"},
{"更","grow late, night watch, sit up late, of course","さら, さら.に, ふ.ける, ふ.かす","sara, sara.ni, fu.keru, fu.kasu","コウ","kou"},
{"肯","agreement, consent, comply with","がえんじ.る","gaenji.ru","コウ","kou"},
{"郊","outskirts, suburbs, rural area","","","コウ","kou"},
{"号","nickname, number, item, title, pseudonym, name, call","さけ.ぶ, よびな","sake.bu, yobina","ゴウ","gou"},
{"被","incur, cover, veil, brood over, shelter, wear, put on, be exposed (film), receiving","こうむ.る, おお.う, かぶ.る, かぶ.せる, ぎぬ","koumu.ru, oo.u, kabu.ru, kabu.seru, ginu","ヒ","hi"},
{"声","voice","こえ, こわ","koe, kowa","セイ, ショウ","sei, shou"},
{"超","transcend, super-, ultra-","こ.える, こ.す, まさる, わたる","ko.eru, ko.su, masaru, wataru","チョウ","chou"},
{"氷","icicle, ice, hail, freeze, congeal","こおり, ひ, こお.る, すい","koori, hi, koo.ru, sui","ヒョウ","hyou"},
{"凍","frozen, congeal, refrigerate","こお.る, こご.える, こご.る, い.てる, し.みる, こおり","koo.ru, kogo.eru, kogo.ru, i.teru, shi.miru, koori","トウ","tou"},
{"谷","valley","たに, きわ.まる, がい, がえ, がや, せ, たり, たん, や","tani, kiwa.maru, gai, gae, gaya, se, tari, tan, ya","コク","koku"},
{"告","revelation, tell, inform, announce","つ.げる, い","tsu.geru, i","コク","koku"},
{"腰","loins, hips, waist, low wainscoting","こし, うすぐ","koshi, usugu","ヨウ","you"},
{"骨","skeleton, bone, remains, frame","ほね","hone","コツ","kotsu"},
{"断","severance, decline, refuse, apologize, warn, dismiss, prohibit, decision, judgement, cutting","た.つ, ことわ.る, さだ.める","ta.tsu, kotowa.ru, sada.meru","ダン","dan"},
{"細","dainty, get thin, taper, slender, narrow","ほそ.い, ほそ.る, こま.か, こま.かい","hoso.i, hoso.ru, koma.ka, koma.kai","サイ","sai"},
{"困","quandary, become distressed, annoyed","こま.る","koma.ru","コン","kon"},
{"込","crowded, mixture, in bulk, included, (kokuji)","","","こ.む, こ.む, こ.み, こ.み, こ.める, こみ, ごめ","ko.mu, ko.mu, ko.mi, ko.mi, ko.meru, komi, gome"},
{"米","rice, USA, metre","こめ, よね, は, べ, まべ, め, よ, よな, よの, よま","kome, yone, ha, be, mabe, me, yo, yona, yono, yoma","ベイ, マイ, メエトル","bei, mai, meetoru"},
{"殺","kill, murder, butcher, slice off, split, diminish, reduce, spoil","ころ.す, ごろ.し, そ.ぐ","koro.su, goro.shi, so.gu","サツ, サイ, セツ","satsu, sai, setsu"},
{"怖","dreadful, be frightened, fearful","こわ.い, こわ.がる, お.じる, おそ.れる","kowa.i, kowa.garu, o.jiru, oso.reru","フ, ホ","fu, ho"},
{"根","root, radical, head (pimple)","ね, ね","ne, ne","コン","kon"},
{"混","mix, blend, confuse","ま.じる, ま.じり, ま.ざる, ま.ぜる, こ.む","ma.jiru, ma.jiri, ma.zaru, ma.zeru, ko.mu","コン","kon"},
{"婚","marriage","","","コン","kon"},
{"差","distinction, difference, variation, discrepancy, margin, balance","さ.す, さ.し","sa.su, sa.shi","サ","sa"},
{"査","investigate","","","サ","sa"},
{"砂","sand","すな, いさ, ご","suna, isa, go","サ, シャ","sa, sha"},
{"再","again, twice, second time","ふたた.び, ふた","futata.bi, futa","サイ, サ","sai, sa"},
{"座","squat, seat, cushion, gathering, sit","すわ.る","suwa.ru","ザ","za"},
{"才","genius, years old, cubic shaku","","","サイ","sai"},
{"祭","ritual, offer prayers, celebrate, deify, enshrine, worship","まつ.る, まつ.り, まつり","matsu.ru, matsu.ri, matsuri","サイ","sai"},
{"菜","vegetable, side dish, greens","な, よう","na, you","サイ","sai"},
{"最","utmost, most, extreme","もっと.も, つま, も","motto.mo, tsuma, mo","サイ, シュ","sai, shu"},
{"妻","wife, spouse","つま, ずま, め","tsuma, zuma, me","サイ","sai"},
{"採","pick, take, fetch, take up","と.る","to.ru","サイ","sai"},
{"済","finish, come to an end, excusable, need not","す.む, ず.み, ずみ, す.まない, す.ます, す.ます, すく.う, な.す, わたし, わた.る, すむ, なり, わたる","su.mu, zu.mi, zumi, su.manai, su.masu, su.masu, suku.u, na.su, watashi, wata.ru, sumu, nari, wataru","サイ, セイ","sai, sei"},
{"歳","year-end, age, occasion, opportunity","とし, とせ, よわい","toshi, tose, yowai","サイ, セイ","sai, sei"},
{"財","property, money, wealth, assets","たから","takara","ザイ, サイ, ゾク","zai, sai, zoku"},
{"材","lumber, log, timber, wood, talent","き, さい","ki, sai","ザイ","zai"},
{"罪","guilt, sin, crime, fault, blame, offense","つみ","tsumi","ザイ","zai"},
{"坂","slope, incline, hill","さか, か, ざ","saka, ka, za","ハン","han"},
{"酒","sake, alcohol","さけ, さか, き, さ, し","sake, saka, ki, sa, shi","シュ","shu"},
{"探","grope, search, look for","さぐ.る, さが.す","sagu.ru, saga.su","タン","tan"},
{"捜","search, look for, locate","さが.す","saga.su","ソウ, シュ, シュウ","sou, shu, shuu"},
{"杯","counter for cupfuls, wine glass, glass, toast","さかずき","sakazuki","ハイ","hai"},
{"咲","blossom, bloom","さ.く, ざき, さ, さき","sa.ku, zaki, sa, saki","ショウ","shou"},
{"昨","yesterday, previous","","","サク","saku"},
{"冊","tome, counter for books, volume","ふみ","fumi","サツ, サク","satsu, saku"},
{"支","branch, support, sustain","ささ.える, つか.える, か.う, しんよう, じゅうまた","sasa.eru, tsuka.eru, ka.u, shinyou, juumata","シ","shi"},
{"刺","thorn, pierce, stab, prick, sting, calling card","さ.す, さ.さる, さ.し, さし, とげ","sa.su, sa.saru, sa.shi, sashi, toge","シ","shi"},
{"指","finger, point to, indicate, put into, play (chess), measure (ruler)","ゆび, さ.す, さ.し, い, いぶ, さし, さす","yubi, sa.su, sa.shi, i, ibu, sashi, sasu","シ","shi"},
{"定","determine, fix, establish, decide","さだ.める, さだ.まる, さだ.か, さた","sada.meru, sada.maru, sada.ka, sata","テイ, ジョウ","tei, jou"},
{"札","tag, paper money, counter for bonds, placard, bid","ふだ, さっ","fuda, saa","サツ","satsu"},
{"刷","printing, print","す.る, ず.り, ずり, は.く","su.ru, zu.ri, zuri, ha.ku","サツ","satsu"},
{"察","guess, presume, surmise, judge, understand","","","サツ","satsu"},
{"雑","miscellaneous","まじ.える, まじ.る","maji.eru, maji.ru","ザツ, ゾウ","zatsu, zou"},
{"様","Esq., way, manner, situation, polite suffix","さま, さん","sama, san","ヨウ, ショウ","you, shou"},
{"冷","cool, cold (beer, person), chill","つめ.たい, ひ.える, ひ.や, ひ.ややか, ひ.やす, ひ.やかす, さ.める, さ.ます","tsume.tai, hi.eru, hi.ya, hi.yayaka, hi.yasu, hi.yakasu, sa.meru, sa.masu","レイ","rei"},
{"皿","dish, a helping, plate","さら","sara","ベイ","bei"},
{"触","contact, touch, feel, hit, proclaim, announce, conflict","ふ.れる, さわ.る, さわ","fu.reru, sawa.ru, sawa","ショク","shoku"},
{"算","calculate, divining, number, abacus, probability","そろ","soro","サン","san"},
{"参","nonplussed, three, going, coming, visiting, visit, be defeated, die, be madly in love","まい.る, まい, まじわる, みつ, み","mai.ru, mai, majiwaru, mitsu, mi","サン, シン","san, shin"},
{"散","scatter, disperse, spend, squander","ち.る, ち.らす, ち.らす, ち.らかす, ち.らかる, ばら, ちる","chi.ru, chi.rasu, chi.rasu, chi.rakasu, chi.rakaru, bara, chiru","サン","san"},
{"賛","approve, praise, title or inscription on picture, assist, agree with","たす.ける, たた.える","tasu.keru, tata.eru","サン","san"},
{"残","remainder, leftover, balance","のこ.る, のこ.す, そこな.う, のこ.り","noko.ru, noko.su, sokona.u, noko.ri","ザン, サン","zan, san"},
{"次","next, order, sequence","つ.ぐ, つぎ, き, すき, つぐ, よし","tsu.gu, tsugi, ki, suki, tsugu, yoshi","ジ, シ","ji, shi"},
{"歯","tooth, cog","よわい, は, よわ.い, よわい.する","yowai, ha, yowa.i, yowai.suru","シ","shi"},
{"史","history, chronicle","あきら, あや, お, こ, ちか, とし, なか, のぶ, ひさ, ひと, ふみ","akira, aya, o, ko, chika, toshi, naka, nobu, hisa, hito, fumi","シ","shi"},
{"示","show, indicate, point out, express, display","しめ.す","shime.su","ジ, シ","ji, shi"},
{"師","expert, teacher, master, army, war","のし, のり, もろ","noshi, nori, moro","シ","shi"},
{"資","assets, resources, capital, funds, data, be conducive to, contribute to","すけ, もと","suke, moto","シ","shi"},
{"詞","part of speech, words, poetry","","","シ","shi"},
{"誌","document, records","","","シ","shi"},
{"路","path, route, road, distance","じ, みち","ji, michi","ロ, ル","ro, ru"},
{"耳","ear","みみ, がみ","mimi, gami","ジ","ji"},
{"寺","Buddhist temple","てら","tera","ジ","ji"},
{"児","newborn babe, child, young of animals","こ, こ, っこ, る","ko, ko, kko, ru","ジ, ニ, ゲイ","ji, ni, gei"},
{"辞","resign, word, term, expression","や.める, いな.む","ya.meru, ina.mu","ジ","ji"},
{"似","becoming, resemble, counterfeit, imitate, suitable","に.る, ひ.る, にた","ni.ru, hi.ru, nita","ジ","ji"},
{"除","exclude, division (x/3), remove, abolish, cancel, except","のぞ.く, よ.け","nozo.ku, yo.ke","ジョ, ジ","jo, ji"},
{"式","style, ceremony, rite, function, method, system, form, expression","のり","nori","シキ","shiki"},
{"識","discriminating, know, write","さと, さとる","sato, satoru","シキ","shiki"},
{"直","straightaway, honesty, frankness, fix, repair","ただ.ちに, なお.す, なお.す, なお.る, なお.き, す.ぐ, すぐ, なお, のう, のお","tada.chini, nao.su, nao.su, nao.ru, nao.ki, su.gu, sugu, nao, nou, noo","チョク, ジキ, ジカ","choku, jiki, jika"},
{"静","quiet","しず, しず.か, しず.まる, しず.める, しづ","shizu, shizu.ka, shizu.maru, shizu.meru, shizu","セイ, ジョウ","sei, jou"},
{"滴","drip, drop","しずく, したた.る","shizuku, shitata.ru","テキ","teki"},
{"沈","sink, be submerged, subside, be depressed, aloes","しず.む, しず.める, しん","shizu.mu, shizu.meru, shin","チン, ジン","chin, jin"},
{"湿","damp, wet, moist","しめ.る, しめ.す, うるお.う, うるお.す","shime.ru, shime.su, uruo.u, uruo.su","シツ, シュウ","shitsu, shuu"},
{"実","reality, truth","み, みの.る, まこと, まことに, みの, みち.る, ぐみ, さね","mi, mino.ru, makoto, makotoni, mino, michi.ru, gumi, sane","ジツ, シツ","jitsu, shitsu"},
{"島","island","しま","shima","トウ","tou"},
{"閉","closed, shut","と.じる, と.ざす, し.める, し.まる, た.てる, へ","to.jiru, to.zasu, shi.meru, shi.maru, ta.teru, he","ヘイ","hei"},
{"捨","discard, throw away, abandon, resign, reject, sacrifice","す.てる","su.teru","シャ","sha"},
{"昔","once upon a time, antiquity, old times","むかし","mukashi","セキ, シャク","seki, shaku"},
{"弱","weak, frail","よわ.い, よわ.る, よわ.まる, よわ.める","yowa.i, yowa.ru, yowa.maru, yowa.meru","ジャク","jaku"},
{"若","young, if, perhaps, possibly, low number, immature","わか.い, わか, も.しくわ, も.し, も.しくは, わく, わこ","waka.i, waka, mo.shikuwa, mo.shi, mo.shikuha, waku, wako","ジャク, ニャク, ニャ","jaku, nyaku, nya"},
{"守","guard, protect, defend, obey","まも.る, まも.り, もり, もり, かみ, う, し, も, て","mamo.ru, mamo.ri, mori, mori, kami, u, shi, mo, te","シュ, ス","shu, su"},
{"取","take, fetch, take up","と.る, と.り, と.り, とり, ど.り, どる","to.ru, to.ri, to.ri, tori, do.ri, doru","シュ","shu"},
{"種","species, kind, class, variety, seed","たね, ぐさ, おい, くさ, た, ほ","tane, gusa, oi, kusa, ta, ho","シュ","shu"},
{"州","state, province","す, くに","su, kuni","シュウ, ス","shuu, su"},
{"拾","pick up, gather, find, go on foot, ten","ひろ.う","hiro.u","シュウ, ジュウ","shuu, juu"},
{"周","circumference, circuit, lap","まわ.り, あまね, しゅ, す, ちか, のり, ひろ, びび, まこと","mawa.ri, amane, shu, su, chika, nori, hiro, bibi, makoto","シュウ","shuu"},
{"船","ship, boat","ふね, ふな, ふ","fune, funa, fu","セン","sen"},
{"柔","tender, weakness, gentleness, softness","やわ.らか, やわ.らかい, やわ, やわ.ら, とお","yawa.raka, yawa.rakai, yawa, yawa.ra, too","ジュウ, ニュウ","juu, nyuu"},
{"宿","inn, lodging, relay station, dwell, lodge, be pregnant, home, dwelling","やど, やど.る, やど.す, すく, ぶすき, やけ","yado, yado.ru, yado.su, suku, busuki, yake","シュク","shuku"},
{"述","mention, state, speak, relate","の.べる","no.beru","ジュツ","jutsu"},
{"術","art, technique, skill, means, trick, resources, magic","すべ","sube","ジュツ","jutsu"},
{"順","obey, order, turn, right, docility, occasion","あや, あり, おき, おさむ, しげ, したがう, とし, なお, のぶ, のり, まさ, むね, もと, ゆき, よし, より","aya, ari, oki, osamu, shige, shitagau, toshi, nao, nobu, nori, masa, mune, moto, yuki, yoshi, yori","ジュン","jun"},
{"準","semi-, correspond to, proportionate to, conform, imitate","じゅん.じる, じゅん.ずる, なぞら.える, のり, ひと.しい, みずもり","jun.jiru, jun.zuru, nazora.eru, nori, hito.shii, mizumori","ジュン","jun"},
{"純","genuine, purity, innocence, net (profit)","あつ, すみ, み, やすし, よし","atsu, sumi, mi, yasushi, yoshi","ジュン","jun"},
{"所","place","ところ, ところ, どころ, とこ, せ","tokoro, tokoro, dokoro, toko, se","ショ","sho"},
{"処","dispose, manage, deal with, sentence, condemn, act, behave, place","ところ, こ, お.る","tokoro, ko, o.ru","ショ","sho"},
{"署","signature, govt office, police station","","","ショ","sho"},
{"諸","various, many, several, together","もろ","moro","ショ","sho"},
{"助","help, rescue, assist","たす.ける, たす.かる, す.ける, すけ","tasu.keru, tasu.karu, su.keru, suke","ジョ","jo"},
{"章","badge, chapter, composition, poem, design","あき, あきら, あや, ふみ","aki, akira, aya, fumi","ショウ","shou"},
{"焼","bake, burning","や.く, や.き, や.き, や.き, や.ける, やい, やき","ya.ku, ya.ki, ya.ki, ya.ki, ya.keru, yai, yaki","ショウ","shou"},
{"象","elephant, pattern after, imitate, image, shape, sign (of the times)","かたど.る, きさ","katado.ru, kisa","ショウ, ゾウ","shou, zou"},
{"照","illuminate, shine, compare, bashful","て.る, て.らす, て.れる, あき, てる","te.ru, te.rasu, te.reru, aki, teru","ショウ","shou"},
{"賞","prize, reward, praise","ほ.める","ho.meru","ショウ","shou"},
{"招","beckon, invite, summon, engage","まね.く","mane.ku","ショウ","shou"},
{"性","sex, gender, nature","さが","saga","セイ, ショウ","sei, shou"},
{"将","leader, commander, general, admiral, or, and again, soon, from now on, just about","まさ.に, はた, まさ, ひきい.る, もって, かつ, かつり, すすむ, たか, ゆき","masa.ni, hata, masa, hikii.ru, motte, katsu, katsuri, susumu, taka, yuki","ショウ, ソウ","shou, sou"},
{"装","attire, dress, pretend, disguise, profess","よそお.う, よそお.い","yosoo.u, yosoo.i","ソウ, ショウ","sou, shou"},
{"召","seduce, call, send for, wear, put on, ride in, buy, eat, drink, catch (cold)","め.す","me.su","ショウ","shou"},
{"床","bed, floor, padding, tatami","とこ, ゆか","toko, yuka","ショウ","shou"},
{"姓","surname","","","セイ, ショウ","sei, shou"},
{"昇","rise up","のぼ.る, しゅう, のり","nobo.ru, shuu, nori","ショウ","shou"},
{"紹","introduce, inherit, help","つぐ","tsugu","ショウ","shou"},
{"星","star, spot, dot, mark","ほし, ぼし","hoshi, boshi","セイ, ショウ","sei, shou"},
{"政","politics, government","まつりごと, まん, ただ, まさ","matsurigoto, man, tada, masa","セイ, ショウ","sei, shou"},
{"精","refined, ghost, fairy, energy, vitality, semen, excellence, purity, skill","きよ","kiyo","セイ, ショウ, シヤウ","sei, shou, shiyau"},
{"乗","ride, power, multiplication, record, counter for vehicles, board, mount, join","の.る, の.り, の.せる, のり","no.ru, no.ri, no.seru, nori","ジョウ, ショウ","jou, shou"},
{"状","status quo, conditions, circumstances, form, appearance","","","ジョウ","jou"},
{"常","usual, ordinary, normal, regular","つね, とこ, とき, のぶ, ひ, ひた","tsune, toko, toki, nobu, hi, hita","ジョウ","jou"},
{"情","feelings, emotion, passion, sympathy, circumstances, facts","なさ.け","nasa.ke","ジョウ, セイ","jou, sei"},
{"城","castle","しろ, いく, がき, き, くに, ぐしく, ぐすく, しき, すく, ぜい, たち, なり","shiro, iku, gaki, ki, kuni, gushiku, gusuku, shiki, suku, zei, tachi, nari","ジョウ","jou"},
{"蒸","steam, heat, sultry, foment, get musty","む.す, む.れる, む.らす","mu.su, mu.reru, mu.rasu","ジョウ, セイ","jou, sei"},
{"畳","tatami mat, counter for tatami mats, fold, shut up, do away with","たた.む, たたみ, かさ.なる","tata.mu, tatami, kasa.naru","ジョウ, チョウ","jou, chou"},
{"成","turn into, become, get, grow, elapse, reach","な.る, な.す, な.す, あき, あきら, しげ, そん, たえ, なお, なり, なる, のり, ひら, まさ, よし, り","na.ru, na.su, na.su, aki, akira, shige, son, tae, nao, nari, naru, nori, hira, masa, yoshi, ri","セイ, ジョウ","sei, jou"},
{"職","post, employment, work","もと","moto","ショク, ソク","shoku, soku"},
{"調","tune, tone, meter, key (music), writing style, prepare, exorcise, investigate","しら.べる, しら.べ, ととの.う, ととの.える, ぎ, つぎ","shira.beru, shira.be, totono.u, totono.eru, gi, tsugi","チョウ","chou"},
{"退","retreat, withdraw, retire, resign, repel, expel, reject","しりぞ.く, しりぞ.ける, ひ.く, の.く, の.ける, ど.く","shirizo.ku, shirizo.keru, hi.ku, no.ku, no.keru, do.ku","タイ","tai"},
{"森","forest, woods","もり, もと","mori, moto","シン","shin"},
{"申","have the honor to, sign of the monkey, 3-5PM, ninth sign of Chinese zodiac","もう.す, もう.し, さる","mou.su, mou.shi, saru","シン","shin"},
{"身","somebody, person, one's station in life","み","mi","シン","shin"},
{"深","deep, heighten, intensify, strengthen","ふか.い, ぶか.い, ふか.まる, ふか.める, み","fuka.i, buka.i, fuka.maru, fuka.meru, mi","シン","shin"},
{"進","advance, proceed, progress, promote","すす.む, すす.める, のぶ","susu.mu, susu.meru, nobu","シン","shin"},
{"臣","retainer, subject","おみ, たか, と, とみ, み","omi, taka, to, tomi, mi","シン, ジン","shin, jin"},
{"信","faith, truth, fidelity, trust","し, しが, しな, しの, しぶ, とき, のび, のぶ, まこと","shi, shiga, shina, shino, shibu, toki, nobi, nobu, makoto","シン","shin"},
{"針","needle, pin, staple, stinger","はり, は","hari, ha","シン","shin"},
{"伸","expand, stretch, extend, lengthen, increase","の.びる, の.ばす, の.べる, の.す, のぶ, よぼる","no.biru, no.basu, no.beru, no.su, nobu, yoboru","シン","shin"},
{"寝","lie down, sleep, rest, bed, remain unsold","ね.る, ね.かす, い.ぬ, みたまや, や.める","ne.ru, ne.kasu, i.nu, mitamaya, ya.meru","シン","shin"},
{"震","quake, shake, tremble, quiver, shiver","ふる.う, ふる.える","furu.u, furu.eru","シン","shin"},
{"吹","blow, breathe, puff, emit, smoke","ふ.く, ふき","fu.ku, fuki","スイ","sui"},
{"末","end, close, tip, powder, posterity","すえ","sue","マツ, バツ","matsu, batsu"},
{"優","tenderness, excel, surpass, actor, superiority, gentleness","やさ.しい, すぐ.れる, まさ.る, ゆ, よし","yasa.shii, sugu.reru, masa.ru, yu, yoshi","ユウ, ウ","yuu, u"},
{"涼","refreshing, nice and cool","すず.しい, すず.む, すず.やか, うす.い, ひや.す, まことに, りょ","suzu.shii, suzu.mu, suzu.yaka, usu.i, hiya.su, makotoni, ryo","リョウ","ryou"},
{"炭","charcoal, coal","すみ","sumi","タン","tan"},
{"速","quick, fast","はや.い, はや, はや.める, すみ.やか, わ","haya.i, haya, haya.meru, sumi.yaka, wa","ソク","soku"},
{"背","stature, height, back, behind, disobey, defy, go back on, rebel","せ, せい, そむ.く, そむ.ける","se, sei, somu.ku, somu.keru","ハイ","hai"},
{"晴","clear up","は.れる, は.れ, は.れ, ば.れ, は.らす, はる, はれ","ha.reru, ha.re, ha.re, ba.re, ha.rasu, haru, hare","セイ","sei"},
{"制","system, law, rule","","","セイ","sei"},
{"製","made in..., manufacture","...","...","セイ..","sei.."},
{"税","tax, duty","さい","sai","ゼイ","zei"},
{"説","rumor, opinion, theory","と.く, さとし, とき","to.ku, satoshi, toki","セツ, ゼイ","setsu, zei"},
{"席","seat, mat, occasion, place","むしろ","mushiro","セキ","seki"},
{"積","volume, product (x*y), acreage, contents, pile up, stack, load, amass","つ.む, づ.み, つ.もる, つ.もり, か, さか, しゃこ, ずみ, つみ","tsu.mu, zu.mi, tsu.moru, tsu.mori, ka, saka, shako, zumi, tsumi","セキ","seki"},
{"責","blame, condemn, censure","せ.める","se.meru","セキ","seki"},
{"績","exploits, unreeling cocoons","み","mi","セキ","seki"},
{"隻","vessels, counter for ships, fish, birds, arrows, one of a pair","","","セキ","seki"},
{"籍","enroll, domiciliary register, membership","","","セキ","seki"},
{"雪","snow","ゆき, せっ, ぶき","yuki, see, buki","セツ","setsu"},
{"設","establishment, provision, prepare","もう.ける, した","mou.keru, shita","セツ","setsu"},
{"接","touch, contact, adjoin, piece together","つ.ぐ","tsu.gu","セツ, ショウ","setsu, shou"},
{"絶","discontinue, beyond, sever, cut off, abstain, interrupt, suppress","た.える, た.やす, た.つ","ta.eru, ta.yasu, ta.tsu","ゼツ","zetsu"},
{"線","line, track","すじ","suji","セン","sen"},
{"専","specialty, exclusive, mainly, solely","もっぱ.ら","moppa.ra","セン","sen"},
{"全","whole, entire, all, complete, fulfill","まった.く, すべ.て, たけ, まさ","matta.ku, sube.te, take, masa","ゼン","zen"},
{"然","sort of thing, so, if so, in that case, well","しか, しか.り, しか.し, さ","shika, shika.ri, shika.shi, sa","ゼン, ネン","zen, nen"},
{"祖","ancestor, pioneer, founder","い","i","ソ","so"},
{"想","concept, think, idea, thought","おも.う","omo.u","ソウ, ソ","sou, so"},
{"総","general, whole, all, full, total","す.べて, すべ.て, ふさ, うさ, ずさ","su.bete, sube.te, fusa, usa, zusa","ソウ","sou"},
{"窓","window, pane","まど, てんまど, けむだし","mado, tenmado, kemudashi","ソウ, ス","sou, su"},
{"層","stratum, social class, layer, story, floor","","","ソウ","sou"},
{"双","pair, set, comparison, counter for pairs","ふた, たぐい, ならぶ, ふたつ, ふ","futa, tagui, narabu, futatsu, fu","ソウ","sou"},
{"掃","sweep, brush","は.く, か","ha.ku, ka","ソウ, シュ","sou, shu"},
{"燥","parch, dry up","はしゃ.ぐ","hasha.gu","ソウ","sou"},
{"造","create, make, structure, physique","つく.る, つく.り, づく.り, ずくり, づくり, み","tsuku.ru, tsuku.ri, zuku.ri, zukuri, zukuri, mi","ゾウ","zou"},
{"増","increase, add, augment, gain, promote","ま.す, ま.し, ふ.える, ふ.やす, まし, ます","ma.su, ma.shi, fu.eru, fu.yasu, mashi, masu","ゾウ","zou"},
{"像","statue, picture, image, figure, portrait","かた","kata","ゾウ","zou"},
{"臓","entrails, viscera, bowels","はらわた","harawata","ゾウ","zou"},
{"憎","hate, detest","にく.む, にく.い, にく.らしい, にく.しみ","niku.mu, niku.i, niku.rashii, niku.shimi","ゾウ","zou"},
{"束","bundle, sheaf, ream, tie in bundles, govern, manage, control","たば, たば.ねる, つか, つか.ねる","taba, taba.neru, tsuka, tsuka.neru","ソク","soku"},
{"則","rule, follow, based on, model after","のっと.る, のり","notto.ru, nori","ソク","soku"},
{"測","fathom, plan, scheme, measure","はか.る","haka.ru","ソク","soku"},
{"続","continue, series, sequel","つづ.く, つづ.ける, つぐ.ない, つぐ","tsuzu.ku, tsuzu.keru, tsugu.nai, tsugu","ゾク, ショク, コウ, キョウ","zoku, shoku, kou, kyou"},
{"底","bottom, sole, depth, bottom price, base, kind, sort","そこ","soko","テイ","tei"},
{"損","damage, loss, disadvantage, hurt, injure","そこ.なう, そこな.う, そこ.なう, そこ.ねる, そこ.ねる","soko.nau, sokona.u, soko.nau, soko.neru, soko.neru","ソン","son"},
{"卒","graduate, soldier, private, die","そっ.する, お.える, お.わる, ついに, にわか","soo.suru, o.eru, o.waru, tsuini, niwaka","ソツ, シュツ","sotsu, shutsu"},
{"率","ratio, rate, proportion, %, coefficient, factor","ひき.いる","hiki.iru","ソツ, リツ, シュツ","sotsu, ritsu, shutsu"},
{"備","equip, provision, preparation","そな.える, そな.わる, つぶさ.に, びっ, びん","sona.eru, sona.waru, tsubusa.ni, bii, bin","ビ","bi"},
{"反","anti-","そ.る, そ.らす, かえ.す, かえ.る, かえ.る, そり, た","so.ru, so.rasu, kae.su, kae.ru, kae.ru, sori, ta","ハン, ホン, タン, ホ","han, hon, tan, ho"},
{"村","town, village","むら, え, むた, ら","mura, e, muta, ra","ソン","son"},
{"孫","grandchild, descendants","まご, ひ","mago, hi","ソン","son"},
{"存","suppose, be aware of, believe, feel","まさ","masa","ソン, ゾン","son, zon"},
{"尊","revered, valuable, precious, noble, exalted","たっと.い, とうと.い, たっと.ぶ, とうと.ぶ, さだ, たか, たけ, みこと","tatto.i, touto.i, tatto.bu, touto.bu, sada, taka, take, mikoto","ソン","son"},
{"太","plump, thick, big around","ふと.い, ふと.る, おお, たか, ひろ","futo.i, futo.ru, oo, taka, hiro","タイ, タ","tai, ta"},
{"袋","sack, bag, pouch","ふくろ, てい, ない, ぶく","fukuro, tei, nai, buku","タイ, ダイ","tai, dai"},
{"第","No., residence","","","ダイ, テイ","dai, tei"},
{"平","even, flat, peace","たい.ら, だいら, ひら, ひら, たいら, たら, はち, ひ, ひとし, へ, へん","tai.ra, daira, hira, hira, taira, tara, hachi, hi, hitoshi, he, hen","ヘイ, ビョウ, ヒョウ","hei, byou, hyou"},
{"倒","overthrow, fall, collapse, drop, break down","たお.れる, だお.れ, たお.す","tao.reru, dao.re, tao.su","トウ","tou"},
{"宝","treasure, wealth, valuables","たから, ほ","takara, ho","ホウ","hou"},
{"宅","home, house, residence, our house, my husband","け, たか, たけ, や, やけ","ke, taka, take, ya, yake","タク","taku"},
{"濯","laundry, wash, pour on, rinse","すす.ぐ, ゆす.ぐ","susu.gu, yusu.gu","タク","taku"},
{"竹","bamboo","たけ, たか","take, taka","チク","chiku"},
{"達","accomplished, reach, arrive, attain","たち, かつ, さと, て, てつ, とおる, みち","tachi, katsu, sato, te, tetsu, tooru, michi","タツ, ダ","tatsu, da"},
{"例","example, custom, usage, precedent","たと.える","tato.eru","レイ","rei"},
{"頼","trust, request","たの.む, たの.もしい, たよ.る, よち, より","tano.mu, tano.moshii, tayo.ru, yochi, yori","ライ","rai"},
{"卵","egg, ovum, spawn, roe","たまご","tamago","ラン","ran"},
{"民","people, nation, subjects","たみ, ひと, み","tami, hito, mi","ミン","min"},
{"便","convenience","たよ.り","tayo.ri","ベン, ビン","ben, bin"},
{"短","short, brevity, fault, defect, weak point","みじか.い","mijika.i","タン","tan"},
{"単","simple, one, single, merely","ひとえ","hitoe","タン","tan"},
{"談","discuss, talk","","","ダン","dan"},
{"段","grade, steps, stairs","","","ダン, タン","dan, tan"},
{"乳","milk, breasts","ちち, ち","chichi, chi","ニュウ","nyuu"},
{"恥","shame, dishonor","は.じる, はじ, は.じらう, は.ずかしい","ha.jiru, haji, ha.jirau, ha.zukashii","チ","chi"},
{"畜","livestock, domestic fowl and animals","","","チク","chiku"},
{"虫","insect, bug, temper","むし, む","mushi, mu","チュウ, キ","chuu, ki"},
{"柱","pillar, post, cylinder, support","はしら","hashira","チュウ","chuu"},
{"仲","go-between, relationship","なか, ちゅん, つづき, なかつ","naka, chun, tsuzuki, nakatsu","チュウ","chuu"},
{"宙","mid-air, air, space, sky, memorization, interval of time","ひろ, ゆ","hiro, yu","チュウ","chuu"},
{"駐","stop-over, reside in, resident","","","チュウ","chuu"},
{"貯","savings, store, lay in, keep, wear mustache","た.める, たくわ.える","ta.meru, takuwa.eru","チョ","cho"},
{"庁","government office","やくしょ","yakusho","チョウ, テイ","chou, tei"},
{"珍","rare, curious, strange","めずら.しい, たから, じん","mezura.shii, takara, jin","チン","chin"},
{"都","metropolis, capital","みやこ, くに, ず, ち, づめ, みや","miyako, kuni, zu, chi, zume, miya","ト, ツ","to, tsu"},
{"費","expense, cost, spend, consume, waste","つい.やす, つい.える","tsui.yasu, tsui.eru","ヒ","hi"},
{"捕","catch, capture","と.らえる, と.らわれる, と.る, とら.える, とら.われる, つか.まえる, つか.まる","to.raeru, to.rawareru, to.ru, tora.eru, tora.wareru, tsuka.maeru, tsuka.maru","ホ","ho"},
{"疲","exhausted, tire, weary","つか.れる, づか.れ, つか.らす","tsuka.reru, zuka.re, tsuka.rasu","ヒ","hi"},
{"付","adhere, attach, refer to, append","つ.ける, つ.ける, づ.ける, つ.け, つ.け, つ.け, づ.け, づけ, つ.く, づ.く, つ.き, つ.き, つき, づ.き, づき, つけ","tsu.keru, tsu.keru, zu.keru, tsu.ke, tsu.ke, tsu.ke, zu.ke, zuke, tsu.ku, zu.ku, tsu.ki, tsu.ki, tsuki, zu.ki, zuki, tsuke","フ","fu"},
{"突","stab, protruding, thrusting, thrust, pierce, prick","つ.く","tsu.ku","トツ, カ","totsu, ka"},
{"包","wrap, pack up, cover, conceal","つつ.む, くる.む, お, かね","tsutsu.mu, kuru.mu, o, kane","ホウ","hou"},
{"努","toil, diligent, as much as possible","つと.める","tsuto.meru","ド","do"},
{"務","task, duties","つと.める, つかさ, み","tsuto.meru, tsukasa, mi","ム","mu"},
{"募","recruit, campaign, gather (contributions), enlist, grow violent","つの.る","tsuno.ru","ボ","bo"},
{"粒","grains, drop, counter for tiny particles","つぶ","tsubu","リュウ","ryuu"},
{"連","take along, lead, join, connect, party, gang, clique","つら.なる, つら.ねる, つ.れる, づ.れ, ずれ, つれ, むらじ, れ","tsura.naru, tsura.neru, tsu.reru, zu.re, zure, tsure, muraji, re","レン","ren"},
{"庭","courtyard, garden, yard","にわ, ば","niwa, ba","テイ","tei"},
{"低","lower, short, humble","ひく.い, ひく.める, ひく.まる","hiku.i, hiku.meru, hiku.maru","テイ","tei"},
{"停","halt, stopping","と.める, と.まる","to.meru, to.maru","テイ","tei"},
{"程","extent, degree, law, formula, distance, limits, amount","ほど, ほど, ほと","hodo, hodo, hoto","テイ","tei"},
{"泥","mud, mire, adhere to, be attached to","どろ, ひじ","doro, hiji","デイ, ナイ, デ, ニ","dei, nai, de, ni"},
{"的","bull's eye, mark, target, object, adjective ending","まと, いくは, ゆくは","mato, ikuha, yukuha","テキ","teki"},
{"適","suitable, occasional, rare, qualified, capable","かな.う","kana.u","テキ","teki"},
{"鉄","iron","くろがね, けん, てっ","kurogane, ken, tee","テツ","tetsu"},
{"点","spot, point, mark, speck, decimal point","つ.ける, つ.く, た.てる, さ.す, とぼ.す, とも.す, ぼち","tsu.keru, tsu.ku, ta.teru, sa.su, tobo.su, tomo.su, bochi","テン","ten"},
{"殿","Mr., hall, mansion, palace, temple, lord","との, どの, て, どん","tono, dono, te, don","デン, テン","den, ten"},
{"登","ascend, climb up","のぼ.る, あ.がる, たか, のぼし, のぼり, のり","nobo.ru, a.garu, taka, noboshi, nobori, nori","トウ, ト, ドウ, ショウ, チョウ","tou, to, dou, shou, chou"},
{"徒","junior, emptiness, vanity, futility, uselessness, ephemeral thing, gang, set, party, people","いたずら, あだ, かち","itazura, ada, kachi","ト","to"},
{"途","route, way, road","みち","michi","ト","to"},
{"渡","transit, ford, ferry, cross, import, deliver, diameter, migrate","わた.る, わた.る, わた.す, お, たり, わたな, わたら, わたり","wata.ru, wata.ru, wata.su, o, tari, watana, watara, watari","ト","to"},
{"塗","paint, plaster, daub, smear, coating","ぬ.る, ぬ.り, まみ.れる","nu.ru, nu.ri, mami.reru","ト","to"},
{"投","throw, discard, abandon, launch into, join, invest in, hurl, give up, sell at a loss","な.げる, な.げ","na.geru, na.ge","トウ","tou"},
{"等","etc., and so forth, class (first), quality, equal, similar","ひと.しい, など, ら, と, ひ","hito.shii, nado, ra, to, hi","トウ","tou"},
{"湯","hot water, bath, hot spring","ゆ","yu","トウ","tou"},
{"灯","lamp, a light, light, counter for lights","ひ, ほ, ともしび, とも.す, あかり","hi, ho, tomoshibi, tomo.su, akari","トウ","tou"},
{"党","party, faction, clique","なかま, むら","nakama, mura","トウ","tou"},
{"到","arrival, proceed, reach, attain, result in","いた.る","ita.ru","トウ","tou"},
{"逃","escape, flee, shirk, evade, set free","に.げる, に.がす, のが.す, のが.れる","ni.geru, ni.gasu, noga.su, noga.reru","トウ","tou"},
{"盗","steal, rob, pilfer","ぬす.む, ぬす.み","nusu.mu, nusu.mi","トウ","tou"},
{"筒","cylinder, pipe, tube, gun barrel, sleeve","つつ","tsutsu","トウ","tou"},
{"塔","pagoda, tower, steeple","","","トウ","tou"},
{"童","juvenile, child","わらべ, ぱ","warabe, pa","ドウ","dou"},
{"働","work, (kokuji)","はたら.く","hatara.ku","ドウ, リュク, リキ, ロク, リョク","dou, ryuku, riki, roku, ryoku"},
{"銅","copper","あかがね","akagane","ドウ","dou"},
{"導","guidance, leading, conduct, usher","みちび.く, みち","michibi.ku, michi","ドウ","dou"},
{"溶","melt, dissolve, thaw","と.ける, と.かす, と.く","to.keru, to.kasu, to.ku","ヨウ","you"},
{"毒","poison, virus, venom, germ, harm, injury, spite","","","ドク","doku"},
{"独","single, alone, spontaneously, Germany","ひと.り, どいつ, どっ","hito.ri, doitsu, doo","ドク, トク","doku, toku"},
{"届","deliver, reach, arrive, report, notify, forward","とど.ける, とど.け, とど.く","todo.keru, todo.ke, todo.ku","カイ","kai"},
{"飛","fly, skip (pages), scatter","と.ぶ, と.ばす, と.ばす, あす, とび","to.bu, to.basu, to.basu, asu, tobi","ヒ","hi"},
{"留","detain, fasten, halt, stop","と.める, と.まる, とど.める, とど.まる, るうぶる, とめ","to.meru, to.maru, todo.meru, todo.maru, ruuburu, tome","リュウ, ル","ryuu, ru"},
{"泊","overnight, put up at, ride at anchor, 3-day stay","と.まる, と.める, とまり, はつ","to.maru, to.meru, tomari, hatsu","ハク","haku"},
{"富","wealth, enrich, abundant","と.む, とみ, と, とん, ふっ","to.mu, tomi, to, ton, fuu","フ, フウ","fu, fuu"},
{"鈍","dull, slow, foolish, blunt","にぶ.い, にぶ.る, にぶ, なま.る, なまく.ら","nibu.i, nibu.ru, nibu, nama.ru, namaku.ra","ドン","don"},
{"無","nothingness, none, ain't, nothing, nil, not","な.い","na.i","ム, ブ","mu, bu"},
{"亡","deceased, the late, dying, perish","な.い, な.き, ほろ.びる, ほろ.ぶ, ほろ.ぼす","na.i, na.ki, horo.biru, horo.bu, horo.bosu","ボウ, モウ","bou, mou"},
{"流","current, a sink, flow, forfeit","なが.れる, なが.れ, なが.す, なが.す, な, ながれ, めぐる","naga.reru, naga.re, naga.su, naga.su, na, nagare, meguru","リュウ, ル","ryuu, ru"},
{"鳴","chirp, cry, bark, sound, ring, echo, honk","な.く, な.る, な.らす, なり, なる","na.ku, na.ru, na.rasu, nari, naru","メイ","mei"},
{"波","waves, billows, Poland","なみ, ひら, みな, みなみ, わ","nami, hira, mina, minami, wa","ハ","ha"},
{"並","row, and, besides, as well as, line up, rank with, rival, equal","な.み, なら.べる, なら.ぶ, なら.びに, なび","na.mi, nara.beru, nara.bu, nara.bini, nabi","ヘイ, ホウ","hei, hou"},
{"涙","tears, sympathy","なみだ","namida","ルイ, レイ","rui, rei"},
{"悩","trouble, worry, in pain, distress, illness","なや.む, なや.ます, なや.ましい, なやみ","naya.mu, naya.masu, naya.mashii, nayami","ノウ","nou"},
{"軟","soft","やわ.らか, やわ.らかい","yawa.raka, yawa.rakai","ナン","nan"},
{"任","responsibility, duty, term, entrust to, appoint","まか.せる, まか.す, さ, とう, ひで","maka.seru, maka.su, sa, tou, hide","ニン","nin"},
{"認","acknowledge, witness, discern, recognize, appreciate, believe","みと.める, したた.める","mito.meru, shitata.meru","ニン","nin"},
{"抜","slip out, extract, pull out, pilfer, quote, remove, omit","ぬ.く, ぬ.く, ぬ.き, ぬ.ける, ぬ.かす, ぬ.かる, ぬき","nu.ku, nu.ku, nu.ki, nu.keru, nu.kasu, nu.karu, nuki","バツ, ハツ, ハイ","batsu, hatsu, hai"},
{"布","linen, cloth","ぬの, う, の, ほ","nuno, u, no, ho","フ","fu"},
{"猫","cat","ねこ","neko","ビョウ","byou"},
{"眠","sleep, die, sleepy","ねむ.る, ねむ.い, ね","nemu.ru, nemu.i, ne","ミン","min"},
{"練","practice, gloss, train, drill, polish, refine","ね.る, ね.り, ねり","ne.ru, ne.ri, neri","レン","ren"},
{"念","wish, sense, idea, thought, feeling, desire, attention","","","ネン","nen"},
{"燃","burn, blaze, glow","も.える, も.やす, も.す","mo.eru, mo.yasu, mo.su","ネン","nen"},
{"農","agriculture, farmers","な, の, み","na, no, mi","ノウ","nou"},
{"能","ability, talent, skill, capacity","よ.く, たか, の, のり, よし","yo.ku, taka, no, nori, yoshi","ノウ","nou"},
{"脳","brain, memory","のうずる","nouzuru","ノウ, ドウ","nou, dou"},
{"望","ambition, full moon, hope, desire, aspire to, expect","のぞ.む, もち, み, も","nozo.mu, mochi, mi, mo","ボウ, モウ","bou, mou"},
{"葉","leaf, plane, lobe, needle, blade, spear, counter for flat things, fragment, piece","は, よ, わ","ha, yo, wa","ヨウ","you"},
{"破","rend, rip, tear, break, destroy, defeat, frustrate","やぶ.る, やぶ.れる, わ","yabu.ru, yabu.reru, wa","ハ","ha"},
{"敗","failure, defeat, reversal","やぶ.れる","yabu.reru","ハイ","hai"},
{"倍","double, twice, times, fold","べ, ます","be, masu","バイ","bai"},
{"量","quantity, measure, weight, amount, consider, estimate, surmise","はか.る, かず","haka.ru, kazu","リョウ","ryou"},
{"麦","barley, wheat","むぎ","mugi","バク","baku"},
{"爆","bomb, burst open, pop, split","は.ぜる","ha.zeru","バク","baku"},
{"箱","box, chest, case, bin, railway car","はこ","hako","ソウ","sou"},
{"畑","farm, field, garden, one's specialty, (kokuji)","","","はた, はたけ, ばたけ, かま, まま","hata, hatake, batake, kama, mama"},
{"肌","texture, skin, body, grain","はだ","hada","キ","ki"},
{"法","method, law, rule, principle, model, system","のり, ほ","nori, ho","ホウ, ハッ, ホッ, フラン","hou, haa, hoo, furan"},
{"鼻","nose, snout","はな","hana","ビ","bi"},
{"放","set free, release, fire, shoot, emit, banish, liberate","はな.す, っぱな.し, はな.つ, はな.れる, こ.く, ほう.る, はなれ","hana.su, ppana.shi, hana.tsu, hana.reru, ko.ku, hou.ru, hanare","ホウ","hou"},
{"幅","hanging scroll, width","はば","haba","フク","fuku"},
{"林","grove, forest","はやし, し","hayashi, shi","リン","rin"},
{"腹","abdomen, belly, stomach","はら","hara","フク","fuku"},
{"払","pay, clear out, prune, banish, dispose of","はら.う, はら.い, ばら.い, はらい","hara.u, hara.i, bara.i, harai","フツ, ヒツ, ホツ","futsu, hitsu, hotsu"},
{"判","judgement, signature, stamp, seal","わか.る","waka.ru","ハン, バン","han, ban"},
{"版","printing block, printing plate, edition, impression, label","","","ハン","han"},
{"般","carrier, carry, all","","","ハン","han"},
{"販","marketing, sell, trade","","","ハン","han"},
{"番","turn, number in a series","つが.い, は, ま","tsuga.i, ha, ma","バン","ban"},
{"晩","nightfall, night","","","バン","ban"},
{"非","un-, mistake, negative, injustice, non-","あら.ず","ara.zu","ヒ","hi"},
{"匹","equal, head, counter for small animals, roll of cloth","ひき","hiki","ヒツ","hitsu"},
{"筆","writing brush, writing, painting brush, handwriting","ふで, くし","fude, kushi","ヒツ","hitsu"},
{"兵","soldier, private, troops, army, warfare, strategy, tactics","つわもの, へ","tsuwamono, he","ヘイ, ヒョウ","hei, hyou"},
{"秒","second (1/60 minute)","","","ビョウ","byou"},
{"貧","poverty, poor","まず.しい","mazu.shii","ヒン, ビン","hin, bin"},
{"瓶","flower pot, bottle, vial, jar, jug, vat, urn","かめ, へい, べ, ぺ","kame, hei, be, pe","ビン","bin"},
{"府","borough, urban prefecture, govt office, representative body, storehouse","い, う, お, はん","i, u, o, han","フ","fu"},
{"婦","lady, woman, wife, bride","ね","ne","フ","fu"},
{"符","token, sign, mark, tally, charm","","","フ","fu"},
{"普","universal, wide(ly), generally, Prussia","あまね.く, あまねし, しん, ひろ","amane.ku, amaneshi, shin, hiro","フ","fu"},
{"膚","skin, body, grain, texture, disposition","はだ","hada","フ","fu"},
{"部","section, bureau, dept, class, copy, part, portion, counter for copies of a newspaper or magazine","べ, とり, ふ, ぺ, ま","be, tori, fu, pe, ma","ブ","bu"},
{"武","warrior, military, chivalry, arms","たけ.し, う, お, たけし, たけん, ん","take.shi, u, o, takeshi, taken, n","ブ, ム","bu, mu"},
{"舞","dance, flit, circle, wheel","ま.う, ま.う, まい","ma.u, ma.u, mai","ブ","bu"},
{"封","seal, closing","","","フウ, ホウ","fuu, hou"},
{"福","blessing, fortune, luck, wealth","とし, とみ, ふ, ふき, ふっ, ぼく, よし","toshi, tomi, fu, fuki, fuu, boku, yoshi","フク","fuku"},
{"副","vice-, duplicate, copy","そい, そえ","soi, soe","フク","fuku"},
{"復","restore, return to, revert, resume","また","mata","フク","fuku"},
{"複","duplicate, double, compound, multiple","","","フク","fuku"},
{"防","ward off, defend, protect, resist","ふせ.ぐ, あた, う, ほう","fuse.gu, ata, u, hou","ボウ","bou"},
{"沸","seethe, boil, ferment, uproar, breed","わ.く, わ.かす","wa.ku, wa.kasu","フツ","futsu"},
{"仏","Buddha, the dead, France","ほとけ","hotoke","ブツ, フツ","butsu, futsu"},
{"報","report, news, reward, retribution","むく.いる","muku.iru","ホウ","hou"},
{"豊","bountiful, excellent, rich","ゆた.か, とよ, て, で, と, ひろし, ふう, ぶん, ほ, ゆたか","yuta.ka, toyo, te, de, to, hiroshi, fuu, bun, ho, yutaka","ホウ, ブ","hou, bu"},
{"貿","trade, exchange","","","ボウ","bou"},
{"忘","forget","わす.れる","wasu.reru","ボウ","bou"},
{"棒","rod, stick, cane, pole, club, line","","","ボウ","bou"},
{"坊","boy, priest's residence, priest","","","ボウ, ボッ","bou, boo"},
{"帽","cap, headgear","ずきん, おお.う","zukin, oo.u","ボウ, モウ","bou, mou"},
{"欲","longing, covetousness, greed, passion, desire, craving","ほっ.する, ほ.しい","hoo.suru, ho.shii","ヨク","yoku"},
{"磨","grind, polish, scour, improve, brush (teeth)","みが.く, す.る, おさむ","miga.ku, su.ru, osamu","マ","ma"},
{"枚","sheet of..., counter for flat thin objects or sheets","ひら..","hira..","マイ, バイ..","mai, bai.."},
{"迷","astray, be perplexed, in doubt, lost, err, illusion","まよ.う","mayo.u","メイ","mei"},
{"満","full, enough, pride, satisfy","み.ちる, み.つ, み.たす, ま, みち, みつ, みつる","mi.chiru, mi.tsu, mi.tasu, ma, michi, mitsu, mitsuru","マン, バン","man, ban"},
{"未","un-, not yet, hitherto, still, even now, sign of the ram, 1-3PM, eighth sign of Chinese zodiac","いま.だ, ま.だ, ひつじ","ima.da, ma.da, hitsuji","ミ, ビ","mi, bi"},
{"乱","riot, war, disorder, disturb","みだ.れる, みだ.る, みだ.す, みだ, おさ.める, わた.る, ら","mida.reru, mida.ru, mida.su, mida, osa.meru, wata.ru, ra","ラン, ロン","ran, ron"},
{"緑","green","みどり","midori","リョク, ロク","ryoku, roku"},
{"夢","dream, vision, illusion","ゆめ, ゆめ.みる, くら.い","yume, yume.miru, kura.i","ム, ボウ","mu, bou"},
{"娘","daughter, girl","むすめ, こ","musume, ko","ジョウ","jou"},
{"綿","cotton","わた, う","wata, u","メン","men"},
{"戻","re-, return, revert, resume, restore, go backwards","もど.す, もど.る","modo.su, modo.ru","レイ","rei"},
{"約","promise, approximately, shrink","","","ヤク","yaku"},
{"由","wherefore, a reason","よし, よ.る","yoshi, yo.ru","ユ, ユウ, ユイ","yu, yuu, yui"},
{"輸","transport, send, be inferior","","","ユ, シュ","yu, shu"},
{"郵","mail, stagecoach stop","","","ユウ","yuu"},
{"予","beforehand, previous, myself, I","あらかじ.め","arakaji.me","ヨ, シャ","yo, sha"},
{"良","good, pleasing, skilled","よ.い, よ.い, い.い, い.い, じ, なが, まこと, よし, ら, りょ, ろう","yo.i, yo.i, i.i, i.i, ji, naga, makoto, yoshi, ra, ryo, rou","リョウ","ryou"},
{"陽","sunshine, yang principle, positive, male, heaven, daytime","ひ, あき, あきら, あけ, はる, ひろ, やん, よ","hi, aki, akira, ake, haru, hiro, yan, yo","ヨウ","you"},
{"容","contain, form, looks","い.れる, かた, ひろ, まさ","i.reru, kata, hiro, masa","ヨウ","you"},
{"翌","the following, next","","","ヨク","yoku"},
{"礼","salute, bow, ceremony, thanks, remuneration","あや, なり, のり, ひろし, れ","aya, nari, nori, hiroshi, re","レイ, ライ","rei, rai"},
{"陸","land, six","おか, くが, たち, みち, む, むつ","oka, kuga, tachi, michi, mu, mutsu","リク, ロク","riku, roku"},
{"律","rhythm, law, regulation, gauge, control","たかし, のり","takashi, nori","リツ, リチ, レツ","ritsu, richi, retsu"},
{"略","abbreviation, omission, outline, shorten, capture, plunder","ほぼ, おか.す, おさ.める, はかりごと, はか.る, はぶ.く, りゃく.す, りゃく.する","hobo, oka.su, osa.meru, hakarigoto, haka.ru, habu.ku, ryaku.su, ryaku.suru","リャク","ryaku"},
{"両","both, old Japanese coin, counter for vehicles, two","てる, ふたつ, もろ","teru, futatsu, moro","リョウ","ryou"},
{"領","jurisdiction, dominion, territory, fief, reign","よう, よし","you, yoshi","リョウ","ryou"},
{"了","complete, finish","さとる","satoru","リョウ","ryou"},
{"療","heal, cure","","","リョウ","ryou"},
{"輪","wheel, ring, circle, link, loop, counter for wheels and flowers","わ, なわ, も","wa, nawa, mo","リン","rin"},
{"類","sort, kind, variety, class, genus","たぐ.い","tagu.i","ルイ","rui"},
{"令","orders, ancient laws, command, decree","のり, りょう, れ","nori, ryou, re","レイ","rei"},
{"零","zero, spill, overflow, nothing, cipher","ぜろ, こぼ.す, こぼ.れる","zero, kobo.su, kobo.reru","レイ","rei"},
{"齢","age","よわ.い, とし","yowa.i, toshi","レイ","rei"},
{"歴","curriculum, continuation, passage of time","","","レキ, レッキ","reki, rekki"},
{"列","file, row, rank, tier, column","れっ","ree","レツ, レ","retsu, re"},
{"他","other, another, the others","ほか","hoka","タ","ta"},
{"伝","transmit, go along, walk along, follow, report, communicate, legend, tradition","つた.わる, つた.える, つた.う, つだ.う, づた.い, つて, つたえ","tsuta.waru, tsuta.eru, tsuta.u, tsuda.u, zuta.i, tsute, tsutae","デン, テン","den, ten"},
{"顔","face, expression","かお","kao","ガン","gan"},
{"団","group, association","かたまり, まる.い","katamari, maru.i","ダン, トン","dan, ton"},
{"対","vis-a-vis, opposite, even, equal, versus, anti-, compare","あいて, こた.える, そろ.い, つれあ.い, なら.ぶ, むか.う, つし","aite, kota.eru, soro.i, tsurea.i, nara.bu, muka.u, tsushi","タイ, ツイ","tai, tsui"},
{"舟","boat, ship","ふね, ふな, ぶね","fune, funa, bune","シュウ","shuu"},
{"雲","cloud","くも, ぐも, き, ずも, のめ","kumo, gumo, ki, zumo, nome","ウン","un"},
{"労","labor, thank for, reward for, toil, trouble","ろう.する, いたわ.る, いた.ずき, ねぎら, つか.れる, ねぎら.う","rou.suru, itawa.ru, ita.zuki, negira, tsuka.reru, negira.u","ロウ","rou"},
{"録","record","","","ロク","roku"},
{"論","argument, discourse","","","ロン","ron"},
{"湾","gulf, bay, inlet","いりえ","irie","ワン","wan"}
};

static kanjitransInfo kanjitable_jlpt1[] = 
{
{"亜","Asia, rank next, come after, -ous","つ.ぐ, や, つぎ, つぐ","tsu.gu, ya, tsugi, tsugu","ア, アシア","a, ashia"},
{"哀","pathetic, grief, sorrow, pathos, pity, sympathize","あわ.れ, あわ.れむ, かな.しい","awa.re, awa.remu, kana.shii","アイ","ai"},
{"挨","push open","ひら.く","hira.ku","アイ","ai"},
{"垢","dirt, grime, earwax","あか, はじ","aka, haji","コウ, ク","kou, ku"},
{"握","grip, hold, mould sushi, bribe","にぎ.る","nigi.ru","アク","aku"},
{"憧","yearn after, long for, aspire to, admire, adore","あこが.れる","akoga.reru","ショウ, トウ, ドウ","shou, tou, dou"},
{"扱","handle, entertain, thresh, strip","あつか.る, あつか.い, あつか.う","atsuka.ru, atsuka.i, atsuka.u","ショウ","shou"},
{"或","some, one, or, possibly, a certain","あ.る, あるい, あるいは","a.ru, arui, aruiha","ワク, コク, イキ","waku, koku, iki"},
{"案","plan, suggestion, draft, ponder, fear, proposition, idea, expectation, bill, worry","つくえ","tsukue","アン","an"},
{"異","uncommon, queerness, strangeness, wonderful, curious, unusual","こと, こと.なる, け","koto, koto.naru, ke","イ","i"},
{"遺","bequeath, leave behind, reserve","","","イ, ユイ","i, yui"},
{"緯","horizontal, woof, left & right, latitude","よこいと, ぬき","yokoito, nuki","イ","i"},
{"威","intimidate, dignity, majesty, menace, threaten","おど.す, おど.し, おど.かす, いさ, たけ, たけし","odo.su, odo.shi, odo.kasu, isa, take, takeshi","イ","i"},
{"維","fiber, tie, rope","これ, たもつ, つぐ, ゆい, ゆき","kore, tamotsu, tsugu, yui, yuki","イ","i"},
{"尉","military officer, jailer, old man, rank","","","イ, ジョウ","i, jou"},
{"為","do, change, make, benefit, welfare, be of use, reach to, try, practice, cost, serve as, good, advantage, as a result of","ため, な.る, な.す, す.る, たり, つく.る, なり, びい","tame, na.ru, na.su, su.ru, tari, tsuku.ru, nari, bii","イ","i"},
{"椅","chair","","","イ","i"},
{"炒","broil, parch, roast, fry","い.る, いた.める","i.ru, ita.meru","ソウ, ショウ","sou, shou"},
{"壱","I, one","ひとつ, い, かず","hitotsu, i, kazu","イチ, イツ","ichi, itsu"},
{"逸","deviate, idleness, leisure, miss the mark, evade, elude, parry, diverge","そ.れる, そ.らす, はぐ.れる, いっ, はや, へん","so.reru, so.rasu, hagu.reru, ii, haya, hen","イツ","itsu"},
{"芋","potato","いも","imo","ウ","u"},
{"隠","conceal, hide, cover","かく.す, かく.し, かく.れる, かか.す, よ.る, お, がくし","kaku.su, kaku.shi, kaku.reru, kaka.su, yo.ru, o, gakushi","イン, オン","in, on"},
{"陰","shade, yin, negative, sex organs, secret, shadow","かげ, かげ.る","kage, kage.ru","イン","in"},
{"姻","matrimony, marry","","","イン","in"},
{"韻","rhyme, elegance, tone","","","イン","in"},
{"嘘","lie, falsehood","うそ, ふ.く","uso, fu.ku","キョ, コ","kyo, ko"},
{"嬉","glad, pleased, rejoice","うれ.しい, たの.しむ, うらし, うれし","ure.shii, tano.shimu, urashi, ureshi","キ","ki"},
{"噂","rumor, gossip, hearsay","うわさ","uwasa","ソン","son"},
{"衛","defense, protection","もり, い, まもる","mori, i, mamoru","エイ, エ","ei, e"},
{"影","shadow, silhouette, phantom","かげ","kage","エイ","ei"},
{"詠","recitation, poem, song, composing","よ.む, うた.う, うた, え, ええ","yo.mu, uta.u, uta, e, ee","エイ","ei"},
{"益","benefit, gain, profit, advantage","ま.す, まし, ます","ma.su, mashi, masu","エキ, ヤク","eki, yaku"},
{"疫","epidemic","","","エキ, ヤク","eki, yaku"},
{"餌","food, bait, prey, tempting profit","え, えば, えさ, もち","e, eba, esa, mochi","ジ, ニ","ji, ni"},
{"閲","review, inspection, revision","けみ.する","kemi.suru","エツ","etsu"},
{"悦","ecstasy, joy, rapture","よろこ.ぶ, よろこ.ばす, や, よし","yoroko.bu, yoroko.basu, ya, yoshi","エツ","etsu"},
{"謁","audience, audience (with king)","","","エツ","etsu"},
{"沿","run alongside, follow along, run along, lie along","そ.う, ぞ.い","so.u, zo.i","エン","en"},
{"宴","banquet, feast, party","うたげ, うた, やす","utage, uta, yasu","エン","en"},
{"炎","inflammation, flame, blaze","ほのお, ぬく","honoo, nuku","エン","en"},
{"縁","affinity, relation, connection, edge, border, verge, brink","ふち, ふちど.る, ゆかり, よすが, へり, えにし","fuchi, fuchido.ru, yukari, yosuga, heri, enishi","エン, ネン","en, nen"},
{"鉛","lead","なまり","namari","エン","en"},
{"猿","monkey","さる, さ, さわ, ざる, まし","saru, sa, sawa, zaru, mashi","エン","en"},
{"援","abet, help, save","","","エン","en"},
{"宛","address, just like, fortunately","あ.てる, あて, づつ, あたか.も","a.teru, ate, zutsu, ataka.mo","エン","en"},
{"於","at, in, on, as for","おい.て, お.ける, ああ, より","oi.te, o.keru, aa, yori","オ, ヨ","o, yo"},
{"桜","cherry","さくら, さ, ろう","sakura, sa, rou","オウ, ヨウ","ou, you"},
{"応","apply, answer, yes, OK, reply, accept","あた.る, まさに, こた.える, お, たか, まさ","ata.ru, masani, kota.eru, o, taka, masa","オウ, ヨウ, ノウ","ou, you, nou"},
{"往","journey, chase away, let go, going, travel","い.く, いにしえ, さき.に, ゆ.く, みち","i.ku, inishie, saki.ni, yu.ku, michi","オウ","ou"},
{"凹","concave, hollow, sunken","くぼ.む, へこ.む, ぼこ","kubo.mu, heko.mu, boko","オウ","ou"},
{"殴","assault, hit, beat, thrash","なぐ.る","nagu.ru","オウ","ou"},
{"憶","recollection, think, remember","","","オク","oku"},
{"乙","the latter, duplicate, strange, witty","おと, きのと","oto, kinoto","オツ, イツ","otsu, itsu"},
{"俺","I, myself","おれ, われ","ore, ware","エン","en"},
{"卸","wholesale","おろ.す, おろし, おろ.し","oro.su, oroshi, oro.shi","シャ","sha"},
{"恩","grace, kindness, goodness, favor, mercy, blessing, benefit","めぐみ","megumi","オン","on"},
{"穏","calm, quiet, moderation","おだ.やか","oda.yaka","オン","on"},
{"蚊","mosquito","か","ka","ブン","bun"},
{"仮","sham, temporary, interim, assumed (name), informal","かり, かり","kari, kari","カ, ケ","ka, ke"},
{"価","value, price","あたい","atai","カ, ケ","ka, ke"},
{"華","splendor, flower, petal, shine, luster, ostentatious, showy, gay, gorgeous","はな, わ","hana, wa","カ, ケ","ka, ke"},
{"禍","calamity, misfortune, evil, curse","わざわい","wazawai","カ","ka"},
{"渦","whirlpool, eddy, vortex","","","カ","ka"},
{"佳","excellent, beautiful, good, pleasing, skilled","けい, よし","kei, yoshi","カ","ka"},
{"寡","widow, minority, few","","","カ","ka"},
{"箇","counters for things","","","カ, コ","ka, ko"},
{"嫁","marry into, bride","よめ, とつ.ぐ","yome, totsu.gu","カ","ka"},
{"稼","earnings, work, earn money","かせ.ぐ","kase.gu","カ","ka"},
{"架","erect, frame, mount, support, shelf, construct","か.ける, か.かる","ka.keru, ka.karu","カ","ka"},
{"概","outline, condition, approximation, generally","おうむ.ね","oumu.ne","ガイ","gai"},
{"該","above-stated, the said, that specific","","","ガイ","gai"},
{"涯","horizon, shore","はて","hate","ガイ","gai"},
{"暇","spare time, rest, leisure, time, leave of absence","ひま, いとま","hima, itoma","カ","ka"},
{"霞","be hazy, grow dim, blurred","かすみ, かす.む","kasumi, kasu.mu","カ, ゲ","ka, ge"},
{"慨","rue, be sad, sigh, lament","","","ガイ","gai"},
{"嘩","noisy","かまびす.しい","kamabisu.shii","カ, ケ","ka, ke"},
{"戒","commandment","いまし.める","imashi.meru","カイ","kai"},
{"懐","pocket, feelings, heart, yearn, miss someone, become attached to, bosom, breast","ふところ, なつ.かしい, なつ.かしむ, なつ.く, なつ.ける, なず.ける, いだ.く, おも.う, かね","futokoro, natsu.kashii, natsu.kashimu, natsu.ku, natsu.keru, nazu.keru, ida.ku, omo.u, kane","カイ, エ","kai, e"},
{"劾","censure, criminal investigation","","","ガイ","gai"},
{"街","boulevard, street, town","まち, また","machi, mata","ガイ, カイ","gai, kai"},
{"芽","bud, sprout, spear, germ","め, じ, めぐ","me, ji, megu","ガ","ga"},
{"賀","congratulations, joy","か, のり, よし, より","ka, nori, yoshi, yori","ガ","ga"},
{"我","ego, I, selfish, our, oneself","われ, わ, わ.が, わが, あ, あが, か","ware, wa, wa.ga, waga, a, aga, ka","ガ","ga"},
{"雅","gracious, elegant, graceful, refined","みや.び, う, お, か, ただし, のり, まさ, まさし, よし","miya.bi, u, o, ka, tadashi, nori, masa, masashi, yoshi","ガ","ga"},
{"餓","starve, hungry, thirst","う.える","u.eru","ガ","ga"},
{"壊","demolition, break, destroy","こわ.す, こわ.れる, やぶ.る","kowa.su, kowa.reru, yabu.ru","カイ, エ","kai, e"},
{"悔","repent, regret","く.いる, く.やむ, くや.しい","ku.iru, ku.yamu, kuya.shii","カイ","kai"},
{"拐","kidnap, falsify","","","カイ","kai"},
{"怪","suspicious, mystery, apparition","あや.しい, あや.しむ","aya.shii, aya.shimu","カイ, ケ","kai, ke"},
{"塊","clod, lump, chink, clot, mass","かたまり, つちくれ","katamari, tsuchikure","カイ, ケ","kai, ke"},
{"垣","hedge, fence, wall","かき, がい","kaki, gai","エン","en"},
{"拡","broaden, extend, expand, enlarge","ひろ.がる, ひろ.げる, ひろ.める","hiro.garu, hiro.geru, hiro.meru","カク, コウ","kaku, kou"},
{"閣","tower, tall building, palace","","","カク","kaku"},
{"核","nucleus, core, kernel","","","カク","kaku"},
{"殻","husk, nut shell","から, がら","kara, gara","カク, コク, バイ","kaku, koku, bai"},
{"穫","harvest, reap","","","カク","kaku"},
{"獲","seize, get, find, earn, acquire, can, may, able to","え.る","e.ru","カク","kaku"},
{"隔","isolate, alternate, distance, separate, gulf","へだ.てる, へだ.たる","heda.teru, heda.taru","カク","kaku"},
{"較","contrast, compare","くら.べる","kura.beru","カク, コウ","kaku, kou"},
{"郭","enclosure, quarters, fortification, red-light district","くるわ, ひろ","kuruwa, hiro","カク","kaku"},
{"岳","point, peak, mountain","たけ, おか, たか, たけん","take, oka, taka, taken","ガク","gaku"},
{"崖","cliff, bluff, precipice","がけ, きし, はて","gake, kishi, hate","ガイ, ゲ, ギ","gai, ge, gi"},
{"籠","basket, devote oneself, seclude oneself, cage, coop, implied","かご, こ.める, こも.る, こ.む, ごめ, もり","kago, ko.meru, komo.ru, ko.mu, gome, mori","ロウ, ル","rou, ru"},
{"潟","lagoon","かた, がた, がら","kata, gata, gara","セキ","seki"},
{"括","fasten, tie up, arrest, constrict","くく.る","kuku.ru","カツ","katsu"},
{"喝","hoarse, scold","","","カツ","katsu"},
{"褐","brown, woollen kimono","","","カツ","katsu"},
{"轄","control, wedge","くさび","kusabi","カツ","katsu"},
{"滑","slippery, slide, slip, flunk","すべ.る, なめ.らか, かり, なめり","sube.ru, name.raka, kari, nameri","カツ, コツ","katsu, kotsu"},
{"渇","thirst, dry up, parch","かわ.く","kawa.ku","カツ","katsu"},
{"鞄","suitcase, bag, briefcase","かばん","kaban","ハク, ホウ, ビョウ","haku, hou, byou"},
{"株","stocks, stump, shares, stock, counter for small plants","かぶ","kabu","シュ","shu"},
{"釜","kettle, cauldron, iron pot","かま","kama","フ","fu"},
{"噛","chew, bite, gnaw","か.む, か.じる","ka.mu, ka.jiru","コウ, ゴウ","kou, gou"},
{"刈","reap, cut, clip, trim, prune","か.る, かっ, かり","ka.ru, kaa, kari","ガイ, カイ","gai, kai"},
{"瓦","tile, gram","かわら, ぐらむ","kawara, guramu","ガ","ga"},
{"幹","tree trunk","みき, つよし, まさ, もと","miki, tsuyoshi, masa, moto","カン","kan"},
{"看","watch over, see","み.る","mi.ru","カン","kan"},
{"憾","remorse, regret, be sorry","うら.む","ura.mu","カン","kan"},
{"還","send back, return","かえ.る","kae.ru","カン","kan"}
};

#endif

