
/*!
 * \file
 * \ingroup db
 * \brief Database support for modules.
 *
 * Database support functions for modules.
 *
 * @cond
 * WARNING:
 * This file was autogenerated from the XML source file
 * ../../modules/carrierroute/kamailio-carrierroute.xml.
 * It can be regenerated by running 'make modules' in the db/schema
 * directory of the source code. You need to have xsltproc and
 * docbook-xsl stylesheets installed.
 * ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED
 * @endcond
 */

#ifndef db_carrierroute_h
#define db_carrierroute_h


/* necessary includes */
#include "../../lib/srdb1/db.h"
#include "../../str.h"
#include "../../ut.h"

#include <string.h>


/* database variables */

extern str carrierroute_db_url;
extern db1_con_t * carrierroute_dbh;
extern db_func_t carrierroute_dbf;

#define carrierroute_DB_URL { "db_url", STR_PARAM, &carrierroute_db_url.s },

#define carrierroute_DB_TABLE { "carrierroute_table", STR_PARAM, &carrierroute_table.s },

extern str carrierroute_table;

/* column names */
extern str carrierroute_id_col;
extern str carrierroute_carrier_col;
extern str carrierroute_domain_col;
extern str carrierroute_scan_prefix_col;
extern str carrierroute_flags_col;
extern str carrierroute_mask_col;
extern str carrierroute_prob_col;
extern str carrierroute_strip_col;
extern str carrierroute_rewrite_host_col;
extern str carrierroute_rewrite_prefix_col;
extern str carrierroute_rewrite_suffix_col;
extern str carrierroute_description_col;
#define carrierroute_DB_COLS \
{ "carrierroute_id_col", STR_PARAM, &carrierroute_id_col.s }, \
{ "carrierroute_carrier_col", STR_PARAM, &carrierroute_carrier_col.s }, \
{ "carrierroute_domain_col", STR_PARAM, &carrierroute_domain_col.s }, \
{ "carrierroute_scan_prefix_col", STR_PARAM, &carrierroute_scan_prefix_col.s }, \
{ "carrierroute_flags_col", STR_PARAM, &carrierroute_flags_col.s }, \
{ "carrierroute_mask_col", STR_PARAM, &carrierroute_mask_col.s }, \
{ "carrierroute_prob_col", STR_PARAM, &carrierroute_prob_col.s }, \
{ "carrierroute_strip_col", STR_PARAM, &carrierroute_strip_col.s }, \
{ "carrierroute_rewrite_host_col", STR_PARAM, &carrierroute_rewrite_host_col.s }, \
{ "carrierroute_rewrite_prefix_col", STR_PARAM, &carrierroute_rewrite_prefix_col.s }, \
{ "carrierroute_rewrite_suffix_col", STR_PARAM, &carrierroute_rewrite_suffix_col.s }, \
{ "carrierroute_description_col", STR_PARAM, &carrierroute_description_col.s }, \

/* table version */
extern const unsigned int carrierroute_version;

#define carrierfailureroute_DB_TABLE { "carrierfailureroute_table", STR_PARAM, &carrierfailureroute_table.s },

extern str carrierfailureroute_table;

/* column names */
extern str carrierfailureroute_id_col;
extern str carrierfailureroute_carrier_col;
extern str carrierfailureroute_domain_col;
extern str carrierfailureroute_scan_prefix_col;
extern str carrierfailureroute_host_name_col;
extern str carrierfailureroute_reply_code_col;
extern str carrierfailureroute_flags_col;
extern str carrierfailureroute_mask_col;
extern str carrierfailureroute_next_domain_col;
extern str carrierfailureroute_description_col;
#define carrierfailureroute_DB_COLS \
{ "carrierfailureroute_id_col", STR_PARAM, &carrierfailureroute_id_col.s }, \
{ "carrierfailureroute_carrier_col", STR_PARAM, &carrierfailureroute_carrier_col.s }, \
{ "carrierfailureroute_domain_col", STR_PARAM, &carrierfailureroute_domain_col.s }, \
{ "carrierfailureroute_scan_prefix_col", STR_PARAM, &carrierfailureroute_scan_prefix_col.s }, \
{ "carrierfailureroute_host_name_col", STR_PARAM, &carrierfailureroute_host_name_col.s }, \
{ "carrierfailureroute_reply_code_col", STR_PARAM, &carrierfailureroute_reply_code_col.s }, \
{ "carrierfailureroute_flags_col", STR_PARAM, &carrierfailureroute_flags_col.s }, \
{ "carrierfailureroute_mask_col", STR_PARAM, &carrierfailureroute_mask_col.s }, \
{ "carrierfailureroute_next_domain_col", STR_PARAM, &carrierfailureroute_next_domain_col.s }, \
{ "carrierfailureroute_description_col", STR_PARAM, &carrierfailureroute_description_col.s }, \

/* table version */
extern const unsigned int carrierfailureroute_version;

#define carrier_name_DB_TABLE { "carrier_name_table", STR_PARAM, &carrier_name_table.s },

extern str carrier_name_table;

/* column names */
extern str carrier_name_id_col;
extern str carrier_name_carrier_col;
#define carrier_name_DB_COLS \
{ "carrier_name_id_col", STR_PARAM, &carrier_name_id_col.s }, \
{ "carrier_name_carrier_col", STR_PARAM, &carrier_name_carrier_col.s }, \

/* table version */
extern const unsigned int carrier_name_version;

#define domain_name_DB_TABLE { "domain_name_table", STR_PARAM, &domain_name_table.s },

extern str domain_name_table;

/* column names */
extern str domain_name_id_col;
extern str domain_name_domain_col;
#define domain_name_DB_COLS \
{ "domain_name_id_col", STR_PARAM, &domain_name_id_col.s }, \
{ "domain_name_domain_col", STR_PARAM, &domain_name_domain_col.s }, \

/* table version */
extern const unsigned int domain_name_version;


/*
 * Closes the DB connection.
 */
void carrierroute_db_close(void);

/*!
 * Initialises the DB API, check the table version and closes the connection.
 * This should be called from the mod_init function.
 *
 * \return 0 means ok, -1 means an error occured.
 */
int carrierroute_db_init(void);

/*!
 * Initialize the DB connection without checking the table version and DB URL.
 * This should be called from child_init. An already existing database
 * connection will be closed, and a new one created.
 *
 * \return 0 means ok, -1 means an error occured.
 */
int carrierroute_db_open(void);

/*!
 * Update the variable length after eventual assignments from the config script.
 * This is necessary because we're using the 'str' type.
 */
void carrierroute_db_vars(void);

#endif
