/***************************************************************************
 *   Copyright (C) 2005 by Anne-Marie Mahfouf   *
 *   annemarie.mahfouf@free.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ***************************************************************************/


#ifndef KALCULVIEW_H_
#define KALCULVIEW_H_

#include <qwidget.h>
#include <qstringlist.h>

#include <krandomsequence.h>

#include "kalculview_base.h"

class QIntValidator;
class QPainter;
class KURL;
class KClock;

/**
 * This is the main view class for Kalcul.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Anne-Marie Mahfouf <annemarie.mahfouf@free.fr>
 * @version 0.1
 */
class KalculView : public kalculview_base
{
Q_OBJECT
public:
    /**
    * Default constructor
    */
    KalculView(QWidget *parent);

    /**
    * Destructor
    */
    virtual ~KalculView();

public slots:    
    /**
     * Method for setting the level to play.
     * \param level The contents of the level file
     */
    void setLevel(const QString& level);

    /**
     * Method for setting the practice mode.
     * \param practiceMode The mode. 1 for Addition, 2 for Subtraction,
     * 3 for Multiplication and 4 for Division.
     */
    void setPracticeMode(int practiceMode);

    /**
     * Called from kalcul main window when settings have been changed
     */
    void settingsChanged();
    
signals:
    /**
        * Use this signal to change the content of the statusbar
        */
    void signalChangeStatusbar(const QString& text);
    
    /**
        * Use this signal to change the content of the caption
        */
    void signalChangeCaption(const QString& text);

    
protected:

    KRandomSequence random;
    int firstNum;
    int secondNum;
    int correctAnswer[100];
    int answerNum[100];
    
    ///whether the test is paused
    bool paused;
    
    ///what kind of test we are doing
    int mode;
    
    ///for level mode, this are the questions
    QStringList levelQuestionsList;
    
    ///for level mode, how many questions do we have?
    int levelNumberOfQuestions;
    
    ///number of total answers
    int total;
    
    ///number of correct answers
    int correct;
    
    ///the question as displayed for the pupil
    QString questionString[100];
    
    ///randomly choose the numbers and display the operation
    void displayOperation();

    ///reset labels to null(), reset clock, clear answerLine
    void reset();

    ///displays the result dialog
    void displayResultDialog();
    
    ///a timer instance
    KClock* clock;
    
    ///our validator
    QIntValidator *intValidator;

private slots:

    void slotCheck();
    void timerDone();
    void slotStart();
    void slotPause();
    void slotStop();
    void saveResults();
};

enum
{
    Practice_Addition = 0,
    Practice_Subtraction,
    Practice_Multiplication,
    Practice_Division,
    Level
};

#endif // KALCULVIEW_H_
