#ifndef	_TEXFONTS
#define	_TEXFONTS
/****************************************************************************
 *
 * Copyright(c) 2002-2003, John Forkosh Associates, Inc. All rights reserved.
 * --------------------------------------------------------------------------
 * This file is part of mimeTeX, which is free software. You may redistribute
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 or later, as published by the Free Software Foundation.
 *      MimeTeX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY, not even the implied warranty of MERCHANTABILITY.
 * See the GNU General Public License for specific details.
 *      By using mimeTeX, you warrant that you have read, understood and
 * agreed to these terms and conditions, and that you are at least 18 years
 * of age and possess the legal right and ability to enter into this
 * agreement and to use mimeTeX in accordance with it.
 *      Your mimeTeX distribution should contain a copy of the GNU General
 * Public License.  If not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 * or point your browser to  http://www.gnu.org/licenses/gpl.html
 * --------------------------------------------------------------------------
 *
 * Purpose:	chardef structure data for mimetex
 *		generated by gfuntype
 * 
 * Source:	texfonts.h
 *
 * Notes:     o	Each big declaration of static chardef arrays
 *		is generated by a single run of my program gfuntype,
 *		as explained in the notes below, and then all those
 *		separate outputs are gathered together in this file.
 *	      o	You must first run metafont to generate a .gf file,
 *		for example...
 *		  mf '\mode=onetz; mag=magstep(.5); input cmmi10'
 *		will generate file cmmi10.131gf (which corresponds
 *		to size=3 below)
 *	      o	Given that (or any other) .gf file, next run
 *		  gftype -i cmmi10.131gf > typeout
 *		(where  typeout  can be any filename you like)
 *	      o	Then run my program against the above output,
 *		for example...
 *		  gfuntype  -n cmmi131  typeout  cmmi131.h
 *		which generates output file cmmib131.h (or any
 *		filename you supply as the last arg), containing
 *		the  static chardef cmmi131[]  array of data.
 *		(The name of that array is taken from the  -n  arg
 *		you supplied to gfuntype.)
 *	      o	Repeat the above steps for all the arrays you need,
 *		and then gather the output together in this file,
 *		texfonts.h, which will be #include'd by mimetex.h
 *	      o	Finally, manually edit the  fonttable[]  array
 *		in minetex.h, placing the names of all these chardef
 *		arrays in the appropriate fonttable[] cells.
 *	      o	Now you can recompile mimetex.c to use your new fonts.
 *
 * --------------------------------------------------------------------------
 * Revision History:
 * 10/05/02	J.Forkosh	Installation.
 * 07/10/03	J.Forkosh	Added cmmi10 fonts (in addition to cmmib10),
 *				and rsfs fonts.
 * 07/12/03	J.Forkosh	Entirely new set of fonts generated.
 *
 ***************************************************************************/


/* --------------------------------------------------------------------------
font sizes 0-5 for cmr10
-------------------------------------------------------------------------- */

/* --- size=0 ---
 * mf '\mode=eighthre; input cmr10'   gives .gf83
 * ---------------------------------------------- */
/* --- fontdef for cmr83 --- */
static	chardef  cmr83[] =
   {
      /* --- pixel bitmap for cmr83 char#0 (noname) --- */
      {   0, 1561,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbf\x28\x0a\x82\x20\x1c" }  },
      /* --- pixel bitmap for cmr83 char#1 (noname) --- */
      {   1, 1588,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x28\x28\x6c\x44\x44\x82\xfe" }  },
      /* --- pixel bitmap for cmr83 char#2 (noname) --- */
      {   2, 1623,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\xb6\x61\x28\x31" }  },
      /* --- pixel bitmap for cmr83 char#3 (noname) --- */
      {   3, 1660,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x04\x85\x42\xa1\x88\xee" }  },
      /* --- pixel bitmap for cmr83 char#4 (noname) --- */
      {   4, 1695,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xa0\xc8\x27\x02\x04\xff" }  },
      /* --- pixel bitmap for cmr83 char#5 (noname) --- */
      {   5, 1726,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x42\x42\x42\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr83 char#6 (noname) --- */
      {   6, 1763,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\x4a\x42\xac\xfc" }  },
      /* --- pixel bitmap for cmr83 char#7 (noname) --- */
      {   7, 1794,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x77\x8a\x20\x08\x82\x70" }  },
      /* --- pixel bitmap for cmr83 char#8 (noname) --- */
      {   8, 1823,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8e\xb8\x5a\x1d\x71" }  },
      /* --- pixel bitmap for cmr83 char#9 (noname) --- */
      {   9, 1854,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x92\xa6\xab\x87\x70" }  },
      /* --- pixel bitmap for cmr83 char#10 (noname) --- */
      {  10, 1889,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x91\x48\x24\xa2\x54\xef" }  },
      /* --- pixel bitmap for cmr83 char#11 (noname) --- */
      {  11, 3214,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\x24\x24\x7f\x24\x24\x24\x66" }  },
      /* --- pixel bitmap for cmr83 char#12 (noname) --- */
      {  12, 3249,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x41\x7c\x1c\x45\xd9" }  },
      /* --- pixel bitmap for cmr83 char#13 (noname) --- */
      {  13, 3278,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x45\x7d\x14\x45\xd9" }  },
      /* --- pixel bitmap for cmr83 char#14 (noname) --- */
      {  14, 3313,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\x91\x40\xc2\x7f\xa4\x91\x44\x92\xdd" }  },
      /* --- pixel bitmap for cmr83 char#15 (noname) --- */
      {  15, 3356,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\x91\x44\xd2\x7f\x24\x91\x44\x92\xc9" }  },
      /* --- pixel bitmap for cmr83 char#16 (noname) --- */
      {  16, 2288,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x74" }  },
      /* --- pixel bitmap for cmr83 char#17 (noname) --- */
      {  17, 2305,                      /* character number, location */
          5,-1,    -2,-1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x26\x49\x1e" }  },
      /* --- pixel bitmap for cmr83 char#18 (noname) --- */
      {  18, 3052,                      /* character number, location */
          8, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x09" }  },
      /* --- pixel bitmap for cmr83 char#19 (noname) --- */
      {  19, 3063,                      /* character number, location */
          8, 2,     6, 2,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x06" }  },
      /* --- pixel bitmap for cmr83 char#20 (noname) --- */
      {  20, 3074,                      /* character number, location */
          7, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  3,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr83 char#21 (noname) --- */
      {  21, 3083,                      /* character number, location */
          8, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3d" }  },
      /* --- pixel bitmap for cmr83 char#22 (noname) --- */
      {  22, 3096,                      /* character number, location */
          7, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  3,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr83 char#23 (noname) --- */
      {  23, 3105,                      /* character number, location */
          8, 3,     6, 3,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr83 char#24 (noname) --- */
      {  24, 3116,                      /* character number, location */
          0, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e" }  },
      /* --- pixel bitmap for cmr83 char#25 \ss --- */
      {  25, 2326,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\xa9\x25\xa5\x5c" }  },
      /* --- pixel bitmap for cmr83 char#26 \ae --- */
      {  26, 2363,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x36\x7f\x22\x69\x03" }  },
      /* --- pixel bitmap for cmr83 char#27 \oe --- */
      {  27, 2390,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6e\xf1\x11\x91\x6e" }  },
      /* --- pixel bitmap for cmr83 char#28 (noname) --- */
      {  28, 2419,                      /* character number, location */
          6, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd0\xf5\x7a\x5d\x00" }  },
      /* --- pixel bitmap for cmr83 char#29 \AE --- */
      {  29, 2448,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x30\x51\xa2\xc2\x97\xaa\xc4\xf9" }  },
      /* --- pixel bitmap for cmr83 char#30 \OE --- */
      {  30, 2495,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\xc9\x14\x5b\x38\xa1\xc6\x28\x23\xff" }  },
      /* --- pixel bitmap for cmr83 char#31 (noname) --- */
      {  31, 2542,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x96\xa6\x6d\x69\x39\x02" }  },
      /* --- pixel bitmap for cmr83 char#32 (noname) --- */
      {  32, 3146,                      /* character number, location */
          4, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          {  2,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x03" }  },
      /* --- pixel bitmap for cmr83 char#33 ! --- */
      {  33, 2587,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9f" }  },
      /* --- pixel bitmap for cmr83 char#34 " --- */
      {  34, 3403,                      /* character number, location */
          8, 0,     5, 0,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6d\x01" }  },
      /* --- pixel bitmap for cmr83 char#35 # --- */
      {  35, 2629,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x28\x14\xea\x4f\xa1\x50\xfe\x0a\x05" }  },
      /* --- pixel bitmap for cmr83 char#36 $ --- */
      {  36, 2180,                      /* character number, location */
          9, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd2\x3f\xff\x12" }  },
      /* --- pixel bitmap for cmr83 char#37 % --- */
      {  37, 2672,                      /* character number, location */
          9, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc2\x5e\xa9\xa2\x40\x51\xa5\xd2\x10" }  },
      /* --- pixel bitmap for cmr83 char#38 & --- */
      {  38, 2207,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x0a\x87\xed\xca\x44\xdc" }  },
      /* --- pixel bitmap for cmr83 char#39 (noname) --- */
      {  39, 2729,                      /* character number, location */
          8, 1,     5, 1,     /* topleft row,col, and botleft row,col */
          {  1,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr83 char#40 ( --- */
      {  40, 2742,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  2,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5a\x55\x95\x02" }  },
      /* --- pixel bitmap for cmr83 char#41 ) --- */
      {  41, 2775,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  2,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa5\xaa\x6a\x01" }  },
      /* --- pixel bitmap for cmr83 char#42 * --- */
      {  42, 2808,                      /* character number, location */
          9, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x2e" }  },
      /* --- pixel bitmap for cmr83 char#43 + --- */
      {  43, 2825,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x82\x20\x3f\x82\x20\x08" }  },
      /* --- pixel bitmap for cmr83 char#44 (noname) --- */
      {  44, 2850,                      /* character number, location */
          1, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  1,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr83 char#45 (noname) --- */
      {  45, 3422,                      /* character number, location */
          3, 0,     2, 0,     /* topleft row,col, and botleft row,col */
          {  3,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr83 char#46 (noname) --- */
      {  46, 2863,                      /* character number, location */
          1, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmr83 char#47 / --- */
      {  47, 2872,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x24\x25\x49\x4a\x02" }  },
      /* --- pixel bitmap for cmr83 char#48 0 --- */
      {  48, 1930,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\x18\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#49 1 --- */
      {  49, 1961,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9a\x24\x1d" }  },
      /* --- pixel bitmap for cmr83 char#50 2 --- */
      {  50, 1982,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x88\xa4\x0f" }  },
      /* --- pixel bitmap for cmr83 char#51 3 --- */
      {  51, 2007,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x21\x06\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#52 4 --- */
      {  52, 2032,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xcc\xad\x8f\x10\x07" }  },
      /* --- pixel bitmap for cmr83 char#53 5 --- */
      {  53, 2055,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x17\x71\x98\x06" }  },
      /* --- pixel bitmap for cmr83 char#54 6 --- */
      {  54, 2078,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\x84\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#55 7 --- */
      {  55, 2103,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9f\x24\x22\x02" }  },
      /* --- pixel bitmap for cmr83 char#56 8 --- */
      {  56, 2126,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x29\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#57 9 --- */
      {  57, 2155,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46\x0f\x91\x01" }  },
      /* --- pixel bitmap for cmr83 char#58 : --- */
      {  58, 2903,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11" }  },
      /* --- pixel bitmap for cmr83 char#59 ; --- */
      {  59, 2916,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  1,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x71" }  },
      /* --- pixel bitmap for cmr83 char#60 (noname) --- */
      {  60, 2608,                      /* character number, location */
          6, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  1,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf9" }  },
      /* --- pixel bitmap for cmr83 char#61 = --- */
      {  61, 2933,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmr83 char#62 (noname) --- */
      {  62, 2265,                      /* character number, location */
          6, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x02\x20\x22\x79" }  },
      /* --- pixel bitmap for cmr83 char#63 (noname) --- */
      {  63, 2242,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x24\x02\x20" }  },
      /* --- pixel bitmap for cmr83 char#64 (noname) --- */
      {  64, 2946,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x37\xcf\xf3\xec\xf3" }  },
      /* --- pixel bitmap for cmr83 char#65 A --- */
      {  65,   35,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x18\x18\x3c\x24\x3c\x24\xe7" }  },
      /* --- pixel bitmap for cmr83 char#66 B --- */
      {  66,   64,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9f\x28\xfa\xb2\x28\x7e" }  },
      /* --- pixel bitmap for cmr83 char#67 C --- */
      {  67,   97,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\xc6\x10\xa2\x64" }  },
      /* --- pixel bitmap for cmr83 char#68 D --- */
      {  68,  128,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x91\x50\x28\x14\x8a\x7e" }  },
      /* --- pixel bitmap for cmr83 char#69 E --- */
      {  69,  163,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x91\xcc\x23\x15\x0a\xff" }  },
      /* --- pixel bitmap for cmr83 char#70 F --- */
      {  70,  198,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbf\xa8\x3a\x8a\x20\x1c" }  },
      /* --- pixel bitmap for cmr83 char#71 G --- */
      {  71,  229,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x51\x28\x10\x0f\x89\x78" }  },
      /* --- pixel bitmap for cmr83 char#72 H --- */
      {  72,  262,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x42\x42\x7e\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr83 char#73 I --- */
      {  73,  299,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x97\x24\xe9" }  },
      /* --- pixel bitmap for cmr83 char#74 J --- */
      {  74,  322,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x44\x44\x75" }  },
      /* --- pixel bitmap for cmr83 char#75 K --- */
      {  75,  347,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf7\x32\x1a\x0e\x16\x12\x22\xe7" }  },
      /* --- pixel bitmap for cmr83 char#76 L --- */
      {  76,  384,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x87\x20\x08\xa2\x28\xfe" }  },
      /* --- pixel bitmap for cmr83 char#77 M --- */
      {  77,  413,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x87\x1b\x66\x98\x52\x4a\xc9\x24\xd3\xed" }  },
      /* --- pixel bitmap for cmr83 char#78 N --- */
      {  78,  466,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe3\x46\x4a\x4a\x52\x72\x62\x47" }  },
      /* --- pixel bitmap for cmr83 char#79 O --- */
      {  79,  511,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\x61\x28\x31" }  },
      /* --- pixel bitmap for cmr83 char#80 P --- */
      {  80,  546,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9f\x28\x8a\x9e\x20\x1c" }  },
      /* --- pixel bitmap for cmr83 char#81 Q --- */
      {  81,  575,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\x61\xe8\x31\x00\x0c" }  },
      /* --- pixel bitmap for cmr83 char#82 R --- */
      {  82,  612,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x91\xc8\x23\x12\x89\xce" }  },
      /* --- pixel bitmap for cmr83 char#83 S --- */
      {  83,  647,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\x31\x8c\x79" }  },
      /* --- pixel bitmap for cmr83 char#84 T --- */
      {  84,  674,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x64\x12\x81\x40\x20\x38" }  },
      /* --- pixel bitmap for cmr83 char#85 U --- */
      {  85,  705,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x42\x42\x42\x42\x42\x42\x3c" }  },
      /* --- pixel bitmap for cmr83 char#86 V --- */
      {  86,  742,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x42\x24\x24\x24\x18\x18\x18" }  },
      /* --- pixel bitmap for cmr83 char#87 W --- */
      {  87,  775,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x77\x17\x11\x55\xa8\x42\x15\xaa\x20\x02\x11" }  },
      /* --- pixel bitmap for cmr83 char#88 X --- */
      {  88,  834,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x67\x24\x18\x18\x18\x34\x24\xe7" }  },
      /* --- pixel bitmap for cmr83 char#89 Y --- */
      {  89,  867,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x24\x28\x38\x10\x10\x10\x38" }  },
      /* --- pixel bitmap for cmr83 char#90 Z --- */
      {  90,  896,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2f\x15\x22\x65\xfc" }  },
      /* --- pixel bitmap for cmr83 char#91 [ --- */
      {  91, 2977,                      /* character number, location */
          9, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  2,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x57\x55\xd5" }  },
      /* --- pixel bitmap for cmr83 char#92 (noname) --- */
      {  92, 3431,                      /* character number, location */
          8, 2,     5, 2,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6d\x01" }  },
      /* --- pixel bitmap for cmr83 char#93 ] --- */
      {  93, 3008,                      /* character number, location */
          9, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  2,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xab\xaa\xea" }  },
      /* --- pixel bitmap for cmr83 char#94 \^ --- */
      {  94, 3155,                      /* character number, location */
          8, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2a" }  },
      /* --- pixel bitmap for cmr83 char#95 (noname) --- */
      {  95, 3168,                      /* character number, location */
          9, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmr83 char#96 (noname) --- */
      {  96, 3039,                      /* character number, location */
          8, 1,     5, 1,     /* topleft row,col, and botleft row,col */
          {  1,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr83 char#97 a --- */
      {  97,  929,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc6\xa5\xec\x01" }  },
      /* --- pixel bitmap for cmr83 char#98 b --- */
      {  98,  950,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x43\x08\x27\xa5\x74" }  },
      /* --- pixel bitmap for cmr83 char#99 c --- */
      {  99,  979,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1e\x91\x06" }  },
      /* --- pixel bitmap for cmr83 char#100 d --- */
      { 100,  998,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c\x21\x97\x52\xf2" }  },
      /* --- pixel bitmap for cmr83 char#101 e --- */
      { 101, 1027,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf6\x91\x06" }  },
      /* --- pixel bitmap for cmr83 char#102 f --- */
      { 102, 1046,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x90\x47\x08\x71" }  },
      /* --- pixel bitmap for cmr83 char#103 g --- */
      { 103, 1069,                      /* character number, location */
          5, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3e\xa5\xe3\x62\x74" }  },
      /* --- pixel bitmap for cmr83 char#104 h --- */
      { 104, 1100,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x43\x08\xa7\x94\xfa" }  },
      /* --- pixel bitmap for cmr83 char#105 i --- */
      { 105, 1129,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x02\x30\x49\x07" }  },
      /* --- pixel bitmap for cmr83 char#106 j --- */
      { 106, 1150,                      /* character number, location */
          9,-1,    -2,-1,     /* topleft row,col, and botleft row,col */
          {  3,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x60\x92\xe4\x01" }  },
      /* --- pixel bitmap for cmr83 char#107 k --- */
      { 107, 1175,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x23\xe2\x66\xb6" }  },
      /* --- pixel bitmap for cmr83 char#108 l --- */
      { 108, 1200,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x24\xe9" }  },
      /* --- pixel bitmap for cmr83 char#109 m --- */
      { 109, 1223,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x24\x49\x92\x74\x1b" }  },
      /* --- pixel bitmap for cmr83 char#110 n --- */
      { 110, 1256,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x29\xf5\x01" }  },
      /* --- pixel bitmap for cmr83 char#111 o --- */
      { 111, 1279,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\xe8\x00" }  },
      /* --- pixel bitmap for cmr83 char#112 p --- */
      { 112, 1302,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x4a\xe9\xc4\x01" }  },
      /* --- pixel bitmap for cmr83 char#113 q --- */
      { 113, 1329,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xa5\xe4\x10\x07" }  },
      /* --- pixel bitmap for cmr83 char#114 r --- */
      { 114, 1356,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x97\x74" }  },
      /* --- pixel bitmap for cmr83 char#115 s --- */
      { 115, 1373,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\x96\x07" }  },
      /* --- pixel bitmap for cmr83 char#116 t --- */
      { 116, 1394,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd2\x64\x1b" }  },
      /* --- pixel bitmap for cmr83 char#117 u --- */
      { 117, 1415,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x29\xe5\x01" }  },
      /* --- pixel bitmap for cmr83 char#118 v --- */
      { 118, 1438,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5b\x29\x42\x00" }  },
      /* --- pixel bitmap for cmr83 char#119 w --- */
      { 119, 1461,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6b\x9b\xcd\x46\x01" }  },
      /* --- pixel bitmap for cmr83 char#120 x --- */
      { 120, 1490,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdb\x10\xb5\x01" }  },
      /* --- pixel bitmap for cmr83 char#121 y --- */
      { 121, 1513,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5b\x29\x42\xc8\x00" }  },
      /* --- pixel bitmap for cmr83 char#122 z --- */
      { 122, 1540,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5f\xaf\x0f" }  },
      /* --- pixel bitmap for cmr83 char#123 (noname) --- */
      { 123, 3450,                      /* character number, location */
          4, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          {  5,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmr83 char#124 (noname) --- */
      { 124, 3459,                      /* character number, location */
          4, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          { 10,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x03" }  },
      /* --- pixel bitmap for cmr83 char#125 (noname) --- */
      { 125, 3177,                      /* character number, location */
          8, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2d" }  },
      /* --- pixel bitmap for cmr83 char#126 \~ --- */
      { 126, 3192,                      /* character number, location */
          8, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c" }  },
      /* --- pixel bitmap for cmr83 char#127 (noname) --- */
      { 127, 3203,                      /* character number, location */
          9, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  3,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x05" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=1 ---
 * mf '\mode=nextscrn; input cmr10'   gives .gf100
 * ----------------------------------------------- */
/* --- fontdef for cmr100 --- */
static	chardef  cmr100[] =
   {
      /* --- pixel bitmap for cmr100 char#0 (noname) --- */
      {   0, 1801,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbf\x28\x8a\x82\x20\x08\x0f" }  },
      /* --- pixel bitmap for cmr100 char#1 (noname) --- */
      {   1, 1832,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x10\x50\xa0\x20\x42\x44\x90\xa0\x80\xff\x01" }  },
      /* --- pixel bitmap for cmr100 char#2 (noname) --- */
      {   2, 1871,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81\x81\x99\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmr100 char#3 (noname) --- */
      {   3, 1912,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x10\x20\xa0\x40\x81\x82\x08\x11\x22\xef\x01" }  },
      /* --- pixel bitmap for cmr100 char#4 (noname) --- */
      {   4, 1951,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\x42\x00\x24\x3c\x24\x00\x81\xff" }  },
      /* --- pixel bitmap for cmr100 char#5 (noname) --- */
      {   5, 1984,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\x91\x48\x24\x12\x89\x44\x77" }  },
      /* --- pixel bitmap for cmr100 char#6 (noname) --- */
      {   6, 2025,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xb1\x90\x88\x20\x12\x85\x7f" }  },
      /* --- pixel bitmap for cmr100 char#7 (noname) --- */
      {   7, 2062,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x66\x89\x10\x10\x10\x10\x10\x10\x7c" }  },
      /* --- pixel bitmap for cmr100 char#8 (noname) --- */
      {   8, 2093,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3e\x84\x2f\x99\x4c\xfa\x10\x3e" }  },
      /* --- pixel bitmap for cmr100 char#9 (noname) --- */
      {   9, 2130,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x10\xd3\x52\x52\x56\x3c\x10\x7c" }  },
      /* --- pixel bitmap for cmr100 char#10 (noname) --- */
      {  10, 2171,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x71\x30\x18\x14\x89\xaa\x77" }  },
      /* --- pixel bitmap for cmr100 char#11 (noname) --- */
      {  11, 3720,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xf8\x89\x10\x21\xf2\x8f\x08\x11\x22\x44\x8c\x01" }  },
      /* --- pixel bitmap for cmr100 char#12 (noname) --- */
      {  12, 3763,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x04\x04\x04\x7f\x64\x44\x44\x44\xc6" }  },
      /* --- pixel bitmap for cmr100 char#13 (noname) --- */
      {  13, 3800,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x44\x44\x44\x7f\x44\x44\x44\x44\xc6" }  },
      /* --- pixel bitmap for cmr100 char#14 (noname) --- */
      {  14, 3843,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x47\x04\x44\x40\x04\xff\x47\x64\x44\x44\x44\x44"
            "\x64\xc4" }  },
      /* --- pixel bitmap for cmr100 char#15 (noname) --- */
      {  15, 3896,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x47\x44\x44\x44\x44\xff\x47\x44\x44\x44\x44\x44"
            "\x64\xc4" }  },
      /* --- pixel bitmap for cmr100 char#16 (noname) --- */
      {  16, 2668,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\xa4\x03" }  },
      /* --- pixel bitmap for cmr100 char#17 (noname) --- */
      {  17, 2687,                      /* character number, location */
          6,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  3,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x26\x49\x92\x03" }  },
      /* --- pixel bitmap for cmr100 char#18 (noname) --- */
      {  18, 3536,                      /* character number, location */
         10, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\x01" }  },
      /* --- pixel bitmap for cmr100 char#19 (noname) --- */
      {  19, 3549,                      /* character number, location */
         10, 2,     7, 2,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x54\x00" }  },
      /* --- pixel bitmap for cmr100 char#20 (noname) --- */
      {  20, 3562,                      /* character number, location */
          9, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  4,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr100 char#21 (noname) --- */
      {  21, 3571,                      /* character number, location */
         10, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  4,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x99\x06" }  },
      /* --- pixel bitmap for cmr100 char#22 (noname) --- */
      {  22, 3588,                      /* character number, location */
          8, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  4,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr100 char#23 (noname) --- */
      {  23, 3597,                      /* character number, location */
         10, 3,     7, 3,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xef\x01" }  },
      /* --- pixel bitmap for cmr100 char#24 (noname) --- */
      {  24, 3612,                      /* character number, location */
          0, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x76\x00" }  },
      /* --- pixel bitmap for cmr100 char#25 \ss --- */
      {  25, 2712,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x24\x49\x9b\x24\x8a\xe2\x06" }  },
      /* --- pixel bitmap for cmr100 char#26 \ae --- */
      {  26, 2757,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x77\x88\xfe\x09\x99\x76" }  },
      /* --- pixel bitmap for cmr100 char#27 \oe --- */
      {  27, 2788,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdc\x81\x18\x7e\x08\x73\x7a\x07" }  },
      /* --- pixel bitmap for cmr100 char#28 (noname) --- */
      {  28, 2821,                      /* character number, location */
          7, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa0\x97\xa7\xe5\xe9\x05" }  },
      /* --- pixel bitmap for cmr100 char#29 \AE --- */
      {  29, 2856,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf8\x43\x11\xca\x50\x86\x1f\x92\x92\x94\x44\xf7\x03" }  },
      /* --- pixel bitmap for cmr100 char#30 \OE --- */
      {  30, 2911,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\x27\x46\x61\x16\x64\xc1\x13\xa4\x63\x6a\x46\xfc"
            "\x07" }  },
      /* --- pixel bitmap for cmr100 char#31 (noname) --- */
      {  31, 2966,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x40\x3c\x62\x91\x91\x99\x89\x89\x46\x3c\x02" }  },
      /* --- pixel bitmap for cmr100 char#32 (noname) --- */
      {  32, 3644,                      /* character number, location */
          5, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          {  3,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr100 char#33 ! --- */
      {  33, 3019,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x02" }  },
      /* --- pixel bitmap for cmr100 char#34 " --- */
      {  34, 3955,                      /* character number, location */
         10, 0,     6, 0,     /* topleft row,col, and botleft row,col */
          {  3,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6d\x0b" }  },
      /* --- pixel bitmap for cmr100 char#35 # --- */
      {  35, 3065,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x90\x20\x41\x82\xf4\x1f\x09\x09\x12\xff\x25\x48\x90"
            "\x20\x01" }  },
      /* --- pixel bitmap for cmr100 char#36 $ --- */
      {  36, 2532,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  4,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd6\x5d\xc6\xdc\x6d\x04" }  },
      /* --- pixel bitmap for cmr100 char#37 % --- */
      {  37, 3120,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x82\xda\x54\x29\x21\x02\x12\x52\xa4\x44\x89\x0a\x02" }  },
      /* --- pixel bitmap for cmr100 char#38 & --- */
      {  38, 2571,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c\x12\x12\x1a\xee\x26\x27\x19\x91\xee" }  },
      /* --- pixel bitmap for cmr100 char#39 (noname) --- */
      {  39, 3187,                      /* character number, location */
         10, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  1,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr100 char#40 ( --- */
      {  40, 3202,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x94\x92\x24\x89\x44" }  },
      /* --- pixel bitmap for cmr100 char#41 ) --- */
      {  41, 3235,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x91\x48\x92\xa4\x14" }  },
      /* --- pixel bitmap for cmr100 char#42 * --- */
      {  42, 3268,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd4\xff\x4d" }  },
      /* --- pixel bitmap for cmr100 char#43 + --- */
      {  43, 3291,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x10\x10\x10\xff\x10\x10\x10\x10" }  },
      /* --- pixel bitmap for cmr100 char#44 (noname) --- */
      {  44, 3316,                      /* character number, location */
          1, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr100 char#45 (noname) --- */
      {  45, 3978,                      /* character number, location */
          4, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          {  3,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr100 char#46 (noname) --- */
      {  46, 3331,                      /* character number, location */
          1, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmr100 char#47 / --- */
      {  47, 3340,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x48\x44\x22\x22\x11\x01" }  },
      /* --- pixel bitmap for cmr100 char#48 0 --- */
      {  48, 2216,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x14\x86\x61\x18\x4a\x1e" }  },
      /* --- pixel bitmap for cmr100 char#49 1 --- */
      {  49, 2255,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x74\x44\x44\x44\x0e" }  },
      /* --- pixel bitmap for cmr100 char#50 2 --- */
      {  50, 2280,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x89\x48\xa2\x0f" }  },
      /* --- pixel bitmap for cmr100 char#51 3 --- */
      {  51, 2311,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x26\x21\xe4\x60\x8c\x0e" }  },
      /* --- pixel bitmap for cmr100 char#52 4 --- */
      {  52, 2342,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x46\x49\xd3\x0f\x41\x38" }  },
      /* --- pixel bitmap for cmr100 char#53 5 --- */
      {  53, 2373,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x71\x89\x99\x06" }  },
      /* --- pixel bitmap for cmr100 char#54 6 --- */
      {  54, 2404,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x71\x99\x99\x06" }  },
      /* --- pixel bitmap for cmr100 char#55 7 --- */
      {  55, 2437,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x22\x42\x84\x10\x02" }  },
      /* --- pixel bitmap for cmr100 char#56 8 --- */
      {  56, 2464,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x69\x96\x99\x06" }  },
      /* --- pixel bitmap for cmr100 char#57 9 --- */
      {  57, 2499,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x99\xe9\x48\x03" }  },
      /* --- pixel bitmap for cmr100 char#58 : --- */
      {  58, 3373,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x21" }  },
      /* --- pixel bitmap for cmr100 char#59 ; --- */
      {  59, 3386,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe1\x01" }  },
      /* --- pixel bitmap for cmr100 char#60 (noname) --- */
      {  60, 3042,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  1,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf1\x03" }  },
      /* --- pixel bitmap for cmr100 char#61 = --- */
      {  61, 3405,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmr100 char#62 (noname) --- */
      {  62, 2643,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x02\x00\x22\x12\x69" }  },
      /* --- pixel bitmap for cmr100 char#63 (noname) --- */
      {  63, 2618,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x48\x22\x00\x20" }  },
      /* --- pixel bitmap for cmr100 char#64 (noname) --- */
      {  64, 3418,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x7e\xe7\xc3\xc3\xe7\xfe\x02\xfc" }  },
      /* --- pixel bitmap for cmr100 char#65 A --- */
      {  65,   35,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x10\x20\xa0\x40\x81\x82\x0f\x11\x22\xef\x01" }  },
      /* --- pixel bitmap for cmr100 char#66 B --- */
      {  66,   72,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\xa1\x50\xec\x13\x0a\x85\x3f" }  },
      /* --- pixel bitmap for cmr100 char#67 C --- */
      {  67,  109,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x61\x30\x10\x08\x04\x85\x3c" }  },
      /* --- pixel bitmap for cmr100 char#68 D --- */
      {  68,  142,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x42\x82\x82\x82\x82\x82\x42\x3f" }  },
      /* --- pixel bitmap for cmr100 char#69 E --- */
      {  69,  181,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\x42\x62\x62\x3e\xa2\xa2\xc2\xff" }  },
      /* --- pixel bitmap for cmr100 char#70 F --- */
      {  70,  222,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbf\x28\xcb\x9e\x24\x09\x0f" }  },
      /* --- pixel bitmap for cmr100 char#71 G --- */
      {  71,  257,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xbc\x84\x09\x0a\x10\x3e\x90\x20\x41\xfc\x00" }  },
      /* --- pixel bitmap for cmr100 char#72 H --- */
      {  72,  296,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x77\x91\x48\xe4\x13\x89\x44\x77" }  },
      /* --- pixel bitmap for cmr100 char#73 I --- */
      {  73,  337,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x97\x24\x49\x07" }  },
      /* --- pixel bitmap for cmr100 char#74 J --- */
      {  74,  362,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1e\x21\x84\x10\x4a\x07" }  },
      /* --- pixel bitmap for cmr100 char#75 K --- */
      {  75,  389,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xf7\x64\x48\x50\x60\xc1\x84\x08\x21\xc7\x01" }  },
      /* --- pixel bitmap for cmr100 char#76 L --- */
      {  76,  432,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8f\x20\x08\x82\x28\xca\x3f" }  },
      /* --- pixel bitmap for cmr100 char#77 M --- */
      {  77,  463,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x87\x1b\x66\x98\x52\x4a\x29\x25\x93\x4c\xb7\x03" }  },
      /* --- pixel bitmap for cmr100 char#78 N --- */
      {  78,  524,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x73\x93\x49\xa5\x52\xc9\x64\x27" }  },
      /* --- pixel bitmap for cmr100 char#79 O --- */
      {  79,  573,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81\x81\x81\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmr100 char#80 P --- */
      {  80,  612,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\xa1\x50\xe8\x13\x08\x04\x07" }  },
      /* --- pixel bitmap for cmr100 char#81 Q --- */
      {  81,  643,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x3c\x42\x81\x81\x81\x81\x81\x5a\x3c\x00\x20\xc0" }  },
      /* --- pixel bitmap for cmr100 char#82 R --- */
      {  82,  690,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x22\x22\x22\x1e\x22\x22\x22\xe7" }  },
      /* --- pixel bitmap for cmr100 char#83 S --- */
      {  83,  729,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3e\x86\xe1\x20\x8c\x0f" }  },
      /* --- pixel bitmap for cmr100 char#84 T --- */
      {  84,  758,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xff\x23\x46\x8c\x08\x01\x02\x04\x08\x7c\x00" }  },
      /* --- pixel bitmap for cmr100 char#85 U --- */
      {  85,  795,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x77\x91\x48\x24\x12\x89\x44\x1c" }  },
      /* --- pixel bitmap for cmr100 char#86 V --- */
      {  86,  836,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xc7\x89\x10\x21\x82\x02\x05\x0a\x08\x10\x00" }  },
      /* --- pixel bitmap for cmr100 char#87 W --- */
      {  87,  875,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe7\x9c\x88\x90\x12\x52\x42\x4a\x50\x05\xc6\xc0\x18"
            "\x18\x03" }  },
      /* --- pixel bitmap for cmr100 char#88 X --- */
      {  88,  938,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xef\x48\xa0\xc0\x00\x01\x05\x0a\x22\xc7\x01" }  },
      /* --- pixel bitmap for cmr100 char#89 Y --- */
      {  89,  977,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xc7\x89\x90\x41\x81\x01\x02\x04\x08\x38\x00" }  },
      /* --- pixel bitmap for cmr100 char#90 Z --- */
      {  90, 1010,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\xa7\x46\xac\x9c\x1f" }  },
      /* --- pixel bitmap for cmr100 char#91 [ --- */
      {  91, 3455,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x92\x24\x49\x72" }  },
      /* --- pixel bitmap for cmr100 char#92 (noname) --- */
      {  92, 3987,                      /* character number, location */
         10, 3,     6, 3,     /* topleft row,col, and botleft row,col */
          {  3,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6d\x0b" }  },
      /* --- pixel bitmap for cmr100 char#93 ] --- */
      {  93, 3488,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x27\x49\x92\x24\x79" }  },
      /* --- pixel bitmap for cmr100 char#94 \^ --- */
      {  94, 3653,                      /* character number, location */
         10, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96" }  },
      /* --- pixel bitmap for cmr100 char#95 (noname) --- */
      {  95, 3666,                      /* character number, location */
         10, 1,     9, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmr100 char#96 (noname) --- */
      {  96, 3521,                      /* character number, location */
         10, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  1,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr100 char#97 a --- */
      {  97, 1047,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e\xe4\x45\xb1\x0f" }  },
      /* --- pixel bitmap for cmr100 char#98 b --- */
      {  98, 1070,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x03\x81\x40\xe0\x11\x09\x85\x22\x0f" }  },
      /* --- pixel bitmap for cmr100 char#99 c --- */
      {  99, 1105,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3e\x84\x10\x1d" }  },
      /* --- pixel bitmap for cmr100 char#100 d --- */
      { 100, 1126,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x10\x08\xc4\x13\x85\x42\x22\x3e" }  },
      /* --- pixel bitmap for cmr100 char#101 e --- */
      { 101, 1161,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xfe\x10\x1d" }  },
      /* --- pixel bitmap for cmr100 char#102 f --- */
      { 102, 1184,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x10\xf2\x08\x21\xc4\x01" }  },
      /* --- pixel bitmap for cmr100 char#103 g --- */
      { 103, 1211,                      /* character number, location */
          6, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbc\x24\x39\x82\x17\x86\xa1\x07" }  },
      /* --- pixel bitmap for cmr100 char#104 h --- */
      { 104, 1248,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x03\x81\x40\xe0\x11\x89\x44\xa2\x3b" }  },
      /* --- pixel bitmap for cmr100 char#105 i --- */
      { 105, 1285,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x02\x30\x49\x3a" }  },
      /* --- pixel bitmap for cmr100 char#106 j --- */
      { 106, 1308,                      /* character number, location */
         10,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x60\x92\x24\x39" }  },
      /* --- pixel bitmap for cmr100 char#107 k --- */
      { 107, 1337,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x83\x20\x08\xbe\x62\x28\xca\x0c" }  },
      /* --- pixel bitmap for cmr100 char#108 l --- */
      { 108, 1372,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x24\x49\x3a" }  },
      /* --- pixel bitmap for cmr100 char#109 m --- */
      { 109, 1399,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdf\x11\x91\x88\x44\x24\xa2\xbb\x03" }  },
      /* --- pixel bitmap for cmr100 char#110 n --- */
      { 110, 1440,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x91\x48\x24\xba\x03" }  },
      /* --- pixel bitmap for cmr100 char#111 o --- */
      { 111, 1469,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x18\x86\xa1\x07" }  },
      /* --- pixel bitmap for cmr100 char#112 p --- */
      { 112, 1496,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x91\x50\x28\xf2\x08\x04\x07" }  },
      /* --- pixel bitmap for cmr100 char#113 q --- */
      { 113, 1529,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x14\x45\x91\x07\x41\x38" }  },
      /* --- pixel bitmap for cmr100 char#114 r --- */
      { 114, 1562,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2f\x22\x72" }  },
      /* --- pixel bitmap for cmr100 char#115 s --- */
      { 115, 1581,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\xc7\x79" }  },
      /* --- pixel bitmap for cmr100 char#116 t --- */
      { 116, 1604,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x92\x2e\xd9\x06" }  },
      /* --- pixel bitmap for cmr100 char#117 u --- */
      { 117, 1629,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x33\x91\x48\x24\xe2\x03" }  },
      /* --- pixel bitmap for cmr100 char#118 v --- */
      { 118, 1658,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb3\xc4\x30\x0c\x03" }  },
      /* --- pixel bitmap for cmr100 char#119 w --- */
      { 119, 1681,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x55\xa9\x62\xc3\x86\x08" }  },
      /* --- pixel bitmap for cmr100 char#120 x --- */
      { 120, 1722,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x33\xc3\x30\xcc\x0c" }  },
      /* --- pixel bitmap for cmr100 char#121 y --- */
      { 121, 1745,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb3\xc4\x30\x0c\x43\x10\x03" }  },
      /* --- pixel bitmap for cmr100 char#122 z --- */
      { 122, 1774,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x35\x2b\x3f" }  },
      /* --- pixel bitmap for cmr100 char#123 (noname) --- */
      { 123, 4010,                      /* character number, location */
          4, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f" }  },
      /* --- pixel bitmap for cmr100 char#124 (noname) --- */
      { 124, 4019,                      /* character number, location */
          4, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          { 13,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x1f" }  },
      /* --- pixel bitmap for cmr100 char#125 (noname) --- */
      { 125, 3675,                      /* character number, location */
         10, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  4,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaa\x05" }  },
      /* --- pixel bitmap for cmr100 char#126 \~ --- */
      { 126, 3694,                      /* character number, location */
          9, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5a" }  },
      /* --- pixel bitmap for cmr100 char#127 (noname) --- */
      { 127, 3709,                      /* character number, location */
         10, 1,     9, 1,     /* topleft row,col, and botleft row,col */
          {  4,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x09" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=2 ---
 * mf '\mode=lview; input cmr10'      gives .gf118
 * ----------------------------------------------- */
/* --- fontdef for cmr118 --- */
static	chardef  cmr118[] =
   {
      /* --- pixel bitmap for cmr118 char#0 (noname) --- */
      {   0, 2023,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x84\x84\x84\x04\x04\x04\x04\x04\x1f" }  },
      /* --- pixel bitmap for cmr118 char#1 (noname) --- */
      {   1, 2056,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x80\x02\x14\x10\x81\x08\x82\x10\x44\x40\x03\xfe"
            "\x3f" }  },
      /* --- pixel bitmap for cmr118 char#2 (noname) --- */
      {   2, 2099,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x78\x18\x26\x50\x80\x49\x26\x19\xa0\x40\x86\xe1\x01" }  },
      /* --- pixel bitmap for cmr118 char#3 (noname) --- */
      {   3, 2150,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x30\xc0\x00\x03\x12\x48\x20\x81\x04\x21\x84\x3c\x0f" }  },
      /* --- pixel bitmap for cmr118 char#4 (noname) --- */
      {   4, 2191,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x81\x00\x42\x7e\x42\x00\x00\x81\xff" }  },
      /* --- pixel bitmap for cmr118 char#5 (noname) --- */
      {   5, 2224,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x27\x08\x41\x08\x42\x10\x82\x10\x84\x20\x04\xf9"
            "\x3e" }  },
      /* --- pixel bitmap for cmr118 char#6 (noname) --- */
      {   6, 2269,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xff\x07\x1b\x24\x88\x00\x01\x43\x82\x82\xff\x03" }  },
      /* --- pixel bitmap for cmr118 char#7 (noname) --- */
      {   7, 2308,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xce\x45\x08\x02\x08\x20\x80\x00\x02\x08\x20\xe0\x03" }  },
      /* --- pixel bitmap for cmr118 char#8 (noname) --- */
      {   8, 2341,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x7c\x20\xf0\x91\x14\x31\xa2\x24\x3e\x10\xf8\x00" }  },
      /* --- pixel bitmap for cmr118 char#9 (noname) --- */
      {   9, 2384,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf8\x80\x30\xb2\x48\x22\x89\x44\x0a\x1e\x20\xe0\x03" }  },
      /* --- pixel bitmap for cmr118 char#10 (noname) --- */
      {  10, 2431,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x7c\x04\x05\x0c\x18\x30\xa0\x20\x41\x45\x8d\x01" }  },
      /* --- pixel bitmap for cmr118 char#11 (noname) --- */
      {  11, 4144,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x47\x04\x22\xfe\x87\x08\x44\x20\x02\x11\x88\x60"
            "\x1c" }  },
      /* --- pixel bitmap for cmr118 char#12 (noname) --- */
      {  12, 4187,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xf8\x08\x10\xf8\x47\x8c\x10\x21\x42\x84\x0c\x03" }  },
      /* --- pixel bitmap for cmr118 char#13 (noname) --- */
      {  13, 4226,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xf8\x08\x11\xfa\x47\x88\x10\x21\x42\x84\x9c\x03" }  },
      /* --- pixel bitmap for cmr118 char#14 (noname) --- */
      {  14, 4269,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x0f\x11\x20\x82\xff\x87\xc8\x10\x11\x22\x42\x44"
            "\x88\x88\x11\x03" }  },
      /* --- pixel bitmap for cmr118 char#15 (noname) --- */
      {  15, 4324,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x0f\x11\x21\xa2\xff\x87\x88\x10\x11\x22\x42\x44"
            "\x88\x88\x11\x03" }  },
      /* --- pixel bitmap for cmr118 char#16 (noname) --- */
      {  16, 2984,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x24\x1d" }  },
      /* --- pixel bitmap for cmr118 char#17 (noname) --- */
      {  17, 3005,                      /* character number, location */
          7,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x88\x88\x88\x78" }  },
      /* --- pixel bitmap for cmr118 char#18 (noname) --- */
      {  18, 3964,                      /* character number, location */
         10, 2,     8, 2,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x09" }  },
      /* --- pixel bitmap for cmr118 char#19 (noname) --- */
      {  19, 3975,                      /* character number, location */
         10, 3,     8, 3,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x06" }  },
      /* --- pixel bitmap for cmr118 char#20 (noname) --- */
      {  20, 3986,                      /* character number, location */
         10, 2,     8, 2,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x15" }  },
      /* --- pixel bitmap for cmr118 char#21 (noname) --- */
      {  21, 3999,                      /* character number, location */
         10, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  5,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd1\x01" }  },
      /* --- pixel bitmap for cmr118 char#22 (noname) --- */
      {  22, 4012,                      /* character number, location */
          9, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  5,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmr118 char#23 (noname) --- */
      {  23, 4021,                      /* character number, location */
         10, 4,     8, 4,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f" }  },
      /* --- pixel bitmap for cmr118 char#24 (noname) --- */
      {  24, 4032,                      /* character number, location */
          0, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe2\x01" }  },
      /* --- pixel bitmap for cmr118 char#25 \ss --- */
      {  25, 3032,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x91\x68\x23\x12\x0a\x85\xc2\x1d" }  },
      /* --- pixel bitmap for cmr118 char#26 \ae --- */
      {  26, 3077,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xcf\xc1\xc8\xff\x04\x11\xc4\xe8\x1c" }  },
      /* --- pixel bitmap for cmr118 char#27 \oe --- */
      {  27, 3112,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x93\x62\xf8\x43\x10\x02\x29\x32\x0e" }  },
      /* --- pixel bitmap for cmr118 char#28 (noname) --- */
      {  28, 3155,                      /* character number, location */
          8, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x40\x9e\x2c\x9a\x2c\x9a\x3c\x01" }  },
      /* --- pixel bitmap for cmr118 char#29 \AE --- */
      {  29, 3196,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x1f\x14\x06\x05\x41\x51\x48\x04\xfe\x81\x44\x12"
            "\x91\x44\xd0\xfb\x07" }  },
      /* --- pixel bitmap for cmr118 char#30 \OE --- */
      {  30, 3259,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x3f\x42\x98\x20\x2a\x10\x15\xf8\x08\x44\x04\x22"
            "\x05\x81\x86\x20\xfc\x1f" }  },
      /* --- pixel bitmap for cmr118 char#31 (noname) --- */
      {  31, 3322,                      /* character number, location */
         11, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\xe1\x63\x9c\x50\x21\x86\x18\x61\x84\x0a\x39\xc6"
            "\x87\x00" }  },
      /* --- pixel bitmap for cmr118 char#32 (noname) --- */
      {  32, 4064,                      /* character number, location */
          6, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1e" }  },
      /* --- pixel bitmap for cmr118 char#33 ! --- */
      {  33, 3381,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x03\x0f" }  },
      /* --- pixel bitmap for cmr118 char#34 " --- */
      {  34, 4383,                      /* character number, location */
         10, 0,     5, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7b\x4b\x99\x00" }  },
      /* --- pixel bitmap for cmr118 char#35 # --- */
      {  35, 3429,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x01\x09\x48\x20\xf1\x7f\x24\x20\x01\x12\xff\x47"
            "\x02\x09\x48\x40\x02" }  },
      /* --- pixel bitmap for cmr118 char#36 $ --- */
      {  36, 2830,                      /* character number, location */
         11, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  5,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc4\xd5\x5a\x0c\xa3\xb5\x3a\x02" }  },
      /* --- pixel bitmap for cmr118 char#37 % --- */
      {  37, 3484,                      /* character number, location */
         11, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x06\x4a\x4c\x7e\x12\x91\x04\x13\x80\x0c\x92\x88\x24"
            "\x24\x21\x05\x06" }  },
      /* --- pixel bitmap for cmr118 char#38 & --- */
      {  38, 2881,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x18\x90\x40\x02\xf5\x8c\x30\xb2\x44\x0c\x31\x3a\x07" }  },
      /* --- pixel bitmap for cmr118 char#39 (noname) --- */
      {  39, 3553,                      /* character number, location */
         10, 1,     5, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaf\x01" }  },
      /* --- pixel bitmap for cmr118 char#40 ( --- */
      {  40, 3570,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  3,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x94\x92\x24\x49\x22\x11" }  },
      /* --- pixel bitmap for cmr118 char#41 ) --- */
      {  41, 3607,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  3,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x91\x48\x92\x24\x29\x05" }  },
      /* --- pixel bitmap for cmr118 char#42 * --- */
      {  42, 3644,                      /* character number, location */
         11, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x7c\xf2\x09\x01" }  },
      /* --- pixel bitmap for cmr118 char#43 + --- */
      {  43, 3665,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x80\x00\x02\x08\x20\xfc\x0f\x02\x08\x20\x80\x00"
            "\x02" }  },
      /* --- pixel bitmap for cmr118 char#44 (noname) --- */
      {  44, 3694,                      /* character number, location */
          2, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaf\x01" }  },
      /* --- pixel bitmap for cmr118 char#45 (noname) --- */
      {  45, 4410,                      /* character number, location */
          4, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          {  3,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmr118 char#46 (noname) --- */
      {  46, 3711,                      /* character number, location */
          2, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr118 char#47 / --- */
      {  47, 3722,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x22\x84\x10\x21\x44\x08\x21\x42\x00" }  },
      /* --- pixel bitmap for cmr118 char#48 0 --- */
      {  48, 2480,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\x18\x63\x8c\xd1\x01" }  },
      /* --- pixel bitmap for cmr118 char#49 1 --- */
      {  49, 2519,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe4\x10\x42\x08\x21\xe4\x03" }  },
      /* --- pixel bitmap for cmr118 char#50 2 --- */
      {  50, 2546,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46\x08\x11\x23\xf2\x03" }  },
      /* --- pixel bitmap for cmr118 char#51 3 --- */
      {  51, 2579,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46\xe8\x20\x8c\xd1\x01" }  },
      /* --- pixel bitmap for cmr118 char#52 4 --- */
      {  52, 2614,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x0c\x45\x32\xf9\x43\x20\x10\x1c" }  },
      /* --- pixel bitmap for cmr118 char#53 5 --- */
      {  53, 2647,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf1\x85\xf0\x22\x8c\xd9\x01" }  },
      /* --- pixel bitmap for cmr118 char#54 6 --- */
      {  54, 2682,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\xc6\xf0\x62\x8c\xd2\x01" }  },
      /* --- pixel bitmap for cmr118 char#55 7 --- */
      {  55, 2721,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\x08\x21\x08\x41\x10\x04\x01" }  },
      /* --- pixel bitmap for cmr118 char#56 8 --- */
      {  56, 2750,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46\xcd\x54\x8c\xd1\x01" }  },
      /* --- pixel bitmap for cmr118 char#57 9 --- */
      {  57, 2791,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc5\x18\x3d\x8c\xc9\x00" }  },
      /* --- pixel bitmap for cmr118 char#58 : --- */
      {  58, 3759,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\x3c" }  },
      /* --- pixel bitmap for cmr118 char#59 ; --- */
      {  59, 3776,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  2,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xbc\x06" }  },
      /* --- pixel bitmap for cmr118 char#60 (noname) --- */
      {  60, 3404,                      /* character number, location */
          8, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  2,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xfc\x3f" }  },
      /* --- pixel bitmap for cmr118 char#61 = --- */
      {  61, 3799,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          { 10,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x03\x00\x00\x00\xff\x03" }  },
      /* --- pixel bitmap for cmr118 char#62 (noname) --- */
      {  62, 2957,                      /* character number, location */
          8, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc6\x00\x00\x8c\x10\x21\x3a" }  },
      /* --- pixel bitmap for cmr118 char#63 (noname) --- */
      {  63, 2932,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x22\x42\x00\x00\xc6\x00" }  },
      /* --- pixel bitmap for cmr118 char#64 (noname) --- */
      {  64, 3812,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x78\x10\x22\x53\xb3\x85\x16\xda\xac\x6c\x04\xe0\x0f" }  },
      /* --- pixel bitmap for cmr118 char#65 A --- */
      {  65,   35,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x01\x14\xa0\x00\x05\x44\xe0\x03\x11\x04\x79"
            "\x3c" }  },
      /* --- pixel bitmap for cmr118 char#66 B --- */
      {  66,   76,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xff\x10\x4c\x20\x81\xfc\x11\x44\x20\x81\x04\xff\x03" }  },
      /* --- pixel bitmap for cmr118 char#67 C --- */
      {  67,  117,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x78\x09\x0b\x0c\x10\x20\x40\x00\x81\x84\xf1\x00" }  },
      /* --- pixel bitmap for cmr118 char#68 D --- */
      {  68,  154,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xff\x10\x46\x10\x81\x04\x12\x48\x20\x41\x84\xfd\x03" }  },
      /* --- pixel bitmap for cmr118 char#69 E --- */
      {  69,  197,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xff\x11\x46\x14\x51\x7c\x10\x41\x24\x81\x04\xfd\x07" }  },
      /* --- pixel bitmap for cmr118 char#70 F --- */
      {  70,  244,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xff\x09\x13\x25\xca\x87\x08\x11\x02\x04\x3e\x00" }  },
      /* --- pixel bitmap for cmr118 char#71 G --- */
      {  71,  285,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x78\x11\x26\x50\x00\x01\x04\x1f\x90\x40\x04\xe1\x07" }  },
      /* --- pixel bitmap for cmr118 char#72 H --- */
      {  72,  326,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xdf\x27\x08\x41\x08\xc2\x1f\x82\x10\x84\x20\x04\xf9"
            "\x3e" }  },
      /* --- pixel bitmap for cmr118 char#73 I --- */
      {  73,  371,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9f\x10\x42\x08\x21\xe4\x03" }  },
      /* --- pixel bitmap for cmr118 char#74 J --- */
      {  74,  398,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1e\x21\x84\x10\x42\xe9\x00" }  },
      /* --- pixel bitmap for cmr118 char#75 K --- */
      {  75,  427,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x9f\x27\x04\x11\x48\x40\x03\x26\x10\x82\x10\x04\xf9"
            "\x3c" }  },
      /* --- pixel bitmap for cmr118 char#76 L --- */
      {  76,  474,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x04\x04\x04\x04\x04\x84\x84\xc4\xff" }  },
      /* --- pixel bitmap for cmr118 char#77 M --- */
      {  77,  507,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\x3c\x03\xc3\xa1\x50\x28\x14\x0a\x49\x42\x92\x90"
            "\x22\xc4\xc8\xb7\x0f" }  },
      /* --- pixel bitmap for cmr118 char#78 N --- */
      {  78,  580,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc7\x67\x08\x43\x28\x42\x12\x92\x10\x85\x20\x84\xf9"
            "\x08" }  },
      /* --- pixel bitmap for cmr118 char#79 O --- */
      {  79,  635,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x78\x18\x26\x50\x80\x01\x06\x18\xa0\x40\x86\xe1\x01" }  },
      /* --- pixel bitmap for cmr118 char#80 P --- */
      {  80,  678,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x7f\x08\x13\x24\x48\x98\x0f\x01\x02\x04\x3e\x00" }  },
      /* --- pixel bitmap for cmr118 char#81 Q --- */
      {  81,  713,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x18\x26\x50\x80\x01\x06\x18\xa0\x40\xbe\xe1\x01"
            "\x00\x00\x80\x01" }  },
      /* --- pixel bitmap for cmr118 char#82 R --- */
      {  82,  760,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7f\x20\x08\x41\x08\xc2\x07\x62\x10\x82\x10\x84\xf8"
            "\x38" }  },
      /* --- pixel bitmap for cmr118 char#83 S --- */
      {  83,  803,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\x18\x04\x0e\x04\x82\xe1\x07" }  },
      /* --- pixel bitmap for cmr118 char#84 T --- */
      {  84,  834,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xff\x23\x46\x8c\x08\x01\x02\x04\x08\x10\xf8\x00" }  },
      /* --- pixel bitmap for cmr118 char#85 U --- */
      {  85,  873,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xdf\x27\x08\x41\x08\x42\x10\x82\x10\x84\x20\x88\x80"
            "\x03" }  },
      /* --- pixel bitmap for cmr118 char#86 V --- */
      {  86,  918,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x8f\x27\x08\x41\x10\x81\x08\x44\x40\x01\x0a\x50\x00"
            "\x01" }  },
      /* --- pixel bitmap for cmr118 char#87 W --- */
      {  87,  963,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xcf\xf3\x84\x21\x84\x21\x44\x22\x48\x12\x48\x12\x28"
            "\x14\x30\x0c\x30\x0c\x30\x0c" }  },
      /* --- pixel bitmap for cmr118 char#88 X --- */
      {  88, 1032,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xcf\x43\x04\x12\xa0\x00\x02\x18\x40\x01\x11\x84\x79"
            "\x3c" }  },
      /* --- pixel bitmap for cmr118 char#89 Y --- */
      {  89, 1075,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x8f\x27\x08\x22\xb0\x01\x05\x10\x80\x00\x04\x20\xc0"
            "\x07" }  },
      /* --- pixel bitmap for cmr118 char#90 Z --- */
      {  90, 1112,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x51\x28\x82\x40\x12\x85\xe2\x3f" }  },
      /* --- pixel bitmap for cmr118 char#91 [ --- */
      {  91, 3873,                      /* character number, location */
         11, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x11\x11\x11\x11\x11\x11\x0f" }  },
      /* --- pixel bitmap for cmr118 char#92 (noname) --- */
      {  92, 4419,                      /* character number, location */
         10, 2,     5, 2,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x32\xa5\xbd\x01" }  },
      /* --- pixel bitmap for cmr118 char#93 ] --- */
      {  93, 3910,                      /* character number, location */
         11, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8f\x88\x88\x88\x88\x88\x88\x0f" }  },
      /* --- pixel bitmap for cmr118 char#94 \^ --- */
      {  94, 4075,                      /* character number, location */
         10, 2,     8, 2,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2a" }  },
      /* --- pixel bitmap for cmr118 char#95 (noname) --- */
      {  95, 4088,                      /* character number, location */
         11, 1,     9, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr118 char#96 (noname) --- */
      {  96, 3947,                      /* character number, location */
         10, 1,     5, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd6\x03" }  },
      /* --- pixel bitmap for cmr118 char#97 a --- */
      {  97, 1153,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\x84\x59\x51\xec\x03" }  },
      /* --- pixel bitmap for cmr118 char#98 b --- */
      {  98, 1180,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x03\x81\x40\x67\x12\x0a\x85\x26\x1d" }  },
      /* --- pixel bitmap for cmr118 char#99 c --- */
      {  99, 1221,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6e\x84\x10\xa6\x03" }  },
      /* --- pixel bitmap for cmr118 char#100 d --- */
      { 100, 1244,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x10\xc8\x25\x0b\x85\x42\x32\x37" }  },
      /* --- pixel bitmap for cmr118 char#101 e --- */
      { 101, 1285,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\xf8\x07\x81\xc8\x01" }  },
      /* --- pixel bitmap for cmr118 char#102 f --- */
      { 102, 1310,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x41\x7c\x04\x41\x10\x84\x03" }  },
      /* --- pixel bitmap for cmr118 char#103 g --- */
      { 103, 1337,                      /* character number, location */
          7, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  7,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x89\x44\xe2\x10\xf8\x82\xc1\x31\x07" }  },
      /* --- pixel bitmap for cmr118 char#104 h --- */
      { 104, 1378,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x03\x02\x02\x3a\x46\x42\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr118 char#105 i --- */
      { 105, 1419,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1b\x30\x49\xd2\x01" }  },
      /* --- pixel bitmap for cmr118 char#106 j --- */
      { 106, 1446,                      /* character number, location */
         11,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  4,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xcc\x00\x8c\x88\x88\x88\x78" }  },
      /* --- pixel bitmap for cmr118 char#107 k --- */
      { 107, 1479,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x03\x81\x40\xaf\x51\x38\x34\x92\x3b" }  },
      /* --- pixel bitmap for cmr118 char#108 l --- */
      { 108, 1518,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x24\x49\x3a" }  },
      /* --- pixel bitmap for cmr118 char#109 m --- */
      { 109, 1545,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdf\x31\x93\x88\x44\x24\x22\x11\x9d\x19" }  },
      /* --- pixel bitmap for cmr118 char#110 n --- */
      { 110, 1592,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3b\x46\x42\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr118 char#111 o --- */
      { 111, 1627,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x51\x30\x18\x14\x71\x00" }  },
      /* --- pixel bitmap for cmr118 char#112 p --- */
      { 112, 1658,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3b\x93\x50\x28\x34\xe9\x04\x82\x03" }  },
      /* --- pixel bitmap for cmr118 char#113 q --- */
      { 113, 1699,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x59\x28\x14\x92\xb9\x40\x20\x38" }  },
      /* --- pixel bitmap for cmr118 char#114 r --- */
      { 114, 1740,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdf\x08\x21\xc4\x01" }  },
      /* --- pixel bitmap for cmr118 char#115 s --- */
      { 115, 1761,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x05\x17\xe3\x03" }  },
      /* --- pixel bitmap for cmr118 char#116 t --- */
      { 116, 1788,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x22\x2f\x22\xaa\x04" }  },
      /* --- pixel bitmap for cmr118 char#117 u --- */
      { 117, 1817,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x63\x42\x42\x42\x42\x42\xfc" }  },
      /* --- pixel bitmap for cmr118 char#118 v --- */
      { 118, 1850,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x24\x24\x24\x18\x18\x18" }  },
      /* --- pixel bitmap for cmr118 char#119 w --- */
      { 119, 1879,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x77\x17\x11\x55\xa8\x42\x15\x44\x20\x02" }  },
      /* --- pixel bitmap for cmr118 char#120 x --- */
      { 120, 1930,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x24\x18\x18\x18\x24\xe7" }  },
      /* --- pixel bitmap for cmr118 char#121 y --- */
      { 121, 1959,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x24\x24\x24\x18\x18\x18\x08\x08\x07" }  },
      /* --- pixel bitmap for cmr118 char#122 z --- */
      { 122, 1994,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x29\x22\xe5\x07" }  },
      /* --- pixel bitmap for cmr118 char#123 (noname) --- */
      { 123, 4446,                      /* character number, location */
          5, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          {  7,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f" }  },
      /* --- pixel bitmap for cmr118 char#124 (noname) --- */
      { 124, 4455,                      /* character number, location */
          5, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          { 15,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x7f" }  },
      /* --- pixel bitmap for cmr118 char#125 (noname) --- */
      { 125, 4099,                      /* character number, location */
         10, 2,     8, 2,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5a" }  },
      /* --- pixel bitmap for cmr118 char#126 \~ --- */
      { 126, 4114,                      /* character number, location */
         10, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  5,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb6\x01" }  },
      /* --- pixel bitmap for cmr118 char#127 (noname) --- */
      { 127, 4129,                      /* character number, location */
         11, 1,     9, 1,     /* topleft row,col, and botleft row,col */
          {  5,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7b\x03" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=3 ---
 * mf '\mode=onetz; mag=magstep(.5); input cmr10'   gives .gf131
 * ------------------------------------------------------------- */
/* --- fontdef for cmr131 --- */
static	chardef  cmr131[] =
   {
      /* --- pixel bitmap for cmr131 char#0 (noname) --- */
      {   0, 2355,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x19\x33\x64\xc8\x90\x01\x03\x06\x0c\x18\x30\xf8"
            "\x01" }  },
      /* --- pixel bitmap for cmr131 char#1 (noname) --- */
      {   1, 2394,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x60\x00\x06\xd0\x00\x0d\xc8\x81\x18\x84\x43\x30\x02"
            "\x27\x60\xff\xff\xff" }  },
      /* --- pixel bitmap for cmr131 char#2 (noname) --- */
      {   2, 2441,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x60\x8c\xc1\x04\x34\xe5\x39\xcf\x79\xca\x03\x36"
            "\x18\x63\xf0\x01" }  },
      /* --- pixel bitmap for cmr131 char#3 (noname) --- */
      {   3, 2504,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x30\x80\x01\x0c\xd0\x80\x06\x34\xb0\x83\x18\xc4\x20"
            "\x86\x60\xde\x0f" }  },
      /* --- pixel bitmap for cmr131 char#4 (noname) --- */
      {   4, 2553,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\x07\x0c\x28\xc8\x9f\x3f\x41\x01\x03\xfe\xff"
            "\x0f" }  },
      /* --- pixel bitmap for cmr131 char#5 (noname) --- */
      {   5, 2596,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x9f\xc1\x30\x18\x06\xc3\x60\x18\x0c\x83\x61\x30"
            "\x0c\x86\xc1\x30\x98\xdf\x0f" }  },
      /* --- pixel bitmap for cmr131 char#6 (noname) --- */
      {   6, 2649,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x1f\xec\x20\x83\x18\xe2\x00\x03\x84\x08\x12\x68"
            "\xf0\xff" }  },
      /* --- pixel bitmap for cmr131 char#7 (noname) --- */
      {   7, 2696,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x8e\xdb\x36\x1c\xc0\x00\x06\x30\x80\x01\x0c\x60\x00"
            "\x03\x18\xf0\x03" }  },
      /* --- pixel bitmap for cmr131 char#8 (noname) --- */
      {   8, 2735,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xc0\x00\x03\x3f\xb6\xcd\x3c\xb3\x6d\xfc\xc0\x00"
            "\x03\x3f" }  },
      /* --- pixel bitmap for cmr131 char#9 (noname) --- */
      {   9, 2782,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x01\xc3\xd9\xcd\x66\x36\xb3\x99\x8d\x3d\xf8\x00"
            "\x03\x18\xf0\x03" }  },
      /* --- pixel bitmap for cmr131 char#10 (noname) --- */
      {  10, 2835,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x18\x36\xf0\xc0\x03\x0f\x2c\x90\x61\x85\x36\xeb"
            "\x9c\x73" }  },
      /* --- pixel bitmap for cmr131 char#11 (noname) --- */
      {  11, 4886,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x0f\x11\x08\x81\x10\x08\xf1\x7f\x08\x81\x10\x08"
            "\x81\x10\x08\x81\x10\x0c\x07" }  },
      /* --- pixel bitmap for cmr131 char#12 (noname) --- */
      {  12, 4941,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x20\x21\x40\x80\xe0\x1f\x32\x44\x88\x10\x21\x42"
            "\xc4\x18" }  },
      /* --- pixel bitmap for cmr131 char#13 (noname) --- */
      {  13, 4990,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x20\x21\x42\x84\xe8\x1f\x22\x44\x88\x10\x21\x42"
            "\xc4\x18" }  },
      /* --- pixel bitmap for cmr131 char#14 (noname) --- */
      {  14, 5045,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 14,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x1d\xc4\x84\x10\x20\x04\x08\xc1\xff\x87\x90\x21"
            "\x44\x08\x11\x42\x84\x10\x21\x44\x0c\x31" }  },
      /* --- pixel bitmap for cmr131 char#15 (noname) --- */
      {  15, 5118,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 14,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x1d\x84\x84\x10\x21\x44\x08\xd1\xff\x87\x10\x21"
            "\x44\x08\x11\x42\x84\x10\x21\x44\x9c\x3b" }  },
      /* --- pixel bitmap for cmr131 char#16 (noname) --- */
      {  16, 3506,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x24\xe9" }  },
      /* --- pixel bitmap for cmr131 char#17 (noname) --- */
      {  17, 3529,                      /* character number, location */
          8,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          {  4,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x88\x88\x88\x88\x78" }  },
      /* --- pixel bitmap for cmr131 char#18 (noname) --- */
      {  18, 4690,                      /* character number, location */
         13, 2,    10, 2,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x91\x01" }  },
      /* --- pixel bitmap for cmr131 char#19 (noname) --- */
      {  19, 4703,                      /* character number, location */
         13, 3,    10, 3,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd4\x00" }  },
      /* --- pixel bitmap for cmr131 char#20 (noname) --- */
      {  20, 4716,                      /* character number, location */
         11, 2,    10, 2,     /* topleft row,col, and botleft row,col */
          {  4,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr131 char#21 (noname) --- */
      {  21, 4725,                      /* character number, location */
         13, 1,     9, 1,     /* topleft row,col, and botleft row,col */
          {  6,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x61\x28\x79" }  },
      /* --- pixel bitmap for cmr131 char#22 (noname) --- */
      {  22, 4746,                      /* character number, location */
         10, 1,     9, 1,     /* topleft row,col, and botleft row,col */
          {  6,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f" }  },
      /* --- pixel bitmap for cmr131 char#23 (noname) --- */
      {  23, 4755,                      /* character number, location */
         13, 5,    10, 5,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xef\x01" }  },
      /* --- pixel bitmap for cmr131 char#24 (noname) --- */
      {  24, 4770,                      /* character number, location */
          0, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          {  4,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x86\x0f" }  },
      /* --- pixel bitmap for cmr131 char#25 \ss --- */
      {  25, 3560,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x1c\x91\x48\x24\xda\x88\x84\x42\xa1\x50\x39\x03" }  },
      /* --- pixel bitmap for cmr131 char#26 \ae --- */
      {  26, 3619,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x9f\x03\x33\x08\xf9\x2f\x82\x10\x84\xd1\x73" }  },
      /* --- pixel bitmap for cmr131 char#27 \oe --- */
      {  27, 3658,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     8, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x8c\x27\x45\x21\x18\xfe\x21\x10\x02\x52\xc8\x78" }  },
      /* --- pixel bitmap for cmr131 char#28 (noname) --- */
      {  28, 3707,                      /* character number, location */
         10, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\xc4\x49\x69\x5a\x96\x96\x23\x04" }  },
      /* --- pixel bitmap for cmr131 char#29 \AE --- */
      {  29, 3758,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x3f\xd0\x18\x68\x08\x36\x04\x99\x82\x4c\xc0\x3f"
            "\x10\x93\x88\x49\xc4\x10\x61\xe8\xf9\x07" }  },
      /* --- pixel bitmap for cmr131 char#30 \OE --- */
      {  30, 3833,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x7f\x8c\x63\x86\x43\x82\x53\x03\x53\x03\x1f\x03"
            "\x13\x03\x93\x87\x83\x86\x43\x8c\x43\xf8\x7f" }  },
      /* --- pixel bitmap for cmr131 char#31 (noname) --- */
      {  31, 3908,                      /* character number, location */
         13, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\xc1\x0f\x63\x0c\x27\xa4\x21\x8f\x78\xc4\x13\x9e"
            "\xb0\xc3\x18\xc3\x0f\x02\x00" }  },
      /* --- pixel bitmap for cmr131 char#32 (noname) --- */
      {  32, 4802,                      /* character number, location */
          7, 0,     5, 0,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3e" }  },
      /* --- pixel bitmap for cmr131 char#33 ! --- */
      {  33, 3975,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xff\xc0\x03" }  },
      /* --- pixel bitmap for cmr131 char#34 " --- */
      {  34, 5197,                      /* character number, location */
         13, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7b\x4b\x29\x13" }  },
      /* --- pixel bitmap for cmr131 char#35 # --- */
      {  35, 4033,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x02\x22\x20\x02\x11\x10\x01\x11\xff\x8f\x08\x88"
            "\x00\x11\xff\x8f\x08\x88\x80\x08\x44\x40\x04\x44\x00" }  },
      /* --- pixel bitmap for cmr131 char#36 $ --- */
      {  36, 3314,                      /* character number, location */
         14, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,    15, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x08\xa7\xa6\x69\xe2\x78\x38\x9a\xa6\x9a\x83\x00" }  },
      /* --- pixel bitmap for cmr131 char#37 % --- */
      {  37, 4104,                      /* character number, location */
         14, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 12,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0e\xa4\x21\xf1\x13\x11\x91\x10\x09\x4a\xe0\x72\x20"
            "\x05\x89\x90\x88\x88\x84\x48\x50\x02\x07" }  },
      /* --- pixel bitmap for cmr131 char#38 & --- */
      {  38, 3377,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x18\x20\x01\x09\x48\x40\x01\xce\x33\xc4\x11\x93\x88"
            "\x42\x18\xc6\xe8\x39" }  },
      /* --- pixel bitmap for cmr131 char#39 (noname) --- */
      {  39, 4195,                      /* character number, location */
         13, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaf\x06" }  },
      /* --- pixel bitmap for cmr131 char#40 ( --- */
      {  40, 4214,                      /* character number, location */
         14, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  4,    19, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x48\x24\x12\x11\x11\x11\x11\x22\x44\x08" }  },
      /* --- pixel bitmap for cmr131 char#41 ) --- */
      {  41, 4259,                      /* character number, location */
         14, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  4,    19, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x21\x42\x84\x88\x88\x88\x88\x44\x22\x01" }  },
      /* --- pixel bitmap for cmr131 char#42 * --- */
      {  42, 4304,                      /* character number, location */
         14, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\xb2\x7b\xde\x8e\x20" }  },
      /* --- pixel bitmap for cmr131 char#43 + --- */
      {  43, 4331,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x01\x08\x40\x00\x02\x10\xfc\x1f\x04\x20\x00"
            "\x01\x08\x40\x00\x02" }  },
      /* --- pixel bitmap for cmr131 char#44 (noname) --- */
      {  44, 4364,                      /* character number, location */
          2, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaf\x06" }  },
      /* --- pixel bitmap for cmr131 char#45 (noname) --- */
      {  45, 5228,                      /* character number, location */
          5, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          {  4,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr131 char#46 (noname) --- */
      {  46, 4383,                      /* character number, location */
          2, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr131 char#47 / --- */
      {  47, 4394,                      /* character number, location */
         14, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  6,    19, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x08\x41\x10\x84\x20\x08\x41\x10\x84\x20\x08\x42"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmr131 char#48 0 --- */
      {  48, 2896,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\x61\x18\x86\x61\x28\x31" }  },
      /* --- pixel bitmap for cmr131 char#49 1 --- */
      {  49, 2947,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe4\x10\x42\x08\x21\x84\x90\x0f" }  },
      /* --- pixel bitmap for cmr131 char#50 2 --- */
      {  50, 2978,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x34\x8f\x30\x0c\x21\x0c\x29\xfe" }  },
      /* --- pixel bitmap for cmr131 char#51 3 --- */
      {  51, 3019,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x1c\xc3\x10\x03\xc1\xf0\x1c\x39" }  },
      /* --- pixel bitmap for cmr131 char#52 4 --- */
      {  52, 3058,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x30\x30\x28\x2c\x24\x22\x23\xff\x20\x20\x20\xf8" }  },
      /* --- pixel bitmap for cmr131 char#53 5 --- */
      {  53, 3099,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe1\xd7\x04\xc1\x33\xc1\x70\x1c\x39" }  },
      /* --- pixel bitmap for cmr131 char#54 6 --- */
      {  54, 3140,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\x04\xcd\x14\x86\x61\x28\x31" }  },
      /* --- pixel bitmap for cmr131 char#55 7 --- */
      {  55, 3187,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x81\x7f\x30\x04\x81\x20\x10\x08\x02\x81\x40\x00" }  },
      /* --- pixel bitmap for cmr131 char#56 8 --- */
      {  56, 3224,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x18\x8e\x97\xa3\xc5\x61\x28\x30" }  },
      /* --- pixel bitmap for cmr131 char#57 9 --- */
      {  57, 3269,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\xa1\xcc\x82\x20\x14\x39" }  },
      /* --- pixel bitmap for cmr131 char#58 : --- */
      {  58, 4439,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xf0" }  },
      /* --- pixel bitmap for cmr131 char#59 ; --- */
      {  59, 4456,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  2,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xf0\x6a" }  },
      /* --- pixel bitmap for cmr131 char#60 (noname) --- */
      {  60, 4004,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  2,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xfc\xff\x03" }  },
      /* --- pixel bitmap for cmr131 char#61 = --- */
      {  61, 4481,                      /* character number, location */
          7, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 11,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x07\x00\x00\x00\xf0\x7f" }  },
      /* --- pixel bitmap for cmr131 char#62 (noname) --- */
      {  62, 3473,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c\x03\x00\x00\x43\x10\x84\x10\x86\x1e" }  },
      /* --- pixel bitmap for cmr131 char#63 (noname) --- */
      {  63, 3440,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x18\x42\x08\x82\x30\x00\x00\x30\x0c" }  },
      /* --- pixel bitmap for cmr131 char#64 (noname) --- */
      {  64, 4494,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\x60\x8c\x9c\x14\x55\xd0\x82\x16\xb4\xa0\x05\x55"
            "\xac\xdc\x18\x0c\x1f" }  },
      /* --- pixel bitmap for cmr131 char#65 A --- */
      {  65,   35,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x07\x70\x00\x07\xf8\x80\x0c\xc8\xc0\x1c\xfc"
            "\x41\x18\x86\xf3\xfc" }  },
      /* --- pixel bitmap for cmr131 char#66 B --- */
      {  66,   78,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x61\x18\x83\x19\xcc\x70\xfe\x31\x8c\xc1\x0c\x66"
            "\x30\xc3\xfe\x03" }  },
      /* --- pixel bitmap for cmr131 char#67 C --- */
      {  67,  127,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x32\x6c\xa0\x80\x03\x0c\x30\xc0\x00\x02\x1a\xc8"
            "\x10\x3c" }  },
      /* --- pixel bitmap for cmr131 char#68 D --- */
      {  68,  172,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xc1\x30\x0c\xc6\xc0\x0c\xcc\xc0\x0c\xcc\xc0\x0c"
            "\xcc\x60\x0c\xf3\x1f" }  },
      /* --- pixel bitmap for cmr131 char#69 E --- */
      {  69,  223,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x63\x18\x83\x98\xc4\x24\x3e\x30\x81\x89\x0c\x64"
            "\x10\xc3\xfe\x07" }  },
      /* --- pixel bitmap for cmr131 char#70 F --- */
      {  70,  278,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x33\xcc\x20\xa3\x8c\xf2\xc3\x08\x23\x0c\x30\xc0"
            "\xc0\x0f" }  },
      /* --- pixel bitmap for cmr131 char#71 G --- */
      {  71,  325,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x62\x98\x81\x04\x34\x80\x01\x0c\x7f\x60\x02\x33"
            "\x18\xc3\xe0\x05" }  },
      /* --- pixel bitmap for cmr131 char#72 H --- */
      {  72,  376,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xbf\x9f\xc1\x30\x18\x06\xc3\x60\xf8\x0f\x83\x61\x30"
            "\x0c\x86\xc1\x30\x98\xdf\x0f" }  },
      /* --- pixel bitmap for cmr131 char#73 I --- */
      {  73,  429,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\xc3\x30\x0c\xc3\x30\x0c\xc3\xfc" }  },
      /* --- pixel bitmap for cmr131 char#74 J --- */
      {  74,  460,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x7c\x18\x0c\x06\x83\xc1\x60\xb0\xd9\xcc\x03" }  },
      /* --- pixel bitmap for cmr131 char#75 K --- */
      {  75,  495,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xcf\x30\x8c\xc1\x0c\x4c\xc0\x06\xdc\xc0\x0c\x8c"
            "\xc1\x38\x0c\xf3\xfb" }  },
      /* --- pixel bitmap for cmr131 char#76 L --- */
      {  76,  550,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x18\x30\x60\xc0\x80\x01\x03\x86\x0c\x19\x32\xfe"
            "\x0f" }  },
      /* --- pixel bitmap for cmr131 char#77 M --- */
      {  77,  589,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1f\xf8\x1c\x38\x1c\x38\x34\x34\x34\x34\x64\x32\x64"
            "\x32\x64\x32\xc4\x31\xc4\x31\xc4\x31\x9f\xfc" }  },
      /* --- pixel bitmap for cmr131 char#78 N --- */
      {  78,  672,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1f\x9f\x83\xd0\x10\x3a\x42\x46\x88\x09\x71\x21\x2c"
            "\x04\x87\xe0\x10\x98\x0f\x02" }  },
      /* --- pixel bitmap for cmr131 char#79 O --- */
      {  79,  739,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x60\x8c\xc1\x04\x34\xe0\x01\x0f\x78\xc0\x03\x36"
            "\x18\x63\xf0\x01" }  },
      /* --- pixel bitmap for cmr131 char#80 P --- */
      {  80,  790,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x30\xc6\x30\xc3\x0c\x33\xc6\x0f\x03\x0c\x30\xc0"
            "\xc0\x0f" }  },
      /* --- pixel bitmap for cmr131 char#81 Q --- */
      {  81,  831,                      /* character number, location */
         12, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x60\x8c\xc1\x04\x34\xe0\x01\x0f\x78\xc0\x03\xb6"
            "\x1b\x67\xf0\x01\x08\x40\x02\x1c\x60" }  },
      /* --- pixel bitmap for cmr131 char#82 R --- */
      {  82,  894,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xc0\x18\x0c\xc3\x30\x8c\xc1\x0f\x8c\xc1\x18\x8c"
            "\xc1\x18\x8c\xf9\xf3" }  },
      /* --- pixel bitmap for cmr131 char#83 S --- */
      {  83,  947,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x7c\xe1\x70\x70\xf0\xf1\xc0\xe0\x70\xe8\x03" }  },
      /* --- pixel bitmap for cmr131 char#84 T --- */
      {  84,  986,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xcf\x1c\x63\x8c\x31\xc2\x00\x03\x0c\x30\xc0\x00"
            "\x03\x3f" }  },
      /* --- pixel bitmap for cmr131 char#85 U --- */
      {  85, 1033,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x9f\x81\x30\x10\x06\xc2\x40\x18\x08\x03\x61\x20"
            "\x0c\x84\x81\x60\x08\xf8\x00" }  },
      /* --- pixel bitmap for cmr131 char#86 V --- */
      {  86, 1086,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x9f\x81\x60\x08\x0c\x81\x21\x60\x02\x4c\x80\x09"
            "\xe0\x00\x1c\x80\x03\x20\x00" }  },
      /* --- pixel bitmap for cmr131 char#87 W --- */
      {  87, 1133,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x9f\xcf\x33\x1c\xc2\x70\x08\xc6\x11\x98\x4c\x60\x32"
            "\x81\xc9\x04\x1c\x0e\x70\x38\xc0\xe1\x00\x86\x01\x08"
            "\x04" }  },
      /* --- pixel bitmap for cmr131 char#88 X --- */
      {  88, 1208,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xbe\x0f\x23\xe0\x04\x58\x00\x0e\xc0\x00\x38\x00\x0f"
            "\x90\x01\x63\x20\x8c\xcf\x0f" }  },
      /* --- pixel bitmap for cmr131 char#89 Y --- */
      {  89, 1255,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x9e\x83\x60\x08\x18\x01\x17\xc0\x02\x30\x00\x06"
            "\xc0\x00\x18\x00\x03\xf8\x01" }  },
      /* --- pixel bitmap for cmr131 char#90 Z --- */
      {  90, 1298,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xff\xe3\x61\x31\x31\x18\x18\x8c\x8c\x86\xc7\xff" }  },
      /* --- pixel bitmap for cmr131 char#91 [ --- */
      {  91, 4581,                      /* character number, location */
         14, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  3,    19, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x92\x24\x49\x92\x24\xc9\x01" }  },
      /* --- pixel bitmap for cmr131 char#92 (noname) --- */
      {  92, 5237,                      /* character number, location */
         13, 2,     7, 2,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x32\xa5\xb4\x37" }  },
      /* --- pixel bitmap for cmr131 char#93 ] --- */
      {  93, 4626,                      /* character number, location */
         14, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          {  3,    19, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x27\x49\x92\x24\x49\x92\xe4\x01" }  },
      /* --- pixel bitmap for cmr131 char#94 \^ --- */
      {  94, 4813,                      /* character number, location */
         12, 2,    10, 2,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96" }  },
      /* --- pixel bitmap for cmr131 char#95 (noname) --- */
      {  95, 4826,                      /* character number, location */
         13, 1,    11, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr131 char#96 (noname) --- */
      {  96, 4671,                      /* character number, location */
         13, 1,     7, 1,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\x0f" }  },
      /* --- pixel bitmap for cmr131 char#97 a --- */
      {  97, 1345,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\x08\xc4\x13\x89\x46\x7d" }  },
      /* --- pixel bitmap for cmr131 char#98 b --- */
      {  98, 1378,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x03\x81\x40\x20\xd0\x98\x84\x42\xa1\xd0\xa4\x01" }  },
      /* --- pixel bitmap for cmr131 char#99 c --- */
      {  99, 1427,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x10\x04\x41\x20\x72" }  },
      /* --- pixel bitmap for cmr131 char#100 d --- */
      { 100, 1452,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x30\x10\x08\x04\xe2\x89\x42\xa1\x50\x48\xc6\x06" }  },
      /* --- pixel bitmap for cmr131 char#101 e --- */
      { 101, 1499,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\xc6\x1f\x82\x64" }  },
      /* --- pixel bitmap for cmr131 char#102 f --- */
      { 102, 1528,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x70\x04\x02\x81\xf8\x21\x10\x08\x04\x02\xc1\x03" }  },
      /* --- pixel bitmap for cmr131 char#103 g --- */
      { 103, 1561,                      /* character number, location */
          8, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x22\x22\x22\x22\x1e\x02\x3e\xc1\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmr131 char#104 h --- */
      { 104, 1610,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x03\x81\x40\x20\xd0\x98\x44\x22\x91\x48\x74\x06" }  },
      /* --- pixel bitmap for cmr131 char#105 i --- */
      { 105, 1659,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1b\x80\x49\x92\x74" }  },
      /* --- pixel bitmap for cmr131 char#106 j --- */
      { 106, 1688,                      /* character number, location */
         13,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          {  4,    17, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xcc\x00\xc0\x88\x88\x88\x88\x88\x07" }  },
      /* --- pixel bitmap for cmr131 char#107 k --- */
      { 107, 1725,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x03\x02\x02\x02\x02\xf2\x32\x1a\x0e\x16\x12\x22\xe7" }  },
      /* --- pixel bitmap for cmr131 char#108 l --- */
      { 108, 1772,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x24\x49\x92\x74" }  },
      /* --- pixel bitmap for cmr131 char#109 m --- */
      { 109, 1805,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     8, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3b\xc7\x18\x09\x21\x21\x24\x84\x84\x90\x10\x3a\xe7" }  },
      /* --- pixel bitmap for cmr131 char#110 n --- */
      { 110, 1860,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1b\x93\x48\x24\x12\x89\xce" }  },
      /* --- pixel bitmap for cmr131 char#111 o --- */
      { 111, 1899,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\x61\x28\x31" }  },
      /* --- pixel bitmap for cmr131 char#112 p --- */
      { 112, 1934,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x1b\x93\x50\x28\x14\x9a\x34\x02\x81\xe0\x00" }  },
      /* --- pixel bitmap for cmr131 char#113 q --- */
      { 113, 1981,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x5c\x62\x41\x41\x41\x41\x62\x5c\x40\x40\x40\xe0" }  },
      /* --- pixel bitmap for cmr131 char#114 r --- */
      { 114, 2028,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x0b\x21\x84\x38" }  },
      /* --- pixel bitmap for cmr131 char#115 s --- */
      { 115, 2053,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x69\x98\x79" }  },
      /* --- pixel bitmap for cmr131 char#116 t --- */
      { 116, 2084,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x98\x4f\x08\x21\x94\x22" }  },
      /* --- pixel bitmap for cmr131 char#117 u --- */
      { 117, 2117,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x33\x91\x48\x24\x12\x89\xf8" }  },
      /* --- pixel bitmap for cmr131 char#118 v --- */
      { 118, 2154,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xef\x89\x10\x21\x82\x02\x05\x0a\x08" }  },
      /* --- pixel bitmap for cmr131 char#119 w --- */
      { 119, 2191,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,     8, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xe7\x0e\x26\x04\x42\x29\x94\x02\x09\x08\x81\x10" }  },
      /* --- pixel bitmap for cmr131 char#120 x --- */
      { 120, 2240,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x89\xa0\x80\x00\x01\x05\x91\xe3" }  },
      /* --- pixel bitmap for cmr131 char#121 y --- */
      { 121, 2275,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xef\x89\x10\x21\x82\x02\x05\x0e\x08\x10\x30\x24\x38"
            "\x00" }  },
      /* --- pixel bitmap for cmr131 char#122 z --- */
      { 122, 2320,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbe\xa4\x29\xa4\x29\xfe" }  },
      /* --- pixel bitmap for cmr131 char#123 (noname) --- */
      { 123, 5268,                      /* character number, location */
          5, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          {  8,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff" }  },
      /* --- pixel bitmap for cmr131 char#124 (noname) --- */
      { 124, 5277,                      /* character number, location */
          5, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          { 17,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xff\x01" }  },
      /* --- pixel bitmap for cmr131 char#125 (noname) --- */
      { 125, 4837,                      /* character number, location */
         13, 2,    10, 2,     /* topleft row,col, and botleft row,col */
          {  5,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x52\x26" }  },
      /* --- pixel bitmap for cmr131 char#126 \~ --- */
      { 126, 4856,                      /* character number, location */
         12, 1,    10, 1,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x66\x06" }  },
      /* --- pixel bitmap for cmr131 char#127 (noname) --- */
      { 127, 4871,                      /* character number, location */
         13, 1,    11, 1,     /* topleft row,col, and botleft row,col */
          {  5,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x52\x02" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=4 ---
 * mf '\mode=itoh; input cmr10'       gives .gf160
 * ----------------------------------------------- */
/* --- fontdef for cmr160 --- */
static	chardef  cmr160[] =
   {
      /* --- pixel bitmap for cmr160 char#0 (noname) --- */
      {   0, 2667,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x63\x18\x83\x18\xc8\x40\x06\x30\x80\x01\x0c\x60"
            "\x00\x03\x18\xc0\x80\x3f\x00" }  },
      /* --- pixel bitmap for cmr160 char#1 (noname) --- */
      {   1, 2710,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x00\xe0\x00\x70\x00\x64\x00\x32\x80\x30\x40\x18"
            "\x10\x18\x08\x0c\x02\x0c\x01\x46\x00\xe6\xff\xfb\xff"
            "\x03" }  },
      /* --- pixel bitmap for cmr160 char#2 (noname) --- */
      {   2, 2763,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x03\x86\xc1\xc0\x18\x60\x03\xf0\x84\x3c\x3f\xcf"
            "\xcf\x13\xf2\x00\x6c\x80\x31\x30\x18\x06\xfc\x00" }  },
      /* --- pixel bitmap for cmr160 char#3 (noname) --- */
      {   3, 2834,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x60\x00\x06\x60\x00\x0d\xd0\x00\x0d\xc8\x81\x18\x88"
            "\x81\x18\x04\x43\x30\x04\xf3\xf8" }  },
      /* --- pixel bitmap for cmr160 char#4 (noname) --- */
      {   4, 2891,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\xff\x01\x18\x80\x00\x40\x20\xfc\xc3\x3f\x04"
            "\x02\x00\x01\x18\x80\xff\xff\xff" }  },
      /* --- pixel bitmap for cmr160 char#5 (noname) --- */
      {   5, 2938,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x3f\x03\xc3\xc0\x30\x30\x0c\x0c\x03\xc3\xc0\x30"
            "\x30\x0c\x0c\x03\xc3\xc0\x30\x30\x0c\xcc\xcf\x0f" }  },
      /* --- pixel bitmap for cmr160 char#6 (noname) --- */
      {   6, 2999,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xef\x80\x39\x20\x06\x88\x01\x71\x00\x1c\x00\x03"
            "\x20\x00\x02\x22\x40\x02\x24\xc0\xfe\x1f" }  },
      /* --- pixel bitmap for cmr160 char#7 (noname) --- */
      {   7, 3050,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1e\xde\xcc\x1c\x12\x02\x03\xc0\x00\x30\x00\x0c\x00"
            "\x03\xc0\x00\x30\x00\x0c\x00\x03\xc0\x00\xfe\x01" }  },
      /* --- pixel bitmap for cmr160 char#8 (noname) --- */
      {   8, 3099,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x07\x18\x00\x03\xfc\xe1\xec\x86\xf1\x30\x1e\xc6"
            "\xc3\xd8\xd9\xe1\x0f\x60\x00\x0c\xf0\x0f" }  },
      /* --- pixel bitmap for cmr160 char#9 (noname) --- */
      {   9, 3158,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x07\x30\x00\x0c\x1c\xe3\xc6\x98\x31\x66\x8c\x19"
            "\x63\xcc\x0c\xb7\x03\x3f\x00\x03\xc0\x00\xfe\x01" }  },
      /* --- pixel bitmap for cmr160 char#10 (noname) --- */
      {  10, 3221,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x81\xc1\x18\xb0\x01\x3c\x80\x07\xf0\x00\x36\x60"
            "\x06\x8c\xc1\x24\xc8\x04\xe9\xf1\x3c\x1e" }  },
      /* --- pixel bitmap for cmr160 char#11 (noname) --- */
      {  11, 5432,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x1d\xc6\xcc\x30\x30\x0c\x0c\xc3\xff\xc3\x30\x30"
            "\x0c\x0c\x03\xc3\xc0\x30\x30\x0c\x0c\xc3\xc3\x03" }  },
      /* --- pixel bitmap for cmr160 char#12 (noname) --- */
      {  12, 5495,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xc1\x08\x43\x18\xc0\x80\xff\xb0\x87\x31\x8c\x61"
            "\x0c\x63\x18\xc3\x98\xc7\x03" }  },
      /* --- pixel bitmap for cmr160 char#13 (noname) --- */
      {  13, 5550,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xc1\x0c\x63\x18\xc3\x98\xff\x30\x86\x31\x8c\x61"
            "\x0c\x63\x18\xc3\x98\xc7\x03" }  },
      /* --- pixel bitmap for cmr160 char#14 (noname) --- */
      {  14, 5609,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7d\x30\x8c\x30\x0c\x61\x18\xc0\x30\xe0\xff\x0f"
            "\xc3\x1e\x86\x31\x0c\x63\x18\xc6\x30\x8c\x61\x18\xc3"
            "\x30\xe6\x61\x3c" }  },
      /* --- pixel bitmap for cmr160 char#15 (noname) --- */
      {  15, 5690,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7f\x30\xce\x30\x8c\x61\x18\xc3\x30\xe6\xff\x0f"
            "\xc3\x18\x86\x31\x0c\x63\x18\xc6\x30\x8c\x61\x18\xc3"
            "\x30\xe6\xf3\x3e" }  },
      /* --- pixel bitmap for cmr160 char#16 (noname) --- */
      {  16, 3956,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x67\x66\x66\x66\x0f" }  },
      /* --- pixel bitmap for cmr160 char#17 (noname) --- */
      {  17, 3981,                      /* character number, location */
          9,-2,    -4,-2,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x0c\xc3\x30\x0c\xc3\x30\x0c\xcf\x0f" }  },
      /* --- pixel bitmap for cmr160 char#18 (noname) --- */
      {  18, 5228,                      /* character number, location */
         14, 2,    11, 2,     /* topleft row,col, and botleft row,col */
          {  4,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x73\x0c" }  },
      /* --- pixel bitmap for cmr160 char#19 (noname) --- */
      {  19, 5241,                      /* character number, location */
         14, 4,    11, 4,     /* topleft row,col, and botleft row,col */
          {  4,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xec\x03" }  },
      /* --- pixel bitmap for cmr160 char#20 (noname) --- */
      {  20, 5254,                      /* character number, location */
         13, 3,    11, 3,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x69" }  },
      /* --- pixel bitmap for cmr160 char#21 (noname) --- */
      {  21, 5267,                      /* character number, location */
         14, 2,    10, 2,     /* topleft row,col, and botleft row,col */
          {  6,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x61\x28\x79" }  },
      /* --- pixel bitmap for cmr160 char#22 (noname) --- */
      {  22, 5288,                      /* character number, location */
         11, 1,    10, 1,     /* topleft row,col, and botleft row,col */
          {  8,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff" }  },
      /* --- pixel bitmap for cmr160 char#23 (noname) --- */
      {  23, 5297,                      /* character number, location */
         14, 6,    11, 6,     /* topleft row,col, and botleft row,col */
          {  4,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x06" }  },
      /* --- pixel bitmap for cmr160 char#24 (noname) --- */
      {  24, 5312,                      /* character number, location */
          0, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  6,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\xec\x07" }  },
      /* --- pixel bitmap for cmr160 char#25 \ss --- */
      {  25, 4016,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\x10\x31\x66\xcc\xe8\x0d\x33\x46\x8c\x19\x33\x66"
            "\xce\xfc\x19" }  },
      /* --- pixel bitmap for cmr160 char#26 \ae --- */
      {  26, 4077,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3e\x6f\x3c\x01\x63\xfc\xef\x0c\x86\xc1\x30\x18\x8f"
            "\x3e\x0f" }  },
      /* --- pixel bitmap for cmr160 char#27 \oe --- */
      {  27, 4122,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x9e\xf1\x24\x18\x0f\xfe\x83\xc1\x60\x20\x18\x18"
            "\x8f\x38\x1e" }  },
      /* --- pixel bitmap for cmr160 char#28 (noname) --- */
      {  28, 4171,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x40\x40\x3c\x66\xf3\xd3\xdb\xcb\xcf\x66\x3c\x02\x02" }  },
      /* --- pixel bitmap for cmr160 char#29 \AE --- */
      {  29, 4224,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\xff\x80\x86\x81\x0c\x02\x19\x08\x32\x10\x62\x04"
            "\xc4\x08\xf8\x1f\x08\x23\x11\x46\x22\x0c\x26\x18\x44"
            "\x30\xec\xfb\x1f" }  },
      /* --- pixel bitmap for cmr160 char#30 \OE --- */
      {  30, 4309,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\xff\xc3\x70\x18\x83\x83\x0c\x1c\x38\xe0\xd0\x01"
            "\x86\x0c\xf0\x67\x80\x21\x03\x0c\x3d\x70\xa0\x81\x83"
            "\x19\x1c\x84\xe1\x30\xf0\xff\x01" }  },
      /* --- pixel bitmap for cmr160 char#31 (noname) --- */
      {  31, 4394,                      /* character number, location */
         15, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 14,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x08\xfc\x83\x61\x10\x28\x06\xda\x40\x3c\x18\x0f"
            "\xc2\x43\xf0\x18\x3c\x02\x5b\x60\x14\x08\x86\xc1\x3f"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmr160 char#32 (noname) --- */
      {  32, 5346,                      /* character number, location */
          8, 0,     6, 0,     /* topleft row,col, and botleft row,col */
          {  5,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\x00" }  },
      /* --- pixel bitmap for cmr160 char#33 ! --- */
      {  33, 4477,                      /* character number, location */
         14, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  2,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xff\x03\x0f" }  },
      /* --- pixel bitmap for cmr160 char#34 " --- */
      {  34, 5773,                      /* character number, location */
         14, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf3\x2c\x8a\x73\x04" }  },
      /* --- pixel bitmap for cmr160 char#35 # --- */
      {  35, 4539,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 15,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x10\x40\x08\x20\x04\x10\x02\x84\x00\x42\xfc\xff"
            "\x41\x08\x20\x04\x08\x01\x84\x00\x42\xf0\xff\x47\x08"
            "\x20\x04\x08\x01\x84\x00\x42\x00" }  },
      /* --- pixel bitmap for cmr160 char#36 $ --- */
      {  36, 3742,                      /* character number, location */
         15, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x3c\x4a\x89\xc9\x49\x0e\x3e\x78\xc8\x8b\x8b\x89"
            "\x4a\x3c\x08" }  },
      /* --- pixel bitmap for cmr160 char#37 % --- */
      {  37, 4614,                      /* character number, location */
         15, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 15,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0c\x10\x19\xc4\xf8\x63\x84\x30\x22\x18\x11\x8c\x04"
            "\x2c\x01\x8c\x18\x20\x12\x88\x11\xc4\x08\x61\x44\x30"
            "\x22\x90\x08\x30" }  },
      /* --- pixel bitmap for cmr160 char#38 & --- */
      {  38, 3815,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x00\x12\xc0\x04\x30\x01\x2c\x00\x8f\xcf\xc1\x70"
            "\x10\x3e\xc2\x9c\x30\x16\x0c\x03\xc6\x23\x8f\x07" }  },
      /* --- pixel bitmap for cmr160 char#39 (noname) --- */
      {  39, 4711,                      /* character number, location */
         14, 2,     8, 2,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaf\x07" }  },
      /* --- pixel bitmap for cmr160 char#40 ( --- */
      {  40, 4730,                      /* character number, location */
         15, 2,    -6, 2,     /* topleft row,col, and botleft row,col */
          {  5,    21, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x11\x62\xc4\x18\x63\x8c\x31\xc6\x10\x86\x10\x04"
            "\x01" }  },
      /* --- pixel bitmap for cmr160 char#41 ) --- */
      {  41, 4779,                      /* character number, location */
         15, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  5,    21, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x41\x10\xc2\x10\xc6\x18\x63\x8c\x31\x46\x8c\x10\x11"
            "\x00" }  },
      /* --- pixel bitmap for cmr160 char#42 * --- */
      {  42, 4828,                      /* character number, location */
         15, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x18\xdb\x7e\x18\x7e\xdb\x18\x18" }  },
      /* --- pixel bitmap for cmr160 char#43 + --- */
      {  43, 4861,                      /* character number, location */
         12, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 14,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x00\x20\x00\x08\x00\x02\x80\x00\x20\x00\x08\xfc"
            "\xff\x80\x00\x20\x00\x08\x00\x02\x80\x00\x20\x00\x08"
            "\x00" }  },
      /* --- pixel bitmap for cmr160 char#44 (noname) --- */
      {  44, 4898,                      /* character number, location */
          2, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xad\x07" }  },
      /* --- pixel bitmap for cmr160 char#45 (noname) --- */
      {  45, 5804,                      /* character number, location */
          5, 0,     3, 0,     /* topleft row,col, and botleft row,col */
          {  5,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x03" }  },
      /* --- pixel bitmap for cmr160 char#46 (noname) --- */
      {  46, 4917,                      /* character number, location */
          2, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmr160 char#47 / --- */
      {  47, 4928,                      /* character number, location */
         15, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  8,    20, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x80\x40\x40\x40\x20\x20\x10\x10\x10\x08\x08\x08"
            "\x04\x04\x02\x02\x02\x01\x01" }  },
      /* --- pixel bitmap for cmr160 char#48 0 --- */
      {  48, 3290,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3c\x66\x42\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x42\x66\x3c" }  },
      /* --- pixel bitmap for cmr160 char#49 1 --- */
      {  49, 3345,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x10\x1f\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\xfe" }  },
      /* --- pixel bitmap for cmr160 char#50 2 --- */
      {  50, 3378,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3c\x62\xc1\xc3\xc0\xc0\x60\x30\x10\x88\x84\x7e\x7f" }  },
      /* --- pixel bitmap for cmr160 char#51 3 --- */
      {  51, 3421,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3e\x43\xc3\xc0\x60\x3c\x60\xc0\xc0\xc3\xc3\x62\x3c" }  },
      /* --- pixel bitmap for cmr160 char#52 4 --- */
      {  52, 3464,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x60\x60\x70\x68\x68\x64\x62\x63\xff\x60\x60\x60\xf8" }  },
      /* --- pixel bitmap for cmr160 char#53 5 --- */
      {  53, 3507,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x42\x3e\x1e\x02\x02\x3e\x62\xc0\xc0\xc3\xc3\x62\x3c" }  },
      /* --- pixel bitmap for cmr160 char#54 6 --- */
      {  54, 3550,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x78\xcc\xc6\x02\x03\x3b\x67\xc3\xc3\xc3\xc2\x66\x3c" }  },
      /* --- pixel bitmap for cmr160 char#55 7 --- */
      {  55, 3601,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x02\xfc\xfb\x0f\x14\x04\x04\x0c\x08\x18\x30\x30\x60"
            "\xc0\x80\x01" }  },
      /* --- pixel bitmap for cmr160 char#56 8 --- */
      {  56, 3640,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3c\x66\xc3\xc3\x66\x3c\x3c\x66\xc3\xc3\xc3\x66\x3c" }  },
      /* --- pixel bitmap for cmr160 char#57 9 --- */
      {  57, 3691,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3c\x66\x43\xc3\xc3\xc3\xe6\xdc\xc0\x40\x63\x23\x1e" }  },
      /* --- pixel bitmap for cmr160 char#58 : --- */
      {  58, 4975,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  2,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xc0\x03" }  },
      /* --- pixel bitmap for cmr160 char#59 ; --- */
      {  59, 4992,                      /* character number, location */
          9, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  2,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\x40\xeb\x01" }  },
      /* --- pixel bitmap for cmr160 char#60 (noname) --- */
      {  60, 4508,                      /* character number, location */
         10, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  2,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xfc\xff\x0f" }  },
      /* --- pixel bitmap for cmr160 char#61 = --- */
      {  61, 5017,                      /* character number, location */
          8, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          { 14,     7, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xff\x3f\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xff\x03" }  },
      /* --- pixel bitmap for cmr160 char#62 (noname) --- */
      {  62, 3919,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    14, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x0c\x06\x00\x00\x60\x10\x08\x04\xc3\x68\x3c\xf6\x00" }  },
      /* --- pixel bitmap for cmr160 char#63 (noname) --- */
      {  63, 3882,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    14, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xbe\xf0\x58\x0c\x43\x20\x10\x0c\x00\x00\xc0\x60\x00" }  },
      /* --- pixel bitmap for cmr160 char#64 (noname) --- */
      {  64, 5030,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x01\x86\x41\x80\x88\x47\x33\x77\x86\x99\x61\x66"
            "\x98\x19\xe6\xcc\x2d\xde\x11\x00\x18\x38\xf8\x03" }  },
      /* --- pixel bitmap for cmr160 char#65 A --- */
      {  65,   35,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x00\x30\x00\x0c\x80\x06\xa0\x01\xec\x00\x31\x40"
            "\x0c\x08\x06\xfe\x81\x60\x10\x30\x04\xcc\xc7\x0f" }  },
      /* --- pixel bitmap for cmr160 char#66 B --- */
      {  66,   90,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x83\xc1\x30\x30\x06\xc6\xc0\x18\x0c\xff\x60\x70"
            "\x0c\x98\x01\x33\x60\x06\xcc\xc0\xfe\x0f" }  },
      /* --- pixel bitmap for cmr160 char#67 C --- */
      {  67,  147,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x13\x83\x33\x60\x03\x28\x00\x07\xc0\x00\x18\x00"
            "\x03\x40\x00\x1a\x40\x06\x84\x41\xc0\x07" }  },
      /* --- pixel bitmap for cmr160 char#68 D --- */
      {  68,  200,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x03\x83\xc1\x80\x30\x60\x0c\x30\x03\xcc\x00\x33"
            "\xc0\x0c\x30\x03\xcc\x80\x31\x20\x0c\xc6\xff\x00" }  },
      /* --- pixel bitmap for cmr160 char#69 E --- */
      {  69,  259,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xc7\x60\x0c\xc4\x80\x8c\xc8\x08\xfc\xc0\x08\x8c"
            "\xc8\x80\x0c\xcc\x40\x0c\xf6\x7f" }  },
      /* --- pixel bitmap for cmr160 char#70 F --- */
      {  70,  320,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xc7\x60\x0c\xc4\x80\x0c\xc9\x10\xfc\xc1\x10\x0c"
            "\xc1\x00\x0c\xc0\x00\x0c\xf0\x07" }  },
      /* --- pixel bitmap for cmr160 char#71 G --- */
      {  71,  371,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x13\x06\xc7\x80\x19\x40\x02\xd0\x00\x30\x00\x0c"
            "\x00\x03\xbf\x00\x66\x80\x31\x60\x18\x1c\xf8\x04" }  },
      /* --- pixel bitmap for cmr160 char#72 H --- */
      {  72,  428,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x3f\x03\xc3\xc0\x30\x30\x0c\x0c\x03\xc3\xff\x30"
            "\x30\x0c\x0c\x03\xc3\xc0\x30\x30\x0c\xcc\xcf\x0f" }  },
      /* --- pixel bitmap for cmr160 char#73 I --- */
      {  73,  489,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    14, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x3f\xc3\x30\x0c\xc3\x30\x0c\xc3\x30\xcc\x0f" }  },
      /* --- pixel bitmap for cmr160 char#74 J --- */
      {  74,  524,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xc1\x80\x01\x03\x06\x0c\x18\x30\x60\xc0\x80\x19"
            "\x33\xc7\x03" }  },
      /* --- pixel bitmap for cmr160 char#75 K --- */
      {  75,  563,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x1f\x83\xc1\x30\x30\x04\x8c\x00\x33\xc0\x0e\x70"
            "\x06\x8c\x01\xc3\xc0\x60\x30\x18\x0c\xcc\x8f\x0f" }  },
      /* --- pixel bitmap for cmr160 char#76 L --- */
      {  76,  626,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7f\x60\x00\x03\x18\xc0\x00\x06\x30\x80\x01\x0c\x64"
            "\x20\x03\x19\xc4\xb0\xff\x01" }  },
      /* --- pixel bitmap for cmr160 char#77 M --- */
      {  77,  671,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1f\xf0\x39\xe0\x70\xc0\xa1\x41\x43\x83\x86\x06\x0d"
            "\x19\x19\x32\x32\xc4\x62\x88\xc5\x10\x8b\x21\x0c\x43"
            "\x18\xe6\x33\x3f" }  },
      /* --- pixel bitmap for cmr160 char#78 N --- */
      {  78,  772,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\x3e\x07\x42\x83\xd0\x20\x64\x08\x31\x42\x8c\x10"
            "\x26\x84\x0b\xc1\x42\xe0\x10\x38\x04\xcc\x07\x02" }  },
      /* --- pixel bitmap for cmr160 char#79 O --- */
      {  79,  851,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x03\x86\x41\x80\x18\x60\x03\xf0\x00\x3c\x00\x0f"
            "\xc0\x03\xf0\x00\x6c\x80\x31\x30\x18\x06\xfc\x00" }  },
      /* --- pixel bitmap for cmr160 char#80 P --- */
      {  80,  910,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xc1\x60\x0c\xcc\xc0\x0c\xcc\xc0\x0c\xc6\x1f\x0c"
            "\xc0\x00\x0c\xc0\x00\x0c\xf0\x03" }  },
      /* --- pixel bitmap for cmr160 char#81 Q --- */
      {  81,  957,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 14,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x03\x86\xc1\xc0\x18\x60\x03\xf0\x00\x3c\x00\x0f"
            "\xc0\x03\xf0\x00\x6c\x80\xb1\x33\x38\x07\xfc\x00\x20"
            "\x00\x88\x00\x3c\x00\x07" }  },
      /* --- pixel bitmap for cmr160 char#82 R --- */
      {  82, 1028,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x03\x06\x03\x03\x83\x81\xc1\xc0\x60\x30\xf0\x0f"
            "\x18\x06\x0c\x06\x06\x03\x83\x81\xc1\xc0\x60\xfc\xe1"
            "\x01" }  },
      /* --- pixel bitmap for cmr160 char#83 S --- */
      {  83, 1089,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xbc\x8c\x0d\x1a\x34\xc0\x81\x1f\x7c\xc0\x01\x07\x0e"
            "\x3c\xac\x0f" }  },
      /* --- pixel bitmap for cmr160 char#84 T --- */
      {  84, 1140,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x7f\x18\x07\xc3\x60\x18\x0c\x81\x01\x30\x00\x06"
            "\xc0\x00\x18\x00\x03\x60\x00\x0c\xf0\x0f" }  },
      /* --- pixel bitmap for cmr160 char#85 U --- */
      {  85, 1191,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x3e\x03\xc2\x80\x30\x20\x0c\x08\x03\xc2\x80\x30"
            "\x20\x0c\x08\x03\xc2\x80\x20\x10\x18\x06\x78\x00" }  },
      /* --- pixel bitmap for cmr160 char#86 V --- */
      {  86, 1252,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xf8\x18\x10\x18\x10\x18\x10\x30\x08\x30\x08\x60"
            "\x04\x60\x04\x60\x04\xc0\x02\xc0\x02\xc0\x03\x80\x01"
            "\x80\x01" }  },
      /* --- pixel bitmap for cmr160 char#87 W --- */
      {  87, 1309,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 22,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x3f\x3e\x03\x07\x82\xc1\x41\x60\x70\x10\x18\x32"
            "\x04\x8c\x8c\x00\x23\x23\xc0\xcc\x09\x60\x61\x01\x58"
            "\x58\x00\x16\x16\x00\x03\x03\xc0\xc0\x00\x30\x30\x00" }  },
      /* --- pixel bitmap for cmr160 char#88 X --- */
      {  88, 1408,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7e\x7e\x38\x08\x30\x04\x60\x02\xe0\x02\xc0\x01\x80"
            "\x01\x80\x03\x40\x03\x20\x06\x20\x0e\x10\x0c\x18\x18"
            "\x3f\xfc" }  },
      /* --- pixel bitmap for cmr160 char#89 Y --- */
      {  89, 1465,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xf8\x18\x10\x38\x10\x30\x08\x60\x04\x60\x04\xc0"
            "\x02\xc0\x03\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01"
            "\xe0\x07" }  },
      /* --- pixel bitmap for cmr160 char#90 Z --- */
      {  90, 1514,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x3f\xd8\xe0\x02\x13\x0c\x70\x80\x01\x06\x38\xc4"
            "\x20\x03\x1d\x6c\xf0\xff\x03" }  },
      /* --- pixel bitmap for cmr160 char#91 [ --- */
      {  91, 5115,                      /* character number, location */
         15, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  4,    20, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x11\x11\x11\x11\x11\x11\x11\x11\xf1" }  },
      /* --- pixel bitmap for cmr160 char#92 (noname) --- */
      {  92, 5815,                      /* character number, location */
         14, 3,     8, 3,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe2\x1c\x45\xb3\x08" }  },
      /* --- pixel bitmap for cmr160 char#93 ] --- */
      {  93, 5162,                      /* character number, location */
         15, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          {  4,    20, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8f\x88\x88\x88\x88\x88\x88\x88\x88\xf8" }  },
      /* --- pixel bitmap for cmr160 char#94 \^ --- */
      {  94, 5357,                      /* character number, location */
         13, 3,    11, 3,     /* topleft row,col, and botleft row,col */
          {  4,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96" }  },
      /* --- pixel bitmap for cmr160 char#95 (noname) --- */
      {  95, 5370,                      /* character number, location */
         14, 2,    12, 2,     /* topleft row,col, and botleft row,col */
          {  1,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x03" }  },
      /* --- pixel bitmap for cmr160 char#96 (noname) --- */
      {  96, 5209,                      /* character number, location */
         14, 2,     8, 2,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x0b" }  },
      /* --- pixel bitmap for cmr160 char#97 a --- */
      {  97, 1567,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x1e\x46\x80\xc1\xe3\x66\xcc\xd8\xb1\xfe\x00" }  },
      /* --- pixel bitmap for cmr160 char#98 b --- */
      {  98, 1606,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\x30\xc0\x00\x03\x0c\xb0\xc3\x19\xc3\x0c\x33\xcc"
            "\x30\xc3\x9c\xd1\x03" }  },
      /* --- pixel bitmap for cmr160 char#99 c --- */
      {  99, 1659,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\xf3\x60\x30\x18\x0c\x8c\x3c" }  },
      /* --- pixel bitmap for cmr160 char#100 d --- */
      { 100, 1688,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x00\x03\x0c\x30\xc0\xf0\x63\xcc\x30\xc3\x0c\x33"
            "\xcc\x30\xe6\x70\x0f" }  },
      /* --- pixel bitmap for cmr160 char#101 e --- */
      { 101, 1739,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\xd3\xf8\x3f\x18\x0c\x8c\x3c" }  },
      /* --- pixel bitmap for cmr160 char#102 f --- */
      { 102, 1770,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\xc8\x0c\x0c\x0c\x3f\x0c\x0c\x0c\x0c\x0c\x0c\x0c"
            "\x3f" }  },
      /* --- pixel bitmap for cmr160 char#103 g --- */
      { 103, 1807,                      /* character number, location */
          9, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xb8\x13\x69\x8c\x31\x44\xf8\x60\x80\x3f\xfc\x09\x3e"
            "\xf0\xc0\x86\xe1\x01" }  },
      /* --- pixel bitmap for cmr160 char#104 h --- */
      { 104, 1862,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\x60\x00\x03\x18\xc0\x00\x76\x70\x86\x31\x8c\x61"
            "\x0c\x63\x18\xc3\x98\xdf\x03" }  },
      /* --- pixel bitmap for cmr160 char#105 i --- */
      { 105, 1915,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x66\x00\x70\x66\x66\x66\xf6" }  },
      /* --- pixel bitmap for cmr160 char#106 j --- */
      { 106, 1946,                      /* character number, location */
         14,-2,    -4,-2,     /* topleft row,col, and botleft row,col */
          {  6,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x30\x0c\x00\x00\x0f\xc3\x30\x0c\xc3\x30\x0c\xc3\xf3"
            "\x03" }  },
      /* --- pixel bitmap for cmr160 char#107 k --- */
      { 107, 1987,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\x60\x00\x03\x18\xc0\x00\xf6\x31\x83\x0d\x3c\xe0"
            "\x03\x3b\x98\xc1\x98\xcf\x03" }  },
      /* --- pixel bitmap for cmr160 char#108 l --- */
      { 108, 2036,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x67\x66\x66\x66\x66\x66\xf6" }  },
      /* --- pixel bitmap for cmr160 char#109 m --- */
      { 109, 2071,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xef\x79\x70\x1c\xc3\x30\x0c\xc3\x30\x0c\xc3\x30\x0c"
            "\xc3\x30\x0c\xc3\x30\xbf\xef\x03" }  },
      /* --- pixel bitmap for cmr160 char#110 n --- */
      { 110, 2132,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xef\xe0\x0c\x63\x18\xc3\x18\xc6\x30\x86\x31\xbf\x07" }  },
      /* --- pixel bitmap for cmr160 char#111 o --- */
      { 111, 2175,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x66\xc3\xc3\xc3\xc3\xc3\x66\x3c" }  },
      /* --- pixel bitmap for cmr160 char#112 p --- */
      { 112, 2214,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xef\x70\xc6\x30\xc3\x0c\x33\xcc\x30\x67\xfc\x30\xc0"
            "\x00\x03\x3f\x00" }  },
      /* --- pixel bitmap for cmr160 char#113 q --- */
      { 113, 2263,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x31\x8e\x60\x06\x33\x98\xc1\x08\xc6\x38\xbc\x01"
            "\x0c\x60\x00\x03\x7e" }  },
      /* --- pixel bitmap for cmr160 char#114 r --- */
      { 114, 2314,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\xdc\x0c\x0c\x0c\x0c\x0c\x0c\x3f" }  },
      /* --- pixel bitmap for cmr160 char#115 s --- */
      { 115, 2341,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x38\x3e\x1e\x1c\xc7\x1f" }  },
      /* --- pixel bitmap for cmr160 char#116 t --- */
      { 116, 2374,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x08\x04\xe3\xcf\x60\x30\x18\x4c\x26\x13\x07" }  },
      /* --- pixel bitmap for cmr160 char#117 u --- */
      { 117, 2411,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xef\x61\x0c\x63\x18\xc3\x18\xc6\x30\x86\x39\xf8\x07" }  },
      /* --- pixel bitmap for cmr160 char#118 v --- */
      { 118, 2452,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x9f\x67\x08\x67\x30\x81\x09\x38\xc0\x01\x0e\x20\x00" }  },
      /* --- pixel bitmap for cmr160 char#119 w --- */
      { 119, 2487,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xcf\x7b\xc6\x08\x63\x04\x6b\x81\xb5\xc0\x5a\xc0\x18"
            "\x60\x0c\x30\x06" }  },
      /* --- pixel bitmap for cmr160 char#120 x --- */
      { 120, 2548,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xdf\x67\x04\x16\xe0\x00\x06\x38\x20\x83\x31\xcf\x07" }  },
      /* --- pixel bitmap for cmr160 char#121 y --- */
      { 121, 2585,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x9f\x67\x08\x67\x30\x81\x09\x38\xc0\x01\x0e\x20\x00"
            "\x01\x04\x26\xe0\x00" }  },
      /* --- pixel bitmap for cmr160 char#122 z --- */
      { 122, 2630,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x59\x2c\xc3\x61\x1a\xcd\x7f" }  },
      /* --- pixel bitmap for cmr160 char#123 (noname) --- */
      { 123, 5846,                      /* character number, location */
          6, 0,     5, 0,     /* topleft row,col, and botleft row,col */
          { 10,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x03" }  },
      /* --- pixel bitmap for cmr160 char#124 (noname) --- */
      { 124, 5855,                      /* character number, location */
          6, 0,     5, 0,     /* topleft row,col, and botleft row,col */
          { 21,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xff\x1f" }  },
      /* --- pixel bitmap for cmr160 char#125 (noname) --- */
      { 125, 5381,                      /* character number, location */
         14, 2,    11, 2,     /* topleft row,col, and botleft row,col */
          {  6,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb6\x2d\x01" }  },
      /* --- pixel bitmap for cmr160 char#126 \~ --- */
      { 126, 5400,                      /* character number, location */
         13, 2,    10, 2,     /* topleft row,col, and botleft row,col */
          {  6,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa4\x97\x00" }  },
      /* --- pixel bitmap for cmr160 char#127 (noname) --- */
      { 127, 5417,                      /* character number, location */
         14, 2,    12, 2,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf3\x0c" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=5 ---
 * mf '\mode=lqlores; input cmr10'    gives .gf180
 * ----------------------------------------------- */
/* --- fontdef for cmr180 --- */
static	chardef  cmr180[] =
   {
      /* --- pixel bitmap for cmr180 char#0 (noname) --- */
      {   0, 3225,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x1f\x06\x86\x01\x61\xc0\x18\x20\x06\x88\x01\x60"
            "\x00\x18\x00\x06\x80\x01\x60\x00\x18\x00\x06\x80\x01"
            "\x60\x00\xff\x00" }  },
      /* --- pixel bitmap for cmr180 char#1 (noname) --- */
      {   1, 3276,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x03\x00\x0c\x00\x68\x00\xa0\x01\x40\x0c\x00\x31"
            "\x00\x82\x01\x08\x06\x10\x30\x40\xc0\x80\x00\x06\x02"
            "\x18\x04\xc0\x10\x00\x23\x00\x98\xff\x7f\xff\xff\x03" }  },
      /* --- pixel bitmap for cmr180 char#2 (noname) --- */
      {   2, 3343,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x07\x38\x1c\x0c\x30\x04\x20\x06\x60\x02\x40\x13"
            "\xc8\xf3\xcf\xf3\xcf\x13\xc8\x03\xc0\x03\xc0\x06\x60"
            "\x04\x20\x0c\x30\x38\x1c\xe0\x07" }  },
      /* --- pixel bitmap for cmr180 char#3 (noname) --- */
      {   3, 3426,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x00\x30\x00\x0c\x80\x07\xa0\x01\x68\x00\x1a\x40"
            "\x0c\x10\x03\xc4\x80\x60\x20\x18\x08\x06\x81\x43\xc0"
            "\x30\x30\x1f\x3f" }  },
      /* --- pixel bitmap for cmr180 char#4 (noname) --- */
      {   4, 3493,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\xff\x1f\x00\x06\x80\x00\x00\x00\x40\x80\xf0"
            "\x3f\xfc\x0f\x01\x02\x00\x00\x00\x00\x40\x00\x18\x00"
            "\xfe\xff\xff\x3f" }  },
      /* --- pixel bitmap for cmr180 char#5 (noname) --- */
      {   5, 3540,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\x63\x80\x81\x01\x06\x06\x18\x18\x60\x60\x80"
            "\x81\x01\x06\x06\x18\x18\x60\x60\x80\x81\x01\x06\x06"
            "\x18\x18\x60\x60\x80\x81\x01\x06\x06\x18\xff\xfc\x03" }  },
      /* --- pixel bitmap for cmr180 char#6 (noname) --- */
      {   6, 3613,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x3f\x03\x9c\x03\x88\x01\x8c\x01\xc4\x00\xc2\x00"
            "\xc0\x00\x60\x00\x20\x00\x08\x00\x02\x88\x00\x24\x00"
            "\x13\x80\x04\x70\xff\x3f" }  },
      /* --- pixel bitmap for cmr180 char#7 (noname) --- */
      {   7, 3674,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x38\x3e\x7c\x61\x86\x41\x82\x80\x01\x80\x01\x80"
            "\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01"
            "\x80\x01\x80\x01\x80\x01\xf0\x0f" }  },
      /* --- pixel bitmap for cmr180 char#8 (noname) --- */
      {   8, 3731,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x0f\xc0\x00\x60\x00\x30\x00\x7f\x60\xcc\x18\xc6"
            "\x06\xc3\x83\xe1\xc1\xb0\x61\x8c\x31\x03\x7f\x00\x0c"
            "\x00\x06\x00\x03\xf0\x0f" }  },
      /* --- pixel bitmap for cmr180 char#9 (noname) --- */
      {   9, 3800,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x0f\x80\x01\x80\x01\x87\xe1\x8c\x31\x8c\x31\x8c"
            "\x31\x8c\x31\x8c\x31\x8c\x31\x98\x19\xb0\x0d\xe0\x07"
            "\x80\x01\x80\x01\x80\x01\xf0\x0f" }  },
      /* --- pixel bitmap for cmr180 char#10 (noname) --- */
      {  10, 3877,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x07\x0c\x86\x01\xcc\x00\x36\x00\x1e\x00\x0f\x80"
            "\x07\xc0\x02\x20\x03\x18\x01\x84\x01\x83\x80\x48\x40"
            "\x46\x10\x3d\x78\x1e\x3c" }  },
      /* --- pixel bitmap for cmr180 char#11 (noname) --- */
      {  11, 6564,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x7b\x18\xce\x0c\x06\x0c\x06\x0c\x06\x0c\x06\xff"
            "\x3f\x0c\x06\x0c\x06\x0c\x06\x0c\x06\x0c\x06\x0c\x06"
            "\x0c\x06\x0c\x06\x0c\x06\x1f\x1f" }  },
      /* --- pixel bitmap for cmr180 char#12 (noname) --- */
      {  12, 6639,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x03\xc3\x30\x18\x06\xc0\x00\x18\xc0\xff\x61\x30"
            "\x0c\x86\xc1\x30\x18\x06\xc3\x60\x18\x0c\x83\x61\x30"
            "\x1f\x1f" }  },
      /* --- pixel bitmap for cmr180 char#13 (noname) --- */
      {  13, 6704,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x07\xc3\x30\x18\x06\xc3\x60\x18\xcc\xff\x61\x30"
            "\x0c\x86\xc1\x30\x18\x06\xc3\x60\x18\x0c\x83\x61\x30"
            "\xbf\x1f" }  },
      /* --- pixel bitmap for cmr180 char#14 (noname) --- */
      {  14, 6775,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 20,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\xf3\x81\xe1\x30\x0c\x06\xc3\x60\x00\x0c\x06\xc0"
            "\x60\x00\xff\xff\xc3\x60\x30\x0c\x06\xc3\x60\x30\x0c"
            "\x06\xc3\x60\x30\x0c\x06\xc3\x60\x30\x0c\x06\xc3\x60"
            "\x30\x1f\x8f\x0f" }  },
      /* --- pixel bitmap for cmr180 char#15 (noname) --- */
      {  15, 6872,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 20,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\xf3\x83\xe1\x30\x0c\x06\xc3\x60\x30\x0c\x06\xc3"
            "\x60\x30\xff\xff\xc3\x60\x30\x0c\x06\xc3\x60\x30\x0c"
            "\x06\xc3\x60\x30\x0c\x06\xc3\x60\x30\x0c\x06\xc3\x60"
            "\x30\xbf\xdf\x0f" }  },
      /* --- pixel bitmap for cmr180 char#16 (noname) --- */
      {  16, 4766,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\xc3\x30\x0c\xc3\x30\x0c\xf3\x03" }  },
      /* --- pixel bitmap for cmr180 char#17 (noname) --- */
      {  17, 4795,                      /* character number, location */
         11,-2,    -5,-2,     /* topleft row,col, and botleft row,col */
          {  7,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x30\x18\x0c\x06\x83\xc1\x60\x30\x18\x0c\x06\xcf"
            "\x3c" }  },
      /* --- pixel bitmap for cmr180 char#18 (noname) --- */
      {  18, 6332,                      /* character number, location */
         17, 2,    13, 2,     /* topleft row,col, and botleft row,col */
          {  5,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe3\x38\x0c" }  },
      /* --- pixel bitmap for cmr180 char#19 (noname) --- */
      {  19, 6347,                      /* character number, location */
         17, 4,    13, 4,     /* topleft row,col, and botleft row,col */
          {  5,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\xbb\x01" }  },
      /* --- pixel bitmap for cmr180 char#20 (noname) --- */
      {  20, 6362,                      /* character number, location */
         16, 3,    13, 3,     /* topleft row,col, and botleft row,col */
          {  5,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd1\x11" }  },
      /* --- pixel bitmap for cmr180 char#21 (noname) --- */
      {  21, 6377,                      /* character number, location */
         17, 2,    13, 2,     /* topleft row,col, and botleft row,col */
          {  7,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc1\xa0\x88\x03" }  },
      /* --- pixel bitmap for cmr180 char#22 (noname) --- */
      {  22, 6398,                      /* character number, location */
         14, 2,    13, 2,     /* topleft row,col, and botleft row,col */
          {  7,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f" }  },
      /* --- pixel bitmap for cmr180 char#23 (noname) --- */
      {  23, 6407,                      /* character number, location */
         17, 6,    13, 6,     /* topleft row,col, and botleft row,col */
          {  6,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x18\x7a" }  },
      /* --- pixel bitmap for cmr180 char#24 (noname) --- */
      {  24, 6426,                      /* character number, location */
          0, 3,    -4, 3,     /* topleft row,col, and botleft row,col */
          {  5,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c\xe3\x0f" }  },
      /* --- pixel bitmap for cmr180 char#25 \ss --- */
      {  25, 4836,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x60\xc6\x30\xc3\x0c\x33\xf6\x0e\x23\x8c\x31\xc4"
            "\x30\xc3\x0c\x33\xcc\x34\x73\xcf\x00" }  },
      /* --- pixel bitmap for cmr180 char#26 \ae --- */
      {  26, 4911,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7c\x1c\x63\x19\x60\x18\x30\x0c\xff\x67\x0c\x08\x06"
            "\x06\x03\x83\x43\x61\x11\x1f\x07" }  },
      /* --- pixel bitmap for cmr180 char#27 \oe --- */
      {  27, 4970,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x38\x84\x64\x86\xc3\x03\xc3\x03\xff\x03\x03\x03"
            "\x03\x03\x03\x86\x87\x84\x44\x78\x38" }  },
      /* --- pixel bitmap for cmr180 char#28 (noname) --- */
      {  28, 5035,                      /* character number, location */
         13, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  9,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x00\xe1\x31\x26\x6a\xf4\xec\xc9\x9b\x17\x2b\x32"
            "\xc6\x43\x80\x00" }  },
      /* --- pixel bitmap for cmr180 char#29 \AE --- */
      {  29, 5104,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\xff\x03\x34\x18\xa0\x81\x80\x0c\x0c\x64\x40\x20"
            "\x43\x82\x18\x02\xc4\x18\xe0\xff\x80\x30\x06\x84\x21"
            "\x21\x0c\x89\x60\x40\x04\x03\x31\x18\x88\xc1\x60\x9f"
            "\xff\x03" }  },
      /* --- pixel bitmap for cmr180 char#30 \OE --- */
      {  30, 5209,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 22,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\xff\x1f\x0c\x07\xc6\x80\x01\x31\x60\xc0\x06\x18"
            "\xa0\x00\x06\x39\x80\x41\x0c\x60\x18\x03\xf8\xc7\x00"
            "\x86\x31\x80\x41\x1a\x60\x90\x06\x18\x20\x03\x06\xc4"
            "\x81\x01\xc1\x70\x60\xc0\xff\x1f" }  },
      /* --- pixel bitmap for cmr180 char#31 (noname) --- */
      {  31, 5314,                      /* character number, location */
         18, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 16,    19, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x20\xe0\x37\x38\x1c\x0c\x38\x04\x28\x06\x64\x02"
            "\x42\x03\xc2\x03\xc1\x83\xc1\x83\xc0\x43\xc0\x43\xc0"
            "\x26\x60\x14\x20\x1c\x30\x38\x1c\xec\x07\x04\x00" }  },
      /* --- pixel bitmap for cmr180 char#32 (noname) --- */
      {  32, 6460,                      /* character number, location */
         10, 0,     7, 0,     /* topleft row,col, and botleft row,col */
          {  6,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x33\x00" }  },
      /* --- pixel bitmap for cmr180 char#33 ! --- */
      {  33, 5415,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  3,    17, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfa\xff\x4b\x92\x00\xe8\x02" }  },
      /* --- pixel bitmap for cmr180 char#34 " --- */
      {  34, 6975,                      /* character number, location */
         17, 1,     9, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x42\xe7\xc6\x84\x84\x84\x42\x21" }  },
      /* --- pixel bitmap for cmr180 char#35 # --- */
      {  35, 5489,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 18,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x41\x00\x04\x01\x10\x04\x40\x10\x80\x20\x00\x82"
            "\x00\x08\xc2\xff\xff\x40\x10\x00\x41\x00\x82\x00\x08"
            "\x02\x20\x08\xfc\xff\x0f\x41\x00\x04\x01\x10\x04\x40"
            "\x10\x80\x20\x00\x82\x00\x08\x02\x20\x08\x00" }  },
      /* --- pixel bitmap for cmr180 char#36 $ --- */
      {  36, 4510,                      /* character number, location */
         19, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  9,    20, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x20\xe0\x91\x04\x31\x62\xe4\x08\x16\x7c\xe0\x81"
            "\x06\x19\xe2\xc4\x88\x11\xa4\xf1\x80\x00" }  },
      /* --- pixel bitmap for cmr180 char#37 % --- */
      {  37, 5580,                      /* character number, location */
         19, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 18,    20, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x80\x98\x00\x21\x0e\xc7\xd0\x0b\x43\x10\x0c\x41"
            "\x30\x84\xc0\x10\x01\x22\x04\x98\x08\xc0\x11\x0e\x20"
            "\x4c\x80\x10\x02\x61\x08\x82\x21\x08\x86\x10\x18\x22"
            "\x40\x88\x00\x13\x01\x38" }  },
      /* --- pixel bitmap for cmr180 char#38 & --- */
      {  38, 4595,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x60\x00\x90\x00\x98\x00\x98\x00\x98\x00\x58\x00\x38"
            "\xfc\x30\x30\x38\x10\x38\x10\x64\x08\xe2\x04\xc3\x04"
            "\x83\x03\x03\x83\xc6\xc6\x3c\x3c" }  },
      /* --- pixel bitmap for cmr180 char#39 (noname) --- */
      {  39, 5705,                      /* character number, location */
         17, 2,     9, 2,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x49\x2a" }  },
      /* --- pixel bitmap for cmr180 char#40 ( --- */
      {  40, 5728,                      /* character number, location */
         19, 2,    -6, 2,     /* topleft row,col, and botleft row,col */
          {  6,    25, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x84\x30\x84\x61\x08\xc3\x30\x0c\xc3\x30\x0c\x83"
            "\x60\x18\x04\x83\x40\x20" }  },
      /* --- pixel bitmap for cmr180 char#41 ) --- */
      {  41, 5785,                      /* character number, location */
         19, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  6,    25, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x81\x40\x30\x08\x86\x41\x30\x0c\xc3\x30\x0c\xc3\x30"
            "\x84\x61\x08\x43\x08\x01" }  },
      /* --- pixel bitmap for cmr180 char#42 * --- */
      {  42, 5842,                      /* character number, location */
         19, 1,     8, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x10\x20\x48\xba\xee\x0f\x87\xbf\xeb\x92\x20\x40\x00" }  },
      /* --- pixel bitmap for cmr180 char#43 + --- */
      {  43, 5887,                      /* character number, location */
         15, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00"
            "\x01\x00\x01\xff\xff\x00\x01\x00\x01\x00\x01\x00\x01"
            "\x00\x01\x00\x01\x00\x01\x00\x01" }  },
      /* --- pixel bitmap for cmr180 char#44 (noname) --- */
      {  44, 5928,                      /* character number, location */
          3, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x49\x2a" }  },
      /* --- pixel bitmap for cmr180 char#45 (noname) --- */
      {  45, 7014,                      /* character number, location */
          6, 0,     4, 0,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x0f" }  },
      /* --- pixel bitmap for cmr180 char#46 (noname) --- */
      {  46, 5951,                      /* character number, location */
          3, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x00" }  },
      /* --- pixel bitmap for cmr180 char#47 / --- */
      {  47, 5964,                      /* character number, location */
         19, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  9,    25, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x02\x02\x04\x08\x08\x10\x20\x20\x40\x80\x80"
            "\x00\x01\x02\x02\x04\x08\x08\x10\x20\x20\x40\x80\x80"
            "\x00\x01\x00" }  },
      /* --- pixel bitmap for cmr180 char#48 0 --- */
      {  48, 3958,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x8c\x09\x12\x34\x78\xf0\xe0\xc1\x83\x07\x0f\x1e"
            "\x3c\x58\x90\x31\x1c" }  },
      /* --- pixel bitmap for cmr180 char#49 1 --- */
      {  49, 4025,                      /* character number, location */
         16, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  7,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x4f\x06\x83\xc1\x60\x30\x18\x0c\x06\x83\xc1\x60"
            "\xfe" }  },
      /* --- pixel bitmap for cmr180 char#50 2 --- */
      {  50, 4066,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3c\x84\x05\x0a\x3c\x18\x30\x60\x60\x40\x40\xc0\xc0"
            "\x80\x90\xa0\xbf\x7f" }  },
      /* --- pixel bitmap for cmr180 char#51 3 --- */
      {  51, 4117,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x88\x18\x33\x06\x0c\x18\x18\x1c\xc0\x00\x01\x1e"
            "\x3c\x38\x90\x30\x1e" }  },
      /* --- pixel bitmap for cmr180 char#52 4 --- */
      {  52, 4170,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\xc0\xc0\x81\x83\x06\x0d\x19\x33\x62\xc2\xfc\x07"
            "\x03\x06\x0c\x18\xfc" }  },
      /* --- pixel bitmap for cmr180 char#53 5 --- */
      {  53, 4221,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x82\xfc\xe8\x10\x20\x40\x80\x0e\x63\x82\x00\x03\x06"
            "\x3c\x38\x90\x10\x1e" }  },
      /* --- pixel bitmap for cmr180 char#54 6 --- */
      {  54, 4276,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x10\x12\x36\x2c\x60\xc0\x8e\x63\x83\x06\x0f\x1e"
            "\x2c\xd8\x10\x31\x1c" }  },
      /* --- pixel bitmap for cmr180 char#55 7 --- */
      {  55, 4339,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x02\xf8\xef\x5f\x40\x81\x00\x01\x04\x08\x20\x40\x00"
            "\x01\x04\x18\x60\x80\x01\x06\x18\x00" }  },
      /* --- pixel bitmap for cmr180 char#56 8 --- */
      {  56, 4384,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x88\x18\x33\x66\xcc\x09\x1f\x1c\x64\x8c\x0d\x1e"
            "\x3c\x78\x90\x31\x1e" }  },
      /* --- pixel bitmap for cmr180 char#57 9 --- */
      {  57, 4447,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x88\x08\x1b\x34\x78\xf0\x60\xc1\xc6\x71\x03\x06"
            "\x34\x6c\xc8\x18\x0e" }  },
      /* --- pixel bitmap for cmr180 char#58 : --- */
      {  58, 6021,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  3,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x00\x00\xba\x00" }  },
      /* --- pixel bitmap for cmr180 char#59 ; --- */
      {  59, 6042,                      /* character number, location */
         11, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          {  3,    16, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x00\x00\xba\x49\x2a" }  },
      /* --- pixel bitmap for cmr180 char#60 (noname) --- */
      {  60, 5452,                      /* character number, location */
         12, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          {  3,    17, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x00\x48\x92\xfe\xff\x02" }  },
      /* --- pixel bitmap for cmr180 char#61 = --- */
      {  61, 6073,                      /* character number, location */
         10, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 16,     7, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff"
            "\xff" }  },
      /* --- pixel bitmap for cmr180 char#62 (noname) --- */
      {  62, 4723,                      /* character number, location */
         12, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x70\x40\x00\x00\x00\x00\x04\x08\x10\x20\x20\x20"
            "\x20\x60\xf0\x60\x41\x7c\x00" }  },
      /* --- pixel bitmap for cmr180 char#63 (noname) --- */
      {  63, 4680,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7c\x04\x0d\x1e\x0c\x08\x08\x08\x08\x10\x20\x40\x00"
            "\x00\x00\x00\x04\x1c\x10\x00" }  },
      /* --- pixel bitmap for cmr180 char#64 (noname) --- */
      {  64, 6086,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x07\x10\x08\x08\x10\xc4\x23\x22\x44\x32\x58\x19"
            "\x98\x19\x98\x19\x98\x19\x98\x19\x98\x32\x98\x22\x9c"
            "\xc4\x73\x08\x00\x10\xe0\xe0\x1f" }  },
      /* --- pixel bitmap for cmr180 char#65 A --- */
      {  65,   35,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x01\x80\x01\x80\x01\x40\x03\x40\x03\x40\x03\x20"
            "\x06\x20\x06\x20\x06\x10\x0c\x10\x0c\xf0\x0f\x08\x18"
            "\x08\x18\x08\x18\x0c\x30\x1f\xfc" }  },
      /* --- pixel bitmap for cmr180 char#66 B --- */
      {  66,  102,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x0f\x18\x38\x18\x20\x18\x60\x18\x60\x18\x60\x18"
            "\x30\x18\x1c\xf8\x3f\x18\x60\x18\xc0\x18\xc0\x18\xc0"
            "\x18\xc0\x18\x60\x18\x30\xff\x1f" }  },
      /* --- pixel bitmap for cmr180 char#67 C --- */
      {  67,  171,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x47\x18\x3c\x02\x98\x00\x6c\x00\x14\x00\x0e\x00"
            "\x06\x00\x03\x80\x01\xc0\x00\x40\x00\x68\x00\x24\x00"
            "\x22\x80\x60\x30\xc0\x07" }  },
      /* --- pixel bitmap for cmr180 char#68 D --- */
      {  68,  234,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x07\x0c\x1c\x0c\x30\x0c\x20\x0c\x60\x0c\x40\x0c"
            "\xc0\x0c\xc0\x0c\xc0\x0c\xc0\x0c\xc0\x0c\xc0\x0c\x60"
            "\x0c\x60\x0c\x30\x0c\x1c\xff\x07" }  },
      /* --- pixel bitmap for cmr180 char#69 E --- */
      {  69,  305,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x1f\x03\xc6\x00\x31\xc0\x0c\x20\x83\xc8\x20\x30"
            "\x0c\xfc\x03\xc3\xc0\x20\x32\x88\x0c\x20\x03\xc4\x00"
            "\x31\x60\xff\x1f" }  },
      /* --- pixel bitmap for cmr180 char#70 F --- */
      {  70,  380,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x8f\x81\x31\x20\x06\xcc\x00\x19\x22\x43\x60\x0c"
            "\xfc\x81\x31\x30\x04\x86\xc0\x00\x18\x00\x03\x60\x00"
            "\x7f\x00" }  },
      /* --- pixel bitmap for cmr180 char#71 G --- */
      {  71,  443,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x47\x60\xf0\x20\x80\x21\x00\x63\x00\x44\x00\xc8"
            "\x00\x80\x01\x00\x03\x00\x06\xf8\x0f\x80\x11\x00\x63"
            "\x00\x86\x00\x0c\x02\x18\x18\x38\xc0\x4f\x00" }  },
      /* --- pixel bitmap for cmr180 char#72 H --- */
      {  72,  512,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xfc\x63\x80\x81\x01\x06\x06\x18\x18\x60\x60\x80"
            "\x81\x01\x06\x06\x18\xf8\x7f\x60\x80\x81\x01\x06\x06"
            "\x18\x18\x60\x60\x80\x81\x01\x06\x06\x18\xff\xfc\x03" }  },
      /* --- pixel bitmap for cmr180 char#73 I --- */
      {  73,  585,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18"
            "\x18\x18\x18\xff" }  },
      /* --- pixel bitmap for cmr180 char#74 J --- */
      {  74,  626,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xc1\x80\x01\x03\x06\x0c\x18\x30\x60\xc0\x80\x01"
            "\x03\x66\xcc\x98\x19\x1c\x00" }  },
      /* --- pixel bitmap for cmr180 char#75 K --- */
      {  75,  673,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x7c\x0c\x18\x0c\x08\x0c\x04\x0c\x02\x0c\x01\x8c"
            "\x00\xcc\x01\x2c\x01\x1c\x03\x0c\x06\x0c\x0c\x0c\x0c"
            "\x0c\x18\x0c\x30\x0c\x30\x3f\xf8" }  },
      /* --- pixel bitmap for cmr180 char#76 L --- */
      {  76,  750,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x00\x06\x80\x01\x60\x00\x18\x00\x06\x80\x01\x60"
            "\x00\x18\x00\x06\x80\x01\x62\x80\x18\x20\x06\x8c\x01"
            "\x61\x70\xff\x1f" }  },
      /* --- pixel bitmap for cmr180 char#77 M --- */
      {  77,  803,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 22,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x00\x3f\x0e\xc0\x81\x03\x70\xa0\x01\x1a\x68\x80"
            "\x06\x32\x90\x81\x0c\x64\x20\x03\x19\x88\x21\x06\x62"
            "\x88\x81\x30\x61\x20\x4c\x18\x08\x13\x06\x82\x83\x81"
            "\xe0\x60\x20\x38\x18\x7f\xc4\x3f" }  },
      /* --- pixel bitmap for cmr180 char#78 N --- */
      {  78,  926,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1f\xf8\xe3\x00\x81\x03\x04\x1a\x10\xc8\x40\x20\x03"
            "\x81\x18\x04\xc2\x10\x08\x43\x20\x18\x81\xc0\x04\x02"
            "\x16\x08\x58\x20\xc0\x81\x00\x06\x02\x18\x7f\x40\x00" }  },
      /* --- pixel bitmap for cmr180 char#79 O --- */
      {  79, 1021,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x07\x38\x1c\x0c\x30\x04\x20\x06\x60\x02\x40\x03"
            "\xc0\x03\xc0\x03\xc0\x03\xc0\x03\xc0\x03\xc0\x06\x60"
            "\x04\x20\x0c\x30\x38\x1c\xe0\x07" }  },
      /* --- pixel bitmap for cmr180 char#80 P --- */
      {  80, 1092,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x07\x03\xc3\x80\x31\xc0\x0c\x30\x03\xcc\x80\x31"
            "\x30\xfc\x07\x03\xc0\x00\x30\x00\x0c\x00\x03\xc0\x00"
            "\x30\x00\x3f\x00" }  },
      /* --- pixel bitmap for cmr180 char#81 Q --- */
      {  81, 1147,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 16,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x07\x38\x1c\x0c\x30\x04\x20\x06\x60\x02\x40\x03"
            "\xc0\x03\xc0\x03\xc0\x03\xc0\x03\xc0\x03\xc0\x06\x60"
            "\x84\x21\x4c\x32\x78\x1c\xe0\x87\x00\x84\x00\x84\x00"
            "\xcc\x00\x78\x00\x30" }  },
      /* --- pixel bitmap for cmr180 char#82 R --- */
      {  82, 1242,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x03\x0c\x06\x0c\x0c\x0c\x18\x0c\x18\x0c\x18\x0c"
            "\x0c\x0c\x06\xfc\x03\x0c\x06\x0c\x0c\x0c\x0c\x0c\x0c"
            "\x0c\x0c\x0c\x8c\x0c\x88\x3f\x70" }  },
      /* --- pixel bitmap for cmr180 char#83 S --- */
      {  83, 1317,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x32\x9c\xc0\x06\x34\xa0\x01\x38\xc0\x0f\xf8\x01"
            "\x1e\xc0\x01\x1c\xe0\x00\x0f\xe8\x20\xf9\x00" }  },
      /* --- pixel bitmap for cmr180 char#84 T --- */
      {  84, 1378,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\xc1\x70\x60\x30\x30\x18\x18\x0c\x0c\x02\x06"
            "\x00\x03\x80\x01\xc0\x00\x60\x00\x30\x00\x18\x00\x0c"
            "\x00\x06\x00\x03\xf0\x0f" }  },
      /* --- pixel bitmap for cmr180 char#85 U --- */
      {  85, 1439,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xf8\x63\x00\x81\x01\x04\x06\x10\x18\x40\x60\x00"
            "\x81\x01\x04\x06\x10\x18\x40\x60\x00\x81\x01\x04\x06"
            "\x10\x18\x40\x40\x00\x01\x03\x02\x18\x04\x80\x0f\x00" }  },
      /* --- pixel bitmap for cmr180 char#86 V --- */
      {  86, 1512,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xf8\x0c\x70\x0c\x20\x18\x10\x18\x10\x18\x10\x30"
            "\x08\x30\x08\x30\x08\x60\x04\x60\x04\xe0\x06\xc0\x02"
            "\xc0\x02\x80\x01\x80\x01\x80\x01" }  },
      /* --- pixel bitmap for cmr180 char#87 W --- */
      {  87, 1581,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 23,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xfe\x7c\x06\x0c\x18\x03\x0d\x84\x81\x06\xc2\x40"
            "\x83\xc1\xa0\x41\x60\x88\x21\x30\xc4\x10\x30\x62\x04"
            "\x98\x60\x02\x4c\x30\x01\x2c\x58\x00\x1e\x3c\x00\x07"
            "\x1c\x80\x03\x0e\x80\x01\x03\x40\x00\x01" }  },
      /* --- pixel bitmap for cmr180 char#88 X --- */
      {  88, 1700,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7f\x7e\x18\x18\x18\x08\x30\x04\x60\x06\x60\x02\xc0"
            "\x01\xc0\x01\x80\x01\x40\x03\x40\x07\x20\x06\x30\x0c"
            "\x10\x0c\x08\x18\x0c\x38\x3f\xfc" }  },
      /* --- pixel bitmap for cmr180 char#89 Y --- */
      {  89, 1769,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7f\xf0\x63\x80\x81\x03\x06\x0c\x08\x60\x10\x80\x41"
            "\x00\x8c\x00\x70\x03\x80\x05\x00\x0c\x00\x30\x00\xc0"
            "\x00\x00\x03\x00\x0c\x00\x30\x00\xc0\x00\xe0\x0f\x00" }  },
      /* --- pixel bitmap for cmr180 char#90 Z --- */
      {  90, 1828,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfe\xef\x60\x06\x26\x30\x02\x23\x18\xc0\x00\x0c\x60"
            "\x00\x03\x30\x88\x81\x0c\xc8\x80\x06\x6c\xe0\xff\x0f" }  },
      /* --- pixel bitmap for cmr180 char#91 [ --- */
      {  91, 6195,                      /* character number, location */
         19, 2,    -6, 2,     /* topleft row,col, and botleft row,col */
          {  4,    25, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x1f\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x0f" }  },
      /* --- pixel bitmap for cmr180 char#92 (noname) --- */
      {  92, 7025,                      /* character number, location */
         17, 2,     9, 2,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x42\x21\x21\x21\x63\xe7\x42" }  },
      /* --- pixel bitmap for cmr180 char#93 ] --- */
      {  93, 6252,                      /* character number, location */
         19, 0,    -6, 0,     /* topleft row,col, and botleft row,col */
          {  5,    25, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1f\x42\x08\x21\x84\x10\x42\x08\x21\x84\x10\x42\x08"
            "\x21\x84\x1f" }  },
      /* --- pixel bitmap for cmr180 char#94 \^ --- */
      {  94, 6473,                      /* character number, location */
         17, 3,    13, 3,     /* topleft row,col, and botleft row,col */
          {  5,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc4\xed\x08" }  },
      /* --- pixel bitmap for cmr180 char#95 (noname) --- */
      {  95, 6492,                      /* character number, location */
         18, 1,    15, 1,     /* topleft row,col, and botleft row,col */
          {  4,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf6\x06" }  },
      /* --- pixel bitmap for cmr180 char#96 (noname) --- */
      {  96, 6309,                      /* character number, location */
         17, 2,     9, 2,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x54\x92\x5d" }  },
      /* --- pixel bitmap for cmr180 char#97 a --- */
      {  97, 1891,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3c\x98\x01\x0c\x30\xf8\x38\x33\xcc\xb0\xc3\x8a\xcb"
            "\x19" }  },
      /* --- pixel bitmap for cmr180 char#98 b --- */
      {  98, 1940,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\xc0\x00\x0c\xc0\x00\x0c\xc0\x00\xec\xc1\x21\x0c"
            "\xc6\xc0\x0c\xcc\xc0\x0c\xcc\xc0\x0c\xc6\x21\xe4\x01" }  },
      /* --- pixel bitmap for cmr180 char#99 c --- */
      {  99, 2003,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x78\xc4\x06\x03\x03\x03\x03\x03\x86\x44\x38" }  },
      /* --- pixel bitmap for cmr180 char#100 d --- */
      { 100, 2038,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x03\x30\x00\x03\x30\x00\x03\x30\x78\x43\x38\x06"
            "\x33\x30\x03\x33\x30\x03\x33\x30\x06\x43\x38\x78\x0f" }  },
      /* --- pixel bitmap for cmr180 char#101 e --- */
      { 101, 2101,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x38\x44\xc2\xc3\xff\x03\x03\x03\x86\x44\x38" }  },
      /* --- pixel bitmap for cmr180 char#102 f --- */
      { 102, 2140,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x30\x33\x60\xc0\x80\xc1\x1f\x06\x0c\x18\x30\x60"
            "\xc0\x80\x01\x03\x06\x3f\x00" }  },
      /* --- pixel bitmap for cmr180 char#103 g --- */
      { 103, 2183,                      /* character number, location */
         11, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xbc\x9b\x39\xcc\x30\xc3\x98\xe1\x43\x00\x03\xfc\xe1"
            "\xcf\x60\x83\x0d\x36\x98\x31\x7c\x00" }  },
      /* --- pixel bitmap for cmr180 char#104 h --- */
      { 104, 2248,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\x80\x01\x30\x00\x06\xc0\x00\x18\x00\xf3\xe0\x31"
            "\x0c\x86\xc1\x30\x18\x06\xc3\x60\x18\x0c\x83\x61\x30"
            "\xbf\x1f" }  },
      /* --- pixel bitmap for cmr180 char#105 i --- */
      { 105, 2311,                      /* character number, location */
         18, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x84\x43\x00\x00\x00\x3c\x0c\xc3\x30\x0c\xc3\x30\xcc"
            "\x0f" }  },
      /* --- pixel bitmap for cmr180 char#106 j --- */
      { 106, 2348,                      /* character number, location */
         18,-2,    -5,-2,     /* topleft row,col, and botleft row,col */
          {  7,    23, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x38\x08\x00\x00\x00\xf0\x60\x30\x18\x0c\x06\x83"
            "\xc1\x60\x30\x18\x0c\x9e\x79\x00" }  },
      /* --- pixel bitmap for cmr180 char#107 k --- */
      { 107, 2397,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0f\xc0\x00\x0c\xc0\x00\x0c\xc0\x00\x8c\xc7\x18\x8c"
            "\xc0\x04\x6c\xc0\x0f\xcc\xc0\x18\x8c\xc3\x30\xbf\x0f" }  },
      /* --- pixel bitmap for cmr180 char#108 l --- */
      { 108, 2458,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    17, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x0f\xc3\x30\x0c\xc3\x30\x0c\xc3\x30\x0c\xc3\x30\x3f" }  },
      /* --- pixel bitmap for cmr180 char#109 m --- */
      { 109, 2499,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 20,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xcf\xe3\xc1\xe3\x31\x0c\x06\xc3\x60\x30\x0c\x06\xc3"
            "\x60\x30\x0c\x06\xc3\x60\x30\x0c\x06\xc3\x60\x30\x3f"
            "\x9f\x0f" }  },
      /* --- pixel bitmap for cmr180 char#110 n --- */
      { 110, 2572,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xcf\x83\xc7\x30\x18\x06\xc3\x60\x18\x0c\x83\x61\x30"
            "\x0c\x86\xc1\xfc\x7e" }  },
      /* --- pixel bitmap for cmr180 char#111 o --- */
      { 111, 2623,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x38\x8c\x09\x1a\x3c\x78\xf0\xe0\xc1\x82\x8c\xe1\x00" }  },
      /* --- pixel bitmap for cmr180 char#112 p --- */
      { 112, 2670,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xef\xc1\x21\x0c\xc6\xc0\x0c\xcc\xc0\x0c\xcc\xc0\x0c"
            "\xc6\x31\xec\xc1\x00\x0c\xc0\x00\x0c\xf0\x03" }  },
      /* --- pixel bitmap for cmr180 char#113 q --- */
      { 113, 2731,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\xc2\x38\x06\x33\x30\x03\x33\x30\x03\x33\x30\x06"
            "\x43\x38\x78\x03\x30\x00\x03\x30\x00\x03\xfc" }  },
      /* --- pixel bitmap for cmr180 char#114 r --- */
      { 114, 2792,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xef\x38\x73\x60\xc0\x80\x01\x03\x06\x0c\x18\xfc\x00" }  },
      /* --- pixel bitmap for cmr180 char#115 s --- */
      { 115, 2825,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\xe1\x70\xf0\xf1\xc1\xc3\xe1\x51\x07" }  },
      /* --- pixel bitmap for cmr180 char#116 t --- */
      { 116, 2866,                      /* character number, location */
         15, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x08\x0c\x0c\x7f\x0c\x0c\x0c\x0c\x0c\x8c\x8c\x8c"
            "\x8c\x78" }  },
      /* --- pixel bitmap for cmr180 char#117 u --- */
      { 117, 2911,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x8f\x87\xc1\x30\x18\x06\xc3\x60\x18\x0c\x83\x61\x30"
            "\x0c\x86\xe1\xc0\x7b" }  },
      /* --- pixel bitmap for cmr180 char#118 v --- */
      { 118, 2962,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xdf\x1b\xc6\x08\x23\x8c\x60\x81\x05\x16\x30\xc0\x00"
            "\x03" }  },
      /* --- pixel bitmap for cmr180 char#119 w --- */
      { 119, 3007,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xcf\x7b\xc3\x98\x61\x88\x39\xc2\x34\x61\x9a\x60\x2d"
            "\x70\x1c\x38\x0e\x18\x03\x04\x01" }  },
      /* --- pixel bitmap for cmr180 char#120 x --- */
      { 120, 3078,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x9e\xc7\x11\x98\x00\x0b\x70\x00\x06\xe0\x00\x0d\x88"
            "\xc1\x30\x9f\x0f" }  },
      /* --- pixel bitmap for cmr180 char#121 y --- */
      { 121, 3123,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xbe\x67\x18\x46\x30\x82\x11\x58\xc0\x02\x16\x60\x00"
            "\x03\x18\x40\x00\x82\x11\x4c\xc0\x01" }  },
      /* --- pixel bitmap for cmr180 char#122 z --- */
      { 122, 3182,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xff\x63\x61\x31\x30\x18\x8c\x8c\x86\xc6\xff" }  },
      /* --- pixel bitmap for cmr180 char#123 (noname) --- */
      { 123, 7064,                      /* character number, location */
          7, 0,     6, 0,     /* topleft row,col, and botleft row,col */
          { 11,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x07" }  },
      /* --- pixel bitmap for cmr180 char#124 (noname) --- */
      { 124, 7073,                      /* character number, location */
          7, 0,     6, 0,     /* topleft row,col, and botleft row,col */
          { 24,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xff\xff" }  },
      /* --- pixel bitmap for cmr180 char#125 (noname) --- */
      { 125, 6505,                      /* character number, location */
         17, 3,    13, 3,     /* topleft row,col, and botleft row,col */
          {  6,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf3\x1c\x45" }  },
      /* --- pixel bitmap for cmr180 char#126 \~ --- */
      { 126, 6528,                      /* character number, location */
         17, 2,    14, 2,     /* topleft row,col, and botleft row,col */
          {  7,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x46\x5f\x0c" }  },
      /* --- pixel bitmap for cmr180 char#127 (noname) --- */
      { 127, 6545,                      /* character number, location */
         18, 2,    15, 2,     /* topleft row,col, and botleft row,col */
          {  7,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe3\xfb\x18" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;



/* --------------------------------------------------------------------------
font sizes 0-5 for cmmi10
-------------------------------------------------------------------------- */

/* --- size=0 ---
 * mf '\mode=eighthre; input cmmi10'   gives .gf83
 * ----------------------------------------------- */
/* --- fontdef for cmmi83 --- */
static	chardef  cmmi83[] =
   {
      /* --- pixel bitmap for cmmi83 char#0 \Gamma --- */
      {   0, 1597,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\xc8\x44\x04\x04\x04\x02\x07" }  },
      /* --- pixel bitmap for cmmi83 char#1 \Delta --- */
      {   1, 1624,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x40\x60\xd0\x90\x88\x84\x86\xfe" }  },
      /* --- pixel bitmap for cmmi83 char#2 \Theta --- */
      {   2, 1657,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\xb6\x61\x14\x39" }  },
      /* --- pixel bitmap for cmmi83 char#3 \Lambda --- */
      {   3, 1694,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x18\x0c\x85\x22\x91\xee" }  },
      /* --- pixel bitmap for cmmi83 char#4 \Xi --- */
      {   4, 1727,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x09\x12\xe1\x43\x04\x40\x90\x3f" }  },
      /* --- pixel bitmap for cmmi83 char#5 \Pi --- */
      {   5, 1758,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x23\x44\x08\x21\x84\x10\x22\xc4\x39" }  },
      /* --- pixel bitmap for cmmi83 char#6 \Sigma --- */
      {   6, 1795,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x32\x0b\x81\x20\x49\x3e" }  },
      /* --- pixel bitmap for cmmi83 char#7 \Upsilon --- */
      {   7, 1826,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x57\x4b\x10\x04\x21\x1c" }  },
      /* --- pixel bitmap for cmmi83 char#8 \Phi --- */
      {   8, 1855,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\xf9\x5a\x9f\x38" }  },
      /* --- pixel bitmap for cmmi83 char#9 \Psi --- */
      {   9, 1886,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x94\xa6\xa9\x47\x38" }  },
      /* --- pixel bitmap for cmmi83 char#10 \Omega --- */
      {  10, 1921,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x70\x24\x91\x48\x24\x95\xef" }  },
      /* --- pixel bitmap for cmmi83 char#11 \alpha --- */
      {  11, 1960,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3e\xa7\x7c\x01" }  },
      /* --- pixel bitmap for cmmi83 char#12 \beta --- */
      {  12, 1985,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x29\x39\x92\xb4\x1c\x41\x00" }  },
      /* --- pixel bitmap for cmmi83 char#13 \gamma --- */
      {  13, 2022,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb2\x32\x46\x08\x01" }  },
      /* --- pixel bitmap for cmmi83 char#14 \delta --- */
      {  14, 2049,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa4\x42\x56\x59\x03" }  },
      /* --- pixel bitmap for cmmi83 char#15 \epsilon --- */
      {  15, 2082,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xce\x73" }  },
      /* --- pixel bitmap for cmmi83 char#16 \zeta --- */
      {  16, 2099,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x13\x21\x44\x10\xc4\x00" }  },
      /* --- pixel bitmap for cmmi83 char#17 \eta --- */
      {  17, 2126,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6f\xca\x94\x10\x02" }  },
      /* --- pixel bitmap for cmmi83 char#18 \theta --- */
      {  18, 2155,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xac\xfa\x5f\x35" }  },
      /* --- pixel bitmap for cmmi83 char#19 \iota --- */
      {  19, 2186,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xea\x03" }  },
      /* --- pixel bitmap for cmmi83 char#20 \kappa --- */
      {  20, 2203,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xda\xb8\x1c\x01" }  },
      /* --- pixel bitmap for cmmi83 char#21 \lambda --- */
      {  21, 2226,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c\x82\x40\x18\x25\x85" }  },
      /* --- pixel bitmap for cmmi83 char#22 \mu --- */
      {  22, 2255,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x52\xca\x7c\x43\x00" }  },
      /* --- pixel bitmap for cmmi83 char#23 \nu --- */
      {  23, 2286,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x53\xaa\x32\x00" }  },
      /* --- pixel bitmap for cmmi83 char#24 \xi --- */
      {  24, 2311,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x0b\xc1\x44\x08\xc6\x00" }  },
      /* --- pixel bitmap for cmmi83 char#25 \pi --- */
      {  25, 2338,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x18\x53\x00" }  },
      /* --- pixel bitmap for cmmi83 char#26 \rho --- */
      {  26, 2357,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\xca\x75\x42\x00" }  },
      /* --- pixel bitmap for cmmi83 char#27 \sigma --- */
      {  27, 2384,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\x14\x25\x07" }  },
      /* --- pixel bitmap for cmmi83 char#28 \tau --- */
      {  28, 2407,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbe\x10\x21\x00" }  },
      /* --- pixel bitmap for cmmi83 char#29 \upsilon --- */
      {  29, 2426,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x73\xca\x64\x00" }  },
      /* --- pixel bitmap for cmmi83 char#30 \phi --- */
      {  30, 2451,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x82\x78\x65\x59\x39\x82\x00" }  },
      /* --- pixel bitmap for cmmi83 char#31 \chi --- */
      {  31, 2490,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x42\x13\x05\xc1\x90\xc4\x00" }  },
      /* --- pixel bitmap for cmmi83 char#32 \psi --- */
      {  32, 2521,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x82\xac\xab\x59\x39\x84\x00" }  },
      /* --- pixel bitmap for cmmi83 char#33 \omega --- */
      {  33, 2562,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x63\x9a\x76\x1b" }  },
      /* --- pixel bitmap for cmmi83 char#34 \varepsilon --- */
      {  34, 2593,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x12\x06" }  },
      /* --- pixel bitmap for cmmi83 char#35 \vartheta --- */
      {  35, 2610,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\xd2\x3f\x55\x32" }  },
      /* --- pixel bitmap for cmmi83 char#36 \varpi --- */
      {  36, 2643,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x53\x52\x29\x36" }  },
      /* --- pixel bitmap for cmmi83 char#37 \varrho --- */
      {  37, 2674,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\xca\x75\xc2\x03" }  },
      /* --- pixel bitmap for cmmi83 char#38 \varsigma --- */
      {  38, 2701,                      /* character number, location */
          5, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\xa2\x01" }  },
      /* --- pixel bitmap for cmmi83 char#39 \varphi --- */
      {  39, 2720,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5a\x59\x4e\x8e\x20\x00" }  },
      /* --- pixel bitmap for cmmi83 char#40 \leftharpoonup --- */
      {  40, 3136,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x02\xff" }  },
      /* --- pixel bitmap for cmmi83 char#41 \leftharpoondown --- */
      {  41, 3149,                      /* character number, location */
          3, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x02\x04" }  },
      /* --- pixel bitmap for cmmi83 char#42 \rightharpoonup --- */
      {  42, 3162,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x40\xff" }  },
      /* --- pixel bitmap for cmmi83 char#43 \rightharpoondown --- */
      {  43, 3175,                      /* character number, location */
          3, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x40\x20" }  },
      /* --- pixel bitmap for cmmi83 char#44 ` --- */
      {  44, 3188,                      /* character number, location */
          7, 0,     2, 0,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\x02" }  },
      /* --- pixel bitmap for cmmi83 char#45 ' --- */
      {  45, 3205,                      /* character number, location */
          7, 0,     2, 0,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa9\x01" }  },
      /* --- pixel bitmap for cmmi83 char#46 \triangleright --- */
      {  46, 3222,                      /* character number, location */
          4, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf9\x00" }  },
      /* --- pixel bitmap for cmmi83 char#47 \triangleleft --- */
      {  47, 3235,                      /* character number, location */
          4, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbc\x01" }  },
      /* --- pixel bitmap for cmmi83 char#48 \0 --- */
      {  48, 2902,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\xe8\x00" }  },
      /* --- pixel bitmap for cmmi83 char#49 \1 --- */
      {  49, 2925,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x93\x74" }  },
      /* --- pixel bitmap for cmmi83 char#50 \2 --- */
      {  50, 2942,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x42\xfe\x01" }  },
      /* --- pixel bitmap for cmmi83 char#51 \3 --- */
      {  51, 2961,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x21\x06\xa3\x03" }  },
      /* --- pixel bitmap for cmmi83 char#52 \4 --- */
      {  52, 2986,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\xa9\xf5\x11\x07" }  },
      /* --- pixel bitmap for cmmi83 char#53 \5 --- */
      {  53, 3011,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x17\x71\x98\x06" }  },
      /* --- pixel bitmap for cmmi83 char#54 \6 --- */
      {  54, 3034,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\x84\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmmi83 char#55 \7 --- */
      {  55, 3059,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9f\x24\x22\x02" }  },
      /* --- pixel bitmap for cmmi83 char#56 \8 --- */
      {  56, 3082,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x29\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmmi83 char#57 \9 --- */
      {  57, 3111,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46\x0f\x91\x01" }  },
      /* --- pixel bitmap for cmmi83 char#58 . --- */
      {  58, 3248,                      /* character number, location */
          1, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmmi83 char#59 , --- */
      {  59, 3257,                      /* character number, location */
          1, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  1,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07" }  },
      /* --- pixel bitmap for cmmi83 char#60 < --- */
      {  60, 3270,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\xc4\x08\x81\xc0\x40\x20" }  },
      /* --- pixel bitmap for cmmi83 char#61 / --- */
      {  61, 3295,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x24\x25\x49\x4a\x02" }  },
      /* --- pixel bitmap for cmmi83 char#62 > --- */
      {  62, 3326,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\xc0\x40\x20\xc4\x08\x01" }  },
      /* --- pixel bitmap for cmmi83 char#63 \star --- */
      {  63, 3351,                      /* character number, location */
          3,-1,     1,-1,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x06" }  },
      /* --- pixel bitmap for cmmi83 char#64 \partial --- */
      {  64, 2753,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x42\x1f\x53\x3a" }  },
      /* --- pixel bitmap for cmmi83 char#65 A --- */
      {  65,   35,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x60\x60\x50\x50\x48\x78\x44\xe7" }  },
      /* --- pixel bitmap for cmmi83 char#66 B --- */
      {  66,   68,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\xc8\x44\x7c\x64\x44\x22\x1f" }  },
      /* --- pixel bitmap for cmmi83 char#67 C --- */
      {  67,  101,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbc\x2c\x05\x41\x94\x18" }  },
      /* --- pixel bitmap for cmmi83 char#68 D --- */
      {  68,  132,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x88\x84\x84\x84\x04\x42\x3f" }  },
      /* --- pixel bitmap for cmmi83 char#69 E --- */
      {  69,  165,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\xc8\x64\x3c\xa4\x84\x42\x7f" }  },
      /* --- pixel bitmap for cmmi83 char#70 F --- */
      {  70,  200,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\xc8\x54\x1c\x14\x04\x02\x07" }  },
      /* --- pixel bitmap for cmmi83 char#71 G --- */
      {  71,  231,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x58\xb3\x28\x10\x0f\x45\x3c" }  },
      /* --- pixel bitmap for cmmi83 char#72 H --- */
      {  72,  266,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x23\x44\x08\x3f\x84\x10\x22\xc4\x39" }  },
      /* --- pixel bitmap for cmmi83 char#73 I --- */
      {  73,  303,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x11\x42\x88\x38" }  },
      /* --- pixel bitmap for cmmi83 char#74 J --- */
      {  74,  326,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x84\x20\x08\x52\x1c" }  },
      /* --- pixel bitmap for cmmi83 char#75 K --- */
      {  75,  351,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdc\x23\x41\x02\x05\x2c\x90\x20\xc2\x39" }  },
      /* --- pixel bitmap for cmmi83 char#76 L --- */
      {  76,  390,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x04\x81\x40\x24\x8a\x7e" }  },
      /* --- pixel bitmap for cmmi83 char#77 M --- */
      {  77,  419,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,     8, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x1c\x8e\x61\x14\x43\x29\x94\x42\x25\x32\x71\x3b" }  },
      /* --- pixel bitmap for cmmi83 char#78 N --- */
      {  78,  476,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x63\x44\x09\x25\xa4\x90\x22\xc6\x11" }  },
      /* --- pixel bitmap for cmmi83 char#79 O --- */
      {  79,  523,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\x86\x61\x14\x39" }  },
      /* --- pixel bitmap for cmmi83 char#80 P --- */
      {  80,  558,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x24\x91\xc8\x23\x08\x0e" }  },
      /* --- pixel bitmap for cmmi83 char#81 Q --- */
      {  81,  587,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\x86\x61\x54\x39\x00\x02" }  },
      /* --- pixel bitmap for cmmi83 char#82 R --- */
      {  82,  628,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x88\x44\x3c\x44\x44\x22\x67" }  },
      /* --- pixel bitmap for cmmi83 char#83 S --- */
      {  83,  663,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x0a\x83\x60\x3a" }  },
      /* --- pixel bitmap for cmmi83 char#84 T --- */
      {  84,  690,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\xd2\x49\x08\x08\x08\x04\x1e" }  },
      /* --- pixel bitmap for cmmi83 char#85 U --- */
      {  85,  721,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x42\x21\x21\x21\x21\x11\x0f" }  },
      /* --- pixel bitmap for cmmi83 char#86 V --- */
      {  86,  758,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x22\x22\x12\x0a\x0a\x06\x06" }  },
      /* --- pixel bitmap for cmmi83 char#87 W --- */
      {  87,  793,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x77\x97\x89\x4c\x54\xa1\x0a\x33\x98\x41\x04" }  },
      /* --- pixel bitmap for cmmi83 char#88 X --- */
      {  88,  846,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdc\xa1\xc0\x81\x01\x03\x05\x89\x73" }  },
      /* --- pixel bitmap for cmmi83 char#89 Y --- */
      {  89,  879,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x26\x14\x14\x08\x08\x04\x0e" }  },
      /* --- pixel bitmap for cmmi83 char#90 Z --- */
      {  90,  910,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\xa5\x21\xa4\x29\x7d" }  },
      /* --- pixel bitmap for cmmi83 char#91 \flat --- */
      {  91, 3362,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x49\xd2\x76\x03" }  },
      /* --- pixel bitmap for cmmi83 char#92 \natural --- */
      {  92, 3393,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x49\xdf\xb6\x27" }  },
      /* --- pixel bitmap for cmmi83 char#93 \sharp --- */
      {  93, 3430,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6d\xdf\xb6\x2f" }  },
      /* --- pixel bitmap for cmmi83 char#94 \smile --- */
      {  94, 3473,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmmi83 char#95 \frown --- */
      {  95, 3490,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81" }  },
      /* --- pixel bitmap for cmmi83 char#96 \ell --- */
      {  96, 2784,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x33\x46\x8c\xe1" }  },
      /* --- pixel bitmap for cmmi83 char#97 a --- */
      {  97,  943,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\xd9\x0b" }  },
      /* --- pixel bitmap for cmmi83 char#98 b --- */
      {  98,  968,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x23\x71\x99\x35" }  },
      /* --- pixel bitmap for cmmi83 char#99 c --- */
      {  99,  997,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x11\x07" }  },
      /* --- pixel bitmap for cmmi83 char#100 d --- */
      { 100, 1016,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x22\x97\x52\x5b" }  },
      /* --- pixel bitmap for cmmi83 char#101 e --- */
      { 101, 1047,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x17\x07" }  },
      /* --- pixel bitmap for cmmi83 char#102 f --- */
      { 102, 1066,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\x64\x22\x22\x11" }  },
      /* --- pixel bitmap for cmmi83 char#103 g --- */
      { 103, 1093,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x59\x47\x03" }  },
      /* --- pixel bitmap for cmmi83 char#104 h --- */
      { 104, 1120,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x86\x08\x27\x65\xce" }  },
      /* --- pixel bitmap for cmmi83 char#105 i --- */
      { 105, 1151,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x02\x55\x01" }  },
      /* --- pixel bitmap for cmmi83 char#106 j --- */
      { 106, 1172,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x00\x66\x24\x22\x01" }  },
      /* --- pixel bitmap for cmmi83 char#107 k --- */
      { 107, 1197,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x86\x08\x6d\x4d\x4b" }  },
      /* --- pixel bitmap for cmmi83 char#108 l --- */
      { 108, 1228,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa6\x24\x4d" }  },
      /* --- pixel bitmap for cmmi83 char#109 m --- */
      { 109, 1251,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6f\x93\x92\xc9\xc9" }  },
      /* --- pixel bitmap for cmmi83 char#110 n --- */
      { 110, 1286,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbf\xda\x0d" }  },
      /* --- pixel bitmap for cmmi83 char#111 o --- */
      { 111, 1311,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\x74\x00" }  },
      /* --- pixel bitmap for cmmi83 char#112 p --- */
      { 112, 1334,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x49\x5a\x8e\x30\x00" }  },
      /* --- pixel bitmap for cmmi83 char#113 q --- */
      { 113, 1361,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x59\x47\x06" }  },
      /* --- pixel bitmap for cmmi83 char#114 r --- */
      { 114, 1388,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbf\x12\x01" }  },
      /* --- pixel bitmap for cmmi83 char#115 s --- */
      { 115, 1407,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xac\x46\x06" }  },
      /* --- pixel bitmap for cmmi83 char#116 t --- */
      { 116, 1426,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd4\xa5\x09" }  },
      /* --- pixel bitmap for cmmi83 char#117 u --- */
      { 117, 1447,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbb\xda\x0e" }  },
      /* --- pixel bitmap for cmmi83 char#118 v --- */
      { 118, 1472,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbb\x5a\x06" }  },
      /* --- pixel bitmap for cmmi83 char#119 w --- */
      { 119, 1497,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xcb\xa5\xb2\xe4\x01" }  },
      /* --- pixel bitmap for cmmi83 char#120 x --- */
      { 120, 1530,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xce\x92\xf5\x00" }  },
      /* --- pixel bitmap for cmmi83 char#121 y --- */
      { 121, 1551,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbb\x5a\x46\x03" }  },
      /* --- pixel bitmap for cmmi83 char#122 z --- */
      { 122, 1580,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6e\x64\x07" }  },
      /* --- pixel bitmap for cmmi83 char#123 \imath --- */
      { 123, 2807,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmmi83 char#124 \jmath --- */
      { 124, 2824,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x36\x25\x05" }  },
      /* --- pixel bitmap for cmmi83 char#125 \wp --- */
      { 125, 2845,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\xa3\x50\xd4\x29\x08\x00" }  },
      /* --- pixel bitmap for cmmi83 char#126 \vec --- */
      { 126, 2876,                      /* character number, location */
          9, 2,     6, 2,     /* topleft row,col, and botleft row,col */
          {  5,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe8\x23" }  },
      /* --- pixel bitmap for cmmi83 char#127 (noname) --- */
      { 127, 2889,                      /* character number, location */
          8, 3,     6, 3,     /* topleft row,col, and botleft row,col */
          {  3,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2b" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=1 ---
 * mf '\mode=nextscrn; input cmmi10'   gives .gf100
 * ------------------------------------------------ */
/* --- fontdef for cmmi100 --- */
static	chardef  cmmi100[] =
   {
      /* --- pixel bitmap for cmmi100 char#0 \Gamma --- */
      {   0, 1841,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x88\x88\x44\x04\x04\x04\x02\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#1 \Delta --- */
      {   1, 1872,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x40\x40\x41\x82\x84\x88\xa0\x41\x81\xff\x01" }  },
      /* --- pixel bitmap for cmmi100 char#2 \Theta --- */
      {   2, 1911,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x84\x82\x81\x99\x81\x41\x23\x1e" }  },
      /* --- pixel bitmap for cmmi100 char#3 \Lambda --- */
      {   3, 1952,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x30\x30\x28\x28\x64\x44\x42\xf7" }  },
      /* --- pixel bitmap for cmmi100 char#4 \Xi --- */
      {   4, 1989,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xf8\x11\x02\x40\x82\x07\x09\x80\x40\xff\x00" }  },
      /* --- pixel bitmap for cmmi100 char#5 \Pi --- */
      {   5, 2022,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfc\x11\x21\x22\x42\x84\x08\x11\x11\x77\x00" }  },
      /* --- pixel bitmap for cmmi100 char#6 \Sigma --- */
      {   6, 2063,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfc\x19\x23\xc4\x04\x01\x11\x21\x23\x7f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#7 \Upsilon --- */
      {   7, 2100,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6e\x99\x18\x08\x08\x08\x08\x04\x1f" }  },
      /* --- pixel bitmap for cmmi100 char#8 \Phi --- */
      {   8, 2131,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x08\x4f\x99\x4c\x7b\x08\x1e" }  },
      /* --- pixel bitmap for cmmi100 char#9 \Psi --- */
      {   9, 2168,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x10\xd1\x29\x29\x3b\x1e\x04\x1f" }  },
      /* --- pixel bitmap for cmmi100 char#10 \Omega --- */
      {  10, 2207,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xf0\x18\x11\x14\x24\x88\x08\x89\x32\x77\x00" }  },
      /* --- pixel bitmap for cmmi100 char#11 \alpha --- */
      {  11, 2250,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x1c\x47\x99\x09" }  },
      /* --- pixel bitmap for cmmi100 char#12 \beta --- */
      {  12, 2279,                      /* character number, location */
         10,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x60\x90\x88\x48\x3c\x44\x44\x44\x26\x1a\x02\x02\x01" }  },
      /* --- pixel bitmap for cmmi100 char#13 \gamma --- */
      {  13, 2328,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6e\x1a\xc3\x10\x04\x41\x08" }  },
      /* --- pixel bitmap for cmmi100 char#14 \delta --- */
      {  14, 2361,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x10\xc2\x54\x4a\xc5\x00" }  },
      /* --- pixel bitmap for cmmi100 char#15 \epsilon --- */
      {  15, 2396,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x1f\xe1" }  },
      /* --- pixel bitmap for cmmi100 char#16 \zeta --- */
      {  16, 2415,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x13\x21\x42\x08\x61\x18\x64\x00" }  },
      /* --- pixel bitmap for cmmi100 char#17 \eta --- */
      {  17, 2448,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdb\x29\x8a\x51\x04\x41\x08" }  },
      /* --- pixel bitmap for cmmi100 char#18 \theta --- */
      {  18, 2485,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x25\x8a\xdf\x17\x25\x89\x01" }  },
      /* --- pixel bitmap for cmmi100 char#19 \iota --- */
      {  19, 2524,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x92\xd4\x01" }  },
      /* --- pixel bitmap for cmmi100 char#20 \kappa --- */
      {  20, 2545,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb2\xe2\x48\x71\x08" }  },
      /* --- pixel bitmap for cmmi100 char#21 \lambda --- */
      {  21, 2574,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x06\x82\x20\x08\x42\x49\x52\x0c" }  },
      /* --- pixel bitmap for cmmi100 char#22 \mu --- */
      {  22, 2609,                      /* character number, location */
          6,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x22\x91\x68\xf6\x0a\x04\x01" }  },
      /* --- pixel bitmap for cmmi100 char#23 \nu --- */
      {  23, 2646,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x53\x4a\x55\x06" }  },
      /* --- pixel bitmap for cmmi100 char#24 \xi --- */
      {  24, 2675,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x13\x42\x98\x10\x41\x38\xc4\x00" }  },
      /* --- pixel bitmap for cmmi100 char#25 \pi --- */
      {  25, 2708,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x0a\x85\x22\x91\x00" }  },
      /* --- pixel bitmap for cmmi100 char#26 \rho --- */
      {  26, 2739,                      /* character number, location */
          6,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x24\x91\x68\xd2\x08\x04\x01" }  },
      /* --- pixel bitmap for cmmi100 char#27 \sigma --- */
      {  27, 2774,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\x92\x24\xc5\x00" }  },
      /* --- pixel bitmap for cmmi100 char#28 \tau --- */
      {  28, 2801,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\x41\x10\x82\x00" }  },
      /* --- pixel bitmap for cmmi100 char#29 \upsilon --- */
      {  29, 2822,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe2\x28\x8a\x92\x03" }  },
      /* --- pixel bitmap for cmmi100 char#30 \phi --- */
      {  30, 2851,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x10\x08\x04\xc2\x53\x26\x93\x25\x0f\x81\x20\x00" }  },
      /* --- pixel bitmap for cmmi100 char#31 \chi --- */
      {  31, 2900,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x86\x46\x28\x18\x08\x18\x14\x22\x21" }  },
      /* --- pixel bitmap for cmmi100 char#32 \psi --- */
      {  32, 2937,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x20\x08\x04\x22\x5d\x2a\x55\x2a\x0f\x81\x40\x00" }  },
      /* --- pixel bitmap for cmmi100 char#33 \omega --- */
      {  33, 2990,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc2\x60\x32\xd9\xda\x00" }  },
      /* --- pixel bitmap for cmmi100 char#34 \varepsilon --- */
      {  34, 3027,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x26\xe9" }  },
      /* --- pixel bitmap for cmmi100 char#35 \vartheta --- */
      {  35, 3048,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x14\x12\x39\x1b\x89\x24\x12\x07" }  },
      /* --- pixel bitmap for cmmi100 char#36 \varpi --- */
      {  36, 3091,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x17\x24\x92\x4c\xb2\xb8\x01" }  },
      /* --- pixel bitmap for cmmi100 char#37 \varrho --- */
      {  37, 3128,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x29\x8a\x53\x13\x04\x06" }  },
      /* --- pixel bitmap for cmmi100 char#38 \varsigma --- */
      {  38, 3163,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x22\x0a" }  },
      /* --- pixel bitmap for cmmi100 char#39 \varphi --- */
      {  39, 3184,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb2\x64\x32\x59\xf2\x10\x08\x02" }  },
      /* --- pixel bitmap for cmmi100 char#40 \leftharpoonup --- */
      {  40, 3702,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 11,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x20\x80\x00\xfe\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#41 \leftharpoondown --- */
      {  41, 3717,                      /* character number, location */
          4, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x17\x00\x01\x08\x00" }  },
      /* --- pixel bitmap for cmmi100 char#42 \rightharpoonup --- */
      {  42, 3732,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 11,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x00\x01\x08\x80\xfe\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#43 \rightharpoondown --- */
      {  43, 3747,                      /* character number, location */
          4, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x07\x10\x40\x00\x02" }  },
      /* --- pixel bitmap for cmmi100 char#44 ` --- */
      {  44, 3762,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmmi100 char#45 ' --- */
      {  45, 3779,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmmi100 char#46 \triangleright --- */
      {  46, 3796,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x71\x79\x01" }  },
      /* --- pixel bitmap for cmmi100 char#47 \triangleleft --- */
      {  47, 3815,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe8\xe9\x08" }  },
      /* --- pixel bitmap for cmmi100 char#48 \0 --- */
      {  48, 3412,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x18\x86\xa1\x07" }  },
      /* --- pixel bitmap for cmmi100 char#49 \1 --- */
      {  49, 3439,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x74\x44\xe4" }  },
      /* --- pixel bitmap for cmmi100 char#50 \2 --- */
      {  50, 3458,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x48\xfa" }  },
      /* --- pixel bitmap for cmmi100 char#51 \3 --- */
      {  51, 3481,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x26\x21\xe4\x60\x8c\x0e" }  },
      /* --- pixel bitmap for cmmi100 char#52 \4 --- */
      {  52, 3512,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x46\x49\xd3\x0f\x41\x38" }  },
      /* --- pixel bitmap for cmmi100 char#53 \5 --- */
      {  53, 3543,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x71\x89\x99\x06" }  },
      /* --- pixel bitmap for cmmi100 char#54 \6 --- */
      {  54, 3574,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x71\x99\x99\x06" }  },
      /* --- pixel bitmap for cmmi100 char#55 \7 --- */
      {  55, 3607,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x22\x42\x84\x10\x02" }  },
      /* --- pixel bitmap for cmmi100 char#56 \8 --- */
      {  56, 3634,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x69\x96\x99\x06" }  },
      /* --- pixel bitmap for cmmi100 char#57 \9 --- */
      {  57, 3669,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x99\xe9\x48\x03" }  },
      /* --- pixel bitmap for cmmi100 char#58 . --- */
      {  58, 3834,                      /* character number, location */
          1, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmmi100 char#59 , --- */
      {  59, 3843,                      /* character number, location */
          1, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#60 < --- */
      {  60, 3858,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x80\x60\x18\x06\x01\x06\x18\x60\x80" }  },
      /* --- pixel bitmap for cmmi100 char#61 / --- */
      {  61, 3883,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x48\x44\x22\x22\x11\x01" }  },
      /* --- pixel bitmap for cmmi100 char#62 > --- */
      {  62, 3916,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01\x06\x18\x60\x80\x60\x18\x06\x01" }  },
      /* --- pixel bitmap for cmmi100 char#63 \star --- */
      {  63, 3941,                      /* character number, location */
          4,-1,     2,-1,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x06" }  },
      /* --- pixel bitmap for cmmi100 char#64 \partial --- */
      {  64, 3227,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\x42\xc8\x65\x4c\xc9\x00" }  },
      /* --- pixel bitmap for cmmi100 char#65 A --- */
      {  65,   35,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x40\xc0\x80\x81\x02\x05\x0f\x22\x42\xef\x01" }  },
      /* --- pixel bitmap for cmmi100 char#66 B --- */
      {  66,   70,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfc\x10\x22\x24\xc4\x87\x10\x21\x21\x3f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#67 C --- */
      {  67,  107,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\xc4\x82\x01\x01\x01\x41\x21\x1e" }  },
      /* --- pixel bitmap for cmmi100 char#68 D --- */
      {  68,  140,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfc\x10\x22\x24\x48\x90\x20\x21\x21\x3f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#69 E --- */
      {  69,  179,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfc\x11\x23\x26\xc6\x87\x28\x51\x41\xff\x00" }  },
      /* --- pixel bitmap for cmmi100 char#70 F --- */
      {  70,  220,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x88\xc8\x64\x3c\x24\x24\x02\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#71 G --- */
      {  71,  255,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x78\x09\x0b\x0c\x10\x3c\x50\x20\x21\x7c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#72 H --- */
      {  72,  294,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xdc\x11\x21\x22\xc2\x87\x08\x11\x11\x77\x00" }  },
      /* --- pixel bitmap for cmmi100 char#73 I --- */
      {  73,  335,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x21\x42\x08\x11\x07" }  },
      /* --- pixel bitmap for cmmi100 char#74 J --- */
      {  74,  360,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x70\x10\x08\x02\x81\x40\x12\x06" }  },
      /* --- pixel bitmap for cmmi100 char#75 K --- */
      {  75,  387,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xdc\x23\x83\x06\x0d\x2c\x90\x41\x84\x10\xc7\x01" }  },
      /* --- pixel bitmap for cmmi100 char#76 L --- */
      {  76,  430,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x04\x82\x40\x20\x12\x45\x3f" }  },
      /* --- pixel bitmap for cmmi100 char#77 M --- */
      {  77,  461,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x1e\xc3\x60\x14\x8a\x41\x29\x28\x05\x95\x90\x09"
            "\xbf\x07" }  },
      /* --- pixel bitmap for cmmi100 char#78 N --- */
      {  78,  522,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xcc\x31\x61\xa2\x42\x85\x0a\x11\x11\x27\x00" }  },
      /* --- pixel bitmap for cmmi100 char#79 O --- */
      {  79,  571,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x84\x82\x81\x81\x81\x41\x23\x1e" }  },
      /* --- pixel bitmap for cmmi100 char#80 P --- */
      {  80,  610,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfc\x10\x22\x24\xc4\x87\x00\x01\x01\x07\x00" }  },
      /* --- pixel bitmap for cmmi100 char#81 Q --- */
      {  81,  641,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x78\x84\x82\x81\x81\x81\x41\x2b\x1e\x00\x40\x30" }  },
      /* --- pixel bitmap for cmmi100 char#82 R --- */
      {  82,  688,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x88\x88\x44\x3c\x44\x44\x22\xc7" }  },
      /* --- pixel bitmap for cmmi100 char#83 S --- */
      {  83,  727,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x22\x81\x80\x01\x81\x22\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#84 T --- */
      {  84,  756,                      /* character number, location */
          9,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xfe\x8b\x28\x62\x44\x10\x40\x00\x01\x02\x3e\x00" }  },
      /* --- pixel bitmap for cmmi100 char#85 U --- */
      {  85,  793,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x77\x91\x28\x12\x89\x44\x12\x07" }  },
      /* --- pixel bitmap for cmmi100 char#86 V --- */
      {  86,  834,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xcf\x85\x10\x21\x41\x82\x02\x03\x06\x04\x00" }  },
      /* --- pixel bitmap for cmmi100 char#87 W --- */
      {  87,  871,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xef\x5c\x88\x88\x11\x31\x21\x25\x98\x02\x53\x20\x06"
            "\xc4\x00" }  },
      /* --- pixel bitmap for cmmi100 char#88 X --- */
      {  88,  930,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xbc\x43\x02\x0f\x18\x20\x40\x81\x04\x11\xcf\x01" }  },
      /* --- pixel bitmap for cmmi100 char#89 Y --- */
      {  89,  967,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xcf\x89\x90\xa0\x80\x01\x01\x02\x02\x0e\x00" }  },
      /* --- pixel bitmap for cmmi100 char#90 Z --- */
      {  90, 1000,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x12\x49\x82\x20\x91\x24\x1f" }  },
      /* --- pixel bitmap for cmmi100 char#91 \flat --- */
      {  91, 3952,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x55\xff\x07" }  },
      /* --- pixel bitmap for cmmi100 char#92 \natural --- */
      {  92, 3979,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\xd1\x9b\x99\xd9\x8b\x08" }  },
      /* --- pixel bitmap for cmmi100 char#93 \sharp --- */
      {  93, 4028,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  2,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmi100 char#94 \smile --- */
      {  94, 4061,                      /* character number, location */
          6, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 11,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01\x14\x10\x41\xf0\x01" }  },
      /* --- pixel bitmap for cmmi100 char#95 \frown --- */
      {  95, 4082,                      /* character number, location */
          6, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 11,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\x20\x88\x80\x02\x08" }  },
      /* --- pixel bitmap for cmmi100 char#96 \ell --- */
      {  96, 3264,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x8c\x62\x14\x43\x18\x06\x0e" }  },
      /* --- pixel bitmap for cmmi100 char#97 a --- */
      {  97, 1037,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\xc6\x98\x2d" }  },
      /* --- pixel bitmap for cmmi100 char#98 b --- */
      {  98, 1066,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x43\x08\xd1\x66\x8c\xc9\x00" }  },
      /* --- pixel bitmap for cmmi100 char#99 c --- */
      {  99, 1103,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xac\x11\x69" }  },
      /* --- pixel bitmap for cmmi100 char#100 d --- */
      { 100, 1126,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x08\x82\x9c\x14\x45\x99\x05" }  },
      /* --- pixel bitmap for cmmi100 char#101 e --- */
      { 101, 1163,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\xbe\x90\x0c" }  },
      /* --- pixel bitmap for cmmi100 char#102 f --- */
      { 102, 1186,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x04\x21\x18\x82\x20\x04\x41\x10\x03" }  },
      /* --- pixel bitmap for cmmi100 char#103 g --- */
      { 103, 1219,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x29\x8a\x12\x07\x41\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#104 h --- */
      { 104, 1252,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x06\x41\x10\x9a\x29\x8a\x71\x08" }  },
      /* --- pixel bitmap for cmmi100 char#105 i --- */
      { 105, 1291,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\xa0\x49\x1b" }  },
      /* --- pixel bitmap for cmmi100 char#106 j --- */
      { 106, 1314,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x00\x00\x18\x05\x41\x08\x82\x10\x03" }  },
      /* --- pixel bitmap for cmmi100 char#107 k --- */
      { 107, 1345,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x06\x41\x10\xb2\x6a\x28\x59\x04" }  },
      /* --- pixel bitmap for cmmi100 char#108 l --- */
      { 108, 1384,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x24\x29\x49\x13" }  },
      /* --- pixel bitmap for cmmi100 char#109 m --- */
      { 109, 1411,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9b\x9d\x29\xa2\x88\x11\x47\x08" }  },
      /* --- pixel bitmap for cmmi100 char#110 n --- */
      { 110, 1454,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdb\x29\x8a\x71\x08" }  },
      /* --- pixel bitmap for cmmi100 char#111 o --- */
      { 111, 1485,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x18\x86\x91\x03" }  },
      /* --- pixel bitmap for cmmi100 char#112 p --- */
      { 112, 1512,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x36\x27\x91\x68\xd2\x08\x04\x03" }  },
      /* --- pixel bitmap for cmmi100 char#113 q --- */
      { 113, 1549,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\xc6\x98\x1c\x42\x0e" }  },
      /* --- pixel bitmap for cmmi100 char#114 r --- */
      { 114, 1582,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfb\x0a\x11\x02" }  },
      /* --- pixel bitmap for cmmi100 char#115 s --- */
      { 115, 1605,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc8\x8c\x69" }  },
      /* --- pixel bitmap for cmmi100 char#116 t --- */
      { 116, 1626,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x24\x2f\x69\x02" }  },
      /* --- pixel bitmap for cmmi100 char#117 u --- */
      { 117, 1651,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x72\x4a\xa9\x2d" }  },
      /* --- pixel bitmap for cmmi100 char#118 v --- */
      { 118, 1682,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x72\x4a\xa9\x0c" }  },
      /* --- pixel bitmap for cmmi100 char#119 w --- */
      { 119, 1711,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x92\x93\x92\x92\x5a\x36" }  },
      /* --- pixel bitmap for cmmi100 char#120 x --- */
      { 120, 1752,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbc\x8a\x20\x95\x07" }  },
      /* --- pixel bitmap for cmmi100 char#121 y --- */
      { 121, 1779,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x72\x4a\xa9\x1c\x2a\x03" }  },
      /* --- pixel bitmap for cmmi100 char#122 z --- */
      { 122, 1816,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\x22\xa2\x1a" }  },
      /* --- pixel bitmap for cmmi100 char#123 \imath --- */
      { 123, 3295,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xae\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#124 \jmath --- */
      { 124, 3314,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xcc\x88\x44\x44\x03" }  },
      /* --- pixel bitmap for cmmi100 char#125 \wp --- */
      { 125, 3339,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x72\x8e\x82\x4a\x35\x05\x05\x02" }  },
      /* --- pixel bitmap for cmmi100 char#126 \vec --- */
      { 126, 3382,                      /* character number, location */
         10, 2,     7, 2,     /* topleft row,col, and botleft row,col */
          {  6,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd0\x0f\x01" }  },
      /* --- pixel bitmap for cmmi100 char#127 (noname) --- */
      { 127, 3395,                      /* character number, location */
         10, 3,     7, 3,     /* topleft row,col, and botleft row,col */
          {  5,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=2 ---
 * mf '\mode=lview; input cmmi10'      gives .gf118
 * ------------------------------------------------ */
/* --- fontdef for cmmi118 --- */
static	chardef  cmmi118[] =
   {
      /* --- pixel bitmap for cmmi118 char#0 \Gamma --- */
      {   0, 2071,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x23\x84\x10\x42\x04\x10\x40\x00\x01\x02\x3c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#1 \Delta --- */
      {   1, 2104,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x01\x0e\x50\x40\x04\x21\x04\x31\x88\x80\x02\xfc"
            "\x3f" }  },
      /* --- pixel bitmap for cmmi118 char#2 \Theta --- */
      {   2, 2145,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x41\x18\x81\x04\xac\xa4\x24\x05\x28\x20\xc2\xe0"
            "\x01" }  },
      /* --- pixel bitmap for cmmi118 char#3 \Lambda --- */
      {   3, 2196,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x40\xc0\x80\x81\x02\x05\x09\x13\x22\x42\xce\x03" }  },
      /* --- pixel bitmap for cmmi118 char#4 \Xi --- */
      {   4, 2237,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x27\x10\x00\x10\xc2\x0f\x42\x00\x00\x00\x81\xf8"
            "\x07" }  },
      /* --- pixel bitmap for cmmi118 char#5 \Pi --- */
      {   5, 2270,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\x8f\x20\x08\x82\x20\x04\x41\x10\x04\x41\x10\x82"
            "\xf0\x3c" }  },
      /* --- pixel bitmap for cmmi118 char#6 \Sigma --- */
      {   6, 2315,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x8f\x40\x18\x04\x41\x30\x00\x03\x18\xc2\x20\x06"
            "\xf1\x1f" }  },
      /* --- pixel bitmap for cmmi118 char#7 \Upsilon --- */
      {   7, 2354,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x9e\x47\x09\x00\x08\x10\x40\x00\x01\x04\x08\xf8\x00" }  },
      /* --- pixel bitmap for cmmi118 char#8 \Phi --- */
      {   8, 2389,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xf0\x41\xe0\x33\x29\x31\xa2\x24\x3e\x08\x7c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#9 \Psi --- */
      {   9, 2432,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\x81\x30\xb2\x48\x92\x4c\x22\x05\x0f\x08\xf8\x00" }  },
      /* --- pixel bitmap for cmmi118 char#10 \Omega --- */
      {  10, 2479,                      /* character number, location */
         10, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\x10\x2c\xa0\x80\x02\x09\x24\x88\x10\xc3\x8c\x01" }  },
      /* --- pixel bitmap for cmmi118 char#11 \alpha --- */
      {  11, 2524,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x71\x38\x1c\x8a\xb9\x01" }  },
      /* --- pixel bitmap for cmmi118 char#12 \beta --- */
      {  12, 2557,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x20\x22\xc4\x47\x88\x10\x21\x42\x46\x74\x08\x10"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmmi118 char#13 \gamma --- */
      {  13, 2606,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x52\x51\x30\x30\x30\x10\x10\x10\x08" }  },
      /* --- pixel bitmap for cmmi118 char#14 \delta --- */
      {  14, 2643,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x10\xa6\x52\x4a\xc5\x00" }  },
      /* --- pixel bitmap for cmmi118 char#15 \epsilon --- */
      {  15, 2680,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\xf1\x91\x06" }  },
      /* --- pixel bitmap for cmmi118 char#16 \zeta --- */
      {  16, 2703,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x13\x21\x42\x08\x41\x30\xe4\x00" }  },
      /* --- pixel bitmap for cmmi118 char#17 \eta --- */
      {  17, 2736,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfa\x79\x8a\x62\x14\x41\x10\x02" }  },
      /* --- pixel bitmap for cmmi118 char#18 \theta --- */
      {  18, 2777,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x4a\xf9\x5e\x2a\x65\x00" }  },
      /* --- pixel bitmap for cmmi118 char#19 \iota --- */
      {  19, 2816,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x94\xa4\x0a" }  },
      /* --- pixel bitmap for cmmi118 char#20 \kappa --- */
      {  20, 2839,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x64\x89\xc2\xa1\x49\xc5\x00" }  },
      /* --- pixel bitmap for cmmi118 char#21 \lambda --- */
      {  21, 2874,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c\x04\x04\x02\x81\xa1\x48\xc2\x20" }  },
      /* --- pixel bitmap for cmmi118 char#22 \mu --- */
      {  22, 2909,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x44\x44\x44\x44\xa6\x5e\x02\x02\x01" }  },
      /* --- pixel bitmap for cmmi118 char#23 \nu --- */
      {  23, 2952,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x46\x91\x48\xa2\x69\x0c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#24 \xi --- */
      {  24, 2985,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x4e\x10\x04\x27\x08\x81\xc0\x40\x1c" }  },
      /* --- pixel bitmap for cmmi118 char#25 \pi --- */
      {  25, 3018,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x2a\x28\x14\x14\x12\x22" }  },
      /* --- pixel bitmap for cmmi118 char#26 \rho --- */
      {  26, 3053,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x4a\x92\xa4\xe5\x08\x42\x00" }  },
      /* --- pixel bitmap for cmmi118 char#27 \sigma --- */
      {  27, 3090,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x49\x24\x12\x49\x18\x00" }  },
      /* --- pixel bitmap for cmmi118 char#28 \tau --- */
      {  28, 3121,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\x05\x02\x81\x20\x10\x00" }  },
      /* --- pixel bitmap for cmmi118 char#29 \upsilon --- */
      {  29, 3144,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc2\xe2\x50\x28\x12\x71\x00" }  },
      /* --- pixel bitmap for cmmi118 char#30 \phi --- */
      {  30, 3179,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x20\x08\x84\xe7\x4c\x26\x93\x35\x07\x81\x20\x00" }  },
      /* --- pixel bitmap for cmmi118 char#31 \chi --- */
      {  31, 3230,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x04\x22\x84\x08\x14\x30\xc0\x80\x02\x11\x42\x05\x02" }  },
      /* --- pixel bitmap for cmmi118 char#32 \psi --- */
      {  32, 3275,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x80\x80\x30\xa9\xb2\x24\x45\x4a\x54\x70\x20\x40"
            "\x80\x00" }  },
      /* --- pixel bitmap for cmmi118 char#33 \omega --- */
      {  33, 3336,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x02\x05\x46\x8c\x18\x31\x93\x19" }  },
      /* --- pixel bitmap for cmmi118 char#34 \varepsilon --- */
      {  34, 3379,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x61\x91\x07" }  },
      /* --- pixel bitmap for cmmi118 char#35 \vartheta --- */
      {  35, 3402,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x48\x48\x52\xe3\x23\x22\x12\x12\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#36 \varpi --- */
      {  36, 3447,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,     7, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfe\xaf\x40\x44\x44\x44\x64\x44\x26\xdc\x01" }  },
      /* --- pixel bitmap for cmmi118 char#37 \varrho --- */
      {  37, 3490,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x4a\x29\xd7\x09\xe1\x00" }  },
      /* --- pixel bitmap for cmmi118 char#38 \varsigma --- */
      {  38, 3527,                      /* character number, location */
          7, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x11\x42\x68" }  },
      /* --- pixel bitmap for cmmi118 char#39 \varphi --- */
      {  39, 3550,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xc2\x44\x46\x8c\x18\x49\x19\x0f\x04\x08\x08\x00" }  },
      /* --- pixel bitmap for cmmi118 char#40 \leftharpoonup --- */
      {  40, 4128,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x80\x00\x18\x80\xff\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#41 \leftharpoondown --- */
      {  41, 4143,                      /* character number, location */
          4, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xdf\x00\x10\x00\x04\x00" }  },
      /* --- pixel bitmap for cmmi118 char#42 \rightharpoonup --- */
      {  42, 4158,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x00\x02\x80\x00\xb0\xff\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#43 \rightharpoondown --- */
      {  43, 4173,                      /* character number, location */
          4, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x1f\x80\x01\x10\x00\x01" }  },
      /* --- pixel bitmap for cmmi118 char#44 ` --- */
      {  44, 4188,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\x02" }  },
      /* --- pixel bitmap for cmmi118 char#45 ' --- */
      {  45, 4205,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa9\x01" }  },
      /* --- pixel bitmap for cmmi118 char#46 \triangleright --- */
      {  46, 4222,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe1\xe4\x16\x00" }  },
      /* --- pixel bitmap for cmmi118 char#47 \triangleleft --- */
      {  47, 4243,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x90\x47\x8b\x01" }  },
      /* --- pixel bitmap for cmmi118 char#48 \0 --- */
      {  48, 3798,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\x18\xa3\x03" }  },
      /* --- pixel bitmap for cmmi118 char#49 \1 --- */
      {  49, 3829,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe4\x10\x42\xc8\x07" }  },
      /* --- pixel bitmap for cmmi118 char#50 \2 --- */
      {  50, 3850,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x42\xc8\xec\x07" }  },
      /* --- pixel bitmap for cmmi118 char#51 \3 --- */
      {  51, 3875,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46\xe8\x20\x8c\xd1\x01" }  },
      /* --- pixel bitmap for cmmi118 char#52 \4 --- */
      {  52, 3910,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x0c\x85\x22\x99\xfc\x21\x10\x1c" }  },
      /* --- pixel bitmap for cmmi118 char#53 \5 --- */
      {  53, 3945,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf1\x85\xf0\x22\x8c\xd9\x01" }  },
      /* --- pixel bitmap for cmmi118 char#54 \6 --- */
      {  54, 3980,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\xc6\xf0\x62\x8c\xd2\x01" }  },
      /* --- pixel bitmap for cmmi118 char#55 \7 --- */
      {  55, 4019,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\x08\x21\x08\x41\x10\x04\x01" }  },
      /* --- pixel bitmap for cmmi118 char#56 \8 --- */
      {  56, 4048,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\x46\xcd\x54\x8c\xd1\x01" }  },
      /* --- pixel bitmap for cmmi118 char#57 \9 --- */
      {  57, 4089,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc5\x18\x3d\x8c\xc9\x00" }  },
      /* --- pixel bitmap for cmmi118 char#58 . --- */
      {  58, 4264,                      /* character number, location */
          2, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#59 , --- */
      {  59, 4275,                      /* character number, location */
          2, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaf\x01" }  },
      /* --- pixel bitmap for cmmi118 char#60 < --- */
      {  60, 4292,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x06\x06\x06\x06\x04\x60\x00\x06\x60\x00\x06"
            "\x20" }  },
      /* --- pixel bitmap for cmmi118 char#61 / --- */
      {  61, 4321,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x22\x84\x10\x21\x44\x08\x21\x42\x00" }  },
      /* --- pixel bitmap for cmmi118 char#62 > --- */
      {  62, 4358,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x18\x80\x01\x18\x80\x01\x08\x18\x18\x18\x18\x10"
            "\x00" }  },
      /* --- pixel bitmap for cmmi118 char#63 \star --- */
      {  63, 4387,                      /* character number, location */
          4, 0,     1, 0,     /* topleft row,col, and botleft row,col */
          {  6,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x46\x02" }  },
      /* --- pixel bitmap for cmmi118 char#64 \partial --- */
      {  64, 3599,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x11\x08\xc8\x13\x85\x22\x19\x07" }  },
      /* --- pixel bitmap for cmmi118 char#65 A --- */
      {  65,   35,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xc0\x00\x03\x0a\x28\x90\x20\x82\x0f\x21\x84\x1c\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#66 B --- */
      {  66,   76,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x07\x81\x10\x08\xc1\xf8\x83\x60\x08\x84\x40\x04"
            "\xe2\x1f" }  },
      /* --- pixel bitmap for cmmi118 char#67 C --- */
      {  67,  117,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xc5\x10\x81\x04\x20\x80\x00\x04\x20\x20\x82\xe0"
            "\x03" }  },
      /* --- pixel bitmap for cmmi118 char#68 D --- */
      {  68,  154,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x03\x41\x10\x04\x81\x08\x80\x40\x08\x84\x20\x04"
            "\xe1\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#69 E --- */
      {  69,  195,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x0f\x41\x10\x05\x51\xf8\x80\x08\x88\x84\x20\x04"
            "\xe3\x1f" }  },
      /* --- pixel bitmap for cmmi118 char#70 F --- */
      {  70,  242,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\x47\x10\xa2\x10\xc5\x07\x22\x10\x81\x00\x02\x78"
            "\x00" }  },
      /* --- pixel bitmap for cmmi118 char#71 G --- */
      {  71,  283,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xc5\x10\x81\x04\x20\x80\xe0\x05\x24\x20\x82\xe0"
            "\x07" }  },
      /* --- pixel bitmap for cmmi118 char#72 H --- */
      {  72,  324,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3c\x8f\x20\x08\x82\x20\xfc\x41\x10\x04\x41\x10\x82"
            "\xf0\x3c" }  },
      /* --- pixel bitmap for cmmi118 char#73 I --- */
      {  73,  369,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x82\x20\x04\x41\x10\xc2\x03" }  },
      /* --- pixel bitmap for cmmi118 char#74 J --- */
      {  74,  396,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf0\x20\x20\x20\x10\x10\x10\x10\x09\x06" }  },
      /* --- pixel bitmap for cmmi118 char#75 K --- */
      {  75,  425,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x3e\x84\x01\x11\x40\x02\xc8\x00\x2e\x80\x18\x20"
            "\x04\x04\xc1\xe7\x01" }  },
      /* --- pixel bitmap for cmmi118 char#76 L --- */
      {  76,  472,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x78\x20\x40\x80\x80\x00\x01\x42\x84\x84\xfc\x01" }  },
      /* --- pixel bitmap for cmmi118 char#77 M --- */
      {  77,  505,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x70\x0c\x0c\x0a\x06\x85\x42\xa2\x20\x51\x90\x24"
            "\x48\x11\xa2\x84\x37\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#78 N --- */
      {  78,  580,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x8f\x21\x28\x82\x22\x24\x41\x14\x44\x41\x14\x82"
            "\xf0\x08" }  },
      /* --- pixel bitmap for cmmi118 char#79 O --- */
      {  79,  639,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x41\x18\x81\x04\x08\xa0\x00\x05\x68\x20\xc2\xe0"
            "\x01" }  },
      /* --- pixel bitmap for cmmi118 char#80 P --- */
      {  80,  680,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x21\x88\x20\x82\x04\xf1\x43\x00\x01\x02\x3c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#81 Q --- */
      {  81,  715,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x41\x18\x81\x04\x2c\xa0\x00\x05\x28\x20\xda\xe0"
            "\x01\x08\x40\x00\x0c" }  },
      /* --- pixel bitmap for cmmi118 char#82 R --- */
      {  82,  766,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x21\x88\x20\x42\xfc\x10\x42\x08\x21\x42\x3c\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#83 S --- */
      {  83,  809,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xf0\x11\x11\x20\x80\x01\x0c\x10\x20\x21\x3e\x00" }  },
      /* --- pixel bitmap for cmmi118 char#84 T --- */
      {  84,  840,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfe\x4f\x14\x51\x44\x08\x20\x80\x00\x02\x04\x7c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#85 U --- */
      {  85,  879,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xcf\x0b\x22\x88\x20\x41\x04\x11\x44\x10\x21\x38\x00" }  },
      /* --- pixel bitmap for cmmi118 char#86 V --- */
      {  86,  924,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x8f\x0b\x22\x88\x10\x26\x90\x40\x01\x05\x0c\x10\x00" }  },
      /* --- pixel bitmap for cmmi118 char#87 W --- */
      {  87,  967,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xcf\x7b\x61\x88\x30\x44\x14\x21\x8a\x90\x24\x28\x14"
            "\x14\x06\x06\x01\x83\x00" }  },
      /* --- pixel bitmap for cmmi118 char#88 X --- */
      {  88, 1038,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x1e\x44\x80\x04\x60\x00\x0c\x80\x01\x28\x80\x0c"
            "\x08\xe1\xf1\x00" }  },
      /* --- pixel bitmap for cmmi118 char#89 Y --- */
      {  89, 1079,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x87\x37\x04\x11\x48\x80\x01\x04\x20\x00\x01\x04\xf0"
            "\x00" }  },
      /* --- pixel bitmap for cmmi118 char#90 Z --- */
      {  90, 1114,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf8\x33\x44\x08\x11\x20\x40\x82\x08\x31\x42\xfc\x01" }  },
      /* --- pixel bitmap for cmmi118 char#91 \flat --- */
      {  91, 4402,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x49\xd2\xb6\x5f\x00" }  },
      /* --- pixel bitmap for cmmi118 char#92 \natural --- */
      {  92, 4439,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x21\xe4\x19\x63\x8c\x31\x4f\x08\x01" }  },
      /* --- pixel bitmap for cmmi118 char#93 \sharp --- */
      {  93, 4490,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6d\xdb\xb6\x6d\x5b" }  },
      /* --- pixel bitmap for cmmi118 char#94 \smile --- */
      {  94, 4549,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 13,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01\xd0\x80\xe1\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#95 \frown --- */
      {  95, 4566,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 13,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\xc3\x80\x05\x40" }  },
      /* --- pixel bitmap for cmmi118 char#96 \ell --- */
      {  96, 3636,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x8c\xa2\x14\x43\x18\x06\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#97 a --- */
      {  97, 1155,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xac\x14\x45\x51\x6a\x01" }  },
      /* --- pixel bitmap for cmmi118 char#98 b --- */
      {  98, 1192,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x27\xe2\x9b\x99\x35" }  },
      /* --- pixel bitmap for cmmi118 char#99 c --- */
      {  99, 1229,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xac\x11\x91\x06" }  },
      /* --- pixel bitmap for cmmi118 char#100 d --- */
      { 100, 1254,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x70\x10\x88\x25\x89\x44\x22\x29\x0b" }  },
      /* --- pixel bitmap for cmmi118 char#101 e --- */
      { 101, 1297,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xac\x79\x91\x06" }  },
      /* --- pixel bitmap for cmmi118 char#102 f --- */
      { 102, 1324,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xe0\x20\x10\x38\x10\x10\x08\x08\x08\x08\x08\x04\x07" }  },
      /* --- pixel bitmap for cmmi118 char#103 g --- */
      { 103, 1357,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x70\x14\x89\x44\xa2\x70\x20\x98\x07" }  },
      /* --- pixel bitmap for cmmi118 char#104 h --- */
      { 104, 1394,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e\x41\xf0\xa6\x29\x8a\x71\x08" }  },
      /* --- pixel bitmap for cmmi118 char#105 i --- */
      { 105, 1433,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x00\x66\x25\x62\x06" }  },
      /* --- pixel bitmap for cmmi118 char#106 j --- */
      { 106, 1460,                      /* character number, location */
         11, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    14, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x20\x00\x00\x18\x46\x41\x10\x82\x20\xc4\x01" }  },
      /* --- pixel bitmap for cmmi118 char#107 k --- */
      { 107, 1493,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e\x41\xd0\xaa\x61\x28\x55\x06" }  },
      /* --- pixel bitmap for cmmi118 char#108 l --- */
      { 108, 1534,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x44\x22\x22\x25" }  },
      /* --- pixel bitmap for cmmi118 char#109 m --- */
      { 109, 1563,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,     7, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x76\xd7\x4c\xcd\x44\x44\x44\x24\xa2\x22\x04" }  },
      /* --- pixel bitmap for cmmi118 char#110 n --- */
      { 110, 1618,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf2\xe7\x51\x28\x0c\x07\x01" }  },
      /* --- pixel bitmap for cmmi118 char#111 o --- */
      { 111, 1653,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4c\xc6\x18\x93\x01" }  },
      /* --- pixel bitmap for cmmi118 char#112 p --- */
      { 112, 1684,                      /* character number, location */
          7,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x68\x9c\x8c\x88\x88\x4c\x34\x04\x04\x07" }  },
      /* --- pixel bitmap for cmmi118 char#113 q --- */
      { 113, 1725,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\xa5\x94\xca\x21\xe4\x00" }  },
      /* --- pixel bitmap for cmmi118 char#114 r --- */
      { 114, 1762,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb6\x5b\x10\x84\x20\x00" }  },
      /* --- pixel bitmap for cmmi118 char#115 s --- */
      { 115, 1789,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x46\x60\x60\xe4\x00" }  },
      /* --- pixel bitmap for cmmi118 char#116 t --- */
      { 116, 1812,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x2f\x22\x52\x06" }  },
      /* --- pixel bitmap for cmmi118 char#117 u --- */
      { 117, 1839,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x46\x55\x89\x44\xa2\xb2\x01" }  },
      /* --- pixel bitmap for cmmi118 char#118 v --- */
      { 118, 1880,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x62\x39\x8a\xa2\xc4\x00" }  },
      /* --- pixel bitmap for cmmi118 char#119 w --- */
      { 119, 1915,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x46\xaa\x58\x22\x89\x24\xd2\xc4\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#120 x --- */
      { 120, 1966,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\xae\x02\x81\x68\x79\x00" }  },
      /* --- pixel bitmap for cmmi118 char#121 y --- */
      { 121, 1995,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x46\x55\x89\x44\xa2\x70\x20\x0a\x03" }  },
      /* --- pixel bitmap for cmmi118 char#122 z --- */
      { 122, 2040,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\x1a\x04\x41\xb2\x64\x00" }  },
      /* --- pixel bitmap for cmmi118 char#123 \imath --- */
      { 123, 3669,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x76\x25\x1b" }  },
      /* --- pixel bitmap for cmmi118 char#124 \jmath --- */
      { 124, 3692,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x53\x08\x11\x42\xe4\x00" }  },
      /* --- pixel bitmap for cmmi118 char#125 \wp --- */
      { 125, 3721,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x72\x89\x85\x83\x4a\x35\x05\x05\x03" }  },
      /* --- pixel bitmap for cmmi118 char#126 \vec --- */
      { 126, 3772,                      /* character number, location */
         11, 3,     8, 3,     /* topleft row,col, and botleft row,col */
          {  7,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa0\x3f\x04" }  },
      /* --- pixel bitmap for cmmi118 char#127 (noname) --- */
      { 127, 3785,                      /* character number, location */
         10, 4,     8, 4,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x08" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=3 ---
 * mf '\mode=onetz; mag=magstep(.5); input cmmi10'   gives .gf131
 * -------------------------------------------------------------- */
/* --- fontdef for cmmi131 --- */
static	chardef  cmmi131[] =
   {
      /* --- pixel bitmap for cmmi131 char#0 \Gamma --- */
      {   0, 2447,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x0f\xc6\x30\x04\x43\x30\x04\x03\x18\x80\x01\x18"
            "\x80\x01\x0c\xf0\x03" }  },
      /* --- pixel bitmap for cmmi131 char#1 \Delta --- */
      {   1, 2486,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x03\x38\x80\x03\x34\x20\x07\x63\x10\x86\x60\x04"
            "\x46\xc0\xfe\xff\xff" }  },
      /* --- pixel bitmap for cmmi131 char#2 \Theta --- */
      {   2, 2531,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x03\x61\x0c\x44\xc0\xa6\x6c\xce\x73\x36\x65\x03"
            "\x22\x30\x86\xc1\x07" }  },
      /* --- pixel bitmap for cmmi131 char#3 \Lambda --- */
      {   3, 2594,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x01\x0c\x70\x80\x03\x1a\xc8\x40\x06\x31\x88\x21"
            "\x0c\x61\xde\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#4 \Xi --- */
      {   4, 2641,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x8f\xff\x04\x44\x40\x08\x82\x3f\xfc\x41\x10\x02"
            "\x22\x20\xff\xf1\x1f" }  },
      /* --- pixel bitmap for cmmi131 char#5 \Pi --- */
      {   5, 2684,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xff\x60\x30\x30\x18\x30\x18\x30\x18\x30\x18\x18"
            "\x0c\x18\x0c\x18\x0c\x18\x0c\x0c\x06\xbf\x1f" }  },
      /* --- pixel bitmap for cmmi131 char#6 \Sigma --- */
      {   6, 2737,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x1f\x03\xe3\x20\x18\x04\x87\xc0\x00\x18\x00\x21"
            "\x10\x04\xc1\x10\x0c\xff\x01" }  },
      /* --- pixel bitmap for cmmi131 char#7 \Upsilon --- */
      {   7, 2784,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x8e\x7f\x0f\x07\x0c\x30\xc0\x80\x01\x06\x18\x60\xc0"
            "\xc0\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#8 \Phi --- */
      {   8, 2819,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x03\x06\x18\xf0\x43\x36\x33\xcf\xcc\x26\xfc\x80"
            "\x01\x06\xfc\x00" }  },
      /* --- pixel bitmap for cmmi131 char#9 \Psi --- */
      {   9, 2866,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x03\xc6\x99\xcd\x66\x36\xb3\xd9\xc6\x1e\x7c\x80"
            "\x01\x06\xfc\x00" }  },
      /* --- pixel bitmap for cmmi131 char#10 \Omega --- */
      {  10, 2919,                      /* character number, location */
         12, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xc1\x38\x83\x0d\x6c\x60\x83\x19\xcc\x30\x85\x2a"
            "\xca\x71\xce\x01" }  },
      /* --- pixel bitmap for cmmi131 char#11 \alpha --- */
      {  11, 2980,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x4c\x0a\x0b\x16\x24\x48\x1c\x67" }  },
      /* --- pixel bitmap for cmmi131 char#12 \beta --- */
      {  12, 3019,                      /* character number, location */
         13, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x81\x04\x21\x44\x08\xe1\x83\x10\x41\x04\x11\x44"
            "\x88\x31\x3a\x08\x20\x40\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmi131 char#13 \gamma --- */
      {  13, 3082,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x65\x85\x02\x05\x06\x0c\x18\x10\x20\x40\x40\x80"
            "\x00" }  },
      /* --- pixel bitmap for cmmi131 char#14 \delta --- */
      {  14, 3125,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x41\x10\x08\x23\x49\x51\x14\x25\x06" }  },
      /* --- pixel bitmap for cmmi131 char#15 \epsilon --- */
      {  15, 3170,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\x88\x17\x42\x74" }  },
      /* --- pixel bitmap for cmmi131 char#16 \zeta --- */
      {  16, 3195,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x08\x1c\x41\x10\x08\x02\x81\x40\x20\x60\xc0\x40"
            "\x20\x0c" }  },
      /* --- pixel bitmap for cmmi131 char#17 \eta --- */
      {  17, 3236,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x76\x65\x93\x48\x24\x8a\x44\x20\x10\x04\x02" }  },
      /* --- pixel bitmap for cmmi131 char#18 \theta --- */
      {  18, 3287,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x4a\x92\xa2\xe8\x47\x51\x94\x24\x06" }  },
      /* --- pixel bitmap for cmmi131 char#19 \iota --- */
      {  19, 3340,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x22\x92\x25" }  },
      /* --- pixel bitmap for cmmi131 char#20 \kappa --- */
      {  20, 3367,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc4\x24\x1a\x0e\x12\xa2\x61\x61" }  },
      /* --- pixel bitmap for cmmi131 char#21 \lambda --- */
      {  21, 3406,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x0c\x10\x10\x10\x20\x20\x20\x60\x50\x48\x44\x82\x81" }  },
      /* --- pixel bitmap for cmmi131 char#22 \mu --- */
      {  22, 3449,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x88\x10\x11\x21\x42\x84\xac\x29\x6f\x02\x04\x04\x08"
            "\x00" }  },
      /* --- pixel bitmap for cmmi131 char#23 \nu --- */
      {  23, 3500,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x87\x84\x42\x42\x22\x12\x0d\x03" }  },
      /* --- pixel bitmap for cmmi131 char#24 \xi --- */
      {  24, 3537,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x08\x9e\x20\x10\xf0\x04\x81\x40\x20\x10\x30\x60"
            "\x20\x0c" }  },
      /* --- pixel bitmap for cmmi131 char#25 \pi --- */
      {  25, 3578,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x95\xa4\x40\x41\x82\x04\x09\x11" }  },
      /* --- pixel bitmap for cmmi131 char#26 \rho --- */
      {  26, 3619,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x30\x24\x92\x48\x24\x99\x34\x02\x41\x20\x00" }  },
      /* --- pixel bitmap for cmmi131 char#27 \sigma --- */
      {  27, 3664,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x22\x22\x21\x21\x11\x11\x0e" }  },
      /* --- pixel bitmap for cmmi131 char#28 \tau --- */
      {  28, 3699,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x12\x09\x08\x08\x08\x04\x04" }  },
      /* --- pixel bitmap for cmmi131 char#29 \upsilon --- */
      {  29, 3726,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x8a\x89\x84\x84\x44\x64\x18" }  },
      /* --- pixel bitmap for cmmi131 char#30 \phi --- */
      {  30, 3767,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x20\x20\x20\x20\x78\x94\x92\x91\x89\x49\x29\x1e"
            "\x04\x04\x04\x04" }  },
      /* --- pixel bitmap for cmmi131 char#31 \chi --- */
      {  31, 3832,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0c\x64\x10\x44\x20\x01\x05\x10\x80\x00\x0a\x48\x20"
            "\x82\x60\x02\x03" }  },
      /* --- pixel bitmap for cmmi131 char#32 \psi --- */
      {  32, 3883,                      /* character number, location */
         13, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x00\x02\x08\x10\x40\x10\xa9\x64\x8a\x24\x92\x48"
            "\x12\x25\x78\x40\x00\x01\x02\x08\x00" }  },
      /* --- pixel bitmap for cmmi131 char#33 \omega --- */
      {  33, 3956,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x06\x0a\x18\x62\x88\x21\xc6\x9c\x93\x33" }  },
      /* --- pixel bitmap for cmmi131 char#34 \varepsilon --- */
      {  34, 4005,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\x04\x17\x42\x74" }  },
      /* --- pixel bitmap for cmmi131 char#35 \vartheta --- */
      {  35, 4030,                      /* character number, location */
         13, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x60\x90\x90\x90\x90\xa6\xca\x45\x44\x44\x24\x24\x1c" }  },
      /* --- pixel bitmap for cmmi131 char#36 \varpi --- */
      {  36, 4091,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,     8, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xbf\x02\x94\x00\x11\x42\x84\x10\x31\x42\x4a\x60"
            "\x0c" }  },
      /* --- pixel bitmap for cmmi131 char#37 \varrho --- */
      {  37, 4142,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x49\x8a\xa2\x34\x35\x41\x10\x3c" }  },
      /* --- pixel bitmap for cmmi131 char#38 \varsigma --- */
      {  38, 4187,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\x84\x10\x04\x41\x90\x01" }  },
      /* --- pixel bitmap for cmmi131 char#39 \varphi --- */
      {  39, 4214,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x84\x89\x19\x62\x84\x11\x46\xa4\x08\x1f\x08\x20\x40"
            "\x00\x01" }  },
      /* --- pixel bitmap for cmmi131 char#40 \leftharpoonup --- */
      {  40, 4898,                      /* character number, location */
          9, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 15,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x00\x04\x00\x01\xc0\x00\xf0\xff\x07" }  },
      /* --- pixel bitmap for cmmi131 char#41 \leftharpoondown --- */
      {  41, 4915,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x7f\x03\x00\x01\x00\x01\x80\x00\x00" }  },
      /* --- pixel bitmap for cmmi131 char#42 \rightharpoonup --- */
      {  42, 4932,                      /* character number, location */
          9, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 15,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x00\x08\x00\x04\x00\x04\x00\xf6\xff\x07" }  },
      /* --- pixel bitmap for cmmi131 char#43 \rightharpoondown --- */
      {  43, 4949,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x7f\x00\x18\x00\x04\x00\x01\x80\x00" }  },
      /* --- pixel bitmap for cmmi131 char#44 ` --- */
      {  44, 4966,                      /* character number, location */
          9, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\x02" }  },
      /* --- pixel bitmap for cmmi131 char#45 ' --- */
      {  45, 4983,                      /* character number, location */
          9, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa9\x01" }  },
      /* --- pixel bitmap for cmmi131 char#46 \triangleright --- */
      {  46, 5000,                      /* character number, location */
          8, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc1\x91\x85\xd9\x11\x00" }  },
      /* --- pixel bitmap for cmmi131 char#47 \triangleleft --- */
      {  47, 5027,                      /* character number, location */
          8, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x6e\x86\x26\x0e\x02" }  },
      /* --- pixel bitmap for cmmi131 char#48 \0 --- */
      {  48, 4516,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x18\x86\x61\x38\x7b" }  },
      /* --- pixel bitmap for cmmi131 char#49 \1 --- */
      {  49, 4551,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe4\x10\x42\x08\xf9" }  },
      /* --- pixel bitmap for cmmi131 char#50 \2 --- */
      {  50, 4574,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x1c\xc2\x10\xeb\xff" }  },
      /* --- pixel bitmap for cmmi131 char#51 \3 --- */
      {  51, 4603,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x1c\xc3\x10\x03\xc1\xf0\x1c\x39" }  },
      /* --- pixel bitmap for cmmi131 char#52 \4 --- */
      {  52, 4642,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x30\x30\x28\x2c\x24\x22\x23\xff\x20\x20\x20\xf8" }  },
      /* --- pixel bitmap for cmmi131 char#53 \5 --- */
      {  53, 4683,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe1\xd7\x04\xc1\x33\xc1\x70\x1c\x39" }  },
      /* --- pixel bitmap for cmmi131 char#54 \6 --- */
      {  54, 4724,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\x04\xcd\x14\x86\x61\x28\x31" }  },
      /* --- pixel bitmap for cmmi131 char#55 \7 --- */
      {  55, 4771,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x81\x7f\x30\x04\x81\x20\x10\x08\x02\x81\x40\x00" }  },
      /* --- pixel bitmap for cmmi131 char#56 \8 --- */
      {  56, 4808,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x18\x8e\x97\xa3\xc5\x61\x28\x30" }  },
      /* --- pixel bitmap for cmmi131 char#57 \9 --- */
      {  57, 4853,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\xa1\xcc\x82\x20\x14\x39" }  },
      /* --- pixel bitmap for cmmi131 char#58 . --- */
      {  58, 5054,                      /* character number, location */
          2, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#59 , --- */
      {  59, 5065,                      /* character number, location */
          2, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaf\x06" }  },
      /* --- pixel bitmap for cmmi131 char#60 < --- */
      {  60, 5084,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x06\x0c\x18\x30\x60\x80\x00\x18\x00\x03\x60\x00"
            "\x0c\x80\x01" }  },
      /* --- pixel bitmap for cmmi131 char#61 / --- */
      {  61, 5113,                      /* character number, location */
         14, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  6,    19, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x08\x41\x10\x84\x20\x08\x41\x10\x84\x20\x08\x42"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmmi131 char#62 > --- */
      {  62, 5158,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x03\x60\x00\x0c\x80\x01\x30\x00\x02\x0c\x18\x30\x60"
            "\xc0\x00\x00" }  },
      /* --- pixel bitmap for cmmi131 char#63 \star --- */
      {  63, 5187,                      /* character number, location */
          5,-1,     3,-1,     /* topleft row,col, and botleft row,col */
          {  7,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x18" }  },
      /* --- pixel bitmap for cmmi131 char#64 \partial --- */
      {  64, 4271,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x38\x44\x80\x80\x80\xb8\xc6\x42\x41\x41\x21\x11\x0e" }  },
      /* --- pixel bitmap for cmmi131 char#65 A --- */
      {  65,   35,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x18\x80\x01\x1c\xa0\x01\x1a\x10\x03\x31\xf8"
            "\x43\x30\x04\xf3\xfc" }  },
      /* --- pixel bitmap for cmmi131 char#66 B --- */
      {  66,   80,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x0f\x0c\xc3\x60\x18\x0c\xc3\xe0\x0f\x86\xc3\x60"
            "\x18\x0c\x83\x30\x98\xff\x00" }  },
      /* --- pixel bitmap for cmmi131 char#67 C --- */
      {  67,  129,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x09\xe3\x08\x44\x40\x06\x60\x00\x03\x30\x00\x03"
            "\x22\x10\x84\x81\x07" }  },
      /* --- pixel bitmap for cmmi131 char#68 D --- */
      {  68,  174,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x0f\x18\x06\x03\xc1\xc0\x30\x30\x0c\x8c\x81\x61"
            "\x60\x18\x08\x06\xc3\x60\xfc\x07" }  },
      /* --- pixel bitmap for cmmi131 char#69 E --- */
      {  69,  225,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x1f\x0c\xc3\x20\x98\x04\x93\xe0\x03\x26\xc0\x44"
            "\x18\x08\x83\x30\x98\xff\x01" }  },
      /* --- pixel bitmap for cmmi131 char#70 F --- */
      {  70,  280,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x1f\x0c\xc3\x20\x18\x05\xa3\xe0\x07\x46\xc0\x08"
            "\x18\x00\x03\x30\x80\x1f\x00" }  },
      /* --- pixel bitmap for cmmi131 char#71 G --- */
      {  71,  327,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x09\xe3\x08\x44\x40\x06\x60\x00\xc3\x3f\x30\x03"
            "\x23\x30\x84\x81\x17" }  },
      /* --- pixel bitmap for cmmi131 char#72 H --- */
      {  72,  378,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xfd\x60\x30\x30\x18\x30\x18\x30\x18\xf0\x1f\x18"
            "\x0c\x18\x0c\x18\x0c\x18\x0c\x0c\x06\xbf\x1f" }  },
      /* --- pixel bitmap for cmmi131 char#73 I --- */
      {  73,  431,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xc1\xc0\x80\x01\x03\x06\x06\x0c\x18\x30\x30\xf8"
            "\x01" }  },
      /* --- pixel bitmap for cmmi131 char#74 J --- */
      {  74,  462,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x03\x06\x0c\x30\xc0\x00\x03\x06\x18\x60\x98\x31"
            "\x83\x07" }  },
      /* --- pixel bitmap for cmmi131 char#75 K --- */
      {  75,  497,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x7d\x30\x04\x0c\x01\x46\x00\x1b\x80\x0f\xe0\x06"
            "\x30\x07\x18\x03\x8c\x01\xc3\xe1\xf7\x01" }  },
      /* --- pixel bitmap for cmmi131 char#76 L --- */
      {  76,  550,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x81\x01\x03\x0c\x30\xc0\x80\x01\x86\x18\x62\xcc"
            "\xd8\x7f" }  },
      /* --- pixel bitmap for cmmi131 char#77 M --- */
      {  77,  589,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 19,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xc0\x07\x07\x0e\x34\x38\xa0\xa1\x01\x0d\x0d\x68"
            "\x64\x20\x93\x01\x99\x0c\x88\x63\x40\x1c\x03\x61\x0c"
            "\x3e\xf9\x01" }  },
      /* --- pixel bitmap for cmmi131 char#78 N --- */
      {  78,  674,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\xf8\xe0\x20\xd0\x10\xd0\x11\x90\x11\x90\x13\x08"
            "\x0b\x08\x0b\x08\x0e\x08\x0e\x04\x06\x1f\x04" }  },
      /* --- pixel bitmap for cmmi131 char#79 O --- */
      {  79,  741,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x03\x61\x0c\x44\xc0\x06\x6c\xc0\x03\x36\x60\x03"
            "\x63\x30\x86\xc1\x07" }  },
      /* --- pixel bitmap for cmmi131 char#80 P --- */
      {  80,  792,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x07\xc6\x30\x0c\xc3\x30\x0c\x63\xf8\x83\x01\x18"
            "\x80\x01\x0c\xf0\x03" }  },
      /* --- pixel bitmap for cmmi131 char#81 Q --- */
      {  81,  833,                      /* character number, location */
         12, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x03\x61\x0c\x44\xc0\x06\x6c\xc0\x03\x36\x60\x03"
            "\x22\x33\xce\xc1\x07\x40\x00\x24\xc0\x01\x0c" }  },
      /* --- pixel bitmap for cmmi131 char#82 R --- */
      {  82,  896,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x07\xc6\x30\x0c\xc3\x30\x06\x3f\x18\x83\x31\x18"
            "\x83\x31\x8c\xfb\xf3" }  },
      /* --- pixel bitmap for cmmi131 char#83 S --- */
      {  83,  949,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x62\xcc\x10\x03\x1c\xe0\x01\x0f\x30\xc0\x08\x31"
            "\x46\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#84 T --- */
      {  84,  992,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfe\x17\x73\x8c\x62\x14\x23\x18\x60\x00\x03\x18\xc0"
            "\x00\x03\xfe\x00" }  },
      /* --- pixel bitmap for cmmi131 char#85 U --- */
      {  85, 1039,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x9f\x81\x18\x08\x03\x61\x20\x0c\xc4\x40\x18\x08"
            "\x03\x61\x10\x0c\x01\x1e\x00" }  },
      /* --- pixel bitmap for cmmi131 char#86 V --- */
      {  86, 1092,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1f\x9f\x41\x30\x08\x86\xc0\x10\x18\x01\x13\xe0\x02"
            "\x38\x00\x07\x60\x00\x04\x00" }  },
      /* --- pixel bitmap for cmmi131 char#87 W --- */
      {  87, 1139,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x9f\xef\x33\x1c\xc2\x68\x04\xa3\x11\x4c\x26\x30\x59"
            "\xc0\x62\x01\x8f\x03\x1c\x0e\x30\x18\xc0\x60\x00\x81"
            "\x00" }  },
      /* --- pixel bitmap for cmmi131 char#88 X --- */
      {  88, 1218,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x7d\x70\x04\x30\x01\x58\x00\x3c\x00\x0c\x00\x06"
            "\x80\x06\x20\x03\x88\x01\x82\xe1\xf3\x03" }  },
      /* --- pixel bitmap for cmmi131 char#89 Y --- */
      {  89, 1267,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1f\x9f\x41\x70\x0c\x8c\x80\x09\xe0\x00\x1c\x80\x01"
            "\x30\x00\x06\x60\x00\x3f\x00" }  },
      /* --- pixel bitmap for cmmi131 char#90 Z --- */
      {  90, 1308,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xc7\x18\x63\x88\x43\x0c\x30\xc0\x00\x23\x1c\x61"
            "\x8c\x31\xfe\x01" }  },
      /* --- pixel bitmap for cmmi131 char#91 \flat --- */
      {  91, 5198,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\x11\x11\x9d\x99\x5d\x33" }  },
      /* --- pixel bitmap for cmmi131 char#92 \natural --- */
      {  92, 5245,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  4,    17, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\x11\xbd\x99\x99\x99\xbd\x88\x08" }  },
      /* --- pixel bitmap for cmmi131 char#93 \sharp --- */
      {  93, 5306,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  4,    17, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x99\xbd\x99\x99\x99\xbd\x99\x01" }  },
      /* --- pixel bitmap for cmmi131 char#94 \smile --- */
      {  94, 5377,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 15,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01\x40\x01\x10\x01\x04\x83\x01\x3e\x00" }  },
      /* --- pixel bitmap for cmmi131 char#95 \frown --- */
      {  95, 5402,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 15,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe0\x03\x0c\x06\x01\x44\x00\x14\x00\x04" }  },
      /* --- pixel bitmap for cmmi131 char#96 \ell --- */
      {  96, 4320,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x40\xa0\x90\x50\x48\x28\x18\x14\x0c\x04\x06\x48\x38" }  },
      /* --- pixel bitmap for cmmi131 char#97 a --- */
      {  97, 1355,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x99\x24\x12\xc9\xa6\x6c" }  },
      /* --- pixel bitmap for cmmi131 char#98 b --- */
      {  98, 1398,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x86\x10\x21\x9c\x9c\x31\xa6\x64\x00" }  },
      /* --- pixel bitmap for cmmi131 char#99 c --- */
      {  99, 1443,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\x04\x41\x10\x39" }  },
      /* --- pixel bitmap for cmmi131 char#100 d --- */
      { 100, 1470,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x60\x20\x10\x04\x62\xc9\x24\x91\x48\x36\x65\x03" }  },
      /* --- pixel bitmap for cmmi131 char#101 e --- */
      { 101, 1523,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\x3d\x41\x10\x39" }  },
      /* --- pixel bitmap for cmmi131 char#102 f --- */
      { 102, 1552,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\xa0\x20\x20\x10\x38\x10\x10\x10\x08\x08\x08\x08"
            "\x08\x04\x05\x02" }  },
      /* --- pixel bitmap for cmmi131 char#103 g --- */
      { 103, 1597,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xb0\xc8\x48\x44\x44\x64\x24\x38\x20\x20\x10\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#104 h --- */
      { 104, 1642,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x0c\x08\x08\x04\x04\x3c\x24\x26\x22\x22\x92\x51\x21" }  },
      /* --- pixel bitmap for cmmi131 char#105 i --- */
      { 105, 1693,                      /* character number, location */
         13, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x00\x60\x56\x24\x6a\x06" }  },
      /* --- pixel bitmap for cmmi131 char#106 j --- */
      { 106, 1724,                      /* character number, location */
         13, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  7,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x00\x00\x00\xc0\xa0\x28\x10\x08\x04\x81\x40\x20"
            "\x08\x03" }  },
      /* --- pixel bitmap for cmmi131 char#107 k --- */
      { 107, 1763,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x0c\x08\x08\x04\x04\x64\x94\x0a\x06\x0a\x52\x31\x31" }  },
      /* --- pixel bitmap for cmmi131 char#108 l --- */
      { 108, 1814,                      /* character number, location */
         13, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x48\x44\x24\x22\x36\x02" }  },
      /* --- pixel bitmap for cmmi131 char#109 m --- */
      { 109, 1847,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,     8, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe6\x8e\x66\xd2\x98\x10\x22\x84\x08\x21\x29\x44\x09"
            "\x21" }  },
      /* --- pixel bitmap for cmmi131 char#110 n --- */
      { 110, 1910,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x76\x94\x34\x21\x42\x84\xa4\x28\x21" }  },
      /* --- pixel bitmap for cmmi131 char#111 o --- */
      { 111, 1957,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9c\x28\x86\x61\x14\x39" }  },
      /* --- pixel bitmap for cmmi131 char#112 p --- */
      { 112, 1992,                      /* character number, location */
          8,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x6c\x94\x9a\x88\x88\x48\x4c\x34\x04\x04\x02\x07" }  },
      /* --- pixel bitmap for cmmi131 char#113 q --- */
      { 113, 2043,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xac\x2c\x45\x51\x96\x38\x08\x42\x38" }  },
      /* --- pixel bitmap for cmmi131 char#114 r --- */
      { 114, 2088,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x36\x65\x83\x40\x20\x08\x04" }  },
      /* --- pixel bitmap for cmmi131 char#115 s --- */
      { 115, 2119,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x24\x01\x03\x02\x86\x3c" }  },
      /* --- pixel bitmap for cmmi131 char#116 t --- */
      { 116, 2146,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x90\x4f\x84\x10\x32\x19" }  },
      /* --- pixel bitmap for cmmi131 char#117 u --- */
      { 117, 2179,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x14\x25\x21\x42\x84\x2c\x29\x6e" }  },
      /* --- pixel bitmap for cmmi131 char#118 v --- */
      { 118, 2226,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x65\x92\x48\x24\x91\x38" }  },
      /* --- pixel bitmap for cmmi131 char#119 w --- */
      { 119, 2267,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x84\x54\x64\x12\x89\x48\x44\x22\x91\x09\x3b" }  },
      /* --- pixel bitmap for cmmi131 char#120 x --- */
      { 120, 2324,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd8\x68\x4a\x80\x00\x01\x52\x16\x1b" }  },
      /* --- pixel bitmap for cmmi131 char#121 y --- */
      { 121, 2363,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x84\x8a\x49\x44\x44\x64\x24\x3c\x20\x10\x11\x0e" }  },
      /* --- pixel bitmap for cmmi131 char#122 z --- */
      { 122, 2414,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x64\x20\x10\x08\x44\x26\x19" }  },
      /* --- pixel bitmap for cmmi131 char#123 \imath --- */
      { 123, 4367,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x66\x45\xa2\x66" }  },
      /* --- pixel bitmap for cmmi131 char#124 \jmath --- */
      { 124, 4394,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x30\x24\x09\x04\x02\x41\x20\x10\x08\xe2\x00" }  },
      /* --- pixel bitmap for cmmi131 char#125 \wp --- */
      { 125, 4429,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0c\xc4\x65\x2c\x58\x70\xe0\xa4\x32\x05\x12\x14\x18"
            "\x00" }  },
      /* --- pixel bitmap for cmmi131 char#126 \vec --- */
      { 126, 4490,                      /* character number, location */
         13, 3,    10, 3,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x40\xff\x40" }  },
      /* --- pixel bitmap for cmmi131 char#127 (noname) --- */
      { 127, 4503,                      /* character number, location */
         12, 5,    10, 5,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x08" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=4 ---
 * mf '\mode=itoh; input cmmi10'       gives .gf160
 * ------------------------------------------------ */
/* --- fontdef for cmmi160 --- */
static	chardef  cmmi160[] =
   {
      /* --- pixel bitmap for cmmi160 char#0 \Gamma --- */
      {   0, 2769,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x3f\x18\x0c\x06\x82\x81\x60\x20\x0c\x00\x03\xc0"
            "\x00\x30\x00\x06\x80\x01\x60\x00\x0c\xc0\x1f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#1 \Delta --- */
      {   1, 2812,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x0c\x00\x06\x80\x07\x20\x03\x88\x01\xc4\x00\x61"
            "\x40\x70\x10\x30\x04\x18\x02\x8c\x00\xee\xff\xff\xff"
            "\x03" }  },
      /* --- pixel bitmap for cmmi160 char#2 \Theta --- */
      {   2, 2865,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x07\x0c\x86\x01\x33\xc0\x06\xb0\x84\x3c\x3f\xcf"
            "\xcf\x13\xda\x00\x36\xc0\x0c\x18\x06\x03\x3e\x00" }  },
      /* --- pixel bitmap for cmmi160 char#3 \Lambda --- */
      {   3, 2936,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x60\x00\x0c\xc0\x03\x78\x80\x0c\x90\x01\x31"
            "\x10\x06\xc2\x20\x18\x04\x43\x60\x1e\x3f" }  },
      /* --- pixel bitmap for cmmi160 char#4 \Xi --- */
      {   4, 2989,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\xf8\x7f\x08\x40\x08\x40\x00\x00\x10\x08\xf0"
            "\x0f\xf0\x0f\x10\x08\x00\x00\x02\x10\x02\x10\xff\x0f"
            "\xff\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#5 \Pi --- */
      {   5, 3036,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xff\x83\x81\x01\x06\x06\x18\x18\x60\x60\xc0\xc0"
            "\x00\x03\x03\x0c\x0c\x30\x30\x60\x60\x80\x81\x01\x06"
            "\x06\x0c\x0c\xfc\xfc\x00" }  },
      /* --- pixel bitmap for cmmi160 char#6 \Sigma --- */
      {   6, 3097,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\x30\xc0\x70\xc0\x60\x80\xe0\x80\xc0\x00\xc0"
            "\x01\x80\x00\x40\x00\x20\x20\x10\x20\x08\x10\x04\x1c"
            "\xfe\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#7 \Upsilon --- */
      {   7, 3148,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3c\xbc\x8d\x1d\x16\x82\x03\xe0\x00\x18\x00\x06\x80"
            "\x01\x60\x00\x0c\x00\x03\xc0\x00\x18\xc0\x3f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#8 \Phi --- */
      {   8, 3197,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x0f\x30\x00\x06\xf8\xc3\xd8\x8c\xf1\x30\x1e\xc6"
            "\xc3\xcc\xcc\xf0\x07\x30\x00\x03\xfc\x03" }  },
      /* --- pixel bitmap for cmmi160 char#9 \Psi --- */
      {   9, 3256,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x07\x30\x00\x0c\x1c\xe3\xc7\xd8\x18\x33\xc6\x8c"
            "\x31\x63\x86\xed\xc0\x0f\xc0\x00\x18\xc0\x3f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#10 \Omega --- */
      {  10, 3319,                      /* character number, location */
         14, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x0f\x18\x1c\x06\x8c\x01\xcc\x00\x36\x80\x19\xc0"
            "\x08\x30\x0c\x0c\x06\x42\x82\x24\x21\xf1\xf0\x78\x3c"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#11 \alpha --- */
      {  11, 3388,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\xc0\x88\x02\x29\x50\x01\x15\x30\x01\x21\x1c\x3c"
            "\x06" }  },
      /* --- pixel bitmap for cmmi160 char#12 \beta --- */
      {  12, 3437,                      /* character number, location */
         14, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 12,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x07\x84\x20\x08\x81\x10\x84\x3e\x08\x86\x40\x08"
            "\x44\x40\x04\x44\x20\x0a\x21\x0f\x02\x20\x00\x01\x10"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#13 \gamma --- */
      {  13, 3508,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\xda\x18\x14\x50\x40\x01\x03\x0c\x30\x40\x00\x01"
            "\x04\x08\x20\x00" }  },
      /* --- pixel bitmap for cmmi160 char#14 \delta --- */
      {  14, 3555,                      /* character number, location */
         15, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\xe0\x23\x40\x00\x01\x02\x0c\x16\x42\x84\x04\x09"
            "\x12\x44\x04\x07" }  },
      /* --- pixel bitmap for cmmi160 char#15 \epsilon --- */
      {  15, 3606,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x86\x40\xf0\x0b\x04\x04\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#16 \zeta --- */
      {  16, 3631,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x80\x00\x87\x81\x80\x80\x00\x01\x02\x02\x04\x08"
            "\x20\x80\x01\x0c\x20\x40\x70\x00" }  },
      /* --- pixel bitmap for cmmi160 char#17 \eta --- */
      {  17, 3674,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe2\x3a\x36\x24\x28\x48\x90\xa0\x20\x41\x80\x00\x01"
            "\x01\x02" }  },
      /* --- pixel bitmap for cmmi160 char#18 \theta --- */
      {  18, 3729,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x60\x90\x88\x84\x84\x82\xfe\xfe\x42\x41\x61\x22\x12"
            "\x0c" }  },
      /* --- pixel bitmap for cmmi160 char#19 \iota --- */
      {  19, 3784,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x10\x21\x44\x4c\x06" }  },
      /* --- pixel bitmap for cmmi160 char#20 \kappa --- */
      {  20, 3813,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x84\x11\x41\x03\x07\x3e\x08\x21\x64\x50\xc1\x01" }  },
      /* --- pixel bitmap for cmmi160 char#21 \lambda --- */
      {  21, 3856,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x18\x80\x00\x02\x08\x40\x00\x01\x04\x30\xa0\x40\x82"
            "\x10\x41\x02\x05\x08" }  },
      /* --- pixel bitmap for cmmi160 char#22 \mu --- */
      {  22, 3903,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x42\x10\x82\x10\x44\x10\x82\x10\xd6\x68\x3a\x13"
            "\x80\x00\x02\x10\x00" }  },
      /* --- pixel bitmap for cmmi160 char#23 \nu --- */
      {  23, 3960,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x06\x09\x12\x24\x24\x44\x84\x84\x06\x03\x00" }  },
      /* --- pixel bitmap for cmmi160 char#24 \xi --- */
      {  24, 4001,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x20\xf0\x08\x04\x02\x04\x78\x04\x02\x01\x01\x01"
            "\x06\x18\x20\x40\x38" }  },
      /* --- pixel bitmap for cmmi160 char#25 \pi --- */
      {  25, 4044,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xfe\x2f\x91\x04\x12\x48\x90\x40\x82\x10\x42\x00" }  },
      /* --- pixel bitmap for cmmi160 char#26 \rho --- */
      {  26, 4089,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x20\x22\x44\x48\x90\x20\x21\x23\x3a\x04\x08\x08"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmmi160 char#27 \sigma --- */
      {  27, 4138,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\x67\x84\x20\x04\x11\x88\x40\x04\x41\x04\x1c\x00" }  },
      /* --- pixel bitmap for cmmi160 char#28 \tau --- */
      {  28, 4177,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xfe\x27\x44\x80\x80\x00\x01\x02\x02\x04\x00" }  },
      /* --- pixel bitmap for cmmi160 char#29 \upsilon --- */
      {  29, 4206,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x06\x0b\x16\x24\x28\x48\x90\x10\x21\x3c\x00" }  },
      /* --- pixel bitmap for cmmi160 char#30 \phi --- */
      {  30, 4251,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x04\x20\x00\x01\x08\xf8\x20\xc9\x88\x42\x0c"
            "\x61\x08\x43\x24\x19\x3e\x40\x00\x02\x08\x40\x00" }  },
      /* --- pixel bitmap for cmmi160 char#31 \chi --- */
      {  31, 4322,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x04\xa8\x80\x10\x04\x21\x20\x01\x0a\x40\x00\x06\x90"
            "\x80\x08\x04\x21\x50\x01\x06" }  },
      /* --- pixel bitmap for cmmi160 char#32 \psi --- */
      {  32, 4381,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 12,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x10\x00\x01\x10\x80\x60\x88\x85\x58\x84\x44"
            "\x28\x44\x42\x24\x22\x24\x81\x0f\x10\x00\x01\x10\x00"
            "\x01" }  },
      /* --- pixel bitmap for cmmi160 char#33 \omega --- */
      {  33, 4460,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x04\x68\x80\x02\x28\x84\x21\x14\x42\x31\xb2\x37\xce"
            "\x01" }  },
      /* --- pixel bitmap for cmmi160 char#34 \varepsilon --- */
      {  34, 4513,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x86\x02\x06\x1e\x01\x01\x21\x1e" }  },
      /* --- pixel bitmap for cmmi160 char#35 \vartheta --- */
      {  35, 4542,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x80\x04\x11\x44\x10\x89\x55\x78\x41\x84\x08\x22"
            "\x8c\x10\x22\x70\x00" }  },
      /* --- pixel bitmap for cmmi160 char#36 \varpi --- */
      {  36, 4607,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xff\x0a\x20\x05\x20\x04\x21\x82\x20\x82\x20\xc2"
            "\x10\x22\x19\x1c\x07" }  },
      /* --- pixel bitmap for cmmi160 char#37 \varrho --- */
      {  37, 4664,                      /* character number, location */
          9, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x70\x88\x84\x84\x82\x82\x42\x23\x1d\x01\x01\x01\x3e" }  },
      /* --- pixel bitmap for cmmi160 char#38 \varsigma --- */
      {  38, 4713,                      /* character number, location */
          9, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xf0\x0c\x02\x02\x01\x02\x0c\x10\x20\x20\x18" }  },
      /* --- pixel bitmap for cmmi160 char#39 \varphi --- */
      {  39, 4742,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x84\x23\x44\x22\x2c\x42\x11\x14\x41\x12\xe2\x18\x78"
            "\x80\x00\x08\x40\x00\x04\x00" }  },
      /* --- pixel bitmap for cmmi160 char#40 \leftharpoonup --- */
      {  40, 5488,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 19,     6, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x00\x80\x00\x00\x02\x00\x10\x00\x60\x00\x80\xff"
            "\xff\x03" }  },
      /* --- pixel bitmap for cmmi160 char#41 \leftharpoondown --- */
      {  41, 5507,                      /* character number, location */
          5, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 19,     6, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\x37\x00\x00\x02\x00\x10\x00\x00\x01\x00\x08"
            "\x00\x00" }  },
      /* --- pixel bitmap for cmmi160 char#42 \rightharpoonup --- */
      {  42, 5526,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 19,     6, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x40\x00\x00\x02\x00\x20\x00\x00\x01\x00\xb0\xff"
            "\xff\x03" }  },
      /* --- pixel bitmap for cmmi160 char#43 \rightharpoondown --- */
      {  43, 5545,                      /* character number, location */
          5, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 19,     6, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\x07\x00\x18\x00\x20\x00\x00\x01\x00\x04\x00"
            "\x20\x00" }  },
      /* --- pixel bitmap for cmmi160 char#44 ` --- */
      {  44, 5564,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x12\x03" }  },
      /* --- pixel bitmap for cmmi160 char#45 ' --- */
      {  45, 5583,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x23\xc9\x01" }  },
      /* --- pixel bitmap for cmmi160 char#46 \triangleright --- */
      {  46, 5602,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x03\x34\x10\x43\x30\x01\x07\x13\x43\x03\x03\x00" }  },
      /* --- pixel bitmap for cmmi160 char#47 \triangleleft --- */
      {  47, 5641,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x00\x03\x0b\x23\x83\x03\x32\x08\x23\xb0\x00\x03" }  },
      /* --- pixel bitmap for cmmi160 char#48 \0 --- */
      {  48, 5072,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81\x81\x81\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#49 \1 --- */
      {  49, 5111,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x07\x02\x81\x40\x20\x10\x7e" }  },
      /* --- pixel bitmap for cmmi160 char#50 \2 --- */
      {  50, 5136,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x43\x81\xc0\x40\x30\x98\x7e\x7f" }  },
      /* --- pixel bitmap for cmmi160 char#51 \3 --- */
      {  51, 5167,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3c\x43\xc3\xc0\x60\x3c\x60\xc0\xc0\xc3\xc3\x62\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#52 \4 --- */
      {  52, 5210,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x30\x30\x38\x28\x24\x26\x22\x23\xff\x20\x20\x20\xf8" }  },
      /* --- pixel bitmap for cmmi160 char#53 \5 --- */
      {  53, 5253,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x42\x3e\x1e\x02\x02\x3e\x62\xc0\xc0\xc1\xc1\x62\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#54 \6 --- */
      {  54, 5296,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x78\x84\x82\x02\x01\x3d\x43\x81\x81\x81\x82\x46\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#55 \7 --- */
      {  55, 5347,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x02\xfc\x0b\x0c\x04\x04\x04\x08\x08\x10\x30\x20\x40"
            "\x80\x00\x01" }  },
      /* --- pixel bitmap for cmmi160 char#56 \8 --- */
      {  56, 5386,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3c\x42\x81\x83\x46\x3c\x3c\x62\xc1\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#57 \9 --- */
      {  57, 5437,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3c\x42\x41\x81\x81\x81\xc2\xbc\x80\x40\x41\x21\x1e" }  },
      /* --- pixel bitmap for cmmi160 char#58 . --- */
      {  58, 5680,                      /* character number, location */
          2, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#59 , --- */
      {  59, 5691,                      /* character number, location */
          2, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xad\x07" }  },
      /* --- pixel bitmap for cmmi160 char#60 < --- */
      {  60, 5710,                      /* character number, location */
         10, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x0c\x30\xc0\x00\x03\x0c\x30\x00\x0c\x00\x03\xc0"
            "\x00\x30\x00\x0c" }  },
      /* --- pixel bitmap for cmmi160 char#61 / --- */
      {  61, 5739,                      /* character number, location */
         15, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  8,    20, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x80\x40\x40\x40\x20\x20\x10\x10\x10\x08\x08\x08"
            "\x04\x04\x02\x02\x02\x01\x01" }  },
      /* --- pixel bitmap for cmmi160 char#62 > --- */
      {  62, 5786,                      /* character number, location */
         10, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x03\xc0\x00\x30\x00\x0c\x00\x03\xc0\x00\x03\x0c\x30"
            "\xc0\x00\x03\x00" }  },
      /* --- pixel bitmap for cmmi160 char#63 \star --- */
      {  63, 5815,                      /* character number, location */
          5, 0,     2, 0,     /* topleft row,col, and botleft row,col */
          {  7,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x18\x12" }  },
      /* --- pixel bitmap for cmmi160 char#64 \partial --- */
      {  64, 4803,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x20\x44\x20\x80\x00\xc2\xcb\xb0\xc0\x02\x05\x14"
            "\x50\x20\x62\xf0\x00" }  },
      /* --- pixel bitmap for cmmi160 char#65 A --- */
      {  65,   35,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x04\x00\x07\x80\x03\xa0\x01\xd8\x00\x64\x00\x31"
            "\x80\x18\x20\x0c\xf8\x07\x04\x03\x81\xc1\xc0\xf8\xf8"
            "\x03" }  },
      /* --- pixel bitmap for cmmi160 char#66 B --- */
      {  66,   90,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x3f\x30\x30\x18\x18\x0c\x0c\x06\x86\x81\xc1\x3f"
            "\x60\x70\x30\x30\x0c\x18\x06\x0c\x03\xc3\xc0\xf8\x3f"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#67 C --- */
      {  67,  147,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x47\x38\x1c\x06\x8c\x01\x64\x00\x12\x00\x0c\x00"
            "\x06\x00\x03\x80\x01\xc4\x00\x42\x80\xc0\x30\xc0\x07"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#68 D --- */
      {  68,  200,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x3f\x60\x60\x60\xc0\x60\xc0\x60\xc0\x30\xc0\x30"
            "\xc0\x30\xc0\x30\x40\x18\x60\x18\x30\x18\x18\x0c\x0c"
            "\xff\x03" }  },
      /* --- pixel bitmap for cmmi160 char#69 E --- */
      {  69,  259,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7f\x30\x30\x18\x18\x0c\x08\x46\x84\x11\xc0\x0f"
            "\x60\x04\x30\x12\x0c\x08\x06\x06\x03\xc1\xe0\xf8\x3f"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#70 F --- */
      {  70,  320,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7f\x30\x30\x18\x18\x0c\x08\x86\x84\x21\xc0\x1f"
            "\x60\x0c\x30\x04\x0c\x00\x06\x00\x03\xc0\x00\xf8\x03"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#71 G --- */
      {  71,  371,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x47\x38\x1c\x06\x8c\x01\x64\x00\x12\x00\x0c\x00"
            "\x06\x00\x03\xbf\x01\xc6\x00\x43\x80\xc1\x60\xc0\x2f"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#72 H --- */
      {  72,  428,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xf3\x83\x81\x01\x06\x06\x18\x18\x60\x60\xc0\xc0"
            "\x00\xff\x03\x0c\x0c\x30\x30\x60\x60\x80\x81\x01\x06"
            "\x06\x0c\x0c\xfc\xfc\x00" }  },
      /* --- pixel bitmap for cmmi160 char#73 I --- */
      {  73,  489,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x83\x01\x06\x18\x60\xc0\x00\x03\x0c\x30\x60\x80"
            "\x01\x06\x0c\xfc\x00" }  },
      /* --- pixel bitmap for cmmi160 char#74 J --- */
      {  74,  524,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x0f\x30\x00\x03\x30\x00\x03\x18\x80\x01\x18\x80"
            "\x01\x0c\xc0\x60\x0c\x62\xe0\x01" }  },
      /* --- pixel bitmap for cmmi160 char#75 K --- */
      {  75,  563,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xf3\xc1\x40\x80\x41\x00\x63\x00\x66\x00\x66\x00"
            "\xec\x00\x38\x03\x30\x06\x30\x0c\x60\x30\xc0\x60\xc0"
            "\xc0\xe0\xc7\x07" }  },
      /* --- pixel bitmap for cmmi160 char#76 L --- */
      {  76,  626,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x03\x0c\x80\x01\x30\x00\x06\x60\x00\x0c\x80\x01"
            "\x30\x10\x03\x61\x20\x0c\xc2\x70\xfe\x07" }  },
      /* --- pixel bitmap for cmmi160 char#77 M --- */
      {  77,  671,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x00\x1f\x34\x70\x80\x06\x0e\xd0\xa0\x01\x1a\x34"
            "\x20\x43\x03\x64\x64\x80\x8c\x0c\x90\x89\x01\xb1\x18"
            "\x20\x16\x03\xc4\x61\x40\x18\x06\x3e\xf3\x03" }  },
      /* --- pixel bitmap for cmmi160 char#78 N --- */
      {  78,  776,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\xf0\x83\x07\x03\x1a\x04\x68\x10\x20\x43\x40\x8c"
            "\x00\x31\x02\x84\x09\x10\x26\x20\x58\x80\xc0\x01\x02"
            "\x07\x04\x0c\x7c\x20\x00" }  },
      /* --- pixel bitmap for cmmi160 char#79 O --- */
      {  79,  855,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x07\x0c\x86\x01\x33\xc0\x06\xb0\x00\x3c\x00\x0f"
            "\xc0\x03\xd8\x00\x36\xc0\x0c\x18\x06\x03\x3e\x00" }  },
      /* --- pixel bitmap for cmmi160 char#80 P --- */
      {  80,  914,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x1f\x30\x18\x18\x18\x0c\x0c\x06\x86\x81\xc1\x60"
            "\xe0\x0f\x30\x00\x0c\x00\x06\x00\x03\xc0\x00\xf8\x01"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#81 Q --- */
      {  81,  961,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 14,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x07\x0c\x86\x01\x33\xc0\x06\xb0\x00\x3c\x00\x0f"
            "\xc0\x03\xd8\x00\x36\xc0\xcc\x19\x1e\x03\x3e\x00\x08"
            "\x00\x02\x80\x07\xe0\x00" }  },
      /* --- pixel bitmap for cmmi160 char#82 R --- */
      {  82, 1030,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x1f\x30\x30\x18\x18\x0c\x0c\x06\x82\xc1\xc0\x3f"
            "\x60\x18\x30\x0c\x0c\x06\x06\x03\x83\xc1\xc0\xfc\xe1"
            "\x01" }  },
      /* --- pixel bitmap for cmmi160 char#83 S --- */
      {  83, 1091,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x0b\x63\x18\x84\x41\x18\x80\x03\xf0\x01\x3e\x00"
            "\x03\x30\x02\x23\x10\x87\x90\x07" }  },
      /* --- pixel bitmap for cmmi160 char#84 T --- */
      {  84, 1142,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfe\xff\x30\x14\x0c\x05\x43\xc1\x10\x18\x00\x06\x80"
            "\x01\x60\x00\x0c\x00\x03\xc0\x00\x18\xc0\x3f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#85 U --- */
      {  85, 1193,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7f\x7e\x06\x0c\x03\x82\x01\xc1\x80\x30\x20\x18\x10"
            "\x0c\x08\x06\x84\x01\xc1\x80\x60\x20\x60\x08\xe0\x03"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#86 V --- */
      {  86, 1254,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x7c\x06\x08\x03\x82\x81\xc1\x40\xc0\x10\x60\x0c"
            "\x30\x02\x98\x00\x6c\x00\x16\x00\x07\x80\x03\xc0\x00"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#87 W --- */
      {  87, 1311,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\x3f\x9f\x81\x81\x30\x38\x18\x06\x07\xc1\xd0\x10"
            "\x18\x1b\x02\x23\x23\x60\x62\x06\x4c\x4c\x80\x85\x05"
            "\xf0\xb0\x00\x0e\x0e\xc0\x80\x01\x18\x10\x00" }  },
      /* --- pixel bitmap for cmmi160 char#88 X --- */
      {  88, 1408,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 19,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xe7\x07\x0c\x02\x60\x08\x00\x26\x00\xb0\x00\x80"
            "\x03\x00\x18\x00\xe0\x00\x80\x0d\x00\x64\x00\x10\x07"
            "\x40\x30\x00\x81\x81\x1f\x7e\x00" }  },
      /* --- pixel bitmap for cmmi160 char#89 Y --- */
      {  89, 1465,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xf8\x0c\x10\x18\x08\x18\x04\x18\x02\x30\x01\xb0"
            "\x00\x70\x00\x20\x00\x30\x00\x30\x00\x30\x00\x18\x00"
            "\x7e\x00" }  },
      /* --- pixel bitmap for cmmi160 char#90 Z --- */
      {  90, 1514,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7f\x1c\x18\x06\x06\x81\x81\x60\x00\x18\x00\x06"
            "\x80\x01\x60\x10\x18\x04\x06\x82\x81\x61\x60\xf8\x3f"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#91 \flat --- */
      {  91, 5830,                      /* character number, location */
         15, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    15, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x41\x10\x04\x41\x30\x85\x61\x18\x45\x49\x31\x00" }  },
      /* --- pixel bitmap for cmmi160 char#92 \natural --- */
      {  92, 5883,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x41\x10\x04\xf9\x19\x86\x61\x18\x86\x61\x7e\x82\x20"
            "\x08" }  },
      /* --- pixel bitmap for cmmi160 char#93 \sharp --- */
      {  93, 5948,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x92\x24\x49\xfa\x25\x49\x92\x24\x49\x92\x7e\x49\x92"
            "\x04" }  },
      /* --- pixel bitmap for cmmi160 char#94 \smile --- */
      {  94, 6027,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 19,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01\x00\x34\x00\x18\x0e\x38\xc0\x7f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#95 \frown --- */
      {  95, 6048,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 19,     5, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xc0\x1f\xc0\x01\x07\x01\x40\x04\x00\x14\x00\x40" }  },
      /* --- pixel bitmap for cmmi160 char#96 \ell --- */
      {  96, 4858,                      /* character number, location */
         14,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  9,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x81\x02\x05\x09\x0a\x12\x14\x18\x10\x10\x30\x50"
            "\x80\x08\x0e" }  },
      /* --- pixel bitmap for cmmi160 char#97 a --- */
      {  97, 1567,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xb8\x88\x09\x13\x16\x24\x48\xd8\x68\xce\x00" }  },
      /* --- pixel bitmap for cmmi160 char#98 b --- */
      {  98, 1614,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    14, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x0e\x02\x81\x40\xd0\x19\x85\xc2\x60\x30\x14\x71\x00" }  },
      /* --- pixel bitmap for cmmi160 char#99 c --- */
      {  99, 1665,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x70\x8c\x82\x02\x01\x01\x01\x42\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#100 d --- */
      { 100, 1696,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x03\x04\x10\x40\x00\xe1\x42\x8c\x30\xc2\x04\x11"
            "\x44\x58\xd1\x38\x03" }  },
      /* --- pixel bitmap for cmmi160 char#101 e --- */
      { 101, 1753,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x8c\x82\x62\x1f\x01\x01\x42\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#102 f --- */
      { 102, 1786,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x81\x02\x01\x02\x02\x1e\x08\x10\x30\x20\x40\x80"
            "\x00\x01\x01\x02\x04\x05\x0c\x00" }  },
      /* --- pixel bitmap for cmmi160 char#103 g --- */
      { 103, 1833,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\x11\x13\x26\x2c\x48\x90\x30\x31\x5c\x80\x00\x81"
            "\xf1\x01" }  },
      /* --- pixel bitmap for cmmi160 char#104 h --- */
      { 104, 1884,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x20\x80\x00\x02\x08\x90\xc3\x11\x43\x04\x09\x22"
            "\x88\x90\x41\x05\x06" }  },
      /* --- pixel bitmap for cmmi160 char#105 i --- */
      { 105, 1941,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x00\x60\x55\x24\x92\x65" }  },
      /* --- pixel bitmap for cmmi160 char#106 j --- */
      { 106, 1978,                      /* character number, location */
         14, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  8,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x00\x00\x00\x00\x30\x48\x48\x40\x20\x20\x20\x10"
            "\x10\x10\x10\x08\x07" }  },
      /* --- pixel bitmap for cmmi160 char#107 k --- */
      { 107, 2019,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x10\x20\x40\x80\x80\x30\x59\x0a\x0c\x3c\x88\x10"
            "\x19\x2a\x1c" }  },
      /* --- pixel bitmap for cmmi160 char#108 l --- */
      { 108, 2074,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    14, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x44\x24\x22\x12\x51\x33" }  },
      /* --- pixel bitmap for cmmi160 char#109 m --- */
      { 109, 2111,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe2\x38\x1d\x47\x0d\x43\x04\x41\x82\x20\x82\x20\x82"
            "\x90\x41\x50\x41\x60" }  },
      /* --- pixel bitmap for cmmi160 char#110 n --- */
      { 110, 2180,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xe2\x74\xd4\x10\x41\x82\x08\x22\x64\x50\x81\x01" }  },
      /* --- pixel bitmap for cmmi160 char#111 o --- */
      { 111, 2231,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x70\x8c\x82\x82\x81\x81\x41\x22\x1c" }  },
      /* --- pixel bitmap for cmmi160 char#112 p --- */
      { 112, 2270,                      /* character number, location */
          9,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc8\xd1\x48\x21\x84\x08\x22\x88\x10\x27\x74\x10\x40"
            "\x80\x00\x0f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#113 q --- */
      { 113, 2325,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x38\xc4\xc2\xc2\x41\x41\x61\x31\x2e\x20\x20\x10\x7c" }  },
      /* --- pixel bitmap for cmmi160 char#114 r --- */
      { 114, 2374,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf2\x66\x81\x20\x10\x08\x02\x01" }  },
      /* --- pixel bitmap for cmmi160 char#115 s --- */
      { 115, 2407,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\xa1\xc0\xc0\x01\x85\x22\x0e" }  },
      /* --- pixel bitmap for cmmi160 char#116 t --- */
      { 116, 2438,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x04\xfd\x08\x82\x10\x04\x49\x31" }  },
      /* --- pixel bitmap for cmmi160 char#117 u --- */
      { 117, 2473,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x06\x15\x54\x10\x41\x82\x08\x22\xac\xa8\x9c\x01" }  },
      /* --- pixel bitmap for cmmi160 char#118 v --- */
      { 118, 2526,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x86\x85\x85\x84\x42\x42\x42\x22\x1c" }  },
      /* --- pixel bitmap for cmmi160 char#119 w --- */
      { 119, 2571,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x86\xb0\x10\x16\x42\x42\x28\x84\x84\x90\x10\x12\x23"
            "\x9c\x03" }  },
      /* --- pixel bitmap for cmmi160 char#120 x --- */
      { 120, 2634,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xb8\x67\x22\x11\x80\x00\x02\x10\x80\x68\x26\xce\x00" }  },
      /* --- pixel bitmap for cmmi160 char#121 y --- */
      { 121, 2675,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0c\x15\x2a\x44\x48\x88\x10\x31\x22\x78\x80\x80\x88"
            "\xe0\x00" }  },
      /* --- pixel bitmap for cmmi160 char#122 z --- */
      { 122, 2730,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\xe4\x44\x20\x10\x88\x84\x4e\x31" }  },
      /* --- pixel bitmap for cmmi160 char#123 \imath --- */
      { 123, 4909,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x56\x45\x22\x59\x06" }  },
      /* --- pixel bitmap for cmmi160 char#124 \jmath --- */
      { 124, 4942,                      /* character number, location */
          9,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x60\x90\x90\x80\x40\x40\x40\x20\x20\x20\x20\x10\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#125 \wp --- */
      { 125, 4979,                      /* character number, location */
          9, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0c\x30\x9e\x0c\x15\x58\xc0\x02\x0e\x48\x22\xe5\x48"
            "\x40\x02\x0a\x30\x00" }  },
      /* --- pixel bitmap for cmmi160 char#126 \vec --- */
      { 126, 5046,                      /* character number, location */
         14, 4,    11, 4,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x40\xff\x40" }  },
      /* --- pixel bitmap for cmmi160 char#127 (noname) --- */
      { 127, 5059,                      /* character number, location */
         13, 5,    11, 5,     /* topleft row,col, and botleft row,col */
          {  8,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x83" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=5 ---
 * mf '\mode=lqlores; input cmmi10'    gives .gf180
 * ------------------------------------------------ */
/* --- fontdef for cmmi180 --- */
static	chardef  cmmi180[] =
   {
      /* --- pixel bitmap for cmmi180 char#0 \Gamma --- */
      {   0, 3357,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\xc0\xc0\xc0\x80\x60\x80\x60\x80\x60\x80\x60"
            "\x00\x30\x00\x30\x00\x30\x00\x30\x00\x18\x00\x18\x00"
            "\x18\x00\x18\x00\x0c\x00\x7f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#1 \Delta --- */
      {   1, 3408,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x30\x00\xc0\x00\x80\x03\x00\x1d\x00\x62\x00\x88"
            "\x01\x10\x06\x20\x38\x40\xc0\x00\x01\x03\x02\x0c\x04"
            "\x70\x08\x80\x21\x00\x46\x00\x98\xff\xff\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmi180 char#2 \Theta --- */
      {   2, 3473,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x1f\xe0\x30\x30\x60\x18\xc0\x0c\xc0\x06\xc0\x06"
            "\xc0\xf3\xcf\xf3\xcf\xf3\xcf\x03\x60\x03\x60\x03\x30"
            "\x03\x10\x06\x0c\x0c\x06\xf8\x01" }  },
      /* --- pixel bitmap for cmmi180 char#3 \Lambda --- */
      {   3, 3550,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x0c\x00\x03\xe0\x00\x38\x00\x0d\x40\x03\xc8\x00"
            "\x32\x40\x0c\x10\x03\xc2\x40\x30\x10\x0c\x02\x83\xc0"
            "\x30\x70\x1f\x3f" }  },
      /* --- pixel bitmap for cmmi180 char#4 \Xi --- */
      {   4, 3617,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\xc3\xff\x0f\x01\x20\x02\x40\x00\x00\x00\x00"
            "\x00\x02\x04\xfc\x0f\xf0\x3f\x40\x80\x00\x00\x00\x00"
            "\x00\x00\x00\x08\x00\x21\x00\xc4\xff\x0f\xff\x3f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#5 \Pi --- */
      {   5, 3664,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\x1f\x18\x60\x00\x03\x0c\x30\xc0\x00\x06\x18"
            "\xc0\x00\x03\x18\x60\x80\x01\x06\x30\xc0\x00\x06\x18"
            "\xc0\x00\x03\x0c\x30\x80\x01\x06\x30\xc0\x00\x06\x18"
            "\x60\x80\x01\x7f\xfc\x01" }  },
      /* --- pixel bitmap for cmmi180 char#6 \Sigma --- */
      {   6, 3737,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\x83\x01\x0c\x06\x20\x38\x80\xc0\x00\x02\x03"
            "\x08\x18\x00\x60\x00\x80\x03\x00\x06\x00\x04\x00\x08"
            "\x20\x10\x80\x20\x00\x41\x00\x84\x00\x1c\xff\x3f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#7 \Upsilon --- */
      {   7, 3798,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\xf0\xfc\xf0\x09\x13\x0e\x14\x04\x38\x00\x30\x00"
            "\x60\x00\x60\x00\xc0\x00\x80\x01\x00\x03\x00\x03\x00"
            "\x06\x00\x0c\x00\x18\x00\x18\x00\xfe\x01\x00" }  },
      /* --- pixel bitmap for cmmi180 char#8 \Phi --- */
      {   8, 3855,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x3f\x00\x03\x80\x01\x60\x00\xfe\xc0\x98\x19\x8c"
            "\x0d\xc3\x83\xe1\xc1\xf0\x60\xcc\x99\x81\x3f\x00\x06"
            "\x00\x03\xc0\x00\xfc\x03" }  },
      /* --- pixel bitmap for cmmi180 char#9 \Psi --- */
      {   9, 3924,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x1f\x00\x03\x00\x03\x87\xc1\x8c\x61\x8c\x31\x8c"
            "\x31\xc6\x18\xc6\x18\xc6\x0c\xc4\x0c\x6c\x07\xf0\x01"
            "\x60\x00\x60\x00\x30\x00\xfe\x01" }  },
      /* --- pixel bitmap for cmmi180 char#10 \Omega --- */
      {  10, 4001,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x3f\xc0\xc1\xc0\x00\xc3\x00\xcc\x00\x98\x01\x30"
            "\x03\x60\x06\x60\x0c\x40\x18\xc0\x30\xc0\x40\x80\x80"
            "\x80\x20\x81\x49\x02\x89\x07\x1f\x0f\x1e\x00" }  },
      /* --- pixel bitmap for cmmi180 char#11 \alpha --- */
      {  11, 4082,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x00\x23\x32\x4c\x83\x69\xb0\x06\xd6\xc0\x19\x18"
            "\x03\xc3\xd8\xf1\x30" }  },
      /* --- pixel bitmap for cmmi180 char#12 \beta --- */
      {  12, 4143,                      /* character number, location */
         17, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 13,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x0f\x10\x03\x41\x10\x08\x81\x21\x30\xf4\x43\x3e"
            "\x08\x0c\x01\x21\x20\x02\x46\xc0\x08\x18\x81\x51\x18"
            "\xf2\x40\x00\x08\x80\x00\x10\x00\x02\x00" }  },
      /* --- pixel bitmap for cmmi180 char#13 \gamma --- */
      {  13, 4228,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 13,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\xd0\x0f\x9d\xa1\x60\x02\x48\x00\x05\xa0\x00\x0c"
            "\x80\x01\x30\x00\x02\x40\x00\x08\x80\x00\x10\x00\x02" }  },
      /* --- pixel bitmap for cmmi180 char#14 \delta --- */
      {  14, 4285,                      /* character number, location */
         18, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\xe0\x43\x84\x00\x01\x06\x18\x38\xd8\x98\x19\x33"
            "\x36\x6c\xd8\xb0\x21\x26\x38\x00" }  },
      /* --- pixel bitmap for cmmi180 char#15 \epsilon --- */
      {  15, 4348,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xf0\x18\x0c\x06\x3e\x03\x03\x03\x02\x46\x38" }  },
      /* --- pixel bitmap for cmmi180 char#16 \zeta --- */
      {  16, 4379,                      /* character number, location */
         17, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 10,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x00\x01\x3c\xf8\x30\x60\x80\x00\x03\x06\x18\x60"
            "\xc0\x00\x03\x0c\x70\x80\x03\x3c\xe0\x01\x0c\x30\xc8"
            "\xc0\x01" }  },
      /* --- pixel bitmap for cmmi180 char#17 \eta --- */
      {  17, 4432,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 10,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe6\x75\xdc\x70\xc3\x0c\x1b\x66\x98\x61\x86\x0d\x33"
            "\x0c\x30\xc0\x80\x01\x06\x18" }  },
      /* --- pixel bitmap for cmmi180 char#18 \theta --- */
      {  18, 4499,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x60\x20\x21\x62\x4c\xd8\xb0\xe1\x61\xff\x86\x0d\x0b"
            "\x13\x26\x46\x84\x0d\x0e\x00" }  },
      /* --- pixel bitmap for cmmi180 char#19 \iota --- */
      {  19, 4568,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\xc3\x30\x8c\x61\x98\xd3\xe4\x00" }  },
      /* --- pixel bitmap for cmmi180 char#20 \kappa --- */
      {  20, 4603,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x63\x14\x13\x58\xc0\x01\x7f\x18\xc6\xb0\x86\x1d"
            "\xd4\x40\x00" }  },
      /* --- pixel bitmap for cmmi180 char#21 \lambda --- */
      {  21, 4658,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x00\x06\x60\x00\x0e\xc0\x00\x0c\xc0\x01\x18\x80"
            "\x01\x38\x40\x03\x32\x10\x87\x60\x0c\x66\xe0\x03\x0c" }  },
      /* --- pixel bitmap for cmmi180 char#22 \mu --- */
      {  22, 4713,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x84\x61\x18\x86\x61\x18\xc6\x30\x0c\xc3\xb0\x0c"
            "\xeb\x78\x7e\x66\x00\x06\x30\x00\x03\x30\x00" }  },
      /* --- pixel bitmap for cmmi180 char#23 \nu --- */
      {  23, 4778,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1e\x64\x30\x83\x19\xcc\x30\xc3\x18\xc2\x08\x26\xd8"
            "\xc0\x01\x00" }  },
      /* --- pixel bitmap for cmmi180 char#24 \xi --- */
      {  24, 4827,                      /* character number, location */
         17, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          {  9,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x80\x80\x87\x8f\x80\x01\x03\x06\xfc\xf0\x11\x30"
            "\x30\x60\xc0\x80\x01\x0e\x78\xc0\x03\x86\x0c\x0e" }  },
      /* --- pixel bitmap for cmmi180 char#25 \pi --- */
      {  25, 4880,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xef\xff\x93\x10\x09\x98\x80\x08\x88\xc0\x08\x8c"
            "\x61\x18\x86\x01" }  },
      /* --- pixel bitmap for cmmi180 char#26 \rho --- */
      {  26, 4931,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x01\x19\x8c\x30\x8c\x61\x86\x31\x8c\x61\x8c\x71"
            "\x86\x1d\x0c\x60\x80\x01\x0c\x60\x00" }  },
      /* --- pixel bitmap for cmmi180 char#27 \sigma --- */
      {  27, 4990,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x8f\xff\x8c\x61\x10\x06\x33\x18\x83\x31\x18\xc3"
            "\x20\x06\x3c\x00" }  },
      /* --- pixel bitmap for cmmi180 char#28 \tau --- */
      {  28, 5035,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xfb\x3f\x42\x0c\x10\x40\x80\x01\x06\x18\x30\xc0"
            "\x00" }  },
      /* --- pixel bitmap for cmmi180 char#29 \upsilon --- */
      {  29, 5068,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0e\x2a\xdc\x60\x83\x0c\x1a\x64\x90\x41\x86\x10\x81"
            "\x03" }  },
      /* --- pixel bitmap for cmmi180 char#30 \phi --- */
      {  30, 5123,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 13,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x20\x00\x04\x80\x00\x10\x00\x01\xf8\xc0\x24"
            "\x8c\xcc\x08\x19\xe1\x21\x36\xc4\x46\x88\x88\x21\x0d"
            "\xf8\x00\x02\x40\x00\x08\x00\x01\x10\x00" }  },
      /* --- pixel bitmap for cmmi180 char#31 \chi --- */
      {  31, 5210,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 14,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\xa0\x0e\x04\x83\xc0\x10\x60\x02\x58\x00\x16\x00"
            "\x03\xc0\x00\x38\x00\x1d\x20\x06\x84\x01\xe1\x20\xb0"
            "\x04\x18" }  },
      /* --- pixel bitmap for cmmi180 char#32 \psi --- */
      {  32, 5279,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 13,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x40\x00\x08\x00\x01\x10\x00\x82\x43\x54\xc8"
            "\x8d\xb0\x11\x32\x42\x43\x64\x84\x8c\x88\x11\x61\x1a"
            "\xf8\x00\x04\x80\x00\x10\x00\x01\x20\x00" }  },
      /* --- pixel bitmap for cmmi180 char#33 \omega --- */
      {  33, 5376,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0c\x90\x00\x1b\x40\x61\x28\x0c\xc3\x50\x18\x0a\x63"
            "\x73\xe6\xfb\x38\x06" }  },
      /* --- pixel bitmap for cmmi180 char#34 \varepsilon --- */
      {  34, 5439,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\xf8\x1b\x14\xe0\xc3\x47\x80\x00\x81\xfc\xf0\x00" }  },
      /* --- pixel bitmap for cmmi180 char#35 \vartheta --- */
      {  35, 5472,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x01\x11\x88\x20\x0c\x61\x10\x1b\xb9\x71\x0d\x6f"
            "\x18\xc3\x0c\x63\x18\x63\x18\xc1\x0c\x3c\x00" }  },
      /* --- pixel bitmap for cmmi180 char#36 \varpi --- */
      {  36, 5551,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\xff\xfb\xff\x3f\x01\x50\x02\x40\x08\x02\x11\x0c"
            "\x42\x10\x08\xe1\x30\xc4\x63\xf0\xf9\x80\xc3\x01" }  },
      /* --- pixel bitmap for cmmi180 char#37 \varrho --- */
      {  37, 5612,                      /* character number, location */
         11, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 10,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x40\x86\x11\xc3\x0c\x1b\x66\x98\x61\xc6\x94\x91"
            "\x43\x00\x01\xfc\xe0\x07\x10" }  },
      /* --- pixel bitmap for cmmi180 char#38 \varsigma --- */
      {  38, 5673,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf8\x0c\x02\x03\x03\x03\x03\x0e\x1c\x38\x60\x20\x18" }  },
      /* --- pixel bitmap for cmmi180 char#39 \varphi --- */
      {  39, 5706,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 13,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x87\xf0\x09\x63\x21\x28\x02\x43\x50\x08\x92\x20"
            "\x16\x87\x3f\xe0\x03\x0c\x80\x00\x18\x00\x03\x60\x00" }  },
      /* --- pixel bitmap for cmmi180 char#40 \leftharpoonup --- */
      {  40, 6604,                      /* character number, location */
         13, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x00\x08\x00\x00\x01\x00\x40\x00\x00\x08\x00"
            "\x80\x01\x00\xf0\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmi180 char#41 \leftharpoondown --- */
      {  41, 6625,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\xbf\x01\x00\x80\x00\x00\x40\x00\x00\x10\x00"
            "\x00\x08\x00\x00\x02\x00\x00" }  },
      /* --- pixel bitmap for cmmi180 char#42 \rightharpoonup --- */
      {  42, 6646,                      /* character number, location */
         13, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x00\x01\x00\x40\x00\x00\x20\x00\x00\x08\x00\x00"
            "\x04\x00\x00\xf6\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmi180 char#43 \rightharpoondown --- */
      {  43, 6667,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\xff\x3f\x00\x00\x06\x00\x40\x00\x00\x08\x00\x00"
            "\x02\x00\x40\x00\x00\x10\x00" }  },
      /* --- pixel bitmap for cmmi180 char#44 ` --- */
      {  44, 6688,                      /* character number, location */
         13, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2c\x11\x21\x0c" }  },
      /* --- pixel bitmap for cmmi180 char#45 ' --- */
      {  45, 6709,                      /* character number, location */
         13, 1,     6, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x43\x88\x48\x03" }  },
      /* --- pixel bitmap for cmmi180 char#46 \triangleright --- */
      {  46, 6730,                      /* character number, location */
         12, 0,     1, 0,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x38\x40\x06\xc2\x10\x98\x00\x07\x2c\x18\x31\x28"
            "\x40\x00\x00" }  },
      /* --- pixel bitmap for cmmi180 char#47 \triangleleft --- */
      {  47, 6775,                      /* character number, location */
         12, 0,     1, 0,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x04\x38\x30\x61\x48\xc0\x00\x1a\x10\x83\x60\x04"
            "\x2c\x80\x01" }  },
      /* --- pixel bitmap for cmmi180 char#48 \0 --- */
      {  48, 6098,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x7c\x8c\x0d\x1e\x3c\x78\xf0\xe0\xc1\x83\x8d\xf1\x01" }  },
      /* --- pixel bitmap for cmmi180 char#49 \1 --- */
      {  49, 6145,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  7,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x90\x0f\x06\x83\xc1\x60\x30\x18\xcc\x1f" }  },
      /* --- pixel bitmap for cmmi180 char#50 \2 --- */
      {  50, 6174,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x7c\x86\x0d\x06\x0c\x18\x18\x18\x88\x0c\xfd\xfd\x03" }  },
      /* --- pixel bitmap for cmmi180 char#51 \3 --- */
      {  51, 6211,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x88\x18\x33\x06\x0c\x18\x18\x1c\xc0\x00\x01\x1e"
            "\x3c\x38\x90\x30\x1e" }  },
      /* --- pixel bitmap for cmmi180 char#52 \4 --- */
      {  52, 6264,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\xc0\xc0\x81\x83\x06\x0d\x19\x33\x62\xc2\xfc\x07"
            "\x03\x06\x0c\x18\xfc" }  },
      /* --- pixel bitmap for cmmi180 char#53 \5 --- */
      {  53, 6315,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x82\xfc\xe8\x10\x20\x40\x80\x0e\x63\x82\x00\x03\x06"
            "\x3c\x38\x90\x10\x1e" }  },
      /* --- pixel bitmap for cmmi180 char#54 \6 --- */
      {  54, 6370,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x10\x12\x36\x2c\x60\xc0\x8e\x63\x83\x06\x0f\x1e"
            "\x2c\xd8\x10\x31\x1c" }  },
      /* --- pixel bitmap for cmmi180 char#55 \7 --- */
      {  55, 6433,                      /* character number, location */
         12, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x02\xf8\xef\x5f\x40\x81\x00\x01\x04\x08\x20\x40\x00"
            "\x01\x04\x18\x60\x80\x01\x06\x18\x00" }  },
      /* --- pixel bitmap for cmmi180 char#56 \8 --- */
      {  56, 6478,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x88\x18\x33\x66\xcc\x09\x1f\x1c\x64\x8c\x0d\x1e"
            "\x3c\x78\x90\x31\x1e" }  },
      /* --- pixel bitmap for cmmi180 char#57 \9 --- */
      {  57, 6541,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x38\x88\x08\x1b\x34\x78\xf0\x60\xc1\xc6\x71\x03\x06"
            "\x34\x6c\xc8\x18\x0e" }  },
      /* --- pixel bitmap for cmmi180 char#58 . --- */
      {  58, 6820,                      /* character number, location */
          3, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x00" }  },
      /* --- pixel bitmap for cmmi180 char#59 , --- */
      {  59, 6833,                      /* character number, location */
          3, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x49\x2a" }  },
      /* --- pixel bitmap for cmmi180 char#60 < --- */
      {  60, 6856,                      /* character number, location */
         14, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 14,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x20\x00\x06\x60\x00\x06\x60\x00\x06\x60\x00\x04"
            "\x00\x06\x00\x06\x00\x06\x00\x06\x00\x06\x00\x06\x00"
            "\x02" }  },
      /* --- pixel bitmap for cmmi180 char#61 / --- */
      {  61, 6893,                      /* character number, location */
         19, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  9,    25, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x02\x02\x04\x08\x08\x10\x20\x20\x40\x80\x80"
            "\x00\x01\x02\x02\x04\x08\x08\x10\x20\x20\x40\x80\x80"
            "\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmi180 char#62 > --- */
      {  62, 6950,                      /* character number, location */
         14, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 14,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01"
            "\x80\x00\x18\x80\x01\x18\x80\x01\x18\x80\x01\x10\x00"
            "\x00" }  },
      /* --- pixel bitmap for cmmi180 char#63 \star --- */
      {  63, 6987,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x00\x08\x00\x01\x20\x00\x04\x9e\x3c\xff\x01\x07"
            "\xa0\x00\x36\x60\x0c\x04\x41\x40\x00" }  },
      /* --- pixel bitmap for cmmi180 char#64 \partial --- */
      {  64, 5777,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x01\x62\x10\x84\xc1\x18\x08\x80\xe0\x89\xe1\x0c"
            "\x6e\xc0\x06\x3c\x60\x03\x36\x30\x02\x61\x0c\x7c\x00" }  },
      /* --- pixel bitmap for cmmi180 char#65 A --- */
      {  65,   35,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x18\x00\x18\x00\x1c\x00\x1c\x00\x1a\x00\x1b\x00"
            "\x19\x80\x18\x80\x38\x40\x30\x40\x30\xe0\x3f\x10\x30"
            "\x10\x30\x08\x30\x0c\x30\x3f\xfc" }  },
      /* --- pixel bitmap for cmmi180 char#66 B --- */
      {  66,  100,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7f\x80\x81\x03\x03\x06\x03\x0c\x06\x18\x0c\x30"
            "\x18\x30\x18\x38\xf0\x7f\x60\xc0\xc1\x00\xc3\x00\x86"
            "\x01\x0c\x03\x18\x06\x18\x06\x1c\xff\x0f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#67 C --- */
      {  67,  169,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x1f\x81\x41\xc3\x00\xc7\x00\xc4\x00\xc8\x00\x90"
            "\x01\x80\x01\x00\x03\x00\x06\x00\x0c\x00\x18\x00\x31"
            "\x00\x42\x00\x82\x01\x02\x06\x03\xf0\x01\x00" }  },
      /* --- pixel bitmap for cmmi180 char#68 D --- */
      {  68,  234,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7f\x00\x03\x07\x0c\x10\x18\xc0\x60\x00\x83\x01"
            "\x08\x06\x20\x0c\xc0\x30\x00\xc3\x00\x0c\x03\x10\x06"
            "\x60\x18\x80\x60\x00\x81\x01\x02\x03\x06\xff\x07\x00" }  },
      /* --- pixel bitmap for cmmi180 char#69 E --- */
      {  69,  305,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\x81\x01\x03\x03\x04\x03\x08\x06\x10\x0c\x22"
            "\x18\x04\x18\x04\xf0\x0f\x60\x10\xc0\x20\xc2\x20\x82"
            "\x01\x04\x03\x04\x06\x08\x06\x1c\xff\x1f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#70 F --- */
      {  70,  380,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xff\xc0\xc0\xc0\x80\x60\x80\x60\x80\x60\x88\x60"
            "\x08\x30\x04\xf0\x07\x30\x04\x30\x04\x18\x02\x18\x00"
            "\x18\x00\x18\x00\x0c\x00\x7f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#71 G --- */
      {  71,  443,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x1f\x81\x41\xc3\x00\xc7\x00\xc4\x00\xc8\x00\x90"
            "\x01\x80\x01\x00\x03\x00\x06\xf8\x0f\x80\x19\x80\x31"
            "\x00\x43\x00\x86\x01\x0c\x06\x0e\xf0\x13\x00" }  },
      /* --- pixel bitmap for cmmi180 char#72 H --- */
      {  72,  514,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xc7\x1f\x18\x60\x00\x03\x0c\x30\xc0\x00\x06\x18"
            "\xc0\x00\x03\x18\x60\x80\x01\x06\xf0\xff\x00\x06\x18"
            "\xc0\x00\x03\x0c\x30\x80\x01\x06\x30\xc0\x00\x06\x18"
            "\x60\x80\x01\x7f\xfc\x01" }  },
      /* --- pixel bitmap for cmmi180 char#73 I --- */
      {  73,  587,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x07\x06\x30\xc0\x00\x06\x30\x80\x01\x06\x30\x80"
            "\x01\x0c\x30\x80\x01\x0c\x60\x80\x01\x7f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#74 J --- */
      {  74,  628,                      /* character number, location */
         17, 3,     0, 3,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x0f\x30\x00\x03\x18\x80\x01\x18\x80\x01\x0c\xc0"
            "\x00\x0c\xc0\x00\x06\x60\x10\x06\x33\x10\x03\x0e\x00" }  },
      /* --- pixel bitmap for cmmi180 char#75 K --- */
      {  75,  675,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 20,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xc7\x0f\x0c\x18\xc0\x80\x00\x06\x02\x60\x10\x00"
            "\x86\x00\x60\x04\x00\x63\x00\xb0\x0c\x00\xc7\x00\x30"
            "\x08\x80\x81\x01\x18\x18\x80\x01\x03\x18\x30\xc0\x00"
            "\x06\x7f\xf8\x01" }  },
      /* --- pixel bitmap for cmmi180 char#76 L --- */
      {  76,  752,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x07\x30\x00\x0c\x80\x01\x60\x00\x18\x00\x06\xc0"
            "\x00\x30\x00\x0c\x00\x03\x60\x80\x18\x20\x06\x84\x01"
            "\x31\x70\xff\x0f" }  },
      /* --- pixel bitmap for cmmi180 char#77 M --- */
      {  77,  803,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 25,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x01\xf8\x81\x03\x70\x00\x07\xd0\x00\x0d\xe0\x00"
            "\x1a\xa0\x01\x34\x20\x03\xc8\x40\x06\x88\x41\x06\x10"
            "\x43\x0c\x20\x86\x18\x40\x8c\x30\x40\x98\x30\x80\x30"
            "\x61\x00\xc1\xc1\x00\x82\x83\x01\x06\x83\x01\x3f\xc2"
            "\x1f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#78 N --- */
      {  78,  926,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x80\x1f\x38\x40\x00\x07\x08\xd0\x80\x00\x32\x10"
            "\x40\x06\x02\x88\x41\x80\x30\x04\x10\x8c\x00\x82\x11"
            "\x40\x30\x02\x04\x2c\x80\x80\x05\x10\xe0\x00\x02\x1c"
            "\x60\x00\x01\x3f\x20\x00" }  },
      /* --- pixel bitmap for cmmi180 char#79 O --- */
      {  79, 1021,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x1f\xe0\x30\x30\x60\x18\xc0\x0c\xc0\x06\x80\x06"
            "\xc0\x03\xc0\x03\xc0\x03\xc0\x03\x60\x03\x60\x03\x30"
            "\x03\x18\x06\x0c\x0c\x06\xf8\x01" }  },
      /* --- pixel bitmap for cmmi180 char#80 P --- */
      {  80, 1092,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x7f\x80\x81\x01\x03\x06\x03\x0c\x06\x18\x0c\x30"
            "\x18\x30\x18\x30\xf0\x1f\x60\x00\xc0\x00\xc0\x00\x80"
            "\x01\x00\x03\x00\x06\x00\x06\x00\x7f\x00\x00" }  },
      /* --- pixel bitmap for cmmi180 char#81 Q --- */
      {  81, 1147,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 16,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x1f\xe0\x30\x30\x60\x18\xc0\x0c\xc0\x06\xc0\x06"
            "\xc0\x03\xc0\x03\xc0\x03\xc0\x03\x60\x03\x60\x03\x30"
            "\xc3\x10\x26\x0d\x1c\x07\xf8\x21\x00\x21\x00\x31\x00"
            "\x11\x00\x0f\x00\x06" }  },
      /* --- pixel bitmap for cmmi180 char#82 R --- */
      {  82, 1242,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x3f\x80\xc1\x00\x03\x03\x03\x06\x06\x0c\x0c\x18"
            "\x18\x18\x18\x18\xf0\x0f\x60\x30\xc0\x60\xc0\xc0\x80"
            "\x81\x01\x03\x03\x06\x46\x06\x4c\x7f\x70\x00" }  },
      /* --- pixel bitmap for cmmi180 char#83 S --- */
      {  83, 1317,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x27\x18\x0e\x03\x43\x40\x18\x10\x06\x80\x03\xc0"
            "\x0f\xe0\x07\xc0\x03\xc0\x00\x30\x02\x8c\x00\x23\x60"
            "\x1c\x0c\xf9\x00" }  },
      /* --- pixel bitmap for cmmi180 char#84 T --- */
      {  84, 1378,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfe\xff\x06\xc3\x02\xc3\x81\x41\x81\x41\x81\x41\x80"
            "\x01\xc0\x00\xc0\x00\xc0\x00\xc0\x00\x60\x00\x60\x00"
            "\x60\x00\x60\x00\x30\x00\xfe\x03" }  },
      /* --- pixel bitmap for cmmi180 char#85 U --- */
      {  85, 1439,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfe\xf0\x63\x00\x81\x01\x04\x03\x08\x0c\x20\x30\x80"
            "\xc0\x00\x82\x01\x04\x06\x10\x18\x40\x60\x00\xc1\x00"
            "\x02\x03\x08\x0c\x10\x60\x60\x00\x41\x00\xf8\x00\x00" }  },
      /* --- pixel bitmap for cmmi180 char#86 V --- */
      {  86, 1512,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xf8\x19\x40\x30\x40\x60\x80\xc0\x80\x80\x01\x01"
            "\x03\x01\x06\x01\x1c\x02\x30\x02\x60\x06\xc0\x04\x80"
            "\x05\x00\x0b\x00\x0e\x00\x0c\x00\x18\x00\x00" }  },
      /* --- pixel bitmap for cmmi180 char#87 W --- */
      {  87, 1581,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 24,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xfe\xfc\x0e\x18\x30\x0c\x1c\x10\x0c\x1e\x08\x0c"
            "\x1a\x08\x0c\x19\x04\x0c\x19\x04\x8c\x18\x02\x8c\x18"
            "\x01\x4c\x18\x01\x4c\xb0\x00\x2c\xb0\x00\x2c\x70\x00"
            "\x1c\x70\x00\x1c\x30\x00\x0c\x30\x00\x04\x10\x00" }  },
      /* --- pixel bitmap for cmmi180 char#88 X --- */
      {  88, 1698,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\xe7\x07\x0e\x0c\x60\x30\x00\xc3\x00\x30\x02\x80"
            "\x09\x00\x3c\x00\xc0\x00\x00\x06\x00\x68\x00\x20\x03"
            "\x80\x39\x00\x86\x01\x10\x0c\x40\xc0\x80\x01\x06\x3f"
            "\xfc\x00" }  },
      /* --- pixel bitmap for cmmi180 char#89 Y --- */
      {  89, 1767,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3f\xf8\x19\x40\x30\x40\xe0\x40\x80\x41\x00\xc3\x00"
            "\x8e\x00\x98\x00\xb0\x00\xe0\x00\x80\x01\x80\x01\x00"
            "\x03\x00\x06\x00\x0c\x00\x0c\x00\xfe\x00\x00" }  },
      /* --- pixel bitmap for cmmi180 char#90 Z --- */
      {  90, 1826,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\xff\x60\x60\x20\x30\x30\x30\x10\x18\x10\x0c\x00"
            "\x06\x00\x03\x80\x01\xc0\x00\x60\x20\x70\x10\x30\x10"
            "\x18\x10\x0c\x18\x06\x0c\xff\x0f" }  },
      /* --- pixel bitmap for cmmi180 char#91 \flat --- */
      {  91, 7034,                      /* character number, location */
         19, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    19, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x81\x40\x20\x10\x08\x04\x02\xbf\x71\x38\x1c\x8e\xc5"
            "\x32\x8d\x43\x00" }  },
      /* --- pixel bitmap for cmmi180 char#92 \natural --- */
      {  92, 7095,                      /* character number, location */
         18, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  7,    23, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x81\x40\x20\x10\x08\xf7\xbf\xc3\x60\x30\x18\x0c\x06"
            "\x83\xe1\xfe\x77\x08\x04\x02\x01" }  },
      /* --- pixel bitmap for cmmi180 char#93 \sharp --- */
      {  93, 7178,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  7,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x91\x48\x24\xf6\xff\x46\x22\x91\x48\x24\x12\x89"
            "\xc4\xfe\xdf\x48\x24\x12\x00" }  },
      /* --- pixel bitmap for cmmi180 char#94 \smile --- */
      {  94, 7261,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 22,     6, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x00\xa0\x00\x00\xc4\x00\xc0\xe0\x00\x1c\xe0\xff"
            "\x01\xe0\x1f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#95 \frown --- */
      {  95, 7288,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 22,     6, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\xff\x00\xfc\xff\x80\x01\x60\x10\x00\x20\x02\x00"
            "\x50\x00\x00\x08" }  },
      /* --- pixel bitmap for cmmi180 char#96 \ell --- */
      {  96, 5846,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x80\x82\x05\x05\x0b\x16\x1c\x2c\x38\x30\x60\x40"
            "\xc0\x40\x41\x02\x44\x70\x00" }  },
      /* --- pixel bitmap for cmmi180 char#97 a --- */
      {  97, 1889,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\x21\xc6\x98\x61\x86\x0d\x33\xcc\xb0\xc3\x8a\xc7"
            "\x19" }  },
      /* --- pixel bitmap for cmmi180 char#98 b --- */
      {  98, 1944,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1e\x30\x60\x60\xc0\x80\x01\x1f\x67\x86\x0c\x1b\x1e"
            "\x36\x6c\xd8\x18\x19\x1c\x00" }  },
      /* --- pixel bitmap for cmmi180 char#99 c --- */
      {  99, 2003,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\x30\x32\x36\x60\x60\xc0\x80\x01\x03\x8d\xf1\x00" }  },
      /* --- pixel bitmap for cmmi180 char#100 d --- */
      { 100, 2040,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x07\x30\x80\x01\x06\x30\x80\xc1\x0d\x31\x8c\x31"
            "\x8c\x61\x86\x31\x8c\x61\x0d\x4b\x3c\x9c\x01" }  },
      /* --- pixel bitmap for cmmi180 char#101 e --- */
      { 101, 2107,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\x30\x32\x34\xe8\x6f\xc0\x80\x01\x02\x8d\xf1\x00" }  },
      /* --- pixel bitmap for cmmi180 char#102 f --- */
      { 102, 2146,                      /* character number, location */
         17, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 11,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x03\x34\xb0\x80\x01\x0c\x60\xe0\x0f\x0c\x60\x00"
            "\x03\x18\x60\x00\x03\x18\xc0\x00\x06\x18\xc0\x00\x06"
            "\x14\xb0\x00\x03\x00" }  },
      /* --- pixel bitmap for cmmi180 char#103 g --- */
      { 103, 2205,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 10,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x42\x8c\x31\xc3\x0c\x1b\x66\x98\x61\x86\x11\x83"
            "\x0f\x30\xc0\x88\x31\x83\x07" }  },
      /* --- pixel bitmap for cmmi180 char#104 h --- */
      { 104, 2268,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3c\x80\x01\x0c\x30\x80\x01\x0c\xe0\x87\x63\x0c\x63"
            "\x18\xc3\x0c\x63\x18\xc3\x1a\x73\x58\x83\x01" }  },
      /* --- pixel bitmap for cmmi180 char#105 i --- */
      { 105, 2335,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    17, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x10\x02\x00\x80\x53\xad\x31\x63\xec\x5c\x06" }  },
      /* --- pixel bitmap for cmmi180 char#106 j --- */
      { 106, 2382,                      /* character number, location */
         17,-1,    -5,-1,     /* topleft row,col, and botleft row,col */
          { 10,    22, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x0c\x00\x00\x00\x00\x00\x0c\x68\x90\x41\x06"
            "\x18\x30\xc0\x00\x03\x0c\x18\x60\x80\x01\x86\x0c\x13"
            "\x38\x00" }  },
      /* --- pixel bitmap for cmmi180 char#107 k --- */
      { 107, 2437,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3c\xc0\x00\x03\x06\x18\x60\x80\x31\xb3\x4c\xb3\xc0"
            "\x81\x1f\xc6\x18\x6b\xec\x50\x83\x00" }  },
      /* --- pixel bitmap for cmmi180 char#108 l --- */
      { 108, 2506,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    17, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x1e\x63\xc6\x18\x33\xc6\x98\x31\xd6\x3a\x06" }  },
      /* --- pixel bitmap for cmmi180 char#109 m --- */
      { 109, 2551,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc6\xe3\x69\xb1\x58\x87\xc3\x1a\x0c\xc6\x60\x30\x83"
            "\xc1\x18\x0c\xc6\x60\xb0\x06\xc3\x1c\x0c\xd6\x60\x60"
            "\x00" }  },
      /* --- pixel bitmap for cmmi180 char#110 n --- */
      { 110, 2640,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc6\xd3\x62\x1d\xd6\x60\x0c\x66\x30\x06\x63\xb0\x86"
            "\x39\x58\x03\x03" }  },
      /* --- pixel bitmap for cmmi180 char#111 o --- */
      { 111, 2705,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x60\xc6\x90\xc1\x06\x0f\x36\xd8\x60\xc3\x88\xc1"
            "\x01" }  },
      /* --- pixel bitmap for cmmi180 char#112 p --- */
      { 112, 2752,                      /* character number, location */
         11,-2,    -5,-2,     /* topleft row,col, and botleft row,col */
          { 13,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x30\x07\x9d\xa1\x21\x34\x0c\x86\x61\x18\x0c\x83\x61"
            "\x30\x06\x67\x60\x07\x0c\x80\x01\x18\x00\x03\xf8\x01" }  },
      /* --- pixel bitmap for cmmi180 char#113 q --- */
      { 113, 2819,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 10,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\x22\xc6\x98\x61\x86\x0d\x33\xcc\x30\xc3\x88\xc1"
            "\x07\x18\x60\xc0\x00\x03\x3f" }  },
      /* --- pixel bitmap for cmmi180 char#114 r --- */
      { 114, 2878,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xe6\x9d\xcd\x0d\x0c\x06\x06\x06\x06\x03\x03" }  },
      /* --- pixel bitmap for cmmi180 char#115 s --- */
      { 115, 2919,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x78\x8c\xc6\x06\x3e\x7c\x60\x61\x63\x31\x1e" }  },
      /* --- pixel bitmap for cmmi180 char#116 t --- */
      { 116, 2958,                      /* character number, location */
         15, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x0c\x06\xf3\x67\x30\x18\x0c\x83\xc1\x64\xb2\x30"
            "\x00" }  },
      /* --- pixel bitmap for cmmi180 char#117 u --- */
      { 117, 3001,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0e\x52\x58\xc3\x1a\xc6\x30\xc3\x18\xc6\xb0\x86\x35"
            "\x1e\xcf\x00" }  },
      /* --- pixel bitmap for cmmi180 char#118 v --- */
      { 118, 3062,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x0e\x15\x37\x6c\xc8\xd0\x90\x21\x43\x46\x8c\xf0\x00" }  },
      /* --- pixel bitmap for cmmi180 char#119 w --- */
      { 119, 3117,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0e\x42\x85\x71\xc3\xb0\x61\xc8\x30\x34\x0c\x19\x86"
            "\x0c\x43\x86\x11\xe2\x08\xce\x03" }  },
      /* --- pixel bitmap for cmmi180 char#120 x --- */
      { 120, 3194,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\x86\x9c\xc4\x4c\x0c\xc0\x00\x06\x60\x00\x46\x62"
            "\x32\x27\xce\x01" }  },
      /* --- pixel bitmap for cmmi180 char#121 y --- */
      { 121, 3247,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 10,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0e\x2a\xdc\x70\xc3\x0c\x1b\x66\x98\x61\x86\x19\xc3"
            "\x0f\x30\x62\x8c\x11\x83\x03" }  },
      /* --- pixel bitmap for cmmi180 char#122 z --- */
      { 122, 3318,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x30\xe2\x47\x08\x10\x20\x40\x80\x00\x41\x84\xf8\x13"
            "\x07" }  },
      /* --- pixel bitmap for cmmi180 char#123 \imath --- */
      { 123, 5905,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\xb5\xc6\x8c\xb1\x73\x19" }  },
      /* --- pixel bitmap for cmmi180 char#124 \jmath --- */
      { 124, 5946,                      /* character number, location */
         11,-1,    -5,-1,     /* topleft row,col, and botleft row,col */
          {  9,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x40\x43\x86\x0c\x18\x18\x30\x60\xc0\xc0\x80\x01"
            "\x03\x46\xc6\x04\x07" }  },
      /* --- pixel bitmap for cmmi180 char#125 \wp --- */
      { 125, 5995,                      /* character number, location */
         11, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\xc0\x78\x66\x6c\x81\x0e\x78\xc0\x07\x3c\xc0\x27"
            "\x76\x32\xcd\xd1\x01\x19\xd0\x00\x0d\x70\x00" }  },
      /* --- pixel bitmap for cmmi180 char#126 \vec --- */
      { 126, 6072,                      /* character number, location */
         17, 5,    14, 5,     /* topleft row,col, and botleft row,col */
          {  9,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x80\xfe\x03\x01" }  },
      /* --- pixel bitmap for cmmi180 char#127 (noname) --- */
      { 127, 6085,                      /* character number, location */
         16, 6,    14, 6,     /* topleft row,col, and botleft row,col */
          {  8,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7c\x82" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;



/* --------------------------------------------------------------------------
font sizes 0-5 for cmmib10  \mathbf{}
-------------------------------------------------------------------------- */

/* --- size=0 ---
 * mf '\mode=eighthre; input cmmib10'   gives .gf83
 * ------------------------------------------------ */
/* --- fontdef for cmmib83 --- */
static	chardef  cmmib83[] =
   {
      /* --- pixel bitmap for cmmib83 char#0 \Gamma --- */
      {   0, 1593,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x31\x33\x62\xc0\x80\x81\x81\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#1 \Delta --- */
      {   1, 1620,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\xc0\x81\x83\x86\x9c\x30\x7f\xff" }  },
      /* --- pixel bitmap for cmmib83 char#2 \Theta --- */
      {   2, 1649,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xb3\xf8\xff\x1f\xcd\x1c" }  },
      /* --- pixel bitmap for cmmib83 char#3 \Lambda --- */
      {   3, 1680,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x60\x60\x70\x70\x68\x6c\x64\xf7" }  },
      /* --- pixel bitmap for cmmib83 char#4 \Xi --- */
      {   4, 1711,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xf1\x13\xc2\x83\x47\xe0\xbf\x7f" }  },
      /* --- pixel bitmap for cmmib83 char#5 \Pi --- */
      {   5, 1738,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xc7\x18\x63\x18\xc3\x18\xc6\x18\xe3\x3d" }  },
      /* --- pixel bitmap for cmmib83 char#6 \Sigma --- */
      {   6, 1775,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x39\x63\xc2\x01\x03\x13\x11\x3f" }  },
      /* --- pixel bitmap for cmmib83 char#7 \Upsilon --- */
      {   7, 1806,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb7\x3b\x83\xc1\x60\x18\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#8 \Phi --- */
      {   8, 1833,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\x98\x6f\xbf\xf7\x31\x7c" }  },
      /* --- pixel bitmap for cmmib83 char#9 \Psi --- */
      {   9, 1860,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\xd8\x7e\xbf\xf7\x31\x3c" }  },
      /* --- pixel bitmap for cmmib83 char#10 \Omega --- */
      {  10, 1889,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xcc\xc6\xc6\x46\xe6\x67\x77" }  },
      /* --- pixel bitmap for cmmib83 char#11 \alpha --- */
      {  11, 1926,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6e\x1c\x65\x27" }  },
      /* --- pixel bitmap for cmmib83 char#12 \beta --- */
      {  12, 1953,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xa2\xc8\x23\x12\x4d\x1e\x81\x00" }  },
      /* --- pixel bitmap for cmmib83 char#13 \gamma --- */
      {  13, 1990,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x36\x63\x84\x10\x02" }  },
      /* --- pixel bitmap for cmmib83 char#14 \delta --- */
      {  14, 2015,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9c\x10\x93\x52\x39" }  },
      /* --- pixel bitmap for cmmib83 char#15 \epsilon --- */
      {  15, 2044,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1e\x17\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#16 \zeta --- */
      {  16, 2061,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x84\x8b\x10\x42\x18\xc4\x00" }  },
      /* --- pixel bitmap for cmmib83 char#17 \eta --- */
      {  17, 2088,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xdb\x29\x46\x11\x04\x01" }  },
      /* --- pixel bitmap for cmmib83 char#18 \theta --- */
      {  18, 2119,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x4c\xca\xff\x53\x32" }  },
      /* --- pixel bitmap for cmmib83 char#19 \iota --- */
      {  19, 2150,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x92\x7a" }  },
      /* --- pixel bitmap for cmmib83 char#20 \kappa --- */
      {  20, 2169,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb2\xe3\xc5\x21" }  },
      /* --- pixel bitmap for cmmib83 char#21 \lambda --- */
      {  21, 2192,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x86\x20\x84\xa8\x8c" }  },
      /* --- pixel bitmap for cmmib83 char#22 \mu --- */
      {  22, 2221,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa2\x28\xc6\x6f\x10\x00" }  },
      /* --- pixel bitmap for cmmib83 char#23 \nu --- */
      {  23, 2252,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa3\x28\x35\x03" }  },
      /* --- pixel bitmap for cmmib83 char#24 \xi --- */
      {  24, 2277,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x88\x0b\xc1\x44\x10\xcc\x01" }  },
      /* --- pixel bitmap for cmmib83 char#25 \pi --- */
      {  25, 2304,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\xa2\x28\x09" }  },
      /* --- pixel bitmap for cmmib83 char#26 \rho --- */
      {  26, 2329,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9c\x28\x4e\x4f\x10\x00" }  },
      /* --- pixel bitmap for cmmib83 char#27 \sigma --- */
      {  27, 2356,                      /* character number, location */
          5, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7e\x92\x14\x03" }  },
      /* --- pixel bitmap for cmmib83 char#28 \tau --- */
      {  28, 2379,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7e\x41\x08\x02" }  },
      /* --- pixel bitmap for cmmib83 char#29 \upsilon --- */
      {  29, 2398,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xd3\x28\x46\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#30 \phi --- */
      {  30, 2423,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x08\xc2\x97\x4c\x96\x3c\x04\x02" }  },
      /* --- pixel bitmap for cmmib83 char#31 \chi --- */
      {  31, 2462,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x42\x13\x06\x41\x11\x85\x01" }  },
      /* --- pixel bitmap for cmmib83 char#32 \psi --- */
      {  32, 2493,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x08\x64\xb5\x54\xaa\x3c\x04\x02" }  },
      /* --- pixel bitmap for cmmib83 char#33 \omega --- */
      {  33, 2536,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa2\x64\xb2\xb5\x01" }  },
      /* --- pixel bitmap for cmmib83 char#34 \varepsilon --- */
      {  34, 2569,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x2c\x12\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#35 \vartheta --- */
      {  35, 2586,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x8a\xee\xa3\x14\x39" }  },
      /* --- pixel bitmap for cmmib83 char#36 \varpi --- */
      {  36, 2621,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x8f\x24\x52\x2c\x6e\x00" }  },
      /* --- pixel bitmap for cmmib83 char#37 \varrho --- */
      {  37, 2652,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9c\x28\x4e\x4f\xe0\x00" }  },
      /* --- pixel bitmap for cmmib83 char#38 \varsigma --- */
      {  38, 2679,                      /* character number, location */
          5, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x4e\x46\x01" }  },
      /* --- pixel bitmap for cmmib83 char#39 \varphi --- */
      {  39, 2698,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb2\x64\xb2\xe4\x21\x10\x00" }  },
      /* --- pixel bitmap for cmmib83 char#40 \leftharpoonup --- */
      {  40, 3124,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 10,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x04\x18\xf0\x3f" }  },
      /* --- pixel bitmap for cmmib83 char#41 \leftharpoondown --- */
      {  41, 3137,                      /* character number, location */
          3, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\x1b\x40\x00" }  },
      /* --- pixel bitmap for cmmib83 char#42 \rightharpoonup --- */
      {  42, 3150,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 10,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x00\xf6\x3f" }  },
      /* --- pixel bitmap for cmmib83 char#43 \rightharpoondown --- */
      {  43, 3163,                      /* character number, location */
          3, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\x03\x06\x08" }  },
      /* --- pixel bitmap for cmmib83 char#44 ` --- */
      {  44, 3176,                      /* character number, location */
          7, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#45 ' --- */
      {  45, 3193,                      /* character number, location */
          7, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#46 \triangleright --- */
      {  46, 3210,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x71\x79\x01" }  },
      /* --- pixel bitmap for cmmib83 char#47 \triangleleft --- */
      {  47, 3229,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe8\xe9\x08" }  },
      /* --- pixel bitmap for cmmib83 char#48 \0 --- */
      {  48, 2892,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x5e\x18\x86\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#49 \1 --- */
      {  49, 2915,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x93\x74" }  },
      /* --- pixel bitmap for cmmib83 char#50 \2 --- */
      {  50, 2932,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x97\xe8\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#51 \3 --- */
      {  51, 2951,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa6\x31\x87\xb7\x03" }  },
      /* --- pixel bitmap for cmmib83 char#52 \4 --- */
      {  52, 2976,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x67\x4d\x3f\x84\x03" }  },
      /* --- pixel bitmap for cmmib83 char#53 \5 --- */
      {  53, 3001,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\x71\xdc\x06" }  },
      /* --- pixel bitmap for cmmib83 char#54 \6 --- */
      {  54, 3024,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1e\x71\x99\x06" }  },
      /* --- pixel bitmap for cmmib83 char#55 \7 --- */
      {  55, 3049,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3f\x22\x22\x84\x00" }  },
      /* --- pixel bitmap for cmmib83 char#56 \8 --- */
      {  56, 3072,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x96\xef\x9d\x06" }  },
      /* --- pixel bitmap for cmmib83 char#57 \9 --- */
      {  57, 3099,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x96\xe9\x88\x07" }  },
      /* --- pixel bitmap for cmmib83 char#58 . --- */
      {  58, 3248,                      /* character number, location */
          2, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#59 , --- */
      {  59, 3259,                      /* character number, location */
          2, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  2,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6f" }  },
      /* --- pixel bitmap for cmmib83 char#60 < --- */
      {  60, 3274,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x18\xc2\x10\x30\x20\x60\x40" }  },
      /* --- pixel bitmap for cmmib83 char#61 / --- */
      {  61, 3299,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x88\x44\x44\x22\x22\x11" }  },
      /* --- pixel bitmap for cmmib83 char#62 > --- */
      {  62, 3330,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x03\x02\x06\x84\x21\x0c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#63 \star --- */
      {  63, 3355,                      /* character number, location */
          3,-1,     1,-1,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x06" }  },
      /* --- pixel bitmap for cmmib83 char#64 \partial --- */
      {  64, 2733,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x09\xfa\x61\x14\x3d" }  },
      /* --- pixel bitmap for cmmib83 char#65 A --- */
      {  65,   35,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\xc0\x80\x81\x83\x06\x1f\xb1\xf3" }  },
      /* --- pixel bitmap for cmmib83 char#66 B --- */
      {  66,   64,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x30\x33\xe3\xc7\x8c\x99\x99\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#67 C --- */
      {  67,   97,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xc4\x46\x03\x03\x43\x23\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#68 D --- */
      {  68,  128,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x30\x33\x66\xcc\x98\x91\xb1\x3f" }  },
      /* --- pixel bitmap for cmmib83 char#69 E --- */
      {  69,  163,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x31\xb3\xe2\xc1\x92\xa1\xa1\x7f" }  },
      /* --- pixel bitmap for cmmib83 char#70 F --- */
      {  70,  200,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x31\xb3\xe2\xc1\x82\x81\x81\x07" }  },
      /* --- pixel bitmap for cmmib83 char#71 G --- */
      {  71,  231,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xc4\x46\x03\xfb\x63\x33\x3e" }  },
      /* --- pixel bitmap for cmmib83 char#72 H --- */
      {  72,  264,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\xc7\x18\x63\xf8\xc3\x18\xc6\x18\xe3\x3d" }  },
      /* --- pixel bitmap for cmmib83 char#73 I --- */
      {  73,  301,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xc6\x30\x0c\x63\x3c" }  },
      /* --- pixel bitmap for cmmib83 char#74 J --- */
      {  74,  324,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x60\x30\x30\x30\x30\x1b\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#75 K --- */
      {  75,  349,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\xc7\x04\x1b\x78\xc0\x06\x36\x98\xe1\x39" }  },
      /* --- pixel bitmap for cmmib83 char#76 L --- */
      {  76,  386,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x18\x0c\x0c\x8c\x8c\x46\x7f" }  },
      /* --- pixel bitmap for cmmib83 char#77 M --- */
      {  77,  415,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x3c\x8e\x46\xe3\xd0\x34\xb4\x0c\x39\x23\x66\x9c"
            "\x3c" }  },
      /* --- pixel bitmap for cmmib83 char#78 N --- */
      {  78,  472,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xc7\x11\x5d\xc8\x42\x1e\xe2\x08\xe3\x10" }  },
      /* --- pixel bitmap for cmmib83 char#79 O --- */
      {  79,  515,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xb3\x78\x3c\x1e\xcd\x1c" }  },
      /* --- pixel bitmap for cmmib83 char#80 P --- */
      {  80,  550,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x98\xcc\xcc\x7c\x0c\x06\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#81 Q --- */
      {  81,  579,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xb3\x78\x3c\x1e\xfd\x1c\x30\x08" }  },
      /* --- pixel bitmap for cmmib83 char#82 R --- */
      {  82,  616,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x30\x33\xe3\xc3\x8c\x99\x99\xe7" }  },
      /* --- pixel bitmap for cmmib83 char#83 S --- */
      {  83,  651,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\x6b\x38\x1c\xd6\x1c" }  },
      /* --- pixel bitmap for cmmib83 char#84 T --- */
      {  84,  678,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x65\x67\xc2\x80\x01\x03\x03\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#85 U --- */
      {  85,  709,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcf\x0d\x0d\x19\x32\x64\xc8\x08\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#86 V --- */
      {  86,  746,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcf\x8d\x98\x70\xc1\x81\x03\x03\x02" }  },
      /* --- pixel bitmap for cmmib83 char#87 W --- */
      {  87,  777,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xef\xdd\x9c\x98\x1b\x6b\x61\x1d\x9c\x83\x31\x20\x06" }  },
      /* --- pixel bitmap for cmmib83 char#88 X --- */
      {  88,  828,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\xc3\x02\x07\x1c\x70\xe0\x81\xc6\x7b" }  },
      /* --- pixel bitmap for cmmib83 char#89 Y --- */
      {  89,  859,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcf\x99\xb0\xe0\x81\x01\x03\x03\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#90 Z --- */
      {  90,  888,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\x9a\x0e\xc3\x72\x59\x3e" }  },
      /* --- pixel bitmap for cmmib83 char#91 \flat --- */
      {  91, 3366,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x55\xff\x01" }  },
      /* --- pixel bitmap for cmmib83 char#92 \natural --- */
      {  92, 3391,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x11\xbd\x99\xd9\x8b" }  },
      /* --- pixel bitmap for cmmib83 char#93 \sharp --- */
      {  93, 3432,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  2,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#94 \smile --- */
      {  94, 3459,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 10,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x0a\xc4\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#95 \frown --- */
      {  95, 3476,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 10,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x08\x14\x20" }  },
      /* --- pixel bitmap for cmmib83 char#96 \ell --- */
      {  96, 2764,                      /* character number, location */
          8,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x4a\x51\x0c\x61\xe0" }  },
      /* --- pixel bitmap for cmmib83 char#97 a --- */
      {  97,  921,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3e\xc6\x7c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#98 b --- */
      {  98,  946,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x43\x84\x17\x63\x3a" }  },
      /* --- pixel bitmap for cmmib83 char#99 c --- */
      {  99,  975,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9e\x11\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#100 d --- */
      { 100,  994,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x08\x79\x51\x94\x5d" }  },
      /* --- pixel bitmap for cmmib83 char#101 e --- */
      { 101, 1025,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x2e\xbe\xf0\x00" }  },
      /* --- pixel bitmap for cmmib83 char#102 f --- */
      { 102, 1044,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x98\x10\x47\x88\x10\x22\x00" }  },
      /* --- pixel bitmap for cmmib83 char#103 g --- */
      { 103, 1071,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3e\xc6\xf4\xd0\x01" }  },
      /* --- pixel bitmap for cmmib83 char#104 h --- */
      { 104, 1098,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\x21\x68\xa6\x18\xc7" }  },
      /* --- pixel bitmap for cmmib83 char#105 i --- */
      { 105, 1131,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x04\xb0\x69\x03" }  },
      /* --- pixel bitmap for cmmib83 char#106 j --- */
      { 106, 1152,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x00\xc0\x14\x22\x84\x0c" }  },
      /* --- pixel bitmap for cmmib83 char#107 k --- */
      { 107, 1179,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\x21\xc8\xae\x93\x45" }  },
      /* --- pixel bitmap for cmmib83 char#108 l --- */
      { 108, 1210,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa6\x24\x4d" }  },
      /* --- pixel bitmap for cmmib83 char#109 m --- */
      { 109, 1233,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xdb\x4e\x8a\x8c\x1c\x19" }  },
      /* --- pixel bitmap for cmmib83 char#110 n --- */
      { 110, 1270,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6f\xca\x9c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#111 o --- */
      { 111, 1295,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x5e\x18\x46\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#112 p --- */
      { 112, 1318,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3e\x23\xd1\xe4\x11\x0c\x00" }  },
      /* --- pixel bitmap for cmmib83 char#113 q --- */
      { 113, 1345,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3e\xc6\xf4\x10\x03" }  },
      /* --- pixel bitmap for cmmib83 char#114 r --- */
      { 114, 1372,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbf\x12\x01" }  },
      /* --- pixel bitmap for cmmib83 char#115 s --- */
      { 115, 1391,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcc\x8c\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#116 t --- */
      { 116, 1408,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xd4\xa5\x09" }  },
      /* --- pixel bitmap for cmmib83 char#117 u --- */
      { 117, 1429,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x73\xca\x6c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#118 v --- */
      { 118, 1456,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x73\xca\x64\x00" }  },
      /* --- pixel bitmap for cmmib83 char#119 w --- */
      { 119, 1481,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x53\x93\x92\x49\x36" }  },
      /* --- pixel bitmap for cmmib83 char#120 x --- */
      { 120, 1516,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x94\x8a\x54\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#121 y --- */
      { 121, 1543,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x73\xca\xe4\xd0\x01" }  },
      /* --- pixel bitmap for cmmib83 char#122 z --- */
      { 122, 1572,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x5c\x11\xf5\x00" }  },
      /* --- pixel bitmap for cmmib83 char#123 \imath --- */
      { 123, 2793,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xef\x03" }  },
      /* --- pixel bitmap for cmmib83 char#124 \jmath --- */
      { 124, 2810,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x36\x25\x05" }  },
      /* --- pixel bitmap for cmmib83 char#125 \wp --- */
      { 125, 2831,                      /* character number, location */
          5, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x74\x8e\x82\x42\x35\x05\x02" }  },
      /* --- pixel bitmap for cmmib83 char#126 \vec --- */
      { 126, 2866,                      /* character number, location */
          9, 2,     6, 2,     /* topleft row,col, and botleft row,col */
          {  6,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xd0\x0f\x01" }  },
      /* --- pixel bitmap for cmmib83 char#127 (noname) --- */
      { 127, 2879,                      /* character number, location */
          8, 3,     6, 3,     /* topleft row,col, and botleft row,col */
          {  5,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x2e\x02" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=1 ---
 * mf '\mode=nextscrn; input cmmib10'   gives .gf100
 * ------------------------------------------------- */
/* --- fontdef for cmmib100 --- */
static	chardef  cmmib100[] =
   {
      /* --- pixel bitmap for cmmib100 char#0 \Gamma --- */
      {   0, 1819,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x31\x63\x64\xc4\x80\x01\x03\x03\x1f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#1 \Delta --- */
      {   1, 1850,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x00\x03\x1e\x64\x88\x11\x46\xb8\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmib100 char#2 \Theta --- */
      {   2, 1883,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x18\x1b\x9e\x3c\x79\xf0\xb0\x31\x3e\x00" }  },
      /* --- pixel bitmap for cmmib100 char#3 \Lambda --- */
      {   3, 1926,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x60\xc0\xc0\x81\x83\x86\x0d\x19\x31\xf7\x01" }  },
      /* --- pixel bitmap for cmmib100 char#4 \Xi --- */
      {   4, 1961,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xf3\x4f\x20\x3f\xfc\x00\x20\xd0\x3f\xff\x00" }  },
      /* --- pixel bitmap for cmmib100 char#5 \Pi --- */
      {   5, 1990,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x8f\x31\x18\xc3\x18\x8c\xc1\x18\x8c\x61\x0c\xef"
            "\x03" }  },
      /* --- pixel bitmap for cmmib100 char#6 \Sigma --- */
      {   6, 2031,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x73\x8c\x23\x4c\x70\xc0\x84\x10\x21\xfe\x00" }  },
      /* --- pixel bitmap for cmmib100 char#7 \Upsilon --- */
      {   7, 2068,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xce\xde\xe3\xc0\x80\x01\x03\x06\x06\x3f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#8 \Phi --- */
      {   8, 2097,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x30\x7c\xde\xdb\xdb\x3e\x0c\x3f" }  },
      /* --- pixel bitmap for cmmib100 char#9 \Psi --- */
      {   9, 2132,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x81\x61\xf6\x6c\xb3\xdd\xc3\x07\x06\x7e\x00" }  },
      /* --- pixel bitmap for cmmib100 char#10 \Omega --- */
      {  10, 2171,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x31\xc6\xb0\x61\x86\x11\x62\xd4\x31\xe7\x00" }  },
      /* --- pixel bitmap for cmmib100 char#11 \alpha --- */
      {  11, 2214,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xe2\xe3\x63\x63\xde" }  },
      /* --- pixel bitmap for cmmib100 char#12 \beta --- */
      {  12, 2243,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\xd0\xc8\xc8\x74\x74\x64\x64\x36\x1e\x02\x02\x01" }  },
      /* --- pixel bitmap for cmmib100 char#13 \gamma --- */
      {  13, 2292,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xce\x6f\x0c\x06\x83\x40\x20\x08" }  },
      /* --- pixel bitmap for cmmib100 char#14 \delta --- */
      {  14, 2323,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x4f\x30\x0c\xa7\x6d\xdb\x62\x00" }  },
      /* --- pixel bitmap for cmmib100 char#15 \epsilon --- */
      {  15, 2360,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x5c\xbc\x31\x3c" }  },
      /* --- pixel bitmap for cmmib100 char#16 \zeta --- */
      {  16, 2379,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x73\x23\xc6\x18\xe3\x79\xec\x00" }  },
      /* --- pixel bitmap for cmmib100 char#17 \eta --- */
      {  17, 2412,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbe\xb3\xd9\x3c\x9b\xc1\x60\x10" }  },
      /* --- pixel bitmap for cmmib100 char#18 \theta --- */
      {  18, 2447,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x96\xd9\xfc\xfb\xcd\x36\x1b\x03" }  },
      /* --- pixel bitmap for cmmib100 char#19 \iota --- */
      {  19, 2486,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb4\x7d\x03" }  },
      /* --- pixel bitmap for cmmib100 char#20 \kappa --- */
      {  20, 2505,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x64\xbb\xc7\x36\x1f\x03" }  },
      /* --- pixel bitmap for cmmib100 char#21 \lambda --- */
      {  21, 2534,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x18\x30\x30\x30\x70\x78\x6c\x66\xc2" }  },
      /* --- pixel bitmap for cmmib100 char#22 \mu --- */
      {  22, 2567,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x88\xcc\xcc\xcc\xee\xde\x06\x06\x02" }  },
      /* --- pixel bitmap for cmmib100 char#23 \nu --- */
      {  23, 2604,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x87\xc6\xc6\x66\x1b\x07" }  },
      /* --- pixel bitmap for cmmib100 char#24 \xi --- */
      {  24, 2633,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\xce\x33\x06\xe7\x19\xc3\xe1\xe1\x1c" }  },
      /* --- pixel bitmap for cmmib100 char#25 \pi --- */
      {  25, 2666,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\xff\x14\x36\x36\x32" }  },
      /* --- pixel bitmap for cmmib100 char#26 \rho --- */
      {  26, 2693,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\xc8\xcc\xcc\x66\x3e\x06\x06\x02" }  },
      /* --- pixel bitmap for cmmib100 char#27 \sigma --- */
      {  27, 2726,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xfe\x33\x33\x1b\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#28 \tau --- */
      {  28, 2751,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x3f\x83\x60\x30\x00" }  },
      /* --- pixel bitmap for cmmib100 char#29 \upsilon --- */
      {  29, 2770,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa6\xb3\xd1\x68\xf2\x00" }  },
      /* --- pixel bitmap for cmmib100 char#30 \phi --- */
      {  30, 2799,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x40\x80\x00\xc1\xc7\xd2\xe4\xc9\xcb\x7c\x20\x40"
            "\x40\x00" }  },
      /* --- pixel bitmap for cmmib100 char#31 \chi --- */
      {  31, 2848,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x86\x4d\x2c\x18\x18\x1c\x3a\x31\x61" }  },
      /* --- pixel bitmap for cmmib100 char#32 \psi --- */
      {  32, 2887,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x80\x80\x00\x61\xea\xb4\x45\x4b\xd6\x78\x20\x40"
            "\x80\x00" }  },
      /* --- pixel bitmap for cmmib100 char#33 \omega --- */
      {  33, 2940,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x82\x02\xc7\x8c\xfd\xcf\x0d" }  },
      /* --- pixel bitmap for cmmib100 char#34 \varepsilon --- */
      {  34, 2973,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x37\x7f" }  },
      /* --- pixel bitmap for cmmib100 char#35 \vartheta --- */
      {  35, 2992,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x48\xc8\xc8\x76\x67\x66\x36\x32\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#36 \varpi --- */
      {  36, 3035,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\xff\xff\x44\x44\x66\xfc\xc3\x1d" }  },
      /* --- pixel bitmap for cmmib100 char#37 \varrho --- */
      {  37, 3064,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xb2\xd9\x7c\xeb\x04\x1e\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#38 \varsigma --- */
      {  38, 3099,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x33\xcf\x06" }  },
      /* --- pixel bitmap for cmmib100 char#39 \varphi --- */
      {  39, 3120,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe2\xe2\x47\x4c\xf4\xcf\x07\x03\x06\x04\x00" }  },
      /* --- pixel bitmap for cmmib100 char#40 \leftharpoonup --- */
      {  40, 3636,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x80\x00\x18\x80\xff\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#41 \leftharpoondown --- */
      {  41, 3651,                      /* character number, location */
          4, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xdf\x00\x10\x00\x04\x00" }  },
      /* --- pixel bitmap for cmmib100 char#42 \rightharpoonup --- */
      {  42, 3666,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x02\x80\x00\xb0\xff\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#43 \rightharpoondown --- */
      {  43, 3681,                      /* character number, location */
          4, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\x1f\x80\x01\x10\x00\x01" }  },
      /* --- pixel bitmap for cmmib100 char#44 ` --- */
      {  44, 3696,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmmib100 char#45 ' --- */
      {  45, 3713,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmmib100 char#46 \triangleright --- */
      {  46, 3730,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x61\xb4\xd8\x46\x00" }  },
      /* --- pixel bitmap for cmmib100 char#47 \triangleleft --- */
      {  47, 3757,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x90\xcb\x28\x39\x04" }  },
      /* --- pixel bitmap for cmmib100 char#48 \0 --- */
      {  48, 3340,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6e\xef\xbd\x1d" }  },
      /* --- pixel bitmap for cmmib100 char#49 \1 --- */
      {  49, 3367,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xec\x31\xc6\x3e" }  },
      /* --- pixel bitmap for cmmib100 char#50 \2 --- */
      {  50, 3386,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6f\x63\xee\x3f" }  },
      /* --- pixel bitmap for cmmib100 char#51 \3 --- */
      {  51, 3407,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6e\x6f\xec\xf0\xde\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#52 \4 --- */
      {  52, 3440,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x1c\xcf\x36\xfb\xc3\x60\x78" }  },
      /* --- pixel bitmap for cmmib100 char#53 \5 --- */
      {  53, 3469,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\x85\x97\xf1\xde\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#54 \6 --- */
      {  54, 3500,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x4c\xef\xb7\xf7\xd6\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#55 \7 --- */
      {  55, 3537,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\x1f\x21\x04\x61\x18\x06" }  },
      /* --- pixel bitmap for cmmib100 char#56 \8 --- */
      {  56, 3564,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6e\xef\xe7\xf6\xde\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#57 \9 --- */
      {  57, 3599,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6e\xef\xbd\xfd\x5e\x06" }  },
      /* --- pixel bitmap for cmmib100 char#58 . --- */
      {  58, 3784,                      /* character number, location */
          2, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#59 , --- */
      {  59, 3795,                      /* character number, location */
          2, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xaf\x01" }  },
      /* --- pixel bitmap for cmmib100 char#60 < --- */
      {  60, 3812,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x81\xc1\x40\x60\x20\x80\x01\x04\x30\x80\x01\x04" }  },
      /* --- pixel bitmap for cmmib100 char#61 / --- */
      {  61, 3841,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x22\x84\x08\x21\x42\x88\x10\x00" }  },
      /* --- pixel bitmap for cmmib100 char#62 > --- */
      {  62, 3874,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x0c\x60\x00\x01\x0c\x20\x30\x10\x18\x0c\x04\x00" }  },
      /* --- pixel bitmap for cmmib100 char#63 \star --- */
      {  63, 3903,                      /* character number, location */
          5, 0,     1, 0,     /* topleft row,col, and botleft row,col */
          {  6,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x8f\x91" }  },
      /* --- pixel bitmap for cmmib100 char#64 \partial --- */
      {  64, 3157,                      /* character number, location */
         10, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9c\x69\x82\xbc\x3c\x4f\x9b\x03" }  },
      /* --- pixel bitmap for cmmib100 char#65 A --- */
      {  65,   35,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x80\x01\x0e\x34\xc8\x20\xc3\x0f\x31\xe7\x03" }  },
      /* --- pixel bitmap for cmmib100 char#66 B --- */
      {  66,   70,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x61\x8c\x31\x63\xfc\x30\xc6\x98\x31\x7f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#67 C --- */
      {  67,  107,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x19\x1b\x1c\x30\x60\xc0\x20\x21\x3c\x00" }  },
      /* --- pixel bitmap for cmmib100 char#68 D --- */
      {  68,  142,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x61\x8c\x31\xc3\x0c\x33\xcc\x98\x31\x7f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#69 E --- */
      {  69,  181,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x31\x63\x65\xc5\x83\x25\x2b\x63\x7f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#70 F --- */
      {  70,  226,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x31\x63\x65\xc5\x83\x05\x0b\x03\x1f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#71 G --- */
      {  71,  265,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x32\x6c\xe0\x00\xe3\x0f\x36\x98\x30\xbc\x00" }  },
      /* --- pixel bitmap for cmmib100 char#72 H --- */
      {  72,  306,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\x8f\x31\x18\xc3\x18\xfc\xc1\x18\x8c\x61\x0c\xef"
            "\x03" }  },
      /* --- pixel bitmap for cmmib100 char#73 I --- */
      {  73,  347,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\x0c\x86\xc1\x60\x30\x0c\x1f" }  },
      /* --- pixel bitmap for cmmib100 char#74 J --- */
      {  74,  372,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x60\x60\x30\x30\x30\x30\x1b\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#75 K --- */
      {  75,  399,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xc7\x0c\x16\xd8\xc0\x07\x76\x30\xc3\x18\xdf\x03" }  },
      /* --- pixel bitmap for cmmib100 char#76 L --- */
      {  76,  438,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\x18\x18\x0c\x0c\x8c\xcc\x46\x7f" }  },
      /* --- pixel bitmap for cmmib100 char#77 M --- */
      {  77,  469,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x7c\x1c\x0e\x8e\x86\xc6\x41\xd3\x20\x67\x90\x33"
            "\xc4\x0c\x2f\x1f" }  },
      /* --- pixel bitmap for cmmib100 char#78 N --- */
      {  78,  528,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x8f\x23\x38\x42\x16\x64\x41\x1c\xc4\x21\x0c\x8f"
            "\x00" }  },
      /* --- pixel bitmap for cmmib100 char#79 O --- */
      {  79,  575,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x18\x1b\x1e\x3c\x78\xf0\xb0\x31\x3e\x00" }  },
      /* --- pixel bitmap for cmmib100 char#80 P --- */
      {  80,  614,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x61\x8c\x31\x63\xfc\x30\xc0\x80\x01\x1f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#81 Q --- */
      {  81,  645,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x18\x1b\x1e\x3c\x78\xf0\xb0\x3d\x3e\x40\x80\x01"
            "\x03" }  },
      /* --- pixel bitmap for cmmib100 char#82 R --- */
      {  82,  690,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x61\x8c\x31\x63\xfc\x30\xc3\x8c\x19\xdf\x03" }  },
      /* --- pixel bitmap for cmmib100 char#83 S --- */
      {  83,  729,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x8c\x0c\x1c\x3c\x60\x60\x31\x1f" }  },
      /* --- pixel bitmap for cmmib100 char#84 T --- */
      {  84,  758,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x65\xcb\xcc\x84\x01\x03\x06\x06\x3f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#85 U --- */
      {  85,  795,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xdf\x1b\x62\xc8\x10\x43\x0c\x31\xc4\x08\x1e\x00" }  },
      /* --- pixel bitmap for cmmib100 char#86 V --- */
      {  86,  836,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9f\x67\x08\x23\x18\xc1\x04\x16\xe0\x00\x03\x08\x00" }  },
      /* --- pixel bitmap for cmmib100 char#87 W --- */
      {  87,  873,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xdf\x73\xc6\x08\x73\x84\x35\xc1\x5a\xe0\x2c\x70\x0c"
            "\x18\x06\x0c\x01" }  },
      /* --- pixel bitmap for cmmib100 char#88 X --- */
      {  88,  932,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x0f\x27\x60\x01\x0e\xc0\x00\x0e\xd0\x81\x18\xcf"
            "\x07" }  },
      /* --- pixel bitmap for cmmib100 char#89 Y --- */
      {  89,  969,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9f\x67\x08\x26\xb0\x80\x07\x18\xc0\x00\x03\x3c\x00" }  },
      /* --- pixel bitmap for cmmib100 char#90 Z --- */
      {  90, 1002,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x99\x91\x91\x03\x03\x13\x23\x23\x7f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#91 \flat --- */
      {  91, 3920,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x49\xf6\xff\x0b" }  },
      /* --- pixel bitmap for cmmib100 char#92 \natural --- */
      {  92, 3947,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x21\xc4\xff\x63\x8c\xf1\xff\x08\x01" }  },
      /* --- pixel bitmap for cmmib100 char#93 \sharp --- */
      {  93, 3992,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6c\xff\xb6\xfd\x1b" }  },
      /* --- pixel bitmap for cmmib100 char#94 \smile --- */
      {  94, 4039,                      /* character number, location */
          6, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 13,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\xd0\x80\xf1\x1f\xf8\x00" }  },
      /* --- pixel bitmap for cmmib100 char#95 \frown --- */
      {  95, 4058,                      /* character number, location */
          7, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 13,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x00\x7f\xf0\x1f\x01\x14\x00\x01" }  },
      /* --- pixel bitmap for cmmib100 char#96 \ell --- */
      {  96, 3196,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x60\x28\x16\xc7\xe1\x30\x18\x0e\x3c" }  },
      /* --- pixel bitmap for cmmib100 char#97 a --- */
      {  97, 1039,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\x3c\xcf\xbb\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#98 b --- */
      {  98, 1066,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x87\x61\x18\xdf\x3c\xcf\x9b\x03" }  },
      /* --- pixel bitmap for cmmib100 char#99 c --- */
      {  99, 1101,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x5c\x8f\x31\x1d" }  },
      /* --- pixel bitmap for cmmib100 char#100 d --- */
      { 100, 1124,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\x30\x18\xcc\x93\xcd\x66\x3b\x1f" }  },
      /* --- pixel bitmap for cmmib100 char#101 e --- */
      { 101, 1159,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x5c\xbe\x31\x1d" }  },
      /* --- pixel bitmap for cmmib100 char#102 f --- */
      { 102, 1182,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x60\x38\x0c\xc3\xc7\x60\x30\x0c\x06\xc3\x61\x00" }  },
      /* --- pixel bitmap for cmmib100 char#103 g --- */
      { 103, 1215,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\xb2\xd9\x6c\xe3\xc1\x64\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#104 h --- */
      { 104, 1250,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0e\x06\x83\xe1\x33\x9b\xcd\xf3\x31" }  },
      /* --- pixel bitmap for cmmib100 char#105 i --- */
      { 105, 1287,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x24\x00\x7d\xdb\x00" }  },
      /* --- pixel bitmap for cmmib100 char#106 j --- */
      { 106, 1312,                      /* character number, location */
         11, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x0c\x00\x00\xc6\x61\x18\xc3\x30\x86\x00" }  },
      /* --- pixel bitmap for cmmib100 char#107 k --- */
      { 107, 1343,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0e\x06\x83\x61\xf6\xbb\x3d\xbb\x19" }  },
      /* --- pixel bitmap for cmmib100 char#108 l --- */
      { 108, 1378,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xce\xcc\x66\x66\x67" }  },
      /* --- pixel bitmap for cmmib100 char#109 m --- */
      { 109, 1405,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbe\x3b\xb3\x99\xcd\x3c\xf3\x19\x03" }  },
      /* --- pixel bitmap for cmmib100 char#110 n --- */
      { 110, 1446,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbe\xb3\xd9\x3c\x1f\x03" }  },
      /* --- pixel bitmap for cmmib100 char#111 o --- */
      { 111, 1475,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xf1\x78\x3c\xf3\x00" }  },
      /* --- pixel bitmap for cmmib100 char#112 p --- */
      { 112, 1502,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\xce\xcc\xcc\x66\x3e\x06\x06\x07" }  },
      /* --- pixel bitmap for cmmib100 char#113 q --- */
      { 113, 1535,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\x3c\xcf\x9b\x87\x61\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#114 r --- */
      { 114, 1568,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xee\x7b\x33\x06" }  },
      /* --- pixel bitmap for cmmib100 char#115 s --- */
      { 115, 1587,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\xc7\xe9\x93\x03" }  },
      /* --- pixel bitmap for cmmib100 char#116 t --- */
      { 116, 1610,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcc\xfc\x66\xb6\x06" }  },
      /* --- pixel bitmap for cmmib100 char#117 u --- */
      { 117, 1637,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe6\x6d\xdb\xba\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#118 v --- */
      { 118, 1666,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xd6\x6d\x9a\x92\x03" }  },
      /* --- pixel bitmap for cmmib100 char#119 w --- */
      { 119, 1695,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x46\x9d\x6d\xa6\x99\x26\xf1\x03" }  },
      /* --- pixel bitmap for cmmib100 char#120 x --- */
      { 120, 1734,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6c\x3d\x5e\xf3\xf2\x00" }  },
      /* --- pixel bitmap for cmmib100 char#121 y --- */
      { 121, 1761,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc6\xb3\xd9\x6c\xf3\xc1\x36\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#122 z --- */
      { 122, 1798,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\x8f\x11\x5e\x07" }  },
      /* --- pixel bitmap for cmmib100 char#123 \imath --- */
      { 123, 3227,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfa\xb6\x01" }  },
      /* --- pixel bitmap for cmmib100 char#124 \jmath --- */
      { 124, 3246,                      /* character number, location */
          6, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\x0d\xc3\x18\x86\x39\x06" }  },
      /* --- pixel bitmap for cmmib100 char#125 \wp --- */
      { 125, 3273,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\xe6\x3d\x1e\xbc\xed\xce\x81\x03\x03\x00" }  },
      /* --- pixel bitmap for cmmib100 char#126 \vec --- */
      { 126, 3310,                      /* character number, location */
         10, 2,     7, 2,     /* topleft row,col, and botleft row,col */
          {  7,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa0\x3f\x08" }  },
      /* --- pixel bitmap for cmmib100 char#127 (noname) --- */
      { 127, 3323,                      /* character number, location */
         10, 3,     7, 3,     /* topleft row,col, and botleft row,col */
          {  5,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x2e\x46" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=2 ---
 * mf '\mode=lview; input cmmib10'      gives .gf118
 * ------------------------------------------------- */
/* --- fontdef for cmmib118 --- */
static	chardef  cmmib118[] =
   {
      /* --- pixel bitmap for cmmib118 char#0 \Gamma --- */
      {   0, 2055,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xc7\x10\x86\x30\xc4\x00\x06\x30\x80\x01\x06\xf8"
            "\x00" }  },
      /* --- pixel bitmap for cmmib118 char#1 \Delta --- */
      {   1, 2088,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x03\x70\x00\x1f\x20\x03\x62\x20\x1c\x02\x23\x60"
            "\xfe\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmib118 char#2 \Theta --- */
      {   2, 2125,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x03\x83\x31\x30\x93\x6c\xcf\xe6\xd9\x24\x1b\x30"
            "\x06\x83\x1f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#3 \Lambda --- */
      {   3, 2180,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x00\x03\x1c\x78\x90\x41\x86\x18\x61\x84\xbd\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#4 \Xi --- */
      {   4, 2219,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x9f\xff\x11\x20\x00\x80\x1f\xf0\x03\x00\x10\x20"
            "\xff\xe3\x7f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#5 \Pi --- */
      {   5, 2250,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xff\x30\x30\x30\x30\x30\x30\x18\x18\x18\x18\x18"
            "\x18\x18\x18\x0c\x0c\x3f\x3f" }  },
      /* --- pixel bitmap for cmmib118 char#6 \Sigma --- */
      {   6, 2295,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x3f\x06\x04\x03\xc1\x41\x60\x00\x10\x00\x83\x20"
            "\x20\x06\xc4\xff\x01" }  },
      /* --- pixel bitmap for cmmib118 char#7 \Upsilon --- */
      {   7, 2334,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1e\x3f\x9b\xf0\x00\x06\x70\x00\x03\x30\x00\x03\x18"
            "\xe0\x07" }  },
      /* --- pixel bitmap for cmmib118 char#8 \Phi --- */
      {   8, 2369,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x07\x06\xfe\x8c\x6d\xe6\x31\x9b\x8d\x1f\x30\xe0"
            "\x07" }  },
      /* --- pixel bitmap for cmmib118 char#9 \Psi --- */
      {   9, 2412,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x03\x06\x63\x6c\x66\x36\x33\x33\xb6\xc1\x0f\x18"
            "\xe0\x07" }  },
      /* --- pixel bitmap for cmmib118 char#10 \Omega --- */
      {  10, 2459,                      /* character number, location */
         10, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xc3\x61\x06\x6c\xc0\x06\x66\x20\x07\x55\x28\x87"
            "\x73\x1c" }  },
      /* --- pixel bitmap for cmmib118 char#11 \alpha --- */
      {  11, 2510,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x8c\x0f\x1f\x3e\x6c\x9c\x67" }  },
      /* --- pixel bitmap for cmmib118 char#12 \beta --- */
      {  12, 2543,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x20\x23\xc6\x4f\x9f\x30\x61\xc2\xc6\xf4\x08\x10"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmmib118 char#13 \gamma --- */
      {  13, 2592,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x3d\xc5\x02\x03\x06\x0c\x08\x10\x20\x20\x00" }  },
      /* --- pixel bitmap for cmmib118 char#14 \delta --- */
      {  14, 2627,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x3c\x0a\x83\xb3\xcd\x66\xb3\x89\x03" }  },
      /* --- pixel bitmap for cmmib118 char#15 \epsilon --- */
      {  15, 2668,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\x31\x7c\xc3\xe8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#16 \zeta --- */
      {  16, 2691,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\xce\x1b\xc6\x30\x0c\xc3\xe3\x41\x1c" }  },
      /* --- pixel bitmap for cmmib118 char#17 \eta --- */
      {  17, 2724,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf6\xcf\xc7\xc6\xc6\x63\x63\x60\x60\x20" }  },
      /* --- pixel bitmap for cmmib118 char#18 \theta --- */
      {  18, 2765,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\x18\x11\x36\xec\xef\xdf\xb0\x31\x22\x38\x00" }  },
      /* --- pixel bitmap for cmmib118 char#19 \iota --- */
      {  19, 2804,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6c\x66\xb6\x06" }  },
      /* --- pixel bitmap for cmmib118 char#20 \kappa --- */
      {  20, 2827,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcc\xa6\x1e\x7e\x66\xe3\xc3" }  },
      /* --- pixel bitmap for cmmib118 char#21 \lambda --- */
      {  21, 2860,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x30\xe0\x80\x01\x03\x0e\x1a\x73\xc3\x82\x03" }  },
      /* --- pixel bitmap for cmmib118 char#22 \mu --- */
      {  22, 2895,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x33\xc6\x18\x63\x8c\x39\xe7\x9b\x01\x06\x08\x00" }  },
      /* --- pixel bitmap for cmmib118 char#23 \nu --- */
      {  23, 2936,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0e\x1b\x66\x98\x31\x66\x6c\x70\x00" }  },
      /* --- pixel bitmap for cmmib118 char#24 \xi --- */
      {  24, 2969,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x38\x9e\xc1\xe0\xf1\x0c\x07\x07\x0f\x86\x03" }  },
      /* --- pixel bitmap for cmmib118 char#25 \pi --- */
      {  25, 3002,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xfd\xa3\x60\xc1\xc2\x8c\x19" }  },
      /* --- pixel bitmap for cmmib118 char#26 \rho --- */
      {  26, 3033,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x61\xcc\x30\xc3\x0c\x3b\xe6\x87\x01\x06\x08\x00" }  },
      /* --- pixel bitmap for cmmib118 char#27 \sigma --- */
      {  27, 3070,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xfb\x7f\xcc\x30\xc3\x8c\xe1\x01" }  },
      /* --- pixel bitmap for cmmib118 char#28 \tau --- */
      {  28, 3099,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xfe\x10\x18\x18\x0c\x0c" }  },
      /* --- pixel bitmap for cmmib118 char#29 \upsilon --- */
      {  29, 3120,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc6\xce\x87\x86\x46\x66\x3c" }  },
      /* --- pixel bitmap for cmmib118 char#30 \phi --- */
      {  30, 3153,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x00\x01\x04\x3e\x26\x8f\x3c\xf1\x44\xd3\xf1\x81"
            "\x00\x02\x08\x00" }  },
      /* --- pixel bitmap for cmmib118 char#31 \chi --- */
      {  31, 3206,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\x19\x61\xc1\x81\x03\x06\x0e\x1a\x62\x83\x01" }  },
      /* --- pixel bitmap for cmmib118 char#32 \psi --- */
      {  32, 3247,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x00\x01\x84\xd1\x2e\x9f\x68\xa2\x49\x96\xf0\x01"
            "\x01\x04\x08\x00" }  },
      /* --- pixel bitmap for cmmib118 char#33 \omega --- */
      {  33, 3304,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\x0b\x1c\x62\x8c\x31\xff\xe7\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#34 \varepsilon --- */
      {  34, 3343,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xdc\xd7\x17\xbe\x03" }  },
      /* --- pixel bitmap for cmmib118 char#35 \vartheta --- */
      {  35, 3368,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\x10\x21\xb6\x7d\xfe\x98\x31\x33\x26\x38\x00" }  },
      /* --- pixel bitmap for cmmib118 char#36 \varpi --- */
      {  36, 3413,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xbf\xff\x8f\x08\x11\x42\xc4\x08\xef\xc3\x31\x00" }  },
      /* --- pixel bitmap for cmmib118 char#37 \varrho --- */
      {  37, 3450,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x18\x1b\x36\x6c\xf8\x58\x8f\x00\x3f\x7c\x00" }  },
      /* --- pixel bitmap for cmmib118 char#38 \varsigma --- */
      {  38, 3489,                      /* character number, location */
          7, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xdc\x8c\xf1\x3c\x66" }  },
      /* --- pixel bitmap for cmmib118 char#39 \varphi --- */
      {  39, 3512,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x82\x09\x1f\x62\x88\x11\xf9\xc3\x07\x06\x18\x30\x00" }  },
      /* --- pixel bitmap for cmmib118 char#40 \leftharpoonup --- */
      {  40, 4086,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 16,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x00\x10\x00\x08\x00\x06\x00\xff\xff" }  },
      /* --- pixel bitmap for cmmib118 char#41 \leftharpoondown --- */
      {  41, 4103,                      /* character number, location */
          4, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 16,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\x06\x00\x08\x00\x10\x00\x10\x00" }  },
      /* --- pixel bitmap for cmmib118 char#42 \rightharpoonup --- */
      {  42, 4120,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 16,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x08\x00\x08\x00\x10\x00\x60\xff\xff" }  },
      /* --- pixel bitmap for cmmib118 char#43 \rightharpoondown --- */
      {  43, 4137,                      /* character number, location */
          4, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 16,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\x00\x60\x00\x10\x00\x08\x00\x08" }  },
      /* --- pixel bitmap for cmmib118 char#44 ` --- */
      {  44, 4154,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x56\x02" }  },
      /* --- pixel bitmap for cmmib118 char#45 ' --- */
      {  45, 4171,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  2,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa9\x01" }  },
      /* --- pixel bitmap for cmmib118 char#46 \triangleright --- */
      {  46, 4188,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc1\x91\x85\xd9\x11\x00" }  },
      /* --- pixel bitmap for cmmib118 char#47 \triangleleft --- */
      {  47, 4215,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x6e\x86\x26\x0e\x02" }  },
      /* --- pixel bitmap for cmmib118 char#48 \0 --- */
      {  48, 3754,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xde\x3c\xcf\xf3\xec\x01" }  },
      /* --- pixel bitmap for cmmib118 char#49 \1 --- */
      {  49, 3785,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcc\xc3\x30\x0c\xf3\x03" }  },
      /* --- pixel bitmap for cmmib118 char#50 \2 --- */
      {  50, 3806,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xde\x0c\x43\xac\xff\x03" }  },
      /* --- pixel bitmap for cmmib118 char#51 \3 --- */
      {  51, 3831,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xde\x3c\xc3\x1c\x0c\xcf\xb3\x03" }  },
      /* --- pixel bitmap for cmmib118 char#52 \4 --- */
      {  52, 3866,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x30\x38\x34\x32\x33\xff\x30\x30\xfc" }  },
      /* --- pixel bitmap for cmmib118 char#53 \5 --- */
      {  53, 3899,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe1\xd7\x04\x5f\x0c\xcf\x93\x03" }  },
      /* --- pixel bitmap for cmmib118 char#54 \6 --- */
      {  54, 3936,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9c\x3d\x0f\xdf\x3c\xcf\x32\x07" }  },
      /* --- pixel bitmap for cmmib118 char#55 \7 --- */
      {  55, 3975,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\x5f\x24\x82\x60\x10\x0c\x06\x03" }  },
      /* --- pixel bitmap for cmmib118 char#56 \8 --- */
      {  56, 4006,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xde\x3c\xdf\x9e\x3e\xcf\xb3\x07" }  },
      /* --- pixel bitmap for cmmib118 char#57 \9 --- */
      {  57, 4047,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xce\x34\xcf\xb3\x0f\xcf\x9b\x03" }  },
      /* --- pixel bitmap for cmmib118 char#58 . --- */
      {  58, 4242,                      /* character number, location */
          3, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmib118 char#59 , --- */
      {  59, 4255,                      /* character number, location */
          3, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xba\x29\x01" }  },
      /* --- pixel bitmap for cmmib118 char#60 < --- */
      {  60, 4274,                      /* character number, location */
          9, 2,    -2, 2,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x02\x06\x06\x06\x06\x04\x60\x00\x06\x60\x00\x06"
            "\x20" }  },
      /* --- pixel bitmap for cmmib118 char#61 / --- */
      {  61, 4303,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  6,    15, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x08\x41\x10\x82\x10\x04\x21\x08\x42\x10\x00" }  },
      /* --- pixel bitmap for cmmib118 char#62 > --- */
      {  62, 4340,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x60\x00\x38\x00\x0c\x00\x03\xc0\x00\x03\x0c\x38"
            "\x60\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmib118 char#63 \star --- */
      {  63, 4369,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x44\xd2\xc7\xb1\x89\x00" }  },
      /* --- pixel bitmap for cmmib118 char#64 \partial --- */
      {  64, 3555,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x66\x46\xc0\x7c\x62\x63\x23\x33\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#65 A --- */
      {  65,   35,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x01\x0c\x70\x40\x03\x1a\xc8\xe1\x0f\x61\x04\x7b"
            "\x3e" }  },
      /* --- pixel bitmap for cmmib118 char#66 B --- */
      {  66,   74,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x87\xc1\x18\x8c\xc1\xfc\xc7\x70\x0c\xc6\x60\x06"
            "\xf3\x1f" }  },
      /* --- pixel bitmap for cmmib118 char#67 C --- */
      {  67,  115,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x1f\x03\x31\x20\x03\x60\x00\x06\xc0\x00\x18\x20"
            "\x06\x02\x3f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#68 D --- */
      {  68,  150,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x07\x83\x61\x20\x0c\xcc\x80\x18\x18\x03\x63\x30"
            "\x06\xe3\x1f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#69 E --- */
      {  69,  193,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x8f\x41\x98\x84\x49\x7c\xc0\x44\x4c\xc4\x20\x06"
            "\xf3\x1f" }  },
      /* --- pixel bitmap for cmmib118 char#70 F --- */
      {  70,  242,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\x06\xc1\x28\x18\x85\x1f\x30\x02\x46\xc0\x00"
            "\x0c\xe0\x07\x00" }  },
      /* --- pixel bitmap for cmmib118 char#71 G --- */
      {  71,  283,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x1f\x03\x31\x20\x03\x60\x00\x06\xdf\x80\x19\x30"
            "\x06\x03\x5f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#72 H --- */
      {  72,  324,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xf8\x30\x30\x30\x30\x30\x30\xf8\x1f\x18\x18\x18"
            "\x18\x18\x18\x0c\x0c\x3f\x3f" }  },
      /* --- pixel bitmap for cmmib118 char#73 I --- */
      {  73,  369,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x30\x30\x30\x18\x18\x18\x18\x0c\x3f" }  },
      /* --- pixel bitmap for cmmib118 char#74 J --- */
      {  74,  396,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x03\x03\x0c\x30\x60\x80\x01\x86\x18\x33\x78\x00" }  },
      /* --- pixel bitmap for cmmib118 char#75 K --- */
      {  75,  427,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xf8\x30\x10\x30\x04\x30\x03\x98\x01\x38\x03\x18"
            "\x03\x18\x06\x0c\x0c\x3f\x1f" }  },
      /* --- pixel bitmap for cmmib118 char#76 L --- */
      {  76,  474,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x30\x60\xc0\xc0\x80\x01\x43\x86\x86\xfe\x01" }  },
      /* --- pixel bitmap for cmmib118 char#77 M --- */
      {  77,  507,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 19,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x80\x87\x06\x0e\x34\x68\xa0\x41\x83\x0c\x0d\x64"
            "\x64\x20\x16\x03\x71\x18\x84\x63\xf8\xcc\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#78 N --- */
      {  78,  582,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\xf0\x70\x20\xd0\x20\x90\x21\x88\x11\x08\x13\x08"
            "\x16\x08\x1c\x04\x0c\x1f\x08" }  },
      /* --- pixel bitmap for cmmib118 char#79 O --- */
      {  79,  639,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x83\x61\x0c\x64\xc0\x02\x36\x60\x03\x36\x30\x86"
            "\xc1\x07" }  },
      /* --- pixel bitmap for cmmib118 char#80 P --- */
      {  80,  682,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x0f\x06\xc3\x60\x18\x8c\xc1\xf0\x0f\x06\xc0\x00"
            "\x0c\xe0\x07\x00" }  },
      /* --- pixel bitmap for cmmib118 char#81 Q --- */
      {  81,  717,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x83\x61\x0c\x66\xc0\x06\x36\x60\x03\x36\x30\xb6"
            "\xc1\x27\x40\x02\x1c\xc0\x00" }  },
      /* --- pixel bitmap for cmmib118 char#82 R --- */
      {  82,  772,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x0f\x06\xc3\x60\x18\x86\x7f\x30\x0c\x86\xc1\x30"
            "\x0c\xf6\xc7\x01" }  },
      /* --- pixel bitmap for cmmib118 char#83 S --- */
      {  83,  817,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x23\xc4\x00\x03\x7c\xc0\x03\x0c\x30\x61\xfc\x00" }  },
      /* --- pixel bitmap for cmmib118 char#84 T --- */
      {  84,  848,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x9f\x51\x8c\x62\x84\x01\x0c\x60\x00\x03\x0c\xf8"
            "\x01" }  },
      /* --- pixel bitmap for cmmib118 char#85 U --- */
      {  85,  887,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1f\x6f\x20\x06\x62\x20\x03\x31\x10\x03\x31\x10\xc3"
            "\xe0\x03" }  },
      /* --- pixel bitmap for cmmib118 char#86 V --- */
      {  86,  932,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1f\xef\x20\x0c\xc1\x10\x8c\xc0\x04\x6c\x80\x03\x18"
            "\x80\x00" }  },
      /* --- pixel bitmap for cmmib118 char#87 W --- */
      {  87,  973,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9f\xef\x0d\x87\x18\x0e\x31\x3a\xe1\x62\x81\xc5\x02"
            "\x87\x03\x0e\x07\x0c\x06\x08\x04\x00" }  },
      /* --- pixel bitmap for cmmib118 char#88 X --- */
      {  88, 1038,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x1e\xc6\x80\x0d\xf0\x00\x0c\xc0\x01\x6c\xc0\x0c"
            "\x04\xe3\xf9\x00" }  },
      /* --- pixel bitmap for cmmib118 char#89 Y --- */
      {  89, 1079,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1f\xcf\x20\x1c\x81\x09\x78\x00\x03\x30\x00\x03\x18"
            "\xe0\x07" }  },
      /* --- pixel bitmap for cmmib118 char#90 Z --- */
      {  90, 1114,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x67\x18\x61\x88\x01\x06\x98\x60\x84\x21\xc6\xf8"
            "\x07" }  },
      /* --- pixel bitmap for cmmib118 char#91 \flat --- */
      {  91, 4398,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x11\x11\xd7\xdd\x37\x01" }  },
      /* --- pixel bitmap for cmmib118 char#92 \natural --- */
      {  92, 4433,                      /* character number, location */
         11, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x11\xf9\x9f\x99\x99\xff\x89" }  },
      /* --- pixel bitmap for cmmib118 char#93 \sharp --- */
      {  93, 4482,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x88\xff\x99\x99\xf9\x1f\x01" }  },
      /* --- pixel bitmap for cmmib118 char#94 \smile --- */
      {  94, 4525,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 16,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x80\x0e\x70\xf0\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#95 \frown --- */
      {  95, 4542,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 16,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x0f\x0e\x70\x01\x80" }  },
      /* --- pixel bitmap for cmmib118 char#96 \ell --- */
      {  96, 3594,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\xb0\x98\x58\x2c\x1c\x0c\x0c\x8e\x78" }  },
      /* --- pixel bitmap for cmmib118 char#97 a --- */
      {  97, 1155,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x66\x63\x63\x63\x73\x6e" }  },
      /* --- pixel bitmap for cmmib118 char#98 b --- */
      {  98, 1188,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0e\x83\xc1\x77\x1e\x8f\xc7\x33\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#99 c --- */
      {  99, 1225,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb8\x3d\x0e\xc3\xe8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#100 d --- */
      { 100, 1252,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x81\x01\xe3\x67\x66\xcc\x98\x31\x73\xdc\x00" }  },
      /* --- pixel bitmap for cmmib118 char#101 e --- */
      { 101, 1291,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbc\x39\x7e\xc3\xe8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#102 f --- */
      { 102, 1318,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\xe0\x30\xfc\x30\x30\x18\x18\x18\x18\x08\x0e\x06" }  },
      /* --- pixel bitmap for cmmib118 char#103 g --- */
      { 103, 1351,                      /* character number, location */
          7,-1,    -3,-1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x99\x19\x33\x66\xcc\x0c\x1f\x30\x32\x3c\x00" }  },
      /* --- pixel bitmap for cmmib118 char#104 h --- */
      { 104, 1390,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x0c\x0c\xfc\xce\xc6\xc6\xc6\xe3\xc3" }  },
      /* --- pixel bitmap for cmmib118 char#105 i --- */
      { 105, 1429,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc8\x00\xe6\x67\x76\x06" }  },
      /* --- pixel bitmap for cmmib118 char#106 j --- */
      { 106, 1456,                      /* character number, location */
         11, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x30\x00\x00\xc3\xd1\x60\x30\x0c\x06\xe3\x30\x00" }  },
      /* --- pixel bitmap for cmmib118 char#107 k --- */
      { 107, 1491,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x0c\x0c\xcc\xb6\xce\x3e\x36\x73\x63" }  },
      /* --- pixel bitmap for cmmib118 char#108 l --- */
      { 108, 1532,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9c\x31\x66\x8c\x31\xc7\x00" }  },
      /* --- pixel bitmap for cmmib118 char#109 m --- */
      { 109, 1559,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xee\xbd\xe7\xdc\x18\x33\xc6\x8c\xb1\x31\x6e\x0c\x03" }  },
      /* --- pixel bitmap for cmmib118 char#110 n --- */
      { 110, 1610,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf6\xcf\xc7\xc6\xc6\xe3\xc3" }  },
      /* --- pixel bitmap for cmmib118 char#111 o --- */
      { 111, 1645,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\xc6\xc3\xc3\xc3\x63\x1e" }  },
      /* --- pixel bitmap for cmmib118 char#112 p --- */
      { 112, 1676,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xec\x3c\x3b\x66\xcc\xd8\x98\x1f\x03\x06\x0e\x00" }  },
      /* --- pixel bitmap for cmmib118 char#113 q --- */
      { 113, 1715,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x66\x63\x63\x63\x33\x3e\x30\x30\x3c" }  },
      /* --- pixel bitmap for cmmib118 char#114 r --- */
      { 114, 1752,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf6\xe7\xd9\x60\x18\x0c\x00" }  },
      /* --- pixel bitmap for cmmib118 char#115 s --- */
      { 115, 1779,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\x1c\x07\x27\x3e\x79\x00" }  },
      /* --- pixel bitmap for cmmib118 char#116 t --- */
      { 116, 1804,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x88\xb1\x6f\x8c\x31\xcb\x00" }  },
      /* --- pixel bitmap for cmmib118 char#117 u --- */
      { 117, 1833,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x86\x9d\x1d\x33\x66\xcc\x1c\x37" }  },
      /* --- pixel bitmap for cmmib118 char#118 v --- */
      { 118, 1868,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x66\xf7\xd1\x68\x32\x71\x00" }  },
      /* --- pixel bitmap for cmmib118 char#119 w --- */
      { 119, 1901,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8c\xad\xcd\xcd\xc8\x8c\xcc\xc4\x4c\xb8\x03" }  },
      /* --- pixel bitmap for cmmib118 char#120 x --- */
      { 120, 1952,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xe9\xca\x86\x61\x43\x93\x1f" }  },
      /* --- pixel bitmap for cmmib118 char#121 y --- */
      { 121, 1987,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x86\x9d\x1d\x33\x66\xcc\x0c\x1f\x30\x36\x3c\x00" }  },
      /* --- pixel bitmap for cmmib118 char#122 z --- */
      { 122, 2028,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xf9\x81\x81\xc0\xc8\x4f\x0c" }  },
      /* --- pixel bitmap for cmmib118 char#123 \imath --- */
      { 123, 3631,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe6\x67\x76\x06" }  },
      /* --- pixel bitmap for cmmib118 char#124 \jmath --- */
      { 124, 3652,                      /* character number, location */
          7, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\x4e\xc3\x30\x86\x61\x8e\x01" }  },
      /* --- pixel bitmap for cmmib118 char#125 \wp --- */
      { 125, 3681,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\x98\xb7\xf1\xc1\x03\xdf\xf6\x4e\x03\x0d\x18\x00" }  },
      /* --- pixel bitmap for cmmib118 char#126 \vec --- */
      { 126, 3728,                      /* character number, location */
         11, 3,     8, 3,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\xff\x20" }  },
      /* --- pixel bitmap for cmmib118 char#127 (noname) --- */
      { 127, 3741,                      /* character number, location */
         10, 4,     8, 4,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7e\x08" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=3 ---
 * mf '\mode=onetz; mag=magstep(.5); input cmmib10'   gives .gf131
 * --------------------------------------------------------------- */
/* --- fontdef for cmmib131 --- */
static	chardef  cmmib131[] =
   {
      /* --- pixel bitmap for cmmib131 char#0 \Gamma --- */
      {   0, 2447,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\x1c\xc3\x41\x38\x08\x07\xe1\x00\x0e\xc0\x01"
            "\x38\x00\x07\x70\x80\x7f\x00" }  },
      /* --- pixel bitmap for cmmib131 char#1 \Delta --- */
      {   1, 2486,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x06\xc0\x01\x78\x00\x3e\x40\x0e\x88\x03\xe1\x61"
            "\x78\x08\x1c\xff\xe7\xff\xff\xff" }  },
      /* --- pixel bitmap for cmmib131 char#2 \Theta --- */
      {   2, 2527,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x07\x0c\xc7\x81\x31\xe5\xce\xb9\x73\x7e\xce\x9d"
            "\x73\xa7\x8c\x81\xe3\x30\xe0\x07" }  },
      /* --- pixel bitmap for cmmib131 char#3 \Lambda --- */
      {   3, 2594,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x03\x30\x80\x03\x3c\xc0\x03\x3a\x90\x03\x39\x88"
            "\x87\x70\x04\xf7\xfc" }  },
      /* --- pixel bitmap for cmmib131 char#4 \Xi --- */
      {   4, 2639,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x3f\xfe\x4f\x00\x11\x40\x00\x00\xfc\x81\x3f\x00"
            "\x00\x02\x88\x00\xf2\x7f\xfc\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#5 \Pi --- */
      {   5, 2678,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xff\x83\x83\x03\x07\x07\x1c\x1c\x70\x70\xc0\xc1"
            "\x81\x83\x03\x0e\x0e\x38\x38\xe0\xe0\xc0\xc1\xc1\xdf"
            "\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#6 \Sigma --- */
      {   6, 2731,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x3f\x1e\x0c\x07\xc2\x83\xe0\x21\x70\x00\x1c\x01"
            "\x41\x30\x08\x02\xe3\xff\xfc\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#7 \Upsilon --- */
      {   7, 2778,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\xdc\xe7\xc7\x4e\xf0\x00\x0e\xc0\x01\x1c\x80\x03"
            "\x70\x00\x0e\xe0\x00\x7f\x00" }  },
      /* --- pixel bitmap for cmmib131 char#8 \Phi --- */
      {   8, 2819,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x0f\x70\x00\x07\xf8\xc3\xfc\x9c\xfb\xb9\x73\x37"
            "\xfc\x01\x1c\xc0\x01\xfe\x00" }  },
      /* --- pixel bitmap for cmmib131 char#9 \Psi --- */
      {   9, 2864,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x07\x38\xbc\x73\x77\xe7\xee\xdc\x9d\xdf\xf1\x1f"
            "\xfc\x01\x0e\xe0\x00\x7f\x00" }  },
      /* --- pixel bitmap for cmmib131 char#10 \Omega --- */
      {  10, 2913,                      /* character number, location */
         12, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x07\x87\x71\x70\x07\xee\xc0\x1d\x98\x83\x7b\x70"
            "\x0d\xeb\xe0\x1c\x9e\xc3\x01" }  },
      /* --- pixel bitmap for cmmib131 char#11 \alpha --- */
      {  11, 2970,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x30\xa6\xb1\x06\x37\x98\xc1\x8c\xc7\x63" }  },
      /* --- pixel bitmap for cmmib131 char#12 \beta --- */
      {  12, 3011,                      /* character number, location */
         13, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x01\x11\x84\x21\x84\x30\xf4\xa0\x8f\x60\x04\x23"
            "\x18\x41\x0c\xa3\x07\x01\x08\x20\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmib131 char#13 \gamma --- */
      {  13, 3076,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xf4\xd3\x90\x00\x05\x18\xc0\x00\x06\x10\x80\x00"
            "\x04\x10\x80\x00" }  },
      /* --- pixel bitmap for cmmib131 char#14 \delta --- */
      {  14, 3117,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\xf0\x08\x18\x18\x30\x78\x64\x66\x63\x63\x63\x33"
            "\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#15 \epsilon --- */
      {  15, 3164,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb8\x21\x7c\xc3\x30\x7a" }  },
      /* --- pixel bitmap for cmmib131 char#16 \zeta --- */
      {  16, 3189,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x10\x18\xcf\x20\x18\x06\x83\xc1\x60\xe0\xe1\xc1"
            "\x40\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#17 \eta --- */
      {  17, 3230,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xee\x35\x37\x66\xcc\x98\xb1\x31\x63\xc0\x80\x81\x01"
            "\x03" }  },
      /* --- pixel bitmap for cmmib131 char#18 \theta --- */
      {  18, 3281,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\xd8\xcc\xcc\xc6\xc6\xfe\x63\x63\x63\x33\x12\x0e" }  },
      /* --- pixel bitmap for cmmib131 char#19 \iota --- */
      {  19, 3334,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8c\x19\x63\xe6\x32" }  },
      /* --- pixel bitmap for cmmib131 char#20 \kappa --- */
      {  20, 3361,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcc\x59\x59\xf0\x60\xc3\xec\xa8\x71" }  },
      /* --- pixel bitmap for cmmib131 char#21 \lambda --- */
      {  21, 3404,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\xe0\x00\x03\x0c\x70\x80\x01\x06\x38\xd0\x20\x63"
            "\xd8\x60\x81\x03" }  },
      /* --- pixel bitmap for cmmib131 char#22 \mu --- */
      {  22, 3447,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x63\xcc\x18\x63\x8c\x31\xee\xac\x6f\x06\x18\x30"
            "\xc0\x00" }  },
      /* --- pixel bitmap for cmmib131 char#23 \nu --- */
      {  23, 3496,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8e\x19\x1b\x33\x66\xc6\xc6\x86\x03" }  },
      /* --- pixel bitmap for cmmib131 char#24 \xi --- */
      {  24, 3533,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x08\x9e\x6f\x30\xf8\x78\x82\xc1\x60\x70\xf0\xe0"
            "\x40\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#25 \pi --- */
      {  25, 3574,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xf7\x7f\x34\x90\x81\x0c\x66\x30\x83\x10" }  },
      /* --- pixel bitmap for cmmib131 char#26 \rho --- */
      {  26, 3611,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x30\x23\x66\xcc\x98\x91\x33\x1f\x06\x0c\x0c\x18"
            "\x00" }  },
      /* --- pixel bitmap for cmmib131 char#27 \sigma --- */
      {  27, 3654,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xfb\x6f\xc6\x18\x63\x8c\x30\x83\x03" }  },
      /* --- pixel bitmap for cmmib131 char#28 \tau --- */
      {  28, 3687,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xfd\x47\xc0\x80\x01\x03\x03\x06" }  },
      /* --- pixel bitmap for cmmib131 char#29 \upsilon --- */
      {  29, 3712,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8c\x35\x67\x64\xc8\x90\x11\x13\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#30 \phi --- */
      {  30, 3753,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x00\x01\x04\x10\x40\xe0\xc3\x92\xc9\x23\x4f\x3c"
            "\x99\x34\x7c\x20\x80\x00\x02\x08\x00" }  },
      /* --- pixel bitmap for cmmib131 char#31 \chi --- */
      {  31, 3818,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0e\xd4\x10\x46\x60\x01\x07\x18\x80\x01\x0e\x68\x20"
            "\x86\xb0\x02\x07" }  },
      /* --- pixel bitmap for cmmib131 char#32 \psi --- */
      {  32, 3869,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x01\x10\x00\x01\x08\x80\xc0\x48\x9a\x9c\x45\x4c"
            "\xc4\x44\x4c\xc2\x12\xf8\x00\x02\x20\x00\x01\x10\x00" }  },
      /* --- pixel bitmap for cmmib131 char#33 \omega --- */
      {  33, 3942,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x04\x12\xf0\x88\x62\x14\xa3\x98\xfc\xc7\x1d" }  },
      /* --- pixel bitmap for cmmib131 char#34 \varepsilon --- */
      {  34, 3987,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x7f\xe8\xd3\x08\xfc\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#35 \vartheta --- */
      {  35, 4014,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x81\x0c\x32\xc8\x20\x3b\xad\x79\x63\x8c\x31\xc6"
            "\x0c\x13\x38\x00" }  },
      /* --- pixel bitmap for cmmib131 char#36 \varpi --- */
      {  36, 4075,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xff\xfe\xff\x09\x20\x04\x21\x84\x21\xc4\x11\x7c"
            "\x1f\x38\x0e" }  },
      /* --- pixel bitmap for cmmib131 char#37 \varrho --- */
      {  37, 4118,                      /* character number, location */
          8, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\xcc\xc4\xc6\xc6\x46\x67\x1d\x01\x01\x3f\x3e" }  },
      /* --- pixel bitmap for cmmib131 char#38 \varsigma --- */
      {  38, 4163,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x83\x60\x30\x38\x78\x70\x30\x0e" }  },
      /* --- pixel bitmap for cmmib131 char#39 \varphi --- */
      {  39, 4190,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc4\x89\x1f\x63\x84\x09\x2e\xe6\x0f\x1f\x0c\x10\x60"
            "\x80\x01" }  },
      /* --- pixel bitmap for cmmib131 char#40 \leftharpoonup --- */
      {  40, 4862,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 18,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x00\xe0\x00\x80\x01\x00\x03\x00\xfe\xff\xff\xff"
            "\x0f" }  },
      /* --- pixel bitmap for cmmib131 char#41 \leftharpoondown --- */
      {  41, 4881,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\xfb\xff\xcf\x00\x00\x06\x00\x38\x00\xc0\x00"
            "\x00" }  },
      /* --- pixel bitmap for cmmib131 char#42 \rightharpoonup --- */
      {  42, 4900,                      /* character number, location */
         10, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 18,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x30\x00\xc0\x01\x00\x06\x00\x30\xff\xff\xff\xff"
            "\x0f" }  },
      /* --- pixel bitmap for cmmib131 char#43 \rightharpoondown --- */
      {  43, 4919,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\xff\xff\x0f\x00\x0c\x00\x18\x00\x70\x00\xc0"
            "\x00" }  },
      /* --- pixel bitmap for cmmib131 char#44 ` --- */
      {  44, 4938,                      /* character number, location */
         12, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\xb6\xdd" }  },
      /* --- pixel bitmap for cmmib131 char#45 ' --- */
      {  45, 4961,                      /* character number, location */
         12, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbb\x6d\x7f" }  },
      /* --- pixel bitmap for cmmib131 char#46 \triangleright --- */
      {  46, 4984,                      /* character number, location */
          9, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x83\xc7\x67\xbf\xff\x3c\x06" }  },
      /* --- pixel bitmap for cmmib131 char#47 \triangleleft --- */
      {  47, 5011,                      /* character number, location */
          9, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x60\x3c\xff\xfd\xe6\xe3\xc1" }  },
      /* --- pixel bitmap for cmmib131 char#48 \0 --- */
      {  48, 4484,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbe\xf1\x78\x3c\x1e\x8f\x7d" }  },
      /* --- pixel bitmap for cmmib131 char#49 \1 --- */
      {  49, 4519,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc8\xc3\x30\x0c\xc3\xf8" }  },
      /* --- pixel bitmap for cmmib131 char#50 \2 --- */
      {  50, 4542,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xbe\x39\x18\x0c\xe7\xfb\xff" }  },
      /* --- pixel bitmap for cmmib131 char#51 \3 --- */
      {  51, 4567,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9e\xf9\x5c\x0e\xe3\xc0\xe0\xf7\xfb\xcc\x03" }  },
      /* --- pixel bitmap for cmmib131 char#52 \4 --- */
      {  52, 4610,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x30\x38\x3c\x34\x32\x33\xff\x30\x30\x30\xfc" }  },
      /* --- pixel bitmap for cmmib131 char#53 \5 --- */
      {  53, 4647,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x22\x9f\xc7\x20\xf0\xc8\xe0\xf3\x79\xcc\x03" }  },
      /* --- pixel bitmap for cmmib131 char#54 \6 --- */
      {  54, 4688,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xb2\x78\xf0\x39\x8d\xc7\xe3\xb1\x89\x03" }  },
      /* --- pixel bitmap for cmmib131 char#55 \7 --- */
      {  55, 4735,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\xff\x7f\x41\x21\x10\x18\x08\x08\x0c\x0c\x0c\x0c" }  },
      /* --- pixel bitmap for cmmib131 char#56 \8 --- */
      {  56, 4772,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xf1\xf8\xfc\xf3\xf9\xe7\xe3\xb1\x88\x03" }  },
      /* --- pixel bitmap for cmmib131 char#57 \9 --- */
      {  57, 4817,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\xd9\x78\x3c\x16\xf3\xc1\xe0\xd1\xcc\x01" }  },
      /* --- pixel bitmap for cmmib131 char#58 . --- */
      {  58, 5038,                      /* character number, location */
          3, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmib131 char#59 , --- */
      {  59, 5051,                      /* character number, location */
          3, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xba\x49\x09" }  },
      /* --- pixel bitmap for cmmib131 char#60 < --- */
      {  60, 5072,                      /* character number, location */
         12, 2,    -2, 2,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x06\x38\xf0\xe0\x81\x03\x0f\x1c\xe0\x00\x1e\xc0"
            "\x01\x3c\x80\x07\x70\x00\x03" }  },
      /* --- pixel bitmap for cmmib131 char#61 / --- */
      {  61, 5107,                      /* character number, location */
         14, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  7,    19, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x60\x30\x1c\x06\x83\xe1\x30\x18\x0e\x83\xe1\x30\x18"
            "\x0c\x87\xc1\x00" }  },
      /* --- pixel bitmap for cmmib131 char#62 > --- */
      {  62, 5152,                      /* character number, location */
         12, 2,    -2, 2,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x03\x38\x80\x07\xf0\x00\x0e\xe0\x01\x1c\xe0\xc0\x03"
            "\x07\x1e\x3c\x70\x80\x01\x00" }  },
      /* --- pixel bitmap for cmmib131 char#63 \star --- */
      {  63, 5187,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x80\x00\x02\x08\xfe\xe3\x03\x07\x36\x88\x10\x04" }  },
      /* --- pixel bitmap for cmmib131 char#64 \partial --- */
      {  64, 4241,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x30\x46\x30\xc1\x00\xe3\x4d\xb8\x60\x83\x0d\x36"
            "\xcc\x18\x3e\x00" }  },
      /* --- pixel bitmap for cmmib131 char#65 A --- */
      {  65,   35,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x02\x60\x00\x0e\xc0\x03\x74\x40\x0e\xc8\x81\x38"
            "\xf8\x07\xe1\x10\xb8\xc7\x0f" }  },
      /* --- pixel bitmap for cmmib131 char#66 B --- */
      {  66,   80,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\x38\x0e\x07\xc3\xe1\x70\x38\xfc\x83\xc3\xe3"
            "\xe0\x38\x38\x0e\xc6\xc1\xfd\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#67 C --- */
      {  67,  129,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x37\x1c\x8e\x01\x31\x40\x0e\x80\x03\x70\x00\x1c"
            "\x00\x07\x88\x01\xc1\x20\xe0\x07" }  },
      /* --- pixel bitmap for cmmib131 char#68 D --- */
      {  68,  174,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 16,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\xe0\x70\x70\x60\x70\xe0\x70\xe0\x70\xe0\x38"
            "\x70\x38\x70\x38\x30\x38\x38\x1c\x1c\xff\x07" }  },
      /* --- pixel bitmap for cmmib131 char#69 E --- */
      {  69,  225,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x3f\x38\x0c\x07\xc2\x91\x70\x24\xfc\x81\x23\xe0"
            "\x48\x38\x10\x0e\xc2\xc1\xfc\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#70 F --- */
      {  70,  280,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\x1c\xc3\x41\x38\x09\x27\xe1\x07\x4e\xc0\x09"
            "\x38\x00\x07\x70\x80\x3f\x00" }  },
      /* --- pixel bitmap for cmmib131 char#71 G --- */
      {  71,  327,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x37\x1c\x8e\x01\x31\x40\x0e\x80\x03\x70\xf8\x1f"
            "\x38\x07\x8e\x81\xc3\x70\xe0\x13" }  },
      /* --- pixel bitmap for cmmib131 char#72 H --- */
      {  72,  378,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xfb\x83\x83\x03\x07\x07\x1c\x1c\x70\x70\xc0\xff"
            "\x81\x83\x03\x0e\x0e\x38\x38\xe0\xe0\xc0\xc1\xc1\xdf"
            "\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#73 I --- */
      {  73,  431,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x83\x03\x07\x1c\x70\xc0\x81\x03\x0e\x38\xe0\xc0"
            "\xc1\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#74 J --- */
      {  74,  462,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x0f\x70\x80\x03\x38\x80\x03\x38\xc0\x01\x1c\xc0"
            "\xe1\x1c\xe7\xe0\x07" }  },
      /* --- pixel bitmap for cmmib131 char#75 K --- */
      {  75,  497,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 17,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xe3\xc1\xc1\xc0\x41\x80\x63\x00\x27\x00\x6e\x00"
            "\xde\x01\x9c\x03\x38\x0e\x70\x1c\x70\x70\xf8\xf3\x01" }  },
      /* --- pixel bitmap for cmmib131 char#76 L --- */
      {  76,  552,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x03\x0e\x70\x00\x07\x70\x00\x07\x38\x80\x83\x38"
            "\x88\x43\x1c\xf6\x3f" }  },
      /* --- pixel bitmap for cmmib131 char#77 M --- */
      {  77,  591,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 22,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x01\x3f\x78\xa0\x03\x1d\x78\x40\x07\x1d\xd0\x21"
            "\x07\xe4\xc8\x81\x38\x39\x20\x2e\x0e\x88\x87\x03\xe2"
            "\xe1\x40\x30\x1c\x7c\xc4\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#78 N --- */
      {  78,  678,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 18,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xe0\x83\x07\x02\x1d\x04\xe4\x10\x10\x47\x40\x1c"
            "\x81\xe0\x02\x82\x0f\x08\x3c\x20\xe0\x40\x80\xc1\x07"
            "\x04" }  },
      /* --- pixel bitmap for cmmib131 char#79 O --- */
      {  79,  743,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x07\x0c\xc7\x81\x31\xe0\x0e\xb8\x03\x7e\xc0\x1d"
            "\x70\x07\x8c\x81\xe3\x30\xe0\x07" }  },
      /* --- pixel bitmap for cmmib131 char#80 P --- */
      {  80,  794,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\x38\x0e\x87\xc3\xe1\x70\x38\x1c\x87\x7f\xe0"
            "\x00\x38\x00\x0e\xc0\x01\xfc\x01" }  },
      /* --- pixel bitmap for cmmib131 char#81 Q --- */
      {  81,  835,                      /* character number, location */
         12, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 14,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x07\x0c\xc7\x81\x31\xe0\x0e\xb8\x03\x7e\xc0\x1d"
            "\x70\x07\x8c\x99\xe3\x39\xe0\x27\x80\x08\xe0\x01\x78"
            "\x00\x0c" }  },
      /* --- pixel bitmap for cmmib131 char#82 R --- */
      {  82,  900,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\x70\x1c\x1c\x0e\x0e\x07\x87\x81\x7f\xe0\x38"
            "\x70\x1c\x38\x0e\x1c\x07\x87\xf3\x8f\x07" }  },
      /* --- pixel bitmap for cmmib131 char#83 S --- */
      {  83,  953,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\xc7\x30\x82\x18\xc0\x0f\xfe\xe0\x0f\x70\x00\x13"
            "\xc8\x60\xfe\x00" }  },
      /* --- pixel bitmap for cmmib131 char#84 T --- */
      {  84,  992,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x5f\x38\x87\xa3\x70\x14\x8e\xc0\x01\x1c\x80\x03"
            "\x70\x00\x0e\xe0\x80\xff\x00" }  },
      /* --- pixel bitmap for cmmib131 char#85 U --- */
      {  85, 1039,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\x7c\x0e\x88\x03\xc2\x01\xe1\x80\x70\x40\x1c\x10"
            "\x0e\x08\x07\x84\x03\x81\x41\x80\x1f\x00" }  },
      /* --- pixel bitmap for cmmib131 char#86 V --- */
      {  86, 1092,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\x3c\x07\xc2\xc1\xf0\x10\x38\x02\x4e\x80\x13\xe0"
            "\x02\x78\x00\x1e\x00\x03\x40\x00" }  },
      /* --- pixel bitmap for cmmib131 char#87 W --- */
      {  87, 1139,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 20,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\x3f\xcf\xe1\x21\x1c\x1e\xc2\xf1\x11\x1c\x9d\xc1"
            "\xc9\x09\xbc\x5c\x80\xc7\x05\x38\x3c\x80\xc3\x01\x18"
            "\x18\x80\x81\x00" }  },
      /* --- pixel bitmap for cmmib131 char#88 X --- */
      {  88, 1216,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x7d\x70\x04\x38\x03\xfc\x00\x3c\x00\x1e\x00\x0f"
            "\x80\x07\xa0\x07\x88\x03\xc2\xe3\xf3\x03" }  },
      /* --- pixel bitmap for cmmib131 char#89 Y --- */
      {  89, 1261,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\x3c\x07\xc2\x43\xe0\x08\x78\x01\x7c\x00\x0f\xc0"
            "\x01\x70\x00\x1c\x80\x03\xf8\x03" }  },
      /* --- pixel bitmap for cmmib131 char#90 Z --- */
      {  90, 1302,                      /* character number, location */
         12, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x1f\xc3\x31\x1c\xc2\x41\x1c\xc0\x03\x3c\x80\x23"
            "\x38\x84\xc3\x38\x8c\xff\x01" }  },
      /* --- pixel bitmap for cmmib131 char#91 \flat --- */
      {  91, 5220,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x21\x84\x10\xc2\xcb\x39\xb7\x32\x02" }  },
      /* --- pixel bitmap for cmmib131 char#92 \natural --- */
      {  92, 5265,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x21\x84\x90\xff\x9f\x31\xc6\x98\xff\x9f\x10\x02" }  },
      /* --- pixel bitmap for cmmib131 char#93 \sharp --- */
      {  93, 5324,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x48\x29\xed\xdf\x52\x4a\x29\xed\xdf\x52\x02" }  },
      /* --- pixel bitmap for cmmib131 char#94 \smile --- */
      {  94, 5387,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 18,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x00\x0a\x00\xc4\x01\x0e\xfe\x1f\xc0\x0f\x00" }  },
      /* --- pixel bitmap for cmmib131 char#95 \frown --- */
      {  95, 5410,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 18,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x1f\xe0\xff\xc1\x00\x8c\x00\x40\x01\x00\x02" }  },
      /* --- pixel bitmap for cmmib131 char#96 \ell --- */
      {  96, 4294,                      /* character number, location */
         13,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x40\xc2\x84\x84\x09\x0b\x0e\x0e\x0c\x18\x38\x40"
            "\x04\x07" }  },
      /* --- pixel bitmap for cmmib131 char#97 a --- */
      {  97, 1349,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xe6\x62\x63\x63\xe3\xb3\x6e" }  },
      /* --- pixel bitmap for cmmib131 char#98 b --- */
      {  98, 1388,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0e\x06\xc3\x60\xf0\x99\xc7\xe3\xf1\x68\xe6\x00" }  },
      /* --- pixel bitmap for cmmib131 char#99 c --- */
      {  99, 1433,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xb3\x68\x30\x18\x8c\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#100 d --- */
      { 100, 1462,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x01\x03\x06\x06\x0c\x9f\x39\x31\x63\xc6\x8c\x9b"
            "\xe5\x06" }  },
      /* --- pixel bitmap for cmmib131 char#101 e --- */
      { 101, 1511,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb8\x29\x7e\xc3\x30\x7a" }  },
      /* --- pixel bitmap for cmmib131 char#102 f --- */
      { 102, 1540,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\xc0\x83\x03\x03\x83\x3f\x0c\x18\x30\x30\x60\xc0"
            "\x80\x01\x83\x83\x07\x06\x00" }  },
      /* --- pixel bitmap for cmmib131 char#103 g --- */
      { 103, 1581,                      /* character number, location */
          8,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x63\x8e\x18\x63\x8c\x31\xc6\x0c\x3e\xc0\x00\x23"
            "\x86\x0f" }  },
      /* --- pixel bitmap for cmmib131 char#104 h --- */
      { 104, 1626,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x30\x60\x60\xc0\x80\x1f\x33\x63\xc6\x8c\x99\x1d"
            "\x37\x0c" }  },
      /* --- pixel bitmap for cmmib131 char#105 i --- */
      { 105, 1675,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x03\x00\x80\x73\x8d\x19\xeb\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#106 j --- */
      { 106, 1708,                      /* character number, location */
         14, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  8,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x80\x00\x00\x00\x00\x70\xc8\x64\x60\x60\x60\x30"
            "\x30\x30\x30\x1a\x06" }  },
      /* --- pixel bitmap for cmmib131 char#107 k --- */
      { 107, 1751,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x30\x60\x60\xc0\x80\x19\x6b\x4b\x0e\x3c\xd8\x9a"
            "\x32\x07" }  },
      /* --- pixel bitmap for cmmib131 char#108 l --- */
      { 108, 1804,                      /* character number, location */
         13, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\x63\xc6\x18\x33\xc6\xb8\x65\x00" }  },
      /* --- pixel bitmap for cmmib131 char#109 m --- */
      { 109, 1839,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xee\x3d\x9a\x33\x8d\x31\x8c\x31\x8c\x31\x8c\x99\xc6"
            "\x58\xc6\x30" }  },
      /* --- pixel bitmap for cmmib131 char#110 n --- */
      { 110, 1902,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xee\xd1\x4c\x63\x18\xc3\x18\x66\x1a\xcb\x30" }  },
      /* --- pixel bitmap for cmmib131 char#111 o --- */
      { 111, 1949,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xb3\x78\x3c\x1e\xcd\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#112 p --- */
      { 112, 1984,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 10,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xdc\xd1\xac\x31\xc6\x18\x63\xc4\x19\x1f\x0c\x30\x60"
            "\xc0\x03" }  },
      /* --- pixel bitmap for cmmib131 char#113 q --- */
      { 113, 2033,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb8\xe6\x62\x63\x63\x63\x33\x3e\x30\x30\x18\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#114 r --- */
      { 114, 2078,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x6e\xda\x4d\x0c\x0c\x0c\x06\x06" }  },
      /* --- pixel bitmap for cmmib131 char#115 s --- */
      { 115, 2111,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\xc8\x4c\x78\xf0\x82\x43\x3e" }  },
      /* --- pixel bitmap for cmmib131 char#116 t --- */
      { 116, 2142,                      /* character number, location */
         12, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x33\xf6\x99\x31\xc6\x2e\x03" }  },
      /* --- pixel bitmap for cmmib131 char#117 u --- */
      { 117, 2177,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8c\x69\x96\x0d\x33\xcc\x30\xcb\x16\x76" }  },
      /* --- pixel bitmap for cmmib131 char#118 v --- */
      { 118, 2224,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xcc\xda\x99\x8c\x8c\x4c\x4c\x38" }  },
      /* --- pixel bitmap for cmmib131 char#119 w --- */
      { 119, 2265,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8c\x49\x33\x67\x23\x66\xc4\x8c\x98\x11\x33\xc1\x1d" }  },
      /* --- pixel bitmap for cmmib131 char#120 x --- */
      { 120, 2322,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb8\x23\xb3\x8c\x60\x00\x03\x19\xed\xc4\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#121 y --- */
      { 121, 2365,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8c\x35\x67\x63\xc6\x8c\x19\x1b\x3c\x60\x64\x4c\x70"
            "\x00" }  },
      /* --- pixel bitmap for cmmib131 char#122 z --- */
      { 122, 2418,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xf9\x01\x81\x81\x81\x90\x9f\x18" }  },
      /* --- pixel bitmap for cmmib131 char#123 \imath --- */
      { 123, 4339,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xce\x35\x66\xac\x73" }  },
      /* --- pixel bitmap for cmmib131 char#124 \jmath --- */
      { 124, 4366,                      /* character number, location */
          8, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  7,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x34\x0d\x06\x83\x61\x30\x18\x8c\xc3\x00" }  },
      /* --- pixel bitmap for cmmib131 char#125 \wp --- */
      { 125, 4401,                      /* character number, location */
          8, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x60\x9e\x8d\x1d\x6c\x60\x03\x59\xec\x3d\x1d\xc8"
            "\x40\x03\x0c\x00" }  },
      /* --- pixel bitmap for cmmib131 char#126 \vec --- */
      { 126, 4456,                      /* character number, location */
         13, 4,     9, 4,     /* topleft row,col, and botleft row,col */
          {  7,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x98\xff\x9f\x03" }  },
      /* --- pixel bitmap for cmmib131 char#127 (noname) --- */
      { 127, 4471,                      /* character number, location */
         12, 5,    10, 5,     /* topleft row,col, and botleft row,col */
          {  8,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7e\x81" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=4 ---
 * mf '\mode=itoh; input cmmib10'       gives .gf160
 * ------------------------------------------------- */
/* --- fontdef for cmmib160 --- */
static	chardef  cmmib160[] =
   {
      /* --- pixel bitmap for cmmib160 char#0 \Gamma --- */
      {   0, 2769,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x7f\x70\x30\x38\x10\x1c\x08\x0e\x84\x03\xc0\x01"
            "\xe0\x00\x70\x00\x1c\x00\x0e\x00\x07\xc0\x01\xf8\x07"
            "\x00" }  },
      /* --- pixel bitmap for cmmib160 char#1 \Delta --- */
      {   1, 2812,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x30\x00\xe0\x00\xc0\x03\x80\x1e\x00\x71\x00\xc6"
            "\x01\x08\x0f\x10\x3c\x20\xe0\x40\x80\x87\x00\x1e\x01"
            "\x70\xfe\xff\xff\xff\x0f" }  },
      /* --- pixel bitmap for cmmib160 char#2 \Theta --- */
      {   2, 2865,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x3f\xe0\xc0\xe1\x00\xe3\x00\xee\x00\xdc\x04\xf9"
            "\xf9\xf3\xf3\xe7\x27\xe8\x0e\xc0\x1d\xc0\x39\xc0\xe1"
            "\xc0\x01\x7f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#3 \Lambda --- */
      {   3, 2936,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x08\x00\x06\x80\x03\xe0\x01\xf0\x00\xf4\x00\x73"
            "\x80\x38\x20\x1c\x08\x0e\x04\x07\x81\x43\xc0\xf9\xf8"
            "\x03" }  },
      /* --- pixel bitmap for cmmib160 char#4 \Xi --- */
      {   4, 2989,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\xe3\xff\x87\x00\x10\x02\x40\x00\x00\x40\x80"
            "\x00\xff\x03\xfc\x0f\x00\x00\x00\x00\x20\x00\x84\x00"
            "\x10\xff\x3f\xfc\xff\x00" }  },
      /* --- pixel bitmap for cmmib160 char#5 \Pi --- */
      {   5, 3032,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xff\x1f\x1c\x70\x80\x03\x0e\x70\xc0\x01\x0e\x38"
            "\xe0\x80\x03\x1c\x70\x80\x03\x0e\x70\xc0\x01\x07\x1c"
            "\xe0\x80\x03\x1c\x70\xc0\x01\x07\xfe\xf9\x07" }  },
      /* --- pixel bitmap for cmmib160 char#6 \Sigma --- */
      {   6, 3093,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\xc3\x03\x0e\x0e\x30\x78\x80\xc0\x01\x02\x0f"
            "\x00\x38\x00\xe0\x00\x80\x01\x00\x01\x02\x03\x08\x02"
            "\x10\x06\x70\xfc\xff\x00" }  },
      /* --- pixel bitmap for cmmib160 char#7 \Upsilon --- */
      {   7, 3144,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xf0\xfc\xf0\x87\x33\x04\x36\x00\x3c\x00\x78\x00"
            "\x70\x00\xe0\x00\xc0\x01\xc0\x01\x80\x03\x00\x07\x00"
            "\x07\xc0\x7f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#8 \Phi --- */
      {   8, 3191,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x3f\xc0\x01\xe0\x00\xfe\xc1\xb9\x73\x8e\x1f\xc7"
            "\x8f\xe3\xc7\x39\x77\x0e\xff\x00\x1c\x00\x07\xf0\x1f"
            "\x00" }  },
      /* --- pixel bitmap for cmmib160 char#9 \Psi --- */
      {   9, 3250,                      /* character number, location */
         14, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x3f\x00\x07\x00\x0e\x78\x1c\xef\x38\xc7\x39\x87"
            "\x73\x0e\xe7\x1c\xce\x1d\xf8\x1d\xe0\x0f\x00\x07\x00"
            "\x07\xc0\x7f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#10 \Omega --- */
      {  10, 3311,                      /* character number, location */
         14, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x3f\xe0\xc1\xe0\x00\xe3\x00\xce\x01\xdc\x01\x9c"
            "\x03\x38\x06\x38\x0c\x30\x18\x30\x24\x20\x49\x20\xf1"
            "\xe0\xe3\xc1\x03" }  },
      /* --- pixel bitmap for cmmib160 char#11 \alpha --- */
      {  11, 3380,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x01\xc7\x68\x60\x1a\x58\x03\xd6\x80\x33\x60\x18"
            "\x1e\x7c\x1c" }  },
      /* --- pixel bitmap for cmmib160 char#12 \beta --- */
      {  12, 3429,                      /* character number, location */
         14, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 13,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x0f\x18\x83\x60\x08\x0c\x81\x90\x1f\xf2\x43\x60"
            "\x08\x8c\x80\x11\x30\x02\xa3\x30\xe4\x83\x00\x10\x00"
            "\x01\x20\x00\x00" }  },
      /* --- pixel bitmap for cmmib160 char#13 \gamma --- */
      {  13, 3500,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\xe8\x87\x63\x04\x48\x80\x02\x28\x80\x01\x18\x80"
            "\x00\x08\x80\x00\x04\x40\x00" }  },
      /* --- pixel bitmap for cmmib160 char#14 \delta --- */
      {  14, 3547,                      /* character number, location */
         15, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    15, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\xe0\x63\xc4\x00\x03\x06\x1c\x76\xc6\x8c\x0d\x1b"
            "\x36\x44\x0c\x0f" }  },
      /* --- pixel bitmap for cmmib160 char#15 \epsilon --- */
      {  15, 3600,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x0c\x06\x06\x7f\x03\x03\x06\x7c" }  },
      /* --- pixel bitmap for cmmib160 char#16 \zeta --- */
      {  16, 3625,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x00\x02\x3c\xf8\x18\x30\x40\x80\x01\x06\x0c\x30"
            "\xc0\x01\x0e\xf0\x81\x0f\x60\x80\xc0\x03" }  },
      /* --- pixel bitmap for cmmib160 char#17 \eta --- */
      {  17, 3668,                      /* character number, location */
          9, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc6\xeb\x71\x83\x19\x6c\x30\x83\x19\x6c\x30\x83\x01"
            "\x0c\x60\x80\x01\x0c" }  },
      /* --- pixel bitmap for cmmib160 char#18 \theta --- */
      {  18, 3723,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\xc1\x8c\x21\x83\x0c\x1a\xec\xbf\xff\x86\x0d\x36"
            "\x88\x30\x66\x70\x00" }  },
      /* --- pixel bitmap for cmmib160 char#19 \iota --- */
      {  19, 3778,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\xc3\x18\x86\x31\x4e\x0e" }  },
      /* --- pixel bitmap for cmmib160 char#20 \kappa --- */
      {  20, 3807,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\xc7\x78\x6c\xc0\x03\xfe\x60\x1c\x86\x39\x58\x03"
            "\x07" }  },
      /* --- pixel bitmap for cmmib160 char#21 \lambda --- */
      {  21, 3850,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\x00\x06\x60\x00\x0e\xc0\x00\x0c\x80\x01\x18\x40"
            "\x03\x33\x18\xc7\x60\x06\x36\xc0" }  },
      /* --- pixel bitmap for cmmib160 char#22 \mu --- */
      {  22, 3897,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x08\x83\x61\x30\x0c\xc6\x60\x18\x0c\x83\x75\x7c"
            "\x7e\xcc\x00\x18\x80\x01\x30\x00\x00" }  },
      /* --- pixel bitmap for cmmib160 char#23 \nu --- */
      {  23, 3950,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0e\x64\x30\x83\x19\x66\x18\x63\x98\x61\x03\x07\x00" }  },
      /* --- pixel bitmap for cmmib160 char#24 \xi --- */
      {  24, 3991,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x00\x01\x3e\xfe\x0c\x18\x60\x00\x3f\xfc\x18\x30"
            "\xc0\x00\x03\x78\xc0\x0f\x78\x80\xc0\x03" }  },
      /* --- pixel bitmap for cmmib160 char#25 \pi --- */
      {  25, 4034,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xef\xff\x91\x80\x09\x88\x80\x08\x8c\x60\x18\x86"
            "\x01" }  },
      /* --- pixel bitmap for cmmib160 char#26 \rho --- */
      {  26, 4075,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x83\x31\x06\x31\xcc\x60\x06\x33\xcc\x31\xf6\x30"
            "\x80\x01\x06\x30\x00" }  },
      /* --- pixel bitmap for cmmib160 char#27 \sigma --- */
      {  27, 4124,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xcf\xff\x8e\x61\x18\x83\x31\x18\xc3\x20\x06\x3c"
            "\x00" }  },
      /* --- pixel bitmap for cmmib160 char#28 \tau --- */
      {  28, 4161,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xf7\x7f\x04\x20\x00\x01\x0c\x60\x80\x01\x0c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#29 \upsilon --- */
      {  29, 4188,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\x6e\x70\x03\x19\x68\x20\x03\x19\xc4\x10\x78\x00" }  },
      /* --- pixel bitmap for cmmib160 char#30 \phi --- */
      {  30, 4233,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 13,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x02\x20\x00\x04\x80\x00\x10\xe0\x0f\x26\x33\xc4"
            "\x86\x78\x08\x0f\xe1\x21\x66\x72\xf8\x03\x08\x00\x01"
            "\x10\x00\x02\x00" }  },
      /* --- pixel bitmap for cmmib160 char#31 \chi --- */
      {  31, 4304,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 14,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1c\xa0\x0e\x04\x83\x80\x11\x60\x02\x70\x00\x0c\x00"
            "\x07\xa0\x01\xe6\x40\x30\x08\x58\x01\x1c" }  },
      /* --- pixel bitmap for cmmib160 char#32 \psi --- */
      {  32, 4361,                      /* character number, location */
         14, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          { 14,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x02\x80\x00\x20\x00\x08\x00\x81\x41\xdc\x10\x37"
            "\x82\x8c\xa0\x21\x64\x08\x19\x21\x4c\x06\x7e\x00\x04"
            "\x80\x00\x20\x00\x08\x00" }  },
      /* --- pixel bitmap for cmmib160 char#33 \omega --- */
      {  33, 4440,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\xb0\x01\x2c\x00\x0b\xc2\xc1\x50\x30\x74\xce\xf8"
            "\x3e\x9c\x07" }  },
      /* --- pixel bitmap for cmmib160 char#34 \varepsilon --- */
      {  34, 4491,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xf8\x0b\xd2\xe1\x23\x40\x80\x3f\x3e\x00" }  },
      /* --- pixel bitmap for cmmib160 char#35 \vartheta --- */
      {  35, 4520,                      /* character number, location */
         14, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x03\xc8\x80\x10\x10\x02\x42\x8c\x4d\xc3\x6b\xf0"
            "\x0c\xc3\x60\x18\x04\xc3\x60\x0c\x78\x00" }  },
      /* --- pixel bitmap for cmmib160 char#36 \varpi --- */
      {  36, 4585,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 19,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xff\xf7\xff\x7f\x02\x40\x10\x08\x42\x20\x10\x82"
            "\x81\x10\x1e\x83\x9f\x0f\x38\x3c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#37 \varrho --- */
      {  37, 4634,                      /* character number, location */
          9, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x61\xcc\x20\xc3\x06\x1b\x6c\x58\x31\x79\x04\x10"
            "\xc0\x3f\xfe\x00" }  },
      /* --- pixel bitmap for cmmib160 char#38 \varsigma --- */
      {  38, 4685,                      /* character number, location */
          9, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x39\x1a\x30\x70\xc0\x00\x07\x3c\x60\x80\xc0\x00" }  },
      /* --- pixel bitmap for cmmib160 char#39 \varphi --- */
      {  39, 4716,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x04\x8e\xe0\x0b\x46\x21\x18\x04\x03\xa0\x09\xf3\x3f"
            "\xf8\x01\x06\x40\x00\x0c\x80\x01\x00" }  },
      /* --- pixel bitmap for cmmib160 char#40 \leftharpoonup --- */
      {  40, 5466,                      /* character number, location */
         11, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x00\x00\x18\x00\x00\x03\x00\xe0\x00\x00\x1c\x00"
            "\xc0\xff\xff\xff\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmib160 char#41 \leftharpoondown --- */
      {  41, 5487,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\xbf\xff\xff\xcf\x01\x00\xe0\x00\x00\x30\x00"
            "\x00\x18\x00\x00\x02\x00\x00" }  },
      /* --- pixel bitmap for cmmib160 char#42 \rightharpoonup --- */
      {  42, 5508,                      /* character number, location */
         11, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x00\x01\x00\x60\x00\x00\x30\x00\x00\x1c\x00\x00"
            "\xce\xff\xff\xff\xff\xff\x03" }  },
      /* --- pixel bitmap for cmmib160 char#43 \rightharpoondown --- */
      {  43, 5529,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 22,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\xff\xff\xff\x07\x00\xe0\x00\x00\x1c\x00\x00"
            "\x03\x00\x60\x00\x00\x10\x00" }  },
      /* --- pixel bitmap for cmmib160 char#44 ` --- */
      {  44, 5550,                      /* character number, location */
         11, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x33\xf3\x0e" }  },
      /* --- pixel bitmap for cmmib160 char#45 ' --- */
      {  45, 5571,                      /* character number, location */
         11, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  4,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf7\xcc\xfc\x07" }  },
      /* --- pixel bitmap for cmmib160 char#46 \triangleright --- */
      {  46, 5592,                      /* character number, location */
         11, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x03\xf0\x00\x3f\x30\x0f\xc3\x33\xf0\x03\x3f\x3c\xf3"
            "\xf0\x03\x0f\x30\x00" }  },
      /* --- pixel bitmap for cmmib160 char#47 \triangleleft --- */
      {  47, 5635,                      /* character number, location */
         11, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 12,    12, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x0c\xf0\xc0\x0f\xcf\x3c\xfc\xc0\x0f\xcc\xc3\xf0"
            "\x0c\xfc\x00\x0f\xc0" }  },
      /* --- pixel bitmap for cmmib160 char#48 \0 --- */
      {  48, 5046,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x18\x36\xf0\xc0\x03\x0f\x3c\xb0\x61\xfc\x00" }  },
      /* --- pixel bitmap for cmmib160 char#49 \1 --- */
      {  49, 5085,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x1f\x18\x18\x18\x18\x18\x18\xff" }  },
      /* --- pixel bitmap for cmmib160 char#50 \2 --- */
      {  50, 5110,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x0c\x36\x30\xe0\x80\x81\x83\xa1\x7f\xff\x01" }  },
      /* --- pixel bitmap for cmmib160 char#51 \3 --- */
      {  51, 5141,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x18\xe7\x18\x71\xc0\xe0\x01\x1c\xe0\x80\x1f\x7e"
            "\xb8\x70\x7c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#52 \4 --- */
      {  52, 5186,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x80\x03\x0e\x34\xc8\x10\x63\xcc\x30\xff\x03\x03"
            "\x0c\x30\xf0\x03" }  },
      /* --- pixel bitmap for cmmib160 char#53 \5 --- */
      {  53, 5229,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\xf9\xe3\x87\x00\x02\xe8\x63\x18\xe0\x80\x1f\x3e"
            "\xb8\x70\x7c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#54 \6 --- */
      {  54, 5274,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x30\x66\x98\x00\x03\xec\x73\xd8\xc0\x03\x0f\x6c"
            "\x30\x61\xf8\x00" }  },
      /* --- pixel bitmap for cmmib160 char#55 \7 --- */
      {  55, 5325,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x02\xf0\xbf\xff\x02\x12\x08\x20\x00\x01\x04\x30\x80"
            "\x01\x06\x30\x80\x01\x0c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#56 \8 --- */
      {  56, 5364,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x10\x63\x98\x61\x9e\xf0\xc1\x9f\x79\x83\x0f\x3c"
            "\xb0\x61\xfc\x00" }  },
      /* --- pixel bitmap for cmmib160 char#57 \9 --- */
      {  57, 5415,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\x18\x32\xd0\xc0\x03\x0f\x6c\x38\xdf\x00\x03\x64"
            "\x98\x31\x3c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#58 . --- */
      {  58, 5678,                      /* character number, location */
          3, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmib160 char#59 , --- */
      {  59, 5691,                      /* character number, location */
          3, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  3,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfa\x49\x05" }  },
      /* --- pixel bitmap for cmmib160 char#60 < --- */
      {  60, 5712,                      /* character number, location */
         12, 2,    -2, 2,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x70\x00\x1e\xc0\x03\x78\x00\x0f\xe0\x01\x3c\x00"
            "\x1e\x00\x3c\x00\x78\x00\xf0\x00\xe0\x01\xc0\x03\x80"
            "\x03" }  },
      /* --- pixel bitmap for cmmib160 char#61 / --- */
      {  61, 5747,                      /* character number, location */
         15, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 10,    20, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x03\x0c\x38\x60\xc0\x01\x03\x0e\x18\x70\xc0\x00"
            "\x03\x0e\x18\x70\xc0\x80\x03\x06\x1c\x30\xc0\x00" }  },
      /* --- pixel bitmap for cmmib160 char#62 > --- */
      {  62, 5794,                      /* character number, location */
         12, 2,    -2, 2,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x07\x00\x0f\x00\x1e\x00\x3c\x00\x78\x00\xf0\x00\xe0"
            "\x01\xf0\x00\x1e\xc0\x03\x78\x00\x0f\xe0\x01\x38\x00"
            "\x00" }  },
      /* --- pixel bitmap for cmmib160 char#63 \star --- */
      {  63, 5829,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x00\x01\x08\x42\xe8\x3f\x7c\xc0\x01\x1b\x8c\x21"
            "\x08" }  },
      /* --- pixel bitmap for cmmib160 char#64 \partial --- */
      {  64, 4771,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x01\x61\x18\x8c\xc1\x00\x0c\xdf\x0c\x6e\xe0\x06"
            "\x36\x60\x03\x32\x30\x86\xc1\x07" }  },
      /* --- pixel bitmap for cmmib160 char#65 A --- */
      {  65,   35,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x08\x00\x1c\x00\x1c\x00\x1e\x00\x1d\x00\x1d\x80"
            "\x1c\x40\x1c\x20\x38\xe0\x3f\x10\x38\x08\x38\x08\x38"
            "\x1f\xfe" }  },
      /* --- pixel bitmap for cmmib160 char#66 B --- */
      {  66,   88,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x7f\xc0\x81\x83\x03\x07\x07\x0e\x0e\x1c\x0e\x1c"
            "\xfc\x0f\x38\x78\x70\xe0\x70\xc0\xe1\x80\xc3\x81\xc3"
            "\x81\xe3\xff\x03" }  },
      /* --- pixel bitmap for cmmib160 char#67 C --- */
      {  67,  145,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x9f\xe1\xc1\xe1\x00\xe3\x00\xe4\x00\xc8\x00\xc0"
            "\x01\x80\x03\x00\x07\x00\x0e\x40\x1c\x80\x30\x80\xc0"
            "\xc1\x00\x7f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#68 D --- */
      {  68,  198,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xff\x00\x07\x1c\x38\xc0\xc1\x01\x0e\x0e\x70\x38"
            "\x80\xc3\x01\x1c\x0e\xe0\x70\x00\xc3\x01\x1c\x0e\x70"
            "\x70\xc0\xc1\x01\x87\xff\x07\x00" }  },
      /* --- pixel bitmap for cmmib160 char#69 E --- */
      {  69,  257,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xff\xc1\x01\x83\x03\x06\x07\x08\x8e\x10\x8e\x00"
            "\xfc\x01\x38\x02\x70\x84\x70\x80\xe0\x80\xc1\x01\xc1"
            "\x81\xe3\xff\x03" }  },
      /* --- pixel bitmap for cmmib160 char#70 F --- */
      {  70,  318,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xff\xe0\xc0\xe0\x80\xe0\x80\xe0\x88\x70\x04\xf0"
            "\x07\x70\x04\x70\x04\x38\x00\x38\x00\x38\x00\x1c\x00"
            "\xff\x00" }  },
      /* --- pixel bitmap for cmmib160 char#71 G --- */
      {  71,  369,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x9f\xe1\xc1\xe1\x00\xe3\x00\xe4\x00\xc8\x00\xc0"
            "\x01\x80\x03\xff\x07\x70\x0e\x70\x1c\xe0\x30\xc0\xc1"
            "\xc1\x01\x7f\x02" }  },
      /* --- pixel bitmap for cmmib160 char#72 H --- */
      {  72,  428,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\xe7\x1f\x1c\x70\x80\x03\x0e\x70\xc0\x01\x0e\x38"
            "\xe0\x80\x03\xfc\x7f\x80\x03\x0e\x70\xc0\x01\x07\x1c"
            "\xe0\x80\x03\x1c\x70\xc0\x01\x07\xfe\xf9\x07" }  },
      /* --- pixel bitmap for cmmib160 char#73 I --- */
      {  73,  489,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x07\x07\x38\xc0\x01\x0e\x38\xc0\x01\x0e\x70\xc0"
            "\x01\x0e\x70\xc0\x81\x7f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#74 J --- */
      {  74,  524,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x1f\xe0\x00\x1c\x80\x03\x70\x00\x07\xe0\x00\x1c"
            "\x80\x03\x38\x18\x87\xe7\x70\x0e\x7c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#75 K --- */
      {  75,  565,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 20,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x87\x0f\x0e\x30\xe0\x80\x00\x0e\x02\xe0\x10\x00"
            "\xc7\x00\x70\x0e\x00\xcf\x01\x70\x1c\x80\x83\x03\x38"
            "\x38\x80\x03\x07\x1c\xe0\xf0\x8f\x3f" }  },
      /* --- pixel bitmap for cmmib160 char#76 L --- */
      {  76,  628,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x0f\x1c\x80\x03\x70\x00\x0e\xe0\x00\x1c\x80\x03"
            "\x70\x00\x07\xe2\x40\x1c\xc4\xe1\xfe\x0f" }  },
      /* --- pixel bitmap for cmmib160 char#77 M --- */
      {  77,  671,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 25,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x01\xf8\x41\x07\x78\x80\x0e\xf0\x00\x1d\xd0\x01"
            "\x3a\x90\x03\x72\x90\x03\xc4\x21\x07\x88\x23\x0e\x10"
            "\x27\x1c\x10\x2e\x1c\x20\x5c\x38\x40\x70\x70\x40\x60"
            "\x70\xe0\x47\xf8\x07" }  },
      /* --- pixel bitmap for cmmib160 char#78 N --- */
      {  78,  776,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x81\x1f\x7c\x40\x80\x0e\x08\x90\x03\x01\x72\x20"
            "\x20\x1c\x02\x04\x47\x80\xe0\x08\x10\x38\x01\x01\x1e"
            "\x20\xc0\x03\x04\x70\x40\x00\x06\x7e\x80\x00" }  },
      /* --- pixel bitmap for cmmib160 char#79 O --- */
      {  79,  853,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x1f\x70\x70\x18\xe0\x1c\xe0\x0e\xe0\x06\xe0\x07"
            "\xe0\x07\xe0\x07\x70\x07\x70\x07\x38\x07\x1c\x0e\x0e"
            "\xf8\x01" }  },
      /* --- pixel bitmap for cmmib160 char#80 P --- */
      {  80,  912,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x7f\xc0\xc1\x81\x03\x07\x07\x0e\x0e\x1c\x0e\x1c"
            "\x1c\x1c\xf8\x0f\x70\x00\x70\x00\xe0\x00\xc0\x01\xc0"
            "\x01\xe0\x0f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#81 Q --- */
      {  81,  959,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 16,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x1f\x70\x70\x38\xe0\x1c\xe0\x0e\xe0\x06\xe0\x07"
            "\xe0\x07\xe0\x07\x70\x07\x70\x07\x38\xe7\x1c\x3e\x0f"
            "\xf8\x21\x00\x23\x00\x1f\x00\x1f\x00\x0e" }  },
      /* --- pixel bitmap for cmmib160 char#82 R --- */
      {  82, 1032,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x7f\xc0\xc1\x81\x03\x07\x07\x0e\x0e\x0c\x0e\x0e"
            "\xfc\x07\x38\x1c\x70\x38\x70\x70\xe0\xe0\xc0\xc1\xc1"
            "\x81\xf3\x0f\x1e" }  },
      /* --- pixel bitmap for cmmib160 char#83 S --- */
      {  83, 1093,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x37\x0c\x06\x01\x61\x40\x18\x00\x7e\x80\x7f\x80"
            "\x3f\x00\x0e\x00\x23\xc0\x08\x10\x07\x43\x7e\x00" }  },
      /* --- pixel bitmap for cmmib160 char#84 T --- */
      {  84, 1144,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\xff\xc3\x41\xc1\x41\xc1\x41\xc1\x41\xe0\x00\xe0"
            "\x00\xe0\x00\xe0\x00\x70\x00\x70\x00\x70\x00\x38\x00"
            "\xff\x01" }  },
      /* --- pixel bitmap for cmmib160 char#85 U --- */
      {  85, 1195,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xf0\x73\x00\xc1\x01\x04\x07\x10\x1c\x40\x38\x80"
            "\xe0\x00\x82\x03\x08\x0e\x20\x1c\x40\x70\x00\xc1\x01"
            "\x02\x0e\x06\xe0\x07\x00" }  },
      /* --- pixel bitmap for cmmib160 char#86 V --- */
      {  86, 1256,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\xf0\x39\x80\xf0\x80\xc0\x81\x80\x83\x00\x07\x01"
            "\x0e\x01\x1c\x01\x78\x03\xe0\x02\xc0\x03\x80\x03\x00"
            "\x07\x00\x06\x00" }  },
      /* --- pixel bitmap for cmmib160 char#87 W --- */
      {  87, 1311,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 24,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\xfe\xf8\x1c\x38\x20\x1c\x38\x10\x1c\x38\x18\x1c"
            "\x3c\x08\x38\x7a\x04\x38\x72\x06\x38\x71\x02\xb8\x70"
            "\x01\xb8\xf0\x01\x78\xf0\x00\x38\x70\x00\x38\x70\x00"
            "\x18\x30\x00" }  },
      /* --- pixel bitmap for cmmib160 char#88 X --- */
      {  88, 1402,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xe7\x07\x0e\x04\xf0\x18\x00\x67\x00\xf8\x01\x80"
            "\x07\x00\x3c\x00\xe0\x01\x80\x0e\x00\xe2\x00\x08\x07"
            "\x20\x78\x80\x80\x83\x1f\x7f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#89 Y --- */
      {  89, 1457,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xf0\x79\xc0\xe0\x80\xc0\x83\x00\x87\x00\x9e\x00"
            "\xb8\x00\xf0\x00\xc0\x00\xc0\x01\x80\x03\x00\x07\x00"
            "\x07\x80\x3f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#90 Z --- */
      {  90, 1506,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\xff\xe1\xc0\xc1\xc0\x81\xc0\x01\xe1\x01\xe0\x01"
            "\xe0\x01\xe0\x01\xe0\x40\xe0\x40\xe0\x80\xe0\x80\xe1"
            "\xc0\xe1\xff\x03" }  },
      /* --- pixel bitmap for cmmib160 char#91 \flat --- */
      {  91, 5866,                      /* character number, location */
         15, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    15, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x81\x40\x20\x10\x08\xfc\xc2\xe1\x70\x2c\x96\x38\x04"
            "\x00" }  },
      /* --- pixel bitmap for cmmib160 char#92 \natural --- */
      {  92, 5915,                      /* character number, location */
         15, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    19, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x81\x40\x20\x10\xee\x7f\x87\xc1\x60\x30\x18\x0c\xf7"
            "\xbf\x43\x20\x10" }  },
      /* --- pixel bitmap for cmmib160 char#93 \sharp --- */
      {  93, 5986,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x91\x48\xec\xff\x8d\x44\x22\x91\x48\x24\xf6\xff"
            "\x46\x22\x01" }  },
      /* --- pixel bitmap for cmmib160 char#94 \smile --- */
      {  94, 6053,                      /* character number, location */
          7, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 22,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x00\xa0\x01\x00\x86\x03\x70\x00\xff\x03" }  },
      /* --- pixel bitmap for cmmib160 char#95 \frown --- */
      {  95, 6074,                      /* character number, location */
          8, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 22,     5, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x7f\x00\x1c\xe0\xc0\x00\xc0\x08\x00\x40\x01\x00"
            "\x20" }  },
      /* --- pixel bitmap for cmmib160 char#96 \ell --- */
      {  96, 4828,                      /* character number, location */
         14,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x03\x0a\x24\x98\x60\xc1\x04\x0b\x1c\x30\x60\xc0"
            "\x81\x04\x10\x82\x07" }  },
      /* --- pixel bitmap for cmmib160 char#97 a --- */
      {  97, 1559,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x62\x9c\xc1\x0c\x36\x98\xc1\x0c\x56\x7c\x3c\x03" }  },
      /* --- pixel bitmap for cmmib160 char#98 b --- */
      {  98, 1604,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x1e\x0c\x0c\x0c\x0c\x76\xce\x86\xc6\xc3\xc3\x63\x23"
            "\x1e" }  },
      /* --- pixel bitmap for cmmib160 char#99 c --- */
      {  99, 1655,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x18\x1b\x36\x30\x60\xc0\x00\x41\x7c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#100 d --- */
      { 100, 1686,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x0f\x60\x00\x06\x60\x00\x06\x3f\x8c\x63\x30\x06"
            "\x33\x18\x83\x31\x58\xe2\xc3\x33" }  },
      /* --- pixel bitmap for cmmib160 char#101 e --- */
      { 101, 1739,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x18\x1a\x34\xf6\x63\xc0\x00\x41\x7c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#102 f --- */
      { 102, 1772,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x07\x34\xb0\x81\x01\x0c\xfc\x81\x01\x0c\x60\x00"
            "\x03\x18\x60\x00\x03\x18\xc0\xc0\x02\x1b\x70\x00" }  },
      /* --- pixel bitmap for cmmib160 char#103 g --- */
      { 103, 1823,                      /* character number, location */
          9,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x85\x31\x86\x31\xcc\x30\x86\x31\x8c\x31\xf8\x01"
            "\x0c\x60\x84\xe1\x03" }  },
      /* --- pixel bitmap for cmmib160 char#104 h --- */
      { 104, 1874,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x80\x01\x18\x80\x01\x18\xc0\x3c\x3c\xc6\x60\x0c"
            "\x66\x30\x06\x63\x98\x83\x35\x30" }  },
      /* --- pixel bitmap for cmmib160 char#105 i --- */
      { 105, 1931,                      /* character number, location */
         15, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  5,    15, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x10\x03\x00\x80\x69\x8d\x19\x33\x97\x01" }  },
      /* --- pixel bitmap for cmmib160 char#106 j --- */
      { 106, 1970,                      /* character number, location */
         15,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          { 10,    19, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x03\x0c\x00\x00\x00\x00\x00\x0e\x64\x90\x01\x06"
            "\x0c\x30\xc0\x80\x01\x06\x18\x20\xc8\xf0\x00" }  },
      /* --- pixel bitmap for cmmib160 char#107 k --- */
      { 107, 2015,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x60\x80\x01\x06\x18\x30\xce\x34\xcb\x1c\xf8\x61"
            "\x8e\xb1\xc3\x0d\x07" }  },
      /* --- pixel bitmap for cmmib160 char#108 l --- */
      { 108, 2070,                      /* character number, location */
         14, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x9e\x31\xc6\x8c\x31\x66\x8c\x75\x0e" }  },
      /* --- pixel bitmap for cmmib160 char#109 m --- */
      { 109, 2107,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 19,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc6\xe3\xe9\xf1\x58\x83\xc1\x18\x0c\x66\x30\x18\x83"
            "\xc1\x18\x0c\x73\x30\x58\x83\x81\x01" }  },
      /* --- pixel bitmap for cmmib160 char#110 n --- */
      { 110, 2176,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc6\xd3\x63\x0d\xc6\x60\x06\x63\x30\x86\x39\x58\x03"
            "\x03" }  },
      /* --- pixel bitmap for cmmib160 char#111 o --- */
      { 111, 2227,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x31\x6c\xb0\xc1\x03\x0f\x3c\x98\x31\x7c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#112 p --- */
      { 112, 2266,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x98\x47\xc7\x34\x08\xc3\x18\x8c\xc1\x18\xc6\x31\xec"
            "\xc1\x00\x0c\x60\x00\x1f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#113 q --- */
      { 113, 2321,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x19\x1b\x36\x3c\x6c\xd8\xb0\x31\x7e\xc0\x80\x81"
            "\x81\x07" }  },
      /* --- pixel bitmap for cmmib160 char#114 r --- */
      { 114, 2370,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x66\xdd\xcd\x0c\x06\x06\x06\x03\x03" }  },
      /* --- pixel bitmap for cmmib160 char#115 s --- */
      { 115, 2405,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\xc2\xc2\x1e\x3c\x60\x43\x21\x1e" }  },
      /* --- pixel bitmap for cmmib160 char#116 t --- */
      { 116, 2438,                      /* character number, location */
         13, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x18\x0c\xf6\xc7\x60\x30\x0c\x06\x93\xc5\x01" }  },
      /* --- pixel bitmap for cmmib160 char#117 u --- */
      { 117, 2475,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\x6a\x58\xc3\x18\x66\x18\xc3\x18\xd6\x78\xbc\x03" }  },
      /* --- pixel bitmap for cmmib160 char#118 v --- */
      { 118, 2524,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x86\x1b\x37\x64\x68\xc8\x90\x11\x23\x3c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#119 w --- */
      { 119, 2569,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 15,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x06\xe2\x86\x71\xc3\x90\x61\x68\x18\x32\x0c\x19\xc6"
            "\x8c\x23\x3c\x0f" }  },
      /* --- pixel bitmap for cmmib160 char#120 x --- */
      { 120, 2632,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xb8\x47\xc6\x62\x0c\x06\x30\x00\x03\x33\x94\x23\xe7"
            "\x01" }  },
      /* --- pixel bitmap for cmmib160 char#121 y --- */
      { 121, 2677,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\xd4\xb0\x86\x31\xcc\x30\x86\x31\x8c\x31\xf8\x01"
            "\x8c\x31\xc6\xe0\x03" }  },
      /* --- pixel bitmap for cmmib160 char#122 z --- */
      { 122, 2734,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xf9\x13\x02\x03\x01\x21\x41\x7f\x71\x00" }  },
      /* --- pixel bitmap for cmmib160 char#123 \imath --- */
      { 123, 4879,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xa6\x35\x66\xcc\x5c\x06" }  },
      /* --- pixel bitmap for cmmib160 char#124 \jmath --- */
      { 124, 4912,                      /* character number, location */
          9,-1,    -4,-1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x20\x43\x06\x0c\x0c\x18\x30\x30\x60\xc0\x80\x91"
            "\xe1\x01" }  },
      /* --- pixel bitmap for cmmib160 char#125 \wp --- */
      { 125, 4951,                      /* character number, location */
          9, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x80\xf0\x99\x61\x0b\xbc\x80\x0f\xf0\x11\x72\x32"
            "\xcd\x23\x03\x64\x80\x06\x60\x00\x00" }  },
      /* --- pixel bitmap for cmmib160 char#126 \vec --- */
      { 126, 5018,                      /* character number, location */
         14, 4,    10, 4,     /* topleft row,col, and botleft row,col */
          { 10,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\xfd\xff\x3f\x30" }  },
      /* --- pixel bitmap for cmmib160 char#127 (noname) --- */
      { 127, 5033,                      /* character number, location */
         13, 6,    11, 6,     /* topleft row,col, and botleft row,col */
          {  8,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7e\x83" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=5 ---
 * mf '\mode=lqlores; input cmmib10'    gives .gf180
 * ------------------------------------------------- */
/* --- fontdef for cmmib180 --- */
static	chardef  cmmib180[] =
   {
      /* --- pixel bitmap for cmmib180 char#0 \Gamma --- */
      {   0, 3377,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x81\x03\x03\x07\x04\x07\x08\x0e\x10\x1c\x20"
            "\x38\x00\x38\x00\x70\x00\xe0\x00\xc0\x01\xc0\x01\x80"
            "\x03\x00\x07\x00\x0e\x00\x0e\x00\xff\x00\x00" }  },
      /* --- pixel bitmap for cmmib180 char#1 \Delta --- */
      {   1, 3428,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x40\x00\x00\x1c\x00\xc0\x03\x00\x74\x00\xc0\x1e"
            "\x00\x88\x03\x80\x70\x00\x08\x1e\x80\x80\x03\x08\x70"
            "\x00\x01\x1e\x10\x80\x03\x01\x70\x10\x00\x1e\xff\xff"
            "\xf3\xff\x7f\xfe\xff\x1f" }  },
      /* --- pixel bitmap for cmmib180 char#2 \Theta --- */
      {   2, 3491,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x3f\xc0\xc1\xc1\x00\xc3\x00\xce\x01\xd8\x01\xb0"
            "\x23\xe2\xe3\xe3\xc7\xc7\x8f\x8f\x1f\x11\x3b\x00\x77"
            "\x00\xe6\x00\x8e\x01\x0e\x0e\x07\xf8\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#3 \Lambda --- */
      {   3, 3576,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x10\x00\x30\x00\xe0\x00\xe0\x01\xa0\x03\x40\x07"
            "\x40\x0e\x80\x1c\x80\x38\x80\x70\x00\xe1\x01\xc1\x03"
            "\x03\x07\x02\x0e\x02\x1c\x04\x38\x3f\xfe\x01" }  },
      /* --- pixel bitmap for cmmib180 char#4 \Xi --- */
      {   4, 3643,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 20,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x0f\xff\xff\x10\x00\x88\x00\x40\x00\x00\x00"
            "\x00\x00\x40\x80\x00\xfe\x07\xe0\x7f\x00\x02\x04\x00"
            "\x00\x00\x00\x00\x00\x00\x20\x00\x10\x02\x00\xf1\xff"
            "\x0f\xff\xff\x00" }  },
      /* --- pixel bitmap for cmmib180 char#5 \Pi --- */
      {   5, 3690,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 25,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\xff\x01\x07\x70\x00\x0e\xe0\x00\x0e\xe0\x00"
            "\x1c\xc0\x01\x38\x80\x03\x70\x00\x07\x70\x00\x07\xe0"
            "\x00\x0e\xc0\x01\x1c\x80\x03\x38\x80\x03\x38\x00\x07"
            "\x70\x00\x0e\xe0\x00\x1c\xc0\x01\x1c\xc0\x01\xff\xf1"
            "\x1f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#6 \Sigma --- */
      {   6, 3763,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x07\x07\x30\x78\x80\x81\x03\x08\x3c\x40\xc0"
            "\x01\x02\x1e\x00\xe0\x00\x00\x0f\x00\x30\x00\x40\x80"
            "\x00\x01\x02\x06\x10\x08\x40\x20\x80\xc3\xff\x1f\xff"
            "\x7f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#7 \Upsilon --- */
      {   7, 3824,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\xe0\xf9\xe1\x27\xce\x71\x30\x43\xc0\x06\x00\x0e"
            "\x00\x3c\x00\x70\x00\xc0\x01\x00\x07\x00\x1c\x00\x38"
            "\x00\xe0\x00\x80\x03\x00\x0e\x00\x1c\x00\xfe\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#8 \Phi --- */
      {   8, 3883,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x7f\x00\x0e\x00\x0e\x00\x07\xe0\x1f\x38\x77\x0e"
            "\xe7\x86\xe3\x87\xe3\x87\xe3\x87\x73\xce\x39\xf8\x07"
            "\xc0\x01\xc0\x01\xe0\x00\xfc\x07" }  },
      /* --- pixel bitmap for cmmib180 char#9 \Psi --- */
      {   9, 3952,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x3f\x00\x0e\x00\x1c\x78\x1c\xee\x38\xce\x71\x9c"
            "\xe3\xb8\xe3\x38\xc7\x71\x8e\x73\x18\x67\x60\x77\x80"
            "\x3f\x00\x1c\x00\x38\x00\x38\x00\xfe\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#10 \Omega --- */
      {  10, 4029,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\xff\x00\x0e\x0c\x38\xc0\xe0\x00\x8e\x03\x70\x1c"
            "\x80\xe3\x00\x1c\x07\x70\x18\x80\xc1\x00\x0e\x06\x30"
            "\x20\xc0\x10\x03\xa2\x18\x18\x7d\xc0\xe7\x03\x3f\x1f"
            "\xf8\x00" }  },
      /* --- pixel bitmap for cmmib180 char#11 \alpha --- */
      {  11, 4110,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x03\x1c\x27\x07\xd3\x81\xeb\xc0\x3b\xe0\x1d\x70"
            "\x0e\x38\x06\x1c\x83\x2d\x3e\x1c" }  },
      /* --- pixel bitmap for cmmib180 char#12 \beta --- */
      {  12, 4169,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 13,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x0f\x18\x03\x61\x10\x0c\x81\x21\x38\xf4\x43\x71"
            "\xc8\x1b\x01\x23\x60\x02\x4e\xc0\x09\x38\x81\x53\x38"
            "\xf2\x41\x00\x08\x80\x00\x10\x00\x02\x00" }  },
      /* --- pixel bitmap for cmmib180 char#13 \gamma --- */
      {  13, 4258,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 15,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x40\x7e\x90\x7f\x64\x38\x02\x90\x00\x50\x00\x18"
            "\x00\x0c\x00\x02\x00\x01\xc0\x00\x60\x00\x30\x00\x0c"
            "\x00\x06\x00\x03" }  },
      /* --- pixel bitmap for cmmib180 char#14 \delta --- */
      {  14, 4311,                      /* character number, location */
         18, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x00\x3f\xc4\x61\x00\x07\x30\x80\x03\x3c\xf8\xe3"
            "\x9c\xe3\x1d\x7f\xb8\xc3\x1d\xce\x30\xc6\xe0\x03" }  },
      /* --- pixel bitmap for cmmib180 char#15 \epsilon --- */
      {  15, 4372,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x71\x30\x70\xe0\xe0\xdf\x81\x03\x06\x18\xe2\x03" }  },
      /* --- pixel bitmap for cmmib180 char#16 \zeta --- */
      {  16, 4403,                      /* character number, location */
         17, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 11,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x00\x04\xe0\x81\x09\x72\x08\x20\x80\x01\x06\x30"
            "\x80\x01\x0e\x70\x80\x03\x3c\xc0\x07\xfc\xc1\x1f\xf8"
            "\x00\x06\x11\x70\x00" }  },
      /* --- pixel bitmap for cmmib180 char#17 \eta --- */
      {  17, 4460,                      /* character number, location */
         11, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xce\xd7\xe3\x1d\xde\xe1\x1c\xee\x70\x0e\xe7\x70\x0e"
            "\x77\x38\x86\x03\x38\x80\x03\x1c\xc0\x01\x0c" }  },
      /* --- pixel bitmap for cmmib180 char#18 \theta --- */
      {  18, 4527,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x81\x19\xc6\x38\xce\x70\x87\x3b\xfc\x70\xff\x3b"
            "\xdc\xe1\x86\x33\x9c\x61\x8c\x41\x06\x1c\x00" }  },
      /* --- pixel bitmap for cmmib180 char#19 \iota --- */
      {  19, 4596,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x0e\x87\xc3\x71\x38\x9c\xa7\x93\x07" }  },
      /* --- pixel bitmap for cmmib180 char#20 \kappa --- */
      {  20, 4631,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x8e\xe3\x71\x32\x2e\xc0\x03\xfc\x87\xc3\x71\xb8"
            "\x0e\xf7\x60\x19\x18" }  },
      /* --- pixel bitmap for cmmib180 char#21 \lambda --- */
      {  21, 4686,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x00\x3c\x00\x0e\x80\x07\xc0\x01\xf0\x00\x38\x00"
            "\x0e\x80\x07\xe0\x01\xfc\x80\x39\x38\x1e\x07\xe7\xc0"
            "\x1d\xf0\x03\x38" }  },
      /* --- pixel bitmap for cmmib180 char#22 \mu --- */
      {  22, 4739,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 14,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x18\x0e\x87\xc3\xe1\x70\x38\x1c\x87\xc3\xe1\x70"
            "\xb8\x1c\xae\xc7\xe7\xcf\x39\x00\x0e\xc0\x01\x70\x00"
            "\x0c\x00" }  },
      /* --- pixel bitmap for cmmib180 char#23 \nu --- */
      {  23, 4804,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3e\x98\x83\x73\x70\x0e\xce\xe1\x1c\x8c\xc3\x70\x0c"
            "\xee\xe0\x07\x3c\x00" }  },
      /* --- pixel bitmap for cmmib180 char#24 \xi --- */
      {  24, 4851,                      /* character number, location */
         17, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 10,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x00\x01\x3c\x9c\xb8\x73\xc0\x01\x03\xfc\x60\x44"
            "\x8f\x01\x03\x0c\x30\xc0\x03\x7f\xf8\x87\x3f\xf0\x90"
            "\x81\x03" }  },
      /* --- pixel bitmap for cmmib180 char#25 \pi --- */
      {  25, 4912,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x3f\xff\xbf\xff\x2f\x66\x00\x33\xc0\x19\x60\x0c"
            "\x38\x06\x1c\x07\x87\x03\x83\x00" }  },
      /* --- pixel bitmap for cmmib180 char#26 \rho --- */
      {  26, 4959,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 13,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x07\x8c\xc1\x30\x1c\x8e\xc3\x39\x1c\x87\xe3\x70"
            "\x1c\xc7\x63\xb8\x03\x07\xe0\x00\x0e\xc0\x01\x18\x00" }  },
      /* --- pixel bitmap for cmmib180 char#27 \sigma --- */
      {  27, 5018,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x3f\xfc\x3f\xff\xcf\x61\xe0\x30\x38\x1c\x1c\x0e"
            "\x0e\x07\xc7\x01\x63\x00\x1f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#28 \tau --- */
      {  28, 5061,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xcf\xff\xfb\xbf\x10\x00\x03\x60\x00\x0e\xc0\x01"
            "\x38\x80\x03\x60\x00" }  },
      /* --- pixel bitmap for cmmib180 char#29 \upsilon --- */
      {  29, 5092,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\xac\xe1\x39\xde\xc1\x1c\xe8\x40\x0e\xe4\x20\x0e"
            "\xc2\x10\xf8\x00" }  },
      /* --- pixel bitmap for cmmib180 char#30 \phi --- */
      {  30, 5147,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 16,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x04\x00\x04\x00\x04\x00\x02\x00\x02\x00\x02\xc0"
            "\x0f\x38\x31\x1c\x71\x0e\x61\x0e\xe1\x87\x70\x87\x70"
            "\x87\x30\x86\x18\x4c\x0e\xf8\x03\x40\x00\x40\x00\x20"
            "\x00\x20\x00\x20\x00" }  },
      /* --- pixel bitmap for cmmib180 char#31 \chi --- */
      {  31, 5234,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 16,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x80\xf2\x40\xe0\x20\xe0\x11\xc0\x09\xc0\x05\xc0"
            "\x03\x80\x03\x80\x03\xc0\x03\xa0\x07\x10\x07\x08\x07"
            "\x04\x0f\x02\x5e\x01\x3c" }  },
      /* --- pixel bitmap for cmmib180 char#32 \psi --- */
      {  32, 5301,                      /* character number, location */
         17, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 16,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x08\x00\x08\x00\x04\x00\x04\x00\x04\x00\x04\x0e"
            "\x42\x1a\xe2\x39\xe2\x1d\xc2\x1c\x81\x0e\x41\x0e\x41"
            "\x0e\x21\x8e\x10\x9c\x0c\xf0\x03\x80\x00\x40\x00\x40"
            "\x00\x40\x00\x40\x00" }  },
      /* --- pixel bitmap for cmmib180 char#33 \omega --- */
      {  33, 5398,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 16,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x40\x04\xe0\x06\xe0\x02\xc0\x82\x81\x81\x41\x83"
            "\x41\xe7\x73\xff\x3f\x3e\x1f\x1c\x0e" }  },
      /* --- pixel bitmap for cmmib180 char#34 \varepsilon --- */
      {  34, 5455,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xf1\x6f\xb0\x00\x3e\x98\x90\x41\x00\x01\xfd\xc3"
            "\x03" }  },
      /* --- pixel bitmap for cmmib180 char#35 \vartheta --- */
      {  35, 5492,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x07\x88\x01\x31\x10\x0e\xc2\x81\xb8\x23\xef\x78"
            "\x1d\xbe\xc3\x71\x38\x87\xe3\x70\x1c\x86\x63\x70\x06"
            "\x7c\x00" }  },
      /* --- pixel bitmap for cmmib180 char#36 \varpi --- */
      {  36, 5571,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 22,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xff\x9f\xff\xff\xef\xff\xff\x25\x00\x20\x08\x08"
            "\x08\x01\x03\x41\xe0\x40\x10\x3c\x0c\xfc\xfd\x03\x3f"
            "\x7e\x80\x07\x07\x00" }  },
      /* --- pixel bitmap for cmmib180 char#37 \varrho --- */
      {  37, 5626,                      /* character number, location */
         11, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x03\x63\x18\xc6\xe1\x1c\xee\x70\x0e\xe7\x70\x8e"
            "\xf3\x18\x79\x10\x00\xff\xf0\x1f\xfe\x01\x10" }  },
      /* --- pixel bitmap for cmmib180 char#38 \varsigma --- */
      {  38, 5685,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    13, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x63\x48\x80\x01\x06\x1c\xe0\x80\x0f\xfc\xe0\x03"
            "\x0e\x30\x70\x00" }  },
      /* --- pixel bitmap for cmmib180 char#39 \varphi --- */
      {  39, 5720,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 16,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x08\x3c\x04\x7e\x02\x7f\x02\xc3\x82\x80\x81\x40\x41"
            "\x40\x46\x30\xfe\x1f\xfc\x0f\xf0\x03\x30\x00\x30\x00"
            "\x30\x00\x38\x00\x38\x00" }  },
      /* --- pixel bitmap for cmmib180 char#40 \leftharpoonup --- */
      {  40, 6632,                      /* character number, location */
         13, 2,     5, 2,     /* topleft row,col, and botleft row,col */
          { 24,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x00\x00\x60\x00\x00\x60\x00\x00\x30\x00\x00\x38"
            "\x00\x00\x1c\x00\x00\xfe\xff\xff\xff\xff\xff" }  },
      /* --- pixel bitmap for cmmib180 char#41 \leftharpoondown --- */
      {  41, 6655,                      /* character number, location */
          7, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 24,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\xff\xfe\xff\xff\x1c\x00\x00\x38\x00\x00\x30"
            "\x00\x00\x60\x00\x00\x60\x00\x00\x40\x00\x00" }  },
      /* --- pixel bitmap for cmmib180 char#42 \rightharpoonup --- */
      {  42, 6678,                      /* character number, location */
         13, 2,     5, 2,     /* topleft row,col, and botleft row,col */
          { 24,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x00\x02\x00\x00\x06\x00\x00\x06\x00\x00\x0c\x00"
            "\x00\x1c\x00\x00\x38\xff\xff\xff\xff\xff\xff" }  },
      /* --- pixel bitmap for cmmib180 char#43 \rightharpoondown --- */
      {  43, 6701,                      /* character number, location */
          7, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 24,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xff\xff\xff\xff\xff\x00\x00\x38\x00\x00\x1c\x00"
            "\x00\x0c\x00\x00\x06\x00\x00\x06\x00\x00\x02" }  },
      /* --- pixel bitmap for cmmib180 char#44 ` --- */
      {  44, 6724,                      /* character number, location */
         13, 1,     5, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xd8\x9f\x31\x8e\xc7" }  },
      /* --- pixel bitmap for cmmib180 char#45 ' --- */
      {  45, 6747,                      /* character number, location */
         13, 1,     5, 1,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe3\x71\x8c\xf9\x1b" }  },
      /* --- pixel bitmap for cmmib180 char#46 \triangleright --- */
      {  46, 6770,                      /* character number, location */
         13, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x03\xe0\x01\xfc\x80\x39\x30\x1e\x06\xcf\x80\x1f\xf0"
            "\x83\x67\x3c\xcc\x81\x1f\xf0\x00\x06\x00" }  },
      /* --- pixel bitmap for cmmib180 char#47 \triangleleft --- */
      {  47, 6821,                      /* character number, location */
         13, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 13,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x18\xc0\x03\x7e\xf0\x0c\x87\x79\xf0\x03\x7e\xc0"
            "\x3c\x18\x0e\x83\x67\xc0\x0f\xe0\x01\x30" }  },
      /* --- pixel bitmap for cmmib180 char#48 \0 --- */
      {  48, 6122,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x70\x9c\xc1\x0e\x7e\xf0\x83\x1f\xfc\xe0\x06\x73"
            "\x1c\x3e\x00" }  },
      /* --- pixel bitmap for cmmib180 char#49 \1 --- */
      {  49, 6169,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x20\x7e\xe0\xc0\x81\x03\x07\x0e\x1c\x38\x70\xfc\x07" }  },
      /* --- pixel bitmap for cmmib180 char#50 \2 --- */
      {  50, 6198,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfe\x39\xdc\xc1\x05\x0e\x70\xc0\x01\x13\x86\xf8\xf3"
            "\xdf\xff\x00" }  },
      /* --- pixel bitmap for cmmib180 char#51 \3 --- */
      {  51, 6237,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x20\x8c\xe3\x1c\x47\x38\xc0\x00\x03\x1f\x80\x03"
            "\x18\xc0\x05\x7e\xf0\x83\x09\x8e\x1f" }  },
      /* --- pixel bitmap for cmmib180 char#52 \4 --- */
      {  52, 6292,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x01\x0c\x70\xc0\x03\x1f\xec\x20\x87\x38\xc2\x19"
            "\xce\xff\x81\x03\x1c\xe0\x00\x07\xff" }  },
      /* --- pixel bitmap for cmmib180 char#53 \5 --- */
      {  53, 6341,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x04\xe3\x0f\x3f\x28\x40\x00\x02\xd0\x83\x31\x04\x03"
            "\x38\xc0\x0f\x7e\xf0\x81\x19\x06\x1f" }  },
      /* --- pixel bitmap for cmmib180 char#54 \6 --- */
      {  54, 6398,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xc1\x18\xe3\x0c\x67\x80\x03\xdc\xe3\x31\x07\x3b"
            "\xf8\xc1\x0f\x6e\x70\x83\x31\x06\x1f" }  },
      /* --- pixel bitmap for cmmib180 char#55 \7 --- */
      {  55, 6461,                      /* character number, location */
         12, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x02\xe0\xff\xfe\xe7\x3f\x01\x12\x10\x80\x00\x04\x60"
            "\x00\x06\x30\x00\x03\x38\x80\x03\x38\x80\x03\x10\x00" }  },
      /* --- pixel bitmap for cmmib180 char#56 \8 --- */
      {  56, 6506,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x60\x8c\xc1\x0c\xe6\x30\xcf\xf0\x03\x1f\xec\x33"
            "\xde\xc0\x07\x3c\xe0\x01\x19\x0c\x1f" }  },
      /* --- pixel bitmap for cmmib180 char#57 \9 --- */
      {  57, 6569,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x60\x8c\xc1\x0e\x76\xf0\x83\x1f\xdc\xe0\x8c\xc7"
            "\x3b\xc0\x01\xe6\x30\xc7\x18\x03\x0f" }  },
      /* --- pixel bitmap for cmmib180 char#58 . --- */
      {  58, 6872,                      /* character number, location */
          4, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  4,     4, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf6\x6f" }  },
      /* --- pixel bitmap for cmmib180 char#59 , --- */
      {  59, 6887,                      /* character number, location */
          4, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf6\xef\x88\x44\x02" }  },
      /* --- pixel bitmap for cmmib180 char#60 < --- */
      {  60, 6912,                      /* character number, location */
         15, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          { 17,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x80\x01\xc0\x03\xe0\x01\xf0\x00\x78\x00\x38\x00"
            "\x3c\x00\x1e\x00\x0f\x00\x1e\x00\xf0\x00\x80\x07\x00"
            "\x1c\x00\xf0\x00\x80\x07\x00\x3c\x00\xe0\x01\x00\x03" }  },
      /* --- pixel bitmap for cmmib180 char#61 / --- */
      {  61, 6955,                      /* character number, location */
         19, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          { 11,    25, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x06\x30\xc0\x01\x06\x38\xc0\x00\x06\x38\xc0\x00"
            "\x07\x18\xc0\x00\x07\x18\xc0\x00\x07\x18\xe0\x00\x03"
            "\x18\xe0\x00\x03\x1c\x60\x00\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#62 > --- */
      {  62, 7012,                      /* character number, location */
         15, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          { 17,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x03\x00\x1e\x00\xf0\x00\x80\x07\x00\x3c\x00\xe0\x00"
            "\x80\x07\x00\x3c\x00\xe0\x01\xc0\x03\xe0\x01\xf0\x00"
            "\x70\x00\x78\x00\x3c\x00\x1e\x00\x0f\x00\x06\x00\x00" }  },
      /* --- pixel bitmap for cmmib180 char#63 \star --- */
      {  63, 7055,                      /* character number, location */
         13,-1,    -1,-1,     /* topleft row,col, and botleft row,col */
          { 15,    14, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x00\x40\x00\x20\x00\x10\x00\x1c\x78\xce\xf3\x7f"
            "\xe0\x0f\xe0\x03\xf0\x01\xdc\x01\xc6\x80\xc1\x40\x40"
            "\x00" }  },
      /* --- pixel bitmap for cmmib180 char#64 \partial --- */
      {  64, 5785,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 14,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x07\x08\x03\x81\xe1\xc0\x38\x30\x00\x0c\x3e\xe3"
            "\xf0\x1c\xbc\x03\xee\x80\x1f\x70\x07\xdc\x01\x63\x60"
            "\x38\x0c\xf8\x00" }  },
      /* --- pixel bitmap for cmmib180 char#65 A --- */
      {  65,   35,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x20\x00\x80\x03\x00\x1c\x00\xf0\x00\x40\x07\x00"
            "\x3a\x00\xc8\x01\x20\x0e\x00\xe1\x00\x04\x07\x10\x38"
            "\x80\xff\x01\x02\x0e\x08\x70\x40\x00\x07\x01\x38\x3f"
            "\xf8\x07" }  },
      /* --- pixel bitmap for cmmib180 char#66 B --- */
      {  66,  100,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x01\x0e\x38\x70\xc0\xc1\x01\x0c\x0e\x70\x70"
            "\x80\x83\x03\x0e\x0e\x3c\xf0\xff\x80\x03\x0e\x1c\x70"
            "\x70\x80\x83\x03\x1c\x1c\xe0\xe0\x80\x83\x03\x0e\xff"
            "\x1f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#67 C --- */
      {  67,  169,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x3f\x82\x07\x0d\x07\x38\x06\x40\x1c\x00\x39\x00"
            "\xe4\x00\xc0\x01\x00\x07\x00\x1c\x00\x70\x00\xc0\x01"
            "\x10\x07\x40\x1c\x80\x60\x00\x01\x07\x03\xf0\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#68 D --- */
      {  68,  234,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 21,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x03\x70\xc0\x01\x0e\x70\xe0\x00\x0c\x1c\x80"
            "\x81\x03\x30\x70\x00\x06\x07\xe0\xe0\x00\x1c\x1c\x80"
            "\x83\x03\x30\x38\x00\x07\x07\x60\xe0\x00\x0e\x1c\xe0"
            "\xc0\x01\x07\xff\x3f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#69 E --- */
      {  69,  305,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x07\x1c\x30\xe0\x00\x81\x03\x08\x1c\x40\xe0"
            "\x20\x02\x07\x01\x1c\x04\xe0\x3f\x00\x87\x01\x38\x08"
            "\xe1\x20\x04\x07\x20\x38\x80\xc0\x01\x06\x07\x38\xff"
            "\xff\x00" }  },
      /* --- pixel bitmap for cmmib180 char#70 F --- */
      {  70,  380,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 18,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x03\x07\x0c\x1c\x20\x38\x80\xe0\x00\x82\x43"
            "\x08\x0e\x01\x1c\x02\xf0\x0f\xc0\x21\x00\x87\x00\x0e"
            "\x01\x38\x00\xe0\x00\x80\x03\x00\x07\x00\xff\x00\x00" }  },
      /* --- pixel bitmap for cmmib180 char#71 G --- */
      {  71,  443,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x7f\x04\x0e\x34\x1c\xc0\x71\x00\xc4\x01\x20\x07"
            "\x00\x39\x00\xe0\x00\x00\x07\x00\x38\xe0\xff\x01\x70"
            "\x0e\xc0\x71\x00\x0e\x03\x70\x38\x80\x83\x03\x0f\xf0"
            "\x47\x00" }  },
      /* --- pixel bitmap for cmmib180 char#72 H --- */
      {  72,  514,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 25,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x1f\xff\x01\x07\x70\x00\x0e\xe0\x00\x0e\xe0\x00"
            "\x1c\xc0\x01\x38\x80\x03\x70\x00\x07\x70\x00\x07\xe0"
            "\xff\x0f\xc0\x01\x1c\x80\x03\x38\x80\x03\x38\x00\x07"
            "\x70\x00\x0e\xe0\x00\x1c\xc0\x01\x1c\xc0\x01\xff\xf1"
            "\x1f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#73 I --- */
      {  73,  587,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x1f\x70\x00\x0e\xe0\x00\x1c\x80\x03\x70\x00\x07"
            "\xe0\x00\x1c\x80\x03\x38\x00\x07\xe0\x00\x1c\xc0\x01"
            "\xff\x01" }  },
      /* --- pixel bitmap for cmmib180 char#74 J --- */
      {  74,  628,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x7f\x00\x0e\x00\x07\xc0\x01\xe0\x00\x70\x00\x38"
            "\x00\x0e\x00\x07\x80\x03\xc0\x01\x70\x00\x38\x38\x1c"
            "\x1c\x07\x86\x01\x7e\x00" }  },
      /* --- pixel bitmap for cmmib180 char#75 K --- */
      {  75,  675,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 24,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x1f\xfc\x80\x03\x10\x80\x03\x04\xc0\x01\x02\xc0"
            "\x81\x00\xc0\x41\x00\xc0\x31\x00\xe0\x38\x00\xe0\x3e"
            "\x00\xe0\x71\x00\xe0\x70\x00\x70\xe0\x00\x70\xe0\x00"
            "\x70\xc0\x01\x70\xc0\x01\x38\x80\x03\xff\xe1\x0f" }  },
      /* --- pixel bitmap for cmmib180 char#76 L --- */
      {  76,  750,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x0f\xe0\x00\x70\x00\x1c\x00\x0e\x00\x07\x80\x03"
            "\xe0\x00\x70\x00\x38\x00\x1c\x00\x07\x88\x03\xc4\x01"
            "\xe1\xc0\x38\x70\xff\x1f" }  },
      /* --- pixel bitmap for cmmib180 char#77 M --- */
      {  77,  801,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 30,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x03\x80\x3f\xe0\x00\xe0\x01\x38\x00\x74\x00\x19"
            "\x80\x0e\x40\x06\xa0\x03\x90\x01\xe4\x00\x64\x80\x38"
            "\x80\x18\x10\x07\x20\x0c\xc4\x01\x08\x83\x70\x00\xc2"
            "\x10\x1c\x40\x30\x82\x03\x10\x98\xe0\x00\x04\x16\x38"
            "\x00\x81\x03\x0e\x20\xe0\xc0\x01\x7f\x18\xfe\x03" }  },
      /* --- pixel bitmap for cmmib180 char#78 N --- */
      {  78,  928,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 25,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x03\xfc\x01\x0f\x40\x00\x1e\x80\x00\x72\x80\x00"
            "\xc4\x01\x01\x88\x03\x02\x10\x0e\x04\x10\x3c\x04\x20"
            "\x70\x08\x40\xc0\x11\x80\x80\x23\x80\x00\x2e\x00\x01"
            "\x78\x00\x02\xf0\x00\x04\xc0\x01\x04\x80\x01\x7f\x00"
            "\x02\x00" }  },
      /* --- pixel bitmap for cmmib180 char#79 O --- */
      {  79, 1021,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x3f\xc0\xc1\xc1\x00\xc3\x00\xce\x01\xd8\x01\xb0"
            "\x03\xe0\x03\xe0\x07\xc0\x0f\x80\x1f\x80\x3b\x00\x77"
            "\x00\xe6\x00\x8e\x01\x0e\x0e\x07\xf8\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#80 P --- */
      {  80, 1092,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 20,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x03\x38\x60\x80\x03\x0e\x1c\xe0\xc0\x01\x0e"
            "\x1c\xe0\xc0\x01\x07\x0e\x38\xe0\xff\x00\x0e\x00\xe0"
            "\x00\x00\x07\x00\x70\x00\x00\x07\x00\x70\x00\x80\x03"
            "\x00\xff\x01\x00" }  },
      /* --- pixel bitmap for cmmib180 char#81 Q --- */
      {  81, 1147,                      /* character number, location */
         17, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 17,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x3f\xc0\xc1\xc1\x00\xc3\x00\xce\x01\xd8\x01\xb0"
            "\x03\xe0\x03\xe0\x07\xc0\x0f\x80\x1f\x00\x3b\x00\x77"
            "\x00\xe6\x38\x8e\x49\x0e\x0e\x07\xf8\x43\x00\x84\x00"
            "\x8c\x01\xf8\x01\xe0\x01\xc0\x01" }  },
      /* --- pixel bitmap for cmmib180 char#82 R --- */
      {  82, 1240,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 20,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\x00\x1c\x38\xc0\x01\x07\x0e\x70\xe0\x00\x07"
            "\x0e\x70\xe0\x80\x03\x07\x1c\xf0\x3f\x00\x07\x0e\x70"
            "\xe0\x80\x03\x0e\x38\xe0\x80\x03\x0e\x38\xe0\xc8\x01"
            "\x4e\xff\xc0\x03" }  },
      /* --- pixel bitmap for cmmib180 char#83 S --- */
      {  83, 1315,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x4f\x30\x38\x0c\x18\x02\x84\x01\xc2\x00\xe0\x03"
            "\xf0\x0f\xf0\x0f\xc0\x0f\x00\x07\x00\x23\x80\x11\xc0"
            "\x08\x30\x0e\x0c\xf9\x01" }  },
      /* --- pixel bitmap for cmmib180 char#84 T --- */
      {  84, 1376,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\xff\x19\x0e\x0b\x1c\x14\x1c\x18\x38\x30\x70\x20"
            "\xe0\x00\xe0\x00\xc0\x01\x80\x03\x00\x07\x00\x07\x00"
            "\x0e\x00\x1c\x00\x38\x00\x38\x00\xff\x07\x00" }  },
      /* --- pixel bitmap for cmmib180 char#85 U --- */
      {  85, 1437,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 21,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xc1\x1f\x07\x40\xe0\x00\x08\x0e\x80\xc0\x01\x10"
            "\x38\x00\x02\x07\x40\x70\x00\x04\x0e\x80\xc0\x01\x10"
            "\x38\x00\x82\x03\x20\x70\x00\x04\x0e\x40\x80\x01\x04"
            "\x60\x60\x00\xf0\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#86 V --- */
      {  86, 1510,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 19,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xc0\xe7\x00\x08\x07\x20\x78\x80\x80\x03\x04\x1c"
            "\x10\xe0\x40\x00\x07\x02\x38\x08\x80\x23\x00\x9c\x01"
            "\xe0\x04\x00\x17\x00\x78\x00\xc0\x03\x00\x0c\x00\x20"
            "\x00\x00" }  },
      /* --- pixel bitmap for cmmib180 char#87 W --- */
      {  87, 1577,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 28,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7f\xf8\xc7\xcf\x01\x0e\x10\x1c\xf0\x80\xc0\x81\x0f"
            "\x08\x1c\xe8\x40\xc0\x41\x0e\x04\x1c\xc4\x21\xc0\x21"
            "\x1c\x01\x3c\xc3\x11\x80\x13\x9c\x00\xb8\xc0\x09\x80"
            "\x0b\x5c\x00\x78\xc0\x03\x80\x03\x3c\x00\x38\xc0\x01"
            "\x80\x01\x1c\x00\x18\x80\x00\x00" }  },
      /* --- pixel bitmap for cmmib180 char#88 X --- */
      {  88, 1692,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 22,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x8f\x3f\xe0\x80\x01\x78\x30\x00\x1c\x06\x00\xcf"
            "\x00\x80\x1b\x00\xe0\x03\x00\x70\x00\x00\x3c\x00\x80"
            "\x0f\x00\xb0\x03\x00\xc6\x01\xc0\x70\x00\x18\x38\x00"
            "\x03\x0e\x60\x80\x07\x7f\xf8\x07" }  },
      /* --- pixel bitmap for cmmib180 char#89 Y --- */
      {  89, 1759,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 20,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xff\xc0\xcf\x01\x10\x3c\x80\x80\x03\x04\x78\x20\x00"
            "\x07\x01\xf0\x08\x00\x4e\x00\xe0\x02\x00\x1e\x00\xc0"
            "\x00\x00\x0e\x00\xe0\x00\x00\x0e\x00\x60\x00\x00\x07"
            "\x00\xfe\x03\x00" }  },
      /* --- pixel bitmap for cmmib180 char#90 Z --- */
      {  90, 1818,                      /* character number, location */
         17, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 17,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\xff\xe1\xc0\x41\xc0\xc1\xc0\x83\x80\x03\x81\x03"
            "\x80\x03\x80\x03\x80\x03\x80\x03\x80\x03\x82\x07\x02"
            "\x07\x04\x07\x08\x07\x18\x07\x1c\xff\x3f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#91 \flat --- */
      {  91, 7102,                      /* character number, location */
         19, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    19, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x01\x01\x01\x01\x01\x01\x01\x7f\xe3\xe1\xe1\xe1"
            "\x71\x71\x39\x0d\x07\x01" }  },
      /* --- pixel bitmap for cmmib180 char#92 \natural --- */
      {  92, 7163,                      /* character number, location */
         18, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          {  6,    23, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x41\x10\x04\x61\xfe\xff\x67\x18\x86\x61\x18\x86\xf9"
            "\xff\x9f\x21\x08\x02" }  },
      /* --- pixel bitmap for cmmib180 char#93 \sharp --- */
      {  93, 7242,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          {  8,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x40\x40\x42\xc2\xf2\xfe\x7f\x4f\x43\x42\x42\x42\x42"
            "\x42\xc2\xf2\xfe\x7f\x4f\x43\x02\x02" }  },
      /* --- pixel bitmap for cmmib180 char#94 \smile --- */
      {  94, 7321,                      /* character number, location */
         10, 2,     3, 2,     /* topleft row,col, and botleft row,col */
          { 24,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x01\x00\x80\x02\x00\x40\x04\x00\x20\x18\x00\x18\xf0"
            "\x00\x0f\xc0\xff\x03\x00\xff\x00" }  },
      /* --- pixel bitmap for cmmib180 char#95 \frown --- */
      {  95, 7352,                      /* character number, location */
         10, 2,     3, 2,     /* topleft row,col, and botleft row,col */
          { 24,     7, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\xff\x01\xe0\xff\x07\x30\x00\x0c\x08\x00\x10\x04"
            "\x00\x20\x02\x00\x40\x01\x00\x80" }  },
      /* --- pixel bitmap for cmmib180 char#96 \ell --- */
      {  96, 5854,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x80\x03\x16\x30\xc1\x04\x27\xb8\xc0\x05\x17\x78\xc0"
            "\x01\x0e\x30\xc0\x01\x0d\x64\x00\x63\xf0\x00" }  },
      /* --- pixel bitmap for cmmib180 char#97 a --- */
      {  97, 1881,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x86\x71\x0c\xe7\x70\x0e\x77\x38\x87\x73\xb8\x87"
            "\x6b\x7c\x3c\x07" }  },
      /* --- pixel bitmap for cmmib180 char#98 b --- */
      {  98, 1936,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3e\xc0\x01\x0e\x38\xc0\x01\x0e\xf0\xc7\x63\x0e\x73"
            "\xb8\xc3\x0f\x77\xb8\xc3\x1d\xc7\x18\x3c\x00" }  },
      /* --- pixel bitmap for cmmib180 char#99 c --- */
      {  99, 1995,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\xc3\x31\xc7\x1d\xe6\x80\x03\x1c\xe0\x00\x06\x34"
            "\x18\x3f\x00" }  },
      /* --- pixel bitmap for cmmib180 char#100 d --- */
      { 100, 2034,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x1f\x80\x03\x70\x00\x07\xe0\x00\x1c\xbc\xc3\x38"
            "\x0c\xc7\xe1\x38\x9c\xc3\x71\x38\x0e\xd7\xe1\x32\x3e"
            "\x3c\x07" }  },
      /* --- pixel bitmap for cmmib180 char#101 e --- */
      { 101, 2101,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\xc1\x11\x83\x1c\xe4\x9c\x1f\x1c\xe0\x00\x06\x34"
            "\x18\x3e\x00" }  },
      /* --- pixel bitmap for cmmib180 char#102 f --- */
      { 102, 2142,                      /* character number, location */
         17, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 14,    22, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x1c\xc0\x0f\xb0\x03\x6e\x80\x03\xe0\x00\xff\x01"
            "\x0e\xc0\x01\x70\x00\x1c\x00\x07\xc0\x01\x70\x00\x0e"
            "\x80\x03\xe0\x00\x38\x60\x06\x9c\x01\x37\x80\x07\x00" }  },
      /* --- pixel bitmap for cmmib180 char#103 g --- */
      { 103, 2203,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x0d\xe3\x18\xce\xe1\x1c\xee\x70\x0e\xe7\x70\x0e"
            "\xc7\x38\xf8\x03\x38\x86\x73\x1c\xe7\xe0\x07" }  },
      /* --- pixel bitmap for cmmib180 char#104 h --- */
      { 104, 2268,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\x00\x0e\xc0\x01\x1c\x80\x03\x70\x00\xfe\xe1\x71"
            "\x1c\x8e\xc3\x71\x38\x87\xe3\x70\x1c\xae\xe3\x3c\x5c"
            "\x06\x07" }  },
      /* --- pixel bitmap for cmmib180 char#105 i --- */
      { 105, 2335,                      /* character number, location */
         18, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  7,    18, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x30\x38\x0c\x00\x00\x00\x18\x9a\x4c\x87\xe3\x70\xb8"
            "\x4e\x17\x07" }  },
      /* --- pixel bitmap for cmmib180 char#106 j --- */
      { 106, 2384,                      /* character number, location */
         18,-1,    -5,-1,     /* topleft row,col, and botleft row,col */
          { 11,    23, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x06\x38\x80\x00\x00\x00\x00\x00\x00\x38\xa0\x83"
            "\x1c\xe4\x00\x07\x1c\xe0\x00\x07\x38\xe0\x00\x07\x38"
            "\xcc\x71\x87\x1b\x78\x00" }  },
      /* --- pixel bitmap for cmmib180 char#107 k --- */
      { 107, 2443,                      /* character number, location */
         17, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x7c\x00\x07\x70\x80\x03\x38\x80\x03\x38\xce\xd1\x9c"
            "\xce\x65\x3c\xe0\x0f\xce\xe1\x9c\xce\x79\x5c\x86\x03" }  },
      /* --- pixel bitmap for cmmib180 char#108 l --- */
      { 108, 2514,                      /* character number, location */
         17, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,    17, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x3c\x8e\x73\x1c\xc7\x39\x8e\xe3\x1c\xc7\x75\x2d\x06" }  },
      /* --- pixel bitmap for cmmib180 char#109 m --- */
      { 109, 2561,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 22,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8e\x87\x47\x17\x13\xd3\xc3\xc3\x75\x70\x70\x1c\x1c"
            "\x9c\x83\x83\xe3\xe0\xe0\x38\x38\xb8\x0e\x0e\xe7\xc1"
            "\xc1\x65\x60\xe0\x00" }  },
      /* --- pixel bitmap for cmmib180 char#110 n --- */
      { 110, 2650,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 14,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8e\x47\x17\xd3\xc3\x75\x70\x1c\x9c\x83\xe3\xe0\x38"
            "\xb8\x0e\xe7\xc1\x65\xe0\x00" }  },
      /* --- pixel bitmap for cmmib180 char#111 o --- */
      { 111, 2715,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xe0\x81\x71\x0c\xe6\xe0\x0e\x7e\x70\x07\x77\x70\x87"
            "\x63\x1c\x7c\x00" }  },
      /* --- pixel bitmap for cmmib180 char#112 p --- */
      { 112, 2762,                      /* character number, location */
         11, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 14,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x38\x0f\x3d\x46\x87\xd1\xe1\x70\x38\x0e\x87\xc3\xe1"
            "\x70\x38\x0e\x8f\xc1\x1d\x70\x00\x1c\x80\x03\xe0\x00"
            "\xfc\x00" }  },
      /* --- pixel bitmap for cmmib180 char#113 q --- */
      { 113, 2829,                      /* character number, location */
         11, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf0\x8c\x71\x0c\xe7\x70\x0e\x77\x38\x87\x73\x38\x87"
            "\x63\x1c\xfc\x01\x1c\xc0\x01\x0e\xe0\x80\x3f" }  },
      /* --- pixel bitmap for cmmib180 char#114 r --- */
      { 114, 2888,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xce\xf5\xdc\x79\x67\x1c\x38\xe0\x80\x03\x0e\x1c\x60"
            "\x00" }  },
      /* --- pixel bitmap for cmmib180 char#115 s --- */
      { 115, 2931,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xf8\x18\x1b\x77\xe4\x87\x1f\xbc\x63\x47\xc6\x78\x00" }  },
      /* --- pixel bitmap for cmmib180 char#116 t --- */
      { 116, 2972,                      /* character number, location */
         16, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x38\x1c\x1c\x1c\xff\x0e\x0e\x0e\x0e\x07\x07\x47"
            "\x27\x37\x0e" }  },
      /* --- pixel bitmap for cmmib180 char#117 u --- */
      { 117, 3017,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\x4c\xc3\xe5\xb8\x0e\xc7\xe1\x1c\x8e\xc3\x71\xb8"
            "\x0e\x97\xf1\xe1\x39" }  },
      /* --- pixel bitmap for cmmib180 char#118 v --- */
      { 118, 3078,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\xd2\x78\xce\x3b\xcc\x41\x07\x39\xc8\x41\x0e\x61"
            "\x04\x1e\x00" }  },
      /* --- pixel bitmap for cmmib180 char#119 w --- */
      { 119, 3133,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          { 17,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\x8c\x34\x9c\xe7\x38\xef\x70\xcc\xe1\xd0\xe1\x90"
            "\xc3\x21\x87\x43\x0e\x47\x18\x8f\xe0\xf1\x00" }  },
      /* --- pixel bitmap for cmmib180 char#120 x --- */
      { 120, 3210,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x78\x8e\x3c\x8b\x73\x71\x06\x0e\xe0\x00\x1c\x98\x43"
            "\x77\x64\xcf\x98\x07" }  },
      /* --- pixel bitmap for cmmib180 char#121 y --- */
      { 121, 3267,                      /* character number, location */
         11, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 12,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x0c\xac\xe1\x39\xde\xe1\x1c\xee\x70\x0e\xe7\x70\x0e"
            "\xc7\x38\xf8\x03\x38\xc6\x71\x1c\x67\xe0\x03" }  },
      /* --- pixel bitmap for cmmib180 char#122 z --- */
      { 122, 3338,                      /* character number, location */
         11, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x70\x88\x7f\xfc\x02\x10\x80\x00\x06\x10\x80\x40\xf4"
            "\xe3\x3f\xc1\x01" }  },
      /* --- pixel bitmap for cmmib180 char#123 \imath --- */
      { 123, 5915,                      /* character number, location */
         11, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  6,    11, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x8c\x96\x75\x9c\xe3\xb8\xe7\xe5\x00" }  },
      /* --- pixel bitmap for cmmib180 char#124 \jmath --- */
      { 124, 5956,                      /* character number, location */
         11,-1,    -5,-1,     /* topleft row,col, and botleft row,col */
          { 11,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xc0\x03\x39\xc4\x21\x0e\x70\xc0\x01\x0e\x70\x80\x03"
            "\x0e\x70\x80\x63\x9c\x73\xdc\xc1\x03" }  },
      /* --- pixel bitmap for cmmib180 char#125 \wp --- */
      { 125, 6007,                      /* character number, location */
         11, 2,    -5, 2,     /* topleft row,col, and botleft row,col */
          { 15,    16, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x18\x00\x86\x8f\x31\xdc\x04\x6c\x01\x5e\x80\x1f\xc0"
            "\x0f\xe1\x8f\xb8\x4f\x4c\xcf\x21\x07\x90\x03\xc8\x00"
            "\x64\x00\x1c\x00" }  },
      /* --- pixel bitmap for cmmib180 char#126 \vec --- */
      { 126, 6090,                      /* character number, location */
         18, 5,    12, 5,     /* topleft row,col, and botleft row,col */
          { 11,     6, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\x00\x01\xdc\xff\xff\x0f\x1c\x40\x00" }  },
      /* --- pixel bitmap for cmmib180 char#127 (noname) --- */
      { 127, 6109,                      /* character number, location */
         16, 6,    14, 6,     /* topleft row,col, and botleft row,col */
          { 10,     2, 1,   (pixbyte *) /* widthxheight, pixsz,map... */
            "\xfc\x09\x08" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;



/* --------------------------------------------------------------------------
font sizes 0-5 for cmsy10
-------------------------------------------------------------------------- */

/* --- size=0 ---
 * mf '\mode=eighthre; input cmsy10'   gives .gf83
 * ----------------------------------------------- */
/* --- fontdef for cmsy83 --- */
static	chardef  cmsy83[] =
   {
      /* --- pixel bitmap for cmsy83 char#0 - --- */
      {   0,  943,                      /* character number, location */
          3, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#1 \cdot --- */
      {   1, 1591,                      /* character number, location */
          3, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmsy83 char#2 \times --- */
      {   2, 1745,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa1\xc4\x10\x8c\x14\x02" }  },
      /* --- pixel bitmap for cmsy83 char#3 \ast --- */
      {   3, 1774,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x2e" }  },
      /* --- pixel bitmap for cmsy83 char#4 \div --- */
      {   4, 1791,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x80\x0f\x00\x01" }  },
      /* --- pixel bitmap for cmsy83 char#5 \diamond --- */
      {   5, 1600,                      /* character number, location */
          5, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x45\x45\x00" }  },
      /* --- pixel bitmap for cmsy83 char#6 \pm --- */
      {   6,  952,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x82\x20\x3f\x82\x20\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#7 \mp --- */
      {   7, 1808,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x82\x20\x3f\x82\x20\x08" }  },
      /* --- pixel bitmap for cmsy83 char#8 \oplus --- */
      {   8,  977,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x96\xa6\x7f\x9a\x6a\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#9 \ominus --- */
      {   9, 1833,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\x7f\x18\x4a\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#10 \otimes --- */
      {  10, 1022,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x34\xb7\x65\x3b\x4b\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#11 \oslash --- */
      {  11, 1870,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\xa7\x65\x39\x4a\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#12 \odot --- */
      {  12, 1915,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\x6d\x18\x4a\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#13 \bigcirc --- */
      {  13, 1956,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81\x81\x81\x81\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmsy83 char#14 \circ --- */
      {  14, 1999,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xaa\x00" }  },
      /* --- pixel bitmap for cmsy83 char#15 \bullet --- */
      {  15, 2014,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  3,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xba\x00" }  },
      /* --- pixel bitmap for cmsy83 char#16 \asymp --- */
      {  16, 2027,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa1\xc4\x00\x8c\x14\x02" }  },
      /* --- pixel bitmap for cmsy83 char#17 \equiv --- */
      {  17, 1512,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x00\x00\x3f\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#18 \subseteq --- */
      {  18, 2056,                      /* character number, location */
          7, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbc\x10\x04\x41\x10\x08\x3c\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#19 \supseteq --- */
      {  19, 2085,                      /* character number, location */
          7, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\x04\x82\x20\x08\x42\x0f\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#20 \leq --- */
      {  20, 1454,                      /* character number, location */
          7, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\xc4\x08\x81\xc0\x40\x20\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#21 \geq --- */
      {  21, 1483,                      /* character number, location */
          7, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\xc0\x40\x20\xc4\x08\x01\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#22 \preceq --- */
      {  22, 2114,                      /* character number, location */
          7, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x08\x21\x07\x02\x81\x20\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#23 \succeq --- */
      {  23, 2143,                      /* character number, location */
          7, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x41\x20\x10\x38\x21\x04\x01\x00\x00\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#24 \sim --- */
      {  24, 2172,                      /* character number, location */
          4, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6f\x0e" }  },
      /* --- pixel bitmap for cmsy83 char#25 \approx --- */
      {  25, 2187,                      /* character number, location */
          6, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x67\xd9\xe6\x67\xd9\xe6" }  },
      /* --- pixel bitmap for cmsy83 char#26 \subset --- */
      {  26, 1308,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbc\x10\x04\x41\x10\x08\x3c" }  },
      /* --- pixel bitmap for cmsy83 char#27 \supset --- */
      {  27, 1333,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\x04\x82\x20\x08\x42\x0f" }  },
      /* --- pixel bitmap for cmsy83 char#28 \ll --- */
      {  28, 2234,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x90\x48\x24\x12\x09\x12\x24\x48\x90" }  },
      /* --- pixel bitmap for cmsy83 char#29 \gg --- */
      {  29, 2277,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x09\x12\x24\x48\x90\x48\x24\x12\x09" }  },
      /* --- pixel bitmap for cmsy83 char#30 \prec --- */
      {  30, 2320,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x08\x21\x07\x02\x81\x20" }  },
      /* --- pixel bitmap for cmsy83 char#31 \succ --- */
      {  31, 2345,                      /* character number, location */
          6, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x41\x20\x10\x38\x21\x04\x01" }  },
      /* --- pixel bitmap for cmsy83 char#32 \leftarrow --- */
      {  32, 1249,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x06\x02\xff\x02\x06" }  },
      /* --- pixel bitmap for cmsy83 char#33 \rightarrow --- */
      {  33, 1266,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x60\x40\xff\x40\x60" }  },
      /* --- pixel bitmap for cmsy83 char#34 \uparrow --- */
      {  34, 1222,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x7c\x42\x08\x21\x84\x00" }  },
      /* --- pixel bitmap for cmsy83 char#35 \downarrow --- */
      {  35, 1195,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x10\x42\x08\xf9\x84\x00" }  },
      /* --- pixel bitmap for cmsy83 char#36 \leftrightarrow --- */
      {  36, 1283,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x66\x42\xff\x42\x66" }  },
      /* --- pixel bitmap for cmsy83 char#37 \nearrow --- */
      {  37, 2370,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xf0\x80\x81\x85\x09\x01\x01\x03\x03\x02\x02\x00" }  },
      /* --- pixel bitmap for cmsy83 char#38 \searrow --- */
      {  38, 2401,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x01\x04\x18\x20\x80\x00\x02\x48\xb0\xc0\xe0\x01" }  },
      /* --- pixel bitmap for cmsy83 char#39 \simeq --- */
      {  39, 2432,                      /* character number, location */
          5, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x67\x9b\x03\x00\xf0\x03" }  },
      /* --- pixel bitmap for cmsy83 char#40 \Leftarrow --- */
      {  40, 2457,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\xfc\x02\x02\x02\xfc\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#41 \Rightarrow --- */
      {  41, 2478,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa0\x1f\x10\x08\xfc\xc1\x00" }  },
      /* --- pixel bitmap for cmsy83 char#42 \Uparrow --- */
      {  42, 2499,                      /* character number, location */
          7,-1,    -2,-1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x24\xc3\x42\x42\x42\x42\x42\x42" }  },
      /* --- pixel bitmap for cmsy83 char#43 \Downarrow --- */
      {  43, 2540,                      /* character number, location */
          8,-1,    -1,-1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x42\x42\x42\x42\x42\x42\xc3\x24\x18" }  },
      /* --- pixel bitmap for cmsy83 char#44 \Leftrightarrow --- */
      {  44, 2581,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x24\x7e\x42\xc3\x42\x3c\x24" }  },
      /* --- pixel bitmap for cmsy83 char#45 \nwarrow --- */
      {  45, 2612,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x1e\x0c\x34\x48\x00\x01\x04\x10\x60\x80\x00\x02" }  },
      /* --- pixel bitmap for cmsy83 char#46 \swarrow --- */
      {  46, 2643,                      /* character number, location */
          8, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x00\x01\x01\x03\x03\x02\x42\x86\x06\x06\x3c\x00" }  },
      /* --- pixel bitmap for cmsy83 char#47 \propto --- */
      {  47, 2674,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe6\x4c\x26\x63\x06" }  },
      /* --- pixel bitmap for cmsy83 char#48 \prime --- */
      {  48, 2701,                      /* character number, location */
          6, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  2,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6a\x05" }  },
      /* --- pixel bitmap for cmsy83 char#49 \infty --- */
      {  49, 1685,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x66\x99\x99\x99\x66" }  },
      /* --- pixel bitmap for cmsy83 char#50 \in --- */
      {  50, 1358,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\x84\xf0\x43\x10\x1c" }  },
      /* --- pixel bitmap for cmsy83 char#51 \ni --- */
      {  51, 2720,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07\x41\xf8\x21\x44\x07" }  },
      /* --- pixel bitmap for cmsy83 char#52 \triangle --- */
      {  52, 2745,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x04\x85\x22\x12\x05\xff" }  },
      /* --- pixel bitmap for cmsy83 char#53 \bigtriangledown --- */
      {  53, 2778,                      /* character number, location */
          6, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\xa0\x48\x44\xa1\x20\x10" }  },
      /* --- pixel bitmap for cmsy83 char#54 / --- */
      {  54, 2811,                      /* character number, location */
          8, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x04\x21\x08\x41\x10\x82\x10\x00" }  },
      /* --- pixel bitmap for cmsy83 char#55 ' --- */
      {  55, 2840,                      /* character number, location */
          5, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmsy83 char#56 \forall --- */
      {  56, 1383,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x31\x3a\xa5\x14\x21" }  },
      /* --- pixel bitmap for cmsy83 char#57 \exists --- */
      {  57, 1416,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x27\x4d\xf2" }  },
      /* --- pixel bitmap for cmsy83 char#58 \neg --- */
      {  58, 1439,                      /* character number, location */
          4, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x42\x08" }  },
      /* --- pixel bitmap for cmsy83 char#59 \emptyset --- */
      {  59, 2857,                      /* character number, location */
          9, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc8\xe5\x5a\x6b\x9d\x4e\x00" }  },
      /* --- pixel bitmap for cmsy83 char#60 \Re --- */
      {  60, 2904,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x36\xb5\x52\xa7\xc1\x64\xcc" }  },
      /* --- pixel bitmap for cmsy83 char#61 \Im --- */
      {  61, 2945,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4e\x1c\xc4\x72\x24\x31" }  },
      /* --- pixel bitmap for cmsy83 char#62 \top --- */
      {  62, 2978,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\x04\x02\x81\x40\x20\x00" }  },
      /* --- pixel bitmap for cmsy83 char#63 \bot --- */
      {  63, 2999,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x04\x02\x81\x40\xfc\x01" }  },
      /* --- pixel bitmap for cmsy83 char#64 \aleph --- */
      {  64, 3020,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x99\xbb\xdd\x9a" }  },
      /* --- pixel bitmap for cmsy83 char#65 \calA --- */
      {  65,   35,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x18\x0c\x85\xe2\x89\x82" }  },
      /* --- pixel bitmap for cmsy83 char#66 \calB --- */
      {  66,   66,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\x49\x6b\xa2\x28\x37" }  },
      /* --- pixel bitmap for cmsy83 char#67 \calC --- */
      {  67,  103,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\x8a\x10\x42\x32" }  },
      /* --- pixel bitmap for cmsy83 char#68 \calD --- */
      {  68,  130,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbe\x64\x92\x48\x24\x51\x1c" }  },
      /* --- pixel bitmap for cmsy83 char#69 \calE --- */
      {  69,  169,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  5,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x12\x26\x42\x32" }  },
      /* --- pixel bitmap for cmsy83 char#70 \calF --- */
      {  70,  196,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\x29\x40\x80\x80\x07\x01\x81\x03" }  },
      /* --- pixel bitmap for cmsy83 char#71 \calG --- */
      {  71,  221,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  5,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5c\xc6\x10\xb3\x43\x07" }  },
      /* --- pixel bitmap for cmsy83 char#72 \calH --- */
      {  72,  254,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xce\x24\x12\xe9\x23\x91\xc4" }  },
      /* --- pixel bitmap for cmsy83 char#73 \calI --- */
      {  73,  293,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\x09\x02\x81\x20\x10\x3e" }  },
      /* --- pixel bitmap for cmsy83 char#74 \calJ --- */
      {  74,  318,                      /* character number, location */
          8, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf0\x48\x24\x20\x10\x10\x10\x09\x06" }  },
      /* --- pixel bitmap for cmsy83 char#75 \calK --- */
      {  75,  349,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x64\x0a\xc3\x60\x50\x28\x63" }  },
      /* --- pixel bitmap for cmsy83 char#76 \calL --- */
      {  76,  384,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x4a\x10\x84\xe0\xe6" }  },
      /* --- pixel bitmap for cmsy83 char#77 \calM --- */
      {  77,  413,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x08\xc4\x20\x86\x31\x4a\x31\x52\x91\x69\xc0" }  },
      /* --- pixel bitmap for cmsy83 char#78 \calN --- */
      {  78,  462,                      /* character number, location */
          9,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x00\x46\x08\x46\x30\x82\x09\x4a\x90\x82\x0c\x43\x00" }  },
      /* --- pixel bitmap for cmsy83 char#79 \calO --- */
      {  79,  507,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x34\xa5\x31\x18\x0c\x45\x1c" }  },
      /* --- pixel bitmap for cmsy83 char#80 \calP --- */
      {  80,  546,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x9a\x92\x14\x43\x08\x02" }  },
      /* --- pixel bitmap for cmsy83 char#81 \calQ --- */
      {  81,  583,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\xa3\x30\x18\x0c\x79\x0e\x78" }  },
      /* --- pixel bitmap for cmsy83 char#82 \calR --- */
      {  82,  618,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3e\x49\x49\x24\x1c\x14\x24\xe2" }  },
      /* --- pixel bitmap for cmsy83 char#83 \calS --- */
      {  83,  657,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x49\x20\xb0\x18\x3b" }  },
      /* --- pixel bitmap for cmsy83 char#84 \calT --- */
      {  84,  686,                      /* character number, location */
          8, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x12\x10\x08\x08\x08\x08\x04\x04" }  },
      /* --- pixel bitmap for cmsy83 char#85 \calU --- */
      {  85,  713,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x46\x22\x49\x24\xcb\x64\x6e" }  },
      /* --- pixel bitmap for cmsy83 char#86 \calV --- */
      {  86,  752,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x23\x22\x91\x44\xa2\x28\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#87 \calW --- */
      {  87,  789,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x43\x22\x23\x19\xa9\x44\x25\xa6\x18\x43\x18" }  },
      /* --- pixel bitmap for cmsy83 char#88 \calX --- */
      {  88,  844,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc8\x90\x70\x10\x18\x16\x11\x33" }  },
      /* --- pixel bitmap for cmsy83 char#89 \calY --- */
      {  89,  877,                      /* character number, location */
          8, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x26\x24\x12\x85\xc2\x20\x0a\x03" }  },
      /* --- pixel bitmap for cmsy83 char#90 \calZ --- */
      {  90,  914,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf8\x44\x20\x38\x08\x44\x42\x3f" }  },
      /* --- pixel bitmap for cmsy83 char#91 \cup --- */
      {  91, 1067,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x31\xc6\x18\xa3\x03" }  },
      /* --- pixel bitmap for cmsy83 char#92 \cap --- */
      {  92, 1100,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\x18\x63\x04" }  },
      /* --- pixel bitmap for cmsy83 char#93 \uplus --- */
      {  93, 3059,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x31\xc6\x1a\xa3\x03" }  },
      /* --- pixel bitmap for cmsy83 char#94 \wedge --- */
      {  94, 1133,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x28\xa5\x62\x04" }  },
      /* --- pixel bitmap for cmsy83 char#95 \vee --- */
      {  95, 1164,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x31\x2a\xa5\x08\x01" }  },
      /* --- pixel bitmap for cmsy83 char#96 \vdash --- */
      {  96, 3094,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\xf1\x11\x11" }  },
      /* --- pixel bitmap for cmsy83 char#97 \dashv --- */
      {  97, 3117,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\xe8\x88\x88" }  },
      /* --- pixel bitmap for cmsy83 char#98 \lfloor --- */
      {  98, 3140,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x49\x92\x24\x49\x72" }  },
      /* --- pixel bitmap for cmsy83 char#99 \rfloor --- */
      {  99, 3173,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x24\x49\x92\x24\x79" }  },
      /* --- pixel bitmap for cmsy83 char#100 \lceil --- */
      { 100, 3206,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x92\x24\x49\x12" }  },
      /* --- pixel bitmap for cmsy83 char#101 \rceil --- */
      { 101, 3239,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x27\x49\x92\x24\x49" }  },
      /* --- pixel bitmap for cmsy83 char#102 \{ --- */
      { 102, 1623,                      /* character number, location */
          9, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x10\x42\xce\x21\x84\x10\x0c" }  },
      /* --- pixel bitmap for cmsy83 char#103 \} --- */
      { 103, 1654,                      /* character number, location */
          9, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x83\x10\x42\x38\x27\x84\x90\x01" }  },
      /* --- pixel bitmap for cmsy83 char#104 \langle --- */
      { 104, 3272,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa4\xa4\x24\x92\x48" }  },
      /* --- pixel bitmap for cmsy83 char#105 \rangle --- */
      { 105, 3305,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x89\x24\x92\x92\x12" }  },
      /* --- pixel bitmap for cmsy83 char#106 \mid --- */
      { 106, 1560,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  1,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x0f" }  },
      /* --- pixel bitmap for cmsy83 char#107 \parallel --- */
      { 107, 3338,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x31\xc6\x18\x63\x8c\x31\xc6\x18\x01" }  },
      /* --- pixel bitmap for cmsy83 char#108 \updownarrow --- */
      { 108, 3397,                      /* character number, location */
          9, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  5,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x7c\x42\x08\x21\xe4\x13\x02" }  },
      /* --- pixel bitmap for cmsy83 char#109 \Updownarrow --- */
      { 109, 3428,                      /* character number, location */
          8,-1,    -2,-1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x66\xc3\x42\x42\x42\x42\xc3\x66\x18" }  },
      /* --- pixel bitmap for cmsy83 char#110 \setminus --- */
      { 110, 1529,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x49\x24\x49\x22\x09" }  },
      /* --- pixel bitmap for cmsy83 char#111 \wr --- */
      { 111, 3471,                      /* character number, location */
          7, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  2,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xab\x57\x03" }  },
      /* --- pixel bitmap for cmsy83 char#112 \surd --- */
      { 112, 3496,                      /* character number, location */
          1, 1,   -11, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x02\x02\x04\x04\x88\x88\x11\x14\x28\x30\x40"
            "\x00" }  },
      /* --- pixel bitmap for cmsy83 char#113 \amalg --- */
      { 113, 3535,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xe7\x42\x42\x42\x42\x42\x42\xff" }  },
      /* --- pixel bitmap for cmsy83 char#114 \nabla --- */
      { 114, 3572,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x82\x44\x44\x6c\x28\x28\x10" }  },
      /* --- pixel bitmap for cmsy83 char#115 \int --- */
      { 115, 1718,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb4\x24\x49\x0b" }  },
      /* --- pixel bitmap for cmsy83 char#116 \sqcup --- */
      { 116, 3607,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x31\xc6\x18\xe3\x07" }  },
      /* --- pixel bitmap for cmsy83 char#117 \sqcap --- */
      { 117, 3640,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\xc6\x18\x63\x04" }  },
      /* --- pixel bitmap for cmsy83 char#118 \sqsubseteq --- */
      { 118, 3673,                      /* character number, location */
          7, 1,    -6, 1,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xff\x40\x20\x10\x08\x04\x02\x7f\x00\x00\xf0\x03" }  },
      /* --- pixel bitmap for cmsy83 char#119 \sqsupseteq --- */
      { 119, 3702,                      /* character number, location */
          7, 0,    -6, 0,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x7f\x20\x10\x08\x04\x02\x81\x7e\x00\x00\xe0\x07" }  },
      /* --- pixel bitmap for cmsy83 char#120 \S --- */
      { 120, 3731,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  2,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xdf\xbf\x0f" }  },
      /* --- pixel bitmap for cmsy83 char#121 \dag --- */
      { 121, 3758,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x92\x2e\x49\x12" }  },
      /* --- pixel bitmap for cmsy83 char#122 \ddag --- */
      { 122, 3785,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  3,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd2\x25\xc8\x17" }  },
      /* --- pixel bitmap for cmsy83 char#123 \P --- */
      { 123, 3812,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7e\xad\xb5\x94\x52\x4a\x01" }  },
      /* --- pixel bitmap for cmsy83 char#124 \clubsuit --- */
      { 124, 3857,                      /* character number, location */
          8, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x38\xf8\xf0\xc1\xe1\xef\xff\x7f\x6b\x10\x00" }  },
      /* --- pixel bitmap for cmsy83 char#125 \Diamond --- */
      { 125, 3886,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x0a\x45\x14\x14\x51\x28\x08" }  },
      /* --- pixel bitmap for cmsy83 char#126 \Heart --- */
      { 126, 3925,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf7\x64\x30\x18\x14\x51\x10" }  },
      /* --- pixel bitmap for cmsy83 char#127 \spadesuit --- */
      { 127, 3964,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x04\xc7\xf7\xff\xff\xd7\x08" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=1 ---
 * mf '\mode=nextscrn; input cmsy10'   gives .gf100
 * ------------------------------------------------ */
/* --- fontdef for cmsy100 --- */
static	chardef  cmsy100[] =
   {
      /* --- pixel bitmap for cmsy100 char#0 - --- */
      {   0, 1075,                      /* character number, location */
          4, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  8,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff" }  },
      /* --- pixel bitmap for cmsy100 char#1 \cdot --- */
      {   1, 1811,                      /* character number, location */
          4, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          {  1,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01" }  },
      /* --- pixel bitmap for cmsy100 char#2 \times --- */
      {   2, 1985,                      /* character number, location */
          7, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  6,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa1\xc4\x10\x8c\x14\x02" }  },
      /* --- pixel bitmap for cmsy100 char#3 \ast --- */
      {   3, 2014,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  4,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd4\xff\x4d" }  },
      /* --- pixel bitmap for cmsy100 char#4 \div --- */
      {   4, 2037,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x00\xe0\x0f\x00\x20\x00" }  },
      /* --- pixel bitmap for cmsy100 char#5 \diamond --- */
      {   5, 1820,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x44\x45\x45\x00" }  },
      /* --- pixel bitmap for cmsy100 char#6 \pm --- */
      {   6, 1084,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x10\x10\x10\xff\x10\x10\x10\xff" }  },
      /* --- pixel bitmap for cmsy100 char#7 \mp --- */
      {   7, 2054,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x10\x10\x10\xff\x10\x10\x10\x10" }  },
      /* --- pixel bitmap for cmsy100 char#8 \oplus --- */
      {   8, 1109,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x52\x91\x91\xff\x91\x91\x52\x3c" }  },
      /* --- pixel bitmap for cmsy100 char#9 \ominus --- */
      {   9, 2079,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81\x81\xff\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmsy100 char#10 \otimes --- */
      {  10, 1158,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\xa5\x99\x89\x99\xa5\x42\x3c" }  },
      /* --- pixel bitmap for cmsy100 char#11 \oslash --- */
      {  11, 2116,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\xa1\x91\x89\x89\x85\x42\x3c" }  },
      /* --- pixel bitmap for cmsy100 char#12 \odot --- */
      {  12, 2165,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81\x81\x99\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmsy100 char#13 \bigcirc --- */
      {  13, 2206,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x20\x88\x80\x04\x14\xc0\x00\x06\x30\x80\x01\x14"
            "\x90\x80\x08\x82\x0f" }  },
      /* --- pixel bitmap for cmsy100 char#14 \circ --- */
      {  14, 2261,                      /* character number, location */
          6, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x69" }  },
      /* --- pixel bitmap for cmsy100 char#15 \bullet --- */
      {  15, 2280,                      /* character number, location */
          6, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  4,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf6\x6f" }  },
      /* --- pixel bitmap for cmsy100 char#16 \asymp --- */
      {  16, 2295,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x42\x3c\x00\x3c\x42\x81" }  },
      /* --- pixel bitmap for cmsy100 char#17 \equiv --- */
      {  17, 1728,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x00\x00\x00\xff\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#18 \subseteq --- */
      {  18, 2324,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x02\x01\x01\x01\x01\x01\x02\xfc\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#19 \supseteq --- */
      {  19, 2353,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3f\x40\x80\x80\x80\x80\x80\x40\x3f\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#20 \leq --- */
      {  20, 1670,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x80\x60\x18\x06\x01\x06\x18\x60\x80\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#21 \geq --- */
      {  21, 1699,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x01\x06\x18\x60\x80\x60\x18\x06\x01\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#22 \preceq --- */
      {  22, 2382,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x80\x80\x40\x30\x0f\x30\x40\x80\x80\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#23 \succeq --- */
      {  23, 2411,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x01\x01\x02\x0c\xf0\x0c\x02\x01\x01\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#24 \sim --- */
      {  24, 2440,                      /* character number, location */
          5, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     3, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8f\x99\xf1" }  },
      /* --- pixel bitmap for cmsy100 char#25 \approx --- */
      {  25, 2461,                      /* character number, location */
          7, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8f\x89\x99\xf1\x8f\x89\x99\xf1" }  },
      /* --- pixel bitmap for cmsy100 char#26 \subset --- */
      {  26, 1512,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x02\x01\x01\x01\x01\x01\x02\xfc" }  },
      /* --- pixel bitmap for cmsy100 char#27 \supset --- */
      {  27, 1537,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x40\x80\x80\x80\x80\x80\x40\x3f" }  },
      /* --- pixel bitmap for cmsy100 char#28 \ll --- */
      {  28, 2508,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x20\x82\x08\x33\x44\x10\x01\x11\x30\x03\x22\x60\x06" }  },
      /* --- pixel bitmap for cmsy100 char#29 \gg --- */
      {  29, 2551,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x33\x20\x02\x66\x60\x06\x44\x10\x21\x82\x08\x33\x00" }  },
      /* --- pixel bitmap for cmsy100 char#30 \prec --- */
      {  30, 2594,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x80\x80\x40\x30\x0f\x30\x40\x80\x80" }  },
      /* --- pixel bitmap for cmsy100 char#31 \succ --- */
      {  31, 2619,                      /* character number, location */
          7, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x01\x01\x02\x0c\xf0\x0c\x02\x01\x01" }  },
      /* --- pixel bitmap for cmsy100 char#32 \leftarrow --- */
      {  32, 1437,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x20\x80\x00\xfe\x2f\x00\x02\x10\x00" }  },
      /* --- pixel bitmap for cmsy100 char#33 \rightarrow --- */
      {  33, 1458,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x00\x01\x08\x80\xfe\x0f\x20\x80\x00\x04" }  },
      /* --- pixel bitmap for cmsy100 char#34 \uparrow --- */
      {  34, 1400,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\xb8\x4a\x08\x21\x84\x10\x42\x00" }  },
      /* --- pixel bitmap for cmsy100 char#35 \downarrow --- */
      {  35, 1363,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x10\x42\x08\x21\xa4\x3a\x42\x00" }  },
      /* --- pixel bitmap for cmsy100 char#36 \leftrightarrow --- */
      {  36, 1479,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x04\x21\x88\x80\xfe\x2f\x20\x82\x10\x04" }  },
      /* --- pixel bitmap for cmsy100 char#37 \nearrow --- */
      {  37, 2644,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xc0\x07\x60\x00\x07\x98\xc0\x08\x04\x20\x00\x01\x18"
            "\xc0\x00\x04\x20\x00\x01\x00" }  },
      /* --- pixel bitmap for cmsy100 char#38 \searrow --- */
      {  38, 2681,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x20\x00\x04\xc0\x00\x08\x00\x01\x20\x00\x04\x80"
            "\x08\x98\x00\x05\x60\xc0\x07" }  },
      /* --- pixel bitmap for cmsy100 char#39 \simeq --- */
      {  39, 2720,                      /* character number, location */
          6, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8f\x99\xf1\x00\x00\x00\xff" }  },
      /* --- pixel bitmap for cmsy100 char#40 \Leftarrow --- */
      {  40, 2745,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x10\x40\x00\xff\x05\x20\x00\x02\xe0\x1f\x01\x10\x00" }  },
      /* --- pixel bitmap for cmsy100 char#41 \Rightarrow --- */
      {  41, 2770,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x40\x00\xf2\x1f\x80\x00\x02\xf4\x0f\x20\x40\x00" }  },
      /* --- pixel bitmap for cmsy100 char#42 \Uparrow --- */
      {  42, 2795,                      /* character number, location */
          9, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x18\x18\x66\xc3\x42\x42\x42\x42\x42\x42\x42\x42" }  },
      /* --- pixel bitmap for cmsy100 char#43 \Downarrow --- */
      {  43, 2846,                      /* character number, location */
         10, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x42\x42\x42\x42\x42\x42\x42\x42\xc3\x66\x18\x18" }  },
      /* --- pixel bitmap for cmsy100 char#44 \Leftrightarrow --- */
      {  44, 2897,                      /* character number, location */
          8, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x44\x8c\xf9\x0b\x18\x70\xb0\x3f\x22\x44\x00" }  },
      /* --- pixel bitmap for cmsy100 char#45 \nwarrow --- */
      {  45, 2936,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3e\x60\x00\x0a\x90\x01\x11\x00\x02\x40\x00\x08\x00"
            "\x01\x30\x00\x02\x40\x00\x08" }  },
      /* --- pixel bitmap for cmsy100 char#46 \swarrow --- */
      {  46, 2975,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 12,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x08\x40\x00\x02\x30\x80\x01\x08\x40\x00\x02\x31"
            "\x90\x01\x0e\x60\x00\x3e\x00" }  },
      /* --- pixel bitmap for cmsy100 char#47 \propto --- */
      {  47, 3012,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xce\x31\x31\x31\x31\xce" }  },
      /* --- pixel bitmap for cmsy100 char#48 \prime --- */
      {  48, 3043,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa4\xa4\x25" }  },
      /* --- pixel bitmap for cmsy100 char#49 \infty --- */
      {  49, 1909,                      /* character number, location */
          6, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8e\x8b\x62\x08\x43\x18\x45\xc7\x01" }  },
      /* --- pixel bitmap for cmsy100 char#50 \in --- */
      {  50, 1562,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xbc\x10\x04\x7f\x10\x08\x3c" }  },
      /* --- pixel bitmap for cmsy100 char#51 \ni --- */
      {  51, 3066,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f\x04\x82\x3f\x08\x42\x0f" }  },
      /* --- pixel bitmap for cmsy100 char#52 \triangle --- */
      {  52, 3091,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x10\x20\xa0\x40\x41\x84\x88\x20\x41\x01\xff\x03" }  },
      /* --- pixel bitmap for cmsy100 char#53 \bigtriangledown --- */
      {  53, 3132,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xff\x03\x0a\x12\x44\x84\x08\x0a\x14\x10\x20\x00" }  },
      /* --- pixel bitmap for cmsy100 char#54 / --- */
      {  54, 3173,                      /* character number, location */
         10, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x20\x08\x41\x08\x42\x10\x84\x20\x04\x01" }  },
      /* --- pixel bitmap for cmsy100 char#55 ' --- */
      {  55, 3206,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmsy100 char#56 \forall --- */
      {  56, 1587,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc1\xa0\xc8\x27\xa2\x50\x28\x08\x04" }  },
      /* --- pixel bitmap for cmsy100 char#57 \exists --- */
      {  57, 1628,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x42\xe8\x21\x84\xf0\x03" }  },
      /* --- pixel bitmap for cmsy100 char#58 \neg --- */
      {  58, 1655,                      /* character number, location */
          5, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  6,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x08\x82" }  },
      /* --- pixel bitmap for cmsy100 char#59 \emptyset --- */
      {  59, 3223,                      /* character number, location */
         10, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  6,    11, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x9e\x94\xa6\x69\x59\x96\x96\x27\x00" }  },
      /* --- pixel bitmap for cmsy100 char#60 \Re --- */
      {  60, 3280,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x66\x34\x49\x92\x28\x4f\x0a\x14\x28\x4b\x9c\x03" }  },
      /* --- pixel bitmap for cmsy100 char#61 \Im --- */
      {  61, 3337,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1c\xa2\xc1\x01\xc1\xc6\x40\x43\x44\x38" }  },
      /* --- pixel bitmap for cmsy100 char#62 \top --- */
      {  62, 3378,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xff\x21\x40\x80\x00\x01\x02\x04\x08\x10\x00" }  },
      /* --- pixel bitmap for cmsy100 char#63 \bot --- */
      {  63, 3403,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x10\x20\x40\x80\x00\x01\x02\x04\x08\xff\x01" }  },
      /* --- pixel bitmap for cmsy100 char#64 \aleph --- */
      {  64, 3428,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x29\xe9\xdd\x5a\x4a\x32\x02" }  },
      /* --- pixel bitmap for cmsy100 char#65 \calA --- */
      {  65,   35,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x80\x00\x03\x0a\x28\x90\x40\x84\x5f\x41\x02\x03" }  },
      /* --- pixel bitmap for cmsy100 char#66 \calB --- */
      {  66,   74,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x64\x9c\x8c\x74\x66\x82\x82\x42\x3d" }  },
      /* --- pixel bitmap for cmsy100 char#67 \calC --- */
      {  67,  117,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x29\x05\x41\x10\x44\x0e" }  },
      /* --- pixel bitmap for cmsy100 char#68 \calD --- */
      {  68,  148,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x7e\x12\x25\x44\x88\x90\x10\x21\x32\x1e\x00" }  },
      /* --- pixel bitmap for cmsy100 char#69 \calE --- */
      {  69,  191,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x38\x29\x08\x8c\x10\x44\x0e" }  },
      /* --- pixel bitmap for cmsy100 char#70 \calF --- */
      {  70,  220,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\x47\x01\x09\x40\x00\x1e\x08\x40\x00\x01\x06\x00" }  },
      /* --- pixel bitmap for cmsy100 char#71 \calG --- */
      {  71,  249,                      /* character number, location */
          9, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\xa2\x28\x10\x0a\xc5\x3c\x90\x07" }  },
      /* --- pixel bitmap for cmsy100 char#72 \calH --- */
      {  72,  286,                      /* character number, location */
          9,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x1c\x4a\x18\x11\x44\xfc\x21\x82\x08\x22\x84\x03" }  },
      /* --- pixel bitmap for cmsy100 char#73 \calI --- */
      {  73,  331,                      /* character number, location */
          9,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfc\x12\x10\x10\x10\x08\x08\x44\x3f" }  },
      /* --- pixel bitmap for cmsy100 char#74 \calJ --- */
      {  74,  360,                      /* character number, location */
          9, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xe0\x43\x82\x08\x22\x40\x00\x01\x04\x08\x21\x78\x00" }  },
      /* --- pixel bitmap for cmsy100 char#75 \calK --- */
      {  75,  395,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc4\x24\x14\x0c\x0a\x0a\x12\x91\x61" }  },
      /* --- pixel bitmap for cmsy100 char#76 \calL --- */
      {  76,  438,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x70\x24\x82\x40\x20\x08\x9c\x39" }  },
      /* --- pixel bitmap for cmsy100 char#77 \calM --- */
      {  77,  469,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x20\x04\x88\x01\xa3\xa0\x28\x14\x8a\x44\x14\x11"
            "\x43\x03\x30" }  },
      /* --- pixel bitmap for cmsy100 char#78 \calN --- */
      {  78,  530,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x00\x23\x82\x08\x23\x4c\x30\x41\x85\x14\x32\x84\x00" }  },
      /* --- pixel bitmap for cmsy100 char#79 \calO --- */
      {  79,  579,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xe8\x28\x2a\x0c\x18\x30\x50\x20\x31\x1c\x00" }  },
      /* --- pixel bitmap for cmsy100 char#80 \calP --- */
      {  80,  624,                      /* character number, location */
          9, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xfe\x12\x26\x44\x88\x8c\x07\x01\x02\x02\x04\x00" }  },
      /* --- pixel bitmap for cmsy100 char#81 \calQ --- */
      {  81,  663,                      /* character number, location */
          9, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x44\x82\x81\x81\x41\x51\x3e\x0f\xf0" }  },
      /* --- pixel bitmap for cmsy100 char#82 \calR --- */
      {  82,  704,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xfe\x24\x94\x10\x22\x78\x90\x40\x04\x91\x82\x01" }  },
      /* --- pixel bitmap for cmsy100 char#83 \calS --- */
      {  83,  749,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\x84\x04\x08\x30\x41\x41\x21\x1e" }  },
      /* --- pixel bitmap for cmsy100 char#84 \calT --- */
      {  84,  782,                      /* character number, location */
          9, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xfe\x23\x40\x40\x80\x00\x01\x02\x04\x04\x08\x00" }  },
      /* --- pixel bitmap for cmsy100 char#85 \calU --- */
      {  85,  811,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x86\x84\x44\x42\x62\x21\x31\x29\x66" }  },
      /* --- pixel bitmap for cmsy100 char#86 \calV --- */
      {  86,  856,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x41\x82\x84\x44\x44\x24\x14\x0c\x06" }  },
      /* --- pixel bitmap for cmsy100 char#87 \calW --- */
      {  87,  895,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x43\x88\x18\x92\x42\x52\x44\x91\x28\x0a\x43\x31\x18"
            "\x02\x01" }  },
      /* --- pixel bitmap for cmsy100 char#88 \calX --- */
      {  88,  960,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x18\x83\x08\x1a\x18\x30\xa0\x60\x42\x08\xc3\x00" }  },
      /* --- pixel bitmap for cmsy100 char#89 \calY --- */
      {  89,  999,                      /* character number, location */
          9, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x86\x10\x42\x84\x04\x09\x0a\x14\x10\x19\x0c\x00" }  },
      /* --- pixel bitmap for cmsy100 char#90 \calZ --- */
      {  90, 1042,                      /* character number, location */
          9, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xf8\x09\x11\x01\x01\x07\x01\x21\x41\x7f\x00" }  },
      /* --- pixel bitmap for cmsy100 char#91 \cup --- */
      {  91, 1211,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x61\x18\x86\x61\x18\x4a\x0c" }  },
      /* --- pixel bitmap for cmsy100 char#92 \cap --- */
      {  92, 1252,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8c\x14\x86\x61\x18\x86\x21" }  },
      /* --- pixel bitmap for cmsy100 char#93 \uplus --- */
      {  93, 3475,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x61\x18\xa6\x6d\x18\x4a\x0c" }  },
      /* --- pixel bitmap for cmsy100 char#94 \wedge --- */
      {  94, 1293,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0c\xc3\x30\x92\x24\x85\x21" }  },
      /* --- pixel bitmap for cmsy100 char#95 \vee --- */
      {  95, 1328,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x61\x28\x49\x12\xc3\x30\x0c" }  },
      /* --- pixel bitmap for cmsy100 char#96 \vdash --- */
      {  96, 3520,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x21\x84\xf0\x43\x08\x21\x00" }  },
      /* --- pixel bitmap for cmsy100 char#97 \dashv --- */
      {  97, 3547,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x10\x42\xe8\x21\x84\x10\x02" }  },
      /* --- pixel bitmap for cmsy100 char#98 \lfloor --- */
      {  98, 3574,                      /* character number, location */
         10, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x49\x92\x24\x49\x72" }  },
      /* --- pixel bitmap for cmsy100 char#99 \rfloor --- */
      {  99, 3607,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x24\x49\x92\x24\x79" }  },
      /* --- pixel bitmap for cmsy100 char#100 \lceil --- */
      { 100, 3640,                      /* character number, location */
         10, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x4f\x92\x24\x49\x12" }  },
      /* --- pixel bitmap for cmsy100 char#101 \rceil --- */
      { 101, 3673,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x27\x49\x92\x24\x49" }  },
      /* --- pixel bitmap for cmsy100 char#102 \{ --- */
      { 102, 1843,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x82\x20\x08\x72\x20\x08\x82\x20\x30" }  },
      /* --- pixel bitmap for cmsy100 char#103 \} --- */
      { 103, 1876,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x07\x82\x20\x08\x02\x23\x08\x82\x20\x07" }  },
      /* --- pixel bitmap for cmsy100 char#104 \langle --- */
      { 104, 3706,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xa4\xa4\x24\x92\x48" }  },
      /* --- pixel bitmap for cmsy100 char#105 \rangle --- */
      { 105, 3739,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x89\x24\x92\x92\x12" }  },
      /* --- pixel bitmap for cmsy100 char#106 \mid --- */
      { 106, 1778,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  1,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x1f" }  },
      /* --- pixel bitmap for cmsy100 char#107 \parallel --- */
      { 107, 3772,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x61\x18\x86\x61\x18\x86\x61\x18\x86\x21" }  },
      /* --- pixel bitmap for cmsy100 char#108 \updownarrow --- */
      { 108, 3831,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\xb8\x4a\x08\x21\xa4\x3a\x42\x00" }  },
      /* --- pixel bitmap for cmsy100 char#109 \Updownarrow --- */
      { 109, 3872,                      /* character number, location */
          9, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x18\x24\xc3\x42\x42\x42\x42\x42\xc3\x24\x18" }  },
      /* --- pixel bitmap for cmsy100 char#110 \setminus --- */
      { 110, 1745,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\x21\x22\x42\x44\x88\x08" }  },
      /* --- pixel bitmap for cmsy100 char#111 \wr --- */
      { 111, 3919,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  1,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x01" }  },
      /* --- pixel bitmap for cmsy100 char#112 \surd --- */
      { 112, 3944,                      /* character number, location */
          1, 0,   -13, 0,     /* topleft row,col, and botleft row,col */
          { 12,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x08\x40\x00\x04\x20\x00\x02\x10\x00\x21\x08\x87"
            "\x40\x04\x48\x80\x02\x28\x00\x01" }  },
      /* --- pixel bitmap for cmsy100 char#113 \amalg --- */
      { 113, 3991,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x63\x91\x48\x24\x12\x89\x44\x7f" }  },
      /* --- pixel bitmap for cmsy100 char#114 \nabla --- */
      { 114, 4032,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xff\x03\x0a\x12\x44\x84\x08\x0a\x14\x10\x00" }  },
      /* --- pixel bitmap for cmsy100 char#115 \int --- */
      { 115, 1952,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x44\x44\x44\x44\x34\x01" }  },
      /* --- pixel bitmap for cmsy100 char#116 \sqcup --- */
      { 116, 4071,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x61\x18\x86\x61\x18\x86\x3f" }  },
      /* --- pixel bitmap for cmsy100 char#117 \sqcap --- */
      { 117, 4112,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x7f\x18\x86\x61\x18\x86\x21" }  },
      /* --- pixel bitmap for cmsy100 char#118 \sqsubseteq --- */
      { 118, 4153,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x03\x04\x08\x10\x20\x40\x80\x00\xff\x01\x00\x00"
            "\xf0\x0f" }  },
      /* --- pixel bitmap for cmsy100 char#119 \sqsupseteq --- */
      { 119, 4182,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  9,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x01\x02\x04\x08\x10\x20\x40\x80\xfe\x01\x00\x00"
            "\xe0\x1f" }  },
      /* --- pixel bitmap for cmsy100 char#120 \S --- */
      { 120, 4211,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x6a\xa2\xb6\x22\x2b" }  },
      /* --- pixel bitmap for cmsy100 char#121 \dag --- */
      { 121, 4254,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x92\x74\x49\x92\x24" }  },
      /* --- pixel bitmap for cmsy100 char#122 \ddag --- */
      { 122, 4287,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  3,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xd2\x25\x41\xf2\x25" }  },
      /* --- pixel bitmap for cmsy100 char#123 \P --- */
      { 123, 4320,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xfe\x75\x5d\xd7\x65\x51\x14\x45\x51\x14" }  },
      /* --- pixel bitmap for cmsy100 char#124 \clubsuit --- */
      { 124, 4377,                      /* character number, location */
         10, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x70\xc0\x07\x3e\xf0\x01\x07\xff\xfd\xff\xff\xaf\x37"
            "\x19\x08\x40\x00" }  },
      /* --- pixel bitmap for cmsy100 char#125 \Diamond --- */
      { 125, 4416,                      /* character number, location */
         10, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x50\xa0\x20\x22\x48\xb0\x20\x41\x44\x50\xa0\x80"
            "\x00" }  },
      /* --- pixel bitmap for cmsy100 char#126 \Heart --- */
      { 126, 4467,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xee\x22\x46\x0c\x18\x50\x10\x11\x14\x10\x20\x00" }  },
      /* --- pixel bitmap for cmsy100 char#127 \spadesuit --- */
      { 127, 4514,                      /* character number, location */
         10, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  9,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x20\xe0\xe0\xe3\xef\xff\xff\xff\xd7\x25\x41\x80"
            "\x00" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=2 ---
 * mf '\mode=lview; input cmsy10'      gives .gf118
 * ------------------------------------------------ */
/* --- fontdef for cmsy118 --- */
static	chardef  cmsy118[] =
   {
      /* --- pixel bitmap for cmsy118 char#0 - --- */
      {   0, 1179,                      /* character number, location */
          4, 1,     3, 1,     /* topleft row,col, and botleft row,col */
          { 10,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x03" }  },
      /* --- pixel bitmap for cmsy118 char#1 \cdot --- */
      {   1, 1969,                      /* character number, location */
          4, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#2 \times --- */
      {   2, 2173,                      /* character number, location */
          8, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x42\x24\x18\x08\x18\x24\x42\x81" }  },
      /* --- pixel bitmap for cmsy118 char#3 \ast --- */
      {   3, 2210,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  5,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x7c\xf2\x09\x01" }  },
      /* --- pixel bitmap for cmsy118 char#4 \div --- */
      {   4, 2231,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x30\xc0\x00\x00\x00\xff\x03\x00\x00\x0c\x30\x00" }  },
      /* --- pixel bitmap for cmsy118 char#5 \diamond --- */
      {   5, 1980,                      /* character number, location */
          7, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x8a\x28\x28\xa2\x20\x00" }  },
      /* --- pixel bitmap for cmsy118 char#6 \pm --- */
      {   6, 1188,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x80\x00\x02\x08\x20\xfc\x0f\x02\x08\x20\x80\xf0"
            "\x3f" }  },
      /* --- pixel bitmap for cmsy118 char#7 \mp --- */
      {   7, 2252,                      /* character number, location */
          8, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x83\x00\x02\x08\x20\xfc\x0f\x02\x08\x20\x80\x00"
            "\x02" }  },
      /* --- pixel bitmap for cmsy118 char#8 \oplus --- */
      {   8, 1217,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x90\x22\x52\x88\x21\xfe\x1f\x62\x88\x22\x91\x82"
            "\x07" }  },
      /* --- pixel bitmap for cmsy118 char#9 \ominus --- */
      {   9, 2281,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x10\x22\x50\x80\x01\xfe\x1f\x60\x80\x02\x11\x82"
            "\x07" }  },
      /* --- pixel bitmap for cmsy118 char#10 \otimes --- */
      {  10, 1278,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x10\x62\x58\x92\x31\x46\x18\x63\x92\x86\x11\x82"
            "\x07" }  },
      /* --- pixel bitmap for cmsy118 char#11 \oslash --- */
      {  11, 2326,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x10\x22\x58\x90\x21\x46\x18\x61\x82\x06\x11\x82"
            "\x07" }  },
      /* --- pixel bitmap for cmsy118 char#12 \odot --- */
      {  12, 2383,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x78\x10\x22\x50\x80\x31\xc6\x18\x63\x80\x02\x11\x82"
            "\x07" }  },
      /* --- pixel bitmap for cmsy118 char#13 \bigcirc --- */
      {  13, 2436,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x00\x63\x10\x10\x01\x24\x80\x02\x60\x00\x0c\x80"
            "\x02\x48\x00\x11\x10\x8c\x01\x0e\x00" }  },
      /* --- pixel bitmap for cmsy118 char#14 \circ --- */
      {  14, 2491,                      /* character number, location */
          7, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x2e\xc6\xe8\x00" }  },
      /* --- pixel bitmap for cmsy118 char#15 \bullet --- */
      {  15, 2514,                      /* character number, location */
          7, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  5,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xee\xff\xef\x00" }  },
      /* --- pixel bitmap for cmsy118 char#16 \asymp --- */
      {  16, 2531,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x01\x1a\x86\x07\x00\x00\x00\x80\x87\x61\x01\x02" }  },
      /* --- pixel bitmap for cmsy118 char#17 \equiv --- */
      {  17, 1878,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,     9, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xff\x03\x00\x00\x00\xff\x03\x00\x00\x00\xff\x03" }  },
      /* --- pixel bitmap for cmsy118 char#18 \subseteq --- */
      {  18, 2560,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x13\x20\x40\x00\x01\x04\x10\x80\x00\x04\xe0\x0f"
            "\x00\x00\x00\xfc\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#19 \supseteq --- */
      {  19, 2591,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7f\x00\x02\x10\x80\x00\x02\x08\x20\x40\x80\xfc\x01"
            "\x00\x00\x00\xfc\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#20 \leq --- */
      {  20, 1816,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x06\x06\x06\x06\x0c\xc0\x00\x0c\xc0\x00\x0c"
            "\x00\x00\x00\xfc\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#21 \geq --- */
      {  21, 1847,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x18\x80\x01\x18\x80\x01\x0c\x0c\x0c\x0c\x0c\x00"
            "\x00\x00\x00\xfc\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#22 \preceq --- */
      {  22, 2622,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x08\x10\x20\x70\x7c\x00\x0e\x40\x00\x02\x08"
            "\x00\x00\x00\xfc\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#23 \succeq --- */
      {  23, 2653,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 10,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x04\x20\x00\x01\x38\x80\xcf\x81\x00\x01\x04\x00"
            "\x00\x00\x00\xfc\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#24 \sim --- */
      {  24, 2684,                      /* character number, location */
          6, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 10,     4, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e\x46\x18\x62\x70" }  },
      /* --- pixel bitmap for cmsy118 char#25 \approx --- */
      {  25, 2711,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e\x46\x18\x56\x20\x0e\xc6\x18\x1c" }  },
      /* --- pixel bitmap for cmsy118 char#26 \subset --- */
      {  26, 1644,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x13\x20\x40\x00\x01\x04\x10\x40\x00\x02\x10\x80"
            "\x3f" }  },
      /* --- pixel bitmap for cmsy118 char#27 \supset --- */
      {  27, 1673,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x7f\x00\x02\x10\x80\x00\x02\x08\x20\x80\x00\x01\xf2"
            "\x07" }  },
      /* --- pixel bitmap for cmsy118 char#28 \ll --- */
      {  28, 2752,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x10\x08\x81\x10\x08\xc1\x18\x84\x40\x08\x10\x02"
            "\x8c\x01\x42\x80\x10\x20\x04\x08\x01" }  },
      /* --- pixel bitmap for cmsy118 char#29 \gg --- */
      {  29, 2811,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x21\x40\x08\x10\x02\x84\x00\x63\x80\x10\x20\x04\x42"
            "\x30\x06\x21\x10\x02\x21\x10\x02\x00" }  },
      /* --- pixel bitmap for cmsy118 char#30 \prec --- */
      {  30, 2870,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x00\x02\x08\x10\x20\x70\x7c\x00\x0e\x40\x00\x02\x08" }  },
      /* --- pixel bitmap for cmsy118 char#31 \succ --- */
      {  31, 2897,                      /* character number, location */
          8, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x01\x04\x20\x00\x01\x38\x80\xcf\x81\x00\x01\x04\x00" }  },
      /* --- pixel bitmap for cmsy118 char#32 \leftarrow --- */
      {  32, 1569,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     7, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x08\x80\x00\x18\x80\xff\x6f\x00\x08\x00\x02\x00" }  },
      /* --- pixel bitmap for cmsy118 char#33 \rightarrow --- */
      {  33, 1590,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     7, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x00\x02\x80\x00\xb0\xff\x0f\xc0\x00\x08\x80\x00" }  },
      /* --- pixel bitmap for cmsy118 char#34 \uparrow --- */
      {  34, 1532,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x08\x04\x67\x8d\x40\x20\x10\x08\x04\x02\x81\x00" }  },
      /* --- pixel bitmap for cmsy118 char#35 \downarrow --- */
      {  35, 1495,                      /* character number, location */
         10, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          {  7,    13, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x08\x04\x02\x81\x40\x20\x10\x88\x35\x07\x81\x00" }  },
      /* --- pixel bitmap for cmsy118 char#36 \leftrightarrow --- */
      {  36, 1611,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     7, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x08\x82\x80\x18\xb0\xff\x6f\xc0\x08\x08\x82\x00" }  },
      /* --- pixel bitmap for cmsy118 char#37 \nearrow --- */
      {  37, 2924,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 14,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x80\x07\x80\x01\x50\x00\x12\x60\x08\x0c\x80"
            "\x01\x30\x00\x06\x40\x00\x08\x00\x01\x00" }  },
      /* --- pixel bitmap for cmsy118 char#38 \searrow --- */
      {  38, 2963,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 14,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x80\x00\x40\x00\x60\x00\x30\x00\x18\x00\x0c\x00"
            "\x86\x00\x12\x00\x05\x80\x01\x78\x00\x01" }  },
      /* --- pixel bitmap for cmsy118 char#39 \simeq --- */
      {  39, 3002,                      /* character number, location */
          7, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e\x46\x18\x62\x70\x00\x00\x00\xc0\xff" }  },
      /* --- pixel bitmap for cmsy118 char#40 \Leftarrow --- */
      {  40, 3033,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 13,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x10\x00\x02\xe0\x7f\x03\x20\x00\x08\x00\xfe\x87\x00"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmsy118 char#41 \Rightarrow --- */
      {  41, 3058,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 12,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x10\xff\x03\xc0\x00\x08\x40\xff\x03\x10\x00"
            "\x01" }  },
      /* --- pixel bitmap for cmsy118 char#42 \Uparrow --- */
      {  42, 3083,                      /* character number, location */
          9, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x18\x24\x42\xc3\x42\x42\x42\x42\x42\x42\x42\x42" }  },
      /* --- pixel bitmap for cmsy118 char#43 \Downarrow --- */
      {  43, 3136,                      /* character number, location */
         10, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,    12, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x42\x42\x42\x42\x42\x42\x42\x42\xc3\x42\x24\x18" }  },
      /* --- pixel bitmap for cmsy118 char#44 \Leftrightarrow --- */
      {  44, 3189,                      /* character number, location */
          8, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x88\x20\x88\xff\x02\x18\x40\x01\xf1\x87\x20\x88\x00" }  },
      /* --- pixel bitmap for cmsy118 char#45 \nwarrow --- */
      {  45, 3228,                      /* character number, location */
         11, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          { 14,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x80\x07\x60\x00\x28\x00\x12\x40\x18\x00\x0c\x00"
            "\x06\x00\x03\x80\x01\x80\x00\x40\x00\x20" }  },
      /* --- pixel bitmap for cmsy118 char#46 \swarrow --- */
      {  46, 3267,                      /* character number, location */
          9, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 14,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x20\x00\x04\x80\x00\x18\x00\x03\x60\x00\x0c\x84"
            "\x01\x12\x80\x02\x60\x00\x78\x00\x20\x00" }  },
      /* --- pixel bitmap for cmsy118 char#47 \propto --- */
      {  47, 3306,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0e\x4b\x12\x46\x18\x61\x48\xe2\x30" }  },
      /* --- pixel bitmap for cmsy118 char#48 \prime --- */
      {  48, 3345,                      /* character number, location */
          8, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  3,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xb6\xb5\x25" }  },
      /* --- pixel bitmap for cmsy118 char#49 \infty --- */
      {  49, 2085,                      /* character number, location */
          7, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,     7, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x0c\x47\x32\x85\xc2\x20\x18\x0a\x65\x12\x87\x01" }  },
      /* --- pixel bitmap for cmsy118 char#50 \in --- */
      {  50, 1702,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\xf8\x04\x02\x01\x01\xff\x01\x01\x02\x04\xf8" }  },
      /* --- pixel bitmap for cmsy118 char#51 \ni --- */
      {  51, 3368,                      /* character number, location */
          9, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          {  8,    11, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x1f\x20\x40\x80\x80\xff\x80\x80\x40\x20\x1f" }  },
      /* --- pixel bitmap for cmsy118 char#52 \triangle --- */
      {  52, 3397,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x00\x14\x80\x02\x88\x80\x20\x10\x04\x01\x11\x40"
            "\x02\xe8\xff\x03" }  },
      /* --- pixel bitmap for cmsy118 char#53 \bigtriangledown --- */
      {  53, 3440,                      /* character number, location */
          7, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 13,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x5f\x00\x09\x20\x02\x82\x20\x10\x04\x44\x00\x05"
            "\xa0\x00\x08\x00" }  },
      /* --- pixel bitmap for cmsy118 char#54 / --- */
      {  54, 3483,                      /* character number, location */
         10, 2,    -3, 2,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x80\x40\x40\x20\x20\x10\x08\x08\x04\x04\x02\x02\x01" }  },
      /* --- pixel bitmap for cmsy118 char#55 ' --- */
      {  55, 3516,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  1,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f" }  },
      /* --- pixel bitmap for cmsy118 char#56 \forall --- */
      {  56, 1731,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x01\x03\xfa\x13\x44\x84\x08\x0a\x14\x10\x20\x00" }  },
      /* --- pixel bitmap for cmsy118 char#57 \exists --- */
      {  57, 1772,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3f\x08\x82\x3e\x08\x82\xe0\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#58 \neg --- */
      {  58, 1799,                      /* character number, location */
          6, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  8,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x80\x80\x80\x80" }  },
      /* --- pixel bitmap for cmsy118 char#59 \emptyset --- */
      {  59, 3533,                      /* character number, location */
         11, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  5,    12, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xc8\xa1\x5a\x6b\xad\x55\x38\x01" }  },
      /* --- pixel bitmap for cmsy118 char#60 \Re --- */
      {  60, 3588,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xe6\xe4\x14\x91\xc4\xf2\x4d\x01\x05\x14\x49\x1c\x0e" }  },
      /* --- pixel bitmap for cmsy118 char#61 \Im --- */
      {  61, 3645,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x0a\x1c\x40\xc0\x03\x3b\x04\xc8\x20\x8c\xc0\x01" }  },
      /* --- pixel bitmap for cmsy118 char#62 \top --- */
      {  62, 3686,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x07\x01\x08\x40\x00\x02\x10\x80\x00\x04\x20\x00"
            "\x01" }  },
      /* --- pixel bitmap for cmsy118 char#63 \bot --- */
      {  63, 3713,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x01\x08\x40\x00\x02\x10\x80\x00\x04\x20\xf8"
            "\x3f" }  },
      /* --- pixel bitmap for cmsy118 char#64 \aleph --- */
      {  64, 3740,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x21\xb1\xd8\x94\x4a\xc5\x44\xa2\x21" }  },
      /* --- pixel bitmap for cmsy118 char#65 \calA --- */
      {  65,   35,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x0c\x50\x80\x02\x12\x90\xc0\x0f\x21\x09\x3a"
            "\x30" }  },
      /* --- pixel bitmap for cmsy118 char#66 \calB --- */
      {  66,   78,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xec\x28\x32\x64\x46\x8f\xa0\x40\x81\x82\xfa\x00" }  },
      /* --- pixel bitmap for cmsy118 char#67 \calC --- */
      {  67,  127,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  8,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xf0\x8c\x82\x02\x01\x01\x01\x01\x42\x3c" }  },
      /* --- pixel bitmap for cmsy118 char#68 \calD --- */
      {  68,  160,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\x23\x41\x11\x08\x81\x10\x08\x81\x08\x84\x20\x88"
            "\xc1\x07" }  },
      /* --- pixel bitmap for cmsy118 char#69 \calE --- */
      {  69,  207,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x78\xa2\x40\xc0\x31\x04\x02\x21\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#70 \calF --- */
      {  70,  238,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x8f\x04\x44\x00\x04\x40\x00\x3e\x20\x00\x01\x10"
            "\xe0\x00" }  },
      /* --- pixel bitmap for cmsy118 char#71 \calG --- */
      {  71,  269,                      /* character number, location */
         10, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf0\x18\x0a\x12\x10\x20\x50\x20\x71\x5c\x40\x7c\x00" }  },
      /* --- pixel bitmap for cmsy118 char#72 \calH --- */
      {  72,  310,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x3c\x28\x82\x21\x04\x42\x10\x84\x7f\x10\x82\x20\x08"
            "\x82\xe0" }  },
      /* --- pixel bitmap for cmsy118 char#73 \calI --- */
      {  73,  359,                      /* character number, location */
         10,-1,     0,-1,     /* topleft row,col, and botleft row,col */
          { 10,    10, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x0b\x01\x04\x08\x20\x80\x00\x01\x04\x08\xfd\x03" }  },
      /* --- pixel bitmap for cmsy118 char#74 \calJ --- */
      {  74,  390,                      /* character number, location */
         10, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x80\x1f\x8c\x40\x08\x88\x00\x10\x00\x02\x20\x00\x04"
            "\x80\x20\x08\xf8\x00" }  },
      /* --- pixel bitmap for cmsy118 char#75 \calK --- */
      {  75,  427,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0c\x47\x26\x09\x38\xc0\x00\x06\x48\x40\x02\x22\x0a"
            "\x0e" }  },
      /* --- pixel bitmap for cmsy118 char#76 \calL --- */
      {  76,  472,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xc0\x61\x42\x40\x80\x00\x01\x01\x02\x1e\xe3\x01" }  },
      /* --- pixel bitmap for cmsy118 char#77 \calM --- */
      {  77,  505,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 17,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x41\x00\xc1\x00\x83\x02\x05\x05\x09\x0a\x09"
            "\x22\x11\x44\x22\x04\x43\x06\x80\x01" }  },
      /* --- pixel bitmap for cmsy118 char#78 \calN --- */
      {  78,  574,                      /* character number, location */
         11, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 14,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x30\x04\x02\x81\xc0\x10\x30\x04\x0a\x81\x24\x20"
            "\x09\x84\x02\x61\x30\x10\x00" }  },
      /* --- pixel bitmap for cmsy118 char#79 \calO --- */
      {  79,  631,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xd0\x61\x91\x04\x05\x18\xc0\x00\x06\x28\x20\xc2\xe0"
            "\x01" }  },
      /* --- pixel bitmap for cmsy118 char#80 \calP --- */
      {  80,  680,                      /* character number, location */
         10, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\x91\x70\x04\x21\x08\x21\x88\xa0\x03\x01\x08\x20"
            "\x00\x01\x00" }  },
      /* --- pixel bitmap for cmsy118 char#81 \calQ --- */
      {  81,  725,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x20\x44\xa0\x80\x01\x06\x18\x50\x2c\x6e\x78\x00"
            "\x1f" }  },
      /* --- pixel bitmap for cmsy118 char#82 \calR --- */
      {  82,  772,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 12,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfc\x23\x41\x11\x04\x41\x10\x03\x0d\x88\x80\x08\x08"
            "\x49\x60" }  },
      /* --- pixel bitmap for cmsy118 char#83 \calS --- */
      {  83,  823,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\xf0\x10\x12\x20\x80\x03\xc8\xa0\x40\x41\x7c\x00" }  },
      /* --- pixel bitmap for cmsy118 char#84 \calT --- */
      {  84,  858,                      /* character number, location */
         10, 0,    -1, 0,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xfe\x0f\x41\x08\x20\x00\x01\x08\x40\x00\x01\x08\x40"
            "\x00\x01\x00" }  },
      /* --- pixel bitmap for cmsy118 char#85 \calU --- */
      {  85,  891,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x0e\x44\x10\x82\x08\x42\x18\xc1\x04\x23\x14\x91\x70"
            "\x0c" }  },
      /* --- pixel bitmap for cmsy118 char#86 \calV --- */
      {  86,  942,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          {  9,    10, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x83\x08\x12\x24\x48\x88\x08\x09\x12\x1c\x08\x00" }  },
      /* --- pixel bitmap for cmsy118 char#87 \calW --- */
      {  87,  985,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 15,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x03\x21\xc2\x20\x61\x90\x48\x48\x24\x22\x11\x51\x48"
            "\x18\x14\x0a\x06\x03\x03" }  },
      /* --- pixel bitmap for cmsy118 char#88 \calX --- */
      {  88, 1058,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x30\x04\x21\x88\x80\x03\x04\x38\x30\x41\x08\x41\x18"
            "\x0c" }  },
      /* --- pixel bitmap for cmsy118 char#89 \calY --- */
      {  89, 1099,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x06\x21\x88\x20\x84\x10\x41\x02\x09\x14\x30\x64\x70"
            "\x00" }  },
      /* --- pixel bitmap for cmsy118 char#90 \calZ --- */
      {  90, 1146,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x47\x10\x40\x00\x01\x0f\x10\x40\x80\x21\x02\xf9"
            "\x07" }  },
      /* --- pixel bitmap for cmsy118 char#91 \cup --- */
      {  91, 1339,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x81\x81\x81\x81\x81\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmsy118 char#92 \cap --- */
      {  92, 1380,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x3c\x42\x81\x81\x81\x81\x81\x81\x81" }  },
      /* --- pixel bitmap for cmsy118 char#93 \uplus --- */
      {  93, 3791,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x81\x91\x91\xbd\x91\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmsy118 char#94 \wedge --- */
      {  94, 1421,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x18\x18\x18\x24\x24\x42\x42\x81\x81" }  },
      /* --- pixel bitmap for cmsy118 char#95 \vee --- */
      {  95, 1458,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x81\x42\x42\x24\x24\x18\x18\x18" }  },
      /* --- pixel bitmap for cmsy118 char#96 \vdash --- */
      {  96, 3840,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x40\x20\xf0\x0f\x04\x02\x81\x00" }  },
      /* --- pixel bitmap for cmsy118 char#97 \dashv --- */
      {  97, 3867,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  7,    10, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x40\x20\x10\xf8\x07\x02\x81\x40\x20" }  },
      /* --- pixel bitmap for cmsy118 char#98 \lfloor --- */
      {  98, 3894,                      /* character number, location */
         11, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\x11\x11\x11\x11\x11\x11\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#99 \rfloor --- */
      {  99, 3931,                      /* character number, location */
         11, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x88\x88\x88\x88\x88\x88\x0f" }  },
      /* --- pixel bitmap for cmsy118 char#100 \lceil --- */
      { 100, 3968,                      /* character number, location */
         11, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1f\x11\x11\x11\x11\x11\x11\x01" }  },
      /* --- pixel bitmap for cmsy118 char#101 \rceil --- */
      { 101, 4005,                      /* character number, location */
         11, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x8f\x88\x88\x88\x88\x88\x88\x08" }  },
      /* --- pixel bitmap for cmsy118 char#102 \{ --- */
      { 102, 2011,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x98\x10\x42\x08\x19\x84\x10\x42\x08\x06" }  },
      /* --- pixel bitmap for cmsy118 char#103 \} --- */
      { 103, 2048,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x83\x10\x42\x08\xc1\x84\x10\x42\xc8\x00" }  },
      /* --- pixel bitmap for cmsy118 char#104 \langle --- */
      { 104, 4042,                      /* character number, location */
         11, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x88\x44\x22\x11\x21\x42\x84\x08" }  },
      /* --- pixel bitmap for cmsy118 char#105 \rangle --- */
      { 105, 4079,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  4,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x11\x22\x44\x88\x48\x24\x12\x01" }  },
      /* --- pixel bitmap for cmsy118 char#106 \mid --- */
      { 106, 1932,                      /* character number, location */
         11, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  1,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x7f" }  },
      /* --- pixel bitmap for cmsy118 char#107 \parallel --- */
      { 107, 4116,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x31\xc6\x18\x63\x8c\x31\xc6\x18\x63\x04" }  },
      /* --- pixel bitmap for cmsy118 char#108 \updownarrow --- */
      { 108, 4183,                      /* character number, location */
         11, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          {  7,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x04\x67\x8d\x40\x20\x10\x08\x04\x62\xcd\x41\x20"
            "\x00" }  },
      /* --- pixel bitmap for cmsy118 char#109 \Updownarrow --- */
      { 109, 4228,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x18\x24\xc3\x42\x42\x42\x42\x42\x42\x42\xc3\x24\x18" }  },
      /* --- pixel bitmap for cmsy118 char#110 \setminus --- */
      { 110, 1895,                      /* character number, location */
         11, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  5,    15, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x21\x08\x21\x04\x21\x04\x21\x84\x20\x04" }  },
      /* --- pixel bitmap for cmsy118 char#111 \wr --- */
      { 111, 4283,                      /* character number, location */
          8, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  2,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xab\x57\x03" }  },
      /* --- pixel bitmap for cmsy118 char#112 \surd --- */
      { 112, 4308,                      /* character number, location */
          1, 1,   -15, 1,     /* topleft row,col, and botleft row,col */
          { 13,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x10\x00\x01\x20\x00\x02\x40\x00\x04\x80\x00\x08"
            "\x02\x41\x10\x10\x02\x22\x40\x04\x50\x00\x0a\x80\x00" }  },
      /* --- pixel bitmap for cmsy118 char#113 \amalg --- */
      { 113, 4361,                      /* character number, location */
         10, 0,     0, 0,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x8f\x27\x08\x41\x08\x42\x10\x82\x10\x84\x20\x04\xf9"
            "\x3f" }  },
      /* --- pixel bitmap for cmsy118 char#114 \nabla --- */
      { 114, 4406,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x1f\xb0\x80\x08\x42\x10\x44\x20\x02\x0a\x50\x00"
            "\x01" }  },
      /* --- pixel bitmap for cmsy118 char#115 \int --- */
      { 115, 2138,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  6,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x30\x0c\x21\x08\x82\x20\x08\x42\x14\x03" }  },
      /* --- pixel bitmap for cmsy118 char#116 \sqcup --- */
      { 116, 4449,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x81\x81\x81\x81\x81\x81\x81\x81\xff" }  },
      /* --- pixel bitmap for cmsy118 char#117 \sqcap --- */
      { 117, 4490,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  8,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x81\x81\x81\x81\x81\x81\x81\x81" }  },
      /* --- pixel bitmap for cmsy118 char#118 \sqsubseteq --- */
      { 118, 4531,                      /* character number, location */
         10, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x0f\x40\x00\x02\x10\x80\x00\x04\x20\x00\x01\xf8"
            "\x1f\x00\x00\x00\x80\xff\x01" }  },
      /* --- pixel bitmap for cmsy118 char#119 \sqsupseteq --- */
      { 119, 4562,                      /* character number, location */
         10, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 11,    14, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x07\x20\x00\x01\x08\x40\x00\x02\x10\x80\x00\xf4"
            "\x3f\x00\x00\x00\x00\xff\x03" }  },
      /* --- pixel bitmap for cmsy118 char#120 \S --- */
      { 120, 4593,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  4,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x96\x19\x96\x99\x86\x99\x06" }  },
      /* --- pixel bitmap for cmsy118 char#121 \dag --- */
      { 121, 4640,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x90\x4f\x08\x21\x84\x10\x42\x00" }  },
      /* --- pixel bitmap for cmsy118 char#122 \ddag --- */
      { 122, 4673,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  5,    13, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x84\x90\x4f\x08\x20\x84\x7c\x42\x00" }  },
      /* --- pixel bitmap for cmsy118 char#123 \P --- */
      { 123, 4706,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          {  8,    13, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xfc\x4e\x4f\x4f\x4f\x4e\x4c\x48\x48\x48\x48\x48\x48" }  },
      /* --- pixel bitmap for cmsy118 char#124 \clubsuit --- */
      { 124, 4763,                      /* character number, location */
         10, 0,    -2, 0,     /* topleft row,col, and botleft row,col */
          { 13,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf0\x01\x7f\xe0\x0f\xfc\x01\x1f\xfc\xdf\xff\xff\xff"
            "\x5f\xdf\xc9\x01\x01\x20\x00" }  },
      /* --- pixel bitmap for cmsy118 char#125 \Diamond --- */
      { 125, 4802,                      /* character number, location */
         10, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x80\x02\x14\x10\x41\x10\x01\x0b\x88\x20\x88\x80"
            "\x02\x14\x40\x00" }  },
      /* --- pixel bitmap for cmsy118 char#126 \Heart --- */
      { 126, 4853,                      /* character number, location */
         10, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x8e\x8b\x62\x08\x03\x18\x40\x01\x11\x04\x11\x50\x00"
            "\x01" }  },
      /* --- pixel bitmap for cmsy118 char#127 \spadesuit --- */
      { 127, 4904,                      /* character number, location */
         10, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    12, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x80\x03\x1c\xf8\xe3\xbf\xff\xff\xff\xff\xaf\x37"
            "\x19\x08\x40\x00" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=3 ---
 * mf '\mode=onetz; mag=magstep(.5); input cmsy10'   gives .gf131
 * -------------------------------------------------------------- */
/* --- fontdef for cmsy131 --- */
static	chardef  cmsy131[] =
   {
      /* --- pixel bitmap for cmsy131 char#0 - --- */
      {   0, 1419,                      /* character number, location */
          5, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          { 11,     1, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xff\x07" }  },
      /* --- pixel bitmap for cmsy131 char#1 \cdot --- */
      {   1, 2347,                      /* character number, location */
          6, 1,     4, 1,     /* topleft row,col, and botleft row,col */
          {  2,     2, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x0f" }  },
      /* --- pixel bitmap for cmsy131 char#2 \times --- */
      {   2, 2583,                      /* character number, location */
          9, 2,     0, 2,     /* topleft row,col, and botleft row,col */
          {  9,     9, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x01\x05\x11\x41\x01\x01\x05\x11\x41\x01\x01" }  },
      /* --- pixel bitmap for cmsy131 char#3 \ast --- */
      {   3, 2624,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          {  6,     8, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\xb2\x7b\xde\x8e\x20" }  },
      /* --- pixel bitmap for cmsy131 char#4 \div --- */
      {   4, 2651,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 10,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x30\xc0\x00\x00\x00\x00\xfc\x0f\x00\x00\x00\xc0\x00"
            "\x03" }  },
      /* --- pixel bitmap for cmsy131 char#5 \diamond --- */
      {   5, 2358,                      /* character number, location */
          8, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  7,     7, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x08\x8a\x28\x28\xa2\x20\x00" }  },
      /* --- pixel bitmap for cmsy131 char#6 \pm --- */
      {   6, 1428,                      /* character number, location */
         12, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x01\x08\x40\x00\x02\x10\xfc\x1f\x04\x20\x00"
            "\x01\x08\x40\xf0\x7f" }  },
      /* --- pixel bitmap for cmsy131 char#7 \mp --- */
      {   7, 2672,                      /* character number, location */
         10, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x07\x01\x08\x40\x00\x02\x10\xfc\x1f\x04\x20\x00"
            "\x01\x08\x40\x00\x02" }  },
      /* --- pixel bitmap for cmsy131 char#8 \oplus --- */
      {   8, 1461,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x20\x89\x88\x44\x14\xc2\x10\xfe\x3f\x84\x21\x14"
            "\x91\x88\x48\x82\x0f" }  },
      /* --- pixel bitmap for cmsy131 char#9 \ominus --- */
      {   9, 2705,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x20\x88\x80\x04\x14\xc0\x00\xfe\x3f\x80\x01\x14"
            "\x90\x80\x08\x82\x0f" }  },
      /* --- pixel bitmap for cmsy131 char#10 \otimes --- */
      {  10, 1534,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x20\x88\xc1\x14\x96\xc8\x28\x86\x30\x8a\x89\x54"
            "\x98\xc1\x08\x82\x0f" }  },
      /* --- pixel bitmap for cmsy131 char#11 \oslash --- */
      {  11, 2758,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x20\x88\xc0\x04\x16\xc8\x20\x86\x30\x82\x09\x54"
            "\x90\x81\x08\x82\x0f" }  },
      /* --- pixel bitmap for cmsy131 char#12 \odot --- */
      {  12, 2825,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 11,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x20\x88\x80\x04\x14\xc0\x38\xc6\x31\x8e\x01\x14"
            "\x90\x80\x08\x82\x0f" }  },
      /* --- pixel bitmap for cmsy131 char#13 \bigcirc --- */
      {  13, 2886,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 15,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xe0\x03\x0c\x06\x01\x44\x00\x24\x00\x0a\x00\x06\x00"
            "\x03\x80\x01\xc0\x00\x60\x00\x30\x00\x28\x00\x12\x00"
            "\x11\x40\x30\x18\xe0\x03" }  },
      /* --- pixel bitmap for cmsy131 char#14 \circ --- */
      {  14, 2957,                      /* character number, location */
          8, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x5e\x18\x86\xa1\x07" }  },
      /* --- pixel bitmap for cmsy131 char#15 \bullet --- */
      {  15, 2984,                      /* character number, location */
          8, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          {  6,     6, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xde\xff\xff\xbf\x07" }  },
      /* --- pixel bitmap for cmsy131 char#16 \asymp --- */
      {  16, 3003,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x01\x34\x18\x3e\x00\x00\x00\x00\xe0\xc3\x60\x01\x04" }  },
      /* --- pixel bitmap for cmsy131 char#17 \equiv --- */
      {  17, 2240,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     9, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xff\x07\x00\x00\x00\xf0\x7f\x00\x00\x00\x00\xff\x07" }  },
      /* --- pixel bitmap for cmsy131 char#18 \subseteq --- */
      {  18, 3032,                      /* character number, location */
         12, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x27\x80\x00\x02\x10\x80\x00\x04\x20\x00\x02\x20"
            "\x00\xfe\x01\x00\x00\x00\xfc\x1f" }  },
      /* --- pixel bitmap for cmsy131 char#19 \supseteq --- */
      {  19, 3065,                      /* character number, location */
         12, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x00\x08\x80\x00\x08\x40\x00\x02\x10\x80\x00\x02"
            "\xc8\x3f\x00\x00\x00\x00\xfc\x1f" }  },
      /* --- pixel bitmap for cmsy131 char#20 \leq --- */
      {  20, 2174,                      /* character number, location */
         12, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x04\x18\x30\x60\xc0\x80\x01\x18\x00\x03\x60\x00"
            "\x0c\x80\x01\x00\x00\x00\xfc\x1f" }  },
      /* --- pixel bitmap for cmsy131 char#21 \geq --- */
      {  21, 2207,                      /* character number, location */
         12, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x30\x00\x06\xc0\x00\x18\x00\x03\x0c\x18\x30\x60"
            "\xc0\x00\x00\x00\x00\x00\xfc\x1f" }  },
      /* --- pixel bitmap for cmsy131 char#22 \preceq --- */
      {  22, 3098,                      /* character number, location */
         12, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x04\x20\x80\x00\x02\x8e\x0f\x80\x03\x20\x00\x02"
            "\x20\x00\x01\x00\x00\x00\xfc\x1f" }  },
      /* --- pixel bitmap for cmsy131 char#23 \succeq --- */
      {  23, 3131,                      /* character number, location */
         12, 1,    -3, 1,     /* topleft row,col, and botleft row,col */
          { 11,    15, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x08\x80\x00\x08\x80\x03\xe0\xe3\x80\x00\x02\x08"
            "\x40\x00\x00\x00\x00\x00\xfc\x1f" }  },
      /* --- pixel bitmap for cmsy131 char#24 \sim --- */
      {  24, 3164,                      /* character number, location */
          7, 1,     2, 1,     /* topleft row,col, and botleft row,col */
          { 11,     5, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\x1e\x9c\x61\x08\xc3\x1c\x3c" }  },
      /* --- pixel bitmap for cmsy131 char#25 \approx --- */
      {  25, 3197,                      /* character number, location */
          9, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    10, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1e\x9c\x61\x98\x83\x07\x00\x00\x78\x70\x86\x61\x0e"
            "\x1e" }  },
      /* --- pixel bitmap for cmsy131 char#26 \subset --- */
      {  26, 1984,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xf8\x27\x80\x00\x02\x10\x80\x00\x04\x20\x00\x02\x20"
            "\x00\xfe\x01" }  },
      /* --- pixel bitmap for cmsy131 char#27 \supset --- */
      {  27, 2013,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x00\x08\x80\x00\x08\x40\x00\x02\x10\x80\x00\x02"
            "\xc8\x3f\x00" }  },
      /* --- pixel bitmap for cmsy131 char#28 \ll --- */
      {  28, 3246,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 15,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x42\xc0\x18\x10\x02\xc6\x80\x10\x30\x06\x84\x00"
            "\x8c\x01\x08\x01\x18\x03\x10\x02\x30\x06\x20\x04" }  },
      /* --- pixel bitmap for cmsy131 char#29 \gg --- */
      {  29, 3305,                      /* character number, location */
         11, 1,    -2, 1,     /* topleft row,col, and botleft row,col */
          { 15,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x21\x00\x63\x00\x42\x00\xc6\x00\x84\x00\x8c\x01\x08"
            "\x01\x63\x40\x08\x18\x03\x42\xc0\x18\x10\x02\x00" }  },
      /* --- pixel bitmap for cmsy131 char#30 \prec --- */
      {  30, 3364,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x04\x20\x80\x00\x02\x8e\x0f\x80\x03\x20\x00\x02"
            "\x20\x00\x01" }  },
      /* --- pixel bitmap for cmsy131 char#31 \succ --- */
      {  31, 3393,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 11,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x08\x80\x00\x08\x80\x03\xe0\xe3\x80\x00\x02\x08"
            "\x40\x00\x00" }  },
      /* --- pixel bitmap for cmsy131 char#32 \leftarrow --- */
      {  32, 1893,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x00\x04\x00\x01\xc0\x00\xf0\xff\x37\x00\x10\x00"
            "\x10\x00\x08\x00" }  },
      /* --- pixel bitmap for cmsy131 char#33 \rightarrow --- */
      {  33, 1918,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x08\x00\x04\x00\x04\x00\xf6\xff\x07\x80\x01\x40"
            "\x00\x10\x00\x08" }  },
      /* --- pixel bitmap for cmsy131 char#34 \uparrow --- */
      {  34, 1848,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x04\xc7\xb7\x46\x20\x10\x08\x04\x02\x81\x40\x20"
            "\x10\x08" }  },
      /* --- pixel bitmap for cmsy131 char#35 \downarrow --- */
      {  35, 1803,                      /* character number, location */
         13, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          {  7,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x04\x02\x81\x40\x20\x10\x08\x04\x02\xb1\xf6\x71"
            "\x10\x08" }  },
      /* --- pixel bitmap for cmsy131 char#36 \leftrightarrow --- */
      {  36, 1943,                      /* character number, location */
          9, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,     9, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x08\x04\x04\x01\xc4\x00\xf6\xff\x37\x80\x11\x40"
            "\x10\x10\x08\x08" }  },
      /* --- pixel bitmap for cmsy131 char#37 \nearrow --- */
      {  37, 3422,                      /* character number, location */
         14, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 16,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x00\x7e\x00\x60\x00\x50\x00\x58\x00\x8c\x00"
            "\x86\x00\x02\x00\x01\x80\x00\x40\x00\x20\x00\x30\x00"
            "\x18\x00\x0c\x00\x04\x00\x02\x00\x01\x00" }  },
      /* --- pixel bitmap for cmsy131 char#38 \searrow --- */
      {  38, 3473,                      /* character number, location */
         13, 1,    -5, 1,     /* topleft row,col, and botleft row,col */
          { 16,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x01\x00\x02\x00\x04\x00\x0c\x00\x18\x00\x30\x00\x20"
            "\x00\x40\x00\x80\x00\x00\x01\x00\x02\x00\x84\x00\x8c"
            "\x00\x48\x00\x50\x00\x60\x00\x7e\x00\x02" }  },
      /* --- pixel bitmap for cmsy131 char#39 \simeq --- */
      {  39, 3524,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 11,     8, 1,        /* width x height, pixsz,  bitmap... */
         (pixbyte *)"\x1e\x9c\x61\x98\x83\x07\x00\x00\x00\xe0\xff" }  },
      /* --- pixel bitmap for cmsy131 char#40 \Leftarrow --- */
      {  40, 3555,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 15,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x20\x00\x10\x00\x04\x00\xff\x6f\x00\x10\x00\x10\x00"
            "\xf0\xff\x10\x00\x10\x00\x08\x00" }  },
      /* --- pixel bitmap for cmsy131 char#41 \Rightarrow --- */
      {  41, 3584,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          { 14,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x02\x80\x00\x40\xfc\x3f\x00\x30\x00\x08\x00\xfd"
            "\x3f\x00\x04\x80\x00\x20\x00" }  },
      /* --- pixel bitmap for cmsy131 char#42 \Uparrow --- */
      {  42, 3613,                      /* character number, location */
         12, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 10,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x30\xc0\x80\x04\x21\x86\x15\x4a\x08\x21\x84\x10\x42"
            "\x08\x21\x84\x10\x42\x08\x21" }  },
      /* --- pixel bitmap for cmsy131 char#43 \Downarrow --- */
      {  43, 3684,                      /* character number, location */
         13, 0,    -3, 0,     /* topleft row,col, and botleft row,col */
          { 10,    16, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x84\x10\x42\x08\x21\x84\x10\x42\x08\x21\x84\x10\x52"
            "\xa8\x61\x84\x20\x01\x03\x0c" }  },
      /* --- pixel bitmap for cmsy131 char#44 \Leftrightarrow --- */
      {  44, 3755,                      /* character number, location */
         10, 2,    -1, 2,     /* topleft row,col, and botleft row,col */
          { 13,    11, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x08\x02\x41\x10\x10\xff\x17\x00\x03\xa0\x00\xe2\x3f"
            "\x04\x04\x41\x20\x08" }  },
      /* --- pixel bitmap for cmsy131 char#45 \nwarrow --- */
      {  45, 3802,                      /* character number, location */
         14, 0,    -4, 0,     /* topleft row,col, and botleft row,col */
          { 16,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x00\x7e\x00\x06\x00\x0a\x00\x12\x00\x31\x00\x21"
            "\x00\x40\x00\x80\x00\x00\x01\x00\x02\x00\x04\x00\x0c"
            "\x00\x18\x00\x30\x00\x20\x00\x40\x00\x80" }  },
      /* --- pixel bitmap for cmsy131 char#46 \swarrow --- */
      {  46, 3853,                      /* character number, location */
         13, 0,    -5, 0,     /* topleft row,col, and botleft row,col */
          { 16,    18, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x80\x00\x40\x00\x20\x00\x30\x00\x18\x00\x0c\x00"
            "\x04\x00\x02\x00\x01\x80\x00\x40\x00\x61\x00\x31\x00"
            "\x1a\x00\x0a\x00\x06\x00\x7e\x00\x40\x00" }  },
      /* --- pixel bitmap for cmsy131 char#47 \propto --- */
      {  47, 3904,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 12,     8, 1,        /* width x height, pixsz,  bitmap... */
     (pixbyte *)"\x1c\x2e\x12\xc1\x10\x0c\xc1\x10\x0c\x22\xc1\xe1" }  },
      /* --- pixel bitmap for cmsy131 char#48 \prime --- */
      {  48, 3947,                      /* character number, location */
         10, 0,     1, 0,     /* topleft row,col, and botleft row,col */
          {  4,     9, 1,        /* width x height, pixsz,  bitmap... */
            (pixbyte *)"\xcc\x64\x26\x32\x01" }  },
      /* --- pixel bitmap for cmsy131 char#49 \infty --- */
      {  49, 2479,                      /* character number, location */
          8, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 15,     8, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x1c\x1c\x11\x51\x50\x30\x10\x18\x08\x0c\x0a\x8a\x88"
            "\x38\x38" }  },
      /* --- pixel bitmap for cmsy131 char#50 \in --- */
      {  50, 2042,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\xf8\x09\x08\x08\x10\xe0\x7f\x80\x00\x02\x08\xe0\x07" }  },
      /* --- pixel bitmap for cmsy131 char#51 \ni --- */
      {  51, 3972,                      /* character number, location */
         10, 1,    -1, 1,     /* topleft row,col, and botleft row,col */
          {  9,    11, 1,        /* width x height, pixsz,  bitmap... */
 (pixbyte *)"\x3f\x80\x00\x02\x08\xf0\x3f\x40\x80\x80\x80\xfc\x00" }  },
      /* --- pixel bitmap for cmsy131 char#52 \triangle --- */
      {  52, 4001,                      /* character number, location */
         13, 1,     0, 1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x40\x00\x14\x80\x02\x88\x00\x11\x10\x04\x82\x20\x20"
            "\x04\x44\x00\x09\xa0\x00\xf8\xff\x01" }  },
      /* --- pixel bitmap for cmsy131 char#53 \bigtriangledown --- */
      {  53, 4056,                      /* character number, location */
          9, 1,    -4, 1,     /* topleft row,col, and botleft row,col */
          { 13,    13, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\xff\x3f\x00\x0a\x20\x01\x44\x40\x08\x08\x82\x40\x10"
            "\x10\x01\x22\x80\x02\x50\x00\x04\x00" }  },
      /* --- pixel bitmap for cmsy131 char#54 / --- */
      {  54, 4111,                      /* character number, location */
         13, 2,    -4, 2,     /* topleft row,col, and botleft row,col */
          {  9,    17, 1,        /* width x height, pixsz,  bitmap... */
       (pixbyte *)"\x00\x01\x01\x02\x02\x04\x04\x08\x08\x10\x20\x20\x40"
            "\x40\x80\x80\x00\x01\x01\x00" }  },
      /* --- pixel bitmap for cmsy131 char#55 ' --- */
      {  55, 4152,                      /* character number, location */
          8, 1,     1, 1,     /* topleft row,col, and botleft row,col */
          {  1,     7, 1,        /* width x height, 