/***************************************************************************

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***************************************************************************
Copyright (C) 2005 by 
Pan Wojtas (Wojtek Sulewski)
wojteksulewski <at> op.pl
gg: 2087202

Przystosowanie do Kadu 0.6 i inne zmiany
Copyright (C) 2007 by
Tomasz 'Dorregaray' Rostanski
rozteck <at> interia.pl
***************************************************************************/

#include <qpainter.h>
#include <qapplication.h>
#include <qsimplerichtext.h>
#include <qspinbox.h>

#include "osd_widget.h"
#include "chat_manager.h"
#include "debug.h"



const int DEFAULT_FRAMES_PER_SECOND = 30;
//const int HINT_MARGIN = 0;
const int DISSOLVE_SIZE_VALUE = 24;


OSDWidget::OSDWidget(QWidget * parent, Notification *notification) : KaduTextBrowser(parent), notification(notification),
	  haveCallbacks(!notification->getCallbacks().isEmpty())
{
	kdebugf();

	notification->acquire();
	
	reparent(parent, WStyle_NoBorder | WStyle_StaysOnTop | WStyle_Tool | WX11BypassWM | WWinOwnDC | WDestructiveClose, QPoint(0,0));
	m_dissolveSize = DISSOLVE_SIZE_VALUE;
	
	setVScrollBarMode(QScrollView::AlwaysOff);
	setHScrollBarMode(QScrollView::AlwaysOff);
	setReadOnly(true);
	setFocusPolicy(NoFocus);
	setFrameStyle(QFrame::Plain);

	callbacksBox = new QHBoxLayout(this, 45);
	const QValueList<QPair<QString, const char *> > callbacks = notification->getCallbacks();
	if (notification->getCallbacks().count())
	{
		callbacksBox->addStretch(10);
		FOREACH(i, callbacks)
		{
			QPushButton *button = new QPushButton((*i).first, this);
			connect(button, SIGNAL(clicked()), notification, (*i).second);
			connect(button, SIGNAL(clicked()), notification, SLOT(clearDefaultCallback()));

			callbacksBox->addWidget(button);
			callbacksBox->addStretch(1);
		}
		callbacksBox->addStretch(9);
	}

	// TODO: zrobic cos z ta lata Joi'a
	/*if (config_file.readBoolEntry("osdhints", "show_emoticons"))
	{
		if ((EmoticonsStyle)config_file.readNumEntry("Chat","EmoticonsStyle") == EMOTS_ANIMATED)
		{
			setStyleSheet(new AnimStyleSheet(this, emoticons->themePath()));
			setTrueTransparency(true);
		}
		else
			setStyleSheet(new StaticStyleSheet(this, emoticons->themePath()));
	}*/

	connect(notification, SIGNAL(closed(Notification *)), this,
			  SLOT(notificationClosed()));
	connect(&m_frameTimer, SIGNAL(timeout()), SLOT(dissolveMask()));
	connect(this, SIGNAL(mouseReleased(QMouseEvent *)), this,
			  SLOT(mouseReleaseEvent(QMouseEvent *)));
}

OSDWidget::OSDWidget(QWidget * parent) : KaduTextBrowser(parent)
{
	kdebugf();

	notification = 0;
	haveCallbacks = false;
	
	reparent(parent, WStyle_NoBorder | WStyle_StaysOnTop | WStyle_Tool | WX11BypassWM | WWinOwnDC | WDestructiveClose, QPoint(0,0));
	m_dissolveSize = DISSOLVE_SIZE_VALUE;
	
	setVScrollBarMode(QScrollView::AlwaysOff);
	setHScrollBarMode(QScrollView::AlwaysOff);
	setReadOnly(true);
	setFocusPolicy(NoFocus);
	setFrameStyle(QFrame::Plain);

	connect(&m_frameTimer, SIGNAL(timeout()), SLOT(dissolveMask()));
	connect(this, SIGNAL(mouseReleased(QMouseEvent *)), this,
			  SLOT(mouseReleaseEvent(QMouseEvent *)));

	kdebugf2();
}

OSDWidget::~OSDWidget()
{
	kdebugf();

	//disconnect(this, SIGNAL(mouseReleased(QMouseEvent *)), this,
	//			  SLOT(mouseReleased(QMouseEvent *)));
	if (notification) {
		disconnect(notification, SIGNAL(closed(Notification *)), this,
				  SLOT(notificationClosed()));
		notification->release();
	}
	
	kdebugf2();
}

void OSDWidget::notificationClosed()
{
	emit closing(this);
}

bool OSDWidget::hasUsers() const
{
	return !notification->userListElements().isEmpty();
}

const UserListElements & OSDWidget::getUsers() const
{
	return notification->userListElements();
}

void OSDWidget::prepare()
{
	kdebugf();
	
	QPalette p(QWidget::palette());
	p.setColor(QPalette::Inactive, QColorGroup::Text, m_data.fg_color);
	p.setColor(QPalette::Inactive, QColorGroup::Link, m_data.fg_color.light());
	QWidget::setPalette(p);
	
// tworzy QSimpleRichText tylko w celu obliczenia szerokoci i wysokoci, jak zajmuje rich text - jak to zrobi inaczej?
	// _ma_ znaczenie, czy jest "QString::null, 0, QMimeSourceFactory::defaultFactory()" - inna szeroko!
	
	kdebugm(KDEBUG_INFO, "m_data.message: %s\n", m_data.message.ascii());
	
	QSimpleRichText m_richText(m_data.message, currentFont(), QString::null, 0, mimeSourceFactory());
	m_richText.setWidth(600);	//ustawia warto wiksz, ni spodziewana - bo inaczej s bdy (z ';'); kto robi sobie dymki > 600px?

	m_width = m_richText.widthUsed();
	m_height = m_richText.height();

// jesli mamy zarejestrowane callback'i to musimy zrobic im miejsce
	if (notification && notification->getCallbacks().count())
		m_height += 20;
	
	if (m_data.message.contains("<table", false))
		m_height -= fontMetrics().height();		//Qt dodaje za duy margines pod tabelk - bd qt #102749
	
	setFixedWidth(m_width);
	setFixedHeight(m_height);
	
// to
	if (m_data.translucency_val == 1)
	{
		background.resize(m_width, m_height);
		background.fill(m_data.bg_color);
		
		background_light.resize(m_width, m_height);
		background_light.fill(m_data.bg_color.light(160));
		
		// border
		drawBorder();
	}
	
// create and set transparency mask
	m_mask.resize(m_width, m_height);
	switch(m_data.maskEffect)
	{
		case Plain:
			plainMask();
			break;
	
		case Dissolve:
			dissolveMask();		// tworzy efekt pojawiania...
			break;
	}

// close the message window after given mS
	if (m_data.duration > 0)
	{
		QTimer::singleShot(m_data.duration, this, SLOT(timeout()));
	}
	
	kdebugf2();
}

void OSDWidget::display()
{
	kdebugf();
	
//ensure we don't dip below the screen
	const QRect screen = QApplication::desktop()->screenGeometry(0);
	if (m_data.x + m_width > screen.width())
		m_data.x = screen.width() - m_width;
	else if (m_data.x < 0)
		m_data.x = 0;

	if (m_data.y + m_height > screen.height())
		m_data.y = screen.height() - m_height;
	else if (m_data.y < 0)
		m_data.y = 0;

	move(m_data.x, m_data.y);

// przezroczysto
	if (m_data.translucency_val != 1)
	{
		background.resize(m_width, m_height);
		background.fill(m_data.bg_color);

		QImage scr(QPixmap::grabWindow(qt_xrootwin(), m_data.x, m_data.y, m_width, m_height).convertToImage());
		background = fade(scr, m_data.translucency_val, m_data.bg_color);
		background_light = fade(scr, m_data.translucency_val, m_data.bg_color.light(160));
		
		// border
		drawBorder();
	}

	mimeSourceFactory()->setPixmap("mime_bg", background);
	
	setText("<qt background=\"mime_bg\" >" +  m_data.message + "</qt>");	// musi by po mime;

	QWidget::show();
kdebugm(KDEBUG_ERROR, "\nm_data.message: [%s]\n", m_data.message.ascii());
	setText("<qt background=\"mime_bg\">" +  m_data.message + "</qt>");	// dwa razy, eby si odwieyo :| musi by po show :|

	emit updated(this);

	kdebugf2();
}

void OSDWidget::drawBorder()
{
	kdebugf();
	
	QPainter p( &background );
	p.setPen(m_data.border_color);
	p.drawRoundRect(0,0,m_width,m_height, 1600 / m_width,1600 / m_height);
	//TODO light?
	
	kdebugf2();
}

void OSDWidget::plainMask()
{
	
	kdebugf();
	QPainter maskPainter(&m_mask);
	
	m_mask.fill(Qt::black);
	
	maskPainter.setBrush(Qt::white);
	maskPainter.setPen(Qt::white);
	maskPainter.drawRoundRect(0, 0, m_width, m_height, 1600 / m_width, 1600 / m_height);
	
	setMask(m_mask);
	
	kdebugf2();
}

void OSDWidget::dissolveMask()
{
	kdebugf();
	
	QPainter maskPainter(&m_mask);

	m_mask.fill(Qt::black);
	
	maskPainter.setBrush(Qt::white);
	maskPainter.setPen(Qt::white);
	maskPainter.drawRoundRect(0, 0, m_width, m_height, 1600 / m_width, 1600 / m_height);

	m_dissolveSize--;
	
	if (m_dissolveSize > 0)
	{
		maskPainter.setRasterOp(Qt::EraseROP);

		int x, y, s;
		const int size = 16;
	
		for (y = 0; y < m_height + size; y += size)
		{
			x = m_width;
			s = m_dissolveSize * x / 128;
			for (; x > -size; x -= size, s -= 2)
			{
				if (s < 0)
					break;

				maskPainter.drawEllipse(x - s / 2, y - s / 2, s, s);
			}
		}
		
		m_frameTimer.start(1000 / DEFAULT_FRAMES_PER_SECOND, true);
	}
	setMask(m_mask);
	
	kdebugf2();
}

void OSDWidget::timeout(bool b)
{
	kdebugf();
	
	QWidget::hide();
	emit timeout(m_data.id, b);
	
	kdebugf2();
}

void OSDWidget::enterEvent(QEvent *)
{
	kdebugf();
	
	QPalette p(QWidget::palette());
	p.setColor(QPalette::Inactive, QColorGroup::Text, m_data.fg_color.dark(350));
	p.setColor(QPalette::Inactive, QColorGroup::Link, m_data.fg_color);
	QWidget::setPalette(p);
	
	mimeSourceFactory()->setPixmap("mime_bg", background_light);
	
	// TODO: zamieni na jaki refresh...
	//msg ma dodatkow spacj - bez tego nie odwiea si.
	QString msg("<qt background=\"mime_bg\" >" +  m_data.message + "</qt>");
	setText(msg);
	
	kdebugf2();
}

void OSDWidget::leaveEvent(QEvent *)
{
	kdebugf();
	
	QPalette p(QWidget::palette());
	p.setColor(QPalette::Inactive, QColorGroup::Text, m_data.fg_color);
	p.setColor(QPalette::Inactive, QColorGroup::Link, m_data.fg_color.light());
	QWidget::setPalette(p);
	
	mimeSourceFactory()->setPixmap("mime_bg", background);
	QString msg("<qt background=\"mime_bg\">" +  m_data.message + "</qt>");
	setText(msg);
	
	kdebugf2();
}

void OSDWidget::mouseReleaseEvent(QMouseEvent *event)
{
	kdebugf();
	
	switch (event->button())
	{
		case Qt::LeftButton:
			emit leftButtonClicked(this);
			break;

		case Qt::RightButton:
			emit rightButtonClicked(this);
			break;

		case Qt::MidButton:
			emit midButtonClicked(this);
			break;

		default:
			break;
	}
	
	kdebugf2();
}

void OSDWidget::acceptNotification()
{
	notification->callbackAccept();
}

void OSDWidget::discardNotification()
{
	if (haveCallbacks) {
		notification->callbackDiscard();
		timeout(true);
	}
	else {
		timeout(false);
	}
}

bool OSDWidget::requireManualClosing()
{
	return haveCallbacks;
}

// eby nie przesuwa zawartoci...
void OSDWidget::contentsWheelEvent(QWheelEvent *e)
{
	kdebugf();
	kdebugf2();
}

// eby nie robio si popupmenu
QPopupMenu *OSDWidget::createPopupMenu(const QPoint &point)
{
	kdebugf();
	
	return NULL;
	
	kdebugf2();
}

//////  OSDPreviewWidget below /////////////////////


#include <qvbuttongroup.h>
#include <qcursor.h>
#include <qcombobox.h>
#include <qcheckbox.h>

OSDPreviewWidget::OSDPreviewWidget(QWidget *parent) : OSDWidget(parent, NULL)
{
	kdebugf();
	
	m_data.duration = 0;
	m_dragging = false;
	
	kdebugf2();
}

void OSDPreviewWidget::doUpdate()
{
	kdebugf();
	
	QWidget::hide();

	//TODO: zastanowic sie nad tym
	QString event = "NewChat";
	setFont(config_file.readFontEntry("osdhints", event + "_font"));
	m_data.bg_color = config_file.readColorEntry("osdhints", event + "_bgcolor");
	m_data.fg_color = config_file.readColorEntry("osdhints", event + "_fgcolor");
	m_data.border_color = config_file.readColorEntry("osdhints", event + "_bordercolor");
	m_data.message = config_file.readEntry("osdhints", event + "_syntax");

	switch(((QComboBox *)MainConfigurationWindow::instance()->widgetById("osdhints/showeffect"))->currentItem())
	{
		case 1:
			m_dissolveSize = DISSOLVE_SIZE_VALUE;
			m_data.maskEffect = Dissolve;
			break;
		default:
			m_data.maskEffect = Plain;
			break;
	}
	
	if (((QCheckBox *)MainConfigurationWindow::instance()->widgetById("osdhints/translucency"))->isChecked())
		m_data.translucency_val =
				((QSpinBox *)MainConfigurationWindow::instance()->widgetById("osdhints/translucency_level"))->value() * 0.01;	// * 0.01, bo w spinie s wartoci w %
	else
		m_data.translucency_val = 1;
	
	if(((QCheckBox *)MainConfigurationWindow::instance()->widgetById("osdhints/show_emoticons"))->isChecked())
	{
		HtmlDocument doc;
		doc.parseHtml(m_data.message);
		doc.convertUrlsToHtml();
		mimeSourceFactory()->addFilePath(emoticons->themePath());
		emoticons->expandEmoticons(doc, m_data.bg_color);
		m_data.message = doc.generateHtml();
	}

	prepare();
	
	const QRect screen = QApplication::desktop()->screenGeometry(0);
	int corner = ((QComboBox *)MainConfigurationWindow::instance()->widgetById("osdhints/corner"))->currentItem();
	QSpinBox *spinx = (QSpinBox *)MainConfigurationWindow::instance()->widgetById("osdhints/posx");
	QSpinBox *spiny = (QSpinBox *)MainConfigurationWindow::instance()->widgetById("osdhints/posy");
	
	m_data.x = spinx->value();
	m_data.y = spiny->value();
	switch(corner)
	{
		case 0:		// Left top
			spinx->setMinValue(0);
			spiny->setMinValue(0);
			spinx->setMaxValue(screen.width() - m_width);
			spiny->setMaxValue(screen.height() - m_height);
			break;
		case 1:		// Left bottom
			m_data.y -= m_height;
			spinx->setMinValue(0);
			spiny->setMinValue(m_height);
			spinx->setMaxValue(screen.width() - m_width);
			spiny->setMaxValue(screen.height());
			break;
		case 2:		// Right top
			m_data.x -= m_width;
			spinx->setMinValue(m_width);
			spiny->setMinValue(0);
			spinx->setMaxValue(screen.width());
			spiny->setMaxValue(screen.height() - m_height);
			break;
		case 3:		// Right bottom
			m_data.x -= m_width;
			m_data.y -= m_height;
			spinx->setMinValue(m_width);
			spiny->setMinValue(m_height);
			spinx->setMaxValue(screen.width());
			spiny->setMaxValue(screen.height());
			break;
	}

	display();
	
	kdebugf2();
}

void OSDPreviewWidget::contentsMousePressEvent(QMouseEvent *e)
{
	kdebugf();
	
	m_dragOffset = e->pos(); //TODO: do ifa

	if(e->button() == LeftButton && !m_dragging)
	{
		m_dragging = true;
//		setCursor(QCursor::sizeAllCursor);
//		grabMouse(QCursor::sizeAllCursor);
	}
	
	kdebugf2();
}

void OSDPreviewWidget::contentsMouseMoveEvent(QMouseEvent *e)
{
	kdebugf();
	
	if(m_dragging)
	{
		const QRect screen = QApplication::desktop()->screenGeometry(0);
			
		QPoint destination = e->globalPos() - m_dragOffset - screen.topLeft();
		// czy nie wyszed za ekran
		int maxX = screen.width() - m_width;
		if(destination.x() < 0)
			destination.rx() = 0;
		if(destination.x() > maxX )
			destination.rx() = maxX;
		int maxY = screen.height() - m_height;
		if(destination.y() < 0)
			destination.ry() = 0;
		if(destination.y() > maxY)
			destination.ry() = maxY;
		
		
		destination += screen.topLeft();
		
		move(destination);
	}
	
	kdebugf2();
}

void OSDPreviewWidget::mouseReleased(QMouseEvent *e)
{
	kdebugf();
	
	switch (e->button())
	{
		case Qt::LeftButton:
			m_dragging = false;

			if(QApplication::desktop()->screenNumber(pos()) != -1)
			{
				// set new data
				
				m_data.x = QWidget::x();
				m_data.y = QWidget::y();
				
				switch (((QComboBox*)
							MainConfigurationWindow::instance()->widgetById("osdhints/corner"))->currentItem())
				{
					case 1:
						emit positionChanged(m_data.x, m_data.y + m_height);
						break;
					case 2:
						
						emit positionChanged(m_data.x + m_width, m_data.y);
						break;
					case 3:
						emit positionChanged(m_data.x + m_width, m_data.y + m_height);
						break;
					default:
						emit positionChanged(m_data.x, m_data.y);
				}
			}
			break;
			
		default:
			break;
	}
	
	kdebugf2();
}

/**

		Code copied from kpixmapeffect.cpp

 **/
 
QImage OSDWidget::fade(QImage img, const float val, const QColor &color)
{
	kdebugf();
	
	if (img.width() == 0 || img.height() == 0)
		return img;
	
	// We don't handle bitmaps
	if (img.depth() == 1)
		return img;
	
	unsigned char tbl[256];
	for (int i=0; i<256; i++)
		tbl[i] = (int) (val * i + 0.5);
	
	int red = color.red();
	int green = color.green();
	int blue = color.blue();
	
	QRgb col;
	int r, g, b, cr, cg, cb;
	
	if (img.depth() <= 8)
	{
		// pseudo color
		for (int i=0; i<img.numColors(); i++)
		{
			col = img.color(i);
			cr = qRed(col); cg = qGreen(col); cb = qBlue(col);
			if (cr > red)
				r = cr - tbl[cr - red];
			else
				r = cr + tbl[red - cr];
			if (cg > green)
				g = cg - tbl[cg - green];
			else
				g = cg + tbl[green - cg];
			if (cb > blue)
				b = cb - tbl[cb - blue];
			else
				b = cb + tbl[blue - cb];
			img.setColor(i, qRgba(r, g, b, qAlpha(col)));
		}
	} else 
	{
	// truecolor
		for (int y=0; y<img.height(); y++)
		{
			QRgb *data = (QRgb *) img.scanLine(y);
			for (int x=0; x<img.width(); x++)
			{
				col = *data;
				cr = qRed(col); cg = qGreen(col); cb = qBlue(col);
				if (cr > red)
					r = cr - tbl[cr - red];
				else
					r = cr + tbl[red - cr];
				if (cg > green)
					g = cg - tbl[cg - green];
				else
					g = cg + tbl[green - cg];
				if (cb > blue)
					b = cb - tbl[cb - blue];
				else
					b = cb + tbl[blue - cb];
				*data++ = qRgba(r, g, b, qAlpha(col));
			}
		}
	}
	
	kdebugf2();
	return img;
}
