#ifndef MESSAGE_BOX_H
#define MESSAGE_BOX_H

#include <qdialog.h>
#include <qmap.h>

class QHBox;
class QLabel;

/**
	Odpowiednik klasy QMessageBox z QT. W zamierzeniu ma
	mie wiksze moliwoci i wygodniejszy interface ni
	orygina.
**/
class MessageBox : public QDialog
{
	Q_OBJECT

	private:
		static QMap<QString,MessageBox*> Boxes;
		QLabel *icon;
		QString message;

		void addButton(QWidget *parent, const QString &caption, const char *slot);

	private slots:
		void okClicked();
		void cancelClicked();
		void yesClicked();
		void noClicked();

	protected:
		void closeEvent(QCloseEvent* e);

	public:
		// komponenty dialogu
		static const int OK;
		static const int CANCEL;
		static const int YES;
		static const int NO;
		//
		MessageBox(const QString& message, int components = 0, bool modal = false, const QString &iconName = QString::null, QWidget *parent = 0);
		~MessageBox();

		//

		/**
			Informuje uytkownika o wykonywanej przez
			program czynnoci. Tworzy dialog zawierajcy
			tylko podany tekst. Nie blokuje wykonywania
			programu. Zamknicie dialogu nastpuje po
			wywoaniu funkcji close z t sam wiadomoci
			przekazan jako argument.
			Wywouje QApplication::processEvents().
		**/
		static void status(const QString& message);

		/**
			Zadaje uytkownikowi pytanie. Tworzy dialog
			z dwoma przyciskami: "Tak" i "Nie". Blokuje
			wykonywanie programu i czeka na reakcj
			uytkownika. Zwraca true jeli wybra "Tak"
			lub false jeli wybra "Nie".
		**/
		static bool ask(const QString& message, const QString& iconName = QString::null, QWidget *parent = 0);

		/**
			Przekazuje uytkownikowi informacj. Tworzy
			dialog z przyciskiem: "OK" zamykajcy okno.
			Nie blokuje wykonywania programu.
		**/
		static void msg(const QString& message, bool modal=false, const QString& iconName = QString::null, QWidget *parent = 0);

		/**
			Zamyka dialog, ktry zosta stworzony za
			pomoc funkcji status z t sam wiadomoci
			przekazan jako argument.
		**/
		static void close(const QString& message);

	signals:
		void okPressed();
		void cancelPressed();
		void yesPressed();
		void noPressed();
};

#endif
