#include <k3dsdk/socket.h>
#include <k3dsdk/system.h>

#include <iostream>

int main(int argc, char* argv[])
{
	if(argc != 3)
	{
		std::cerr << "Usage: " << argv[0] << " [HOST] [RESOURCE]" << std::endl;
		return 1;
	}

	const std::string host = argv[1];
	const std::string resource = argv[2];

	try
	{
		k3d::socket::endpoint connection = k3d::socket::connect(host, 80);
		connection.write("GET " + resource + " HTTP/1.1\r\n");
		connection.write("Host: " + host + "\r\n");
		connection.write("Connection: close\r\n");
		connection.write("User-Agent: K-3D http_get\r\n");
		connection.write("\r\n");

		std::string buffer;
		while(true)
		{
			connection.read(buffer);
			std::cerr << buffer;
		}
	}
	catch(k3d::socket::closed& e)
	{
	}
	catch(std::exception& e)
	{
		std::cerr << e.what() << std::endl;
		return 1;
	}

	return 0;
}

