#!/usr/bin/perl

# Linux script that points out Makefile.win files missing new .cpp 

foreach(`find . -name Makefile.win`)
{
	chomp;
	my $Makefile = $_;

	my $content = LoadFile($Makefile);

	my $path = substr $Makefile, 0, (length $Makefile) - 12;

	my $matches = '';
	foreach(`find $path -name *.cpp -maxdepth 1`)
	{
		chomp;
		my ($file) = ($_ =~ /([\w\.]+)$/);
		$matches .= $file . "\n" if($content !~ $file)
	}

	if($matches ne '')
	{
		print "\nMissing in $Makefile :\n",
			$matches;
	}
}

print "\n";



sub	LoadFile
{
	my $name = shift;

	undef $/;
	open INF, "<$name";
	my $f = <INF>;
	close INF;
	$/ = "\n";

	return $f;
}



