/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.exception;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.DispatcherHelper;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.FileUploadLimitExceededException;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.ExceptionHandler;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.LocalizableError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionHandler
implements ExceptionHandler {
    private static final Log log = Log.getInstance(DefaultExceptionHandler.class);
    private Configuration configuration;
    private Map<Class<? extends Throwable>, HandlerProxy> handlers = new HashMap<Class<? extends Throwable>, HandlerProxy>();

    @Override
    public void handle(Throwable throwable, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block8: {
            try {
                Throwable actual = this.unwrap(throwable);
                HandlerProxy proxy = null;
                for (Class<?> type = actual.getClass(); type != null && proxy == null; type = type.getSuperclass()) {
                    proxy = this.handlers.get(type);
                }
                if (proxy != null) {
                    proxy.handle(actual, request, response);
                    break block8;
                }
                if (throwable instanceof FileUploadLimitExceededException) {
                    Resolution resolution = this.handle((FileUploadLimitExceededException)((Object)throwable), request, response);
                    if (resolution != null) {
                        resolution.execute(request, response);
                    }
                    break block8;
                }
                log.warn(throwable, "Unhandled exception caught by the Stripes default exception handler.");
                throw throwable;
            }
            catch (ServletException se) {
                throw se;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable t) {
                throw new StripesServletException("Unhandled exception in exception handler.", t);
            }
        }
    }

    protected Resolution handle(FileUploadLimitExceededException exception, HttpServletRequest request, HttpServletResponse response) throws FileUploadLimitExceededException {
        ActionBean actionBean;
        ActionBeanContext context;
        StripesRequestWrapper wrapper;
        String path = this.getFileUploadExceededExceptionPath(request);
        if (path == null) {
            throw exception;
        }
        try {
            wrapper = new StripesRequestWrapper(request){

                protected void constructMultipartWrapper(HttpServletRequest request) throws StripesServletException {
                    this.setLocale(DefaultExceptionHandler.this.configuration.getLocalePicker().pickLocale(request));
                }
            };
            context = this.configuration.getActionBeanContextFactory().getContextInstance((HttpServletRequest)wrapper, response);
            actionBean = this.configuration.getActionResolver().getActionBean(context);
            wrapper.setAttribute("actionBean", actionBean);
        }
        catch (ServletException e) {
            log.error(e, new Object[0]);
            throw exception;
        }
        String fieldName = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(actionBean.getClass());
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if (!FileBean.class.isAssignableFrom(pd.getPropertyType())) continue;
                if (fieldName == null) {
                    fieldName = pd.getName();
                    continue;
                }
                fieldName = null;
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DecimalFormat format = new DecimalFormat("0.00");
        double max = (double)exception.getMaximum() / 1024.0;
        double posted = (double)exception.getPosted() / 1024.0;
        LocalizableError error = new LocalizableError("validation.file.postBodyTooBig", format.format(max), format.format(posted));
        if (fieldName == null) {
            context.getValidationErrors().addGlobalError(error);
        } else {
            context.getValidationErrors().add(fieldName, error);
        }
        ExecutionContext exectx = new ExecutionContext();
        exectx.setActionBean(actionBean);
        exectx.setActionBeanContext(context);
        DispatcherHelper.fillInValidationErrors(exectx);
        return new ForwardResolution(path){

            public void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                super.execute((HttpServletRequest)wrapper, response);
            }
        };
    }

    protected String getFileUploadExceededExceptionPath(HttpServletRequest request) {
        URL referer = null;
        try {
            referer = new URL(request.getHeader("referer"));
        }
        catch (Exception e) {
            return null;
        }
        String path = referer.getFile();
        String contextPath = request.getContextPath();
        if (contextPath.length() > 1) {
            if (!path.startsWith(contextPath + "/")) {
                return null;
            }
            path = path.replace(contextPath, "");
        }
        return path;
    }

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        this.addHandler(this);
    }

    protected void addHandler(Class<?> handlerClass) throws Exception {
        this.addHandler(handlerClass.newInstance());
    }

    protected void addHandler(Object handler) throws Exception {
        Method[] methods;
        for (Method method : methods = handler.getClass().getMethods()) {
            Class<?>[] parameters = method.getParameterTypes();
            int mods = method.getModifiers();
            if (!Modifier.isPublic(mods) || Modifier.isAbstract(mods) || parameters.length != 3 || !Throwable.class.isAssignableFrom(parameters[0]) || !HttpServletRequest.class.equals(parameters[1]) || !HttpServletResponse.class.equals(parameters[2]) || handler == this && method.getName().equals("handle") && Throwable.class.equals(parameters[0])) continue;
            Class<?> type = parameters[0];
            HandlerProxy proxy = new HandlerProxy(handler, method);
            HandlerProxy previous = this.handlers.get(type);
            if (previous != null) {
                log.warn("More than one exception handler for exception type ", type, " in ", handler.getClass().getSimpleName(), ". '", method.getName(), "()' will be used instead of '", previous.getHandlerMethod().getName(), "()'.");
            }
            this.handlers.put(type, proxy);
            log.debug("Added exception handler '", handler.getClass().getSimpleName(), ".", method.getName(), "()' for exception type: ", type);
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Throwable unwrap(Throwable throwable) {
        Throwable t;
        if (throwable instanceof ServletException && (t = ((ServletException)throwable).getRootCause()) != null) {
            throwable = t;
        }
        return throwable;
    }

    protected static class HandlerProxy {
        private Object handler;
        private Method handlerMethod;

        public HandlerProxy(Object handler, Method handlerMethod) {
            this.handler = handler;
            this.handlerMethod = handlerMethod;
        }

        public void handle(Throwable t, HttpServletRequest req, HttpServletResponse res) throws Exception {
            Object resolution = this.handlerMethod.invoke(this.handler, t, req, res);
            if (resolution != null && resolution instanceof Resolution) {
                ((Resolution)resolution).execute(req, res);
            }
        }

        Method getHandlerMethod() {
            return this.handlerMethod;
        }
    }
}

