/*
 * Decompiled with CFR 0.152.
 */
package net.iamvegan.multipartrequest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.iamvegan.multipartrequest.EmptyEnumeration;
import net.iamvegan.multipartrequest.IteratorEnumeration;
import net.iamvegan.multipartrequest.MaxContentLengthException;
import net.iamvegan.multipartrequest.MultipartFile;
import net.iamvegan.multipartrequest.ParameterParser;
import net.iamvegan.multipartrequest.ProgressListener;
import net.iamvegan.multipartrequest.ProgressNotifier;

public class HttpServletMultipartRequest
extends HttpServletRequestWrapper {
    public static final int ABORT_ON_MAX_LENGTH = 100;
    public static final int IGNORE_ON_MAX_LENGTH = 101;
    public static final int SAVE_TO_MEMORY = 102;
    public static final int SAVE_TO_TMPDIR = 103;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final long MAX_CONTENT_LENGTH = 0x200000L;
    private static final int READ_LINE_BLOCK = 131072;
    private static Enumeration EMPTY_ENUMERATION = new EmptyEnumeration();
    private ParameterParser m_paramParser = new ParameterParser();
    private boolean m_isMultipart;
    private boolean m_isIgnoreOnMaxLength;
    private File m_tempDirectory;
    private boolean m_isLoadIntoMemory;
    private long m_maxContentLength;
    private String m_strBoundary;
    private long m_contentLength;
    private Map m_htParameters;
    private Map m_htFiles;
    private ProgressNotifier m_progressNotifier;
    private int m_itemCount = 0;
    private long m_intTotalRead;
    private byte[] m_blockOfBytes = null;
    private String m_charEncoding;

    public HttpServletMultipartRequest(HttpServletRequest request) throws IOException {
        this(request, 0x200000L, 103, 100, null, null);
    }

    public HttpServletMultipartRequest(HttpServletRequest request, long maxContentLength, int saveMode, int onMaxLengthMode, String charEncoding, ProgressListener progressListener) throws IOException {
        super(request);
        this.initParser(request, maxContentLength, saveMode, onMaxLengthMode, charEncoding, progressListener);
    }

    public boolean isMultipartRequest() {
        return this.m_isMultipart;
    }

    public boolean isMaxLengthExceeded() {
        return this.m_contentLength > this.m_maxContentLength;
    }

    public File getTempDirectory() {
        return this.m_tempDirectory;
    }

    public boolean isLoadIntoMemory() {
        return this.m_isLoadIntoMemory;
    }

    protected boolean isIgnoreOnMaxLength() {
        return this.m_isIgnoreOnMaxLength;
    }

    protected boolean isAbortOnMaxLength() {
        return !this.m_isIgnoreOnMaxLength;
    }

    public String getParameter(String name) {
        if (this.isMultipartRequest()) {
            Object value = this.m_htParameters.get(name);
            if (value instanceof List) {
                return (String)((List)value).get(0);
            }
            return (String)this.m_htParameters.get(name);
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        if (this.isMultipartRequest()) {
            Object value = this.m_htParameters.get(name);
            if (value instanceof List) {
                List list = (List)value;
                String[] stringArray = new String[list.size()];
                return list.toArray(stringArray);
            }
            return new String[]{(String)value};
        }
        return super.getParameterValues(name);
    }

    public Enumeration getParameterNames() {
        if (this.isMultipartRequest()) {
            return new IteratorEnumeration(this.m_htParameters.keySet().iterator());
        }
        return super.getParameterNames();
    }

    public Map getParameterMap() {
        if (this.isMultipartRequest()) {
            return this.m_htParameters;
        }
        return super.getParameterMap();
    }

    public MultipartFile getFileParameter(String name) {
        if (this.isMultipartRequest()) {
            MultipartFile fileObj = null;
            Object value = this.m_htFiles.get(name);
            if (value instanceof List) {
                fileObj = (MultipartFile)((List)value).get(0);
            } else if (value instanceof MultipartFile) {
                fileObj = (MultipartFile)this.m_htFiles.get(name);
            }
            return fileObj;
        }
        return null;
    }

    public MultipartFile[] getFileParameterValues(String name) {
        if (this.isMultipartRequest()) {
            Object value = this.m_htFiles.get(name);
            if (value instanceof List) {
                List list = (List)value;
                MultipartFile[] multiArray = new MultipartFile[list.size()];
                return list.toArray(multiArray);
            }
            return new MultipartFile[]{(MultipartFile)value};
        }
        return null;
    }

    public Enumeration getFileParameterNames() {
        if (this.isMultipartRequest()) {
            return new IteratorEnumeration(this.m_htFiles.keySet().iterator());
        }
        return null;
    }

    public Map getFileParameterMap() {
        if (this.isMultipartRequest()) {
            return this.m_htFiles;
        }
        return null;
    }

    public String toHtmlString() {
        int i;
        String strName;
        StringBuffer sbReturn = new StringBuffer();
        sbReturn.append("<h2>Parameters</h2>");
        sbReturn.append("\n<table border=\"3\"><tr><td><b>Name</b></td><td><b>Value</b></td></tr>");
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            strName = (String)e.nextElement();
            sbReturn.append("\n<tr><td>" + strName + "</td>");
            sbReturn.append("<td><table border=\"1\"><tr>");
            String[] values = this.getParameterValues(strName);
            i = 0;
            while (i < values.length) {
                String value = values[i];
                sbReturn.append("<td>" + value + "</td>");
                ++i;
            }
            sbReturn.append("</tr></table></td></tr>");
        }
        sbReturn.append("</table>");
        if (this.isMultipartRequest()) {
            sbReturn.append("<h2>File Parameters</h2>");
            Enumeration fileEnumeration = this.getFileParameterNames();
            if (fileEnumeration.hasMoreElements()) {
                sbReturn.append("\n<table border=\"2\"><tr><td><b>Name</b></td><td><b>Filename</b></td><td><b>Content Type</b></td><td><b>Size</b></td></tr>");
                while (fileEnumeration.hasMoreElements()) {
                    strName = (String)fileEnumeration.nextElement();
                    MultipartFile[] multiFiles = this.getFileParameterValues(strName);
                    i = 0;
                    while (i < multiFiles.length) {
                        MultipartFile multiFile = multiFiles[i];
                        sbReturn.append("\n<tr><td>" + strName + "</td>" + "<td>" + (multiFile.getName() != null ? multiFile.getName() : "") + "</td>");
                        sbReturn.append("<td>" + (multiFile.getContentType() != null ? multiFile.getContentType() : "") + "</td>" + "<td>" + (multiFile.getSize() != -1L ? String.valueOf(multiFile.getSize()) : "") + "</td>" + "</tr>");
                        ++i;
                    }
                }
                sbReturn.append("</table>");
            } else {
                sbReturn.append("<p style=\"{color: orange;}\">No valid files uploaded</p>");
                if (this.isMaxLengthExceeded()) {
                    sbReturn.append("<p style=\"{color: red;}\">Max Bytes exceeded (" + this.m_contentLength + " > " + this.m_maxContentLength + ") all file uploads ignored.</p>");
                }
            }
        }
        return sbReturn.toString();
    }

    private void initParser(HttpServletRequest request, long maxContentLength, int saveMode, int onMaxLengthMode, String charEncoding, ProgressListener progressListener) throws IllegalArgumentException, IOException, UnsupportedEncodingException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith(MULTIPART_FORM_DATA) && contentType.indexOf("boundary=") != -1) {
            this.m_isMultipart = true;
            this.m_htParameters = new HashMap();
            this.m_htFiles = new HashMap();
            if (onMaxLengthMode == 101) {
                this.m_isIgnoreOnMaxLength = true;
            } else if (onMaxLengthMode != 100) {
                throw new IllegalArgumentException("Illegal max length mode specified");
            }
            if (saveMode == 102) {
                this.m_isLoadIntoMemory = true;
            } else if (saveMode != 103) {
                throw new IllegalArgumentException("Illegal save mode specified");
            }
            this.m_maxContentLength = maxContentLength;
            if (this.m_maxContentLength == -1L) {
                this.m_maxContentLength = 0x200000L;
            }
            this.m_contentLength = request.getContentLength();
            if (this.isAbortOnMaxLength() && this.isMaxLengthExceeded()) {
                throw new MaxContentLengthException(this.m_contentLength, this.m_maxContentLength);
            }
            if (!this.m_isLoadIntoMemory) {
                String dirValue = System.getProperty("net.iamvegan.multipartrequest.tmpdir");
                if (dirValue == null || dirValue.trim().length() == 0) {
                    dirValue = System.getProperty("java.io.tmpdir");
                }
                if (dirValue != null && dirValue.length() > 0) {
                    this.m_tempDirectory = new File(dirValue);
                    if (!this.m_tempDirectory.isDirectory() || !this.m_tempDirectory.canWrite()) {
                        throw new IOException("Invalid temporary directory specified");
                    }
                }
            }
            if (charEncoding != null && this.validateCharacterEncoding(charEncoding)) {
                this.m_charEncoding = charEncoding;
            }
            if (this.m_charEncoding == null) {
                this.m_charEncoding = DEFAULT_ENCODING;
            }
            if (progressListener != null) {
                this.m_progressNotifier = new ProgressNotifier(progressListener, this.m_contentLength);
            }
            this.m_strBoundary = contentType.substring(contentType.indexOf("boundary=") + "boundary=".length()).trim();
            this.m_blockOfBytes = new byte[131072];
            this.m_intTotalRead = 0L;
            this.parse(new BufferedInputStream((InputStream)request.getInputStream()));
            this.m_blockOfBytes = null;
        }
    }

    private void fireProgressEvent() {
        if (this.m_progressNotifier != null) {
            this.m_progressNotifier.notifyProgress(this.m_intTotalRead, this.m_itemCount);
        }
    }

    private boolean validateCharacterEncoding(String charsetName) throws UnsupportedEncodingException {
        new String(new byte[]{48}, charsetName);
        return true;
    }

    private void parse(InputStream in) throws IOException {
        String strLine = null;
        int read = -1;
        read = this.readLine(in, this.m_blockOfBytes);
        String string = strLine = read > 0 ? new String(this.m_blockOfBytes, 0, read, this.m_charEncoding) : null;
        if (strLine == null || strLine.indexOf(this.m_strBoundary) == -1) {
            throw new IOException("Invalid Form Data, no boundary encountered.");
        }
        while ((read = this.readLine(in, this.m_blockOfBytes)) > 0 && (strLine = new String(this.m_blockOfBytes, 0, read, this.m_charEncoding)) != null && strLine.length() != 0 && strLine.trim().length() != 0) {
            long filesize;
            ++this.m_itemCount;
            Map parameters = this.m_paramParser.parse(strLine, ';');
            String strName = (String)parameters.get("name");
            if (!parameters.containsKey("filename")) {
                this.readLine(in, this.m_blockOfBytes);
                String param = this.readParameter(in);
                this.addParameter(strName, param);
                continue;
            }
            String strFilename = (String)parameters.get("filename");
            if (strFilename == null) {
                read = this.readLine(in, this.m_blockOfBytes);
                String string2 = strLine = read > 0 ? new String(this.m_blockOfBytes, 0, read, this.m_charEncoding) : null;
                if (strLine != null && strLine.toLowerCase().startsWith("content-type:")) {
                    this.readLine(in, this.m_blockOfBytes);
                }
                this.readLine(in, this.m_blockOfBytes);
                this.readLine(in, this.m_blockOfBytes);
                continue;
            }
            this.addParameter(strName, strFilename);
            read = this.readLine(in, this.m_blockOfBytes);
            strLine = read > 0 ? new String(this.m_blockOfBytes, 0, read, this.m_charEncoding) : null;
            String strContentType = "application/octet-stream";
            if (strLine != null && strLine.toLowerCase().startsWith("content-type:")) {
                strContentType = strLine.substring("content-type:".length()).trim();
                this.readLine(in, this.m_blockOfBytes);
            }
            strFilename = HttpServletMultipartRequest.getBasename(strFilename);
            if (this.isLoadIntoMemory()) {
                byte[] contentsOfFile = this.readFile(in);
                filesize = -1L;
                if (contentsOfFile != null) {
                    filesize = contentsOfFile.length;
                }
                if (filesize <= 0L) continue;
                this.addFileParameter(strName, new MultipartFile(strName, strFilename, strContentType, filesize, contentsOfFile));
                continue;
            }
            File outFile = File.createTempFile("multPartReq", null, this.getTempDirectory());
            filesize = this.readAndWriteFile(in, outFile);
            if (filesize <= 0L) continue;
            this.addFileParameter(strName, new MultipartFile(strName, strFilename, strContentType, filesize, outFile));
        }
    }

    private void addParameter(String strName, String value) {
        Object objParms = this.m_htParameters.get(strName);
        if (objParms instanceof List) {
            ((List)objParms).add(value);
        } else if (objParms instanceof String) {
            ArrayList<Object> vecParms = new ArrayList<Object>();
            vecParms.add(objParms);
            vecParms.add(value);
            this.m_htParameters.put(strName, vecParms);
        } else {
            this.m_htParameters.put(strName, value);
        }
    }

    private void addFileParameter(String strName, MultipartFile fileObj) {
        Object objParms = this.m_htFiles.get(strName);
        if (objParms instanceof List) {
            ((List)objParms).add(fileObj);
        } else if (objParms instanceof MultipartFile) {
            ArrayList<Object> vecParms = new ArrayList<Object>();
            vecParms.add(objParms);
            vecParms.add(fileObj);
            this.m_htFiles.put(strName, vecParms);
        } else {
            this.m_htFiles.put(strName, fileObj);
        }
    }

    private String readParameter(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int read = -1;
        String line = null;
        while (true) {
            if ((read = this.readLine(in, this.m_blockOfBytes)) < 0) {
                throw new IOException("Stream ended prematurely.");
            }
            line = new String(this.m_blockOfBytes, 0, read, this.m_charEncoding);
            if (read < this.m_blockOfBytes.length && line.indexOf(this.m_strBoundary) != -1) break;
            buf.append(line);
        }
        if (buf.length() > 0) {
            buf.setLength(HttpServletMultipartRequest.getLengthMinusEnding(buf));
        }
        return buf.toString();
    }

    private long readAndWrite(InputStream in, OutputStream out) throws IOException {
        long fileSize = 0L;
        int read = -1;
        byte[] secondLineOfBytes = new byte[this.m_blockOfBytes.length];
        int sizeOfSecondArray = 0;
        while (true) {
            if ((read = this.readLine(in, this.m_blockOfBytes)) < 0) {
                throw new IOException("Stream ended prematurely.");
            }
            if (read < this.m_blockOfBytes.length && new String(this.m_blockOfBytes, 0, read, this.m_charEncoding).indexOf(this.m_strBoundary) != -1) {
                int actualLength;
                if (sizeOfSecondArray == 0 || (actualLength = HttpServletMultipartRequest.getLengthMinusEnding(secondLineOfBytes, sizeOfSecondArray)) <= 0 || out == null) break;
                out.write(secondLineOfBytes, 0, actualLength);
                fileSize += (long)actualLength;
                break;
            }
            if (sizeOfSecondArray != 0) {
                out.write(secondLineOfBytes, 0, sizeOfSecondArray);
                fileSize += (long)sizeOfSecondArray;
            }
            if (out == null) continue;
            System.arraycopy(this.m_blockOfBytes, 0, secondLineOfBytes, 0, read);
            sizeOfSecondArray = read;
        }
        return fileSize;
    }

    private long readAndWriteFile(InputStream in, File outFile) throws IOException {
        long l;
        block4: {
            BufferedOutputStream out = null;
            try {
                long count;
                if (!this.isMaxLengthExceeded() && outFile != null && outFile.exists() && outFile.canWrite()) {
                    out = new BufferedOutputStream(new FileOutputStream(outFile));
                }
                if ((count = this.readAndWrite(in, out)) == 0L && outFile != null) {
                    outFile.delete();
                }
                l = count;
                Object var6_6 = null;
                if (out == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_7 = null;
                    if (out == null) break block5;
                    out.flush();
                    out.close();
                }
                throw throwable;
            }
            out.flush();
            out.close();
        }
        return l;
    }

    private byte[] readFile(InputStream in) throws IOException {
        long count;
        ByteArrayOutputStream out = null;
        if (!this.isMaxLengthExceeded()) {
            out = new ByteArrayOutputStream();
        }
        if ((count = this.readAndWrite(in, out)) > 0L) {
            if (out != null) {
                return out.toByteArray();
            }
            return null;
        }
        return null;
    }

    private int readLine(InputStream in, byte[] bytesToBeRead) throws IOException {
        int result;
        if (this.m_intTotalRead >= this.m_contentLength) {
            return -1;
        }
        int length = bytesToBeRead.length;
        if ((long)length > this.m_contentLength - this.m_intTotalRead) {
            length = (int)(this.m_contentLength - this.m_intTotalRead);
        }
        if ((result = this.readLine(in, bytesToBeRead, 0, length)) > 0) {
            this.m_intTotalRead += (long)result;
            this.fireProgressEvent();
        }
        return result;
    }

    private static final int getLengthMinusEnding(byte[] byteLine, int endOfArray) {
        if (byteLine == null) {
            return 0;
        }
        if (endOfArray >= 2 && byteLine[endOfArray - 2] == 13 && byteLine[endOfArray - 1] == 10) {
            return endOfArray - 2;
        }
        if (endOfArray >= 1 && byteLine[endOfArray - 1] == 10 || byteLine[endOfArray - 1] == 13) {
            return endOfArray - 1;
        }
        return endOfArray;
    }

    private static final int getLengthMinusEnding(StringBuffer buf) {
        if (buf.length() >= 2 && buf.charAt(buf.length() - 2) == '\r' && buf.charAt(buf.length() - 1) == '\n') {
            return buf.length() - 2;
        }
        if (buf.length() >= 1 && buf.charAt(buf.length() - 1) == '\n' || buf.charAt(buf.length() - 1) == '\r') {
            return buf.length() - 1;
        }
        return buf.length();
    }

    private static final String getBasename(String strFilename) {
        if (strFilename == null) {
            return strFilename;
        }
        int intIndex = strFilename.lastIndexOf("/");
        if (intIndex == -1 || strFilename.lastIndexOf("\\") > intIndex) {
            intIndex = strFilename.lastIndexOf("\\");
        }
        if (intIndex != -1) {
            return strFilename.substring(intIndex + 1);
        }
        return strFilename;
    }

    private int readLine(InputStream in, byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = in.read()) != -1) {
            b[off++] = (byte)c;
            if (c == 10 || ++count == len) break;
        }
        return count > 0 ? count : -1;
    }
}

