/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.htmltowiki;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class WikiParserCallback
extends HTMLEditorKit.ParserCallback {
    private String m_beforeCaretText;
    private String m_afterCaretText;
    private String newWikiSyntax = "";
    private String lastLinkRef = "";
    private String lastLinkText = "";
    private String LiSymbols = "";
    private boolean justMadeLink = false;
    private boolean scriptInProcess = false;
    private boolean titleInProcess = false;
    private boolean headerInList = false;
    private boolean headerJustProcessed = false;
    private int lastHeaderIndex = -1;
    private boolean singleTableInProcess = false;
    private boolean multTableInProcess = false;
    private int numEmbeddedTables = 0;
    private String tableBuffer = "";
    private String cancelTableBuffer = "";
    private boolean isFirstTDTag = false;

    public WikiParserCallback(String before, String after) {
        this.m_beforeCaretText = before;
        this.m_afterCaretText = after;
    }

    public void handleComment(char[] data, int pos) {
    }

    public void handleEndTag(HTML.Tag t, int pos) {
        if (t == HTML.Tag.SCRIPT) {
            this.scriptInProcess = false;
        }
        if (t == HTML.Tag.TITLE) {
            this.titleInProcess = false;
        }
        if (t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.H5 || t == HTML.Tag.H6) {
            if (this.headerInList) {
                this.headerInList = false;
            } else {
                this.endHeaderTag();
                this.addToWiki("\n");
            }
        }
        if (t == HTML.Tag.B || t == HTML.Tag.STRONG) {
            this.addToWiki("__");
        }
        if (t == HTML.Tag.I || t == HTML.Tag.EM) {
            this.addToWiki("''");
        }
        if (t == HTML.Tag.A) {
            if (!this.justMadeLink) {
                this.addToWiki(this.textLink(this.lastLinkRef, this.lastLinkText));
            }
            this.lastLinkRef = "";
            this.lastLinkText = "";
        }
        if ((t == HTML.Tag.UL || t == HTML.Tag.OL) && this.LiSymbols != "") {
            this.LiSymbols = this.LiSymbols.substring(0, this.LiSymbols.length() - 1);
        }
        if (t == HTML.Tag.TABLE) {
            this.addToWikiTable("\n");
            if (this.numEmbeddedTables > 0) {
                --this.numEmbeddedTables;
            }
            if (this.numEmbeddedTables == 0) {
                if (this.multTableInProcess) {
                    this.multTableInProcess = false;
                } else {
                    this.singleTableInProcess = false;
                    this.addToWiki(this.tableBuffer);
                    this.tableBuffer = "";
                    this.cancelTableBuffer = "";
                }
            }
        }
        if (t == HTML.Tag.TR) {
            this.addToWiki("\n");
        }
        if (t == HTML.Tag.HTML && (this.m_afterCaretText.equals("!") || this.m_afterCaretText.equals("*") || this.m_afterCaretText.equals("#"))) {
            this.newWikiSyntax = this.newWikiSyntax + "\n";
        }
    }

    private void addToWiki(String newStuff) {
        if (newStuff.equals("\n")) {
            if (this.headerJustProcessed) {
                return;
            }
        } else {
            this.headerJustProcessed = false;
        }
        if (this.scriptInProcess || this.titleInProcess) {
            return;
        }
        if (newStuff == null) {
            newStuff = "";
        }
        if (this.singleTableInProcess) {
            if (newStuff.endsWith("\\\\") && this.tableBuffer.endsWith("\\\\")) {
                this.tableBuffer = this.tableBuffer + " ";
            }
            this.tableBuffer = this.tableBuffer + newStuff;
            this.cancelTableBuffer = this.addAndCheckLineBreaks(newStuff, this.cancelTableBuffer);
        } else {
            this.newWikiSyntax = this.addAndCheckLineBreaks(newStuff, this.newWikiSyntax);
        }
    }

    private void addToWikiTable(String tableStuff) {
        if (this.multTableInProcess || this.scriptInProcess || this.titleInProcess) {
            return;
        }
        if (tableStuff == null) {
            tableStuff = "";
        }
        if (this.singleTableInProcess) {
            this.tableBuffer = this.tableBuffer + tableStuff;
        } else {
            this.addToWiki(tableStuff);
        }
    }

    private String addAndCheckLineBreaks(String stuff, String testText) {
        if (stuff.equals("\\\\")) {
            if (testText.endsWith("\\\\\n")) {
                int wikiLength = testText.length();
                return testText.substring(0, wikiLength - 3) + "\n\n";
            }
            if (testText.endsWith("\\\\")) {
                int wikiLength = testText.length();
                return testText.substring(0, wikiLength - 2) + "\n\n";
            }
            if (testText.endsWith("\n")) {
                return testText + "\n";
            }
            return testText + "\\\\\n";
        }
        return testText + stuff;
    }

    private void endHeaderTag() {
        this.headerJustProcessed = true;
        if (this.lastHeaderIndex == -1) {
            return;
        }
        String lastLine = this.newWikiSyntax.substring(this.lastHeaderIndex);
        int numExclamations = 0;
        if (lastLine.startsWith("!!!")) {
            numExclamations = 3;
        } else if (lastLine.startsWith("!!")) {
            numExclamations = 2;
        } else if (lastLine.startsWith("!")) {
            numExclamations = 1;
        }
        if (numExclamations == 0) {
            return;
        }
        String afterHeader = lastLine.substring(numExclamations);
        boolean nonSpaceFound = false;
        for (int i = 0; i < afterHeader.length(); ++i) {
            if (afterHeader.charAt(i) == ' ') continue;
            nonSpaceFound = true;
            break;
        }
        this.newWikiSyntax = nonSpaceFound ? this.newWikiSyntax + "\n" : this.newWikiSyntax.substring(0, this.lastHeaderIndex);
    }

    private String textLink(String ref, String shownText) {
        String textToReturn = "";
        if (ref != null && !ref.equals("") && !ref.startsWith("javascript:")) {
            textToReturn = textToReturn + "[";
            if (shownText != null && shownText != "") {
                textToReturn = textToReturn + shownText + "|";
            }
            textToReturn = textToReturn + ref + "]";
        }
        return textToReturn;
    }

    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t == HTML.Tag.HR) {
            this.addToWiki("----");
        }
        if (t == HTML.Tag.BR) {
            this.addToWiki("\\\\");
        }
        if (t == HTML.Tag.IMG) {
            if (!this.lastLinkText.equals("")) {
                this.addToWiki(this.textLink(this.lastLinkRef, this.lastLinkText));
                this.lastLinkText = "";
            }
            String src = (String)a.getAttribute(HTML.Attribute.SRC);
            String align = (String)a.getAttribute(HTML.Attribute.ALIGN);
            String height = (String)a.getAttribute(HTML.Attribute.HEIGHT);
            String width = (String)a.getAttribute(HTML.Attribute.WIDTH);
            String alt = (String)a.getAttribute(HTML.Attribute.ALT);
            String border = (String)a.getAttribute(HTML.Attribute.BORDER);
            String link = this.lastLinkRef;
            this.addToWiki("[{Image");
            this.addToWiki(this.addAttrib("src", src));
            this.addToWiki(this.addAttrib("align", align));
            this.addToWiki(this.addAttrib("height", height));
            this.addToWiki(this.addAttrib("width", width));
            this.addToWiki(this.addAttrib("alt", alt));
            this.addToWiki(this.addAttrib("border", border));
            this.addToWiki(this.addAttrib("link", link));
            this.addToWiki("}]");
            this.justMadeLink = true;
        }
    }

    private String addAttrib(String attribName, String attribContents) {
        if (attribContents == null) {
            return "";
        }
        return " " + attribName + "='" + attribContents + "'";
    }

    private void addLineBreakIfNecessary(HTML.Tag t) {
        if (this.singleTableInProcess) {
            this.tableBuffer = this.tableBuffer + this.addLineBreakIfNecessary(t, this.m_beforeCaretText + this.newWikiSyntax + this.tableBuffer);
            this.cancelTableBuffer = this.cancelTableBuffer + this.addLineBreakIfNecessary(t, this.m_beforeCaretText + this.newWikiSyntax + this.cancelTableBuffer);
        } else {
            this.newWikiSyntax = this.newWikiSyntax + this.addLineBreakIfNecessary(t, this.m_beforeCaretText + this.newWikiSyntax);
        }
    }

    private String addLineBreakIfNecessary(HTML.Tag t, String lineBreakTest) {
        int lastLineBreak = lineBreakTest.lastIndexOf("\n");
        int testLength = lineBreakTest.length();
        if (lineBreakTest.length() > 0 && lastLineBreak + 1 < testLength) {
            String currentLine = lineBreakTest.substring(lastLineBreak + 1, testLength);
            if (this.tagIsHeader(t) && (currentLine.startsWith("*") || currentLine.startsWith("#")) && this.LiSymbols.length() > 0) {
                this.headerInList = true;
                return "";
            }
        }
        if (lastLineBreak == -1 ? lineBreakTest.length() > 0 : !lineBreakTest.endsWith("\n")) {
            return "\n";
        }
        return "";
    }

    public boolean tagIsHeader(HTML.Tag t) {
        return t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.H5 || t == HTML.Tag.H6;
    }

    private void startParagraphTag() {
        if (this.singleTableInProcess) {
            this.tableBuffer = this.tableBuffer + this.startParagraphTag(this.tableBuffer);
            this.cancelTableBuffer = this.cancelTableBuffer + this.startParagraphTag(this.cancelTableBuffer);
        } else {
            this.newWikiSyntax = this.newWikiSyntax + this.startParagraphTag(this.newWikiSyntax);
        }
    }

    private String startParagraphTag(String paragraphText) {
        if (paragraphText.length() == 0) {
            return "";
        }
        if (!paragraphText.endsWith("\n")) {
            return "\n\n";
        }
        int lastBreakIndex = paragraphText.lastIndexOf("\n");
        int secondLastBreakIndex = paragraphText.lastIndexOf("\n", lastBreakIndex - 1);
        String lineAbove = paragraphText.substring(secondLastBreakIndex + 1, lastBreakIndex);
        if (!lineAbove.startsWith("!") && lineAbove.length() != 0) {
            return "\n";
        }
        return "";
    }

    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t == HTML.Tag.SCRIPT) {
            this.scriptInProcess = true;
        }
        if (t == HTML.Tag.TITLE) {
            this.titleInProcess = true;
        }
        if (t == HTML.Tag.H1 || t == HTML.Tag.H2) {
            this.addLineBreakIfNecessary(t);
            if (!this.headerInList) {
                this.lastHeaderIndex = this.newWikiSyntax.length();
                this.addToWiki("!!!");
            }
        }
        if (t == HTML.Tag.H3) {
            this.addLineBreakIfNecessary(t);
            if (!this.headerInList) {
                this.lastHeaderIndex = this.newWikiSyntax.length();
                this.addToWiki("!!");
            }
        }
        if (t == HTML.Tag.H4 || t == HTML.Tag.H5 || t == HTML.Tag.H6) {
            this.addLineBreakIfNecessary(t);
            if (!this.headerInList) {
                this.lastHeaderIndex = this.newWikiSyntax.length();
                this.addToWiki("!");
            }
        }
        if (t == HTML.Tag.B || t == HTML.Tag.STRONG) {
            this.addToWiki("__");
        }
        if (t == HTML.Tag.I || t == HTML.Tag.EM) {
            this.addToWiki("''");
        }
        if (!(t != HTML.Tag.P && t != HTML.Tag.DIV || !this.LiSymbols.equals("") || this.singleTableInProcess || this.headerJustProcessed)) {
            this.startParagraphTag();
        }
        if (t == HTML.Tag.A) {
            String ref = (String)a.getAttribute(HTML.Attribute.HREF);
            if (ref == null) {
                ref = "";
            }
            this.lastLinkRef = ref;
        }
        if (t == HTML.Tag.UL) {
            this.LiSymbols = this.LiSymbols + "*";
        }
        if (t == HTML.Tag.OL) {
            this.LiSymbols = this.LiSymbols + "#";
        }
        if (t == HTML.Tag.LI) {
            if (this.LiSymbols.equals("")) {
                this.addLineBreakIfNecessary(t);
                this.addToWiki("* ");
            } else {
                this.addLineBreakIfNecessary(t);
                this.addToWiki(this.LiSymbols + " ");
            }
        }
        if (t == HTML.Tag.TABLE) {
            ++this.numEmbeddedTables;
            this.isFirstTDTag = true;
            if (!this.multTableInProcess) {
                this.singleTableInProcess = true;
                if (this.numEmbeddedTables == 2) {
                    this.singleTableInProcess = false;
                    this.multTableInProcess = true;
                    this.addToWiki(this.cancelTableBuffer);
                    this.tableBuffer = "";
                    this.cancelTableBuffer = "";
                }
            }
        }
        if (t == HTML.Tag.TD) {
            if (this.isFirstTDTag) {
                this.addLineBreakIfNecessary(t);
                this.isFirstTDTag = false;
            }
            this.addToWikiTable("|");
        }
        if (t == HTML.Tag.TH) {
            if (this.isFirstTDTag) {
                this.addLineBreakIfNecessary(t);
                this.isFirstTDTag = false;
            }
            this.addToWikiTable("||");
        }
    }

    public void handleText(char[] data, int pos) {
        String theText = new String(data);
        if (data[0] != '\u00a0' || data.length > 2) {
            if (this.lastLinkRef.equals("")) {
                this.addToWiki(theText);
            } else {
                this.lastLinkText = this.lastLinkText + theText;
                this.justMadeLink = false;
            }
        }
    }

    public String boldToHeader(String textBlock) {
        String[] textLines = textBlock.split("\n");
        String newTextBlock = "";
        String curLine = "";
        String testCurLine = "";
        for (int lineCount = 0; lineCount < textLines.length; ++lineCount) {
            curLine = textLines[lineCount];
            testCurLine = curLine.trim();
            int lineLength = testCurLine.length();
            if (testCurLine.startsWith("__") && testCurLine.endsWith("__\\\\") && !testCurLine.equals("__\\\\")) {
                curLine = "!" + testCurLine.substring(2, lineLength - 4);
            } else if (testCurLine.startsWith("''__") && testCurLine.endsWith("__''\\\\")) {
                try {
                    curLine = "!''" + testCurLine.substring(4, lineLength - 6) + "''";
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            newTextBlock = newTextBlock + curLine + "\n";
        }
        newTextBlock = newTextBlock.substring(0, newTextBlock.length() - 1);
        return newTextBlock;
    }

    public String toString() {
        this.newWikiSyntax = this.boldToHeader(this.newWikiSyntax);
        return this.newWikiSyntax;
    }
}

