/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.wikiwizard.WikiWizardApplet;
import org.wikiwizard.observeModul;

public class SearchDialog
extends JDialog
implements CaretListener,
KeyListener,
ActionListener {
    private observeModul obsable;
    public JTextField input;
    private JApplet owner;
    private String saver;
    public StatusBar statusBar;
    private JCheckBox fontChase;
    static String resource_ico = "/org/wikiwizard/resources";
    private Font menuFontSize = new Font("Dialog", 0, 12);
    private ResourceBundle bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);
    static /* synthetic */ Class class$org$wikiwizard$WikiWizardApplet;

    public SearchDialog(Object obs) {
        super((Frame)SwingUtilities.getRoot((JApplet)obs));
        this.owner = (JApplet)obs;
        this.statusBar = new StatusBar();
        this.statusBar.setText(" ");
        this.setModal(false);
        this.setTitle(this.bundle.getString("searchDiaTitle"));
        this.obsable = new observeModul();
        this.obsable.addObserver((Observer)obs);
        JPanel pane = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)pane, "North");
        JPanel bet = new JPanel();
        bet.setPreferredSize(new Dimension(100, 30));
        this.getContentPane().add((Component)bet, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        JLabel label = new JLabel(this.bundle.getString("searchDiaSearchFor"));
        label.setFont(this.menuFontSize);
        pane.add((Component)label, c);
        this.input = new JTextField(((WikiWizardApplet)this.owner).text.getSelectedText(), 20);
        this.input.addCaretListener(this);
        this.input.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                SearchDialog.this.input.selectAll();
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        c.gridwidth = 2;
        pane.add((Component)this.input, c);
        JButton searchButton = new JButton(this.bundle.getString("searchDiaOK"));
        searchButton.setFont(this.menuFontSize);
        pane.add((Component)searchButton, c);
        this.fontChase = new JCheckBox(this.bundle.getString("searchDiaCase"));
        this.fontChase.setFont(this.menuFontSize);
        c.gridx = 1;
        c.gridy = 1;
        pane.add((Component)this.fontChase, c);
        searchButton.addActionListener(this);
        JButton cancelButton = new JButton(this.bundle.getString("searchDiaCancel"));
        cancelButton.setFont(this.menuFontSize);
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        pane.add((Component)cancelButton, c);
        cancelButton.addActionListener(this);
        searchButton.getRootPane().setDefaultButton(searchButton);
        searchButton.setDefaultCapable(true);
        this.input.addKeyListener(this);
        pane.addKeyListener(this);
        this.input.requestFocus();
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.obsable.input("SearchDialog beenden");
            this.hide();
        }
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        if (arg.equals(this.bundle.getString("searchDiaOK"))) {
            this.obsable.input("Weitersuchen");
        }
        if (arg.equals(this.bundle.getString("searchDiaCancel"))) {
            this.obsable.input("SearchDialog beenden");
            this.hide();
        }
    }

    public boolean getFontChase() {
        return this.fontChase.isSelected();
    }

    public String getInput() {
        return this.input.getText();
    }

    public void setInput(String sInput) {
        this.input.setText(sInput);
    }

    public void textFieldRequest() {
        this.input.requestFocus();
    }

    public void show() {
        super.show();
        this.setLocationRelativeTo(this.owner);
    }

    public void caretUpdate(CaretEvent arg0) {
        this.input.setBackground(Color.WHITE);
        if (!this.input.getText().equals(this.saver)) {
            this.statusBar.setText(" ");
        }
    }

    class StatusBar
    extends JPanel {
        private JLabel m_Koordinaten = new JLabel("");
        private JLabel m_Nachrichten = new JLabel("");
        private JLabel m_ZoomFaktor = new JLabel("");
        private JLabel icon;
        private ImageIcon image1;
        private ImageIcon image2;
        private ImageIcon image3;

        private StatusBar() {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new FlowLayout(0, 5, 0));
            this.m_Koordinaten.setFont(new Font("Arial", 1, 10));
            this.m_Nachrichten.setFont(new Font("Arial", 1, 10));
            this.m_ZoomFaktor.setFont(new Font("Arial", 1, 10));
            this.m_Koordinaten.setHorizontalAlignment(2);
            this.m_Koordinaten.setPreferredSize(new Dimension(300, 17));
            this.image1 = new ImageIcon(tk.getImage((class$org$wikiwizard$WikiWizardApplet == null ? (class$org$wikiwizard$WikiWizardApplet = SearchDialog.class$("org.wikiwizard.WikiWizardApplet")) : class$org$wikiwizard$WikiWizardApplet).getResource(resource_ico + "/stock_repeat-16.png")));
            this.image2 = new ImageIcon(tk.getImage((class$org$wikiwizard$WikiWizardApplet == null ? (class$org$wikiwizard$WikiWizardApplet = SearchDialog.class$("org.wikiwizard.WikiWizardApplet")) : class$org$wikiwizard$WikiWizardApplet).getResource(resource_ico + "/stock_3d-light-on-16.png")));
            this.icon = new JLabel();
            this.add(this.icon);
            this.add(this.m_Koordinaten);
        }

        public void setZoom(int z) {
            this.m_ZoomFaktor.setText("Zoom: " + z + "%");
        }

        public void setStatus(String z) {
            this.m_Nachrichten.setText(z);
        }

        public void setText(String text) {
            if (text.equals(" ")) {
                this.icon.setVisible(false);
            } else {
                this.icon.setVisible(true);
            }
            if (text.equals(SearchDialog.this.bundle.getString("searchNotFound"))) {
                this.icon.setIcon(this.image2);
            } else {
                this.icon.setIcon(this.image1);
            }
            this.m_Koordinaten.setText(text);
            if (SearchDialog.this.input != null) {
                SearchDialog.this.saver = SearchDialog.this.input.getText();
            }
        }
    }
}

