/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.util.ResourceBundle;
import javax.swing.JApplet;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.wikiwizard.WikiWizardApplet;

public class LineCount
extends Thread {
    private JEditorPane text2 = new JEditorPane();
    private JEditorPane text;
    private int row;
    private JApplet applet;
    private int column;
    static String resource_lang = "org.wikiwizard.resources";
    private JTextField txt_row;
    private JTextField txt_col;
    private JTextField txt_size;
    private ResourceBundle bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);

    public LineCount(JEditorPane pane, WikiWizardApplet applet, JTextField txt_row, JTextField txt_col, JTextField txt_size) {
        this.text = pane;
        this.txt_row = txt_row;
        this.txt_col = txt_col;
        this.txt_size = txt_size;
        this.applet = applet;
    }

    public void run() {
        boolean set = true;
        try {
            this.txt_row.setText(this.bundle.getString("rowStatusBar") + this.getRealLineCount(this.text));
            this.txt_col.setText(this.bundle.getString("colStatusBar") + this.getRealColumnCount(this.text));
            this.txt_size.setText(this.bundle.getString("sizeStatusBar") + this.text.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRealColumnCount(JTextComponent text) {
        int width = 0;
        int nr = 0;
        try {
            if (text.getDocument().getText(text.getCaretPosition(), 1).equals("\n")) {
                if (text.getDocument().getLength() > 0) {
                    nr = text.getDocument().getText(0, text.getDocument().getLength()).lastIndexOf("\n", text.getCaretPosition() - 1);
                }
            } else {
                nr = text.getDocument().getText(0, text.getDocument().getLength()).lastIndexOf("\n", text.getCaretPosition());
            }
            width = nr == -1 ? text.getCaretPosition() : text.getCaretPosition() - nr - 1;
        }
        catch (Exception e) {
            // empty catch block
        }
        return width + 1;
    }

    public int getRealLineCount(JTextComponent component) {
        Element root = this.text.getDocument().getDefaultRootElement();
        int line = 1 + root.getElementIndex(this.text.getCaretPosition());
        return line;
    }
}

