/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import org.wikiwizard.BrowserLauncher;
import org.wikiwizard.WikiWizardApplet;

public class AboutDialog
extends JDialog {
    private URL url;
    private JEditorPane editorPane;
    private JButton bn_ok = null;
    private JApplet parent = null;
    private JDialog dialog = null;
    private ResourceBundle bundle = null;
    URL pageURL = null;
    Font menuFontSize = new Font("Dialog", 0, 12);

    public boolean showDialog() {
        if (this.bn_ok != null) {
            this.bn_ok.requestFocus();
        }
        this.setVisible(true);
        return true;
    }

    public AboutDialog(JApplet owner, String startPage, String title, Object[] arguments) {
        this.bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);
        this.dialog = this;
        this.parent = owner;
        this.setModal(true);
        this.setTitle(this.bundle.getString("aboutDialogTitle"));
        this.setSize(400, 400);
        this.setResizable(true);
        this.setScreenCentered();
        this.setLocationRelativeTo(owner);
        this.pageURL = AboutDialog.class.getResource(startPage);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        JPanel statusPanel = new JPanel();
        this.editorPane = new JEditorPane();
        this.editorPane.setFont(new Font("Courier", 0, 12));
        this.editorPane.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(this.editorPane), "Center");
        JPanel okPanel = new JPanel(new FlowLayout(1));
        this.bn_ok = new JButton(this.bundle.getString("aboutDialogOK"));
        this.bn_ok.setFont(this.menuFontSize);
        AbstractAction OkAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.setVisible(false);
            }
        };
        this.bn_ok.addActionListener(OkAction);
        okPanel.add(this.bn_ok);
        this.getContentPane().add((Component)okPanel, "South");
        this.getRootPane().setDefaultButton(this.bn_ok);
        try {
            this.editorPane.setContentType("text/html");
            HTMLDocument doc = (HTMLDocument)this.editorPane.getDocument();
            doc.setBase(this.pageURL);
            InputStream bis = (InputStream)this.pageURL.getContent();
            String scontent = "";
            String s = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(bis));
            while ((s = in.readLine()) != null) {
                scontent = scontent + s + "\n";
            }
            in.close();
            String result = MessageFormat.format(scontent, arguments);
            if (result != null) {
                class ContentLoader
                extends Thread {
                    String con = "";

                    ContentLoader(String content) {
                        this.con = content;
                    }

                    public void run() {
                        try {
                            AboutDialog.this.editorPane.setText(this.con);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                ContentLoader loader = new ContentLoader(result);
                loader.start();
            }
        }
        catch (Exception e) {
            this.editorPane.setText("ERROR: " + e);
            e.printStackTrace();
        }
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    AboutDialog.this.dialog.setCursor(Cursor.getPredefinedCursor(12));
                } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    AboutDialog.this.dialog.setCursor(Cursor.getPredefinedCursor(0));
                } else if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        String protocol = event.getURL().getProtocol().toLowerCase();
                        if (protocol.equals("file") || protocol.equals("jar")) {
                            AboutDialog.this.editorPane.setPage(event.getURL());
                        } else {
                            BrowserLauncher.openURL(event.getURL().toString());
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(AboutDialog.this, e);
                        try {
                            AboutDialog.this.editorPane.setPage(AboutDialog.this.pageURL);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AboutDialog.this.setVisible(false);
            }
        });
    }

    private void setScreenCentered() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        d = this.getSize();
        int windowHeight = d.height;
        int windowWidth = d.width;
        this.setLocation((screenWidth - windowWidth) / 2, (screenHeight - windowHeight) / 2 + 300);
    }

    public static void main(String[] args) {
        Object[] arguments = new Object[]{"WikiWizard, Version 0.9", System.getProperties().getProperty("java.version"), System.getProperties().getProperty("java.home"), Locale.getDefault()};
        String filename = "/org/wikiwizard/resources/about.html";
        filename = filename.replace('\"', ' ').trim();
        AboutDialog dialog = new AboutDialog(null, filename, "About WikiWizard", arguments);
        dialog.showDialog();
    }
}

