import pisock
from jppy.conduit import Conduit
from jppy.core import Component, implements
from jppy.config import ListOption, Option

import smtplib
try:
    from email.mime.text import MIMEText
except ImportError, e:
    from email import MIMEText

class AnnounceEvents(Conduit):
    """
    To use this conduit, write into your ~/.jppyrc:

    [AnnounceEvents]
    email = you@example.com, friend@example.com

    [conduit]
    enabled = jppy.conduits.announce_events.AnnounceEvents
    """
    email         = ListOption("AnnounceEvents","email")
    frm           = Option("AnnounceEvents","from")
    subject       = Option("AnnounceEvents","subject","Calendar Changes")
    categories    = ListOption("AnnounceEvents","categories")
    
    def pre_sync(self):
        self.log.debug("In pre_sync()")

        categories_available = self.env.calendar.getCategories()
        if self.categories:
            self.category_ints = []
            for wanted_name in self.categories:
                try:
                    self.category_ints.append(
                        categories_available.index(wanted_name))
                except ValueError, e:
                    self.log.warn("Category %s does not exist. Remove setting if you want all categories." % wanted_name)
        else:
            self.category_ints = range(0,16)
        self.log.debug("Categories - %s" % self.category_ints)
        
        original_records = {}
        for r in self.env.calendar.records(categories=self.category_ints):
            r.category
            original_records[r.unique_id] = r
        self.original_records = original_records
        
    def post_sync(self):
        current_records = {}
        for r in self.env.calendar.records(categories=self.category_ints):
            current_records[r.unique_id] = r

        self.log.debug("In post_sync() - orig:%d curr:%d" % (
            len(self.original_records.keys()),
            len(current_records.keys())))

        added   = []
        removed = []

        for original_id, original_r in self.original_records.items():
            if original_id not in current_records.keys():
                self.log.debug("%s was removed: %s" % (original_id,
                                                       original_r))
                removed.append(original_r)
        
        for current_id, current_r in current_records.items():
            if current_id not in self.original_records.keys():
                self.log.debug("%s was added: %s" % (current_id,
                                                     current_r))
                added.append(current_r)

        if not (added or removed):
            self.log.info("No changes")
            return

        body = []

        for r in added:
            body.append("""\
New calendar entry: %(description)s
%(begin)s - %(end)s

""" % dict(r))
        for r in removed:
            body.append("""\
Removed calendar entry: %(description)s
%(begin)s - %(end)s

""" % dict(r))

        msg = MIMEText("\n".join(body))
        msg['Subject'] = "Calendar Changes"
        msg['From'] = self.frm
        msg['To'] = ", ".join(self.email)

        self.log.info("Sending mail to %s" % self.email)
        
        s = smtplib.SMTP()
        s.connect()
        s.sendmail(self.frm, self.email, msg.as_string())
        s.close()
        
