import datetime
from dateutil.tz import *
from dateutil.relativedelta import *
from dateutil.rrule import *
import vobject

def decode(str):
    '''Convert a unicode string to a byte string'''
    if str:
        return str.encode('utf-8')
    else:
        return str
    
def to_tzinfo(palm_tz):
        '''
        Convert a palm timezone object into a tzinfo object
        '''

        if palm_tz["dstObserved"]:
            start_day = 0
            if palm_tz["dstStart.dayOfWeek"] == 0:
                start_day = SU(+(palm_tz["dstStart.weekOfMonth"]+1))
            elif palm_tz["dstStart.dayOfWeek"] == 1:
                start_day = MO(+(palm_tz["dstStart.weekOfMonth"]+1))
            elif palm_tz["dstStart.dayOfWeek"] == 2:
                start_day = TU(+(palm_tz["dstStart.weekOfMonth"]+1))
            elif palm_tz["dstStart.dayOfWeek"] == 3:
                start_day = WE(+(palm_tz["dstStart.weekOfMonth"]+1))
            elif palm_tz["dstStart.dayOfWeek"] == 4:
                start_day = TH(+(palm_tz["dstStart.weekOfMonth"]+1))
            elif palm_tz["dstStart.dayOfWeek"] == 5:
                start_day = FR(+(palm_tz["dstStart.weekOfMonth"]+1))
            elif palm_tz["dstStart.dayOfWeek"] == 6:
                start_day = SA(+(palm_tz["dstStart.weekOfMonth"]+1))
            else:
                print("Error!")

            end_day = 0
            if palm_tz["dstEnd.dayOfWeek"] == 0:
                end_day = SU(+(palm_tz["dstEnd.weekOfMonth"]+1))
            elif palm_tz["dstEnd.dayOfWeek"] == 1:
                end_day = MO(+(palm_tz["dstEnd.weekOfMonth"]+1))
            elif palm_tz["dstEnd.dayOfWeek"] == 2:
                end_day = TU(+(palm_tz["dstEnd.weekOfMonth"]+1))
            elif palm_tz["dstEnd.dayOfWeek"] == 3:
                end_day = WE(+(palm_tz["dstEnd.weekOfMonth"]+1))
            elif palm_tz["dstEnd.dayOfWeek"] == 4:
                end_day = TH(+(palm_tz["dstEnd.weekOfMonth"]+1))
            elif palm_tz["dstEnd.dayOfWeek"] == 5:
                end_day = FR(+(palm_tz["dstEnd.weekOfMonth"]+1))
            elif palm_tz["dstEnd.dayOfWeek"] == 6:
                end_day = SA(+(palm_tz["dstEnd.weekOfMonth"]+1))
            else:
                print("Error!")

            return tzrange(decode(palm_tz["name"]),
                           palm_tz["offset"]*60,
                           decode(palm_tz["name"])+"DST",
                           (palm_tz["offset"]+60)*60,
                           relativedelta(hours=+2,
                                         month=palm_tz["dstStart.month"],
                                         day=1,
                                         weekday=start_day),
                           relativedelta(hours=+1,
                                         month=palm_tz["dstEnd.month"],
                                         day=1,
                                         weekday=end_day))


        else:
            return tzrange(decode(palm_tz["name"]), palm_tz["offset"]*60)
