import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import os, os.path
import sys
import jppy
import ConfigParser
import tasks, memos, contacts
import gtk_models

class notebook:
    def __init__(self, parent, glade_path, control_mainloop=0, env=None):
        self.control_mainloop = control_mainloop

        parent.connect("destroy", self.quit)

        if env is None:
            self.env = jppy.environment.Environment()
        else:
            self.env = env

        # set up the panes
        self.panes = []
        try:
            self.panes.append(contacts.pane(self.env, glade_path))
        except IOError, e:
            self.env.warn("Unable to create the Contacts pane: %s" % e)
        self.panes.append(tasks.pane(self.env, glade_path))
        self.panes.append(memos.pane(self.env, glade_path))

        try:
            use_memo32 = self.env.config.get('core','memo32').upper() == "YES"
        except ConfigParser.NoOptionError, e:
            use_memo32 = False
        if use_memo32:
            memo32pane = memos.pane(self.env, glade_path, model=gtk_models.Memos32Model(self.env))
            memo32pane.name = "Memo32"
            self.panes.append(memo32pane)

        vbox = gtk.VBox()
        msg = """
<span size="large" weight="bold">Jppy</span>
Close subwindows to
return them to the dock.
"""
        allgonewidget = gtk.Label()
        allgonewidget.hide()
        allgonewidget.set_markup(msg)
        allgonewidget.set_property("xpad", 20)
        vbox.add(allgonewidget)
        notebook = gtk.Notebook()
        for pane in self.panes:
            self.put_in_notebook(None, pane.main_vpaned, pane.name, notebook, allgonewidget)

        notebook.show()
        vbox.add(notebook)

        vbox.show()

        parent.add(vbox)
        parent.show()
        
        return

    def child_detached(self, handlebox, label, vpaned, name, notebook, allgonewidget):
        #print widget, label, vpaned, name, notebook
        #print name

        self.env.log.debug("Detached")

        window = gtk.Window()
        window.set_title("Jppy - %s" % name)
        
        vpaned.reparent(window)
        window.show()
        window.connect("destroy", self.put_in_notebook, vpaned, name, notebook, allgonewidget)

        if len(notebook.get_children()) == 0:
            allgonewidget.show()
            notebook.hide()
            maingdkwindow = allgonewidget.get_parent_window()
            maingdkwindow.resize(100,100)

    def put_in_notebook(self, window, vpaned, name, notebook, allgonewidget):
        #print window, vpaned, name, notebook
        box = gtk.HandleBox()
        label = gtk.Label(name)
        label.show()
        box.add(label)
        box.show()
        box.connect("child-detached",
                    self.child_detached,
                    vpaned,
                    name,
                    notebook,
                    allgonewidget)

        if window:
            window.remove(vpaned)
            window.destroy()

        if len(notebook.get_children()) == 0:
            allgonewidget.hide()
            notebook.show()
            
        notebook.append_page(vpaned,box)        

    def quit(self, widget=None):
        self.env.log.info("Quitting")
        for pane in self.panes:
            pane.quit()
        if self.control_mainloop:
            gtk.main_quit()
