#!/usr/bin/env python

import email
import jppy
from optparse import OptionParser
import mimetypes

parser = OptionParser()

(options, args) = parser.parse_args()

env = jppy.environment.Environment()
ab = env.addressBook

for filename in args:
    fp = open(filename)
    msg = email.message_from_file(fp)
    fp.close()

    for part in msg.walk():
        if part.get_content_type() != "text/x-vcard":
            continue

        vcard = part.get_payload(decode=True)

        # a very nasty hack to work around a bug in the vobject-python library
        out_vcard = []
        block = vcard.split("\n")
        n = 0
        while n < len(block): 
            if block[n].endswith("=\r"):
                out_vcard.append(block[n][:-2] + block[n+1])
                n = n + 1
            elif block[n].endswith("="):
                out_vcard.append(block[n][:-1] + block[n+1])
                n = n + 1
            else:
                out_vcard.append(block[n])
            n = n + 1
        vcard = "\n".join(out_vcard)
        
        for contact in jppy.vcard.load_vcards(vcard):
            ab.save(contact)
            print contact
