import os
import datetime
from dateutil.tz import *
from dateutil.relativedelta import *
from dateutil.rrule import *
import vobject

from jppy import _jpilot, api
from jppy.core import implements

from jppy.api import IAddressBook, IMemoList, ITaskList, ICalendar, IInstallFile

from jpilot_utils import calendar_event_mixin

assert _jpilot.check_hidden_dir() == 0
assert _jpilot.check_copy_DBs_to_home() == 0

class Address(_jpilot.Address):
    pass

class Todo(_jpilot.Todo):
    pass

class Memo(_jpilot.Memo):
    pass

class jpilot_common_mixin:
    _writeDatabaseFunction= _jpilot.SaveObjectToJpilotDatabase
    _deleteFromDatabaseFunction = _jpilot.DeleteObjectFromJpilotDatabase

class addressBook(api.addressBook, jpilot_common_mixin):
    implements(IAddressBook)
    _appInfoFunction      = _jpilot.w_read_AddressAppInfo
    _readDatabaseFunction = _jpilot.w_jp_read_AddressDB
    _database             = "AddressDB"
    _record_class         = Address

class memoList(api.memoList, jpilot_common_mixin):
    implements(IMemoList)
    _appInfoFunction      = _jpilot.w_read_MemoAppInfo
    _readDatabaseFunction = _jpilot.w_jp_read_MemoDB
    _database             = "MemoDB"
    _record_class         = Memo

class memo32List(api.memo32List, jpilot_common_mixin):
    implements(IMemoList)
    _appInfoFunction      = _jpilot.w_read_MemoAppInfo
    _readDatabaseFunction = _jpilot.w_jp_read_MemoDB
    _database             = "Memo32DB"
    _record_class         = Memo

class taskList(api.taskList, jpilot_common_mixin):
    implements(ITaskList)
    _appInfoFunction      = _jpilot.w_read_ToDoAppInfo
    _readDatabaseFunction = _jpilot.w_jp_read_ToDoDB
    _database             = "ToDoDB"
    _record_class         = Todo    

class Appointment(_jpilot.Appointment, calendar_event_mixin):

    # TODO this should be able to be moved to the mixin
    _keys = ["dates"]
    
    def keys(self):
        return _jpilot.Appointment.keys(self) + self._keys

    def __getitem__(self, key):
        if key in self._keys:
            if hasattr(self, "_get_%s" % key):
                return getattr(self, "_get_%s" % key)()
            raise NotImplemented("Unable to get %s yet." % key)
        elif "begin" == key or "end" == key:
            return self.convertDatetimeFromPalm(_jpilot.Appointment.__getitem__(self, key))
        elif "exceptions" == key:
            palmExceptions = _jpilot.Appointment.__getitem__(self, key)
            tzExceptions = []
            for palmException in palmExceptions:
                tzExceptions.append(self.convertDatetimeFromPalm(palmException))
            return tzExceptions
        elif "timezone" == key:
            return self.gettimezone()
        else:
            return _jpilot.Appointment.__getitem__(self, key)

    def __setitem__(self, item, value):
        if item in self._keys:
            if hasattr(self, "_set_%s" % item):
                setattr(self, "_set_%s" % item, value)
            else:
                raise NotImplementedError("Unable to set %s yet." % item)
        else:
            if "begin" == item or "end" == item:
                value = convertDatetimeToPalm(value)
            elif "exceptions" == item:
                palmExceptions = []
                for exception in value:
                    palmExceptions.append(self.convertDatetimeToPalm(exception))
                value = palmExceptions

            _jpilot.Appointment.__setitem__(self, item, value)

    def gettimezone(self):
        """
        Always return tzlocal as appointments don't support timezones.
        """
        return tzlocal()
    

class calendar(api.calendar, jpilot_common_mixin):
    implements(ICalendar)
    _appInfoFunction      = _jpilot.w_read_DatebookAppInfo
    _readDatabaseFunction = _jpilot.w_jp_read_DatebookDB
    _database             = "DatebookDB"
    _record_class         = Appointment    

class installFile(api.installFile):
    implements(IInstallFile)
    def install(filename):
        f = open(self._install_queue_filename(),"a")
        f.write("%s\n" % filename)
        f.close()

    def _install_queue_filename(self):
        possible_names = ("jpilot_to_install", "jpilot.install")
        for possible_name in possible_names:
            full_filename = os.path.join(os.environ['HOME'],".jpilot",possible_name)
            if os.path.exists(full_filename) and os.path.getsize(full_filename) > 0:
                return full_filename
        return full_filename
