#include <jmp-config.h>

/*  Experimenal start on JVMTI interface support for JMP.
 *
 */
#ifdef SUPPORT_JVMTI

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jni.h>
#include <jvmti.h>

#include <jmp-debug.h>
#include <jmp-jvmti.h>

static jvmtiEnv *jvmti = NULL;

#ifdef JVMTI_VERSION_1_2
 /* FWIW - 1.2 does not exists at this time */
 static int jvmti_version_supported = JVMTI_VERSION_1_2;
#elif JVMTI_VERSION_1_1
 static int jvmti_version_supported = JVMTI_VERSION_1_1;
#else
 static int jvmti_version_supported = JVMTI_VERSION_1;
#endif
static int jvmti_version_using = 0;

#ifdef JVMTI_VERSION_1_1
#endif

#ifdef JVMTI_VERSION_1_2
#endif

static const char *jvm_jvmti_version_string (int vers) {
  switch(vers) {
  case JVMTI_VERSION_1:
    return "1.0";

#ifdef JVMTI_VERSION_1_1
  case JVMTI_VERSION_1_1:
    return "1.1";
#endif

#ifdef JVMTI_VERSION_1_2
  case JVMTI_VERSION_1_2:
    return "1.2";
#endif
  }
  return "unknown";
}

static jint jvm_detect_jvmti_version (JavaVM *vm) {
    jvmtiEnv **jvmti_p;
    jvmti_p = &jvmti;

#ifdef JVMTI_VERSION_1_2
    if(jvmti_version_using == 0) {
        if ((*vm)->GetEnv(vm, (void **) jvmti_p, JVMTI_VERSION_1_2) == 0)
            jvmti_version_using = JVMTI_VERSION_1_2;
    }
#endif

#ifdef JVMTI_VERSION_1_1
    if(jvmti_version_using == 0) {
        if ((*vm)->GetEnv(vm, (void **) jvmti_p, JVMTI_VERSION_1_1) == 0)
            jvmti_version_using = JVMTI_VERSION_1_1;
    }
#endif

    if(jvmti_version_using == 0) {
        if ((*vm)->GetEnv(vm, (void **) jvmti_p, JVMTI_VERSION_1) == 0)
            jvmti_version_using = JVMTI_VERSION_1;
    }

    return jvmti_version_using;
}

JNIEXPORT jint JNICALL
Agent_OnLoad(JavaVM *vm, char *options, void *reserved)
{
    /* get jvmti interface pointer */
    if (jvm_detect_jvmti_version (vm) < 0) {
	fprintf (stderr, "jmp: error in obtaining jvmti interface pointer\n");
	return JNI_ERR;
    }

    if (jvmti_version_using != jvmti_version_supported) {
        fprintf (stdout, "JVMTI Version: JVM supports %s, JMP supports %s, using %s\n",
             jvm_jvmti_version_string(jvmti_version_using),
             jvm_jvmti_version_string(jvmti_version_supported),
             jvm_jvmti_version_string(jvmti_version_using));
    } else {
        fprintf (stdout, "JVMTI Version: %s\n",
             jvm_jvmti_version_string(jvmti_version_using));
    }
    fflush (stdout);

    return JNI_OK;
}

JNIEXPORT void JNICALL
Agent_OnUnload(JavaVM *vm)
{
    jvmti = NULL;
}

#endif

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
