set version=2.3
set package_name=jericho-html-%version%

md bin
md lib

rem ----- Compile source:
javac -g:none -d bin src\java\au\id\jericho\lib\html\*.java src\java\au\id\jericho\lib\html\nodoc\*.java
if errorlevel 1 goto end

rem ----- Create jar library:
jar -cf lib\%package_name%.jar -C bin .

@if "%1"=="-nojavadoc" goto buildsamples
rem ----- Create docs:
javadoc -quiet -windowtitle "Jericho HTML Parser %version%" -classpath src\java;bin -use -d doc\api -subpackages au.id.jericho.lib.html -exclude au.id.jericho.lib.html.nodoc -noqualifier au.id.jericho.lib.html -group "Core Package" au.id.jericho.lib.html
type src\css\javadoc.css >> doc\api\stylesheet.css

rem ----- Build the samples:
:buildsamples
md samples\CommandLine\bin
javac -g -deprecation -classpath lib/%package_name%.jar -d samples\CommandLine\bin samples\CommandLine\src\*.java
if errorlevel 1 goto end
md samples\CommandLine\bat_lib
echo @set package_name=%package_name%> samples\CommandLine\bat_lib\set_package_name.bat

@if "%1"=="-nojavadoc" goto end
rem ----- Zip up the whole package:
jar -cMf ..\%package_name%.zip -C .. %package_name%

:end
