/*
 * File    : MediaBagSelector.java
 * Created : 22-mar-2004 15:36
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.bags;

import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.Component;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.net)
 * @version 1.0
 */
public class MediaBagSelector extends javax.swing.JPanel {
    
    Options options;
    
    /** Creates new form MediaBagSelector */
    public MediaBagSelector(Options options) {
        this.options=options;
        initComponents();
        mediaList.addListSelectionListener(selListener);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel sizeLb;
        javax.swing.JLabel typeLb;

        scrollList = new javax.swing.JScrollPane();
        mediaList = new javax.swing.JList();
        elementPanel = new javax.swing.JPanel();
        previewLabel = new javax.swing.JLabel();
        nameLb = new javax.swing.JLabel();
        nameText = new javax.swing.JLabel();
        fileLb = new javax.swing.JLabel();
        fileText = new javax.swing.JLabel();
        typeLb = new javax.swing.JLabel();
        typeTx = new javax.swing.JLabel();
        sizeLb = new javax.swing.JLabel();
        sizeTx = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        scrollList.setPreferredSize(new java.awt.Dimension(120, 120));
        scrollList.setMinimumSize(new java.awt.Dimension(120, 120));
        scrollList.setViewportView(mediaList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(scrollList, gridBagConstraints);

        elementPanel.setLayout(new java.awt.GridBagLayout());

        previewLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        previewLabel.setPreferredSize(new java.awt.Dimension(100, 100));
        previewLabel.setBorder(new javax.swing.border.EtchedBorder());
        previewLabel.setMinimumSize(new java.awt.Dimension(100, 100));
        previewLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                previewLabelMousePressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 7, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 1.0;
        elementPanel.add(previewLabel, gridBagConstraints);

        nameLb.setText(options.getMsg("edit_name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        elementPanel.add(nameLb, gridBagConstraints);

        nameText.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        elementPanel.add(nameText, gridBagConstraints);

        fileLb.setText(options.getMsg("edit_file"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        elementPanel.add(fileLb, gridBagConstraints);

        fileText.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        elementPanel.add(fileText, gridBagConstraints);

        typeLb.setText(options.getMsg("edit_media_type"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        elementPanel.add(typeLb, gridBagConstraints);

        typeTx.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        elementPanel.add(typeTx, gridBagConstraints);

        sizeLb.setText(options.getMsg("edit_media_size"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        elementPanel.add(sizeLb, gridBagConstraints);

        sizeTx.setText("0 Kb");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        elementPanel.add(sizeTx, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(elementPanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void previewLabelMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_previewLabelMousePressed

        if(current!=null)
            current.testMedia(this, options);
        
    }//GEN-LAST:event_previewLabelMousePressed

    MediaBagEditor mbe;
    MediaBagElementEditor current;
    int filters;
    
    protected void setMediaBagEditor(MediaBagEditor mbe, int filters){
        this.mbe=mbe;
        this.filters=filters;
        setSelected(null);
        mediaList.setListData(mbe==null ? new Vector() : mbe.getChildrenList(filters));
    }
    
    protected void setSelected(MediaBagElementEditor mbed){
        current=mbed;
        nameText.setText(current==null ? "" : current.getName());

        fileText.setText(current==null ? "" : current.getMediaBagElement().getFileName());
        
        typeTx.setText(mbed==null
        ? ""
        : mbed.getDescription(options));
        
        long fSize=-1;
        if(mbed!=null)
            fSize=mbed.getFileSize();
        sizeTx.setText(fSize<0
        ? ""
        : options.getMessages().fileSize(fSize));
        
        previewLabel.setIcon(mbed==null ? null :
            mbed.getMediaBagElement().getThumbNail(90, 90, mbed.getMediaBag().getProject().getFileSystem()));
        
    }
    
    protected MediaBagElementEditor getSelected(){
        return current;
    }
    
    private ListSelectionListener selListener=new ListSelectionListener(){
        public void valueChanged(ListSelectionEvent evt){
            if(evt!=null && !evt.getValueIsAdjusting()){
                setSelected((MediaBagElementEditor)mediaList.getSelectedValue());
            }
        }
    };
    
        
    private static java.util.HashMap dlgPanels=new java.util.HashMap(1);
    public static String getMediaName(String initialValue, Options options, Component parent, MediaBagEditor mbe, int filters){
        String result=null;
        Messages msg=options.getMessages();
        MediaBagSelector mbs=(MediaBagSelector)dlgPanels.get(options);
        if(mbs==null){
            mbs=new MediaBagSelector(options);
            mbs.setPreferredSize(new java.awt.Dimension(400, 300));
            dlgPanels.put(options, mbs);
        }
        mbs.setMediaBagEditor(mbe, filters);
        MediaBagElementEditor mbed=initialValue==null ? null 
        : (MediaBagElementEditor)mbe.getChildByName(initialValue);
        mbs.setSelected(mbed);
        mbs.mediaList.setSelectedValue(mbed, true);
        
        boolean b=msg.showInputDlg(parent, mbs, "edit_media_dlg_title");
        if(b){
            MediaBagElementEditor mbele=mbs.getSelected();
            if(mbele!=null)
                result=mbele.getName();
        }        
        mbs.setMediaBagEditor(null, -1);
        return result;
    }

    
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel elementPanel;
    private javax.swing.JLabel fileLb;
    private javax.swing.JLabel fileText;
    private javax.swing.JList mediaList;
    private javax.swing.JLabel nameLb;
    private javax.swing.JLabel nameText;
    private javax.swing.JLabel previewLabel;
    private javax.swing.JScrollPane scrollList;
    private javax.swing.JLabel sizeTx;
    private javax.swing.JLabel typeTx;
    // End of variables declaration//GEN-END:variables
    
}
