/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _ipodslave_H_
#define _ipodslave_H_

#include <qstring.h>
#include <qcstring.h>
#include <qfile.h>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

#include "trackmetadata.h"
#include "ipod.h"
#include "directorymodel.h"
#include "ipodutility.h"

class QCString;

class kio_ipodslaveProtocol : public KIO::SlaveBase
{
typedef QMap<QString,IPodUtility*> UtilityMap;
public:
    kio_ipodslaveProtocol(const QCString &pool_socket, const QCString &app_socket);
    virtual ~kio_ipodslaveProtocol();

    virtual void mimetype(const KURL& url);
    virtual void get(const KURL& url);
    virtual void listDir (const KURL &url);
    virtual void stat(const KURL &url);
    virtual void mkdir( const KURL & url, int);
    virtual void del( const KURL& url, bool);
    virtual void rename( const KURL & src, const KURL & dest, bool);
    virtual void copy( const KURL & src, const KURL & dest, int, bool);
    virtual void put (const KURL &url, int, bool, bool resume);

private:
    QFile logfile;         // the logfile where operations are synchronized between slaves
    QDateTime itunesDBtimestamp;    // timestamp of the iTunesDB file on the iPod (used to detect changes)
    long logfileentrypos;    // the number of logfile entries we already know about

    void fillUDSEntry(const IPod& ipod, KIO::UDSEntry& entry, const QString& name, TrackMetadata& track, long type, bool changed);
    void fillUDSEntry(KIO::UDSEntry& entry, const QString& name, size_t size, long type, bool changed, uint lastmodified, const QString *mimetype = NULL);
    void appendUDSAtom(KIO::UDSEntry& entry, unsigned int uds, long longinfo);
    void appendUDSAtom(KIO::UDSEntry& entry, unsigned int uds, const QString stringinfo);

    /**
     * returns the formated trackname for the given track
     */
    QString formatTrackname( const IPod& ipod, TrackMetadata& track, int tracknum, unsigned short tracknumdigits, bool isPlaylist );

    /**
     * returns the stripped Track title from the given filename (reverse for formatTrackname())
     */
    QString stripTrackname( const QString& trackfilename);

    /**
     * pops up a message that changes need to be synchronized with the sync utility
     */
    void showSyncInfoMessage();

    bool checkError(IPod::IPodError ipodError, const QString& message);

    void updateIPodList();
    bool checkIPod(IPod& ipod);
    class LockedIPodPtr findIPod( const QString& distinctName, bool write_lock );

    void doPut( IPod& ipod, const DirectoryModel& dirmodel );
    void doCopyFromToIPod( const DirectoryModel& src, const DirectoryModel& dest );
    bool doCopyFile( QFile& src_file, QFile& dest_file );

    TrackMetadata * findTrack( const IPod& ipod, const DirectoryModel& dirmodel, int * tracknumber= 0);
    UtilityMap utilitymap;
    QPtrList<IPod> ipods;

};

#endif
