/* mobile.c generated by valac 0.11.6, the Vala compiler
 * generated from mobile.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <connman-manager.h>
#include <connman-service.h>
#include <float.h>
#include <math.h>


#define TYPE_DEVICE_BOX (device_box_get_type ())
#define DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE_BOX, DeviceBox))
#define DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE_BOX, DeviceBoxClass))
#define IS_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE_BOX))
#define IS_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE_BOX))
#define DEVICE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE_BOX, DeviceBoxClass))

typedef struct _DeviceBox DeviceBox;
typedef struct _DeviceBoxClass DeviceBoxClass;
typedef struct _DeviceBoxPrivate DeviceBoxPrivate;

#define TYPE_MOBILE_BOX (mobile_box_get_type ())
#define MOBILE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOBILE_BOX, MobileBox))
#define MOBILE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOBILE_BOX, MobileBoxClass))
#define IS_MOBILE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOBILE_BOX))
#define IS_MOBILE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOBILE_BOX))
#define MOBILE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOBILE_BOX, MobileBoxClass))

typedef struct _MobileBox MobileBox;
typedef struct _MobileBoxClass MobileBoxClass;
typedef struct _MobileBoxPrivate MobileBoxPrivate;

#define TYPE_INFO_BOX (info_box_get_type ())
#define INFO_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INFO_BOX, InfoBox))
#define INFO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INFO_BOX, InfoBoxClass))
#define IS_INFO_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INFO_BOX))
#define IS_INFO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INFO_BOX))
#define INFO_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INFO_BOX, InfoBoxClass))

typedef struct _InfoBox InfoBox;
typedef struct _InfoBoxClass InfoBoxClass;

#define TYPE_TOGGLE_SWITCH (toggle_switch_get_type ())
#define TOGGLE_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_SWITCH, ToggleSwitch))
#define TOGGLE_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_SWITCH, ToggleSwitchClass))
#define IS_TOGGLE_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_SWITCH))
#define IS_TOGGLE_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_SWITCH))
#define TOGGLE_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_SWITCH, ToggleSwitchClass))

typedef struct _ToggleSwitch ToggleSwitch;
typedef struct _ToggleSwitchClass ToggleSwitchClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_EDIT_CONNECTION_DIALOG (edit_connection_dialog_get_type ())
#define EDIT_CONNECTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialog))
#define EDIT_CONNECTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialogClass))
#define IS_EDIT_CONNECTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDIT_CONNECTION_DIALOG))
#define IS_EDIT_CONNECTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDIT_CONNECTION_DIALOG))
#define EDIT_CONNECTION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialogClass))

typedef struct _EditConnectionDialog EditConnectionDialog;
typedef struct _EditConnectionDialogClass EditConnectionDialogClass;

struct _DeviceBox {
	GtkVBox parent_instance;
	DeviceBoxPrivate * priv;
};

struct _DeviceBoxClass {
	GtkVBoxClass parent_class;
};

struct _MobileBox {
	DeviceBox parent_instance;
	MobileBoxPrivate * priv;
};

struct _MobileBoxClass {
	DeviceBoxClass parent_class;
};

struct _MobileBoxPrivate {
	gchar* datadir;
	ConnmanManager* connman;
	InfoBox* infobox;
	ToggleSwitch* toggleswitch;
	GtkLabel* label_status;
	GtkBuilder* builder;
	GtkVBox* vbox_connections;
	GtkButton* button_connect;
	GtkButton* button_forget;
	GtkButton* button_edit;
	GtkScrolledWindow* scrolledwindow_connections;
	ConnmanService* service;
};


static gpointer mobile_box_parent_class = NULL;

GType device_box_get_type (void) G_GNUC_CONST;
GType mobile_box_get_type (void) G_GNUC_CONST;
GType info_box_get_type (void) G_GNUC_CONST;
GType toggle_switch_get_type (void) G_GNUC_CONST;
#define MOBILE_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOBILE_BOX, MobileBoxPrivate))
enum  {
	MOBILE_BOX_DUMMY_PROPERTY
};
MobileBox* mobile_box_new (ConnmanManager* connman, const gchar* datadir);
MobileBox* mobile_box_construct (GType object_type, ConnmanManager* connman, const gchar* datadir);
DeviceBox* device_box_construct (GType object_type);
static void mobile_box_on_cellular_state_changed (MobileBox* self, GParamSpec* p);
static void _mobile_box_on_cellular_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
InfoBox* info_box_new (gboolean homogeneous, gint spacing);
InfoBox* info_box_construct (GType object_type, gboolean homogeneous, gint spacing);
ToggleSwitch* toggle_switch_new (void);
ToggleSwitch* toggle_switch_construct (GType object_type);
static void mobile_box_on_toggleswitch_toggled (MobileBox* self);
static void _mobile_box_on_toggleswitch_toggled_toggle_switch_toggled (ToggleSwitch* _sender, gpointer self);
GtkBuilder* utils_gui_new_builder (const gchar* path);
static void mobile_box_get_widgets (MobileBox* self);
static void mobile_box_connect_signals (MobileBox* self);
static ConnmanService** _vala_array_dup1 (ConnmanService** self, int length);
static void mobile_box_service_state_changed (MobileBox* self);
static void _mobile_box_service_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void mobile_box_update_widget_states (MobileBox* self, ConnmanTechnologyState state);
static void mobile_box_on_button_connect_clicked (MobileBox* self);
static void _mobile_box_on_button_connect_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mobile_box_on_button_edit_clicked (MobileBox* self);
static void _mobile_box_on_button_edit_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void toggle_switch_set_active (ToggleSwitch* self, gboolean active);
gboolean toggle_switch_get_active (ToggleSwitch* self);
EditConnectionDialog* edit_connection_dialog_new (ConnmanService* connection, const gchar* datadir);
EditConnectionDialog* edit_connection_dialog_construct (GType object_type, ConnmanService* connection, const gchar* datadir);
GType edit_connection_dialog_get_type (void) G_GNUC_CONST;
gint edit_connection_dialog_run (EditConnectionDialog* self);
static void mobile_box_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _mobile_box_on_cellular_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	mobile_box_on_cellular_state_changed (self, pspec);
}


static void _mobile_box_on_toggleswitch_toggled_toggle_switch_toggled (ToggleSwitch* _sender, gpointer self) {
	mobile_box_on_toggleswitch_toggled (self);
}


static ConnmanService** _vala_array_dup1 (ConnmanService** self, int length) {
	ConnmanService** result;
	int i;
	result = g_new0 (ConnmanService*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


static void _mobile_box_service_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	mobile_box_service_state_changed (self);
}


MobileBox* mobile_box_construct (GType object_type, ConnmanManager* connman, const gchar* datadir) {
	MobileBox * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	ConnmanManager* _tmp2_;
	ConnmanManager* _tmp3_;
	InfoBox* _tmp4_ = NULL;
	InfoBox* _tmp5_;
	ToggleSwitch* _tmp6_ = NULL;
	ToggleSwitch* _tmp7_;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	gchar* _tmp10_;
	GtkBuilder* _tmp11_ = NULL;
	GtkBuilder* _tmp12_;
	ConnmanService** _tmp13_;
	ConnmanService** _tmp14_ = NULL;
	ConnmanService** _tmp15_;
	ConnmanService** _tmp16_;
	ConnmanService** services;
	gint services_length1;
	gint _services_size_;
	ConnmanTechnologyState _tmp21_;
	g_return_val_if_fail (connman != NULL, NULL);
	g_return_val_if_fail (datadir != NULL, NULL);
	self = (MobileBox*) device_box_construct (object_type);
	gtk_box_set_spacing ((GtkBox*) self, 12);
	_tmp0_ = g_strdup (datadir);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->datadir);
	self->priv->datadir = _tmp1_;
	_tmp2_ = _g_object_ref0 (connman);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->connman);
	self->priv->connman = _tmp3_;
	g_signal_connect_object ((GObject*) self->priv->connman, "notify::cellular-state", (GCallback) _mobile_box_on_cellular_state_changed_g_object_notify, self, 0);
	_tmp4_ = info_box_new (FALSE, 12);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->infobox);
	self->priv->infobox = _tmp5_;
	_tmp6_ = toggle_switch_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->toggleswitch);
	self->priv->toggleswitch = _tmp7_;
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->label_status);
	self->priv->label_status = _tmp9_;
	gtk_misc_set_alignment ((GtkMisc*) self->priv->label_status, (gfloat) 0, 0.5f);
	gtk_container_set_border_width ((GtkContainer*) self->priv->infobox, (guint) 10);
	gtk_box_pack_start ((GtkBox*) self->priv->infobox, (GtkWidget*) self->priv->label_status, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->infobox, (GtkWidget*) self->priv->toggleswitch, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->infobox, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (self->priv->toggleswitch, "toggled", (GCallback) _mobile_box_on_toggleswitch_toggled_toggle_switch_toggled, self, 0);
	_tmp10_ = g_strconcat (datadir, "ui/mobile_box.ui", NULL);
	_tmp11_ = utils_gui_new_builder (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp12_;
	_g_free0 (_tmp10_);
	mobile_box_get_widgets (self);
	mobile_box_connect_signals (self);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->vbox_connections, TRUE, TRUE, (guint) 0);
	_tmp14_ = _tmp13_ = connman_manager_get_services (connman);
	_tmp15_ = (_tmp16_ = _tmp14_, (_tmp16_ == NULL) ? ((gpointer) _tmp16_) : _vala_array_dup1 (_tmp16_, _vala_array_length (_tmp13_)));
	services = _tmp15_;
	services_length1 = _vala_array_length (_tmp13_);
	_services_size_ = _vala_array_length (_tmp13_);
	{
		ConnmanService** service_collection;
		int service_collection_length1;
		int service_it;
		service_collection = services;
		service_collection_length1 = services_length1;
		for (service_it = 0; service_it < services_length1; service_it = service_it + 1) {
			ConnmanService* _tmp17_;
			ConnmanService* service;
			_tmp17_ = _g_object_ref0 (service_collection[service_it]);
			service = _tmp17_;
			{
				ConnmanServiceType _tmp18_;
				_tmp18_ = connman_service_get_service_type (service);
				if (_tmp18_ == CONNMAN_SERVICE_TYPE_CELLULAR) {
					ConnmanService* _tmp19_;
					ConnmanService* _tmp20_;
					_tmp19_ = _g_object_ref0 (service);
					_tmp20_ = _tmp19_;
					_g_object_unref0 (self->priv->service);
					self->priv->service = _tmp20_;
					g_signal_connect_object ((GObject*) service, "notify::state", (GCallback) _mobile_box_service_state_changed_g_object_notify, self, 0);
					_g_object_unref0 (service);
					break;
				}
				_g_object_unref0 (service);
			}
		}
	}
	_tmp21_ = connman_manager_get_cellular_state (self->priv->connman);
	mobile_box_update_widget_states (self, _tmp21_);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_object_unref), NULL);
	return self;
}


MobileBox* mobile_box_new (ConnmanManager* connman, const gchar* datadir) {
	return mobile_box_construct (TYPE_MOBILE_BOX, connman, datadir);
}


static void mobile_box_get_widgets (MobileBox* self) {
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_;
	GtkVBox* _tmp2_;
	GtkVBox* _tmp3_;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GObject* _tmp12_ = NULL;
	GObject* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GObject* _tmp16_ = NULL;
	GObject* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GtkScrolledWindow* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "vbox_connections");
	_tmp2_ = _g_object_ref0 ((_tmp1_ = _tmp0_, GTK_IS_VBOX (_tmp1_) ? ((GtkVBox*) _tmp1_) : NULL));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->vbox_connections);
	self->priv->vbox_connections = _tmp3_;
	_tmp4_ = gtk_builder_get_object (self->priv->builder, "button_connect");
	_tmp6_ = _g_object_ref0 ((_tmp5_ = _tmp4_, GTK_IS_BUTTON (_tmp5_) ? ((GtkButton*) _tmp5_) : NULL));
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->button_connect);
	self->priv->button_connect = _tmp7_;
	_tmp8_ = gtk_builder_get_object (self->priv->builder, "button_forget");
	_tmp10_ = _g_object_ref0 ((_tmp9_ = _tmp8_, GTK_IS_BUTTON (_tmp9_) ? ((GtkButton*) _tmp9_) : NULL));
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->priv->button_forget);
	self->priv->button_forget = _tmp11_;
	_tmp12_ = gtk_builder_get_object (self->priv->builder, "button_edit");
	_tmp14_ = _g_object_ref0 ((_tmp13_ = _tmp12_, GTK_IS_BUTTON (_tmp13_) ? ((GtkButton*) _tmp13_) : NULL));
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->button_edit);
	self->priv->button_edit = _tmp15_;
	_tmp16_ = gtk_builder_get_object (self->priv->builder, "scrolledwindow_connections");
	_tmp18_ = _g_object_ref0 ((_tmp17_ = _tmp16_, GTK_IS_SCROLLED_WINDOW (_tmp17_) ? ((GtkScrolledWindow*) _tmp17_) : NULL));
	_tmp19_ = _tmp18_;
	_g_object_unref0 (self->priv->scrolledwindow_connections);
	self->priv->scrolledwindow_connections = _tmp19_;
}


static void _mobile_box_on_button_connect_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mobile_box_on_button_connect_clicked (self);
}


static void _mobile_box_on_button_edit_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mobile_box_on_button_edit_clicked (self);
}


static void mobile_box_connect_signals (MobileBox* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->priv->button_connect, "clicked", (GCallback) _mobile_box_on_button_connect_clicked_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->button_edit, "clicked", (GCallback) _mobile_box_on_button_edit_clicked_gtk_button_clicked, self, 0);
}


static void mobile_box_update_widget_states (MobileBox* self, ConnmanTechnologyState state) {
	gboolean device_editable;
	gboolean settings_editable;
	gboolean toggleswitch_state;
	gchar* _tmp0_;
	gchar* status_text;
	gchar* _tmp1_;
	gchar* connect;
	ConnmanServiceState _tmp10_;
	g_return_if_fail (self != NULL);
	device_editable = FALSE;
	settings_editable = FALSE;
	toggleswitch_state = FALSE;
	_tmp0_ = g_strdup ("");
	status_text = _tmp0_;
	_tmp1_ = g_strdup ("");
	connect = _tmp1_;
	switch (state) {
		case CONNMAN_TECHNOLOGY_STATE_ENABLED:
		{
			gchar* _tmp2_;
			gchar* _tmp3_;
			device_editable = TRUE;
			settings_editable = TRUE;
			toggleswitch_state = TRUE;
			_tmp2_ = g_strdup ("Mobile Broadband is enabled.");
			_tmp3_ = _tmp2_;
			_g_free0 (status_text);
			status_text = _tmp3_;
			break;
		}
		case CONNMAN_TECHNOLOGY_STATE_CONNECTED:
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			device_editable = TRUE;
			settings_editable = TRUE;
			toggleswitch_state = TRUE;
			_tmp4_ = g_strdup ("Connected to the Internet.");
			_tmp5_ = _tmp4_;
			_g_free0 (status_text);
			status_text = _tmp5_;
			break;
		}
		case CONNMAN_TECHNOLOGY_STATE_AVAILABLE:
		{
			gchar* _tmp6_;
			gchar* _tmp7_;
			device_editable = TRUE;
			settings_editable = FALSE;
			toggleswitch_state = FALSE;
			_tmp6_ = g_strdup ("The Mobile Broadband device is powered off.");
			_tmp7_ = _tmp6_;
			_g_free0 (status_text);
			status_text = _tmp7_;
			break;
		}
		case CONNMAN_TECHNOLOGY_STATE_OFFLINE:
		{
			gchar* _tmp8_;
			gchar* _tmp9_;
			device_editable = TRUE;
			settings_editable = FALSE;
			toggleswitch_state = FALSE;
			_tmp8_ = g_strdup ("Mobile Broadband is offline.");
			_tmp9_ = _tmp8_;
			_g_free0 (status_text);
			status_text = _tmp9_;
			break;
		}
		default:
		break;
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->vbox_connections, settings_editable);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->toggleswitch, device_editable);
	toggle_switch_set_active (self->priv->toggleswitch, toggleswitch_state);
	gtk_label_set_text (self->priv->label_status, status_text);
	if (self->priv->service == NULL) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_connect, FALSE);
		_g_free0 (connect);
		_g_free0 (status_text);
		return;
	}
	_tmp10_ = connman_service_get_state (self->priv->service);
	switch (_tmp10_) {
		case CONNMAN_SERVICE_STATE_ASSOCIATION:
		case CONNMAN_SERVICE_STATE_CONFIGURATION:
		case CONNMAN_SERVICE_STATE_READY:
		case CONNMAN_SERVICE_STATE_ONLINE:
		{
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = g_strdup ("Disconnect");
			_tmp12_ = _tmp11_;
			_g_free0 (connect);
			connect = _tmp12_;
			break;
		}
		default:
		{
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = g_strdup ("Connect");
			_tmp14_ = _tmp13_;
			_g_free0 (connect);
			connect = _tmp14_;
			break;
		}
	}
	gtk_button_set_label (self->priv->button_connect, connect);
	_g_free0 (connect);
	_g_free0 (status_text);
}


static void mobile_box_on_cellular_state_changed (MobileBox* self, GParamSpec* p) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_cellular_state (self->priv->connman);
	mobile_box_update_widget_states (self, _tmp0_);
}


static void mobile_box_service_state_changed (MobileBox* self) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_manager_get_cellular_state (self->priv->connman);
	mobile_box_update_widget_states (self, _tmp0_);
}


static void mobile_box_on_toggleswitch_toggled (MobileBox* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = toggle_switch_get_active (self->priv->toggleswitch);
	if (_tmp0_) {
		connman_manager_enable_technology (self->priv->connman, CONNMAN_TECHNOLOGY_TYPE_CELLULAR, NULL, NULL, NULL);
	} else {
		connman_manager_disable_technology (self->priv->connman, CONNMAN_TECHNOLOGY_TYPE_CELLULAR, NULL, NULL, NULL);
	}
}


static void mobile_box_on_button_connect_clicked (MobileBox* self) {
	ConnmanServiceState _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->service == NULL) {
		return;
	}
	_tmp0_ = connman_service_get_state (self->priv->service);
	switch (_tmp0_) {
		case CONNMAN_SERVICE_STATE_ASSOCIATION:
		case CONNMAN_SERVICE_STATE_CONFIGURATION:
		case CONNMAN_SERVICE_STATE_READY:
		case CONNMAN_SERVICE_STATE_ONLINE:
		{
			connman_service_disconnect (self->priv->service, NULL, NULL);
			break;
		}
		default:
		{
			connman_service_connect (self->priv->service, NULL, NULL);
			break;
		}
	}
}


static void mobile_box_on_button_edit_clicked (MobileBox* self) {
	EditConnectionDialog* _tmp0_ = NULL;
	EditConnectionDialog* dialog;
	g_return_if_fail (self != NULL);
	if (self->priv->service == NULL) {
		return;
	}
	_tmp0_ = edit_connection_dialog_new (self->priv->service, self->priv->datadir);
	dialog = _tmp0_;
	edit_connection_dialog_run (dialog);
	_g_object_unref0 (dialog);
}


static void mobile_box_class_init (MobileBoxClass * klass) {
	mobile_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MobileBoxPrivate));
	G_OBJECT_CLASS (klass)->finalize = mobile_box_finalize;
}


static void mobile_box_instance_init (MobileBox * self) {
	self->priv = MOBILE_BOX_GET_PRIVATE (self);
}


static void mobile_box_finalize (GObject* obj) {
	MobileBox * self;
	self = MOBILE_BOX (obj);
	_g_free0 (self->priv->datadir);
	_g_object_unref0 (self->priv->connman);
	_g_object_unref0 (self->priv->infobox);
	_g_object_unref0 (self->priv->toggleswitch);
	_g_object_unref0 (self->priv->label_status);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->vbox_connections);
	_g_object_unref0 (self->priv->button_connect);
	_g_object_unref0 (self->priv->button_forget);
	_g_object_unref0 (self->priv->button_edit);
	_g_object_unref0 (self->priv->scrolledwindow_connections);
	_g_object_unref0 (self->priv->service);
	G_OBJECT_CLASS (mobile_box_parent_class)->finalize (obj);
}


GType mobile_box_get_type (void) {
	static volatile gsize mobile_box_type_id__volatile = 0;
	if (g_once_init_enter (&mobile_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MobileBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mobile_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MobileBox), 0, (GInstanceInitFunc) mobile_box_instance_init, NULL };
		GType mobile_box_type_id;
		mobile_box_type_id = g_type_register_static (TYPE_DEVICE_BOX, "MobileBox", &g_define_type_info, 0);
		g_once_init_leave (&mobile_box_type_id__volatile, mobile_box_type_id);
	}
	return mobile_box_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



