/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONNMAN_PROXY_H_
#define _CONNMAN_PROXY_H_

#include <glib-object.h>
#include <gio/gio.h>

#include "connman-service.h"

G_BEGIN_DECLS

#define CONNMAN_TYPE_MANAGER connman_manager_get_type()

#define CONNMAN_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), CONNMAN_TYPE_MANAGER, ConnmanManager))

#define CONNMAN_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), CONNMAN_TYPE_MANAGER, ConnmanManagerClass))

#define CONNMAN_IS_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), CONNMAN_TYPE_MANAGER))

#define CONNMAN_IS_PROXY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), CONNMAN_TYPE_MANAGER))

#define CONNMAN_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), CONNMAN_TYPE_MANAGER, ConnmanManagerClass))

typedef struct {
  GObject parent;
} ConnmanManager;

typedef struct {
  GObjectClass parent_class;
} ConnmanManagerClass;

typedef enum {
  CONNMAN_TECHNOLOGY_TYPE_UNKNOWN,
  CONNMAN_TECHNOLOGY_TYPE_ETHERNET,
  CONNMAN_TECHNOLOGY_TYPE_WIFI,
  CONNMAN_TECHNOLOGY_TYPE_BLUETOOTH,
  CONNMAN_TECHNOLOGY_TYPE_CELLULAR,
} ConnmanTechnologyType;

typedef enum {
  CONNMAN_TECHNOLOGY_STATE_UNKNOWN,
  CONNMAN_TECHNOLOGY_STATE_UNAVAILABLE,
  CONNMAN_TECHNOLOGY_STATE_AVAILABLE,
  CONNMAN_TECHNOLOGY_STATE_OFFLINE,
  CONNMAN_TECHNOLOGY_STATE_ENABLED,
  CONNMAN_TECHNOLOGY_STATE_CONNECTED,
} ConnmanTechnologyState;

GType connman_manager_get_type(void);

void connman_manager_enable_technology(ConnmanManager *self,
				       ConnmanTechnologyType type,
				       GCancellable *cancellable,
				       GAsyncReadyCallback callback,
				       gpointer user_data);
void connman_manager_enable_technology_finish(ConnmanManager *self,
					      GAsyncResult *res,
					      GError **error);
void connman_manager_disable_technology(ConnmanManager *self,
					ConnmanTechnologyType type,
					GCancellable *cancellable,
					GAsyncReadyCallback callback,
					gpointer user_data);
void connman_manager_disable_technology_finish(ConnmanManager *self,
					       GAsyncResult *res,
					       GError **error);
void connman_manager_connect_service(ConnmanManager *self,
				     ConnmanServiceType type,
				     ConnmanServiceMode mode,
				     ConnmanServiceSecurity security,
				     guint8 *ssid,
				     guint ssid_len,
				     GCancellable *cancellable,
				     GAsyncReadyCallback callback,
				     gpointer user_data);
void connman_manager_connect_service_finish(ConnmanManager *self,
					    GAsyncResult *res,
					    GError **error);
gboolean connman_manager_get_connected(ConnmanManager *self);
ConnmanService **connman_manager_get_services(ConnmanManager *self);
ConnmanService *connman_manager_get_service(ConnmanManager *self,
					    const gchar *path);
ConnmanService *connman_manager_get_default_service(ConnmanManager *self);
ConnmanTechnologyState connman_manager_get_wifi_state(ConnmanManager *self);
ConnmanTechnologyState connman_manager_get_ethernet_state(ConnmanManager *self);
ConnmanTechnologyState connman_manager_get_cellular_state(ConnmanManager *self);
ConnmanTechnologyState connman_manager_get_bluetooth_state(ConnmanManager *self);
gboolean connman_manager_get_offline_mode(ConnmanManager *self);
void connman_manager_set_offline_mode(ConnmanManager *self, gboolean mode);
ConnmanManager *connman_manager_new(void);

#endif
