/* utils.c generated by valac 0.12.0, the Vala compiler
 * generated from utils.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



gdouble utils_max (gdouble* data, int data_length1);
gdouble utils_mean (gdouble* data, int data_length1);
gchar* utils_format_size (gdouble val);
gchar* utils_format_speed (gdouble val);


gdouble utils_max (gdouble* data, int data_length1) {
	gdouble result = 0.0;
	gdouble _result_;
	if (data_length1 == 0) {
		result = (gdouble) 0;
		return result;
	}
	_result_ = data[0];
	{
		gdouble* v_collection;
		int v_collection_length1;
		int v_it;
		v_collection = data;
		v_collection_length1 = data_length1;
		for (v_it = 0; v_it < data_length1; v_it = v_it + 1) {
			gdouble v;
			v = v_collection[v_it];
			{
				if (_result_ < v) {
					_result_ = v;
				}
			}
		}
	}
	result = _result_;
	return result;
}


gdouble utils_mean (gdouble* data, int data_length1) {
	gdouble result = 0.0;
	gdouble _result_;
	if (data_length1 == 0) {
		result = (gdouble) 0;
		return result;
	}
	_result_ = (gdouble) 0;
	{
		gdouble* v_collection;
		int v_collection_length1;
		int v_it;
		v_collection = data;
		v_collection_length1 = data_length1;
		for (v_it = 0; v_it < data_length1; v_it = v_it + 1) {
			gdouble v;
			v = v_collection[v_it];
			{
				_result_ = _result_ + v;
			}
		}
	}
	result = _result_ / data_length1;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch10_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch10_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* utils_format_size (gdouble val) {
	gchar* result = NULL;
	static const gchar* units[] = {"{} kB", "{} MB", "{} GB"};
	gint index;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* pattern;
	gchar* _tmp8_ = NULL;
	index = -1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if ((index + 1) < G_N_ELEMENTS (units)) {
			_tmp0_ = val >= 1000;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		val = val / ((gdouble) 1000);
		index = index + 1;
	}
	if (index < 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = ngettext ("%u byte", "%u bytes", (gulong) val);
		_tmp2_ = g_strdup_printf (_tmp1_, (guint) val);
		result = _tmp2_;
		return result;
	}
	if (val < 9.9995) {
		_tmp3_ = "%.3f";
	} else {
		const gchar* _tmp4_ = NULL;
		if (val < 99.995) {
			_tmp4_ = "%.2f";
		} else {
			const gchar* _tmp5_ = NULL;
			if (val < 999.95) {
				_tmp5_ = "%.1f";
			} else {
				_tmp5_ = "%.0f";
			}
			_tmp4_ = _tmp5_;
		}
		_tmp3_ = _tmp4_;
	}
	_tmp6_ = _ (units[index]);
	_tmp7_ = string_replace (_tmp6_, "{}", _tmp3_);
	pattern = _tmp7_;
	_tmp8_ = g_strdup_printf (pattern, val);
	result = _tmp8_;
	_g_free0 (pattern);
	return result;
}


gchar* utils_format_speed (gdouble val) {
	gchar* result = NULL;
	static const gchar* units[] = {"{} kB/s", "{} MB/s", "{} GB/s", "{} TB/s"};
	gint index;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* pattern;
	gchar* _tmp8_ = NULL;
	index = -1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if ((index + 1) < G_N_ELEMENTS (units)) {
			_tmp0_ = val >= 1000;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		val = val / ((gdouble) 1000);
		index = index + 1;
	}
	if (index < 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = ngettext ("%u byte/s", "%u bytes/s", (gulong) val);
		_tmp2_ = g_strdup_printf (_tmp1_, (guint) val);
		result = _tmp2_;
		return result;
	}
	if (val < 9.9995) {
		_tmp3_ = "%.3f";
	} else {
		const gchar* _tmp4_ = NULL;
		if (val < 99.995) {
			_tmp4_ = "%.2f";
		} else {
			const gchar* _tmp5_ = NULL;
			if (val < 999.95) {
				_tmp5_ = "%.1f";
			} else {
				_tmp5_ = "%.0f";
			}
			_tmp4_ = _tmp5_;
		}
		_tmp3_ = _tmp4_;
	}
	_tmp6_ = _ (units[index]);
	_tmp7_ = string_replace (_tmp6_, "{}", _tmp3_);
	pattern = _tmp7_;
	_tmp8_ = g_strdup_printf (pattern, val);
	result = _tmp8_;
	_g_free0 (pattern);
	return result;
}



