#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2010 Sebastian MacDonald Sebas310@gmail.com
# Copyright (C) 2010 Mehdi Rejraji mehd36@gmail.com
# Copyright (C) 2011 Vadim Rutkovsky roignac@gmail.com
# Copyright (C) 2013 Zhang Zhao vaguedream@hotmail.com
# Copyright (C) 2013 Kobe Lee kobe24_lixiang@126.com
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import os,sys
from PyQt4 import QtCore, QtGui, uic
import pycwapi

PROJECT_ROOT_DIRECTORY = os.path.abspath(
    os.path.dirname(os.path.dirname(os.path.realpath(sys.argv[0]))))

class Forecast(QtGui.QDialog):
    def __init__(self, forecast_data):
        super(Forecast, self).__init__()
        uic.loadUi(os.path.join(PROJECT_ROOT_DIRECTORY, 'data/ui/forecast.ui'), self)
        self.img_ct1.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/ct1.gif')))
        self.img_ct2.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/ct1.gif')))
        self.img_uv.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/uv1.gif')))
        self.img_xc.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/xc1.gif')))
        self.img_tr.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/tr1.gif')))
        self.img_cl.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/cl1.gif')))
        self.img_ls.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/ls1.gif')))
        self.img_ag.setPixmap(QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/ag.jpg')))

        self.forecast_data = forecast_data

    def update_forecast(self):
        self.img1.setPixmap(self.get_pixmap('img1'))
        self.img2.setPixmap(self.get_pixmap('img2'))
        self.img3.setPixmap(self.get_pixmap('img3'))
        self.img4.setPixmap(self.get_pixmap('img4'))
        self.img5.setPixmap(self.get_pixmap('img5'))
        self.img6.setPixmap(self.get_pixmap('img6'))
        self.img7.setPixmap(self.get_pixmap('img7'))
        self.img8.setPixmap(self.get_pixmap('img8'))
        self.img9.setPixmap(self.get_pixmap('img9'))
        self.img10.setPixmap(self.get_pixmap('img10'))
        self.img11.setPixmap(self.get_pixmap('img11'))
        self.img12.setPixmap(self.get_pixmap('img12'))

        self.weather1.setText(self.forecast_data['weather1'])
        self.weather2.setText(self.forecast_data['weather2'])
        self.weather3.setText(self.forecast_data['weather3'])
        self.weather4.setText(self.forecast_data['weather4'])
        self.weather5.setText(self.forecast_data['weather5'])
        self.weather6.setText(self.forecast_data['weather6'])

        self.temp1.setText(self.forecast_data['temp1'])
        self.temp2.setText(self.forecast_data['temp2'])
        self.temp3.setText(self.forecast_data['temp3'])
        self.temp4.setText(self.forecast_data['temp4'])
        self.temp5.setText(self.forecast_data['temp5'])
        self.temp6.setText(self.forecast_data['temp6'])

        self.wind1.setText(self.forecast_data['wind1'])
        self.wind2.setText(self.forecast_data['wind2'])
        self.wind3.setText(self.forecast_data['wind3'])
        self.wind4.setText(self.forecast_data['wind4'])
        self.wind5.setText(self.forecast_data['wind5'])
        self.wind6.setText(self.forecast_data['wind6'])

        self.index.setText(self.forecast_data['index'])
        self.index48.setText(self.forecast_data['index48'])
        self.index_d.setText(self.forecast_data['index_d'])
        self.index48_d.setText(self.forecast_data['index48_d'])
        self.index_uv.setText(self.forecast_data['index_uv'])
        self.index_xc.setText(self.forecast_data['index_xc'])
        self.index_tr.setText(self.forecast_data['index_tr'])
        self.index_cl.setText(self.forecast_data['index_cl'])
        self.index_ls.setText(self.forecast_data['index_ls'])
        self.index_ag.setText(self.forecast_data['index_ag'])

    def get_pixmap(self, img):
        icons_day = ('img1', 'img3', 'img5', 'img7', 'img9', 'img11')
        icons_night = ('img2', 'img4', 'img6', 'img8', 'img10', 'img12')
        
        if img in icons_day:
            return QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/d') + self.forecast_data[img] + '.gif')
        elif img in icons_night:
            if self.forecast_data[img] == '99':
                return QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/n') + self.forecast_data[icons_day[icons_night.index(img)]] + '.gif')
            else:
                return QtGui.QPixmap(os.path.join(PROJECT_ROOT_DIRECTORY, 'icons/n') + self.forecast_data[img] + '.gif')

def show_forecast(forecast_data):
    app = QtGui.QApplication(sys.argv)
    f = Forecast(forecast_data)
    f.update_forecast()
    f.show()
    app.exec_()
        
if __name__ == "__main__":
    forecast_data = pycwapi.get_weather_from_nmc(sys.argv[1], 1)
    show_forecast(forecast_data)

