#
# Copyright 2009 Canonical Ltd.
#
# Written by:
#     Gustavo Niemeyer <gustavo.niemeyer@canonical.com>
#     Sidnei da Silva <sidnei.da.silva@canonical.com>
#
# This file is part of the Image Store Proxy.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
import copy
import json


class MissingValueError(ValueError):
    pass


class JSONObject(dict):

    required = ()
    subtypes = {}

    def __init__(self, *args, **kwargs):
        if len(args) == 1 and isinstance(args[0], basestring):
            args = (json.loads(args[0]),)
        dict.__init__(self, *args, **kwargs)

        for name in self.required:
            if name not in self:
                raise MissingValueError("%r is required for %s" %
                                        (name, self.__class__.__name__))

        for name in self.subtypes:
            if name in self:
                subtype = self.subtypes[name]
                value = self[name]
                if isinstance(value, list):
                    new_value = []
                    for item in value:
                        if not isinstance(item, subtype):
                            new_value.append(subtype(item))
                        else:
                            new_value.append(item)
                    self[name] = new_value
                else:
                    if not isinstance(value, subtype):
                        self[name] = subtype(value)

    def __str__(self):
        return json.dumps(self)

    def __eq__(self, other):
        if not type(other) is type(self):
            return False
        return super(JSONObject, self).__eq__(other)

    def copy(self):
        return copy.deepcopy(self)

    def toDict(self):
        return json.loads(json.dumps(self))
