#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_preedit_start_reply_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_int32		maximum_length)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_PREEDIT_START_REPLY;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.preedit_start_reply.maximum_length = maximum_length;
    return m;
}


void
iiimp_preedit_start_reply_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
    if (NULL == m) return;
    free(m);
    return;
}


uchar_t *
iiimp_preedit_start_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_int32		maximum_length,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* input context id */
    nbyte += 4;	/* max length of preedit string */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_PREEDIT_START_REPLY, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU32(maximum_length, rest, p, data_s->byte_swap);

    return buf;
}


IIIMP_message *
iiimp_preedit_start_reply_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_preedit_start_reply_v *	v;
    size_t				rest;
    const uchar_t *			p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.preedit_start_reply);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);
    GET32(v->maximum_length, rest, p, data_s->byte_swap);

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_preedit_start_reply_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    (void)fprintf(data_s->print_fp, "\tmax length of preedit string=%d\n",
		  m->v.preedit_start_reply.maximum_length);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
