#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <locale.h>

#include "encode.h"
#include "phonetic_im.h"
#include "logf.h"

#define MAX_LINE_LEN  256

int lineno = 0;

char *skip_space(char *s)
{
        while (*s && (*s==' ' || *s=='\t')) s++;
        return s;
}

int LoadTableHeader (file_name, indic_table)
char *file_name;
TableStruct *indic_table;
{
	FILE *ifile;
  char line_buf[256], line[MAX_LINE_LEN];
  char *key, *value_str;
  register char *ptr;
  int len, line_index;
  int flag_section = DEFAULT_SECTION;

	log_f("phonetic_table: ==== LoadTableHeader ====\n");

	/* read table from file to memory buffer  */
	ifile = fopen (file_name, "r");
	if (! ifile) {
    fprintf(stderr, "Unable to open the input table file \"%s\"\n",file_name);
    return(-1);
  }

  while(fgets(line_buf, 255, ifile) != NULL) {
    lineno++;

    if((line_buf[0] == '#') && (line_buf[1] == '#')){
      log_f("COMMENTS \n");
      continue;
    }

		value_str = line_buf;
		ptr = skip_space(value_str);

		if (*ptr == '\0') break;

		/* if is space line, get new line 
		if (flag_section != COMMENT_SECTION) {
			if (*ptr == '\n')
				continue;
		}
    */

		line_index = 0;
		while(*ptr != '\n' && *ptr != '\0' && line_index < MAX_LINE_LEN) 
			line[line_index++] = *ptr++;

		/* trim right space */
		while (line_index > 0 && isspace(line[line_index-1])) line_index--;
		line[line_index] = '\0';

		key = line;
		len = strlen(line);
		log_f("len:%d, %s\n", strlen(line), line);
		if (line[0] == '[' && line[len-1] == ']') {
			/* get section name of the item */
			ptr = line + 1;
			while(isspace(*ptr)) ptr++;
			key = ptr;

			ptr = line + len - 2;
			while(isspace(*ptr)) ptr--;
			*(ptr+1) = '\0';

			if (!*key) continue;

			if (!(strncasecmp(key, DESCRIPTION_STR, strlen(DESCRIPTION_STR)))) {
				flag_section = DESCRIPTION_SECTION;
				continue;
	   	} 
		}

    switch (flag_section) {
		  case DEFAULT_SECTION:
			   break;

		  case DESCRIPTION_SECTION:
         if(!(strncasecmp(key, LOCALE_STR, strlen(LOCALE_STR)))) {
              value_str = skip_space(key+strlen(LOCALE_STR));
              if ((*value_str == '\0') || (*value_str == '\n'))
                      continue;
              strcpy(indic_table->Lname, value_str);
              break;
         }

			if (!(strncasecmp(key, NAME_STR, strlen(NAME_STR)))) {
				value_str = skip_space(key+strlen(NAME_STR));
				if ((*value_str == '\0') || (*value_str == '\n'))
					continue;

				strcpy(indic_table->Cname, value_str);
				break;
			}

			if (!(strncasecmp(key, ENCODE_STR, strlen(ENCODE_STR)))) {
				value_str = skip_space(key+strlen(ENCODE_STR));
				if ((*value_str == '\0') || (*value_str == '\n'))
					continue;

				indic_table->Encode = get_encodeid_from_name(value_str);
				indic_table->Output_Encode = indic_table->Encode;
				break;
			}

			if (!(strncasecmp(key, FUNCTION_STR, strlen(FUNCTION_STR)))) {
				value_str = skip_space(key+strlen(FUNCTION_STR));
				if ((*value_str == '\0') || (*value_str == '\n'))
					continue;

				strcpy(indic_table->Fname, value_str);
				break;
			}

			if (!(strncasecmp(key, USEDCODES_STR, strlen(USEDCODES_STR)))) {
				value_str = skip_space(key+strlen(USEDCODES_STR));
				if ((*value_str == '\0') || (*value_str == '\n'))
					continue;

				strncpy(indic_table->UsedCodes, value_str, MAX_USEDCODES_NUM);
				break;
			}
		}
	} 
  fclose (ifile);
  return(0);
}
