/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "zhuyin_standard.h"

static char *ZhuyinSymbol[NUM_OF_ZHUYIN_SYMBOL + 1] = {
  NULL, 
  "ㄅ", "ㄆ", "ㄇ", "ㄈ", "ㄉ", "ㄊ", "ㄋ", "ㄌ", "ㄍ", "ㄎ",
  "ㄏ", "ㄐ", "ㄑ", "ㄒ", "ㄓ", "ㄔ", "ㄕ", "ㄖ", "ㄗ", "ㄘ",
  "ㄙ",  /* 21 */             /* 1-21 */
  "ㄧ", "ㄨ", "ㄩ", /* 24 */   /* 1-3  */
  "ㄚ", "ㄛ", "ㄜ", "ㄝ", "ㄞ", "ㄟ", "ㄠ", "ㄡ", "ㄢ", "ㄣ",
  "ㄤ", "ㄥ", "ㄦ", /* 37 */   /* 1-13 */
  "ˉ", "ˊ", "ˇ", "ˋ", "˙", /* 1-5  */
};

static char StandardKeyMap[NUM_OF_ZHUYIN_SYMBOL + 1] = {
  0,
  '1', 'q', 'a', 'z', '2', 'w', 's', 'x', 'e', 'd',
  'c', 'r', 'f', 'v', '5', 't', 'g', 'b', 'y', 'h',
  'n', 'u', 'j', 'm', '8', 'i', 'k', ',', '9', 'o',
  'l', '.', '0', 'p', ';', '/', '-', ' ', '6', '3',
  '4', '7',
};

/*
 * return the Zhuyin symbol represents the Zhuyin number
 */
unsigned char *ZhuyinIndexToZhuyinSymbol(int idx)
{
	if (idx <= 0 || idx > NUM_OF_ZHUYIN_SYMBOL) {
		return(NULL);
	}
	return((unsigned char *)ZhuyinSymbol[idx]);
}

/*
 * return the Zhuyin key represents the Zhuyin symbol
 */
char ZhuyinIndexToStandardKey(int idx)
{
	if (idx <= 0 || idx > NUM_OF_ZHUYIN_SYMBOL) {
		return(0);
	}
	return(StandardKeyMap[idx]);
}

/*
 * return type of the Zhuyin index
 */
int ZhuyinIndexToZhuyinType(int idx)
{
	if (idx <= 0 || idx > NUM_OF_ZHUYIN_SYMBOL) {
		return(ZHUYIN_TYPE_ERROR);
	}

	if (idx >= 1 && idx <= 21) {
		return(ZHUYIN_TYPE_CONSONANT);
	} else if (idx >= 22 && idx <= 24) {
		return(ZHUYIN_TYPE_VOWEL1);
	} else if (idx >= 25 && idx <= 37) {
		return(ZHUYIN_TYPE_VOWEL2);
	} else if (idx >= 38 && idx <= 42) {
		return(ZHUYIN_TYPE_TONE);
	}

	return(ZHUYIN_TYPE_ERROR);
}

/*
 * return index of the Zhuyin symbol
 */
int ZhuyinSymbolToZhuyinIndex(unsigned char *sym)
{
	int idx;

	if (sym == NULL) return(0);

	for (idx = 1; idx <= NUM_OF_ZHUYIN_SYMBOL; idx++) {
		if (!strncmp((char *)sym, (char *)ZhuyinSymbol[idx], strlen(ZhuyinSymbol[idx]))) {
			return(idx);
		}
	}
	return(0);
}

/*
 * return type of the Zhuyin symbol
 */
int ZhuyinSymbolToZhuyinType(unsigned char *sym)
{
	int idx = ZhuyinSymbolToZhuyinIndex(sym);

	return(ZhuyinIndexToZhuyinType(idx));
}

/*
 * return key of the Zhuyin symbol
 */
char ZhuyinSymbolToStandardKey(unsigned char *sym)
{
	int idx = ZhuyinSymbolToZhuyinIndex(sym);

	return(ZhuyinIndexToStandardKey(idx));
}

/*
 * return index of the Zhuyin Key
 */
int ZhuyinKeyToZhuyinIndex(char key)
{
	int idx;

	for (idx = 1; idx <= NUM_OF_ZHUYIN_SYMBOL; idx++) {
		if (key == StandardKeyMap[idx]) {
			return(idx);
		}
	}
	return(0);
}

/*
 * return the Zhuyin symbol represents the Zhuyin key
 */
unsigned char *ZhuyinKeyToZhuyinSymbol(char key)
{
	int idx = ZhuyinKeyToZhuyinIndex(key);
	return((unsigned char *)ZhuyinSymbol[idx]);
}

/*
 * return the Zhuyin type represents the Zhuyin key
 */
int ZhuyinKeyToZhuyinType(char key)
{
	int idx = ZhuyinKeyToZhuyinIndex(key);
	return(ZhuyinIndexToZhuyinType(idx));
}

int ZhuyinSymbolSequenceToStandardKeySequence(unsigned char *sym_sequence, char *key_sequence, int *sym_len)
{
	int i, idx;
	unsigned char *sym_ptr = sym_sequence;
	char *key_ptr = key_sequence;

	i = 0;
	while (i++ < 4) {
		idx = ZhuyinSymbolToZhuyinIndex(sym_ptr);
		if (idx == 0) break;

		*key_ptr++ = StandardKeyMap[idx];
		sym_ptr += strlen((char *)ZhuyinSymbol[idx]);
	}

	*key_ptr = '\0';
	*sym_len = (sym_ptr - sym_sequence);

	return(0);
}
