/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "zhuyin_standard.h"
#include "zhuyin_keymap.h"

int ZhuyinKeymapList_Init(TZhuyinKeymapList *pZhuyinKeymapList)
{
	pZhuyinKeymapList->nNum_Keymaps = 0;
	pZhuyinKeymapList->nNum_Keymaps_Alloced = 0;
	pZhuyinKeymapList->pKeymaps = NULL;

	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Free(TZhuyinKeymapList *pZhuyinKeymapList)
{
	int i;

	if (pZhuyinKeymapList->pKeymaps == NULL) {
		return(0);
	}

	for(i=0; i<pZhuyinKeymapList->nNum_Keymaps_Alloced; i++) {
		if (pZhuyinKeymapList->pKeymaps[i]== NULL)
			continue;

		if (pZhuyinKeymapList->pKeymaps[i]->pName) {
			free((char *)pZhuyinKeymapList->pKeymaps[i]->pName);
		}

		if (pZhuyinKeymapList->pKeymaps[i]->pKeymap) {
			free((char *)pZhuyinKeymapList->pKeymaps[i]->pKeymap);
		}

		free((char *)pZhuyinKeymapList->pKeymaps[i]);
	}

	free((char *)pZhuyinKeymapList->pKeymaps);

	pZhuyinKeymapList->nNum_Keymaps = 0;
	pZhuyinKeymapList->nNum_Keymaps_Alloced = 0;
	pZhuyinKeymapList->pKeymaps = NULL;

	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Alloc(TZhuyinKeymapList *pZhuyinKeymapList, int nNum_Alloced)
{
	int i;

	pZhuyinKeymapList->nNum_Keymaps_Alloced = 0;
	pZhuyinKeymapList->pKeymaps = (PZhuyinKeymap*)malloc(nNum_Alloced*sizeof(PZhuyinKeymap));
	if (pZhuyinKeymapList->pKeymaps == NULL) {
		return(ZHUYIN_KEYMAP_ERROR);
	}

	for (i=0; i<nNum_Alloced; i++)
		pZhuyinKeymapList->pKeymaps[i] = NULL;

	pZhuyinKeymapList->nNum_Keymaps_Alloced = nNum_Alloced;

	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_ReAlloc(TZhuyinKeymapList *pZhuyinKeymapList, int nNum_ReAlloced)
{
	int i;

	pZhuyinKeymapList->pKeymaps = (PZhuyinKeymap*)realloc(pZhuyinKeymapList->pKeymaps,
					nNum_ReAlloced * sizeof(PZhuyinKeymap));
	if (pZhuyinKeymapList->pKeymaps == NULL) {
		pZhuyinKeymapList->nNum_Keymaps = 0;
		pZhuyinKeymapList->nNum_Keymaps_Alloced = 0;
		return(ZHUYIN_KEYMAP_ERROR);
	}

	for (i=pZhuyinKeymapList->nNum_Keymaps_Alloced; i<nNum_ReAlloced; i++)
		pZhuyinKeymapList->pKeymaps[i] = NULL;

	pZhuyinKeymapList->nNum_Keymaps_Alloced = nNum_ReAlloced;

	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Print(TZhuyinKeymapList *pZhuyinKeymapList)
{
	int nKeymap_ID, idx, key;

	printf("nNum_Keymaps: %d\n", pZhuyinKeymapList->nNum_Keymaps);
	for(nKeymap_ID = 0; nKeymap_ID < pZhuyinKeymapList->nNum_Keymaps; nKeymap_ID ++) {
		if (pZhuyinKeymapList->pKeymaps[nKeymap_ID] == NULL) {
			return(ZHUYIN_KEYMAP_ERROR);
		}

		if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName == NULL) {
			return(ZHUYIN_KEYMAP_ERROR);
		}

		if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap == NULL) {
			return(ZHUYIN_KEYMAP_ERROR);
		}

		printf("Name: %s\n", pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName);

		printf("Keymap: \n");
		for (idx = 1; idx <= NUM_OF_ZHUYIN_SYMBOL; idx++) {
			key = pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap[idx];
			if (key != 0) {
				printf("%s:  %c  0x%x\n", (char *)ZhuyinIndexToZhuyinSymbol(idx), key, key);
			}
		}
	}

	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Item_Prepare(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID)
{
	int ret;

	if (nKeymap_ID < 0 || nKeymap_ID >= pZhuyinKeymapList->nNum_Keymaps_Alloced + NUM_KEYMAPS_ALLOC)
		return(ZHUYIN_KEYMAP_ERROR);

	if (pZhuyinKeymapList->nNum_Keymaps_Alloced == 0) {
		ret = ZhuyinKeymapList_Alloc(pZhuyinKeymapList, NUM_KEYMAPS_ALLOC);
		if (ret == ZHUYIN_KEYMAP_ERROR)
			return(ZHUYIN_KEYMAP_ERROR);
	}

	if (nKeymap_ID >= pZhuyinKeymapList->nNum_Keymaps_Alloced) {
		int nNum_Alloc = pZhuyinKeymapList->nNum_Keymaps_Alloced + NUM_KEYMAPS_ALLOC;
		ret = ZhuyinKeymapList_ReAlloc(pZhuyinKeymapList, nNum_Alloc);
		if (ret == ZHUYIN_KEYMAP_ERROR)
			return(ZHUYIN_KEYMAP_ERROR);
	}

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID] == NULL) {
		pZhuyinKeymapList->pKeymaps[nKeymap_ID] = (TZhuyinKeymap *)calloc(1, sizeof(TZhuyinKeymap));
		if (pZhuyinKeymapList->pKeymaps[nKeymap_ID] == NULL)
			return(ZHUYIN_KEYMAP_ERROR);
	}

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName != NULL) {
		free((char *)pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName);
		pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName = NULL;
	}

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap != NULL) {
		free((char *)pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap);
		pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap = NULL;
	}
		
	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Item_Set_Name(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID, unsigned char *pName)
{
	if (!pName || !*pName) 
		return(ZHUYIN_KEYMAP_ERROR);

	if (nKeymap_ID < 0 || nKeymap_ID >= pZhuyinKeymapList->nNum_Keymaps_Alloced)
		return(ZHUYIN_KEYMAP_ERROR);

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID] == NULL) {
		return(ZHUYIN_KEYMAP_ERROR);
	}

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName != NULL) {
		free((char *)pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName);
	}

	pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName = (unsigned char *)strdup(pName);
	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName == NULL)
		return(ZHUYIN_KEYMAP_ERROR);

	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Item_Set_KeymapValue(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID, unsigned char *pZhuyinSymbol, char key)
{
	int idx;

	if (!pZhuyinSymbol || !*pZhuyinSymbol)
		return(ZHUYIN_KEYMAP_ERROR);

	if (nKeymap_ID < 0 || nKeymap_ID >= pZhuyinKeymapList->nNum_Keymaps_Alloced)
		return(ZHUYIN_KEYMAP_ERROR);

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID] == NULL) {
		return(ZHUYIN_KEYMAP_ERROR);
	}

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap == NULL) {
		pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap = (char *)calloc(NUM_OF_ZHUYIN_SYMBOL + 2, sizeof(char));
		if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap == NULL)
			return(ZHUYIN_KEYMAP_ERROR);
	}
		
	idx = ZhuyinSymbolToZhuyinIndex(pZhuyinSymbol);
	if (idx == 0) return(ZHUYIN_KEYMAP_OK);

	pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap[idx] = tolower(key);
	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Item_Add_StandardKeymap(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID)
{
	int idx;
	char key;

	if (nKeymap_ID < 0 || nKeymap_ID >= pZhuyinKeymapList->nNum_Keymaps_Alloced)
		return(ZHUYIN_KEYMAP_ERROR);

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID] == NULL) {
		return(ZHUYIN_KEYMAP_ERROR);
	}

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName != NULL) {
		free((char *)pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName);
	}

	pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName = (unsigned char *)strdup(NAME_STANDARD_ZHUYIN_KEYMAP);
	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pName == NULL)
		return(ZHUYIN_KEYMAP_ERROR);

	if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap == NULL) {
		pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap = (char *)calloc(NUM_OF_ZHUYIN_SYMBOL + 2, sizeof(char));
		if (pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap == NULL)
			return(ZHUYIN_KEYMAP_ERROR);
	}
		
	for (idx = 1; idx <= NUM_OF_ZHUYIN_SYMBOL; idx++) {
		pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap[idx] = ZhuyinIndexToStandardKey(idx);
	}
	return(ZHUYIN_KEYMAP_OK);
}

int ZhuyinKeymapList_Item_KeyToIndex(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID, int key)
{
	int idx;
	char *pKeymap;

	if (nKeymap_ID < 0 || nKeymap_ID >= pZhuyinKeymapList->nNum_Keymaps)
		return(0);

	pKeymap = pZhuyinKeymapList->pKeymaps[nKeymap_ID]->pKeymap;
	if (pKeymap == NULL)
		return(0);

	key = tolower(key);
	for (idx = 1; idx <= NUM_OF_ZHUYIN_SYMBOL; idx++) {
		if (key == pKeymap[idx]) {
			return(idx);
		}
	}
	return(0);
}

unsigned char *ZhuyinKeymapList_Item_KeyToSymbol(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID, int key)
{
	int idx = ZhuyinKeymapList_Item_KeyToIndex(pZhuyinKeymapList, nKeymap_ID, key);
	return((unsigned char *)ZhuyinIndexToZhuyinSymbol(idx));
}

int ZhuyinKeymapList_Item_KeyToType(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID, int key)
{
	int idx = ZhuyinKeymapList_Item_KeyToIndex(pZhuyinKeymapList, nKeymap_ID, key);
	return(ZhuyinIndexToZhuyinType(idx));
}

int ZhuyinKeymapList_Item_KeyToStandardKey(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID, int key)
{
	int idx = ZhuyinKeymapList_Item_KeyToIndex(pZhuyinKeymapList, nKeymap_ID, key);
	return(ZhuyinIndexToStandardKey(idx));
}

int ZhuyinKeymapList_Item_CheckIfValidKey(TZhuyinKeymapList *pZhuyinKeymapList, int nKeymap_ID, int key)
{
	int idx = ZhuyinKeymapList_Item_KeyToIndex(pZhuyinKeymapList, nKeymap_ID, key);
	return(idx ? 1 : 0);
}

