#ifndef HHENTRY_H
#define HHENTRY_H
#include <iconv.h>
#include "utfchar.h"

#define HASH_TABLE_NUMBER 256
#define IIIM_KO_LE_DIC "IIIM-KO-LE-DIC"

typedef struct _HH {
  unsigned char *utf_hangul;
  unsigned char *utf_hanja;
} HH;



typedef struct _HHItem {
  unsigned char *hangul;
  int n_hanja;
  unsigned char **hanja_list;
} HHItem, *HHEntry;

typedef struct _HHList {
  int n_count;
  HHEntry *list;
} HHList;

  

void
hh_free (HH *);
HH *
hh_new ();



HHEntry
hhitem_new ();
HHEntry
hhitem_new_with_data (HH *);
void
hhitem_init (HHEntry hhentry);
HHEntry
hhitem_add_hanja (HHEntry hhentry, unsigned char *utf_hanja);

void
hhlist_init (HHList *hhlist);

void
hhlist_add_hhitem (HHList *hhlist, HHEntry hhitem);

HHEntry
hhlist_add_hh (HHList *hhlist, HH *item);
HHEntry
hhlist_search_hhitem (HHList *hhlist, HH *hh);
void
hhlist_dump_content (HHList *hhlist, FILE *fp);
void
hhlist_read_from_file (FILE *fp, HHList *hhlist);

void
hhitem_read_from_file (FILE *fp, HHEntry entry_return);

int
hash (UTFCHAR *string);

HH *
process_hangul_hanja_pair (iconv_t cd, char *str_hangul, char *str_hanja);

void
hash_table_dump_content (HHList table[], int size, FILE *fp);

#endif /* HHENTRY_H */
