#include <glib.h>
#include "utfchar.h"
#include "hanjatable.h"
unsigned char *
convert_u16_to_u8 (UTFCHAR *u16str)
{
  gchar *u8str;
  int u16len = _utfchar_length (u16str) * sizeof (UTFCHAR);
  int bytes_read = 0;
  int bytes_written = 0;
  GError *gerror = NULL;
  
  u8str = g_convert ((const gchar *)u16str,
		     u16len,
		     "UTF-8", "UTF-16",
		     &bytes_read,
		     &bytes_written,
		     &gerror);
  if (gerror)
    return NULL;

  return u8str;
}
int
main (int argc, char **argv)
{
  int n_table_length;
  int i,j;
  const unsigned short *hangul;
  const unsigned short *hanja;
  unsigned short buffer[2] = { 0x0000, 0x0000};

  unsigned char *u8hangul;
  unsigned char *u8hanja;
  n_table_length = sizeof (hanjatable) / sizeof (hanjatable[0]);

  for (i = 0 ; i < n_table_length; i++){
    hangul =  hanjatable[i];
    hanja = hangul + 1;
    memset (buffer, 0, sizeof (buffer));
    memcpy (buffer, hangul, sizeof (unsigned short));
    u8hangul = convert_u16_to_u8 (buffer);

    while (*hanja){
      memset (buffer, 0, sizeof (buffer));
      memcpy (buffer, hanja, sizeof (unsigned short));
      u8hanja = convert_u16_to_u8 (buffer);
      printf ("[%s][%s]@\n",u8hangul, u8hanja );
      g_free ((gpointer) u8hanja);    
      hanja++;
    }
    
    g_free ((gpointer) u8hangul);

  }
  return 0;  
}
